/////////////////////////////////////////////////////////////////////////////
// Name:        dialog_drc.cpp
// Purpose:     
// Author:      jean-pierre Charras
// Modified by: 
// Created:     27/02/2006 20:42:00
// RCS-ID:      
// Copyright:   License GNU
// Licence:     
/////////////////////////////////////////////////////////////////////////////

// Generated by DialogBlocks (unregistered), 27/02/2006 20:42:00

#if defined(__GNUG__) && !defined(NO_GCC_PRAGMA)
#pragma implementation "dialog_drc.h"
#endif

// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include "wx/wx.h"
#endif

////@begin includes
////@end includes

#include "dialog_drc.h"

////@begin XPM images
////@end XPM images

/*!
 * WinEDA_DrcFrame type definition
 */

IMPLEMENT_DYNAMIC_CLASS( WinEDA_DrcFrame, wxDialog )

/*!
 * WinEDA_DrcFrame event table definition
 */

BEGIN_EVENT_TABLE( WinEDA_DrcFrame, wxDialog )

////@begin WinEDA_DrcFrame event table entries
    EVT_BUTTON( ID_DRC_RUN, WinEDA_DrcFrame::OnDrcRunClick )

    EVT_BUTTON( ID_STOP_CONTROL_DRC, WinEDA_DrcFrame::OnStopControlDrcClick )

    EVT_BUTTON( ID_ERASE_DRC_MARKERS, WinEDA_DrcFrame::OnEraseDrcMarkersClick )

    EVT_BUTTON( ID_LIST_UNCONNECTED_PADS, WinEDA_DrcFrame::OnListUnconnectedPadsClick )

    EVT_BUTTON( ID_BUTTON_BROWSE_RPT_FILE, WinEDA_DrcFrame::OnButtonBrowseRptFileClick )

    EVT_BUTTON( wxID_OK, WinEDA_DrcFrame::OnOkClick )

    EVT_BUTTON( wxID_CANCEL, WinEDA_DrcFrame::OnCancelClick )

////@end WinEDA_DrcFrame event table entries

END_EVENT_TABLE()

/*!
 * WinEDA_DrcFrame constructors
 */

WinEDA_DrcFrame::WinEDA_DrcFrame( )
{
}

WinEDA_DrcFrame::WinEDA_DrcFrame( WinEDA_PcbFrame* parent, wxDC * panelDC,
                                  wxWindowID id,
                                  const wxString& caption,
                                  const wxPoint& pos,
                                  const wxSize& size,
                                  long style )
{
    m_Parent = parent;
    m_DC = panelDC;
    AbortDrc = FALSE;

    Create(parent, id, caption, pos, size, style);

    PutValueInLocalUnits( *m_SetClearance, g_DesignSettings.m_TrackClearence,
                          m_Parent->m_InternalUnits );
}

/*!
 * WinEDA_DrcFrame creator
 */

bool WinEDA_DrcFrame::Create( wxWindow* parent, wxWindowID id, const wxString& caption, const wxPoint& pos, const wxSize& size, long style )
{
////@begin WinEDA_DrcFrame member initialisation
    m_MainSizer = NULL;
    m_CommandSizer = NULL;
    m_ClearenceTitle = NULL;
    m_SetClearance = NULL;
    m_Pad2PadTestCtrl = NULL;
    m_UnconnectedTestCtrl = NULL;
    m_ZonesTestCtrl = NULL;
    m_CreateRptCtrl = NULL;
    m_RptFilenameCtrl = NULL;
    m_logWindow = NULL;
    Line = NULL;
    StdDialogButtonSizer = NULL;
////@end WinEDA_DrcFrame member initialisation

////@begin WinEDA_DrcFrame creation
    SetExtraStyle(wxWS_EX_BLOCK_EVENTS);
    wxDialog::Create( parent, id, caption, pos, size, style );

    CreateControls();
    if( GetSizer() )
    {
        GetSizer()->SetSizeHints(this);
    }
    Centre();
////@end WinEDA_DrcFrame creation
    return true;
}

/*!
 * Control creation for WinEDA_DrcFrame
 */

void WinEDA_DrcFrame::CreateControls()
{    
    SetFont( *g_DialogFont );
    
////@begin WinEDA_DrcFrame content construction
    // Generated by DialogBlocks, 13/11/2007 16:40:34 (unregistered)

    WinEDA_DrcFrame* itemDialog1 = this;

    m_MainSizer = new wxBoxSizer(wxVERTICAL);
    itemDialog1->SetSizer(m_MainSizer);

    m_CommandSizer = new wxBoxSizer(wxHORIZONTAL);
    m_MainSizer->Add(m_CommandSizer, 0, wxGROW|wxALL, 5);

    wxStaticBox* itemStaticBoxSizer4Static = new wxStaticBox(itemDialog1, wxID_ANY, _("Options"));
    wxStaticBoxSizer* itemStaticBoxSizer4 = new wxStaticBoxSizer(itemStaticBoxSizer4Static, wxVERTICAL);
    m_CommandSizer->Add(itemStaticBoxSizer4, 0, wxALIGN_TOP|wxLEFT|wxTOP|wxBOTTOM, 5);

    m_ClearenceTitle = new wxStaticText( itemDialog1, wxID_STATIC, _("Clearance"), wxDefaultPosition, wxDefaultSize, 0 );
    itemStaticBoxSizer4->Add(m_ClearenceTitle, 0, wxGROW|wxLEFT|wxRIGHT|wxTOP|wxADJUST_MINSIZE, 5);

    m_SetClearance = new wxTextCtrl( itemDialog1, ID_TEXTCTRL_CLEARANCE, _T(""), wxDefaultPosition, wxDefaultSize, 0 );
    itemStaticBoxSizer4->Add(m_SetClearance, 0, wxGROW|wxLEFT|wxRIGHT|wxBOTTOM, 5);

    itemStaticBoxSizer4->Add(5, 5, 0, wxGROW|wxALL, 5);

    wxStaticBox* itemStaticBoxSizer8Static = new wxStaticBox(itemDialog1, wxID_ANY, _("Test Drc:"));
    wxStaticBoxSizer* itemStaticBoxSizer8 = new wxStaticBoxSizer(itemStaticBoxSizer8Static, wxVERTICAL);
    itemStaticBoxSizer4->Add(itemStaticBoxSizer8, 0, wxGROW|wxALL, 5);

    m_Pad2PadTestCtrl = new wxCheckBox( itemDialog1, ID_CHECKBOX_PAD2PAD, _("Include pad to pad test"), wxDefaultPosition, wxDefaultSize, 0 );
    m_Pad2PadTestCtrl->SetValue(false);
    itemStaticBoxSizer8->Add(m_Pad2PadTestCtrl, 0, wxGROW|wxALL, 5);

    m_UnconnectedTestCtrl = new wxCheckBox( itemDialog1, ID_CHECKBOX_UNCONNECTED, _("Include unconnected"), wxDefaultPosition, wxDefaultSize, 0 );
    m_UnconnectedTestCtrl->SetValue(false);
    itemStaticBoxSizer8->Add(m_UnconnectedTestCtrl, 0, wxGROW|wxALL, 5);

    m_ZonesTestCtrl = new wxCheckBox( itemDialog1, ID_CHECKBOX_TEST_ZONES, _("Include zones"), wxDefaultPosition, wxDefaultSize, 0 );
    m_ZonesTestCtrl->SetValue(false);
    itemStaticBoxSizer8->Add(m_ZonesTestCtrl, 0, wxGROW|wxALL, 5);

    m_CreateRptCtrl = new wxCheckBox( itemDialog1, ID_CHECKBOX_CREATE_FILE, _("Create Report file"), wxDefaultPosition, wxDefaultSize, 0 );
    m_CreateRptCtrl->SetValue(false);
    itemStaticBoxSizer8->Add(m_CreateRptCtrl, 0, wxGROW|wxALL, 5);

    m_CommandSizer->Add(5, 5, 1, wxALIGN_CENTER_VERTICAL|wxLEFT|wxTOP|wxBOTTOM, 5);

    wxBoxSizer* itemBoxSizer14 = new wxBoxSizer(wxVERTICAL);
    m_CommandSizer->Add(itemBoxSizer14, 0, wxALIGN_CENTER_VERTICAL|wxTOP|wxBOTTOM, 5);

    wxBoxSizer* itemBoxSizer15 = new wxBoxSizer(wxHORIZONTAL);
    itemBoxSizer14->Add(itemBoxSizer15, 0, wxALIGN_CENTER_HORIZONTAL|wxRIGHT|wxTOP, 5);

    wxBoxSizer* itemBoxSizer16 = new wxBoxSizer(wxVERTICAL);
    itemBoxSizer15->Add(itemBoxSizer16, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5);

    wxButton* itemButton17 = new wxButton( itemDialog1, ID_DRC_RUN, _("Test Drc"), wxDefaultPosition, wxDefaultSize, 0 );
    itemButton17->SetForegroundColour(wxColour(202, 0, 0));
    itemBoxSizer16->Add(itemButton17, 0, wxGROW|wxALL, 5);

    wxButton* itemButton18 = new wxButton( itemDialog1, ID_STOP_CONTROL_DRC, _("Stop Drc"), wxDefaultPosition, wxDefaultSize, 0 );
    itemButton18->SetForegroundColour(wxColour(0, 128, 128));
    itemBoxSizer16->Add(itemButton18, 0, wxGROW|wxALL, 5);

    wxBoxSizer* itemBoxSizer19 = new wxBoxSizer(wxVERTICAL);
    itemBoxSizer15->Add(itemBoxSizer19, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5);

    wxButton* itemButton20 = new wxButton( itemDialog1, ID_ERASE_DRC_MARKERS, _("Del Markers"), wxDefaultPosition, wxDefaultSize, 0 );
    itemButton20->SetForegroundColour(wxColour(0, 128, 0));
    itemBoxSizer19->Add(itemButton20, 0, wxGROW|wxALL, 5);

    wxButton* itemButton21 = new wxButton( itemDialog1, ID_LIST_UNCONNECTED_PADS, _("List Unconn"), wxDefaultPosition, wxDefaultSize, 0 );
    itemButton21->SetForegroundColour(wxColour(0, 0, 255));
    itemBoxSizer19->Add(itemButton21, 0, wxGROW|wxALL, 5);

    wxStaticBox* itemStaticBoxSizer22Static = new wxStaticBox(itemDialog1, wxID_ANY, _("Report File"));
    wxStaticBoxSizer* itemStaticBoxSizer22 = new wxStaticBoxSizer(itemStaticBoxSizer22Static, wxVERTICAL);
    itemBoxSizer14->Add(itemStaticBoxSizer22, 0, wxGROW|wxLEFT|wxRIGHT|wxTOP, 5);

    wxButton* itemButton23 = new wxButton( itemDialog1, ID_BUTTON_BROWSE_RPT_FILE, _("Browse"), wxDefaultPosition, wxDefaultSize, 0 );
    itemButton23->SetForegroundColour(wxColour(0, 128, 128));
    itemStaticBoxSizer22->Add(itemButton23, 0, wxALIGN_LEFT|wxALL, 5);

    m_RptFilenameCtrl = new wxTextCtrl( itemDialog1, ID_TEXTCTRL_GET_RPT_FILENAME, _T(""), wxDefaultPosition, wxDefaultSize, 0 );
    itemStaticBoxSizer22->Add(m_RptFilenameCtrl, 0, wxGROW|wxALL, 5);

    wxStaticText* itemStaticText25 = new wxStaticText( itemDialog1, wxID_STATIC, _("Messages:"), wxDefaultPosition, wxDefaultSize, 0 );
    m_MainSizer->Add(itemStaticText25, 0, wxGROW|wxLEFT|wxRIGHT|wxADJUST_MINSIZE, 10);

    m_logWindow = new wxTextCtrl( itemDialog1, ID_TEXTCTRL, _T(""), wxDefaultPosition, wxSize(-1, 300), wxTE_MULTILINE|wxTE_READONLY|wxHSCROLL|wxFULL_REPAINT_ON_RESIZE );
    m_MainSizer->Add(m_logWindow, 1, wxGROW|wxLEFT|wxRIGHT|wxBOTTOM, 10);

    Line = new wxStaticLine( itemDialog1, ID_STATICLINE, wxDefaultPosition, wxDefaultSize, wxLI_HORIZONTAL );
    m_MainSizer->Add(Line, 0, wxGROW|wxLEFT|wxRIGHT, 5);

    StdDialogButtonSizer = new wxStdDialogButtonSizer;

    m_MainSizer->Add(StdDialogButtonSizer, 0, wxGROW|wxALL, 10);
    wxButton* itemButton29 = new wxButton( itemDialog1, wxID_OK, _("&OK"), wxDefaultPosition, wxDefaultSize, 0 );
    itemButton29->SetForegroundColour(wxColour(200, 0, 0));
    StdDialogButtonSizer->AddButton(itemButton29);

    wxButton* itemButton30 = new wxButton( itemDialog1, wxID_CANCEL, _("&Cancel"), wxDefaultPosition, wxDefaultSize, 0 );
    itemButton30->SetForegroundColour(wxColour(0, 0, 255));
    StdDialogButtonSizer->AddButton(itemButton30);

    StdDialogButtonSizer->Realize();

    // Set validators
    m_Pad2PadTestCtrl->SetValidator( wxGenericValidator(& s_Pad2PadTestOpt) );
    m_UnconnectedTestCtrl->SetValidator( wxGenericValidator(& s_UnconnectedTestOpt) );
    m_ZonesTestCtrl->SetValidator( wxGenericValidator(& s_ZonesTestOpt) );
    m_CreateRptCtrl->SetValidator( wxGenericValidator(& s_CreateRptFileOpt) );
////@end WinEDA_DrcFrame content construction

    AddUnitSymbol(*m_ClearenceTitle);
    m_RptFilenameCtrl->SetValue(s_RptFilename);


    // capture the text control's events, all of them.
//  m_logWindow->PushEventHandler( this );    
}

/*!
 * Should we show tooltips?
 */

bool WinEDA_DrcFrame::ShowToolTips()
{
    return true;
}

/*!
 * Get bitmap resources
 */

wxBitmap WinEDA_DrcFrame::GetBitmapResource( const wxString& name )
{
    // Bitmap retrieval
////@begin WinEDA_DrcFrame bitmap retrieval
    wxUnusedVar(name);
    return wxNullBitmap;
////@end WinEDA_DrcFrame bitmap retrieval
}

/*!
 * Get icon resources
 */

wxIcon WinEDA_DrcFrame::GetIconResource( const wxString& name )
{
    // Icon retrieval
////@begin WinEDA_DrcFrame icon retrieval
    wxUnusedVar(name);
    return wxNullIcon;
////@end WinEDA_DrcFrame icon retrieval
}
/*!
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_DRC_RUN
 */

void WinEDA_DrcFrame::OnDrcRunClick( wxCommandEvent& event )
{
    TestDrc(event);
}

/*!
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_STOP_CONTROL_DRC
 */

void WinEDA_DrcFrame::OnStopControlDrcClick( wxCommandEvent& event )
{
    if( DrcInProgress )
        AbortDrc = TRUE;
    else
        wxBell();
}

/*!
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_ERASE_DRC_MARKERS
 */

void WinEDA_DrcFrame::OnEraseDrcMarkersClick( wxCommandEvent& event )
{
    DelDRCMarkers(event);
}

/*!
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_LIST_UNCONNECTED_PADS
 */

void WinEDA_DrcFrame::OnListUnconnectedPadsClick( wxCommandEvent& event )
{
    ListUnconnectedPads(event);
}

/*!
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON_BROWSE_RPT_FILE
 */

void WinEDA_DrcFrame::OnButtonBrowseRptFileClick( wxCommandEvent& event )
{
wxString FileName, Mask(wxT("*")), Ext(wxT(".rpt"));

    FileName = m_Parent->m_CurrentScreen->m_FileName;
    ChangeFileNameExt(FileName, wxT("-drc") + Ext);
    Mask += Ext;

    FileName = EDA_FileSelector( _("DRC Report file"),
                                 wxEmptyString,     /* Chemin par defaut */
                                 FileName,          /* nom fichier par defaut */
                                 Ext,               /* extension par defaut */
                                 Mask,              /* Masque d'affichage */
                                 this,
                                 wxFD_SAVE,
                                 TRUE
                                 );
    if( FileName.IsEmpty() )
        return;

    m_RptFilenameCtrl->SetValue(FileName);
    s_RptFilename = FileName;
}


/*!
 * Override the event handler so we can direct the m_lowWindows events here initially
 */

bool WinEDA_DrcFrame::ProcessEvent( wxEvent& event )
{
    int id = event.GetId();
    
    if( id == ID_TEXTCTRL ) 
    {
        
//printf("ID_TEXTCTRL\n");

        // this does not work yet 

        if( event.GetEventType() == wxMOUSE_BTN_LEFT )
        {
            wxMouseEvent& mouseEvent = (wxMouseEvent&) event;
               
            if( mouseEvent.LeftUp() )
            {
                wxTextCoord col;
                wxTextCoord row;
                
                wxPoint pos = mouseEvent.GetPosition();
                
                if( wxTE_HT_UNKNOWN != m_logWindow->HitTest( pos, &col, &row ) )
                {
                    wxString text = m_logWindow->GetLineText( row );
                }
            }
        }

        return false;
    }

    else
    {
        bool ret; 
//        printf("ProcessEvent(%d)\n", id);
        ret = static_cast<wxDialog*>(this)->wxDialog::ProcessEvent( event );
//        printf("~ProcessEvent\n");
        return ret;
    }
}


/*!
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for wxID_OK
 */

void WinEDA_DrcFrame::OnOkClick( wxCommandEvent& event )
{
    s_Pad2PadTestOpt = m_Pad2PadTestCtrl->IsChecked();
    s_UnconnectedTestOpt = m_UnconnectedTestCtrl->IsChecked();
    s_ZonesTestOpt = m_ZonesTestCtrl->IsChecked();
    s_CreateRptFileOpt = m_CreateRptCtrl->IsChecked();
    event.Skip();
}


/*!
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for wxID_CANCEL
 */

void WinEDA_DrcFrame::OnCancelClick( wxCommandEvent& event )
{
////@begin wxEVT_COMMAND_BUTTON_CLICKED event handler for wxID_CANCEL in WinEDA_DrcFrame.
    // Before editing this code, remove the block markers.
    event.Skip();
////@end wxEVT_COMMAND_BUTTON_CLICKED event handler for wxID_CANCEL in WinEDA_DrcFrame. 
}
