/***************************************************************************
 *   Copyright (C) 2004 by Emil Stoyanov                                   *
 *   emosto@users.sourceforge.net                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "kiaxaccountwizard.h"

KiaxAccountWizard::KiaxAccountWizard(QWidget* parent, const char* name, bool modal, WFlags fl)
: AccountWizardUI(parent,name, modal,fl)
{
    loadPresets();
    init();
    helpButton()->hide();
}

void KiaxAccountWizard::init() {
    accountNameEdit->clear();
    networkNameComboBox->clear();
    for (int i=0;i<getPresets().count();i++) {
      networkNameComboBox->insertItem(getPresets().at(i)->operatorName);
    }
    selectedPreset = 0;
    networkNameComboBox->setCurrentItem(selectedPreset);
    networkInfo->setText(getPresets().at(selectedPreset)->instructions);
    usernameEdit->clear();
    passwordEdit->clear();
    callerIdNameEdit->clear();
    callerIdNumberEdit->clear();
    setNextEnabled(page(0), false);
    setNextEnabled(page(2), false);
    setNextEnabled(page(3), false);
    setFinishEnabled(page(4), true);
    finishButton()->setEnabled(true);
    setBackEnabled(page(4), false);
    setHelpEnabled(page(0), false);
    setHelpEnabled(page(1), false);
    setHelpEnabled(page(2), false);
    setHelpEnabled(page(3), false);
    setHelpEnabled(page(4), false);
    showPage(page(0));
}

KiaxAccountWizard::~KiaxAccountWizard()
{
}

/*$SPECIALIZATION$*/
void KiaxAccountWizard::back()
{
  QWizard::back();
  cancelButton()->setEnabled(true);
}

void KiaxAccountWizard::next()
{
  QWizard::next();
  if (indexOf(currentPage())==4) {
    cancelButton()->setEnabled(false);
    createAccountFromPreset(selectedPreset);
  }
}

void KiaxAccountWizard::accountNameEdit_textChanged(const QString& text) {
    if (text.length()>0)
     setNextEnabled(page(0), true);
    else setNextEnabled(page(0), false);
}

void KiaxAccountWizard::callerIdNumberEdit_textChanged(const QString& text) {
    if ((text.length()>0)&&(callerIdNameEdit->text().length()>0))
     setNextEnabled(page(3), true);
    else setNextEnabled(page(3), false);
}

void KiaxAccountWizard::callerIdNameEdit_textChanged(const QString& text) {
    if ((text.length()>0)&&(callerIdNumberEdit->text().length()>0))
     setNextEnabled(page(3), true);
    else setNextEnabled(page(3), false);
}

void KiaxAccountWizard::passwordEdit_textChanged(const QString& text) {
    if ((text.length()>0)&&(usernameEdit->text().length()>0))
     setNextEnabled(page(2), true);
    else setNextEnabled(page(2), false);
}

void KiaxAccountWizard::usernameEdit_textChanged(const QString& text) {
    if ((text.length()>0)&&(passwordEdit->text().length()>0))
     setNextEnabled(page(2), true);
    else setNextEnabled(page(2), false);
}

void KiaxAccountWizard::networkNameComboBox_activated(int item) {
  networkInfo->setText(getPresets().at(networkNameComboBox->currentItem())->instructions);
  selectedPreset = item;
}

void KiaxAccountWizard::loadPresets() {
  
  /* This method should load VoIP presets for different VoIP providers 
     The aim is to enable Kiax to load presets from different sources.
     However as a beginning we include only FWD and VoipGATE. In the
     future we'll enable presets loading from internet.
  */
  KiaxPreset* fwdPreset = new KiaxPreset();
  fwdPreset->echoTestNumber = "613";
  fwdPreset->iaxServer = "iax2.fwdnet.net";
  fwdPreset->operatorHomePage = "http://www.freeworlddialup.com";
  fwdPreset->operatorName = "FWD (Free World Dialup)";
  fwdPreset->registerPageURL = "http://www.freeworlddialup.com";
  fwdPreset->preferredCodec = "ulaw";
  fwdPreset->userLoginPage = "http://www.freeworlddialup.com";
  fwdPreset->instructions = "<font color=\"#00007f\">Free World Dialup is one of the first open and free VoIP networks. It is grounded and supported by Pulver Inc. The network provides VoIP connectivity to a great number of users through SIP and IAX protocols. In order to be able to use FWD with Kiax you have to activate IAX support in Advanced/IAX section of your profile. Please press button \"Get Account\" to go directly to the registration page.</font>";
  
  
  KiaxPreset* voipgatePreset = new KiaxPreset();
  voipgatePreset->echoTestNumber = "35227273098";
  voipgatePreset->iaxServer = "register.voipgate.com";
  voipgatePreset->operatorHomePage = "http://www.voipgate.com";
  voipgatePreset->operatorName = "VoipGATE";
  voipgatePreset->registerPageURL = "https://www.voipgate.com/register.php?afflink=kiax";
  voipgatePreset->preferredCodec = "ilbc";
  voipgatePreset->userLoginPage = "https://www.voipgate.com/login.php";
  voipgatePreset->instructions = "<font color=\"#00007f\">VoipGATE is a VoIP service provider based in Luxemburg. It provides quality communication services for end-users and business customers on reasonable and low prices. PC-to-PC VoIP communication is free! </font>";
  
  presets.insert(0,fwdPreset);
  presets.insert(1,voipgatePreset);

}

QPtrList<KiaxPreset> KiaxAccountWizard::getPresets() {
  return presets;
}

void KiaxAccountWizard::homePageButton_pressed() {
}

void KiaxAccountWizard::registerButton_pressed() {
}

void KiaxAccountWizard::createAccountFromPreset(int presetNumber) {
  KiaxAccount* account = new KiaxAccount(NULL);
  account->accAlias = accountNameEdit->text();
  account->callerId = callerIdNameEdit->text();
  account->callerIdNumber = callerIdNumberEdit->text();
  account->codec = getPresets().at(presetNumber)->preferredCodec;
  account->iaxServer = getPresets().at(presetNumber)->iaxServer;
  account->username = usernameEdit->text();
  account->password = passwordEdit->text();
  account->save();
  delete account;
  emit accountCreated();
}
