/***************************************************************************
                          perpendicular.cpp  -  description
                             -------------------
    begin                : Sat Aug 4 2001
    copyright            : (C) 2001 by Marc Bartsch
    email                : marc.bartsch@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "perpendicular.h"

Perpendicular::Perpendicular(): GeoLine()
{
	ID = ID_perpendicular;
  identificator = "Perpendicular";

	startCoords.goBeyond = true;
	endCoords.goBeyond = true;

	int temp[] = { ID_geoPoint, 1, ID_geoLine, 1, -1 };

	convertParams( temp, sizeof( temp ) / sizeof( temp[0] ) );
}

Perpendicular::~Perpendicular()
{
}

void Perpendicular::move()
{
	int indexLine = 0;
	int indexGeoPoint = 1;

	if (	isGeoLine( parents.at( 1 ) ) )
	{
		indexLine = 1;
		indexGeoPoint = 0;
	}

 	Coordinates coord1, coord2;
 	coord1 = parents.at( indexLine )->getStartCoordinates();
 	coord2 = parents.at( indexLine )->getEndCoordinates();
 	coord1 -= coord2;
 	coord1.orthogonalize();

 	startCoords.coords = parents.at( indexGeoPoint )->getCoordinates();
 	endCoords.coords = startCoords.coords + coord1;

	computeGoBeyond();
}
