/***************************************************************************
                          colorlabel.h  -  description
                             -------------------
    begin                : Tue Sep 25 2001
    copyright            : (C) 2001 by Marc Bartsch
    email                : marc.bartsch@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef COLORLABEL_H
#define COLORLABEL_H

#include <qwidget.h>
#include <qcolor.h>
#include <qevent.h>
#include <qrect.h>
#include <qpainter.h>
#include <kcolordialog.h>

/**
  *@author Marc Bartsch
  */

class ColorLabel : public QWidget
{
   	Q_OBJECT

	public:

		ColorLabel( QColor foregroundColor, QColor backgroundColor, QWidget *parent=0, const char *name=0 );
		~ColorLabel();

		void		setDrawColor( QColor pdrawColor ){ drawColor = pdrawColor; repaint(); };
		void		setBackgroundColor( QColor pbackgroundColor ){ backgroundColor = pbackgroundColor; repaint(); };

  protected:

    virtual void mouseDoubleClickEvent( QMouseEvent * );
		virtual void paintEvent( QPaintEvent * );

		QRect 	foreground;
		QRect 	background;
		QColor	drawColor;
		QColor	backgroundColor;

	signals:

		void backgroundColorChanged( QColor color );
		void drawColorChanged( QColor color );

};

#endif
