/***************************************************************************
                          attacher.cpp  -  description
                             -------------------
    begin                : Mon Mar 20 2000
    copyright            : (C) 2000 by Marc Bartsch
    email                : marc.bartsch@topmail.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "attacher.h"

Attacher::Attacher(): GeoTool()
{
	ID = ID_attacher;
  identificator = "Attacher";

	int temp[] = { ID_point, 1, ID_geoLine, 1, -1, ID_point, 1, ID_circle, 1, -1,
								 ID_point, 1, ID_fixedCircle, 1, -1,
								 ID_pointOnLine, 1, ID_geoLine, 1, -1, ID_pointOnLine, 1, ID_circle, 1, -1,
								 ID_pointOnLine, 1, ID_fixedCircle, 1, -1  };

	convertParams( temp, sizeof( temp ) / sizeof( temp[0] ) );
}

Attacher::~Attacher()
{
}

void Attacher::processObjects()
{
	GeoObjects *point;
	GeoObjects *line;

	//	Insert point first and then segment
	if ( ( strcmp( parents.first()->identify(), QString( "Point" ) ) == 0 ) ||
		   ( strcmp( parents.first()->identify(), QString( "PointOnLine" ) ) == 0 ) )
	{
		point = parents.first();
		line  = parents.next();
 	}
	else
	{
		line  = parents.first();
		point = parents.next();
	}

 	//	Delete point in children of parents
 	GeoObjects *actual;
 	for ( actual = point->parents.first(); actual; actual = point->parents.next() )
 	{
 		actual->children.removeRef( point );	
 	}

 	point->parents.clear();
 	point->parents.append( line );
 	line->children.append( point );
	point->setInitComplete( false );
	point->move();
}
