/*-
 * vkbd_var.h
 *
 * Copyright (c) 2004 Maksim Yevmenkin <m_evmenkin@yahoo.com>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: vkbd_var.h,v 1.4 2004/08/17 17:43:14 max Exp $
 * $FreeBSD: src/sys/dev/vkbd/vkbd_var.h,v 1.2 2005/01/06 01:43:32 imp Exp $
 */

#ifndef _VKBD_VAR_H_
#define _VKBD_VAR_H_

#define	VKBD_Q_SIZE	64	/* vkbd input queue size */

struct vkbd_status
{
	int	mode;		/* keyboard mode */
	int	leds;		/* keyboard LEDs */
	int	lock;		/* keyboard lock key state */
	int	delay;		/* keyboard delay */
	int	rate;		/* keyboard rate */
	int	reserved[3];
};

typedef struct vkbd_status	vkbd_status_t;
typedef struct vkbd_status *	vkbd_status_p;

#endif /* ndef _VKBD_VAR_H_ */

