/*
 * Copyright (c) 2004-05 Applied Micro Circuits Corporation.
 * Copyright (c) 2004-05 Vinod Kashyap
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	$FreeBSD: src/sys/dev/twa/tw_cl_fwimg.c,v 1.1.2.1 2005/05/04 19:26:28 vkashyap Exp $
 */

/*
 * AMCC'S 3ware driver for 9000 series storage controllers.
 *
 * Author: Vinod Kashyap
 */


#include "tw_osl_share.h"
#include "tw_cl_share.h"

#ifdef TW_OSL_FLASH_FIRMWARE

TW_INT8  tw_cli_fw_img[] = {
2,0,136,1,44,42,8,0,174,106,27,158,5,0,0,0,2,0,6,0,
4,0,9,0,28,0,24,0,175,236,221,186,48,50,47,50,54,47,48,53,
49,49,58,50,53,58,53,51,70,69,57,88,32,50,46,48,54,46,48,48,
46,48,48,57,13,9,9,9,9,9,9,9,9,9,9,13,10,65,77,67,
67,32,51,119,97,114,101,32,70,105,114,109,119,97,114,101,32,73,109,97,
103,101,32,40,67,41,32,50,48,48,51,45,50,48,48,52,32,65,77,67,
67,13,10,66,117,105,108,116,32,98,121,32,70,108,97,115,104,73,109,97,
103,101,67,111,109,112,111,115,101,114,32,49,46,48,53,32,111,110,32,83,
97,116,32,70,101,98,32,50,54,32,49,49,58,51,48,58,53,51,32,50,
48,48,53,10,13,10,66,117,105,108,100,32,68,101,116,97,105,108,115,58,
13,10,68,97,116,101,32,32,32,32,61,32,48,50,47,50,54,47,48,53,
13,10,84,105,109,101,32,32,32,32,61,32,49,49,58,50,53,58,53,51,
13,10,86,101,114,115,105,111,110,32,61,32,70,69,57,88,32,50,46,48,
54,46,48,48,46,48,48,57,13,10,83,82,76,32,32,32,32,32,61,32,
50,52,45,50,56,13,10,66,117,105,108,100,32,32,32,61,32,57,13,10,
66,114,97,110,99,104,32,32,61,32,52,13,10,10,67,111,109,112,111,110,
101,110,116,32,86,101,114,115,105,111,110,115,58,13,10,70,69,57,88,32,
50,46,48,54,46,48,48,46,48,48,57,13,10,66,69,57,88,32,50,46,
48,51,46,48,49,46,48,53,49,13,10,66,66,85,58,32,49,46,48,52,
46,48,48,46,48,50,50,13,10,26,0,0,3,30,200,255,99,39,53,0,
99,167,49,0,99,175,45,0,99,183,41,0,99,191,37,0,99,199,33,0,
99,207,29,0,99,215,25,0,99,255,21,0,99,223,17,0,99,231,13,0,
99,239,9,0,128,255,22,0,0,0,0,0,70,108,97,115,104,32,85,112,
100,97,116,101,114,0,128,255,4,0,31,232,93,38,1,0,36,38,138,84,
4,38,0,64,4,38,0,64,93,54,0,0,38,54,234,255,102,31,1,0,
93,30,1,0,35,30,134,84,93,54,0,0,38,54,142,0,28,10,64,14,
128,0,1,14,216,52,162,5,1,240,93,86,0,0,42,86,70,49,234,167,
32,0,128,255,104,0,93,54,0,0,38,54,234,255,38,31,1,0,35,255,
21,0,35,239,9,0,35,231,13,0,35,223,17,0,35,215,25,0,35,207,
29,0,35,199,33,0,35,191,37,0,35,183,41,0,35,175,45,0,35,167,
49,0,35,39,53,0,3,30,56,0,127,0,1,0,0,0,0,0,0,0,
216,52,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,20,0,138,7,225,243,128,239,4,0,93,78,0,0,41,78,
138,47,93,214,0,0,58,214,46,43,93,206,0,0,57,206,162,43,93,190,
0,0,55,190,146,50,0,226,26,176,99,79,1,0,38,143,1,0,97,138,
234,29,6,134,4,0,48,63,1,0,6,126,8,0,47,255,1,0,6,118,
12,0,46,223,1,0,6,110,16,0,45,71,1,0,6,102,20,0,44,199,
1,0,6,94,24,0,43,23,1,0,6,86,28,0,42,143,1,0,245,13,
38,63,1,0,6,142,4,0,49,255,1,0,6,134,8,0,48,223,1,0,
0,194,0,66,0,138,0,18,241,17,178,53,2,128,168,129,99,7,5,0,
35,118,4,0,14,126,4,0,111,7,1,0,35,102,4,0,12,110,8,0,
109,7,1,0,35,86,4,0,10,94,12,0,107,7,1,0,226,185,177,5,
247,137,187,5,16,224,128,225,226,177,177,5,246,137,251,5,16,80,218,81,
10,208,16,80,217,81,10,200,35,151,1,0,242,17,251,45,35,159,1,0,
241,153,185,45,248,65,146,45,176,73,245,37,99,7,5,0,35,134,4,0,
16,142,4,0,93,118,128,255,46,118,250,254,14,120,167,121,113,127,1,0,
35,102,4,0,12,110,8,0,68,86,254,255,42,86,0,96,10,88,191,89,
109,95,1,0,35,134,4,0,16,142,12,0,68,118,126,255,46,118,40,43,
14,120,187,121,113,127,1,0,93,110,0,0,45,110,146,50,28,216,205,217,
93,102,0,0,44,102,170,50,28,192,204,193,181,29,68,218,27,94,252,255,
35,142,4,0,17,86,12,0,42,23,1,0,43,135,1,0,208,17,59,87,
1,0,68,218,59,95,1,0,68,218,2,48,10,56,11,64,93,254,0,0,
63,254,136,1,122,0,248,217,218,229,93,126,0,0,47,126,170,50,28,216,
207,217,93,118,0,0,46,118,170,50,28,208,206,209,93,110,0,0,45,110,
170,50,28,192,205,193,181,45,250,217,137,13,35,94,4,0,11,102,12,0,
44,23,1,0,245,5,35,142,4,0,17,86,4,0,42,23,1,0,59,135,
1,0,208,17,68,218,68,218,27,126,252,255,35,110,4,0,13,118,4,0,
46,87,1,0,47,103,1,0,204,81,59,95,1,0,68,218,2,48,10,56,
11,64,93,254,0,0,63,254,6,2,121,0,248,217,218,213,93,198,0,0,
56,198,92,42,93,94,0,0,43,94,170,50,28,216,203,217,93,86,0,0,
42,86,170,50,28,208,202,209,93,142,0,0,49,142,170,50,28,200,209,201,
181,45,250,217,137,13,35,126,4,0,15,134,12,0,48,23,1,0,245,5,
35,110,4,0,13,118,4,0,46,23,1,0,59,103,1,0,204,17,68,218,
68,218,27,94,252,255,35,142,4,0,17,86,4,0,42,87,1,0,43,135,
1,0,208,81,59,95,1,0,68,218,2,48,10,56,11,64,93,254,0,0,
63,254,140,2,120,0,249,217,218,213,93,126,0,0,47,126,170,50,28,16,
207,17,93,118,0,0,46,118,150,51,28,64,206,65,93,110,0,0,45,110,
150,51,28,56,205,57,226,65,162,77,35,94,4,0,11,102,12,0,68,142,
126,255,49,142,40,43,44,135,1,0,17,80,176,81,170,65,197,61,65,58,
7,126,255,255,15,55,0,0,198,118,48,0,14,104,164,106,13,88,194,90,
11,96,35,142,4,0,12,80,209,81,42,87,1,0,68,18,2,134,252,255,
48,127,1,0,10,248,207,249,63,79,1,0,198,118,128,0,224,113,178,5,
224,73,178,29,198,110,3,0,13,88,194,90,11,96,35,142,4,0,12,80,
209,81,42,87,1,0,224,81,226,13,198,134,8,0,224,129,162,5,194,74,
202,73,198,126,8,0,224,121,162,5,162,74,127,79,1,0,232,17,202,197,
128,255,8,0,74,6,255,243,130,7,225,241,58,6,64,48,32,16,64,198,
16,0,57,6,68,51,34,17,55,6,192,176,160,144,128,255,8,20,31,88,
128,255,4,0,31,80,11,248,10,224,162,226,194,226,128,255,234,2,10,216,
224,217,178,5,128,7,206,1,27,16,194,18,2,104,220,105,45,127,1,0,
250,121,250,5,28,112,194,113,46,103,5,0,249,97,178,13,45,95,1,0,
250,89,170,29,28,80,194,81,42,135,5,0,247,129,202,21,13,232,28,120,
194,121,47,111,5,0,247,105,138,13,128,255,24,5,61,23,13,0,234,17,
250,5,181,13,29,48,128,255,142,1,224,81,226,5,65,218,128,94,0,240,
235,217,150,213,187,6,0,240,210,37,61,87,1,0,250,81,218,37,61,143,
5,0,247,137,154,37,128,255,60,5,253,63,11,0,61,71,13,0,10,48,
221,57,128,255,216,5,224,81,178,5,128,7,60,1,253,103,11,0,221,97,
61,239,13,0,204,233,61,95,1,0,250,89,218,5,61,87,5,0,249,81,
210,5,32,86,195,1,128,7,24,1,64,222,16,0,128,255,248,4,248,81,
154,13,128,255,148,4,10,224,216,225,128,255,186,4,10,216,220,217,29,224,
165,13,28,48,128,255,4,1,224,81,234,117,28,48,128,255,88,1,10,224,
224,225,234,245,128,255,106,4,10,224,216,225,60,135,1,0,250,129,218,5,
60,127,5,0,249,121,162,5,27,224,60,119,1,0,250,113,218,21,60,111,
5,0,249,105,154,21,165,13,60,103,21,0,0,82,224,97,194,5,28,48,
128,255,22,1,10,224,28,48,128,255,32,1,224,81,186,245,165,5,0,226,
0,210,61,95,21,0,224,89,154,37,1,210,224,225,226,29,28,80,187,81,
125,87,21,0,61,143,13,0,61,135,21,0,241,129,201,5,125,7,21,0,
229,5,29,48,128,255,72,1,125,87,17,0,29,48,128,255,96,0,61,127,
21,0,106,127,21,0,61,119,17,0,106,119,17,0,61,71,13,0,29,56,
27,48,128,255,212,4,224,81,218,29,61,95,13,0,29,48,129,90,193,90,
203,217,128,255,156,0,10,232,224,209,162,205,128,255,174,3,10,232,216,233,
61,127,5,0,249,121,154,13,31,114,99,119,1,0,29,48,3,56,4,66,
128,255,154,4,0,82,66,6,255,241,38,87,13,0,230,135,11,0,198,81,
176,81,127,0,128,7,97,0,6,232,191,255,236,255,61,135,1,0,49,6,
64,48,32,16,10,56,241,129,130,13,61,119,1,0,47,6,128,112,96,80,
239,113,234,21,39,103,1,0,45,6,64,48,32,16,237,97,130,13,39,87,
1,0,43,6,128,112,96,80,235,81,138,13,253,71,11,0,29,48,128,255,
252,29,224,81,194,5,32,86,200,1,165,5,234,0,64,6,127,0,38,143,
21,0,0,82,224,137,194,5,38,87,21,0,198,81,127,0,224,49,210,45,
38,135,1,0,49,6,64,48,32,16,241,129,138,13,38,119,5,0,47,6,
68,51,34,17,239,113,210,29,38,103,1,0,45,6,128,112,96,80,237,97,
138,13,38,87,5,0,43,6,136,119,102,85,235,81,242,13,38,135,1,0,
49,6,64,48,32,16,241,129,170,13,38,119,5,0,47,6,136,136,136,136,
239,113,186,5,1,82,165,5,0,82,127,0,0,82,230,119,11,0,38,23,
13,0,0,90,6,102,24,0,193,114,174,17,130,18,194,18,204,17,44,71,
1,0,200,81,225,79,0,0,201,89,68,98,226,97,129,253,203,81,127,0,
128,7,225,0,128,239,4,0,0,50,128,255,192,3,100,87,89,128,36,23,
89,128,34,23,17,0,93,254,0,0,34,127,16,0,36,55,89,128,34,111,
21,0,63,254,44,0,15,112,206,49,109,0,10,224,224,225,210,5,36,55,
89,128,128,255,208,18,224,225,210,125,0,50,128,255,70,7,100,87,89,128,
36,23,89,128,34,23,17,0,93,254,0,0,34,135,16,0,36,55,89,128,
34,119,21,0,63,254,106,0,16,120,207,49,110,0,10,224,224,225,210,5,
36,55,89,128,128,255,146,18,224,225,226,93,0,50,128,255,118,7,100,87,
89,128,36,23,89,128,34,23,17,0,93,254,0,0,34,143,16,0,36,55,
89,128,34,127,21,0,63,254,168,0,17,128,208,49,111,0,10,224,224,225,
210,5,36,55,89,128,128,255,84,18,224,225,242,61,0,50,128,255,166,7,
100,87,89,128,36,23,89,128,34,23,17,0,93,254,0,0,34,87,16,0,
36,55,89,128,34,135,21,0,63,254,230,0,10,136,209,49,112,0,10,224,
224,225,210,5,36,55,89,128,128,255,22,18,224,225,130,37,0,50,128,255,
214,7,100,87,89,128,36,23,89,128,34,23,17,0,93,254,0,0,34,95,
16,0,36,55,89,128,34,143,21,0,63,254,36,1,11,80,202,49,113,0,
10,224,224,225,210,5,36,55,89,128,128,255,216,17,224,225,186,5,128,255,
10,0,28,80,64,6,255,0,128,7,225,112,128,239,4,0,36,23,89,128,
34,23,17,0,93,254,0,0,34,127,24,0,36,55,89,128,34,111,29,0,
63,254,34,0,15,112,206,49,109,0,36,23,89,128,34,23,17,0,10,224,
93,254,0,0,34,87,56,0,36,55,89,128,34,135,61,0,63,254,70,0,
10,136,209,49,112,0,234,225,218,109,36,231,89,128,93,254,0,0,60,231,
17,0,36,223,89,128,63,254,124,0,59,223,17,0,60,103,24,0,36,55,
89,128,60,87,29,0,27,222,40,0,12,88,203,49,28,230,24,0,106,0,
10,224,59,135,0,0,36,55,89,128,59,119,5,0,93,254,0,0,16,120,
207,49,63,254,152,0,110,0,36,223,89,128,10,200,220,201,59,223,17,0,
36,231,89,128,93,254,0,0,60,231,17,0,36,215,89,128,63,254,218,0,
28,230,40,0,58,215,17,0,59,143,24,0,36,55,89,128,59,127,29,0,
26,214,48,0,17,128,208,49,27,222,24,0,111,0,60,111,0,0,10,216,
36,55,89,128,60,95,5,0,13,96,204,49,93,254,0,0,63,254,246,0,
107,0,10,224,219,225,58,143,0,0,36,55,89,128,58,127,5,0,93,254,
0,0,17,128,208,49,63,254,20,1,111,0,25,48,220,81,10,62,8,0,
128,255,222,0,10,224,100,231,93,128,64,6,255,112,128,7,97,0,128,239,
4,0,36,23,89,128,34,23,17,0,93,254,0,0,34,127,40,0,36,55,
89,128,34,111,45,0,63,254,34,0,15,112,206,49,109,0,64,6,127,0,
128,7,97,0,128,239,4,0,36,23,89,128,34,23,17,0,93,254,0,0,
34,127,48,0,36,55,89,128,34,111,53,0,63,254,34,0,15,112,206,49,
109,0,64,6,127,0,128,7,97,0,128,239,4,0,36,23,89,128,34,23,
17,0,93,254,0,0,34,127,56,0,36,55,89,128,34,111,61,0,63,254,
34,0,15,112,206,49,109,0,64,6,127,0,12,0,128,7,97,0,6,232,
61,135,1,0,49,6,64,48,32,16,241,129,130,13,61,119,1,0,47,6,
128,112,96,80,239,113,202,13,29,48,128,255,144,0,253,71,11,0,10,56,
29,48,128,255,16,26,224,81,194,5,32,86,202,1,165,5,234,0,64,6,
127,0,128,7,225,16,7,216,6,232,149,21,61,135,1,0,49,6,64,48,
32,16,241,129,154,13,29,224,28,48,191,255,160,255,224,81,186,5,28,80,
213,5,68,234,251,233,241,237,0,82,64,6,255,16,52,0,24,0,128,7,
97,0,128,239,4,0,36,23,89,128,6,80,7,88,10,56,34,23,17,0,
8,72,11,64,93,254,0,0,34,127,8,0,36,55,89,128,34,111,13,0,
63,254,44,0,15,112,206,49,109,0,64,6,127,0,38,87,13,0,230,135,
11,0,198,81,176,81,127,0,24,0,128,7,33,0,224,49,138,13,32,54,
40,0,128,255,214,13,10,48,224,49,146,53,68,142,0,0,49,142,248,140,
102,143,17,0,68,134,0,0,48,134,132,141,102,135,17,0,64,126,16,0,
102,127,5,0,32,118,0,64,102,119,13,0,102,127,1,0,38,103,1,0,
12,102,170,10,102,103,21,0,38,95,1,0,11,94,84,5,102,95,25,0,
38,87,1,0,102,87,29,0,38,143,1,0,48,6,91,34,1,0,66,138,
102,143,33,0,102,135,37,0,6,80,64,6,63,0,38,87,1,0,127,0,
38,87,5,0,127,0,38,87,13,0,127,0,68,22,0,0,34,22,56,141,
34,87,9,0,34,135,5,0,208,81,202,82,127,0,38,87,1,0,127,0,
128,7,193,16,6,232,229,87,64,0,224,7,96,1,10,216,251,47,32,0,
61,143,21,0,32,134,170,0,113,135,0,0,61,127,25,0,32,118,85,0,
111,119,0,0,61,111,21,0,32,102,144,0,109,103,0,0,61,87,29,0,
42,87,0,0,61,231,33,0,202,142,255,0,252,231,1,0,61,103,21,0,
208,138,32,94,240,0,108,95,0,0,61,87,37,0,17,225,32,22,192,1,
234,225,170,5,0,18,2,80,64,6,223,16,134,7,225,243,6,224,99,71,
9,0,60,143,1,0,9,184,0,218,7,208,241,209,161,13,60,127,5,0,
60,119,1,0,23,128,218,129,206,121,239,129,195,5,32,86,193,1,165,117,
64,54,1,0,128,255,22,14,10,200,99,207,5,0,224,201,202,5,32,86,
21,1,229,101,60,239,1,0,0,18,2,104,194,106,68,86,0,0,202,105,
45,87,57,141,202,82,221,81,234,209,225,5,10,232,65,18,2,6,180,255,
153,245,99,23,1,0,165,77,35,127,1,0,68,102,0,0,194,122,204,121,
47,199,57,141,28,48,29,56,25,64,202,194,24,72,128,255,62,1,26,16,
189,17,26,88,165,21,35,87,5,0,35,151,9,0,95,186,65,210,194,81,
18,143,0,0,18,158,1,0,65,90,65,18,74,143,0,0,99,159,9,0,
24,176,221,177,246,89,185,5,224,185,170,237,28,48,29,56,128,255,80,1,
10,216,224,217,186,29,28,48,29,56,25,64,24,72,128,255,56,0,10,216,
224,217,170,21,28,48,29,56,25,64,24,72,128,255,254,0,10,216,224,217,
154,13,35,159,1,0,22,232,65,154,99,159,1,0,224,185,234,181,25,48,
128,255,90,13,27,80,70,6,255,243,128,7,193,0,6,232,9,224,34,6,
240,255,31,0,0,74,229,69,231,143,1,0,232,135,1,0,240,137,202,5,
66,58,66,66,197,61,61,127,21,0,32,118,170,0,111,119,0,0,61,111,
25,0,32,102,85,0,109,103,0,0,61,95,21,0,32,86,160,0,107,87,
0,0,66,58,7,142,254,255,66,66,8,134,254,255,240,127,1,0,113,127,
0,0,226,127,1,0,226,55,1,0,207,118,32,0,224,113,130,21,226,127,
1,0,226,55,1,0,15,104,205,102,64,0,6,88,203,86,64,0,234,97,
194,5,32,22,205,1,197,21,15,136,209,134,64,0,6,120,207,118,64,0,
238,129,170,229,65,74,28,104,13,96,159,98,28,88,204,89,11,80,161,82,
234,73,177,181,0,18,2,80,64,6,223,0,0,18,133,13,231,143,1,0,
66,58,65,18,104,143,0,0,66,66,9,120,159,122,9,104,207,105,161,106,
237,17,177,245,127,0,0,18,213,13,232,143,1,0,231,135,1,0,66,66,
66,58,240,137,194,5,32,86,194,1,165,13,65,18,9,112,159,114,9,96,
206,97,161,98,236,17,230,237,0,82,127,0,34,6,240,255,31,0,38,143,
21,0,32,134,170,0,113,135,0,0,38,127,25,0,32,118,85,0,111,119,
0,0,38,111,21,0,32,102,128,0,109,103,0,0,38,95,21,0,32,86,
170,0,107,87,0,0,38,143,25,0,32,134,85,0,113,135,0,0,32,126,
48,0,103,127,0,0,226,127,1,0,226,79,1,0,207,118,32,0,224,113,
130,21,226,127,1,0,226,79,1,0,15,104,205,102,64,0,9,88,203,86,
64,0,234,97,194,5,32,22,206,1,165,13,15,136,209,134,64,0,9,120,
207,118,64,0,238,129,170,229,0,18,2,80,127,0,128,7,97,0,6,232,
224,233,138,13,32,54,40,0,128,255,16,10,10,232,224,233,146,45,29,48,
191,255,34,252,64,142,16,0,125,143,5,0,32,134,0,64,125,135,13,0,
125,143,1,0,61,119,1,0,128,110,170,170,205,113,125,119,21,0,61,103,
1,0,12,102,84,85,125,103,25,0,61,95,1,0,125,95,29,0,61,87,
1,0,49,6,91,0,32,0,66,82,125,87,33,0,125,143,37,0,29,80,
64,6,127,0,128,7,97,0,6,232,224,233,138,13,32,54,40,0,128,255,
162,9,10,232,224,233,146,45,29,48,191,255,180,251,64,142,16,0,125,143,
5,0,32,134,0,64,125,135,13,0,125,143,1,0,61,119,1,0,128,110,
170,170,205,113,125,119,21,0,61,103,1,0,12,102,84,85,125,103,25,0,
61,95,1,0,125,95,29,0,61,87,1,0,49,6,91,34,32,0,66,82,
125,87,33,0,125,143,37,0,29,80,64,6,127,0,128,7,97,0,6,232,
224,233,138,13,32,54,40,0,128,255,52,9,10,232,224,233,146,45,29,48,
191,255,70,251,64,142,16,0,125,143,5,0,32,134,0,64,125,135,13,0,
125,143,1,0,61,119,1,0,128,110,170,170,205,113,125,119,21,0,61,103,
1,0,12,102,84,85,125,103,25,0,61,95,1,0,125,95,29,0,61,87,
1,0,49,6,91,34,194,0,66,82,125,87,33,0,125,143,37,0,29,80,
64,6,127,0,128,7,97,0,6,232,224,233,138,13,32,54,40,0,128,255,
198,8,10,232,224,233,178,45,29,48,191,255,216,250,64,142,16,0,125,143,
5,0,32,134,0,64,125,135,13,0,125,143,1,0,61,119,1,0,128,110,
170,170,205,113,125,119,21,0,61,103,1,0,12,102,84,85,125,103,25,0,
61,95,1,0,11,94,0,2,125,95,29,0,61,87,1,0,49,6,91,34,
28,0,66,82,125,87,33,0,125,143,37,0,29,80,64,6,127,0,38,23,
1,0,2,80,127,0,38,23,5,0,2,80,127,0,38,23,13,0,2,80,
127,0,34,6,0,192,23,0,2,80,127,0,128,7,225,16,6,232,0,226,
229,87,64,0,224,7,96,1,10,216,61,143,21,0,128,134,170,170,113,135,
0,0,61,127,25,0,32,118,85,85,111,119,0,0,61,111,21,0,128,102,
144,144,109,103,0,0,32,54,32,78,128,255,20,5,61,95,1,0,235,87,
1,0,10,136,208,138,61,135,29,0,240,127,1,0,15,224,17,225,61,119,
21,0,128,110,170,170,110,111,0,0,61,103,25,0,32,94,85,85,108,95,
0,0,61,87,21,0,128,142,240,240,106,143,0,0,32,54,32,78,128,255,
208,4,251,47,32,0,48,6,186,186,31,31,240,225,186,5,0,18,181,5,
32,22,192,1,2,80,64,6,255,16,190,7,225,241,3,30,124,254,6,232,
7,224,8,216,9,208,35,142,0,0,64,134,0,64,17,200,16,201,61,127,
1,0,239,225,161,13,26,112,220,113,61,111,5,0,61,103,1,0,204,105,
237,113,195,5,32,22,193,1,133,101,28,88,61,87,1,0,11,136,170,137,
17,16,61,135,9,0,240,23,194,2,2,184,149,85,61,127,1,0,15,112,
23,104,61,103,9,0,13,88,236,95,34,2,11,96,12,192,206,193,29,48,
24,56,25,64,128,255,32,1,0,18,24,72,149,37,252,73,218,29,224,209,
178,29,2,80,217,81,65,218,27,142,255,255,17,135,0,0,74,135,0,0,
95,210,65,226,224,209,226,13,2,126,1,0,15,112,217,113,65,218,27,110,
255,255,13,103,0,0,78,103,0,0,95,210,65,226,66,74,68,18,61,87,
9,0,10,88,129,90,11,128,193,130,16,136,17,120,216,121,239,73,225,213,
29,48,24,56,25,64,128,255,44,0,29,48,24,56,25,64,128,255,248,0,
10,16,224,17,194,5,32,22,194,1,213,5,65,186,224,209,250,173,0,18,
2,80,3,30,132,1,126,6,255,241,128,7,225,48,6,224,7,216,8,248,
60,135,5,0,16,136,129,138,17,232,59,233,229,87,64,0,224,7,96,1,
10,208,60,127,21,0,128,118,170,170,111,119,0,0,60,111,25,0,32,102,
85,85,109,103,0,0,60,95,21,0,128,86,160,160,107,87,0,0,0,18,
229,21,66,218,27,142,254,255,66,250,31,134,254,255,240,127,1,0,113,127,
0,0,66,234,29,118,254,255,66,250,31,110,254,255,237,103,1,0,110,103,
0,0,65,18,60,87,9,0,10,88,129,90,235,17,225,229,32,54,32,78,
128,255,42,3,250,47,32,0,64,6,255,48,38,135,5,0,16,136,129,138,
17,16,39,17,0,74,229,21,66,66,8,126,254,255,66,58,7,118,254,255,
238,111,1,0,111,111,0,0,66,66,8,102,254,255,66,18,2,94,254,255,
235,87,1,0,108,87,0,0,65,74,38,135,9,0,16,136,129,138,241,73,
225,229,127,0,38,135,5,0,16,136,129,138,17,16,39,17,0,74,133,37,
66,66,8,126,254,255,239,119,1,0,66,58,7,110,254,255,237,103,1,0,
236,113,194,5,32,22,194,1,149,29,66,66,8,94,254,255,235,87,1,0,
66,18,2,142,254,255,241,135,1,0,240,81,194,5,32,22,194,1,165,13,
65,74,9,120,38,111,9,0,13,112,129,114,238,121,177,221,0,18,2,80,
127,0,38,23,1,0,2,80,127,0,38,23,5,0,2,80,127,0,38,23,
13,0,2,80,127,0,34,6,0,192,23,0,2,80,127,0,128,7,225,16,
6,232,0,226,229,87,64,0,224,7,96,1,10,216,61,143,21,0,128,134,
170,170,113,135,0,0,61,127,25,0,32,118,85,85,111,119,0,0,61,111,
21,0,128,102,144,144,109,103,0,0,32,54,32,78,128,255,24,2,61,95,
1,0,235,87,1,0,10,136,208,138,61,135,29,0,240,127,1,0,15,224,
17,225,61,119,21,0,128,110,170,170,110,111,0,0,61,103,25,0,32,94,
85,85,108,95,0,0,61,87,21,0,128,142,240,240,106,143,0,0,32,54,
32,78,128,255,212,1,251,47,32,0,48,6,186,186,31,31,240,225,186,5,
0,18,181,5,32,22,192,1,2,80,64,6,255,16,190,7,225,241,3,30,
124,254,6,232,7,208,8,192,9,200,35,142,0,0,64,134,0,64,17,216,
16,217,61,127,1,0,239,209,161,13,25,112,218,113,61,111,5,0,61,103,
1,0,204,105,237,113,195,5,32,22,193,1,149,85,26,88,61,87,1,0,
11,136,170,137,17,16,61,135,9,0,240,23,194,2,2,184,165,69,61,127,
1,0,15,112,23,104,61,103,9,0,13,88,236,95,34,2,11,96,12,224,
206,225,29,48,28,56,27,64,128,255,226,0,0,74,28,16,165,21,250,17,
234,13,224,201,194,13,9,80,219,81,65,194,24,142,255,255,17,135,0,0,
74,135,0,0,95,202,65,210,65,18,65,74,61,119,9,0,14,120,129,122,
15,96,193,98,12,104,13,88,220,89,235,17,209,229,29,48,28,56,27,64,
128,255,44,0,29,48,28,56,27,64,128,255,184,0,10,16,224,17,194,5,
32,22,194,1,213,5,65,186,224,201,234,189,0,18,2,80,3,30,132,1,
126,6,255,241,128,7,225,16,6,248,7,232,8,224,229,87,64,0,224,7,
96,1,10,216,63,143,21,0,128,134,170,170,113,135,0,0,63,127,25,0,
32,118,85,85,111,119,0,0,63,111,21,0,128,102,160,160,109,103,0,0,
0,18,197,13,66,234,29,94,254,255,66,226,28,86,254,255,234,143,1,0,
107,143,0,0,65,18,63,127,9,0,15,128,129,130,240,17,129,245,32,54,
32,78,128,255,108,0,251,47,32,0,64,6,255,16,0,18,197,13,66,66,
8,142,254,255,66,58,7,134,254,255,240,127,1,0,113,127,0,0,65,18,
38,111,9,0,13,112,129,114,238,17,129,245,127,0,0,18,149,21,66,66,
8,142,254,255,241,135,1,0,66,58,7,126,254,255,239,119,1,0,238,129,
194,5,32,22,194,1,165,13,65,18,2,104,38,95,9,0,11,96,129,98,
236,105,161,237,0,18,2,80,127,0,128,7,225,0,6,232,29,6,155,255,
233,5,32,230,213,1,29,238,156,255,149,21,47,6,140,134,71,0,15,128,
253,135,34,2,16,136,17,112,45,6,64,66,15,0,237,119,194,2,14,230,
1,0,0,234,128,102,26,183,236,225,147,13,128,54,26,183,128,255,34,0,
128,94,26,183,171,225,229,5,28,80,10,48,128,255,18,0,0,226,224,225,
234,237,224,233,202,213,64,6,255,0,128,7,193,0,6,232,64,86,0,0,
42,87,80,245,202,0,10,224,29,136,220,137,17,128,128,126,27,183,239,135,
192,234,252,233,167,13,64,86,0,0,42,87,80,245,202,0,10,16,253,17,
150,253,165,21,64,86,0,0,42,87,80,245,202,0,10,16,245,5,64,86,
0,0,42,87,80,245,202,0,10,16,252,17,159,253,253,17,246,245,64,6,
223,0,1,50,127,0,12,0,3,30,220,255,99,255,33,0,99,231,29,0,
3,230,28,0,99,207,25,0,99,215,21,0,99,223,17,0,99,239,13,0,
128,239,4,0,99,55,9,0,68,214,0,0,58,214,128,128,58,223,1,0,
0,202,133,69,35,119,9,0,224,113,178,13,59,55,5,0,224,49,210,53,
35,119,9,0,38,103,1,0,236,113,250,45,59,55,1,0,224,201,202,5,
122,55,1,0,181,5,121,55,1,0,58,119,1,0,59,55,9,0,99,119,
5,0,224,49,210,13,59,119,13,0,2,58,93,254,0,0,63,254,104,0,
99,119,1,0,14,104,109,0,181,13,59,119,13,0,93,254,0,0,63,254,
126,0,99,119,1,0,14,104,109,0,35,119,5,0,58,95,1,0,235,113,
170,197,165,5,27,200,59,223,1,0,224,217,138,197,35,207,25,0,35,215,
21,0,35,223,17,0,35,239,13,0,35,255,33,0,35,231,29,0,3,30,
36,0,127,0,3,30,236,255,99,255,17,0,99,231,13,0,3,230,12,0,
99,215,9,0,99,223,5,0,99,239,1,0,128,239,4,0,6,208,181,29,
39,103,1,0,7,48,122,103,1,0,38,63,5,0,224,57,178,13,38,223,
9,0,7,48,2,58,93,254,0,0,63,254,40,0,123,0,133,13,38,223,
9,0,93,254,0,0,63,254,56,0,123,0,58,63,1,0,224,57,186,229,
35,215,9,0,35,223,5,0,35,239,1,0,35,255,17,0,35,231,13,0,
3,30,20,0,127,0,88,26,99,255,5,0,99,231,1,0,68,102,0,0,
44,103,129,128,3,224,224,97,210,5,0,50,191,255,148,254,245,5,68,54,
0,0,38,54,132,128,191,255,94,255,35,255,5,0,35,231,1,0,72,26,
127,0,3,30,236,255,99,255,17,0,99,231,13,0,3,230,12,0,99,215,
9,0,99,223,5,0,99,239,1,0,128,239,4,0,68,118,0,0,46,119,
89,143,0,218,224,113,250,29,1,114,68,14,0,0,97,119,89,143,93,54,
0,0,38,54,168,255,128,255,38,18,133,13,65,218,9,208,93,254,0,0,
63,254,52,0,122,0,27,48,194,50,68,86,0,0,202,49,38,79,29,132,
38,54,28,132,224,73,250,237,35,215,9,0,35,223,5,0,35,239,1,0,
35,255,17,0,35,231,13,0,3,30,20,0,127,0,88,26,99,255,5,0,
99,231,1,0,3,224,6,50,128,255,26,1,35,255,5,0,35,231,1,0,
72,26,127,0,3,30,236,255,99,255,17,0,99,231,13,0,3,230,12,0,
99,215,9,0,99,223,5,0,99,239,1,0,128,239,4,0,6,208,224,209,
186,29,1,210,149,29,68,54,0,0,38,55,217,144,93,222,0,0,59,222,
154,1,224,49,162,5,6,216,93,254,0,0,63,254,42,0,123,0,93,102,
0,0,44,102,154,1,236,217,186,5,0,82,229,5,26,48,128,255,218,16,
224,81,194,229,35,215,9,0,35,223,5,0,35,239,1,0,35,255,17,0,
35,231,13,0,3,30,20,0,127,0,88,26,99,255,5,0,99,231,1,0,
3,224,0,82,95,50,104,50,251,53,70,0,9,0,14,0,19,0,24,0,
29,0,34,0,39,0,44,0,49,0,68,86,0,0,42,86,92,143,133,45,
68,86,0,0,42,86,168,143,181,37,68,86,0,0,42,86,224,143,229,29,
68,86,0,0,42,86,140,144,149,29,68,86,0,0,42,86,20,144,197,21,
68,86,0,0,42,86,52,144,245,13,68,86,0,0,42,86,88,144,165,13,
68,86,0,0,42,86,112,144,213,5,68,86,0,0,42,86,112,143,35,255,
5,0,35,231,1,0,72,26,127,0,80,26,99,255,13,0,99,231,9,0,
3,230,8,0,99,223,5,0,99,239,1,0,6,232,1,50,191,255,90,255,
10,216,29,48,191,255,82,255,68,54,0,0,38,54,252,130,27,64,10,72,
68,62,0,0,39,62,208,144,128,255,120,0,128,255,220,16,35,223,5,0,
35,239,1,0,35,255,13,0,35,231,9,0,3,30,16,0,127,0,88,26,
99,255,5,0,99,231,1,0,3,224,224,49,178,5,128,255,84,13,35,255,
5,0,35,231,1,0,72,26,127,0,88,26,99,255,5,0,99,231,1,0,
3,224,191,255,114,254,35,255,5,0,35,231,1,0,72,26,127,0,88,26,
99,255,5,0,99,231,1,0,3,224,191,255,184,255,35,255,5,0,35,231,
1,0,72,26,127,0,127,0,3,30,224,255,99,79,29,0,99,255,13,0,
35,94,16,0,203,94,7,0,99,95,5,0,99,71,25,0,35,102,24,0,
99,103,1,0,35,71,1,0,35,79,5,0,99,231,9,0,3,230,8,0,
128,255,20,0,35,255,13,0,35,231,9,0,3,30,32,0,127,0,4,2,
3,30,212,253,99,79,41,2,99,71,37,2,99,255,25,2,99,231,21,2,
3,230,20,2,99,207,17,2,99,215,13,2,99,223,9,2,99,239,5,2,
128,239,4,0,7,200,6,216,128,255,84,10,27,103,15,0,12,208,220,210,
159,210,135,98,209,5,9,50,128,255,128,20,133,61,59,95,5,0,224,89,
154,21,219,175,15,0,35,86,4,0,123,87,5,0,35,78,4,0,32,54,
0,2,123,79,1,0,123,55,9,0,219,151,15,0,27,48,93,62,0,0,
35,103,41,2,35,79,37,2,39,62,140,9,25,64,99,103,1,0,128,255,
22,3,10,200,59,87,5,0,35,94,4,0,235,81,170,13,27,48,128,255,
182,10,123,7,5,0,123,7,1,0,123,7,9,0,224,209,218,5,219,223,
15,0,162,5,31,202,27,48,128,255,160,9,25,80,35,207,17,2,35,215,
13,2,35,239,5,2,35,255,25,2,35,231,21,2,35,223,9,2,3,30,
44,2,127,0,88,26,99,255,5,0,99,231,1,0,3,224,197,13,6,88,
10,82,234,95,194,98,12,102,48,0,71,103,255,255,95,58,234,55,194,2,
224,49,202,245,224,65,146,13,229,5,32,54,48,0,71,55,255,255,95,58,
231,65,161,253,35,231,1,0,35,255,5,0,7,80,72,26,127,0,24,0,
3,30,208,255,99,255,45,0,99,231,41,0,3,230,40,0,99,207,37,0,
99,215,33,0,99,223,29,0,99,239,25,0,128,239,4,0,99,55,13,0,
38,119,9,0,7,216,224,217,99,119,17,0,38,207,13,0,99,223,1,0,
250,5,68,222,0,0,59,222,220,144,99,223,1,0,27,48,128,255,10,8,
35,111,13,0,13,103,21,0,45,55,5,0,224,97,194,5,234,49,169,5,
6,80,10,112,219,113,99,119,9,0,35,119,13,0,46,119,1,0,234,113,
99,119,5,0,190,5,99,87,5,0,35,79,13,0,35,215,5,0,9,79,
16,0,170,209,224,73,210,29,27,55,0,0,6,6,211,255,242,5,6,6,
213,255,194,5,6,6,224,255,170,5,65,218,27,103,0,0,12,6,208,255,
154,13,27,95,1,0,139,86,32,0,10,6,136,255,170,5,66,218,32,118,
48,0,181,5,32,118,32,0,99,119,21,0,229,13,14,79,0,0,65,114,
99,119,1,0,35,63,17,0,9,48,93,254,0,0,63,254,204,0,121,0,
35,119,1,0,251,113,129,245,35,71,13,0,8,71,17,0,224,65,194,13,
149,29,35,55,21,0,35,63,17,0,93,254,0,0,63,254,244,0,121,0,
95,210,224,209,223,245,197,13,27,103,0,0,65,218,35,63,17,0,93,254,
0,0,12,48,63,254,18,1,121,0,35,111,9,0,237,217,161,245,181,13,
35,63,17,0,32,54,32,0,93,254,0,0,63,254,46,1,121,0,95,210,
224,209,223,245,35,207,37,0,35,215,33,0,35,223,29,0,35,239,25,0,
35,255,45,0,35,231,41,0,35,87,5,0,3,30,48,0,127,0,3,30,
140,255,99,255,113,0,99,231,109,0,99,223,105,0,99,239,101,0,6,232,
61,79,5,0,3,230,108,0,8,216,3,70,99,0,224,73,174,5,1,74,
72,7,0,0,7,48,8,56,169,65,191,255,6,254,10,64,224,217,194,5,
72,223,255,255,95,66,29,48,8,56,191,255,62,254,35,223,105,0,35,239,
101,0,35,255,113,0,35,231,109,0,3,30,116,0,127,0,88,26,99,255,
5,0,99,231,1,0,6,103,27,0,8,80,3,224,204,54,32,0,213,13,
199,94,15,0,68,78,0,0,201,89,11,71,228,144,132,58,6,65,74,71,
255,255,95,82,224,57,186,245,35,255,5,0,35,231,1,0,72,26,127,0,
88,26,99,255,5,0,99,231,1,0,6,80,42,55,5,0,3,224,224,49,
174,5,1,50,166,73,224,57,238,5,32,54,48,0,72,55,255,255,95,66,
233,65,171,253,224,57,167,13,10,95,27,0,32,54,48,0,72,55,254,255,
72,95,255,255,94,66,10,48,8,56,191,255,158,253,35,255,5,0,35,231,
1,0,72,26,127,0,156,0,3,30,60,255,99,79,193,0,99,255,177,0,
99,231,173,0,3,230,172,0,99,207,169,0,99,215,165,0,99,223,161,0,
99,239,157,0,128,239,4,0,99,55,21,0,99,63,13,0,8,216,0,210,
224,217,218,5,68,222,0,0,59,222,220,144,35,111,21,0,99,111,137,0,
35,111,13,0,99,111,141,0,128,7,102,5,6,80,10,6,219,255,226,13,
35,103,13,0,35,63,21,0,10,48,93,254,0,0,63,254,72,0,108,0,
65,218,128,7,50,5,65,218,67,7,3,0,31,50,99,55,129,0,99,55,
133,0,35,54,144,0,197,5,70,7,0,0,65,50,35,78,155,0,233,49,
163,253,27,255,0,0,31,6,211,255,218,5,1,50,67,55,145,0,197,29,
31,48,31,6,213,255,202,5,67,55,146,0,213,21,6,6,208,255,218,5,
1,50,67,55,144,0,229,13,31,80,31,6,224,255,202,5,67,87,147,0,
245,5,10,6,221,255,234,5,1,50,67,55,148,0,65,218,181,221,31,78,
208,255,106,74,169,21,0,50,245,5,234,55,64,2,65,218,198,89,11,54,
208,255,99,55,129,0,27,95,0,0,11,78,208,255,106,74,177,245,149,29,
31,6,214,255,234,21,35,55,193,0,28,74,67,50,73,49,68,50,99,55,
193,0,38,55,253,255,99,55,129,0,224,49,254,5,128,49,99,55,129,0,
1,50,67,55,145,0,65,218,27,87,0,0,10,6,210,255,250,53,1,106,
27,71,1,0,67,111,3,0,65,218,8,70,208,255,106,66,169,21,0,50,
245,5,234,55,64,2,65,218,198,81,10,54,208,255,99,55,133,0,27,87,
0,0,10,70,208,255,106,66,177,245,197,29,27,55,0,0,6,6,214,255,
186,21,35,95,193,0,28,66,67,90,72,89,68,90,99,95,193,0,43,95,
253,255,99,95,133,0,224,89,142,13,31,50,99,55,133,0,197,5,99,7,
133,0,165,5,65,218,27,63,0,0,7,6,224,255,178,253,7,6,148,255,
138,13,27,63,1,0,65,218,7,6,148,255,218,37,197,5,7,6,180,255,
234,5,65,218,1,50,67,55,151,0,197,29,7,6,152,255,250,13,27,87,
1,0,1,50,65,218,10,6,152,255,218,5,65,218,67,55,154,0,229,13,
67,55,153,0,181,13,7,6,150,255,242,5,7,6,134,255,194,5,7,6,
140,255,170,5,65,218,27,63,0,0,65,218,67,63,155,0,7,6,191,255,
186,5,128,7,112,2,7,54,187,255,98,50,187,5,128,7,100,2,107,50,
186,5,128,7,22,1,6,6,237,255,186,5,128,7,48,1,6,6,228,255,
186,5,128,7,72,2,6,6,226,255,177,5,128,7,38,3,186,5,128,7,
12,3,6,6,225,255,162,37,6,6,221,255,177,5,128,7,40,2,6,6,
220,255,162,29,6,6,215,255,177,5,128,7,0,3,186,5,128,7,62,2,
6,6,213,255,201,117,146,101,6,6,210,255,186,5,128,7,174,2,6,6,
208,255,178,109,6,6,205,255,130,109,128,7,216,2,3,95,3,0,224,89,
178,5,67,7,144,0,3,87,151,0,35,79,193,0,224,81,226,37,35,55,
197,0,9,80,10,70,255,255,200,62,4,0,231,49,226,79,0,0,194,74,
202,73,9,54,3,0,28,58,71,49,72,50,99,55,193,0,38,79,253,255,
38,71,249,255,93,86,128,255,42,86,20,225,224,81,242,5,35,54,128,0,
128,255,4,0,128,7,172,2,8,200,149,13,67,74,28,50,70,73,68,74,
99,79,193,0,41,207,253,255,3,79,153,0,224,73,178,5,249,0,229,5,
3,63,154,0,224,57,162,5,185,0,3,71,146,0,25,56,224,65,186,5,
3,71,147,0,224,57,206,5,32,70,45,0,128,57,35,54,128,0,149,109,
3,87,155,0,35,79,193,0,28,50,72,82,67,87,155,0,67,74,70,73,
68,74,41,111,253,255,99,79,193,0,99,111,9,0,181,93,3,79,3,0,
224,73,178,5,67,7,144,0,3,71,151,0,35,63,193,0,224,65,130,45,
35,87,197,0,7,64,8,54,255,255,198,94,4,0,235,81,226,63,0,0,
194,58,200,57,7,54,3,0,28,90,75,49,72,50,99,55,193,0,38,95,
253,255,38,87,249,255,93,70,128,255,40,70,20,225,224,65,146,13,10,64,
11,72,35,54,128,0,128,255,4,0,128,7,222,1,10,200,181,13,67,58,
28,82,74,57,68,58,39,111,253,255,99,63,193,0,99,111,9,0,3,63,
153,0,224,57,242,5,35,111,9,0,205,0,99,111,9,0,229,5,3,95,
154,0,224,89,162,5,153,0,3,79,155,0,9,6,139,255,170,13,35,63,
9,0,35,54,128,0,0,66,191,255,226,250,128,7,140,1,3,111,148,0,
35,79,9,0,67,7,127,0,3,86,127,0,99,111,17,0,224,73,186,5,
99,79,17,0,3,63,155,0,99,87,25,0,7,6,145,255,170,21,35,111,
17,0,128,105,99,111,17,0,149,13,201,54,7,0,6,54,48,0,74,55,
255,255,95,82,131,74,224,73,250,245,245,5,9,56,10,64,35,54,128,0,
191,255,232,250,35,63,17,0,35,79,25,0,35,54,128,0,10,64,191,255,
22,251,128,7,30,1,68,110,0,0,45,62,244,144,99,63,25,0,35,54,
128,0,191,255,226,248,35,103,25,0,32,54,41,0,76,55,15,0,35,103,
25,0,202,209,76,7,16,0,149,125,3,87,154,0,224,81,226,13,35,79,
193,0,28,50,67,74,70,73,68,74,99,79,193,0,41,79,253,255,73,215,
0,0,133,109,3,71,153,0,35,87,193,0,224,65,210,13,10,62,3,0,
28,82,74,57,68,58,99,63,193,0,39,63,253,255,103,215,0,0,229,85,
3,55,151,0,28,58,224,49,130,21,10,94,3,0,71,89,68,90,99,95,
193,0,43,95,253,255,26,56,191,58,107,215,1,0,107,63,5,0,165,69,
67,82,71,81,68,82,99,87,193,0,42,87,253,255,106,215,1,0,133,61,
35,79,193,0,67,7,144,0,28,82,1,50,67,74,74,73,68,74,99,79,
193,0,9,64,40,63,253,255,67,55,149,0,35,54,128,0,165,37,35,63,
193,0,28,82,67,58,74,57,68,58,99,63,193,0,7,63,252,255,67,63,
4,0,67,7,5,0,167,0,224,57,218,13,35,63,21,0,35,103,13,0,
0,50,93,254,0,0,63,254,124,5,108,0,65,210,133,13,35,54,128,0,
35,62,4,0,191,255,220,247,202,209,27,55,0,0,224,49,178,5,191,7,
150,250,26,80,35,207,169,0,35,215,165,0,35,239,157,0,35,255,177,0,
35,231,173,0,35,223,161,0,3,30,196,0,127,0,6,56,6,103,0,0,
65,50,224,97,202,253,167,49,6,86,255,255,127,0,10,88,95,66,150,13,
6,87,0,0,7,95,0,0,65,50,65,58,234,89,242,245,202,86,255,0,
203,94,255,0,171,81,127,0,0,2,39,103,9,0,6,64,95,98,103,103,
9,0,204,5,128,255,230,0,165,13,39,55,1,0,8,80,138,0,70,71,
0,0,65,50,103,55,1,0,22,2,68,94,0,0,43,94,220,130,6,72,
171,73,164,74,9,6,236,255,177,13,194,74,68,62,0,0,39,62,32,132,
9,64,199,65,8,48,128,7,200,7,127,0,9,2,68,54,0,0,38,54,
220,130,198,55,47,0,198,47,15,0,198,55,31,0,6,230,32,0,38,103,
28,0,38,87,44,0,6,238,16,0,32,110,0,192,77,97,77,81,138,86,
2,0,140,102,1,0,102,103,28,0,102,87,44,0,191,255,152,255,29,48,
191,255,146,255,28,48,191,255,140,255,31,2,68,94,0,0,43,94,220,130,
171,49,164,50,6,6,236,255,177,13,194,50,68,62,0,0,199,49,38,55,
33,132,224,49,178,5,128,7,82,7,127,0,68,94,0,0,43,94,220,130,
171,49,164,50,6,6,236,255,177,13,194,50,68,62,0,0,199,49,38,55,
33,132,224,49,178,5,128,7,44,7,127,0,4,0,19,2,6,216,7,232,
68,54,0,0,38,54,220,130,230,233,193,61,68,86,0,0,234,87,49,145,
196,82,198,81,234,233,201,53,221,247,15,0,146,53,29,55,15,0,61,231,
5,0,218,50,156,50,198,94,9,0,105,90,186,5,125,231,1,0,221,151,
15,0,221,175,15,0,224,225,170,29,61,231,12,0,67,223,3,0,220,230,
255,63,221,255,13,0,226,5,28,48,0,58,2,66,128,255,2,10,28,48,
35,62,3,0,1,66,128,255,34,10,97,82,206,21,221,31,15,0,229,5,
29,48,128,255,38,0,224,81,178,5,31,82,197,13,32,54,255,1,125,55,
9,0,92,223,0,0,65,226,125,231,1,0,27,80,138,0,41,2,4,0,
9,2,0,226,6,232,191,255,42,255,224,233,178,69,61,55,5,0,224,49,
242,61,221,247,15,0,234,5,9,50,128,255,82,9,31,226,245,53,221,239,
15,0,202,53,61,87,1,0,230,81,163,37,221,255,13,0,146,13,61,103,
12,0,0,58,2,66,204,54,255,63,128,255,122,9,61,95,12,0,61,79,
1,0,61,63,5,0,203,54,255,63,9,64,167,65,128,255,142,9,61,55,
1,0,61,63,5,0,167,49,230,81,206,5,221,31,15,0,31,226,61,55,
5,0,221,183,13,0,224,49,32,62,0,2,125,55,1,0,125,63,9,0,
186,5,125,55,9,0,29,48,191,255,116,254,28,80,31,2,52,0,88,26,
99,255,5,0,99,231,1,0,68,62,0,0,39,62,228,129,39,103,29,0,
6,248,3,224,236,249,193,85,39,95,33,0,235,249,137,85,223,86,7,0,
218,77,39,55,9,0,63,95,253,255,230,249,169,13,6,80,10,48,38,87,
5,0,234,249,185,13,230,81,161,253,133,13,6,80,42,55,1,0,230,81,
185,5,255,49,163,253,103,87,9,0,42,63,253,255,255,81,219,5,7,72,
202,73,233,249,209,45,0,74,0,98,7,64,202,65,255,65,234,5,10,248,
63,87,5,0,199,89,1,74,11,56,223,57,230,57,138,21,38,63,1,0,
38,55,253,255,106,255,1,0,127,87,5,0,1,98,198,89,7,48,127,55,
1,0,102,255,5,0,127,95,253,255,224,73,186,13,224,97,154,13,106,255,
1,0,127,87,5,0,127,55,1,0,102,255,5,0,35,255,5,0,35,231,
1,0,72,26,127,0,84,26,99,255,9,0,99,231,5,0,3,230,4,0,
99,239,1,0,6,232,128,255,2,5,224,233,194,5,29,48,191,255,18,255,
128,255,242,4,35,239,1,0,35,255,9,0,35,231,5,0,76,26,127,0,
3,30,232,255,99,255,21,0,99,231,17,0,99,207,13,0,99,215,9,0,
99,239,1,0,99,223,5,0,68,222,0,0,59,222,228,129,59,103,37,0,
6,232,7,200,3,230,16,0,224,97,218,5,32,54,0,8,123,55,37,0,
59,55,37,0,29,208,6,88,221,89,71,90,95,50,38,232,75,233,212,21,
250,233,177,21,29,48,128,255,130,5,10,56,127,58,250,13,224,201,178,13,
26,238,8,0,24,98,76,233,29,48,128,255,106,5,10,56,127,58,186,5,
0,82,197,53,199,78,7,0,178,5,8,50,134,73,59,87,33,0,231,81,
138,13,29,48,199,49,123,55,33,0,9,216,199,217,181,29,59,55,29,0,
224,49,178,5,230,57,185,5,123,63,29,0,59,55,33,0,224,49,210,5,
29,64,199,65,232,49,217,5,29,48,199,49,123,55,33,0,9,48,199,49,
6,222,8,0,72,74,169,233,71,234,24,82,74,233,123,239,253,255,27,48,
191,255,30,254,27,80,35,207,13,0,35,215,9,0,35,223,5,0,35,239,
1,0,35,255,21,0,35,231,17,0,3,30,24,0,127,0,3,30,228,255,
99,255,25,0,99,231,21,0,3,230,20,0,99,207,17,0,99,215,13,0,
99,223,9,0,99,239,5,0,6,222,11,0,24,90,75,217,230,217,185,5,
0,82,245,117,27,6,240,255,177,5,32,222,16,0,68,214,0,0,58,214,
228,129,58,239,9,0,224,233,154,21,224,233,218,13,122,239,1,0,26,54,
20,0,122,55,9,0,122,55,21,0,122,55,25,0,122,7,17,0,58,239,
9,0,29,56,61,239,1,0,61,79,253,255,251,73,193,45,61,87,1,0,
122,63,9,0,9,48,187,49,6,6,240,255,241,5,103,87,1,0,106,63,
5,0,29,72,181,69,58,71,33,0,221,73,232,73,218,5,29,64,219,233,
1,90,197,5,6,64,221,65,0,90,8,72,104,223,253,255,125,55,253,255,
224,89,130,53,103,239,1,0,125,63,5,0,125,87,1,0,106,239,5,0,
245,37,58,55,9,0,230,233,186,205,99,55,1,0,27,200,25,48,0,58,
191,255,32,254,224,81,218,21,61,63,1,0,7,64,40,63,1,0,231,65,
217,5,58,54,20,0,230,57,138,253,40,55,253,255,1,58,153,49,191,255,
250,253,10,72,224,73,226,5,35,119,1,0,122,119,9,0,149,173,9,80,
35,207,17,0,35,215,13,0,35,223,9,0,35,239,5,0,35,255,25,0,
35,231,21,0,3,30,28,0,127,0,84,26,99,255,9,0,99,231,5,0,
3,230,4,0,99,239,1,0,6,232,128,255,146,2,29,48,191,255,172,254,
10,232,128,255,132,2,29,80,35,239,1,0,35,255,9,0,35,231,5,0,
76,26,127,0,8,2,128,255,110,2,32,230,35,0,28,48,194,50,68,86,
0,0,202,49,38,223,13,130,38,54,12,130,224,217,146,13,0,58,102,7,
1,0,93,254,0,0,63,254,46,0,123,0,95,226,204,237,68,230,0,0,
60,231,113,132,224,225,162,13,93,254,0,0,63,254,72,0,124,0,68,14,
0,0,97,7,113,132,128,255,28,2,30,2,8,2,6,216,68,230,0,0,
128,255,16,2,60,103,157,130,60,230,156,130,224,97,170,13,93,94,0,0,
43,94,166,255,124,95,1,0,28,48,128,255,56,4,0,74,9,48,194,50,
68,70,0,0,200,49,38,63,13,130,38,54,12,130,224,57,250,5,102,223,
1,0,128,255,208,1,0,82,133,13,65,74,9,6,220,255,198,237,128,255,
192,1,31,82,30,2,16,0,88,26,99,255,5,0,99,231,1,0,3,224,
6,50,128,255,182,1,35,255,5,0,35,231,1,0,72,26,127,0,3,30,
232,255,99,255,21,0,99,231,17,0,3,230,16,0,99,207,13,0,99,215,
9,0,99,223,5,0,99,239,1,0,8,208,6,64,199,209,8,200,32,238,
238,15,0,218,149,69,129,218,27,96,137,98,225,5,135,95,1,0,65,58,
139,222,0,255,219,54,1,0,135,95,1,0,65,58,224,49,130,13,72,95,
0,0,65,66,65,234,221,238,255,15,165,45,135,87,1,0,65,58,202,78,
240,0,202,86,15,0,67,82,196,74,9,89,11,48,200,49,189,49,235,233,
191,5,6,54,0,240,0,74,229,5,72,7,0,0,65,66,65,50,65,74,
249,49,185,13,234,73,134,253,165,13,134,103,1,0,65,50,65,74,72,103,
0,0,65,66,234,73,134,253,221,81,202,238,255,15,250,57,250,189,35,207,
13,0,35,215,9,0,35,223,5,0,35,239,1,0,35,255,21,0,35,231,
17,0,3,30,24,0,127,0,88,26,99,231,5,0,99,239,1,0,6,232,
8,72,9,48,221,49,7,64,136,0,29,230,255,255,9,6,223,255,153,37,
8,56,200,58,8,57,7,88,208,90,11,57,197,5,70,71,255,255,95,50,
198,86,15,0,186,253,16,74,93,73,149,13,102,63,1,0,102,63,5,0,
102,63,9,0,102,63,13,0,80,50,233,49,234,245,6,54,16,0,181,5,
70,71,0,0,95,50,252,49,202,253,29,80,35,231,5,0,35,239,1,0,
72,26,127,0,6,80,198,94,3,0,218,21,39,89,203,94,3,0,154,21,
100,66,241,13,6,96,200,97,130,98,194,98,39,95,1,0,68,58,102,95,
1,0,68,50,230,97,155,253,200,70,3,0,224,65,178,13,6,96,200,97,
7,95,0,0,65,58,70,95,0,0,65,50,230,97,155,253,127,0,127,0,
127,0,127,0,127,0,127,0,127,0,68,86,0,0,42,86,136,132,127,0,
3,30,236,255,99,255,17,0,99,231,13,0,3,230,12,0,99,215,9,0,
99,223,5,0,99,239,1,0,128,239,4,0,6,216,27,102,255,255,12,6,
224,255,185,5,31,82,229,29,191,255,198,255,27,96,194,98,12,64,202,65,
40,215,1,0,105,218,178,5,224,209,218,5,27,48,128,255,210,1,213,13,
97,210,178,13,10,56,202,97,108,7,1,0,27,48,93,254,0,0,63,254,
72,0,122,0,0,82,35,215,9,0,35,223,5,0,35,239,1,0,35,255,
17,0,35,231,13,0,3,30,20,0,127,0,88,26,99,255,5,0,99,231,
1,0,3,224,6,248,224,249,202,5,191,255,96,255,10,248,1,74,9,80,
194,82,223,81,106,7,1,0,65,74,9,6,224,255,135,253,32,78,18,0,
9,96,194,98,223,97,1,50,108,55,1,0,65,74,9,6,232,255,247,245,
32,78,29,0,9,56,194,58,223,57,1,50,103,55,1,0,65,74,9,6,
224,255,247,245,35,255,5,0,35,231,1,0,72,26,127,0,80,26,99,255,
13,0,99,231,9,0,3,230,8,0,99,239,1,0,99,223,5,0,6,216,
191,255,240,254,68,118,0,0,46,119,165,130,224,113,154,13,68,118,254,255,
46,118,0,96,68,14,0,0,97,119,165,130,68,54,0,0,38,55,165,130,
68,102,254,255,44,102,0,96,219,49,230,97,235,13,68,94,255,255,43,94,
0,112,235,49,139,13,68,14,0,0,97,55,165,130,6,232,187,233,213,5,
31,234,12,50,128,255,136,1,191,255,150,254,29,80,35,223,5,0,35,239,
1,0,35,231,9,0,35,255,13,0,3,30,16,0,127,0,4,0,3,30,
228,255,99,255,25,0,99,231,21,0,3,230,20,0,99,207,17,0,99,215,
13,0,99,223,9,0,99,239,5,0,128,239,4,0,99,55,1,0,0,202,
191,255,80,254,68,222,0,0,59,223,169,130,165,13,59,215,1,0,93,254,
0,0,63,254,34,0,122,0,59,223,5,0,224,217,234,245,68,118,0,0,
46,119,221,146,224,113,242,5,191,255,34,254,42,54,220,0,128,255,4,0,
35,63,1,0,2,50,128,255,42,1,25,96,172,0,2,90,76,88,203,78,
1,0,98,74,145,253,191,255,248,253,35,207,17,0,35,215,13,0,35,223,
9,0,35,239,5,0,35,255,25,0,35,231,21,0,3,30,28,0,127,0,
88,26,99,255,5,0,99,231,1,0,3,224,1,50,191,255,80,255,35,255,
5,0,35,231,1,0,72,26,127,0,84,26,99,255,9,0,99,231,5,0,
3,230,4,0,99,239,1,0,6,232,191,255,166,253,68,14,0,0,33,103,
169,130,125,103,5,0,97,239,169,130,191,255,144,253,35,239,1,0,35,255,
9,0,35,231,5,0,76,26,127,0,88,26,99,255,5,0,99,231,1,0,
3,224,32,54,16,0,31,58,128,255,136,0,35,255,5,0,35,231,1,0,
72,26,127,0,84,26,99,255,9,0,99,231,5,0,3,230,4,0,99,239,
1,0,128,239,4,0,93,102,0,0,44,102,72,253,224,97,234,5,68,86,
0,0,42,86,104,133,245,5,191,255,50,253,10,48,224,81,162,5,6,80,
35,239,1,0,35,255,9,0,35,231,5,0,76,26,127,0,84,26,99,255,
9,0,99,231,5,0,3,230,4,0,99,239,1,0,6,232,191,255,164,255,
224,81,178,5,106,239,1,0,35,239,1,0,35,255,9,0,35,231,5,0,
76,26,127,0,92,26,99,255,1,0,97,2,0,82,128,255,110,3,217,5,
10,48,191,255,190,255,31,82,35,255,1,0,68,26,127,0,88,26,99,255,
5,0,99,231,1,0,3,224,8,80,7,72,9,64,10,72,6,56,38,6,
7,0,4,0,191,255,196,255,35,255,5,0,35,231,1,0,72,26,127,0,
88,26,99,255,5,0,99,231,1,0,3,224,8,80,7,72,9,64,10,72,
6,56,38,6,1,0,4,0,191,255,152,255,35,255,5,0,35,231,1,0,
72,26,127,0,3,30,216,255,99,255,37,0,99,231,33,0,3,230,32,0,
99,239,21,0,6,232,99,215,29,0,7,208,99,223,25,0,8,216,191,255,
204,254,68,118,0,0,46,119,249,146,224,113,178,5,191,255,54,252,68,118,
0,0,46,119,245,146,224,113,178,5,191,255,94,244,68,118,0,0,46,119,
241,146,224,113,178,5,128,255,4,0,68,118,0,0,46,119,237,146,224,113,
194,5,0,50,191,255,152,252,68,118,0,0,46,119,233,146,224,113,242,5,
191,255,250,251,42,54,220,0,128,255,4,0,68,118,0,0,46,119,229,146,
224,113,178,5,128,255,4,0,224,233,218,21,67,239,2,0,67,7,3,0,
35,102,2,0,99,103,13,0,99,7,17,0,65,98,99,103,5,0,99,7,
9,0,35,222,4,0,35,214,12,0,1,234,68,14,0,0,97,223,109,133,
68,118,0,0,46,119,225,146,224,113,226,5,29,48,26,56,27,64,128,255,
4,0,29,48,26,56,27,64,191,255,236,210,10,48,191,255,12,253,35,215,
29,0,35,223,25,0,35,239,21,0,35,255,37,0,35,231,33,0,3,30,
40,0,127,0,88,0,96,0,106,0,116,0,132,0,142,0,152,0,162,0,
172,0,182,0,192,0,240,0,208,0,218,0,228,0,0,1,246,0,10,1,
20,1,30,1,40,1,50,1,84,1,98,1,114,1,130,1,148,1,164,1,
180,1,196,1,212,1,228,1,244,1,74,1,88,1,104,1,120,1,138,1,
154,1,170,1,186,1,202,1,218,1,234,1,128,7,33,0,224,7,68,1,
128,7,33,0,128,7,193,255,165,13,128,7,33,0,128,7,193,247,213,5,
128,7,33,0,128,7,193,243,240,239,64,0,224,7,68,1,128,7,33,0,
128,7,193,241,229,29,128,7,33,0,128,7,193,240,149,29,128,7,33,0,
128,7,193,112,197,21,128,7,33,0,128,7,193,48,245,13,128,7,33,0,
128,7,193,16,165,13,128,7,33,0,128,7,193,0,213,5,128,7,33,0,
128,7,65,0,240,239,64,0,224,7,68,1,128,7,33,0,128,7,193,255,
165,13,128,7,33,0,128,7,193,247,213,5,128,7,33,0,128,7,193,243,
128,7,78,0,128,7,33,0,213,37,128,7,33,0,128,7,193,240,229,29,
128,7,33,0,128,7,193,241,149,29,128,7,33,0,128,7,193,112,197,21,
128,7,33,0,128,7,193,48,245,13,128,7,33,0,128,7,193,16,165,13,
128,7,33,0,128,7,193,0,213,5,128,7,33,0,128,7,65,0,240,239,
64,0,240,87,64,0,234,95,253,255,171,25,106,0,240,255,64,0,255,103,
1,0,204,25,64,6,63,0,240,255,64,0,255,103,1,0,204,25,64,6,
192,255,133,21,240,255,64,0,255,103,1,0,204,25,64,6,192,247,133,13,
240,255,64,0,255,103,1,0,204,25,64,6,192,243,64,6,63,0,240,255,
64,0,255,103,1,0,204,25,64,6,192,241,133,53,240,255,64,0,255,103,
1,0,204,25,64,6,192,240,133,45,240,255,64,0,255,103,1,0,204,25,
64,6,192,112,133,37,240,255,64,0,255,103,1,0,204,25,64,6,192,48,
133,29,240,255,64,0,255,103,1,0,204,25,64,6,192,16,133,21,240,255,
64,0,255,103,1,0,204,25,64,6,192,0,133,13,240,255,64,0,255,103,
1,0,204,25,64,6,64,0,64,6,63,0,0,0,0,0,127,0,0,0,
48,85,129,0,0,0,0,0,21,0,0,0,88,85,129,0,0,0,0,0,
219,8,0,0,172,97,129,0,176,97,129,0,180,97,129,0,184,97,129,0,
188,97,129,0,192,97,129,0,196,97,129,0,200,97,129,0,204,97,129,0,
220,97,129,0,228,97,129,0,236,97,129,0,244,97,129,0,252,97,129,0,
4,98,129,0,12,98,129,0,104,98,129,0,112,98,129,0,120,98,129,0,
128,98,129,0,136,98,129,0,144,98,129,0,152,98,129,0,168,98,129,0,
176,98,129,0,184,98,129,0,192,98,129,0,200,98,129,0,208,98,129,0,
216,98,129,0,232,98,129,0,240,98,129,0,248,98,129,0,0,99,129,0,
8,99,129,0,16,99,129,0,24,99,129,0,40,99,129,0,48,99,129,0,
56,99,129,0,64,99,129,0,72,99,129,0,80,99,129,0,88,99,129,0,
104,99,129,0,112,99,129,0,120,99,129,0,128,99,129,0,136,99,129,0,
144,99,129,0,152,99,129,0,180,103,129,0,184,103,129,0,188,103,129,0,
192,103,129,0,196,103,129,0,200,103,129,0,204,103,129,0,208,103,129,0,
51,51,51,51,51,51,51,51,51,49,49,49,49,49,49,49,49,49,49,49,
49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,
49,49,49,49,49,49,49,49,49,49,49,177,177,177,177,177,177,177,177,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,238,238,34,34,187,187,85,85,73,78,86,65,
76,73,68,0,68,73,82,72,69,65,68,0,68,73,82,84,65,73,76,0,
67,79,77,80,95,48,51,0,67,79,77,80,95,48,52,0,67,79,77,80,
95,48,53,0,67,79,77,80,95,48,54,0,67,79,77,80,95,48,55,0,
67,79,77,80,95,48,56,0,36,86,69,82,86,69,82,36,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,67,104,101,99,107,105,110,103,32,102,108,97,115,104,32,109,
101,109,111,114,121,32,102,105,108,101,115,10,0,0,0,0,45,45,45,45,
45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,32,58,32,
32,45,45,45,45,45,45,45,45,45,45,32,32,45,45,45,45,45,45,45,
45,45,45,45,45,45,45,45,45,45,10,0,32,110,111,110,101,32,102,111,
117,110,100,10,109,97,114,107,105,110,103,32,108,97,115,116,32,118,97,108,
105,100,32,102,105,108,101,46,46,46,46,0,32,102,111,117,110,100,46,10,
76,105,110,107,105,110,103,32,118,97,108,105,100,32,102,105,108,101,115,46,
46,46,46,32,10,0,0,0,32,68,111,110,101,10,82,101,112,97,105,114,
32,99,111,109,112,108,101,116,101,100,32,115,117,99,99,101,115,115,102,117,
108,108,121,32,10,0,0,0,10,10,82,101,112,97,105,114,105,110,103,32,
116,104,101,32,102,108,97,115,104,32,102,105,108,101,32,115,121,115,116,101,
109,10,0,0,66,97,100,32,100,105,114,101,99,116,111,114,121,44,32,114,
101,112,97,105,114,32,97,98,111,114,116,101,100,10,0,0,48,120,37,48,
56,88,46,48,120,37,48,56,88,32,58,32,32,48,120,37,48,56,120,32,
32,37,54,100,32,40,61,37,35,120,41,10,0,0,0,0,118,97,108,105,
100,97,116,105,111,110,32,102,97,105,108,101,100,44,32,115,101,97,114,99,
104,105,110,103,32,102,111,114,32,118,97,108,105,100,32,102,105,108,101,115,
46,46,46,46,0,0,0,0,32,82,101,112,97,105,114,32,102,97,105,108,
101,100,32,10,0,0,0,0,86,97,108,105,100,97,116,105,110,103,32,102,
108,97,115,104,32,102,105,108,101,32,115,121,115,116,101,109,46,46,46,46,
46,10,115,105,103,110,97,116,117,114,101,49,46,115,105,103,110,97,116,117,
114,101,50,32,58,32,32,97,100,100,114,101,115,115,32,32,32,32,32,116,
111,116,97,108,32,115,105,122,101,10,0,0,85,110,115,117,112,112,111,114,
116,101,100,32,70,108,97,115,104,70,105,108,101,32,118,101,114,115,105,111,
110,32,40,97,100,100,114,61,48,120,37,88,41,10,0,0,102,108,97,115,
104,70,105,108,101,46,99,112,112,0,0,0,85,110,115,117,112,112,111,114,
116,101,100,32,70,108,97,115,104,70,105,108,101,32,118,101,114,115,105,111,
110,32,40,97,100,100,114,61,48,120,37,88,41,10,0,0,66,73,79,83,
32,105,109,97,103,101,32,110,111,116,32,102,111,117,110,100,32,105,110,32,
102,108,97,115,104,33,10,0,70,105,114,109,119,97,114,101,32,105,109,97,
103,101,32,110,111,116,32,102,111,117,110,100,32,105,110,32,102,108,97,115,
104,33,10,0,85,110,101,120,112,101,99,116,101,100,32,108,111,99,97,116,
105,111,110,32,111,102,32,70,105,114,109,119,97,114,101,32,105,110,32,102,
108,97,115,104,33,10,0,0,32,32,32,69,120,112,101,99,116,101,100,32,
97,100,100,114,58,32,37,120,32,32,32,32,65,99,116,117,97,108,32,97,
100,100,114,58,32,37,120,10,0,0,0,0,85,110,101,120,112,101,99,116,
101,100,32,115,105,122,101,32,111,102,32,70,105,114,109,119,97,114,101,32,
104,101,97,100,101,114,33,10,0,0,0,0,32,32,32,69,120,112,101,99,
116,101,100,32,115,105,122,101,58,32,37,120,32,32,32,32,65,99,116,117,
97,108,32,115,105,122,101,58,32,37,120,10,0,0,0,0,85,110,101,120,
112,101,99,116,101,100,32,108,111,99,97,116,105,111,110,32,111,102,32,66,
73,79,83,32,105,110,32,102,108,97,115,104,33,10,0,0,85,110,101,120,
112,101,99,116,101,100,32,115,105,122,101,32,111,102,32,66,73,79,83,32,
104,101,97,100,101,114,33,10,0,0,0,0,224,84,129,0,232,84,129,0,
240,84,129,0,248,84,129,0,0,85,129,0,8,85,129,0,16,85,129,0,
24,85,129,0,32,85,129,0,0,0,0,0,0,0,0,0,0,0,0,0,
2,25,128,0,0,0,0,0,2,25,128,0,0,0,0,0,2,25,128,0,
0,0,0,0,2,25,128,0,0,0,0,0,2,25,128,0,0,0,0,0,
2,25,128,0,0,0,0,0,2,25,128,0,16,0,0,0,8,0,0,0,
8,0,0,0,32,0,0,0,64,0,0,0,64,0,0,0,64,0,0,0,
64,0,0,0,64,0,0,0,64,0,0,0,64,0,0,0,64,0,0,0,
64,0,0,0,64,0,0,0,64,0,0,0,64,0,0,0,64,0,0,0,
64,0,0,0,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
88,12,128,0,0,0,0,0,232,11,128,0,0,0,0,0,186,11,128,0,
0,0,0,0,192,11,128,0,0,0,0,0,198,11,128,0,0,0,0,0,
204,11,128,0,0,0,0,0,226,11,128,0,0,0,0,0,0,0,0,0,
0,0,0,0,2,25,128,0,0,0,0,0,2,25,128,0,0,0,0,0,
2,25,128,0,0,0,0,0,2,25,128,0,0,0,0,0,2,25,128,0,
0,0,0,0,2,25,128,0,0,0,0,0,2,25,128,0,0,0,0,0,
0,0,0,0,0,0,0,0,126,17,128,0,0,0,0,0,224,16,128,0,
0,0,0,0,190,16,128,0,0,0,0,0,198,16,128,0,0,0,0,0,
206,16,128,0,0,0,0,0,2,25,128,0,0,0,0,0,214,16,128,0,
0,0,0,0,0,0,0,0,0,0,0,0,2,25,128,0,0,0,0,0,
2,25,128,0,0,0,0,0,2,25,128,0,0,0,0,0,2,25,128,0,
0,0,0,0,2,25,128,0,0,0,0,0,2,25,128,0,0,0,0,0,
2,25,128,0,0,0,0,0,0,0,0,0,0,0,0,0,122,20,128,0,
0,0,0,0,220,19,128,0,0,0,0,0,186,19,128,0,0,0,0,0,
194,19,128,0,0,0,0,0,202,19,128,0,0,0,0,0,2,25,128,0,
0,0,0,0,210,19,128,0,232,3,0,0,69,114,114,111,114,58,32,100,
101,116,101,99,116,101,100,32,109,105,115,109,97,116,99,104,32,105,110,32,
116,104,101,32,115,116,97,116,105,99,32,100,101,115,116,114,117,99,116,111,
114,32,111,114,100,101,114,105,110,103,32,115,116,114,97,116,101,103,121,10,
0,0,0,0,69,114,114,111,114,58,32,100,101,116,101,99,116,101,100,32,
109,105,115,109,97,116,99,104,32,105,110,32,116,104,101,32,115,116,97,116,
105,99,32,100,101,115,116,114,117,99,116,111,114,32,111,114,100,101,114,105,
110,103,32,115,116,114,97,116,101,103,121,10,0,0,0,0,0,0,0,0,
67,43,43,32,114,117,110,116,105,109,101,32,97,98,111,114,116,0,0,0,
102,114,101,101,105,110,103,32,97,114,114,97,121,32,110,111,116,32,97,108,
108,111,99,97,116,101,100,32,98,121,32,97,110,32,97,114,114,97,121,32,
110,101,119,32,111,112,101,114,97,116,105,111,110,0,0,0,116,101,114,109,
105,110,97,116,101,40,41,32,99,97,108,108,101,100,32,98,121,32,116,104,
101,32,101,120,99,101,112,116,105,111,110,32,104,97,110,100,108,105,110,103,
32,109,101,99,104,97,110,105,115,109,0,0,114,101,116,117,114,110,101,100,
32,102,114,111,109,32,97,32,117,115,101,114,45,100,101,102,105,110,101,100,
32,116,101,114,109,105,110,97,116,101,40,41,32,114,111,117,116,105,110,101,
0,0,0,0,109,97,105,110,40,41,32,99,97,108,108,101,100,32,109,111,
114,101,32,116,104,97,110,32,111,110,99,101,0,0,0,0,97,32,112,117,
114,101,32,118,105,114,116,117,97,108,32,102,117,110,99,116,105,111,110,32,
119,97,115,32,99,97,108,108,101,100,0,0,105,110,118,97,108,105,100,32,
100,121,110,97,109,105,99,32,99,97,115,116,0,0,0,0,105,110,118,97,
108,105,100,32,116,121,112,101,105,100,32,111,112,101,114,97,116,105,111,110,
0,0,0,0,105,110,116,101,114,110,97,108,32,101,114,114,111,114,58,32,
115,116,97,116,105,99,32,111,98,106,101,99,116,32,109,97,114,107,101,100,
32,102,111,114,32,100,101,115,116,114,117,99,116,105,111,110,32,109,111,114,
101,32,116,104,97,110,32,111,110,99,101,0,37,115,58,32,37,115,10,0,
0,0,0,0,40,110,117,108,108,41,0,0,48,49,50,51,52,53,54,55,
56,57,65,66,67,68,69,70,40,70,108,111,97,116,105,110,103,32,112,111,
105,110,116,32,111,117,116,112,117,116,32,117,110,115,117,112,112,111,114,116,
101,100,32,119,47,45,110,111,102,108,111,97,116,105,111,32,111,114,32,45,
102,110,111,110,101,41,0,0,20,0,65,77,0,80,77,0,0,0,83,117,
110,77,111,110,84,117,101,87,101,100,84,104,117,70,114,105,83,97,116,0,
0,0,74,97,110,70,101,98,77,97,114,65,112,114,77,97,121,74,117,110,
74,117,108,65,117,103,83,101,112,79,99,116,78,111,118,68,101,99,0,0,
0,0,83,117,110,100,97,121,0,77,111,110,100,97,121,0,84,117,101,115,
100,97,121,0,87,101,100,110,101,115,100,97,121,0,84,104,117,114,115,100,
97,121,0,70,114,105,100,97,121,0,83,97,116,117,114,100,97,121,0,0,
0,0,74,97,110,117,97,114,121,0,70,101,98,114,117,97,114,121,0,77,
97,114,99,104,0,65,112,114,105,108,0,77,97,121,0,74,117,110,101,0,
74,117,108,121,0,65,117,103,117,115,116,0,83,101,112,116,101,109,98,101,
114,0,79,99,116,111,98,101,114,0,78,111,118,101,109,98,101,114,0,68,
101,99,101,109,98,101,114,0,0,0,87,69,84,0,32,32,32,0,32,32,
32,0,32,32,32,0,65,83,84,0,69,83,84,0,67,83,84,0,77,83,
84,0,80,83,84,0,32,32,32,0,32,32,32,0,32,32,32,0,32,32,
32,0,32,32,32,0,32,32,32,0,32,32,32,0,32,32,32,0,32,32,
32,0,32,32,32,0,32,32,32,0,32,32,32,0,32,32,32,0,32,32,
32,0,77,69,84,0,69,69,84,0,32,32,32,0,44,32,108,105,110,101,
32,0,34,44,32,0,102,105,108,101,32,0,0,0,65,115,115,101,114,116,
105,111,110,32,102,97,105,108,101,100,58,32,0,0,95,117,110,107,110,111,
119,110,32,115,116,114,105,110,103,95,0,0,0,0,95,78,97,109,101,108,
101,115,115,95,0,71,77,84,0,32,32,32,0,31,28,31,30,31,30,31,
31,30,31,30,31,31,28,31,30,31,30,31,31,30,31,30,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,140,45,128,0,0,0,0,0,
48,37,128,0,248,44,128,0,64,48,32,16,68,51,34,17,3,0,24,0,
44,229,5,0,59,193,9,99,44,229,5,0,0,0,128,0,0,226,128,255,
4,0,31,232,8,72,7,64,6,56,97,2,0,82,32,54,20,0,133,255,
214,225,1,66,0,74,177,5,128,7,6,0,0,66,64,38,134,0,36,38,
248,228,64,30,155,0,35,30,4,156,28,10,65,25,4,38,0,64,4,38,
0,64,64,46,134,0,37,46,248,100,64,14,134,0,1,14,248,228,186,5,
128,7,6,0,1,240,93,86,3,0,42,86,10,218,234,167,32,0,128,166,
255,0,128,174,255,255,0,178,0,186,0,194,0,202,0,210,93,54,0,0,
38,54,230,0,128,255,216,1,128,7,0,0,6,80,198,94,3,0,178,5,
128,7,56,0,39,89,203,94,3,0,178,5,128,7,44,0,100,66,185,5,
128,7,36,0,6,96,200,97,130,98,194,98,39,95,1,0,68,58,102,95,
1,0,68,50,230,97,179,5,191,7,240,255,200,70,3,0,224,65,186,5,
128,7,28,0,6,96,200,97,7,95,0,0,65,58,70,95,0,0,65,50,
230,97,179,5,191,7,240,255,127,0,0,0,1,0,0,0,0,0,0,0,
124,13,133,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,128,7,193,0,7,16,6,72,8,232,194,233,9,224,32,70,
238,15,0,50,245,93,129,50,198,142,0,1,224,137,138,13,65,18,2,134,
255,255,144,87,1,0,138,54,0,255,198,126,1,0,224,121,194,21,65,18,
2,118,255,255,142,87,1,0,65,74,9,110,255,255,10,96,172,0,12,88,
139,0,77,95,0,0,8,86,1,0,202,70,255,15,197,61,65,18,2,142,
255,255,145,87,1,0,65,18,2,134,255,255,144,63,1,0,199,126,240,0,
15,112,196,114,14,81,199,110,15,0,13,62,3,0,8,96,170,97,9,104,
172,105,234,65,191,5,13,110,0,240,0,98,133,13,65,74,9,94,255,255,
75,7,0,0,65,106,65,98,252,105,161,5,245,13,231,97,214,245,197,13,
65,74,9,86,255,255,65,106,13,142,255,255,145,135,1,0,74,135,0,0,
65,98,231,97,198,245,7,120,200,121,207,70,255,15,253,17,154,165,64,6,
223,0,8,16,198,17,7,136,145,0,17,72,6,62,255,255,8,6,223,255,
169,45,9,136,200,138,9,128,16,137,17,120,208,122,15,137,197,5,95,18,
66,79,0,0,194,118,15,0,224,113,170,253,16,106,6,112,77,113,245,13,
98,143,1,0,2,102,4,0,108,143,1,0,2,94,8,0,107,143,1,0,
2,86,12,0,106,143,1,0,80,18,238,17,138,245,2,22,16,0,181,5,
66,79,0,0,95,18,231,17,202,253,6,16,2,80,127,0,138,7,225,243,
7,184,8,176,99,79,1,0,59,6,128,5,128,0,41,6,230,1,128,0,
60,6,136,0,128,0,40,6,244,225,133,0,0,234,9,56,27,248,6,142,
16,0,49,215,1,0,6,134,20,0,48,207,1,0,6,126,24,0,47,23,
1,0,6,118,28,0,46,127,1,0,2,112,186,113,99,7,5,0,35,102,
4,0,12,110,4,0,109,7,1,0,35,86,4,0,10,94,8,0,107,7,
1,0,35,134,4,0,16,142,12,0,113,7,1,0,226,65,177,5,232,121,
187,5,14,232,128,233,226,57,177,5,231,121,251,5,14,80,201,81,10,72,
14,80,220,81,10,224,255,17,235,5,239,249,201,5,249,209,162,5,174,217,
239,17,146,13,26,48,2,56,162,121,15,64,63,6,16,3,128,0,124,0,
46,6,244,225,133,0,29,224,206,225,45,6,48,226,133,0,29,208,205,209,
133,29,68,226,28,102,252,255,35,86,4,0,10,94,12,0,43,23,1,0,
44,143,1,0,209,17,60,87,1,0,68,226,60,95,1,0,68,226,2,48,
10,56,11,64,191,255,150,254,250,225,138,237,48,6,48,226,133,0,29,224,
208,225,47,6,120,226,133,0,29,208,207,209,46,6,120,226,133,0,29,200,
206,201,133,45,250,225,137,13,35,102,4,0,12,110,12,0,45,23,1,0,
245,5,35,86,4,0,10,94,4,0,43,23,1,0,60,143,1,0,209,17,
68,226,68,226,28,134,252,255,35,118,4,0,14,126,4,0,47,87,1,0,
48,111,1,0,205,81,60,95,1,0,68,226,2,48,10,56,11,64,191,255,
198,252,249,225,138,221,44,6,120,226,133,0,29,224,204,225,43,6,132,226,
133,0,29,208,203,209,165,53,68,226,28,86,252,255,35,134,4,0,16,142,
12,0,49,255,1,0,42,127,1,0,207,249,68,226,28,118,252,255,35,102,
4,0,12,110,4,0,45,207,1,0,46,95,1,0,203,201,68,226,28,86,
252,255,42,199,1,0,64,86,0,0,3,90,106,95,10,248,31,48,25,56,
24,142,15,0,16,122,17,128,79,129,16,64,191,255,84,252,64,86,0,0,
0,90,106,95,10,248,250,225,225,205,46,6,120,226,133,0,29,224,206,225,
45,6,120,226,133,0,29,208,205,209,44,6,120,226,133,0,29,200,204,201,
133,45,250,225,137,13,35,86,4,0,10,94,12,0,43,23,1,0,245,5,
35,134,4,0,16,142,4,0,49,23,1,0,60,127,1,0,207,17,68,226,
68,226,28,118,252,255,35,102,4,0,12,110,4,0,45,87,1,0,46,95,
1,0,203,81,60,95,1,0,68,226,2,48,10,56,11,64,191,255,92,252,
249,225,138,221,42,6,132,226,133,0,29,16,202,17,49,6,184,226,133,0,
29,224,209,225,48,6,184,226,133,0,208,233,226,225,146,77,35,118,4,0,
14,126,12,0,44,6,0,0,0,0,47,95,1,0,12,104,171,105,173,225,
197,61,65,234,29,86,255,255,10,215,0,0,218,142,48,0,17,128,164,130,
16,112,194,114,14,120,35,102,4,0,15,104,204,105,45,103,1,0,68,18,
2,94,252,255,43,87,1,0,12,200,202,201,57,79,1,0,218,142,128,0,
224,137,178,5,224,73,178,29,218,134,3,0,16,112,194,114,14,120,35,102,
4,0,15,104,204,105,45,103,1,0,224,97,226,13,218,94,8,0,224,89,
162,5,194,74,204,73,218,86,8,0,224,81,162,5,162,74,121,79,1,0,
252,17,202,197,23,48,22,56,35,71,1,0,63,6,124,5,128,0,123,0,
74,6,255,243,128,7,225,0,6,232,7,224,37,159,37,128,224,153,178,5,
130,255,116,141,37,159,33,128,224,153,178,5,130,255,8,185,37,159,29,128,
224,153,178,5,128,255,4,0,37,159,25,128,224,153,194,5,0,50,130,255,
230,207,29,48,28,136,17,56,128,255,226,5,64,6,255,0,132,7,97,0,
7,16,8,56,32,71,169,182,6,72,40,71,41,0,99,23,1,0,38,6,
124,13,133,0,130,255,34,181,196,255,96,144,218,29,196,63,96,144,0,50,
130,255,208,35,1,138,99,143,5,0,31,50,128,255,40,0,61,6,216,228,
152,0,29,48,31,58,128,255,34,0,224,81,186,253,35,135,5,0,224,129,
210,5,99,7,5,0,128,255,22,0,133,5,33,6,52,99,0,0,97,0,
33,6,8,199,1,0,97,0,33,6,48,99,0,0,97,0,128,7,225,112,
7,216,251,0,6,200,32,54,50,0,130,255,234,160,10,232,29,48,39,6,
160,13,133,0,130,255,194,64,27,56,29,64,38,6,172,13,133,0,130,255,
156,180,29,48,130,255,228,160,229,87,64,0,224,7,96,1,36,135,145,137,
10,208,16,6,216,255,158,21,36,127,137,137,65,122,100,127,137,137,15,6,
216,255,182,5,100,7,137,137,36,119,145,137,65,114,100,119,145,137,181,5,
32,222,255,0,36,231,137,137,43,6,200,101,134,0,0,58,32,70,124,0,
199,226,203,225,60,238,4,0,29,48,191,255,32,251,29,48,27,56,25,64,
32,78,124,0,129,255,158,47,156,143,5,0,17,6,143,255,210,13,28,127,
29,0,32,134,113,0,92,135,4,0,207,126,248,0,143,126,4,0,92,127,
29,0,36,111,245,178,124,111,1,0,250,47,32,0,64,6,255,112,128,7,
225,16,6,224,229,87,64,0,224,7,96,1,36,143,145,137,10,216,60,54,
4,0,32,70,124,0,224,137,135,37,36,239,141,137,46,6,200,101,134,0,
199,234,206,233,61,62,4,0,191,255,76,249,61,111,1,0,36,103,141,137,
124,111,1,0,65,98,100,103,141,137,12,6,216,255,182,5,100,7,141,137,
36,95,145,137,95,90,100,95,145,137,245,13,0,58,191,255,124,250,124,7,
26,0,32,86,112,0,92,87,4,0,10,138,92,143,11,0,124,7,1,0,
251,47,32,0,64,6,255,16,71,7,0,0,71,7,1,0,2,82,127,0,
3,30,216,255,99,79,37,0,99,255,21,0,99,239,9,0,99,231,13,0,
6,224,252,0,99,223,17,0,7,216,99,71,33,0,35,142,32,0,99,143,
1,0,35,134,24,0,208,126,7,0,99,127,5,0,32,54,255,0,130,255,
102,159,35,71,1,0,35,79,5,0,10,232,29,48,27,56,130,255,252,168,
229,87,64,0,224,7,96,1,10,216,29,48,28,56,191,255,74,254,196,231,
96,144,242,5,32,110,0,16,64,14,32,0,97,111,20,0,251,47,32,0,
29,48,130,255,66,159,35,223,17,0,35,231,13,0,35,239,9,0,35,255,
21,0,3,30,40,0,127,0,128,7,225,16,0,218,60,6,200,101,134,0,
28,238,4,0,124,7,1,0,29,48,0,58,32,70,124,0,191,255,158,249,
125,7,22,0,28,230,128,0,29,238,128,0,65,218,27,6,216,255,246,237,
32,142,40,0,100,143,137,137,100,7,141,137,100,7,145,137,64,6,255,16,
6,6,240,255,185,5,128,7,136,1,198,50,36,118,148,137,14,22,20,0,
198,17,8,106,98,111,0,0,66,7,2,0,32,102,231,255,66,103,3,0,
14,22,12,0,198,17,32,142,8,1,98,143,0,0,32,134,64,0,66,135,
2,0,32,126,66,0,66,127,3,0,14,22,16,0,198,17,98,143,0,0,
66,135,2,0,66,127,3,0,6,136,206,137,32,126,9,1,113,127,0,0,
14,104,6,112,205,113,78,135,2,0,6,88,205,89,32,142,37,0,75,143,
3,0,13,22,4,0,198,17,32,118,9,1,98,119,0,0,66,135,2,0,
66,143,3,0,13,22,8,0,198,17,98,119,0,0,66,135,2,0,66,143,
3,0,36,110,148,137,13,22,24,0,198,17,32,102,11,1,98,103,0,0,
66,135,2,0,32,86,53,0,66,87,3,0,13,126,28,0,198,121,111,103,
0,0,13,94,28,0,198,89,32,86,64,0,75,87,2,0,13,126,28,0,
198,121,32,118,53,0,79,119,3,0,13,94,32,0,198,89,32,86,11,1,
107,87,0,0,13,126,32,0,198,121,32,118,64,0,79,119,2,0,13,94,
32,0,198,89,32,86,53,0,75,87,3,0,13,126,36,0,198,121,32,118,
11,1,111,119,0,0,13,94,36,0,198,89,32,86,64,0,75,87,2,0,
13,126,36,0,198,121,32,118,53,0,79,119,3,0,13,94,40,0,198,89,
32,86,11,1,107,87,0,0,13,126,40,0,198,121,32,118,64,0,79,119,
2,0,13,94,40,0,198,89,32,86,53,0,75,87,3,0,13,126,44,0,
198,121,32,118,11,1,111,119,0,0,13,94,44,0,198,89,32,86,64,0,
75,87,2,0,13,134,44,0,208,49,32,118,53,0,70,119,3,0,127,0,
6,6,240,255,185,5,128,7,120,1,198,50,36,118,148,137,14,22,20,0,
198,17,8,106,98,111,0,0,66,7,2,0,32,102,231,255,66,103,3,0,
14,22,12,0,198,17,98,111,0,0,32,134,224,255,66,135,2,0,32,126,
64,0,66,127,3,0,14,22,16,0,198,17,8,98,98,103,0,0,66,135,
2,0,66,127,3,0,6,136,206,137,9,122,113,127,0,0,14,104,6,112,
205,113,78,135,2,0,6,88,205,89,32,142,200,255,75,143,3,0,13,22,
4,0,198,17,9,114,98,119,0,0,66,135,2,0,66,143,3,0,13,22,
8,0,198,17,98,119,0,0,66,135,2,0,66,143,3,0,36,110,148,137,
13,22,24,0,198,17,11,98,98,103,0,0,66,135,2,0,32,86,202,255,
66,87,3,0,13,126,28,0,198,121,111,103,0,0,13,94,28,0,198,89,
32,86,224,255,75,87,2,0,13,126,28,0,198,121,32,118,202,255,79,119,
3,0,13,94,32,0,198,89,11,82,107,87,0,0,13,126,32,0,198,121,
32,118,224,255,79,119,2,0,13,94,32,0,198,89,32,86,202,255,75,87,
3,0,13,126,36,0,198,121,11,114,111,119,0,0,13,94,36,0,198,89,
32,86,224,255,75,87,2,0,13,126,36,0,198,121,32,118,202,255,79,119,
3,0,13,94,40,0,198,89,11,82,107,87,0,0,13,126,40,0,198,121,
32,118,224,255,79,119,2,0,13,94,40,0,198,89,32,86,202,255,75,87,
3,0,13,126,44,0,198,121,11,114,111,119,0,0,13,94,44,0,198,89,
32,86,224,255,75,87,2,0,13,134,44,0,208,49,32,118,202,255,70,119,
3,0,127,0,128,7,97,0,0,234,29,48,191,255,120,254,65,234,29,6,
240,255,166,253,64,6,127,0,32,86,0,1,127,0,128,7,225,16,6,232,
189,0,7,224,188,0,130,255,22,150,29,48,28,56,128,255,154,82,128,255,
174,0,129,255,56,81,10,216,130,255,136,31,224,217,194,5,27,48,128,255,
54,76,38,6,100,16,133,0,130,255,46,175,59,6,0,16,133,0,27,48,
130,255,34,175,37,54,40,128,130,255,26,175,38,6,152,16,133,0,130,255,
16,175,38,6,36,16,133,0,32,62,24,0,32,70,28,0,130,255,254,174,
38,6,68,16,133,0,4,58,9,66,130,255,240,174,38,6,188,16,133,0,
39,6,216,16,133,0,40,6,228,16,133,0,130,255,218,174,38,6,16,16,
133,0,130,255,208,174,28,56,29,64,38,6,240,16,133,0,130,255,194,174,
37,54,40,128,130,255,186,174,27,48,130,255,180,174,37,54,40,128,130,255,
172,174,130,255,158,130,0,82,64,6,255,16,33,6,192,106,0,0,97,0,
194,50,36,118,236,135,206,49,38,23,1,0,128,110,0,160,98,111,8,0,
127,0,128,7,225,0,4,143,232,135,7,224,6,232,224,137,194,13,128,255,
10,4,29,48,128,255,12,4,224,225,210,5,32,54,136,19,130,255,188,58,
64,6,255,0,6,136,194,138,36,118,212,141,206,137,49,23,1,0,193,50,
36,86,20,142,202,49,230,143,1,0,32,54,232,3,145,142,0,128,98,143,
0,0,130,7,142,58,6,136,194,138,36,118,212,141,206,137,49,23,1,0,
193,50,36,86,20,142,202,49,230,143,1,0,32,54,232,3,145,142,0,64,
98,143,0,0,130,7,100,58,194,50,36,118,212,141,39,87,18,0,206,49,
38,79,1,0,32,22,223,255,74,17,234,17,178,5,130,22,160,0,194,102,
0,1,130,0,250,29,7,95,8,0,200,90,11,17,105,23,16,0,7,119,
12,0,39,103,10,0,200,114,140,0,14,97,105,103,18,0,7,143,14,0,
167,127,13,0,200,138,17,121,105,127,20,0,7,103,17,0,167,87,15,0,
200,98,12,81,245,45,7,135,9,0,200,130,144,134,12,0,105,135,16,0,
7,111,15,0,39,95,10,0,200,106,168,90,13,89,105,95,18,0,105,7,
20,0,105,7,22,0,7,135,8,0,200,130,16,17,105,23,16,0,7,95,
12,0,39,143,10,0,200,90,145,0,11,137,105,143,18,0,7,119,14,0,
167,103,13,0,200,114,14,97,105,103,20,0,7,87,17,0,200,82,135,135,
17,0,10,129,105,135,22,0,127,0,128,7,225,0,6,232,29,136,194,138,
36,118,212,141,206,137,49,231,1,0,29,104,193,106,36,86,20,142,202,105,
237,143,1,0,10,50,145,142,224,0,124,143,0,0,252,23,1,0,130,255,
102,57,193,234,36,102,20,142,204,233,253,95,1,0,124,95,0,0,252,23,
1,0,64,6,255,0,194,50,36,118,236,135,206,49,38,23,1,0,32,110,
0,80,98,111,8,0,127,0,6,136,194,138,36,118,212,141,206,137,49,23,
1,0,6,104,193,106,36,86,20,142,202,105,237,143,1,0,145,142,0,16,
98,143,0,0,128,7,84,2,194,50,36,118,212,141,206,49,38,23,1,0,
6,106,32,102,128,0,98,111,16,0,98,103,22,0,226,23,1,0,127,0,
128,7,97,0,194,50,36,118,212,141,206,49,38,239,1,0,6,106,4,98,
10,50,125,111,16,0,125,103,22,0,253,23,1,0,130,255,202,56,6,90,
125,95,16,0,125,7,22,0,253,23,1,0,32,54,136,19,130,255,180,56,
64,6,127,0,128,7,97,0,6,232,29,136,194,138,36,118,212,141,206,137,
49,23,1,0,29,104,193,106,36,86,20,142,202,105,237,143,1,0,32,54,
100,0,145,142,0,1,98,143,0,0,226,23,1,0,130,255,122,56,29,48,
191,255,222,254,32,54,184,11,130,255,108,56,64,6,127,0,128,7,225,241,
68,55,232,135,224,49,226,5,38,6,12,17,133,0,130,255,244,171,0,226,
128,255,152,1,0,186,0,210,56,6,200,221,136,0,26,136,194,138,36,118,
236,135,206,137,49,223,1,0,59,239,8,0,59,207,8,0,216,234,156,234,
217,206,15,0,98,202,202,69,99,234,170,69,23,104,65,186,224,105,154,29,
24,48,32,62,32,0,9,66,191,255,138,242,88,7,8,0,29,102,48,0,
88,103,0,0,32,94,46,0,88,95,1,0,25,86,48,0,88,87,2,0,
32,142,48,0,88,143,3,0,26,56,29,64,25,72,38,6,24,17,133,0,
130,255,118,171,0,106,28,96,194,98,27,16,36,86,212,141,204,81,36,94,
148,141,204,89,107,223,1,0,106,23,1,0,68,98,68,82,68,90,65,226,
2,22,32,0,65,106,100,106,198,245,26,48,128,255,244,0,26,48,191,255,
80,254,65,210,99,210,166,173,97,186,193,61,130,45,99,186,193,21,138,61,
32,254,40,241,223,191,0,0,64,86,0,0,0,90,74,95,144,244,32,254,
40,241,223,183,0,0,64,86,0,0,0,90,74,95,144,244,32,254,38,241,
223,191,0,0,64,86,0,0,0,90,74,95,144,244,32,254,38,241,223,183,
0,0,64,86,0,0,0,90,74,95,144,244,32,254,36,241,223,191,0,0,
64,86,0,0,0,90,74,95,144,244,32,254,36,241,223,183,0,0,64,86,
0,0,0,90,74,95,144,244,245,13,23,56,38,6,44,17,133,0,130,255,
176,170,23,64,38,6,64,17,133,0,32,62,182,0,191,255,98,245,32,70,
16,0,28,6,240,255,190,5,28,64,232,0,4,63,233,135,100,71,234,135,
232,0,232,57,195,13,224,57,231,5,38,6,76,17,133,0,130,255,118,170,
36,135,234,135,68,135,233,135,64,6,255,241,33,6,190,23,0,0,97,0,
33,6,142,23,0,0,97,0,33,6,224,101,0,0,97,0,33,6,164,24,
0,0,97,0,92,26,166,143,43,0,134,135,45,0,166,127,45,0,134,119,
47,0,67,143,3,0,67,135,2,0,67,127,1,0,67,119,0,0,35,87,
1,0,68,26,127,0,128,7,225,0,6,232,61,87,113,0,157,127,1,0,
7,88,8,104,42,23,37,0,15,112,14,56,11,64,34,135,40,0,34,103,
45,0,141,0,13,72,16,48,202,49,63,6,30,17,128,0,108,0,125,87,
2,0,10,48,230,0,224,49,178,13,6,224,129,255,158,38,28,56,10,64,
38,6,144,17,133,0,130,255,204,169,61,87,2,0,64,6,255,0,128,7,
225,48,6,208,58,54,41,0,0,58,32,70,35,0,191,255,144,240,58,87,
113,0,154,127,1,0,42,23,37,0,15,112,58,70,41,0,32,78,35,0,
34,135,48,0,34,111,53,0,14,56,63,6,134,17,128,0,16,48,202,49,
109,0,122,87,2,0,186,223,41,0,10,136,241,0,224,137,138,37,177,0,
99,218,198,5,27,6,220,255,201,5,32,22,138,3,149,21,0,18,58,94,
41,0,245,5,139,87,1,0,65,90,65,18,202,137,177,0,251,17,150,253,
224,137,210,5,32,22,21,3,122,23,2,0,58,135,2,0,224,129,226,37,
58,239,2,0,29,48,129,255,240,37,29,56,10,64,38,6,192,17,133,0,
130,255,30,169,0,234,58,230,41,0,133,21,29,6,237,255,218,5,37,54,
44,128,130,255,8,169,156,63,1,0,37,54,48,128,130,255,252,168,65,226,
65,234,251,233,134,245,37,54,44,128,130,255,236,168,58,87,2,0,64,6,
255,48,128,7,225,0,6,232,61,87,113,0,157,127,1,0,7,88,8,104,
42,23,37,0,15,112,14,56,11,64,34,135,56,0,34,103,61,0,141,0,
13,72,16,48,202,49,63,6,90,18,128,0,108,0,125,87,2,0,10,48,
230,0,224,49,178,13,6,224,129,255,98,37,28,56,10,64,38,6,240,17,
133,0,130,255,144,168,61,87,2,0,64,6,255,0,132,7,225,241,196,239,
84,144,6,200,64,190,32,0,168,0,167,0,162,13,4,23,84,144,221,18,
159,18,218,5,32,86,134,3,128,7,52,1,8,102,3,0,89,103,4,0,
89,63,5,0,0,18,0,82,57,94,4,0,12,110,255,255,245,5,139,135,
1,0,65,90,65,82,176,17,162,0,237,81,150,253,217,97,76,23,3,0,
35,78,4,0,99,7,1,0,32,54,12,177,64,62,32,0,1,66,128,255,
230,19,89,7,76,0,57,198,77,0,165,13,38,6,104,23,133,0,130,255,
8,168,32,54,94,1,130,255,246,119,153,71,5,0,57,62,4,0,25,48,
191,255,18,255,10,216,224,81,218,93,35,78,4,0,32,142,200,0,99,143,
1,0,32,54,12,177,64,62,32,0,1,66,128,255,156,19,224,81,218,5,
35,127,5,0,150,122,241,13,32,222,22,3,32,54,22,3,129,255,126,36,
10,64,38,6,148,23,133,0,32,62,22,3,130,255,170,167,153,215,77,0,
27,6,118,252,202,5,32,214,35,0,229,13,224,217,202,13,152,95,1,0,
224,89,178,45,171,0,32,222,0,3,171,217,251,0,224,217,194,37,27,48,
129,255,62,36,27,56,10,64,38,6,172,23,133,0,130,255,108,167,0,234,
24,230,255,255,133,21,29,6,237,255,218,5,37,54,56,128,130,255,86,167,
156,63,1,0,37,54,60,128,130,255,74,167,65,226,65,234,250,233,134,245,
37,54,56,128,130,255,58,167,27,6,254,252,162,149,27,80,68,6,255,241,
128,7,225,112,6,216,59,143,125,0,7,232,8,224,0,202,224,137,226,215,
0,0,130,13,59,54,116,0,31,58,191,255,54,242,224,81,170,253,27,48,
191,255,66,253,224,81,194,13,224,209,178,125,32,54,12,177,64,62,32,0,
0,66,128,255,190,18,128,7,2,1,155,23,43,0,2,134,128,255,93,23,
0,0,144,0,16,6,237,255,185,53,224,209,146,21,59,54,76,0,59,62,
41,0,32,70,35,0,191,255,66,236,32,54,12,177,64,62,32,0,0,66,
128,255,132,18,197,101,38,6,252,23,133,0,130,255,166,166,0,234,59,230,
41,0,133,13,29,6,237,255,218,5,37,54,68,128,130,255,144,166,156,63,
1,0,37,54,72,128,130,255,132,166,65,226,65,234,29,6,221,255,249,237,
37,54,68,128,130,255,114,166,197,53,2,142,112,255,99,138,137,13,27,48,
191,255,28,252,124,87,1,0,1,202,149,45,16,6,240,255,193,21,27,48,
191,255,8,252,61,6,16,24,134,0,29,48,10,64,37,62,80,128,130,255,
114,156,29,56,38,6,28,24,133,0,130,255,48,166,181,21,38,6,228,23,
133,0,130,255,36,166,29,127,0,0,38,6,52,24,133,0,207,62,255,0,
130,255,18,166,37,54,68,128,130,255,10,166,224,209,250,13,59,54,116,0,
128,255,216,17,224,81,146,13,38,6,64,24,133,0,32,62,178,1,0,66,
191,255,172,240,25,80,138,0,64,6,255,112,128,7,33,0,64,86,0,0,
10,87,10,244,138,0,129,82,153,13,32,54,12,177,64,62,16,0,0,66,
128,255,148,17,197,5,0,50,128,255,178,37,32,254,30,241,223,191,0,0,
64,86,0,0,0,90,74,95,144,244,64,6,63,0,132,7,225,112,6,208,
7,200,217,0,8,224,9,232,28,6,223,255,201,5,32,86,33,3,229,69,
224,225,202,5,28,80,234,0,149,69,58,222,116,0,99,223,1,0,1,122,
67,127,4,0,27,48,31,58,191,255,148,240,224,81,186,253,28,126,2,0,
25,112,168,114,90,119,6,0,90,207,7,0,4,18,58,86,8,0,28,94,
4,0,133,13,157,135,1,0,65,234,65,18,74,135,0,0,65,82,235,17,
134,253,26,48,15,64,168,0,7,58,191,255,168,252,131,111,5,0,10,224,
224,105,146,21,35,55,1,0,67,7,4,0,128,255,240,16,224,81,146,13,
38,6,76,24,133,0,32,62,178,1,0,66,191,255,196,239,28,80,68,6,
255,112,128,7,218,16,128,7,225,16,6,232,191,255,46,251,10,224,224,225,
178,5,128,7,216,1,157,135,43,0,0,18,16,118,128,255,142,0,14,6,
240,255,193,5,100,114,161,5,1,18,130,0,224,17,170,13,16,94,112,255,
99,90,225,5,130,0,224,17,186,5,128,7,154,1,29,48,191,255,104,250,
59,6,16,24,134,0,10,232,27,48,29,64,37,62,92,128,130,255,208,154,
27,56,38,6,228,24,133,0,130,255,142,164,64,134,0,128,93,129,186,5,
128,7,14,1,29,112,159,114,225,5,38,6,104,24,133,0,130,255,114,164,
29,96,155,98,233,5,38,6,88,24,133,0,130,255,98,164,38,6,136,24,
133,0,29,80,147,82,201,5,38,6,248,24,133,0,130,255,76,164,64,62,
48,0,93,57,148,58,167,0,38,6,12,25,133,0,130,255,56,164,37,54,
88,128,221,94,0,64,194,5,38,6,28,25,133,0,130,255,36,164,38,6,
156,24,133,0,221,86,0,32,194,5,38,6,40,25,133,0,130,255,14,164,
221,142,0,16,226,5,38,6,52,25,133,0,130,255,254,163,221,134,0,8,
226,5,38,6,76,25,133,0,130,255,238,163,221,126,0,128,226,5,38,6,
168,24,133,0,130,255,222,163,64,118,1,0,93,113,226,5,38,6,100,25,
133,0,130,255,204,163,29,96,146,98,233,5,38,6,184,24,133,0,130,255,
188,163,221,86,0,4,226,5,38,6,120,25,133,0,130,255,172,163,221,142,
64,0,226,5,38,6,140,25,133,0,130,255,156,163,221,134,8,0,226,5,
38,6,156,25,133,0,130,255,140,163,38,6,168,25,133,0,29,120,151,122,
137,13,38,6,204,24,133,0,197,5,38,6,192,25,133,0,130,255,110,163,
221,70,7,0,130,13,100,66,177,29,146,13,102,66,177,13,226,13,229,21,
39,6,32,18,133,0,213,21,39,6,88,18,133,0,149,21,39,6,136,18,
133,0,213,13,39,6,48,18,133,0,156,234,129,13,39,6,168,18,133,0,
197,5,39,6,192,18,133,0,38,6,116,24,133,0,130,255,32,163,133,13,
38,6,212,25,133,0,130,255,20,163,32,230,129,3,28,80,64,6,255,16,
132,7,225,16,6,224,7,216,155,0,60,238,116,0,99,239,1,0,1,130,
67,135,4,0,29,48,31,58,191,255,20,238,224,81,186,253,92,223,6,0,
28,48,8,58,1,66,191,255,84,250,131,127,5,0,10,232,224,121,146,21,
35,55,1,0,67,7,4,0,128,255,156,14,224,81,146,13,38,6,240,25,
133,0,32,62,178,1,0,66,191,255,112,237,29,80,68,6,255,16,132,7,
225,0,6,224,60,238,116,0,99,239,1,0,1,130,67,135,4,0,29,48,
31,58,191,255,182,237,224,81,186,253,28,48,3,58,0,66,191,255,250,249,
131,127,5,0,10,232,224,121,146,21,35,55,1,0,67,7,4,0,128,255,
66,14,224,81,146,13,38,6,252,25,133,0,32,62,178,1,0,66,191,255,
22,237,29,80,68,6,255,0,132,7,225,0,6,224,60,238,116,0,99,239,
1,0,1,130,67,135,4,0,29,48,31,58,191,255,92,237,224,81,186,253,
28,48,2,58,0,66,191,255,160,249,131,127,5,0,10,232,224,121,146,21,
35,55,1,0,67,7,4,0,128,255,232,13,224,81,146,13,38,6,8,26,
133,0,32,62,178,1,0,66,191,255,188,236,29,80,68,6,255,0,130,7,
225,240,0,226,0,210,6,216,8,232,61,55,5,0,0,202,7,192,37,62,
220,128,130,255,34,163,224,81,146,13,61,55,5,0,37,62,144,128,130,255,
18,163,224,81,154,29,61,55,9,0,32,70,16,0,0,58,130,255,96,180,
10,200,25,48,130,255,224,141,10,208,224,209,186,13,61,63,9,0,38,6,
128,27,133,0,25,64,130,255,152,161,128,7,80,7,61,55,5,0,37,62,
220,128,130,255,210,162,224,81,202,29,27,48,26,56,25,64,136,0,191,255,
92,247,10,224,38,6,20,26,133,0,130,255,108,161,0,234,26,216,149,13,
155,63,1,0,37,54,100,128,130,255,90,161,65,218,65,234,249,233,241,245,
128,7,222,6,61,55,5,0,37,62,144,128,130,255,140,162,224,81,154,37,
10,224,28,16,194,18,194,233,29,198,12,0,28,232,218,233,213,13,56,55,
1,0,32,70,16,0,0,58,130,255,200,179,68,194,93,87,0,0,65,234,
65,226,249,225,177,245,27,48,26,56,25,64,136,0,191,255,36,248,10,224,
128,7,142,6,61,55,5,0,39,6,36,26,133,0,130,255,58,162,224,81,
186,13,129,255,78,181,10,56,38,6,48,26,133,0,130,255,220,160,128,7,
104,6,61,55,5,0,37,62,228,128,130,255,22,162,224,81,146,13,61,55,
5,0,37,62,236,128,130,255,6,162,224,81,218,77,61,55,5,0,37,62,
236,128,130,255,246,161,224,81,202,5,59,206,41,0,181,5,59,206,76,0,
38,6,84,26,133,0,130,255,148,160,0,234,25,216,155,63,1,0,37,54,
152,128,130,255,132,160,29,6,239,255,138,13,38,6,232,26,133,0,32,62,
34,0,130,255,112,160,65,218,65,234,29,6,221,255,201,237,38,6,172,27,
133,0,130,255,92,160,0,234,25,216,155,23,1,0,32,62,126,0,2,102,
224,255,12,6,161,255,161,5,2,56,37,54,240,128,130,255,60,160,29,6,
239,255,234,5,38,6,0,27,133,0,130,255,44,160,65,218,65,234,29,6,
221,255,233,229,181,37,61,55,5,0,37,62,248,128,130,255,94,161,224,81,
154,37,38,6,196,27,133,0,130,255,6,160,0,234,68,218,155,63,1,0,
37,54,152,128,130,255,246,159,29,6,236,255,234,5,38,6,104,26,133,0,
130,255,230,159,65,218,65,234,29,6,219,255,233,237,37,54,160,128,130,255,
212,159,128,7,96,5,61,55,5,0,37,62,164,128,130,255,14,161,224,81,
234,37,99,194,162,13,36,63,69,142,38,6,216,27,133,0,130,255,174,159,
128,7,58,5,61,55,9,0,10,66,0,58,130,255,72,178,10,232,29,56,
38,6,124,26,133,0,130,255,144,159,98,234,217,5,100,239,69,142,128,7,
20,5,38,6,152,26,133,0,130,255,122,159,128,7,6,5,61,55,5,0,
37,62,0,129,130,255,180,160,224,81,202,45,32,54,35,0,130,255,144,139,
61,55,9,0,10,208,0,58,10,66,130,255,250,177,10,232,189,0,26,200,
229,21,0,18,25,80,32,94,85,0,74,95,0,0,65,82,65,18,2,6,
221,255,166,253,27,48,26,72,128,62,16,224,10,66,191,255,132,249,10,224,
95,234,189,0,224,233,170,237,26,48,130,255,98,139,128,7,160,4,61,55,
5,0,37,62,172,128,130,255,78,160,224,81,170,69,27,48,191,255,58,245,
224,81,138,61,155,111,43,0,0,18,13,94,128,255,139,0,11,6,240,255,
193,5,100,90,161,5,1,18,130,0,224,17,146,45,61,6,232,166,145,0,
61,23,49,0,35,62,2,0,2,66,34,127,8,0,0,74,34,119,13,0,
63,6,88,28,128,0,15,48,221,49,110,0,27,48,191,255,180,249,38,6,
224,147,4,0,130,255,0,43,29,48,35,62,2,0,2,66,0,74,129,255,
108,180,36,55,129,176,128,255,112,26,128,7,68,4,27,48,191,255,138,249,
128,7,58,4,61,55,5,0,39,6,24,27,133,0,130,255,186,159,224,81,
138,61,38,6,36,27,133,0,130,255,98,158,229,87,64,0,224,7,96,1,
10,216,0,226,32,54,52,0,130,255,222,136,10,232,224,233,210,5,29,48,
128,255,170,164,29,224,28,232,61,23,49,0,34,103,16,0,34,95,21,0,
63,6,228,28,128,0,12,48,221,49,107,0,10,224,224,233,226,13,61,23,
49,0,34,143,8,0,34,135,13,0,3,58,63,6,4,29,128,0,17,48,
221,49,112,0,251,47,32,0,128,7,142,3,61,55,5,0,37,62,108,128,
130,255,60,159,224,81,138,61,38,6,244,27,133,0,130,255,228,157,229,87,
64,0,224,7,96,1,10,216,0,226,32,54,52,0,130,255,96,136,10,232,
224,233,210,5,29,48,128,255,206,161,29,224,28,232,61,23,49,0,34,119,
16,0,34,111,21,0,63,6,98,29,128,0,14,48,221,49,109,0,10,224,
224,233,226,13,61,23,49,0,34,95,8,0,34,87,13,0,3,58,63,6,
130,29,128,0,11,48,221,49,106,0,251,47,32,0,128,7,16,3,61,55,
5,0,37,62,116,128,130,255,190,158,224,81,250,5,27,48,191,255,118,248,
10,224,128,7,244,2,61,55,5,0,37,62,8,129,130,255,162,158,224,81,
234,5,128,255,56,26,10,224,128,7,218,2,61,55,5,0,37,62,11,129,
130,255,136,158,224,81,234,5,128,255,4,26,10,224,128,7,192,2,61,55,
5,0,37,62,14,129,130,255,110,158,224,81,138,21,61,55,9,0,32,70,
16,0,0,58,130,255,188,175,10,56,135,0,27,48,191,255,2,250,10,224,
128,7,146,2,61,55,5,0,37,62,180,128,130,255,64,158,224,81,234,21,
61,55,9,0,0,58,10,66,130,255,144,175,4,143,84,144,224,81,234,23,
0,0,194,134,1,0,209,142,251,0,194,130,16,137,68,143,84,144,128,7,
88,2,61,55,5,0,37,62,20,129,57,6,212,221,136,0,130,255,0,158,
224,81,138,13,25,48,0,58,128,255,12,30,10,224,128,7,52,2,61,55,
5,0,37,62,188,128,130,255,226,157,224,81,138,13,25,48,5,58,128,255,
238,29,10,224,128,7,22,2,61,55,5,0,37,62,28,129,130,255,196,157,
224,81,138,13,25,48,6,58,128,255,208,29,10,224,128,7,248,1,61,55,
5,0,37,62,36,129,130,255,166,157,224,81,250,5,25,48,128,255,70,30,
10,224,128,7,220,1,61,55,5,0,39,6,32,28,133,0,130,255,136,157,
224,81,250,13,61,55,9,0,10,66,0,58,130,255,216,174,10,56,135,0,
25,48,128,255,104,30,10,224,128,7,174,1,61,55,5,0,39,6,84,27,
133,0,130,255,90,157,224,81,250,5,25,48,128,255,216,30,10,224,128,7,
144,1,61,55,5,0,39,6,44,28,133,0,130,255,60,157,224,81,234,5,
25,48,128,255,14,31,128,7,116,1,61,55,5,0,37,62,124,128,130,255,
34,157,224,81,170,13,132,63,85,144,38,6,212,26,133,0,130,255,198,155,
128,7,82,1,61,55,5,0,37,62,196,128,130,255,0,157,224,81,202,13,
32,254,30,241,223,183,0,0,64,86,0,0,0,90,74,95,144,244,128,7,
44,1,61,55,5,0,37,62,204,128,130,255,218,156,224,81,202,13,32,254,
30,241,223,55,0,0,64,86,0,0,0,90,74,95,144,244,128,7,6,1,
61,55,5,0,37,62,212,128,130,255,180,156,224,81,186,13,32,254,30,241,
223,191,0,0,64,86,0,0,0,90,74,95,144,244,133,117,61,55,5,0,
37,62,140,128,130,255,144,156,224,81,234,5,27,48,191,255,152,248,10,224,
181,101,61,55,5,0,37,62,44,129,130,255,118,156,224,81,234,5,27,48,
191,255,216,248,10,224,229,85,61,55,5,0,37,62,47,129,130,255,92,156,
224,81,170,29,61,55,9,0,32,70,16,0,0,58,130,255,170,173,10,224,
61,55,13,0,220,0,0,58,32,70,16,0,130,255,152,173,61,79,17,0,
27,48,28,56,10,64,191,255,64,245,10,224,213,53,61,55,5,0,37,62,
50,129,130,255,26,156,224,81,138,13,0,50,37,62,50,129,128,255,216,10,
10,224,229,37,61,55,5,0,37,62,56,129,130,255,252,155,224,81,138,13,
0,50,37,62,56,129,128,255,186,10,10,224,245,21,61,55,5,0,37,62,
64,129,130,255,222,155,224,81,154,13,36,63,9,136,38,6,96,27,133,0,
130,255,130,154,245,5,38,6,56,28,133,0,130,255,118,154,165,21,224,225,
234,5,37,54,132,128,130,255,104,154,181,13,28,48,129,255,36,23,28,56,
10,64,38,6,92,28,133,0,130,255,82,154,224,209,194,5,26,48,130,255,
150,134,66,6,255,240,128,7,225,16,6,232,191,255,122,240,10,224,224,225,
154,93,157,135,43,0,0,18,16,118,128,255,142,0,14,6,240,255,193,5,
100,114,161,5,1,18,130,0,224,17,138,13,16,94,112,255,99,90,193,5,
130,0,224,17,194,61,29,48,191,255,188,239,59,6,16,24,134,0,10,232,
27,48,29,64,37,62,72,129,130,255,36,144,27,56,38,6,124,28,133,0,
130,255,226,153,221,70,7,0,130,13,100,66,177,29,146,13,102,66,177,13,
226,13,229,21,39,6,32,18,133,0,213,21,39,6,88,18,133,0,149,21,
39,6,136,18,133,0,213,13,39,6,48,18,133,0,156,234,129,13,39,6,
168,18,133,0,197,5,39,6,192,18,133,0,38,6,144,28,133,0,130,255,
148,153,133,13,38,6,168,28,133,0,130,255,136,153,32,230,129,3,28,80,
64,6,255,16,134,7,225,48,6,224,7,216,155,0,60,238,116,0,99,239,
5,0,1,130,67,135,8,0,29,48,31,58,191,255,136,228,224,81,186,253,
229,87,64,0,224,7,96,1,10,208,1,122,67,127,3,0,32,238,100,0,
28,48,191,255,72,244,28,48,191,255,122,239,224,81,178,5,95,234,170,253,
224,233,138,29,131,119,9,0,224,113,146,21,35,55,5,0,67,7,8,0,
128,255,244,4,224,81,146,13,38,6,248,28,133,0,32,62,178,1,0,66,
191,255,200,227,32,86,22,3,133,101,28,48,35,62,3,0,1,66,191,255,
20,240,32,254,30,241,223,191,0,0,64,86,0,0,0,90,74,95,144,244,
250,47,32,0,156,239,43,0,0,18,29,102,128,255,100,98,153,37,224,217,
138,53,29,6,127,255,210,45,38,6,4,29,133,0,130,255,188,152,38,6,
52,29,133,0,39,6,104,29,133,0,130,255,172,152,221,62,255,0,38,6,
116,29,133,0,130,255,158,152,37,54,80,129,130,255,150,152,32,22,133,3,
165,21,38,6,196,28,133,0,130,255,134,152,29,56,38,6,116,29,133,0,
130,255,122,152,37,54,80,129,130,255,114,152,32,22,135,3,131,95,9,0,
2,232,224,89,146,21,35,55,5,0,67,7,8,0,128,255,50,4,224,81,
146,13,38,6,248,28,133,0,32,62,178,1,0,66,191,255,6,227,29,80,
70,6,255,48,132,7,225,16,6,224,7,216,60,238,116,0,99,239,1,0,
1,130,67,135,4,0,29,48,31,58,191,255,74,227,224,81,186,253,28,48,
191,255,86,238,10,232,224,233,242,21,131,119,5,0,224,113,146,21,35,55,
1,0,67,7,4,0,128,255,214,3,224,81,146,13,38,6,128,29,133,0,
32,62,178,1,0,66,191,255,170,226,29,80,197,53,156,111,43,0,0,18,
13,94,128,255,139,0,11,6,240,255,193,5,100,90,161,5,1,18,130,0,
224,17,138,13,13,134,112,255,99,130,193,5,130,0,224,17,242,5,28,48,
191,255,108,237,123,87,1,0,181,5,32,238,139,3,131,111,5,0,224,105,
146,21,35,55,1,0,67,7,4,0,128,255,110,3,224,81,146,13,38,6,
128,29,133,0,32,62,178,1,0,66,191,255,66,226,29,80,68,6,255,16,
132,7,225,16,6,224,7,216,60,238,116,0,99,239,1,0,1,130,67,135,
4,0,29,48,31,58,191,255,134,226,224,81,186,253,28,48,191,255,146,237,
224,81,130,29,131,119,5,0,10,232,224,113,146,21,35,55,1,0,67,7,
4,0,128,255,18,3,224,81,146,13,38,6,140,29,133,0,32,62,178,1,
0,66,191,255,230,225,29,80,181,29,156,111,43,0,131,103,5,0,10,232,
91,111,0,0,224,97,146,21,35,55,1,0,67,7,4,0,128,255,220,2,
224,81,146,13,38,6,140,29,133,0,32,62,178,1,0,66,191,255,176,225,
29,80,68,6,255,16,132,7,225,0,6,224,60,238,116,0,99,239,1,0,
1,130,67,135,4,0,29,48,31,58,191,255,246,225,224,81,186,253,28,48,
6,58,0,66,191,255,58,238,131,127,5,0,10,232,224,121,146,21,35,55,
1,0,67,7,4,0,128,255,130,2,224,81,146,13,38,6,164,29,133,0,
32,62,178,1,0,66,191,255,86,225,29,80,68,6,255,0,132,7,225,240,
7,200,8,216,9,232,3,199,36,0,6,224,60,214,116,0,99,215,1,0,
1,130,67,135,4,0,26,48,31,58,191,255,146,225,224,81,186,253,28,48,
217,126,31,0,15,62,96,0,167,0,0,66,191,255,206,237,10,112,224,113,
202,29,14,16,224,193,234,103,0,0,27,80,162,81,181,21,224,97,250,5,
60,134,76,0,194,129,144,95,3,0,229,5,60,110,76,0,202,105,173,95,
1,0,93,95,0,0,65,234,95,82,65,18,251,17,214,237,131,95,5,0,
14,232,224,89,146,21,35,55,1,0,67,7,4,0,128,255,218,1,224,81,
146,13,38,6,176,29,133,0,32,62,178,1,0,66,191,255,174,224,29,80,
68,6,255,240,132,7,225,240,6,208,7,200,9,232,3,199,36,0,8,224,
28,6,224,255,199,5,32,86,15,1,213,77,58,222,116,0,99,223,1,0,
1,130,67,135,4,0,27,48,31,58,191,255,222,224,224,81,186,253,28,120,
170,121,15,22,255,255,221,17,58,118,4,0,202,113,14,94,2,0,224,193,
234,119,0,0,10,96,229,13,224,113,202,5,140,111,1,0,181,5,130,111,
1,0,75,111,0,0,95,18,65,90,1,234,65,82,221,97,252,81,150,245,
26,48,217,94,31,0,11,62,64,0,167,0,28,64,168,0,191,255,218,236,
131,111,5,0,10,232,224,105,146,21,35,55,1,0,67,7,4,0,128,255,
34,1,224,81,146,13,38,6,188,29,133,0,32,62,178,1,0,66,191,255,
246,223,29,80,68,6,255,240,132,7,225,0,6,224,60,238,116,0,99,239,
1,0,1,130,67,135,4,0,29,48,31,58,191,255,60,224,224,81,186,253,
28,48,1,58,0,66,191,255,128,236,131,127,5,0,10,232,224,121,146,21,
35,55,1,0,67,7,4,0,128,255,200,0,224,81,146,13,38,6,200,29,
133,0,32,62,178,1,0,66,191,255,156,223,29,80,68,6,255,0,132,7,
225,0,6,224,60,238,116,0,99,239,1,0,1,130,67,135,4,0,29,48,
31,58,191,255,226,223,224,81,186,253,28,48,0,58,0,66,191,255,38,236,
131,127,5,0,10,232,224,121,146,21,35,55,1,0,67,7,4,0,128,255,
110,0,224,81,146,13,38,6,212,29,133,0,32,62,178,1,0,66,191,255,
66,223,29,80,68,6,255,0,38,54,116,0,37,62,84,129,1,66,129,7,
74,109,128,7,225,0,7,232,189,0,8,224,224,49,138,13,32,54,152,0,
130,255,230,126,10,48,224,49,146,13,70,239,0,0,102,7,2,0,102,231,
113,0,70,7,148,0,6,80,64,6,255,0,33,6,114,197,1,0,97,0,
33,6,42,195,1,0,97,0,33,6,108,198,1,0,97,0,33,6,52,103,
0,0,97,0,128,7,33,0,38,6,212,221,136,0,128,255,32,24,32,22,
239,0,68,23,52,142,36,150,56,142,114,7,1,0,68,23,60,142,36,150,
64,142,114,7,1,0,64,6,63,0,130,7,97,0,32,142,239,0,67,143,
3,0,38,6,88,30,133,0,130,255,214,147,38,6,192,28,141,0,191,255,
86,255,132,135,85,144,36,23,93,144,100,7,69,142,208,134,72,0,68,135,
84,144,224,17,218,5,100,23,89,144,196,183,84,144,38,6,212,221,136,0,
128,255,102,23,64,22,0,64,36,150,56,142,114,23,1,0,63,6,128,132,
30,0,64,86,0,0,10,87,10,244,138,0,129,82,177,5,95,250,138,253,
224,249,154,13,38,6,36,30,133,0,130,255,112,147,68,7,84,144,181,69,
0,234,38,6,192,28,141,0,35,62,3,0,191,255,228,251,10,16,224,17,
186,13,163,111,3,0,13,118,128,255,14,6,237,255,249,5,138,0,224,81,
202,5,65,234,99,234,166,237,0,106,224,17,202,13,163,135,3,0,16,142,
128,255,17,6,237,255,201,5,130,0,224,17,162,5,1,106,4,103,84,144,
205,94,1,0,193,90,36,158,84,144,204,102,253,0,11,97,68,103,84,144,
211,207,0,0,242,5,38,6,24,30,133,0,130,255,246,146,133,13,38,6,
8,30,133,0,130,255,234,146,68,7,84,144,66,6,127,0,134,7,225,112,
166,119,1,0,134,95,1,0,32,142,170,0,134,127,5,0,14,216,200,218,
11,217,219,0,67,95,5,0,67,143,6,0,32,134,221,0,67,119,4,0,
166,119,5,0,67,135,7,0,134,87,7,0,166,23,7,0,67,127,8,0,
67,119,9,0,67,87,10,0,67,23,11,0,10,224,200,226,2,225,220,0,
6,238,8,0,28,6,255,228,201,5,32,86,33,3,229,125,37,102,96,129,
12,87,0,0,35,78,2,0,57,6,192,28,141,0,73,87,0,0,12,143,
1,0,25,48,128,62,2,224,2,66,73,143,1,0,191,255,180,236,10,112,
224,113,218,101,213,29,32,118,32,0,28,6,224,255,238,231,60,211,219,102,
31,0,226,5,219,134,31,0,32,214,32,0,176,209,25,48,27,56,26,64,
29,72,191,255,132,236,10,112,224,113,154,21,218,217,219,0,186,225,220,0,
218,233,224,225,186,229,25,48,128,62,0,224,8,66,35,78,4,0,191,255,
96,236,10,112,0,234,29,16,196,18,45,6,240,23,134,0,205,17,34,143,
1,0,36,127,21,136,32,134,16,0,17,104,141,87,1,0,143,103,1,0,
65,106,65,122,138,97,218,5,224,81,178,5,95,130,218,245,224,97,231,29,
36,95,17,136,17,96,32,110,16,0,139,127,1,0,140,87,1,0,65,90,
65,98,143,81,218,5,224,121,178,5,95,106,218,245,224,81,182,13,226,63,
5,0,34,71,9,0,34,79,13,0,25,48,191,255,238,235,10,112,65,234,
98,234,230,197,14,80,70,6,255,112,130,7,97,0,32,142,239,0,67,143,
3,0,61,6,192,28,141,0,29,48,191,255,112,236,38,6,224,147,4,0,
130,255,188,29,29,48,35,62,3,0,191,255,222,249,29,48,35,62,3,0,
191,255,212,249,29,48,35,62,3,0,191,255,202,249,224,81,202,69,163,95,
3,0,10,16,11,118,128,255,142,0,14,6,240,255,193,5,100,114,161,5,
1,18,130,0,224,17,146,37,11,6,119,255,162,53,38,6,148,30,133,0,
130,255,14,145,38,6,196,30,133,0,39,6,248,30,133,0,130,255,254,144,
3,87,3,0,38,6,4,31,133,0,202,62,255,0,130,255,236,144,37,54,
98,129,130,255,228,144,32,86,132,3,213,21,38,6,108,30,133,0,130,255,
212,144,3,127,3,0,38,6,4,31,133,0,207,62,255,0,130,255,194,144,
37,54,98,129,130,255,186,144,32,86,136,3,66,6,127,0,128,7,33,0,
191,255,204,253,224,81,186,5,191,255,38,255,64,6,63,0,130,7,225,0,
36,63,17,136,6,224,0,234,36,95,21,136,7,80,32,102,16,0,138,127,
1,0,139,23,1,0,65,82,65,90,143,17,218,5,224,121,178,5,95,98,
218,245,224,17,199,21,38,6,16,31,133,0,130,255,98,144,38,6,192,28,
141,0,0,58,191,255,220,246,10,232,224,233,138,29,28,48,191,255,156,255,
10,232,181,21,38,6,172,166,145,0,35,62,3,0,1,66,0,74,129,255,
0,167,224,81,226,5,163,111,3,0,13,6,127,255,178,5,32,238,133,3,
29,80,66,6,255,0,128,7,97,0,6,232,7,48,37,62,100,129,130,255,
86,145,224,81,154,13,38,6,192,28,141,0,1,58,191,255,130,246,224,81,
202,5,29,48,191,255,20,253,64,6,127,0,148,7,225,48,6,216,155,0,
7,208,35,54,4,0,39,6,136,136,136,136,129,255,116,30,35,54,4,0,
129,255,158,46,224,81,170,13,38,6,52,31,133,0,130,255,192,143,32,86,
198,1,128,7,82,1,35,54,4,0,129,255,46,25,10,224,28,48,130,255,
218,123,10,232,224,233,226,45,29,56,28,64,99,7,1,0,35,54,4,0,
0,74,129,255,172,28,10,224,224,225,178,5,128,7,24,1,36,127,17,136,
224,121,154,13,32,54,17,0,130,255,168,123,100,87,17,136,224,81,194,21,
36,55,17,136,32,70,17,0,0,58,191,255,64,214,36,111,21,136,224,105,
202,13,32,54,17,0,130,255,130,123,100,87,21,136,224,81,202,5,32,86,
16,1,213,109,36,55,21,136,32,70,17,0,0,58,191,255,20,214,35,54,
4,0,129,255,170,24,36,79,17,136,29,56,10,64,35,54,4,0,129,255,
118,45,224,81,218,13,38,6,132,31,133,0,130,255,14,143,36,55,17,136,
130,255,84,123,32,86,128,3,197,77,224,217,170,29,36,63,21,136,38,6,
140,164,145,0,32,70,16,0,0,74,129,255,180,165,224,81,250,5,38,6,
180,31,133,0,130,255,218,142,133,13,36,63,21,136,38,6,108,31,133,0,
130,255,202,142,26,48,37,62,112,129,130,255,10,144,224,81,154,13,29,48,
27,56,35,70,4,0,191,255,22,254,10,224,229,29,26,48,37,62,104,129,
130,255,236,143,36,63,17,136,224,81,186,13,38,6,212,31,133,0,130,255,
144,142,29,48,191,255,220,253,10,224,181,13,38,6,0,32,133,0,130,255,
124,142,29,48,26,56,191,255,92,254,10,224,29,48,130,255,186,122,28,80,
84,6,255,48,130,7,97,0,196,151,84,144,36,158,84,144,32,142,239,0,
67,143,3,0,211,207,0,0,32,238,134,3,186,5,128,7,8,1,61,6,
192,28,141,0,29,48,35,62,3,0,191,255,190,246,29,48,35,62,3,0,
191,255,180,246,29,48,35,62,3,0,191,255,170,246,10,232,224,233,234,101,
163,95,3,0,11,118,128,255,142,0,14,6,240,255,193,5,100,114,161,5,
1,234,157,0,224,233,162,45,11,6,119,255,250,5,0,50,37,62,128,129,
191,255,4,254,197,69,38,6,28,33,133,0,130,255,226,141,38,6,80,32,
133,0,39,6,132,32,133,0,130,255,210,141,3,87,3,0,38,6,144,32,
133,0,202,62,255,0,130,255,192,141,37,54,136,129,130,255,184,141,1,50,
37,62,128,129,191,255,196,253,197,37,11,6,127,255,250,5,1,50,37,62,
120,129,191,255,178,253,181,29,38,6,156,32,133,0,130,255,144,141,38,6,
52,32,133,0,130,255,134,141,3,119,3,0,38,6,144,32,133,0,206,62,
255,0,130,255,116,141,37,54,136,129,130,255,108,141,32,238,133,3,197,13,
10,232,224,233,154,13,196,23,84,144,38,6,204,32,133,0,130,255,82,141,
149,13,196,151,84,144,38,6,236,32,133,0,29,56,130,255,64,141,29,80,
66,6,127,0,128,7,97,0,36,158,84,144,211,207,0,0,32,238,130,3,
130,37,64,142,137,0,17,143,228,221,102,138,130,29,38,6,192,28,141,0,
191,255,232,247,10,232,224,233,130,13,29,56,38,6,128,33,133,0,130,255,
0,141,181,13,38,6,108,33,133,0,130,255,244,140,196,159,84,144,181,5,
32,238,140,3,29,80,64,6,127,0,130,7,225,112,164,143,13,136,99,7,
1,0,224,137,186,5,196,143,84,144,36,158,84,144,211,207,0,0,59,6,
212,221,136,0,186,5,128,7,124,2,32,254,30,241,223,191,0,0,64,86,
0,0,0,90,74,95,144,244,32,254,30,241,223,183,0,0,64,86,0,0,
0,90,74,95,144,244,38,6,136,34,133,0,130,255,142,140,60,6,192,28,
141,0,28,48,191,255,66,242,27,200,25,48,128,255,160,15,27,103,16,0,
1,18,101,98,194,5,102,98,162,5,0,18,58,6,212,33,133,0,130,0,
224,17,138,13,105,98,226,5,38,6,84,34,133,0,128,7,56,1,38,6,
112,34,133,0,130,255,70,140,28,48,3,56,191,255,4,244,4,127,124,142,
10,232,224,233,146,29,29,6,117,252,226,13,38,6,172,33,133,0,130,255,
36,140,26,48,29,56,130,255,28,140,196,151,84,144,128,7,16,1,38,6,
160,34,133,0,32,62,139,3,130,255,6,140,229,93,35,23,1,0,0,82,
1,106,2,128,156,130,225,5,194,118,7,0,102,114,170,5,1,82,138,0,
224,81,138,13,194,86,7,0,100,82,194,5,224,81,162,5,0,106,141,0,
99,122,154,21,224,105,154,61,38,6,204,34,133,0,130,255,196,139,38,6,
0,35,133,0,32,62,208,0,0,66,191,255,118,214,229,85,1,82,224,105,
234,5,194,134,7,0,101,130,162,5,0,82,10,104,141,0,97,122,186,13,
194,118,7,0,101,114,242,5,38,6,12,35,133,0,130,255,136,139,245,29,
224,105,250,5,38,6,4,34,133,0,130,255,120,139,245,21,194,102,7,0,
101,98,250,5,28,48,191,255,30,233,10,232,196,31,84,144,224,233,202,5,
196,23,84,144,149,45,26,48,29,56,130,255,80,139,196,151,84,144,165,37,
32,54,100,0,37,62,164,129,191,255,208,215,229,87,64,0,224,7,96,1,
10,232,25,48,8,58,128,255,142,12,196,159,84,144,29,248,255,47,32,0,
38,6,68,35,133,0,130,255,24,139,191,255,178,252,10,232,224,233,202,5,
191,255,212,253,10,232,36,158,84,144,211,215,0,0,210,61,224,233,234,53,
28,48,3,56,191,255,184,242,10,232,224,233,130,13,26,48,29,56,130,255,
228,138,196,151,84,144,133,45,195,223,0,0,1,90,234,5,132,23,13,136,
224,17,170,5,2,88,4,87,84,144,203,142,1,0,37,54,140,129,202,86,
254,0,17,81,68,87,84,144,130,255,178,138,195,223,0,0,186,13,132,127,
13,136,37,54,168,129,224,121,178,5,37,54,148,129,130,255,152,138,37,54,
156,129,130,255,144,138,36,158,84,144,211,215,0,0,170,37,68,7,84,144,
32,254,30,241,223,191,0,0,64,86,0,0,0,90,74,95,144,244,32,254,
30,241,223,55,0,0,64,86,0,0,0,90,74,95,144,244,36,158,84,144,
211,223,0,0,38,6,124,35,133,0,194,5,38,6,56,34,133,0,130,255,
68,138,27,95,16,0,1,82,0,18,101,90,194,5,102,90,162,5,0,82,
138,0,224,81,186,5,105,90,186,13,36,158,84,144,211,207,0,0,218,5,
4,143,124,142,99,138,170,5,1,18,130,0,2,80,138,0,66,6,255,112,
128,7,225,0,32,143,169,182,224,137,130,85,164,135,13,136,224,129,226,5,
191,255,10,246,191,255,14,253,213,69,36,158,84,144,211,207,0,0,130,69,
64,118,137,0,14,119,228,221,1,18,101,114,194,5,102,114,162,5,0,18,
130,0,224,17,210,29,0,234,29,56,135,0,60,6,212,221,136,0,28,48,
128,255,180,12,224,81,226,13,29,56,135,0,28,48,128,255,236,11,29,64,
32,54,95,0,39,6,156,35,133,0,191,255,42,214,65,234,29,6,240,255,
230,229,191,255,86,252,32,254,30,241,223,55,0,0,64,86,0,0,0,90,
74,95,144,244,32,254,30,241,223,191,0,0,64,86,0,0,0,90,74,95,
144,244,196,143,84,144,128,255,98,10,64,6,255,0,132,7,97,0,36,158,
84,144,211,207,0,0,32,86,130,3,226,45,61,6,188,165,145,0,29,48,
35,62,4,0,4,66,0,74,129,255,138,156,49,6,4,3,2,1,99,143,
1,0,29,48,3,56,4,66,0,74,129,255,72,156,99,7,1,0,29,48,
3,56,4,66,0,74,129,255,100,156,29,48,35,62,4,0,4,66,0,74,
129,255,42,156,35,127,1,0,48,6,4,3,2,1,240,121,178,5,32,86,
108,48,68,6,127,0,128,7,33,0,38,6,192,28,141,0,191,255,230,227,
38,6,224,147,4,0,130,255,50,21,0,82,64,6,63,0,128,7,33,0,
36,158,84,144,211,207,0,0,32,86,130,3,134,0,242,5,6,56,38,6,
192,28,141,0,191,255,168,229,64,6,63,0,7,64,6,56,38,6,192,28,
141,0,191,7,172,230,134,7,97,0,36,158,84,144,211,207,0,0,0,234,
130,101,35,62,4,0,38,6,156,167,145,0,4,66,0,74,129,255,206,155,
35,62,8,0,38,6,188,165,145,0,4,66,0,74,129,255,188,155,50,6,
40,166,145,0,50,23,1,0,10,232,42,6,248,165,145,0,35,62,3,0,
72,18,34,55,0,0,34,143,5,0,1,66,0,74,202,49,63,6,208,50,
128,0,113,0,35,23,5,0,35,135,9,0,46,6,0,234,36,0,130,129,
238,129,219,5,163,111,3,0,224,105,250,37,36,158,84,144,211,247,0,0,
170,13,100,23,89,144,32,54,83,0,37,62,176,129,191,255,150,212,181,29,
36,87,89,144,224,81,202,5,100,23,89,144,197,21,170,17,43,6,128,58,
9,0,235,17,225,13,32,54,83,0,37,62,176,129,191,255,110,212,35,87,
5,0,100,87,89,144,181,5,100,7,89,144,29,80,70,6,127,0,6,16,
32,54,90,0,66,65,178,5,32,54,91,0,37,62,177,129,191,7,68,212,
130,7,33,0,70,65,186,21,35,62,3,0,38,6,168,170,145,0,1,66,
0,74,129,255,100,158,163,71,3,0,39,6,180,35,133,0,32,54,89,0,
191,255,24,212,66,6,63,0,130,7,33,0,70,65,186,21,35,62,3,0,
38,6,108,170,145,0,1,66,0,74,129,255,52,158,163,71,3,0,39,6,
192,35,133,0,32,54,88,0,191,255,232,211,66,6,63,0,70,65,250,5,
32,54,87,0,37,62,178,129,191,7,212,211,127,0,6,16,32,54,85,0,
66,65,178,5,32,54,86,0,37,62,179,129,191,7,188,211,130,7,33,0,
70,65,250,29,50,6,100,166,145,0,50,23,1,0,42,6,52,166,145,0,
35,62,3,0,1,66,72,18,34,55,0,0,34,135,5,0,0,74,63,6,
20,52,128,0,202,49,112,0,163,71,3,0,32,54,84,0,37,62,180,129,
191,255,120,211,66,6,63,0,70,65,250,5,32,54,93,0,37,62,188,129,
191,7,100,211,127,0,70,65,250,5,32,54,92,0,37,62,189,129,191,7,
82,211,127,0,6,16,32,54,81,0,66,65,178,5,32,54,82,0,37,62,
190,129,191,7,58,211,128,7,33,0,36,158,84,144,211,199,0,0,0,82,
146,21,132,143,13,136,224,137,218,13,64,134,137,0,16,135,228,221,102,130,
242,5,196,135,84,144,128,255,126,7,191,255,66,249,64,6,63,0,130,7,
33,0,70,65,202,13,32,54,78,0,37,62,191,129,191,255,242,210,196,39,
84,144,191,255,180,255,165,37,50,6,40,166,145,0,50,23,1,0,42,6,
248,165,145,0,35,62,3,0,1,66,72,18,34,55,0,0,34,135,5,0,
0,74,63,6,224,52,128,0,202,49,112,0,163,71,3,0,32,54,80,0,
39,6,204,35,133,0,191,255,170,210,196,167,84,144,66,6,63,0,168,0,
8,136,98,66,201,5,97,66,185,13,245,5,99,66,177,13,210,13,100,66,
226,13,181,21,32,54,73,0,197,13,32,54,74,0,149,13,32,54,75,0,
229,5,32,54,76,0,181,5,32,54,77,0,37,62,192,129,191,7,100,210,
127,0,168,0,8,136,98,66,201,5,97,66,137,21,245,5,99,66,209,21,
242,21,100,66,210,29,165,37,36,158,84,144,211,231,0,0,218,29,32,54,
68,0,229,21,36,158,84,144,211,231,0,0,218,21,32,54,69,0,229,13,
32,54,70,0,181,13,36,158,84,144,211,231,0,0,170,13,32,54,71,0,
181,5,32,54,72,0,37,62,193,129,191,7,6,210,127,0,36,158,84,144,
211,199,0,0,186,13,64,142,137,0,17,143,228,221,102,138,210,5,196,7,
84,144,128,7,86,6,127,0,70,65,186,5,191,7,220,255,191,7,162,254,
3,30,236,255,99,63,9,0,99,55,5,0,99,255,1,0,36,158,84,144,
211,207,0,0,242,29,35,22,4,0,34,95,1,0,36,86,60,142,106,95,
1,0,34,23,5,0,36,62,64,142,36,54,56,142,106,23,5,0,128,255,
78,9,36,22,60,142,34,95,1,0,36,86,52,142,106,95,1,0,34,23,
5,0,106,23,5,0,35,255,1,0,3,30,20,0,127,0,132,7,97,0,
32,22,239,0,67,23,0,0,99,7,5,0,36,158,84,144,211,207,0,0,
0,82,226,29,61,6,192,28,141,0,35,62,4,0,29,48,191,255,128,236,
224,81,202,21,35,55,1,0,35,63,5,0,191,255,104,255,64,134,137,0,
16,135,228,221,102,130,218,5,196,135,84,144,128,255,152,5,29,48,191,255,
80,234,196,47,84,144,68,6,127,0,128,7,97,0,36,158,84,144,211,207,
0,0,146,45,36,158,84,144,211,199,0,0,146,37,64,142,137,0,17,143,
228,221,102,138,130,29,38,6,192,28,141,0,191,255,138,239,10,232,224,233,
130,13,29,56,38,6,216,35,133,0,130,255,72,132,149,21,38,6,0,36,
133,0,130,255,60,132,196,31,84,144,149,13,32,238,140,3,229,5,32,238,
131,3,181,5,32,238,130,3,29,80,64,6,127,0,130,7,97,0,36,158,
84,144,211,207,0,0,0,234,130,21,3,56,99,55,1,0,38,6,156,167,
145,0,4,66,0,74,129,255,36,151,10,232,191,255,94,251,196,55,84,144,
29,80,66,6,127,0,128,7,97,0,40,23,6,0,97,18,138,45,64,142,
137,0,17,143,228,221,102,138,202,5,32,238,140,3,149,37,38,6,248,165,
145,0,0,58,129,255,72,154,10,232,224,233,138,29,191,255,20,253,10,232,
224,233,186,21,38,6,192,28,141,0,191,255,196,236,10,232,224,233,202,5,
196,39,84,144,133,13,196,167,84,144,191,255,38,254,181,5,32,238,13,1,
29,80,64,6,127,0,130,7,225,0,99,7,1,0,36,158,84,144,211,207,
0,0,32,238,130,3,194,29,60,6,192,28,141,0,28,48,3,56,191,255,
42,235,10,232,224,233,170,21,35,127,1,0,207,134,7,0,186,13,128,255,
90,4,28,48,191,255,0,225,10,232,0,50,129,255,136,164,181,5,32,238,
141,3,29,80,66,6,255,0,128,7,33,0,38,6,192,28,141,0,191,255,
254,237,224,81,186,5,196,159,84,144,64,6,63,0,128,7,33,0,38,6,
192,28,141,0,191,255,62,238,224,81,186,5,196,31,84,144,64,6,63,0,
132,7,33,0,32,22,239,0,67,23,0,0,99,7,5,0,3,56,35,70,
4,0,38,6,192,28,141,0,191,255,184,219,224,81,194,21,36,158,84,144,
211,239,0,0,242,13,3,56,38,6,112,147,145,0,31,66,130,255,100,73,
32,54,12,177,64,62,64,0,0,66,191,255,138,238,68,6,63,0,128,7,
97,0,229,87,64,0,224,7,96,1,10,232,38,6,212,221,136,0,8,58,
128,255,252,3,10,248,224,249,186,5,196,159,84,144,253,47,32,0,224,249,
202,5,191,255,78,245,10,248,31,80,64,6,127,0,128,7,97,0,64,134,
137,0,16,135,228,221,0,82,4,239,124,142,1,18,101,130,194,5,102,130,
162,5,0,18,130,0,224,17,162,37,38,6,212,221,136,0,1,58,128,255,
222,3,101,82,139,29,36,158,84,144,211,207,0,0,186,5,99,234,186,13,
38,6,116,36,133,0,130,255,48,130,128,255,144,25,224,81,162,13,245,5,
32,54,99,0,37,62,194,129,191,255,172,206,191,255,102,255,64,6,127,0,
128,7,225,112,61,6,212,221,136,0,0,210,128,255,4,3,29,135,16,0,
1,18,61,231,21,0,101,130,194,5,102,130,162,5,0,18,130,0,224,17,
226,93,38,6,208,36,133,0,130,255,222,129,128,255,236,2,0,218,27,88,
139,0,193,90,61,142,24,0,209,89,43,135,0,0,224,129,214,5,27,48,
134,0,128,255,214,2,65,218,27,6,240,255,246,237,129,255,44,162,68,7,
72,142,132,55,73,142,6,16,2,6,240,255,241,45,197,18,32,142,164,180,
209,17,34,23,5,0,224,17,242,37,128,255,174,2,224,81,178,37,132,55,
73,142,1,18,230,23,192,0,2,96,92,97,146,29,34,88,75,225,128,255,
154,2,132,71,73,142,10,72,224,73,146,13,32,54,95,0,39,6,188,36,
133,0,191,255,234,205,165,13,32,54,94,0,37,62,196,129,191,255,220,205,
181,5,128,255,118,2,132,103,73,142,65,98,68,103,72,142,204,94,255,0,
11,6,240,255,185,197,181,5,129,255,104,161,29,87,16,0,100,82,218,5,
29,48,8,58,128,255,124,2,29,143,16,0,104,138,154,21,0,218,213,13,
220,134,1,0,130,13,27,64,32,54,95,0,37,62,196,129,191,255,140,205,
65,218,129,226,224,225,186,245,36,158,84,144,211,207,0,0,210,93,29,95,
16,0,1,18,101,90,194,5,102,90,162,5,0,18,130,0,224,17,242,61,
229,87,64,0,224,7,96,1,10,200,29,48,28,56,128,255,164,2,0,218,
1,90,251,95,192,0,92,89,250,5,29,48,27,56,135,0,31,66,128,255,
108,2,65,218,27,6,240,255,166,245,29,48,224,225,210,5,6,58,128,255,
246,1,213,5,128,255,168,2,196,159,84,144,25,248,255,47,32,0,224,225,
202,5,191,255,70,243,10,208,0,218,1,114,251,119,192,0,92,113,130,13,
27,64,32,54,79,0,37,62,196,129,191,255,242,204,65,218,27,6,240,255,
150,245,245,5,105,90,210,5,29,48,128,255,166,3,10,208,4,87,124,142,
99,82,162,21,38,6,148,36,133,0,130,255,56,128,191,255,176,252,10,208,
149,13,29,48,1,58,128,255,138,1,29,48,128,255,124,3,10,208,29,48,
128,255,154,1,128,255,80,1,191,255,48,251,26,80,64,6,255,112,128,7,
225,0,61,6,212,221,136,0,29,87,16,0,1,18,134,0,101,82,194,5,
102,82,162,5,0,18,130,0,224,17,202,85,105,82,162,85,196,223,84,144,
186,5,224,49,194,109,99,82,186,5,224,49,194,69,29,224,28,48,4,58,
128,255,44,1,28,48,128,255,184,1,191,255,106,213,128,255,254,0,64,86,
0,0,10,87,8,240,138,0,202,254,239,0,64,86,0,0,74,255,8,240,
128,255,236,0,32,23,61,177,224,17,154,29,224,17,146,13,38,6,244,36,
133,0,32,62,97,1,0,66,191,255,72,202,32,54,52,177,191,255,88,235,
224,81,146,13,38,6,52,37,133,0,32,62,178,1,0,66,191,255,44,202,
36,135,69,142,224,129,154,13,128,255,176,0,36,127,69,142,224,121,186,5,
128,255,172,0,128,255,180,23,29,48,5,58,128,255,168,0,197,5,196,223,
84,144,210,29,128,255,68,0,38,6,64,37,133,0,129,255,92,236,196,159,
84,144,38,6,192,28,141,0,191,255,126,220,64,86,0,0,10,87,10,244,
138,0,129,82,169,253,38,6,0,37,133,0,129,255,54,236,129,255,82,161,
64,6,255,0,33,6,114,172,1,0,97,0,33,6,6,87,1,0,97,0,
33,6,140,140,1,0,97,0,33,6,194,170,1,0,97,0,33,6,234,141,
1,0,97,0,33,6,224,170,1,0,97,0,33,6,176,170,1,0,97,0,
33,6,116,164,1,0,97,0,33,6,212,101,0,0,97,0,33,6,108,86,
1,0,97,0,33,6,98,102,0,0,97,0,33,6,60,87,1,0,97,0,
70,63,16,0,38,70,16,0,0,58,1,74,129,7,100,253,38,70,24,0,
5,58,32,78,32,0,129,7,86,253,70,7,56,0,38,70,56,0,32,62,
37,0,1,74,129,7,68,253,128,7,97,0,134,127,57,0,6,232,61,70,
56,0,1,74,199,121,70,127,56,0,32,62,37,0,129,255,38,253,31,98,
224,81,186,5,29,103,56,0,140,0,12,80,138,0,64,6,127,0,135,0,
232,0,7,6,240,255,201,5,32,86,10,1,133,13,7,128,193,130,198,129,
112,71,24,0,191,7,148,255,127,0,102,63,21,0,38,70,20,0,1,58,
4,74,129,7,226,252,128,7,97,0,6,232,128,255,68,2,61,23,21,0,
29,48,61,70,20,0,1,58,10,17,125,23,21,0,4,74,129,255,192,252,
64,6,127,0,128,7,97,0,6,232,61,143,21,0,224,137,146,13,38,6,
76,37,133,0,32,62,210,0,0,66,191,255,142,200,29,48,7,58,191,255,
38,255,64,6,127,0,128,7,225,48,7,224,6,232,61,119,21,0,156,0,
1,218,252,223,192,0,91,113,242,53,28,56,38,6,96,37,133,0,130,255,
156,125,229,87,64,0,224,7,96,1,10,208,61,87,21,0,59,88,29,48,
61,70,20,0,75,81,125,87,21,0,1,58,4,74,129,255,74,252,31,106,
193,226,221,225,124,111,24,0,10,216,224,217,218,5,29,48,191,255,212,254,
10,216,61,95,21,0,224,89,202,13,29,48,191,255,108,255,196,159,84,144,
250,47,32,0,191,255,16,240,191,255,212,247,250,47,32,0,181,5,32,222,
10,1,27,80,64,6,255,48,128,7,225,16,0,82,6,216,59,239,21,0,
0,226,181,13,221,142,1,0,226,5,27,48,28,56,135,0,191,255,86,255,
65,226,129,234,224,233,218,245,64,6,255,16,128,7,225,0,135,0,7,232,
6,224,38,6,144,37,133,0,130,255,242,124,60,111,21,0,1,122,253,127,
192,0,79,105,234,87,0,0,64,6,255,0,128,7,97,0,6,232,29,63,
16,0,38,6,184,37,133,0,130,255,202,124,61,63,21,0,38,6,244,37,
133,0,130,255,188,124,157,63,57,0,38,6,212,37,133,0,130,255,174,124,
64,6,127,0,128,7,97,0,6,232,93,7,16,0,125,7,21,0,93,7,
56,0,0,18,61,86,24,0,31,90,106,95,0,0,66,82,65,18,2,6,
240,255,166,253,29,48,61,70,16,0,0,58,1,74,129,255,70,251,224,81,
218,13,29,48,61,70,20,0,1,58,4,74,129,255,52,251,224,81,202,5,
29,48,191,255,202,253,224,81,154,13,29,48,61,70,56,0,32,62,37,0,
1,74,129,255,22,251,64,6,127,0,128,7,97,0,6,232,129,255,144,253,
29,48,61,70,16,0,0,58,1,74,129,255,82,247,29,48,61,70,20,0,
1,58,4,74,129,255,68,247,29,48,61,70,24,0,5,58,32,78,32,0,
129,255,52,247,29,48,61,70,56,0,32,62,37,0,1,74,129,255,36,247,
29,48,191,255,26,255,64,6,127,0,128,7,97,0,6,232,224,233,138,13,
32,54,60,0,130,255,110,102,10,232,224,233,242,5,29,48,3,58,32,70,
38,0,129,255,252,252,29,80,64,6,127,0,33,6,90,140,1,0,97,0,
128,7,225,241,39,215,1,0,38,207,1,0,26,136,61,6,100,38,133,0,
57,137,162,53,0,226,218,198,0,7,136,194,218,190,112,0,132,186,29,71,
4,0,0,98,100,66,234,5,32,70,112,0,23,216,1,98,197,13,104,66,
234,5,32,70,0,7,24,216,1,98,213,5,1,18,232,23,192,0,2,64,
8,120,89,121,8,104,90,105,47,105,194,13,224,97,162,5,27,64,61,95,
1,0,25,48,26,56,63,6,190,63,128,0,107,0,65,226,72,234,109,226,
246,213,64,6,255,241,135,0,224,57,186,5,9,82,133,61,38,23,1,0,
64,134,0,128,66,129,186,5,1,82,133,53,2,112,159,114,177,5,2,82,
181,45,2,96,148,98,193,5,2,80,154,82,185,5,7,82,181,37,194,134,
8,0,178,5,0,82,229,29,194,126,0,8,178,5,3,82,149,29,194,118,
0,64,178,5,4,82,197,21,2,104,155,106,193,5,2,88,153,90,185,5,
8,82,197,13,194,142,0,128,234,5,194,134,0,4,186,5,135,18,185,5,
5,82,165,5,6,82,127,0,128,7,33,0,135,0,191,255,128,255,10,88,
0,82,34,6,28,24,134,0,2,135,0,0,235,129,202,5,34,87,5,0,
245,5,72,18,65,82,106,82,225,245,37,86,232,129,64,6,63,0,6,72,
40,6,124,24,134,0,8,62,240,255,6,54,244,1,181,77,9,80,37,94,
244,129,4,98,138,127,1,0,139,23,1,0,65,82,65,90,143,17,218,5,
224,121,178,5,95,98,218,245,224,17,138,61,68,74,9,16,2,119,0,0,
65,18,224,113,202,253,169,17,95,18,226,45,201,17,2,94,1,0,37,102,
248,129,4,106,139,143,1,0,140,23,1,0,65,90,65,98,145,17,218,5,
224,137,178,5,95,106,218,245,224,17,170,29,32,86,16,0,7,16,9,88,
11,135,0,0,65,90,66,135,0,0,65,18,224,129,186,5,95,18,181,5,
95,82,218,245,224,81,226,5,66,7,0,0,65,18,95,82,202,253,72,7,
0,0,65,74,230,73,209,181,127,0,128,7,33,0,196,223,96,144,138,21,
32,54,128,0,128,255,68,1,224,81,162,13,38,6,204,38,133,0,32,62,
79,0,0,66,191,255,132,196,224,81,64,6,63,0,150,7,225,0,196,223,
96,144,64,230,1,0,242,5,38,6,248,38,133,0,130,255,164,121,229,117,
32,142,0,1,64,14,32,0,97,143,12,0,35,54,8,0,39,6,136,119,
102,85,129,255,38,8,35,54,8,0,129,255,80,24,224,81,250,5,38,6,
40,39,133,0,130,255,114,121,213,93,35,54,8,0,129,255,230,2,10,232,
252,233,179,5,64,238,1,0,29,48,130,255,138,101,10,224,224,225,250,5,
38,6,64,39,133,0,130,255,72,121,133,77,35,54,8,0,0,58,35,70,
4,0,129,255,132,23,35,135,5,0,253,129,179,5,99,239,5,0,28,56,
35,71,5,0,99,7,1,0,35,54,8,0,0,74,129,255,52,6,28,48,
191,255,130,254,196,199,96,144,162,13,38,6,112,39,133,0,39,6,108,24,
134,0,130,255,252,120,245,29,28,56,0,50,64,70,1,0,128,255,100,0,
10,232,224,233,202,13,38,6,140,39,133,0,39,6,108,24,134,0,130,255,
216,120,196,7,96,144,181,13,29,48,128,255,144,245,29,56,10,64,38,6,
216,38,133,0,130,255,190,120,28,48,130,255,6,101,32,102,0,1,64,14,
32,0,97,103,14,0,32,254,34,241,223,183,0,0,64,86,0,0,0,90,
74,95,144,244,86,6,255,0,33,6,24,35,0,0,97,0,33,6,136,69,
1,0,97,0,128,7,225,112,6,232,7,224,60,23,1,0,61,87,1,0,
57,6,16,41,133,0,8,216,226,81,242,5,25,48,32,62,196,6,0,66,
191,255,32,195,156,87,5,0,157,23,5,0,234,17,242,5,25,48,32,62,
197,6,0,66,191,255,8,195,29,48,28,56,12,66,191,255,190,189,59,143,
9,0,224,137,250,5,25,48,32,62,202,6,0,66,191,255,234,194,29,86,
252,255,59,239,17,0,0,210,59,23,9,0,0,226,245,5,253,81,242,5,
29,208,61,239,1,0,65,226,226,225,150,253,226,225,246,5,25,48,28,64,
32,62,223,6,191,255,184,194,59,127,9,0,95,122,123,127,9,0,61,23,
1,0,224,225,202,5,123,23,17,0,181,5,122,23,1,0,125,223,1,0,
64,6,255,112,64,14,139,0,65,7,44,31,38,6,128,24,134,0,130,7,
138,92,156,7,225,0,6,232,99,7,17,0,99,7,21,0,99,7,24,0,
99,7,30,0,32,134,17,0,99,135,33,0,35,126,36,0,99,127,13,0,
128,255,188,1,106,7,9,0,46,6,98,46,1,0,106,119,5,0,32,110,
12,177,106,111,29,0,32,102,0,16,106,103,33,0,32,94,232,3,106,95,
21,0,99,87,9,0,0,226,221,207,6,0,162,37,189,79,5,0,29,48,
0,58,35,70,36,0,99,79,26,0,128,255,126,1,97,82,146,13,38,6,
232,41,133,0,32,62,135,0,0,66,191,255,254,193,128,135,105,177,32,54,
16,0,224,129,162,5,12,50,12,58,35,70,8,0,128,255,90,1,65,226,
61,239,9,0,224,233,154,221,224,225,215,61,61,6,12,31,139,0,29,48,
31,58,191,255,50,194,224,81,186,253,35,255,9,0,229,87,64,0,224,7,
96,1,63,239,0,0,220,233,127,239,0,0,10,224,252,47,32,0,224,233,
138,13,31,48,63,127,5,0,63,6,52,68,128,0,111,0,31,114,99,119,
1,0,32,54,12,177,32,62,0,16,1,66,35,78,4,0,191,255,136,226,
38,6,12,31,139,0,191,255,142,226,224,81,162,13,38,6,248,41,133,0,
32,62,178,1,0,66,191,255,98,193,224,81,35,55,9,0,38,239,12,0,
102,7,0,0,128,255,204,0,29,80,92,6,255,0,138,7,225,16,6,216,
0,82,0,234,64,230,1,0,245,13,99,239,9,0,99,239,13,0,99,231,
17,0,3,48,32,62,128,0,0,66,128,255,166,0,93,238,1,0,251,233,
185,5,224,81,242,237,74,6,255,16,128,7,225,16,229,87,64,0,224,7,
96,1,10,224,38,6,4,42,133,0,130,255,56,118,0,50,128,255,164,156,
10,232,29,48,3,58,128,255,10,155,10,216,224,233,226,13,61,23,49,0,
72,18,34,55,0,0,34,143,5,0,3,58,63,6,2,69,128,0,221,49,
113,0,252,47,32,0,27,80,64,6,255,16,38,6,12,31,139,0,39,6,
32,42,133,0,1,66,129,7,202,78,224,49,210,5,129,58,185,5,130,7,
242,97,127,0,33,6,210,49,1,0,97,0,33,6,12,34,0,0,97,0,
33,6,174,22,0,0,97,0,33,6,208,204,1,0,97,0,33,6,180,80,
1,0,97,0,128,7,33,0,0,82,34,6,48,31,139,0,2,94,24,0,
98,95,1,0,66,7,22,0,2,22,24,0,11,94,24,0,65,82,10,6,
209,255,214,245,34,6,48,31,139,0,98,7,105,4,66,7,126,4,100,23,
81,142,38,6,176,35,139,0,0,58,32,70,64,0,191,255,76,188,64,14,
139,0,193,7,228,35,64,6,63,0,191,7,94,246,128,135,169,176,240,142,
100,0,96,143,165,176,127,0,134,7,225,112,7,224,0,234,28,6,240,255,
241,5,252,238,136,4,45,6,24,229,152,0,205,233,224,233,186,5,128,7,
254,2,0,210,28,6,240,255,177,13,28,16,197,18,32,134,164,180,208,17,
34,127,5,0,224,121,162,5,2,208,224,209,186,5,128,7,218,2,58,223,
5,0,224,217,186,5,128,7,206,2,59,23,105,0,57,6,85,155,145,0,
2,22,96,0,34,55,0,0,34,119,5,0,125,223,109,0,63,6,50,70,
128,0,219,49,110,0,224,81,194,5,218,215,31,0,130,13,221,151,0,0,
1,90,28,96,217,97,76,95,0,0,59,23,105,0,2,22,160,1,34,55,
0,0,34,87,5,0,3,56,63,6,102,70,128,0,219,49,106,0,35,135,
1,0,224,129,194,37,224,81,138,29,160,103,169,176,224,97,226,13,221,215,
0,0,178,13,221,151,0,0,221,7,20,0,1,106,28,112,217,113,78,111,
0,0,149,21,221,199,20,0,226,13,224,97,130,13,181,13,221,199,20,0,
130,13,221,215,0,0,218,5,221,135,20,0,221,23,0,0,196,207,84,144,
162,29,196,199,84,144,218,13,221,215,0,0,194,21,221,151,0,0,221,15,
20,0,1,122,217,225,92,127,0,0,181,13,221,207,20,0,130,13,221,215,
0,0,218,5,221,143,20,0,221,23,0,0,59,23,105,0,2,22,112,0,
34,55,0,0,34,119,5,0,63,6,6,71,128,0,219,49,110,0,29,103,
1,0,224,81,234,111,0,0,205,94,1,0,204,102,223,0,197,90,11,97,
93,103,1,0,27,48,35,62,8,0,35,70,4,0,128,255,26,8,221,215,
0,0,186,5,128,7,104,1,35,135,5,0,253,87,121,0,240,81,250,5,
35,119,9,0,253,127,123,0,238,121,162,61,64,102,137,0,12,103,228,221,
1,18,101,98,194,5,102,98,162,5,0,18,130,0,224,17,202,5,26,48,
128,255,224,7,35,135,5,0,35,87,9,0,125,7,124,0,0,18,125,135,
120,0,125,87,122,0,1,90,11,120,226,127,192,0,239,81,202,5,125,23,
124,0,213,5,65,18,2,6,240,255,214,245,253,119,125,0,224,113,154,13,
38,6,200,42,133,0,32,62,188,1,0,66,191,255,20,190,35,103,9,0,
95,98,125,103,126,0,35,23,5,0,35,87,9,0,49,6,60,222,136,0,
49,127,1,0,2,88,234,95,192,2,36,87,214,143,74,120,226,127,192,2,
194,90,235,121,4,18,235,127,60,107,93,111,23,0,205,102,255,0,239,97,
170,5,3,18,189,135,23,0,32,230,0,8,253,127,125,0,193,82,80,224,
239,231,192,0,234,231,192,2,93,23,22,0,154,13,38,6,200,42,133,0,
32,62,228,1,0,66,191,255,162,189,28,6,0,240,183,5,32,230,0,16,
125,231,128,0,49,6,60,222,136,0,49,95,1,0,36,135,214,143,189,111,
23,0,157,103,23,0,80,88,236,104,237,95,192,2,3,130,193,90,80,88,
235,225,235,231,60,123,221,215,0,0,125,127,130,0,146,29,221,215,2,0,
186,21,31,82,31,90,125,87,5,0,125,95,9,0,125,7,13,0,93,7,
16,0,93,7,17,0,93,7,18,0,93,7,19,0,125,7,25,0,221,215,
0,0,202,21,221,215,2,0,146,21,64,110,137,0,13,111,228,221,1,18,
101,106,194,5,102,106,162,5,0,18,130,0,224,17,202,5,26,48,128,255,
142,6,253,135,3,0,253,23,1,0,240,17,226,5,125,23,2,0,29,48,
128,255,128,6,70,6,255,112,128,7,225,243,6,200,7,208,8,192,9,232,
157,0,0,50,128,255,112,6,10,224,224,225,178,253,0,218,224,233,226,191,
0,0,54,6,8,44,1,0,165,69,61,135,29,0,253,23,9,0,240,135,
11,0,2,120,239,0,239,129,202,5,221,247,54,0,130,13,221,55,54,0,
29,56,25,48,128,255,60,6,165,45,125,23,32,0,28,48,29,56,128,255,
54,6,191,255,242,251,106,7,9,0,32,118,232,3,106,119,21,0,32,110,
16,0,106,111,2,0,106,183,5,0,106,239,29,0,106,231,33,0,125,87,
45,0,32,70,0,16,224,185,170,5,0,66,61,63,45,0,29,48,128,255,
2,6,61,55,45,0,1,58,128,255,0,6,65,218,219,102,63,0,210,13,
58,239,8,0,224,233,242,5,58,239,1,0,26,48,29,56,128,255,236,5,
224,233,202,181,28,48,224,217,178,29,57,63,109,0,128,255,226,5,28,48,
128,255,228,5,224,193,194,21,197,13,60,239,9,0,60,54,8,0,29,56,
128,255,192,5,24,48,29,56,128,255,208,5,60,87,16,0,224,81,170,245,
181,5,128,255,202,5,27,80,64,6,255,243,128,7,225,243,6,176,7,184,
0,202,56,6,48,31,139,0,24,232,61,143,1,0,246,137,250,37,29,119,
22,0,98,114,210,5,99,114,178,5,100,114,250,29,61,215,16,0,0,218,
149,21,61,231,16,0,224,225,130,13,61,231,9,0,61,54,8,0,28,56,
128,255,92,5,23,48,28,56,128,255,108,5,65,218,250,217,246,237,125,7,
20,0,5,98,93,103,22,0,29,48,128,255,94,5,24,198,24,0,65,202,
25,6,208,255,134,213,64,6,255,243,130,7,225,243,6,216,135,0,0,210,
57,6,48,31,139,0,1,194,5,186,224,57,226,183,0,0,25,232,29,135,
22,0,101,130,178,85,61,127,1,0,251,121,250,77,67,199,3,0,60,6,
8,215,255,255,28,48,31,58,128,255,24,5,224,81,186,253,59,87,109,0,
42,23,105,0,2,22,128,0,34,55,0,0,34,119,5,0,1,58,63,6,
188,74,128,0,202,49,110,0,163,111,3,0,224,105,178,21,67,7,3,0,
38,6,8,215,255,255,128,255,230,4,224,81,162,13,38,6,48,42,133,0,
32,62,255,0,0,66,191,255,230,186,224,81,224,177,194,29,229,5,199,55,
54,0,27,48,128,255,112,4,61,231,16,0,224,225,130,13,61,231,9,0,
61,54,8,0,28,56,128,255,122,4,28,56,224,57,234,237,125,7,20,0,
93,191,22,0,29,48,128,255,134,4,25,206,24,0,65,210,26,6,208,255,
198,165,66,6,255,243,128,7,225,16,6,232,0,58,191,255,32,255,189,143,
3,0,218,138,159,138,226,223,0,0,224,217,250,5,61,54,40,0,128,255,
106,4,10,56,213,13,61,231,100,0,224,225,130,13,61,231,93,0,61,54,
92,0,28,56,128,255,24,4,28,56,224,57,242,5,199,55,54,0,29,48,
128,255,232,3,213,229,64,6,255,16,136,7,225,241,7,232,8,224,6,208,
35,54,4,0,128,255,48,4,61,207,8,0,0,218,252,201,252,207,60,195,
149,21,61,231,8,0,224,225,242,5,61,231,1,0,29,48,28,56,128,255,
206,3,28,56,35,54,4,0,128,255,220,3,65,218,248,217,246,237,55,6,
8,215,255,255,1,130,67,135,3,0,23,224,28,48,31,58,128,255,208,3,
224,81,186,253,58,87,109,0,42,23,105,0,2,22,160,0,34,55,0,0,
34,127,5,0,0,58,63,6,4,76,128,0,202,49,111,0,163,119,3,0,
224,113,162,29,67,7,3,0,23,48,128,255,162,3,224,81,178,21,38,6,
48,42,133,0,32,62,255,0,0,66,191,255,162,185,224,81,154,13,133,13,
26,48,29,64,35,62,4,0,1,74,191,255,162,252,35,111,12,0,224,105,
239,245,24,216,133,21,61,231,8,0,224,225,242,5,61,231,1,0,29,48,
28,56,128,255,42,3,29,48,28,56,128,255,58,3,65,218,249,217,134,245,
1,90,67,95,3,0,23,232,29,48,31,58,128,255,52,3,224,81,186,253,
58,87,109,0,42,23,105,0,2,22,160,0,34,55,0,0,202,49,34,87,
5,0,1,58,63,6,160,76,128,0,106,0,58,87,109,0,42,23,105,0,
2,22,128,0,34,55,0,0,34,143,5,0,1,58,63,6,192,76,128,0,
202,49,113,0,163,135,3,0,224,129,146,21,67,7,3,0,23,48,128,255,
230,2,224,81,162,13,38,6,48,42,133,0,32,62,255,0,0,66,191,255,
230,184,224,81,72,6,255,241,142,7,225,241,56,6,212,221,136,0,1,138,
99,143,1,0,6,232,31,50,191,255,40,185,35,54,16,0,128,255,188,2,
35,54,4,0,128,255,180,2,29,48,35,62,16,0,191,255,202,252,132,111,
73,142,189,207,3,0,56,94,24,0,193,106,203,105,45,215,0,0,218,202,
159,202,32,70,64,0,224,209,190,5,35,71,24,0,61,63,113,0,8,184,
224,57,210,5,35,54,16,0,128,255,76,2,61,63,117,0,224,57,178,13,
229,5,61,54,40,0,128,255,90,2,10,56,35,54,16,0,128,255,48,2,
61,54,40,0,128,255,88,2,224,81,175,245,245,13,224,225,130,13,61,231,
93,0,61,54,92,0,28,56,128,255,248,1,28,56,35,54,16,0,128,255,
6,2,61,231,100,0,224,225,255,237,0,226,165,21,35,63,24,0,224,57,
146,13,35,223,17,0,35,54,16,0,27,56,128,255,204,1,27,56,35,54,
4,0,128,255,218,1,65,226,250,225,230,237,224,201,242,5,29,48,23,64,
35,62,16,0,191,255,174,253,224,209,190,21,0,210,149,21,132,63,73,142,
26,64,232,0,24,48,191,255,220,238,29,48,35,62,16,0,35,70,4,0,
0,74,191,255,222,250,202,209,35,103,24,0,224,97,223,237,35,207,12,0,
0,226,181,21,35,63,12,0,224,57,146,13,35,223,5,0,35,54,4,0,
27,56,128,255,94,1,27,56,199,55,54,0,29,48,128,255,50,1,65,226,
249,225,214,237,132,63,73,142,26,64,232,0,24,48,191,255,132,238,125,7,
113,0,35,135,1,0,125,7,117,0,125,7,105,0,93,7,21,0,224,129,
210,5,99,7,1,0,191,255,210,183,78,6,255,241,128,7,33,0,5,138,
64,143,168,176,32,134,244,1,96,135,165,176,64,7,169,176,50,6,60,222,
136,0,50,127,1,0,96,7,61,176,96,7,65,176,96,127,69,176,128,255,
58,1,128,255,62,1,128,255,90,1,191,255,174,246,128,255,58,1,4,119,
84,144,222,114,159,114,64,119,170,176,64,6,63,0,130,7,97,0,6,232,
221,135,20,0,221,143,20,0,31,82,125,87,5,0,221,199,3,0,125,87,
9,0,125,7,13,0,93,7,16,0,93,7,17,0,93,7,18,0,93,7,
19,0,32,134,1,3,125,7,128,0,125,7,105,0,93,7,21,0,125,7,
126,0,125,7,124,0,125,7,122,0,125,7,120,0,125,135,0,0,234,5,
32,126,1,3,125,127,2,0,213,5,35,54,3,0,191,255,154,246,61,54,
28,0,128,255,194,0,61,54,40,0,0,58,128,255,192,0,61,54,92,0,
128,255,136,0,66,6,127,0,33,6,210,124,0,0,97,0,33,6,84,166,
1,0,97,0,33,6,236,41,0,0,97,0,33,6,176,41,0,0,97,0,
33,6,12,39,0,0,97,0,33,6,66,41,0,0,97,0,33,6,76,91,
0,0,97,0,33,6,166,52,1,0,97,0,33,6,132,103,1,0,97,0,
33,6,220,38,0,0,97,0,33,6,144,38,0,0,97,0,33,6,232,103,
1,0,97,0,33,6,216,39,0,0,97,0,33,6,98,192,1,0,97,0,
33,6,154,190,1,0,97,0,33,6,152,25,1,0,97,0,33,6,74,104,
1,0,97,0,33,6,184,24,1,0,97,0,33,6,168,81,0,0,97,0,
33,6,82,78,0,0,97,0,33,6,56,28,1,0,97,0,33,6,98,78,
0,0,97,0,33,6,160,27,1,0,97,0,34,6,240,147,139,0,100,23,
109,142,100,7,105,142,0,138,2,86,12,0,98,87,5,0,98,7,1,0,
98,7,9,0,76,82,76,18,65,138,17,6,1,248,214,245,241,134,12,0,
47,6,240,147,139,0,207,129,112,7,5,0,112,7,1,0,112,7,9,0,
127,0,128,7,225,16,6,232,61,143,8,0,59,6,216,43,133,0,7,224,
97,138,254,5,27,48,32,62,80,5,0,66,191,255,104,181,229,87,64,0,
224,7,96,1,61,23,1,0,61,95,5,0,10,248,226,225,250,29,235,17,
138,29,61,119,8,0,125,7,5,0,125,7,1,0,95,114,125,119,8,0,
255,47,32,0,61,111,8,0,224,105,174,53,27,48,32,62,101,5,0,66,
191,255,36,181,224,81,165,45,60,103,17,0,125,103,1,0,245,5,235,225,
218,5,60,87,21,0,125,87,5,0,60,143,21,0,60,135,17,0,61,111,
8,0,113,135,17,0,60,119,21,0,60,127,17,0,95,106,125,111,8,0,
111,119,21,0,255,47,32,0,61,103,8,0,224,97,142,13,27,48,32,62,
128,5,0,66,191,255,208,180,224,81,64,6,255,16,128,7,225,0,6,232,
7,248,229,87,64,0,224,7,96,1,61,143,8,0,10,224,224,137,170,13,
38,6,40,44,133,0,32,62,19,5,0,66,191,255,160,180,181,37,61,23,
1,0,61,87,5,0,127,23,1,0,234,17,234,5,125,7,5,0,125,7,
1,0,149,21,61,119,1,0,46,119,17,0,61,103,5,0,125,119,1,0,
110,103,21,0,61,87,1,0,61,95,5,0,107,87,17,0,61,143,8,0,
95,138,125,143,8,0,252,47,32,0,61,135,8,0,224,129,174,13,38,6,
40,44,133,0,32,62,57,5,0,66,191,255,62,180,224,81,64,6,255,0,
34,6,240,35,139,0,100,23,89,142,100,7,85,142,0,138,2,86,12,0,
98,87,5,0,98,7,1,0,98,7,9,0,76,82,76,18,65,138,17,6,
1,248,214,245,241,134,12,0,47,6,240,35,139,0,207,129,112,7,5,0,
112,7,1,0,112,7,9,0,127,0,128,7,193,16,6,224,7,232,229,87,
64,0,224,7,96,1,60,143,8,0,10,216,224,137,170,13,124,239,1,0,
124,239,5,0,125,239,21,0,125,239,17,0,181,21,60,119,5,0,125,119,
21,0,60,111,5,0,109,239,17,0,60,103,1,0,125,103,17,0,60,95,
1,0,107,239,21,0,124,239,5,0,60,87,8,0,65,82,124,87,8,0,
251,47,32,0,64,6,223,16,0,82,0,18,229,5,38,143,1,0,68,50,
65,18,209,81,231,17,161,253,127,0,0,82,0,18,229,5,38,143,1,0,
68,50,65,18,209,81,231,17,161,253,128,81,127,0,128,7,225,16,36,55,
117,142,130,255,198,84,10,224,28,232,224,233,154,13,38,6,48,45,133,0,
32,62,8,1,0,66,191,255,62,179,36,55,113,142,36,71,117,142,29,56,
128,255,40,2,10,216,224,217,226,13,27,64,32,54,98,0,39,6,72,45,
133,0,191,255,234,180,28,48,130,255,160,84,27,80,245,85,36,87,25,136,
29,16,14,90,65,18,65,82,170,111,255,255,162,119,255,255,173,113,186,5,
95,90,250,245,224,113,210,13,32,54,97,0,37,62,36,130,191,255,180,180,
28,48,130,255,106,84,32,86,97,0,181,61,36,63,117,142,29,48,130,58,
191,255,64,255,224,81,210,13,32,54,96,0,37,62,36,130,191,255,140,180,
28,48,130,255,66,84,32,86,96,0,245,37,78,234,29,48,128,255,168,1,
202,233,29,48,128,255,168,1,202,233,29,48,128,255,168,1,202,233,29,48,
128,255,168,1,202,233,29,48,128,255,168,1,202,233,29,48,128,255,168,1,
202,233,29,48,128,255,168,1,202,233,29,48,128,255,168,1,129,255,180,133,
28,48,130,255,242,83,0,82,64,6,255,16,130,7,225,16,36,55,117,142,
130,255,196,83,10,232,29,224,224,233,154,13,38,6,96,45,133,0,32,62,
183,0,0,66,191,255,60,178,36,71,117,142,0,58,29,48,191,255,78,174,
36,63,25,136,14,66,29,48,191,255,228,172,78,234,229,87,64,0,224,7,
96,1,10,216,32,54,52,177,31,58,191,255,118,178,224,81,170,253,32,143,
61,177,224,137,146,13,38,6,84,45,133,0,32,62,97,1,0,66,191,255,
242,177,32,54,52,177,191,255,2,211,224,81,146,13,38,6,120,45,133,0,
32,62,178,1,0,66,191,255,214,177,29,48,128,255,16,1,202,233,29,48,
128,255,16,1,202,233,29,48,128,255,16,1,202,233,29,48,128,255,16,1,
202,233,29,48,128,255,16,1,202,233,29,48,128,255,16,1,202,233,29,48,
128,255,16,1,202,233,29,48,128,255,16,1,36,135,117,142,28,48,16,238,
252,255,29,56,130,58,191,255,16,254,99,87,1,0,220,233,29,48,3,56,
4,66,191,255,54,172,36,55,113,142,36,71,117,142,28,56,191,255,28,238,
10,232,38,6,212,221,136,0,191,255,142,232,251,47,32,0,28,48,130,255,
222,82,29,80,66,6,255,16,128,7,33,0,49,6,110,40,7,0,100,143,
117,142,48,6,0,42,7,0,100,135,117,142,208,126,255,1,146,13,38,6,
132,45,133,0,32,62,151,0,0,66,191,255,30,177,36,55,117,142,137,50,
191,255,192,237,100,87,113,142,64,6,63,0,33,6,186,69,1,0,97,0,
33,6,2,141,1,0,97,0,33,6,196,102,1,0,97,0,33,6,12,79,
0,0,97,0,33,6,58,38,0,0,97,0,33,6,226,63,0,0,97,0,
33,6,226,27,1,0,97,0,33,6,132,32,0,0,97,0,33,6,126,55,
1,0,97,0,33,6,88,141,1,0,97,0,33,6,250,102,1,0,97,0,
33,6,60,79,0,0,97,0,33,6,102,38,0,0,97,0,33,6,42,64,
0,0,97,0,33,6,14,28,1,0,97,0,33,6,100,33,0,0,97,0,
33,6,200,55,1,0,97,0,64,14,141,0,65,7,108,28,38,6,140,24,
134,0,130,7,122,74,224,49,210,5,129,58,185,5,130,7,182,81,127,0,
134,7,33,0,32,62,36,244,99,63,1,0,32,70,4,244,99,71,5,0,
3,122,99,127,9,0,38,6,112,28,141,0,5,74,129,255,132,51,38,6,
172,25,134,0,130,255,60,74,40,6,112,28,141,0,38,6,192,28,141,0,
32,62,22,0,191,255,246,208,38,6,184,25,134,0,130,255,30,74,70,6,
63,0,128,7,97,0,129,255,72,4,10,232,129,255,30,4,10,72,29,64,
202,65,197,77,9,80,37,94,56,130,4,98,138,127,1,0,139,23,1,0,
65,82,65,90,143,17,218,5,224,121,178,5,95,98,218,245,224,17,154,61,
68,74,9,16,65,18,2,119,255,255,224,113,202,253,169,17,95,18,242,45,
201,17,2,94,1,0,37,102,60,130,4,106,139,143,1,0,140,23,1,0,
65,90,65,98,145,17,218,5,224,137,178,5,95,106,218,245,224,17,186,29,
32,86,16,0,36,22,36,136,65,74,9,135,255,255,65,18,224,129,66,135,
255,255,186,5,95,18,181,5,95,82,218,245,224,81,226,5,66,7,0,0,
65,18,95,82,202,253,68,7,52,136,197,5,65,74,232,73,193,181,38,6,
248,46,133,0,36,62,36,136,130,255,146,100,64,6,127,0,128,7,33,0,
199,0,97,50,209,5,194,13,98,50,130,37,197,37,38,6,16,47,133,0,
130,255,114,100,129,255,254,186,197,29,219,58,159,58,226,13,38,6,56,47,
133,0,130,255,92,100,31,50,191,255,120,175,128,255,42,19,191,255,128,175,
197,13,38,6,32,47,133,0,130,255,66,100,229,5,38,6,72,47,133,0,
130,255,54,100,32,54,244,1,130,255,36,52,37,54,64,130,130,255,38,100,
64,6,63,0,134,7,225,112,7,208,218,0,6,216,128,255,36,156,224,81,
218,5,38,6,156,47,133,0,229,125,0,226,1,202,27,48,0,58,0,66,
3,72,128,255,216,18,10,232,27,48,29,56,128,255,214,18,61,143,0,0,
224,137,218,253,61,135,12,0,224,129,234,5,227,23,3,0,224,17,170,5,
2,200,125,7,0,0,29,48,191,255,8,238,218,118,1,0,242,29,27,48,
129,255,170,13,10,224,224,225,234,13,27,48,128,255,140,156,10,64,27,72,
32,54,34,0,39,6,176,47,133,0,191,255,50,176,149,21,28,6,255,239,
242,5,38,6,108,47,133,0,130,255,142,99,133,13,0,226,229,5,38,6,
84,47,133,0,130,255,126,99,224,201,130,53,4,95,128,142,224,89,202,45,
222,210,159,210,242,29,224,225,218,29,27,48,129,255,198,13,10,224,28,6,
160,253,138,13,27,64,15,50,37,62,68,130,191,255,224,175,197,21,224,225,
250,5,38,6,196,47,133,0,130,255,62,99,197,13,38,6,132,47,133,0,
130,255,50,99,229,5,38,6,220,47,133,0,130,255,38,99,32,54,244,1,
130,255,20,51,229,5,38,6,244,47,133,0,130,255,18,99,37,54,76,130,
130,255,10,99,70,6,255,112,154,7,225,243,230,0,61,6,196,25,134,0,
0,218,34,6,36,25,134,0,34,135,0,0,240,49,226,5,72,18,65,218,
27,6,239,255,134,253,27,6,239,255,170,5,95,218,32,54,16,0,130,255,
96,77,10,224,224,225,242,5,124,7,5,0,124,7,9,0,124,7,13,0,
67,7,12,0,32,86,232,3,99,87,49,0,3,18,67,23,44,0,67,23,
36,0,67,23,28,0,32,22,44,1,99,23,33,0,2,18,67,23,20,0,
32,22,100,0,99,23,25,0,99,23,17,0,60,23,5,0,32,86,88,2,
99,87,41,0,0,82,224,17,210,5,60,87,9,0,162,81,163,82,0,90,
224,17,210,5,60,95,13,0,162,89,163,90,60,103,9,0,235,81,12,56,
249,29,7,192,24,208,1,202,26,80,224,81,130,21,224,81,234,5,8,50,
130,255,210,76,224,81,146,13,3,23,44,0,74,23,0,0,35,23,49,0,
106,23,5,0,95,202,72,210,224,201,186,237,24,94,8,0,124,95,9,0,
181,13,224,17,178,5,162,97,163,98,28,48,1,66,35,78,44,0,128,255,
96,7,195,218,99,223,5,0,50,6,36,25,134,0,210,217,59,191,5,0,
10,82,0,194,74,184,128,7,34,1,60,23,5,0,0,82,224,17,210,5,
60,87,9,0,162,81,163,82,0,90,224,17,210,5,60,95,13,0,162,89,
163,90,60,103,9,0,235,81,12,56,249,29,7,200,25,216,1,210,27,80,
224,81,130,21,224,81,234,5,8,50,130,255,60,76,224,81,146,13,3,23,
12,0,74,23,0,0,35,23,17,0,106,23,5,0,95,210,72,218,224,209,
186,237,25,142,8,0,124,143,9,0,181,21,224,17,194,5,162,97,163,98,
186,5,0,218,197,5,7,216,162,217,163,218,28,48,1,66,35,78,12,0,
128,255,190,6,195,218,219,177,60,23,5,0,0,82,224,17,210,5,60,87,
9,0,162,81,163,82,0,90,224,17,210,5,60,95,13,0,162,89,163,90,
60,103,9,0,235,81,12,56,249,29,7,200,25,216,1,210,27,80,224,81,
130,21,224,81,234,5,8,50,130,255,178,75,224,81,146,13,3,23,28,0,
74,23,0,0,35,23,33,0,106,23,5,0,95,210,72,218,224,209,186,237,
25,134,8,0,124,135,9,0,245,21,224,17,194,5,162,97,163,98,186,5,
0,218,197,5,7,216,162,217,163,218,28,48,1,66,35,78,28,0,128,255,
52,6,35,159,1,0,195,218,219,153,99,159,1,0,65,194,247,193,190,5,
191,7,222,254,224,185,226,61,60,23,5,0,0,82,224,17,210,5,60,87,
9,0,162,81,163,82,0,90,224,17,210,5,60,95,13,0,162,89,163,90,
60,103,9,0,235,81,12,56,249,29,7,200,25,216,1,210,27,80,224,81,
130,21,224,81,234,5,8,50,130,255,18,75,224,81,146,13,3,23,36,0,
74,23,0,0,35,23,41,0,106,23,5,0,95,210,72,218,224,209,186,237,
25,126,8,0,124,127,9,0,181,13,224,17,178,5,162,97,163,98,28,48,
1,66,35,78,36,0,128,255,160,5,35,23,5,0,50,6,36,25,134,0,
210,17,34,23,5,0,10,82,0,194,234,23,128,186,128,7,26,1,60,23,
5,0,0,82,224,17,210,5,60,87,9,0,162,81,163,82,0,90,224,17,
210,5,60,95,13,0,162,89,163,90,60,103,9,0,235,81,12,56,249,29,
7,200,25,216,1,210,27,80,224,81,130,21,224,81,234,5,8,50,130,255,
124,74,224,81,146,13,3,23,20,0,74,23,0,0,35,23,25,0,106,23,
5,0,95,210,72,218,224,209,186,237,25,118,8,0,124,119,9,0,181,21,
224,17,194,5,162,97,163,98,186,5,0,218,197,5,7,216,162,217,163,218,
28,48,1,66,35,78,20,0,128,255,254,4,195,218,219,185,60,23,5,0,
0,82,224,17,210,5,60,87,9,0,162,81,163,82,0,90,224,17,210,5,
60,95,13,0,162,89,163,90,60,103,9,0,235,81,12,56,249,29,7,200,
25,216,1,210,27,80,224,81,130,21,224,81,234,5,8,50,130,255,242,73,
224,81,146,13,3,23,28,0,74,23,0,0,35,23,33,0,106,23,5,0,
95,210,72,218,224,209,186,237,25,110,8,0,124,111,9,0,181,21,224,17,
194,5,162,97,163,98,186,5,0,218,197,5,7,216,162,217,163,218,28,48,
1,66,35,78,28,0,128,255,116,4,195,218,219,177,65,194,35,23,5,0,
50,6,36,25,134,0,210,17,34,23,5,0,10,82,234,23,128,18,226,193,
190,5,191,7,208,254,28,48,129,255,34,57,90,6,255,243,128,7,33,0,
36,63,121,176,38,6,164,48,133,0,130,255,220,94,36,63,93,144,38,6,
44,48,133,0,130,255,206,94,32,63,1,177,38,6,64,48,133,0,130,255,
192,94,128,255,172,13,10,56,38,6,84,48,133,0,130,255,176,94,32,63,
53,176,38,6,104,48,133,0,130,255,162,94,128,255,150,13,10,56,38,6,
124,48,133,0,130,255,146,94,32,63,217,176,38,6,144,48,133,0,130,255,
132,94,64,6,63,0,132,7,225,16,198,0,224,49,146,21,228,119,121,142,
32,62,16,0,0,66,6,113,100,119,120,142,100,7,33,136,32,54,12,177,
191,255,44,202,128,7,62,1,35,54,3,0,35,62,4,0,129,255,242,233,
10,88,32,22,60,0,36,231,33,136,226,95,194,2,228,239,121,142,28,6,
237,255,170,13,11,110,5,0,32,102,96,39,236,111,128,154,100,159,29,136,
181,45,28,6,237,255,135,45,36,87,29,136,0,234,171,81,106,82,183,5,
100,7,29,136,0,18,228,103,131,142,2,136,193,138,46,6,176,28,141,0,
206,137,36,159,29,136,49,87,0,0,234,153,223,5,234,89,182,5,12,233,
221,0,65,18,103,18,230,237,224,233,210,5,0,226,100,7,33,136,197,5,
28,6,237,255,239,5,38,6,200,48,133,0,130,255,194,93,28,6,240,255,
206,13,28,56,38,6,236,48,133,0,130,255,176,93,28,48,29,56,191,255,
138,249,181,45,28,6,237,255,238,13,28,222,240,255,27,56,38,6,184,48,
133,0,130,255,144,93,27,48,29,56,191,255,254,248,181,29,28,6,237,255,
234,5,38,6,212,48,133,0,130,255,118,93,229,87,64,0,224,7,96,1,
10,248,36,87,33,136,234,225,250,5,28,142,1,0,100,143,33,136,100,7,
120,142,255,47,32,0,197,29,229,87,64,0,224,7,96,1,36,135,33,136,
10,248,240,225,170,13,28,126,1,0,100,127,33,136,228,103,121,142,29,97,
100,103,120,142,255,47,32,0,32,54,12,177,32,62,16,0,0,66,191,255,
238,200,68,6,255,16,4,135,96,144,198,126,1,0,196,122,32,22,0,1,
208,134,239,0,15,129,68,135,96,144,224,49,178,5,32,22,0,4,50,6,
20,0,32,0,114,23,0,0,127,0,128,7,97,0,6,232,189,0,68,239,
124,142,224,233,226,55,0,0,191,255,194,255,98,234,146,13,99,234,154,13,
36,127,93,144,65,122,100,127,93,144,181,5,100,7,93,144,64,6,127,0,
128,7,97,0,6,232,189,0,68,239,124,142,167,0,68,63,125,142,0,50,
191,255,142,255,196,191,96,144,99,234,210,5,100,7,93,144,100,7,96,144,
64,6,127,0,128,7,33,0,68,7,128,142,38,6,204,204,68,68,129,255,
204,92,191,255,224,239,128,255,116,11,128,255,120,11,191,255,234,172,128,255,
120,11,129,255,46,211,129,255,174,129,128,255,116,11,129,255,134,123,129,255,
32,124,128,255,112,11,128,255,116,11,128,255,120,11,128,255,124,11,128,255,
128,11,191,255,66,230,191,255,94,169,129,255,100,196,128,255,132,175,128,255,
50,154,128,255,148,80,128,255,166,80,128,255,104,11,129,255,212,232,129,255,
140,181,128,255,144,211,191,255,138,245,129,255,192,210,128,255,88,11,0,82,
0,18,43,6,176,28,141,0,107,23,0,0,2,22,160,5,66,90,65,82,
103,82,150,253,3,138,100,143,130,142,38,6,255,255,17,17,129,255,46,92,
38,6,187,187,85,85,129,255,36,92,64,6,63,0,128,7,225,0,0,226,
0,50,128,255,28,11,172,82,10,232,1,50,128,255,18,11,140,82,196,82,
10,233,68,239,126,142,36,102,56,136,12,54,4,0,29,64,168,0,37,62,
80,130,130,255,210,81,38,6,248,48,133,0,36,62,56,136,130,255,142,91,
4,55,126,142,6,6,240,255,166,5,1,226,128,255,222,10,0,50,191,255,
100,254,128,255,62,253,191,255,36,246,38,6,238,238,34,34,129,255,182,91,
38,6,153,153,119,119,129,255,172,91,64,86,0,0,10,87,8,240,138,0,
64,87,48,177,28,48,191,255,66,175,38,6,112,28,141,0,129,255,166,41,
40,6,112,28,141,0,0,50,32,62,80,0,129,255,122,228,10,232,29,48,
129,255,248,227,4,119,96,144,100,87,122,142,10,56,231,0,224,57,234,127,
0,0,206,118,247,0,207,110,1,0,195,106,13,113,68,119,96,144,224,57,
210,5,7,6,192,253,130,13,213,13,38,6,36,49,133,0,130,255,238,90,
197,13,38,6,12,49,133,0,130,255,226,90,229,5,38,6,48,49,133,0,
130,255,214,90,29,48,129,255,78,125,29,48,128,255,50,10,29,48,130,255,
214,70,129,255,88,224,129,255,178,223,129,255,138,223,191,255,204,198,191,255,
204,224,64,6,255,0,168,7,225,243,41,87,1,0,35,22,8,0,98,87,
1,0,41,87,5,0,6,224,8,216,7,192,98,87,5,0,60,23,5,0,
0,210,46,6,255,255,255,31,61,6,196,25,134,0,224,17,210,5,60,215,
13,0,162,209,163,210,224,217,186,5,128,7,94,8,0,82,224,17,210,5,
60,87,9,0,162,81,163,82,14,96,170,97,251,97,177,5,128,7,134,5,
42,6,208,46,133,0,15,90,99,95,41,0,35,102,20,0,99,7,37,0,
76,7,0,0,10,16,65,18,2,127,255,255,224,121,202,253,35,94,16,0,
170,17,2,206,255,255,11,16,34,111,25,0,10,192,13,6,240,255,201,5,
34,95,5,0,181,5,34,94,4,0,235,81,185,5,128,7,164,1,34,103,
25,0,12,6,240,255,201,5,34,103,5,0,181,5,34,102,4,0,34,95,
21,0,204,89,234,89,187,5,128,7,130,1,35,87,41,0,35,22,20,0,
10,6,240,255,185,5,35,23,21,0,35,135,37,0,24,216,162,217,251,129,
217,5,35,54,16,0,130,255,154,58,35,23,37,0,2,224,187,225,252,201,
169,5,25,224,64,214,134,0,58,215,201,97,219,225,252,17,217,5,35,54,
16,0,130,255,118,58,35,23,37,0,188,17,250,17,169,5,2,208,224,209,
210,69,35,87,41,0,35,102,20,0,10,6,240,255,185,5,35,103,21,0,
28,88,204,89,35,102,20,0,10,6,240,255,185,5,35,103,21,0,220,97,
218,97,186,17,226,29,11,104,172,105,226,105,171,21,2,80,203,81,10,94,
255,255,2,128,204,129,16,102,255,255,12,127,0,0,95,98,75,127,0,0,
95,90,95,18,154,253,149,13,12,119,0,0,65,98,75,119,0,0,65,90,
95,18,154,253,35,111,37,0,35,103,41,0,186,105,35,22,20,0,12,6,
240,255,185,5,35,23,21,0,99,111,37,0,194,105,77,7,0,0,35,87,
37,0,251,81,169,5,10,216,224,217,186,5,128,7,144,1,35,23,41,0,
35,126,20,0,2,6,240,255,185,5,35,127,21,0,35,94,20,0,2,6,
240,255,185,5,35,95,21,0,27,128,203,129,10,16,187,17,226,29,15,80,
176,81,226,81,171,21,2,112,207,113,14,126,255,255,2,104,208,105,13,134,
255,255,16,103,0,0,95,130,79,103,0,0,95,122,95,18,154,253,149,13,
16,95,0,0,65,130,79,95,0,0,65,122,95,18,154,253,35,87,37,0,
35,135,41,0,187,81,35,22,20,0,16,6,240,255,185,5,35,23,21,0,
99,87,37,0,194,81,74,7,0,0,128,7,6,1,25,216,126,218,211,5,
35,54,16,0,130,255,4,59,35,23,41,0,251,17,217,77,35,215,37,0,
155,230,15,0,126,226,179,5,27,224,245,13,28,112,3,106,237,119,194,2,
2,80,129,82,234,113,249,5,30,98,170,97,236,17,187,5,10,224,194,225,
28,54,1,0,130,255,166,66,10,184,224,209,226,13,35,87,41,0,35,62,
20,0,23,48,10,6,240,255,185,5,35,63,21,0,26,64,191,255,120,157,
35,135,41,0,16,6,240,255,217,5,35,55,21,0,130,255,246,67,15,122,
99,127,41,0,35,86,20,0,99,7,37,0,74,7,0,0,99,191,21,0,
99,231,41,0,35,22,20,0,28,6,240,255,169,5,23,16,99,215,37,0,
194,209,90,7,0,0,229,13,224,217,202,13,35,86,20,0,2,6,240,255,
185,5,35,87,21,0,99,7,37,0,74,7,0,0,224,217,194,29,35,87,
41,0,35,54,20,0,10,6,240,255,185,5,35,55,21,0,24,56,25,64,
191,255,252,156,35,135,41,0,35,22,20,0,16,6,240,255,185,5,35,23,
21,0,99,207,37,0,194,201,89,7,0,0,35,102,16,0,37,22,40,130,
99,23,45,0,61,22,244,254,99,23,49,0,15,114,99,119,77,0,35,86,
56,0,99,7,73,0,74,7,0,0,64,222,134,0,59,223,201,97,35,231,
37,0,27,16,252,17,169,5,2,224,35,94,52,0,236,89,170,93,35,87,
73,0,252,81,217,5,35,54,52,0,130,255,238,55,35,23,73,0,188,17,
251,17,169,5,2,216,224,217,186,5,128,7,162,1,35,87,77,0,35,94,
56,0,10,6,240,255,185,5,35,95,57,0,28,96,203,97,35,94,56,0,
10,6,240,255,185,5,35,95,57,0,203,225,27,104,220,105,187,17,226,29,
12,112,173,113,226,113,171,21,2,88,204,89,11,102,255,255,2,80,205,81,
10,110,255,255,13,135,0,0,95,106,76,135,0,0,95,98,95,18,154,253,
149,13,13,127,0,0,65,106,76,127,0,0,65,98,95,18,154,253,35,119,
73,0,35,111,77,0,187,113,35,22,56,0,13,6,240,255,185,5,35,23,
57,0,99,119,73,0,194,113,78,7,0,0,128,7,20,1,126,226,211,5,
35,54,52,0,130,255,16,57,35,23,77,0,252,17,217,77,35,215,73,0,
156,222,15,0,126,218,179,5,28,216,245,13,27,88,3,82,234,95,194,2,
2,96,129,98,236,89,249,5,30,130,172,129,240,17,187,5,12,216,194,217,
27,54,1,0,130,255,178,64,10,200,224,209,226,13,35,119,77,0,35,62,
56,0,25,48,14,6,240,255,185,5,35,63,57,0,26,64,191,255,132,155,
35,111,77,0,13,6,240,255,217,5,35,55,57,0,130,255,2,66,15,98,
99,103,77,0,35,86,56,0,99,7,73,0,74,7,0,0,99,207,57,0,
99,223,77,0,35,22,56,0,27,6,240,255,169,5,25,16,99,215,73,0,
194,209,90,7,0,0,229,13,224,225,202,13,35,86,56,0,2,6,240,255,
185,5,35,87,57,0,99,7,73,0,74,7,0,0,224,225,194,37,35,119,
77,0,35,54,56,0,14,6,240,255,185,5,35,55,57,0,35,111,41,0,
35,62,20,0,13,6,240,255,185,5,35,63,21,0,28,64,191,255,248,154,
35,103,77,0,35,22,56,0,12,6,240,255,185,5,35,23,57,0,99,231,
73,0,194,225,92,7,0,0,61,22,20,255,99,23,49,0,64,230,134,0,
60,231,205,97,35,238,44,0,224,225,226,5,29,48,63,6,210,101,128,0,
124,0,35,23,49,0,2,22,24,0,34,55,0,0,34,87,5,0,63,6,
236,101,128,0,221,49,106,0,29,48,130,255,140,49,35,135,77,0,16,6,
240,255,217,5,35,55,57,0,130,255,24,65,15,122,99,127,77,0,35,86,
56,0,99,7,73,0,74,7,0,0,35,103,41,0,12,6,240,255,217,5,
35,55,21,0,130,255,244,64,15,90,99,95,41,0,35,86,20,0,99,7,
37,0,74,7,0,0,128,7,194,2,0,82,224,17,210,5,60,87,9,0,
162,81,163,82,27,104,202,105,237,209,177,5,128,7,118,1,0,82,26,88,
129,90,14,96,171,97,250,97,177,5,11,80,218,81,10,208,0,82,224,17,
210,5,60,87,9,0,162,81,163,82,27,128,202,129,240,209,169,13,0,82,
224,17,210,5,60,87,9,0,162,81,163,82,27,208,202,209,238,209,179,29,
36,111,237,143,224,105,186,21,1,98,100,103,237,143,34,6,192,46,133,0,
100,23,229,143,61,22,52,255,36,142,232,143,113,23,1,0,61,54,84,255,
130,255,16,57,36,54,228,143,130,255,178,48,26,200,195,202,25,48,130,255,
196,62,60,239,5,0,99,199,5,0,10,176,22,208,213,21,26,80,224,81,
130,21,224,81,234,5,8,50,130,255,166,62,224,81,146,13,29,23,0,0,
74,23,0,0,61,23,5,0,106,23,5,0,72,210,72,234,248,233,186,237,
99,215,1,0,26,232,27,208,35,199,13,0,3,191,8,0,149,21,29,80,
224,81,194,13,224,81,234,5,8,50,130,255,104,62,224,81,210,5,74,191,
0,0,106,199,5,0,95,210,72,234,224,209,250,237,35,215,1,0,27,80,
195,82,60,199,9,0,202,209,99,215,1,0,35,239,5,0,213,21,26,80,
224,81,130,21,224,81,234,5,8,50,130,255,44,62,224,81,146,13,29,23,
0,0,74,23,0,0,61,23,5,0,106,23,5,0,72,210,72,234,248,233,
186,237,60,55,5,0,0,18,224,49,210,5,60,23,9,0,166,17,163,18,
194,217,224,49,162,13,60,87,9,0,6,16,165,5,72,18,234,17,234,253,
130,255,104,63,214,201,124,207,13,0,195,218,214,217,124,223,9,0,124,183,
5,0,128,7,54,1,60,23,9,0,24,200,2,120,185,121,163,122,251,121,
153,85,2,192,27,184,195,186,23,208,217,209,25,232,213,21,26,80,224,81,
130,21,224,81,234,5,8,50,130,255,162,61,224,81,146,13,29,23,0,0,
74,23,0,0,61,23,5,0,106,23,5,0,72,210,72,234,248,233,186,237,
60,239,9,0,35,215,13,0,3,199,8,0,29,96,185,97,163,98,172,217,
149,21,29,80,224,81,194,13,224,81,234,5,8,50,130,255,96,61,224,81,
210,5,74,199,0,0,106,215,5,0,95,218,72,234,224,217,250,237,60,87,
9,0,25,56,215,81,124,87,9,0,183,81,197,13,35,22,8,0,34,95,
1,0,103,95,1,0,34,23,5,0,103,23,5,0,72,58,234,57,202,245,
165,69,2,208,27,192,195,194,26,232,184,233,2,216,213,21,27,80,224,81,
130,21,224,81,234,5,8,50,130,255,2,61,224,81,146,13,29,23,0,0,
74,23,0,0,61,23,5,0,106,23,5,0,72,218,72,234,250,233,186,237,
124,223,9,0,25,96,26,16,184,17,26,80,181,13,88,18,34,95,1,0,
88,82,106,95,1,0,34,95,5,0,106,95,5,0,226,97,218,245,25,16,
24,216,217,217,197,13,35,86,8,0,42,95,1,0,98,95,1,0,42,87,
5,0,98,87,5,0,72,18,251,17,202,245,104,6,255,243,224,49,210,5,
129,58,185,5,130,7,16,62,127,0,130,7,108,46,130,7,104,46,128,7,
225,0,6,232,7,224,224,233,130,29,61,135,33,0,16,6,240,255,217,5,
61,55,13,0,130,255,232,61,15,122,125,127,33,0,61,86,12,0,125,7,
29,0,74,7,0,0,129,226,201,5,29,48,130,255,204,61,64,6,255,0,
130,7,38,46,38,135,33,0,16,6,240,255,201,5,38,87,13,0,181,5,
38,86,12,0,127,0,128,7,225,0,6,232,7,224,224,233,130,29,61,135,
33,0,16,6,240,255,217,5,61,55,13,0,130,255,144,61,15,122,125,127,
33,0,61,86,12,0,125,7,29,0,74,7,0,0,129,226,201,5,29,48,
130,255,116,61,64,6,255,0,127,0,38,87,1,0,127,0,224,49,210,5,
129,58,185,5,130,7,92,61,127,0,224,49,210,5,129,58,185,5,130,7,
78,61,127,0,224,49,210,5,129,58,185,5,130,7,64,61,127,0,33,6,
92,169,1,0,97,0,33,6,244,51,1,0,97,0,33,6,224,20,0,0,
97,0,33,6,76,54,1,0,97,0,33,6,180,97,1,0,97,0,33,6,
176,54,1,0,97,0,33,6,98,23,0,0,97,0,33,6,82,103,1,0,
97,0,33,6,48,107,1,0,97,0,33,6,46,42,1,0,97,0,33,6,
94,38,1,0,97,0,33,6,126,98,0,0,97,0,33,6,242,99,0,0,
97,0,33,6,238,137,0,0,97,0,33,6,186,173,1,0,97,0,33,6,
2,36,0,0,97,0,33,6,122,103,0,0,97,0,33,6,130,106,0,0,
97,0,33,6,160,37,0,0,97,0,128,7,33,0,64,14,0,0,65,7,
52,215,38,6,196,25,134,0,130,255,72,53,64,14,0,0,65,7,88,215,
38,6,208,25,134,0,130,255,54,53,64,6,63,0,224,49,210,5,129,58,
185,5,130,7,110,60,127,0,224,49,210,5,129,58,185,5,130,7,96,60,
127,0,198,207,2,0,1,138,226,87,0,0,103,143,1,0,127,0,198,143,
2,0,1,82,102,87,125,0,127,0,128,7,225,0,6,232,61,143,125,0,
7,224,97,138,186,13,60,63,1,0,221,15,2,0,128,255,60,2,224,81,
250,5,125,87,125,0,29,48,28,56,128,255,52,2,64,6,255,0,128,7,
97,0,6,232,29,143,7,0,123,138,234,5,38,6,240,50,133,0,130,255,
232,79,29,63,1,0,61,71,108,0,38,6,252,50,133,0,130,255,214,79,
61,63,117,0,61,71,113,0,38,6,12,51,133,0,130,255,196,79,29,48,
128,255,246,1,228,87,76,2,38,6,224,50,133,0,10,56,10,104,191,106,
150,106,205,57,170,58,130,255,164,79,29,63,2,0,38,6,36,51,133,0,
222,58,159,58,130,255,146,79,64,6,127,0,128,7,97,0,6,232,29,143,
7,0,123,138,234,5,38,6,52,51,133,0,130,255,118,79,29,63,1,0,
61,71,108,0,38,6,64,51,133,0,130,255,100,79,61,63,117,0,61,71,
113,0,38,6,80,51,133,0,130,255,82,79,29,48,128,255,132,1,228,87,
76,2,38,6,104,51,133,0,10,56,10,104,191,106,150,106,205,57,170,58,
130,255,50,79,64,6,127,0,130,7,97,0,6,232,3,48,128,255,98,1,
195,199,0,0,178,5,195,63,0,0,35,127,0,0,125,127,0,0,35,119,
2,0,29,80,125,119,2,0,66,6,127,0,128,7,97,0,6,232,29,143,
7,0,123,138,234,5,38,6,144,51,133,0,130,255,234,78,29,63,1,0,
61,71,108,0,38,6,156,51,133,0,130,255,216,78,61,63,117,0,61,71,
113,0,38,6,120,51,133,0,130,255,198,78,64,6,127,0,128,7,225,0,
6,232,29,231,7,0,28,6,225,255,234,29,29,135,0,0,224,129,138,21,
61,23,105,0,2,22,96,0,34,55,0,0,34,127,5,0,63,6,122,108,
128,0,221,49,111,0,224,81,178,13,61,119,117,0,139,114,203,114,125,119,
121,0,14,118,0,248,125,119,117,0,29,48,128,255,186,0,28,6,225,255,
186,5,221,7,2,0,221,199,2,0,242,5,61,127,117,0,15,126,0,8,
125,127,121,0,64,6,255,0,128,7,225,0,6,232,7,224,224,233,146,13,
0,58,128,255,96,0,129,226,201,5,29,48,130,255,72,58,64,6,255,0,
198,143,2,0,127,0,1,82,127,0,128,7,225,0,6,232,7,224,224,233,
146,13,0,58,128,255,54,0,129,226,201,5,29,48,130,255,30,58,64,6,
255,0,128,7,225,0,6,232,7,224,224,233,146,13,0,58,128,255,22,0,
129,226,201,5,29,48,130,255,254,57,64,6,255,0,0,82,127,0,33,6,
62,139,0,0,97,0,33,6,64,111,0,0,97,0,33,6,166,140,0,0,
97,0,33,6,192,123,0,0,97,0,33,6,254,140,0,0,97,0,33,6,
58,141,0,0,97,0,128,7,225,0,6,232,7,224,224,233,146,13,0,58,
191,255,194,255,129,226,201,5,29,48,130,255,170,57,64,6,255,0,198,143,
2,0,127,0,1,82,127,0,128,7,225,0,6,232,7,224,224,233,146,13,
0,58,128,255,18,0,129,226,201,5,29,48,130,255,128,57,64,6,255,0,
33,6,152,174,0,0,97,0,168,7,225,243,99,55,25,0,7,184,55,207,
13,0,55,199,9,0,99,71,37,0,38,23,14,0,224,201,146,37,99,23,
41,0,2,72,191,74,99,79,45,0,24,48,25,56,2,64,130,255,64,99,
35,23,41,0,11,232,35,223,45,0,10,224,2,88,2,208,234,23,34,10,
29,16,252,223,32,2,235,23,32,2,252,215,32,2,1,80,202,17,194,217,
149,13,24,224,226,231,194,2,0,218,28,208,0,234,226,215,34,2,186,193,
99,199,9,0,55,151,1,0,35,95,25,0,35,111,9,0,55,199,18,0,
99,151,29,0,43,95,14,0,216,105,235,105,243,13,191,255,242,214,35,151,
29,0,10,16,42,6,68,205,1,0,98,87,5,0,98,151,9,0,99,23,
29,0,55,207,5,0,55,135,16,0,55,127,25,0,35,87,9,0,99,207,
57,0,99,135,68,0,99,127,77,0,10,136,218,81,99,87,61,0,225,23,
0,0,219,17,99,23,65,0,247,119,23,0,35,111,25,0,50,6,64,44,
1,0,99,119,74,0,195,151,74,0,45,111,14,0,99,7,13,0,99,151,
21,0,177,105,248,105,248,111,60,91,99,95,70,0,35,55,25,0,38,55,
81,0,99,7,1,0,28,64,29,72,128,255,162,18,99,87,33,0,229,87,
64,0,224,7,96,1,35,143,25,0,49,159,93,0,49,151,89,0,10,248,
99,159,45,0,99,151,41,0,255,47,32,0,35,135,45,0,35,223,65,0,
35,215,61,0,240,233,171,21,209,5,35,119,41,0,238,225,217,13,35,151,
29,0,35,55,33,0,99,151,53,0,1,146,99,151,5,0,128,255,84,18,
245,101,35,103,45,0,236,233,234,77,35,87,41,0,234,225,170,77,35,151,
25,0,210,247,2,0,210,69,191,255,244,213,35,151,29,0,106,151,9,0,
35,151,33,0,106,151,33,0,35,151,21,0,99,87,53,0,10,128,35,143,
25,0,106,151,5,0,1,146,112,151,0,0,99,151,5,0,49,23,105,0,
2,22,48,1,34,55,0,0,34,127,5,0,63,6,130,111,128,0,209,49,
111,0,35,119,25,0,10,176,46,119,14,0,35,71,9,0,22,184,14,16,
14,120,234,23,34,10,238,95,32,2,191,122,1,80,239,191,32,2,238,183,
32,2,202,89,203,185,214,65,99,71,61,0,225,23,0,0,215,17,99,23,
65,0,229,21,191,255,108,213,35,151,29,0,106,151,9,0,35,151,33,0,
106,151,33,0,35,151,21,0,99,87,53,0,99,7,5,0,106,151,5,0,
1,146,106,151,0,0,35,151,37,0,35,62,52,0,224,145,218,29,35,87,
5,0,35,143,25,0,194,82,49,102,16,0,202,97,44,23,1,0,49,94,
16,0,203,81,34,23,105,0,42,87,1,0,72,18,34,55,0,0,34,135,
5,0,63,6,44,112,128,0,202,49,112,0,213,29,35,87,5,0,35,143,
25,0,194,82,49,118,16,0,202,113,46,23,1,0,49,94,16,0,203,81,
34,23,105,0,42,87,1,0,2,22,16,0,34,55,0,0,34,95,5,0,
63,6,102,112,128,0,202,49,107,0,35,151,13,0,35,23,70,0,65,146,
99,151,13,0,162,193,248,0,224,193,210,53,2,80,2,104,191,106,218,81,
99,87,61,0,225,23,0,0,205,17,219,17,99,23,65,0,57,23,17,0,
35,95,68,0,137,18,35,87,70,0,171,17,245,5,25,206,20,0,57,23,
17,0,0,90,137,18,162,81,156,253,203,17,35,127,25,0,194,81,99,87,
68,0,99,207,57,0,47,127,14,0,99,7,9,0,248,121,248,127,60,115,
99,119,70,0,65,226,225,79,0,0,201,233,191,7,210,253,97,146,215,29,
229,87,64,0,224,7,96,1,35,255,29,0,35,143,13,0,63,255,0,0,
209,249,35,143,29,0,10,232,113,255,0,0,253,47,32,0,224,249,154,13,
35,55,29,0,38,111,5,0,63,6,32,113,128,0,109,0,104,6,255,243,
128,7,225,48,6,232,7,224,188,0,8,216,9,208,0,82,28,6,17,0,
138,45,61,127,17,0,47,23,105,0,2,22,200,0,34,55,0,0,34,119,
5,0,32,62,239,255,63,6,92,113,128,0,207,49,110,0,224,81,202,53,
61,103,21,0,28,88,44,23,105,0,11,56,27,64,2,22,200,0,34,55,
0,0,34,87,5,0,26,72,63,6,134,113,128,0,204,49,106,0,133,37,
127,226,234,29,29,127,7,0,15,6,81,0,154,29,61,127,101,0,61,111,
93,0,61,119,97,0,61,103,89,0,239,105,241,13,187,5,238,97,193,13,
61,23,85,0,93,231,7,0,224,17,226,5,1,114,66,119,5,1,125,7,
85,0,64,6,255,48,138,7,225,243,99,63,9,0,7,63,0,0,6,200,
98,58,146,13,38,6,228,59,133,0,130,255,36,73,0,82,128,7,180,2,
35,143,9,0,121,63,4,0,17,119,1,0,89,71,0,0,89,119,6,0,
17,111,5,0,89,111,7,0,17,103,2,0,89,79,1,0,0,80,121,103,
10,0,17,95,19,0,0,186,0,210,1,194,89,95,2,0,49,103,9,0,
49,111,13,0,0,226,9,176,204,81,225,23,0,0,205,17,121,87,89,0,
121,23,93,0,133,69,24,232,35,143,9,0,57,222,16,0,244,239,64,2,
209,233,189,55,1,0,220,217,128,255,28,15,123,87,1,0,57,110,16,0,
220,105,45,95,1,0,224,89,242,37,35,87,57,0,57,134,16,0,42,87,
1,0,220,129,25,119,0,0,99,87,5,0,48,87,1,0,65,114,42,23,
105,0,29,56,14,64,35,102,4,0,2,22,136,0,34,55,0,0,99,103,
1,0,34,95,5,0,22,72,202,49,63,6,178,114,128,0,107,0,10,184,
215,193,224,185,162,13,68,226,65,178,65,210,57,87,4,0,234,209,230,189,
224,185,202,5,0,82,128,7,206,1,57,23,21,0,57,87,17,0,34,119,
14,0,34,95,8,0,42,87,14,0,14,192,11,16,181,5,206,193,203,17,
234,193,214,253,25,135,7,0,16,6,225,255,170,21,121,7,10,0,24,80,
133,13,57,127,10,0,203,17,206,81,65,122,121,127,10,0,2,6,0,255,
206,5,10,6,0,252,198,245,57,103,10,0,57,95,17,0,236,119,32,2,
43,23,105,0,121,7,12,0,206,193,121,199,8,0,121,199,14,0,2,22,
24,0,34,55,0,0,34,87,5,0,63,6,84,115,128,0,203,49,106,0,
57,71,14,0,10,208,26,48,11,216,8,72,99,71,13,0,191,74,99,79,
17,0,27,56,130,255,172,93,35,23,13,0,10,64,121,199,117,0,11,72,
2,224,2,88,234,23,34,10,35,239,17,0,9,16,235,23,32,2,1,80,
232,239,32,2,202,17,232,231,32,2,194,233,251,233,203,13,177,5,250,225,
153,13,65,66,225,63,0,0,199,73,26,88,188,89,121,95,117,0,9,104,
8,80,1,114,174,81,121,87,109,0,57,87,21,0,225,95,0,0,141,89,
121,95,113,0,42,23,105,0,2,22,24,0,34,55,0,0,34,135,5,0,
63,6,234,115,128,0,202,49,112,0,99,87,13,0,99,95,17,0,57,71,
14,0,11,56,10,48,8,72,191,74,130,255,26,93,57,119,14,0,121,87,
97,0,121,95,101,0,10,104,238,95,32,2,14,16,234,23,34,10,13,232,
238,111,32,2,14,120,35,119,17,0,191,122,239,239,32,2,1,80,202,89,
203,233,238,233,187,21,209,5,35,103,13,0,236,105,233,13,57,103,97,0,
57,111,101,0,12,86,1,0,121,87,97,0,225,23,0,0,205,17,121,23,
101,0,57,87,97,0,57,95,101,0,11,81,234,5,1,82,121,87,97,0,
121,7,101,0,57,95,21,0,43,23,105,0,2,22,24,0,34,55,0,0,
34,87,5,0,63,6,142,116,128,0,203,49,106,0,251,89,219,5,177,5,
250,81,169,5,0,186,23,80,74,6,255,243,128,7,225,0,6,232,29,135,
7,0,16,6,225,255,250,5,93,7,2,0,125,7,89,0,125,7,93,0,
61,127,17,0,47,23,105,0,2,22,184,1,34,55,0,0,34,119,5,0,
63,6,218,116,128,0,207,49,110,0,10,224,224,225,242,37,61,103,21,0,
44,23,105,0,2,22,184,1,34,55,0,0,34,95,5,0,63,6,254,116,
128,0,204,49,107,0,10,224,224,81,210,21,29,135,7,0,16,6,225,255,
138,21,61,127,21,0,47,23,105,0,2,22,232,1,34,55,0,0,34,119,
5,0,63,6,44,117,128,0,207,49,110,0,29,111,7,0,127,106,210,5,
32,102,175,255,93,103,7,0,61,95,17,0,11,95,7,0,224,89,242,5,
61,87,21,0,10,87,7,0,224,81,186,5,0,18,165,29,224,225,178,29,
61,127,81,0,224,121,250,13,29,48,128,255,22,12,125,87,81,0,224,81,
138,13,38,6,36,60,133,0,130,255,142,69,0,18,229,5,221,207,2,0,
226,5,32,22,191,255,93,23,7,0,0,226,28,80,64,6,255,0,128,7,
225,0,6,232,7,224,224,233,194,53,61,63,81,0,49,6,236,45,134,0,
125,143,105,0,224,57,194,5,29,48,128,255,206,11,61,135,85,0,224,129,
146,13,38,6,68,60,133,0,32,62,51,6,0,66,191,255,250,143,61,23,
105,0,2,22,192,1,34,55,0,0,34,127,5,0,63,6,236,117,128,0,
221,49,111,0,29,63,0,0,29,71,1,0,38,6,84,60,133,0,130,255,
12,69,129,226,201,5,29,48,130,255,20,49,64,6,255,0,136,7,225,48,
6,232,221,207,2,0,7,208,162,21,29,135,7,0,16,6,65,0,218,13,
61,127,17,0,15,127,7,0,224,121,242,5,61,119,21,0,14,119,7,0,
224,113,202,5,32,86,44,1,181,101,0,218,32,54,124,1,130,255,78,47,
10,224,224,225,210,5,28,48,129,255,62,201,28,216,224,217,202,5,32,86,
145,3,165,85,38,6,124,60,133,0,130,255,156,68,27,48,26,56,35,110,
7,0,99,111,1,0,35,70,8,0,35,78,6,0,129,255,50,193,10,224,
224,225,250,53,163,95,7,0,224,89,178,53,38,6,172,60,133,0,130,255,
108,68,3,87,6,0,221,183,2,0,98,82,241,5,194,5,99,82,194,5,
149,37,221,55,2,0,35,87,9,0,35,95,13,0,221,143,2,0,31,66,
61,55,21,0,27,58,125,87,89,0,125,95,93,0,128,255,186,10,61,23,
105,0,2,22,184,1,34,55,0,0,34,135,5,0,63,6,240,118,128,0,
221,49,112,0,229,5,32,230,145,3,181,5,32,230,44,1,27,48,3,58,
129,255,24,197,28,80,72,6,255,48,128,7,225,208,6,224,60,135,21,0,
60,239,17,0,48,23,105,0,61,239,105,0,31,218,2,22,24,0,34,55,
0,0,34,119,5,0,29,238,24,0,63,6,60,119,128,0,208,49,110,0,
60,23,17,0,61,55,0,0,10,192,61,111,5,0,63,6,86,119,128,0,
194,49,11,200,109,0,235,201,225,5,187,5,234,193,179,5,32,222,17,0,
27,80,64,6,255,208,130,7,225,16,6,224,60,143,17,0,49,23,105,0,
7,216,2,22,160,1,34,55,0,0,34,135,5,0,3,56,63,6,146,119,
128,0,209,49,112,0,35,127,1,0,10,232,97,122,202,21,60,119,21,0,
46,23,105,0,2,22,160,1,34,55,0,0,34,111,5,0,3,56,63,6,
188,119,128,0,206,49,109,0,97,234,170,5,10,232,35,103,1,0,29,80,
123,103,1,0,66,6,255,16,128,7,225,16,8,216,187,0,6,232,61,23,
85,0,7,224,188,0,224,225,154,21,29,127,7,0,239,217,218,13,224,17,
178,13,125,7,85,0,1,114,66,119,5,1,38,6,244,60,133,0,130,255,
4,67,97,226,234,77,29,95,7,0,235,217,170,77,132,87,113,137,0,18,
224,81,226,5,36,143,117,137,224,137,170,5,1,18,130,0,224,17,210,61,
61,119,85,0,224,113,186,21,189,111,3,0,224,105,186,13,0,50,129,255,
70,128,125,87,85,0,38,6,24,61,133,0,130,255,186,66,61,103,85,0,
224,97,242,37,61,55,85,0,29,56,129,255,136,156,224,81,130,29,61,87,
85,0,224,81,226,13,42,23,241,13,72,18,34,55,0,0,34,95,5,0,
3,58,63,6,136,120,128,0,202,49,107,0,125,7,85,0,38,6,52,61,
133,0,245,5,1,82,93,87,3,0,38,6,204,60,133,0,130,255,102,66,
64,6,255,16,128,7,97,0,6,232,61,63,14,0,29,71,2,0,38,6,
92,61,133,0,7,128,159,130,208,57,161,58,217,66,159,66,130,255,62,66,
29,48,128,255,198,8,64,6,127,0,132,7,225,243,6,208,99,71,5,0,
58,95,101,0,7,216,59,207,13,0,59,199,9,0,59,191,18,0,58,87,
97,0,235,201,193,5,203,29,234,193,169,29,58,135,8,0,240,185,238,21,
58,127,17,0,47,23,105,0,35,71,5,0,2,22,184,0,34,63,0,0,
34,119,5,0,3,48,63,6,44,121,128,0,207,57,110,0,195,199,0,0,
218,5,32,86,34,1,128,7,16,1,58,183,17,0,58,103,14,0,11,106,
123,111,25,0,54,183,14,0,12,120,191,122,248,127,32,2,22,64,24,80,
12,16,234,23,34,10,12,16,22,72,249,23,32,2,1,80,23,232,202,17,
194,121,24,80,236,87,32,2,191,234,23,224,202,225,225,95,0,0,191,74,
28,48,203,233,207,233,29,56,130,255,144,87,123,87,9,0,123,95,13,0,
22,64,22,72,191,74,28,48,29,56,130,255,234,86,58,103,17,0,44,23,
105,0,123,87,18,0,35,71,5,0,2,22,136,1,34,55,0,0,34,95,
5,0,63,6,202,121,128,0,27,56,204,49,107,0,10,16,224,81,210,53,
58,103,14,0,24,80,24,112,23,88,236,119,32,2,12,120,12,16,191,122,
234,23,34,10,12,16,248,127,32,2,249,23,32,2,1,80,191,90,202,17,
194,121,23,80,206,81,123,87,9,0,15,96,225,111,0,0,205,89,204,89,
123,95,13,0,58,127,17,0,1,130,47,23,105,0,123,135,18,0,2,22,
80,0,34,55,0,0,34,119,5,0,27,56,63,6,54,122,128,0,207,49,
110,0,0,18,123,199,9,0,123,207,13,0,123,191,18,0,2,80,68,6,
255,243,138,7,225,243,6,192,99,71,13,0,99,79,17,0,56,95,101,0,
7,200,57,223,13,0,57,215,9,0,57,191,18,0,56,87,97,0,235,217,
193,5,219,29,234,209,185,29,56,135,8,0,240,185,254,21,56,127,17,0,
47,23,105,0,35,71,13,0,2,22,184,0,34,63,0,0,34,119,5,0,
35,54,4,0,63,6,166,122,128,0,207,57,110,0,195,199,4,0,202,5,
0,82,128,7,50,1,35,151,17,0,56,55,81,0,26,64,27,72,99,151,
1,0,128,255,162,6,56,103,14,0,56,183,17,0,12,106,121,111,25,0,
12,88,191,90,250,95,32,2,99,87,9,0,26,80,12,16,234,23,34,10,
54,183,14,0,12,16,251,23,32,2,1,80,22,72,22,64,202,17,194,89,
23,232,26,80,236,87,32,2,191,234,23,224,202,225,11,80,225,95,0,0,
191,74,28,48,203,233,202,233,29,56,130,255,254,85,121,87,9,0,121,95,
13,0,22,64,22,72,191,74,28,48,29,56,130,255,88,85,56,103,17,0,
44,23,105,0,121,87,18,0,35,79,17,0,35,71,13,0,2,22,128,1,
34,55,0,0,34,95,5,0,25,56,63,6,96,123,128,0,204,49,107,0,
10,48,224,49,194,5,128,255,6,6,181,53,56,103,14,0,26,80,23,112,
23,88,12,16,12,120,234,23,34,10,12,16,191,122,1,80,251,23,32,2,
250,127,32,2,250,103,32,2,202,17,194,121,191,90,204,113,121,119,9,0,
15,96,225,111,0,0,205,89,204,89,121,95,13,0,56,135,17,0,1,82,
48,23,105,0,121,87,18,0,2,22,72,0,34,55,0,0,34,127,5,0,
25,56,63,6,208,123,128,0,208,49,111,0,121,191,18,0,121,215,9,0,
121,223,13,0,35,87,9,0,74,6,255,243,128,7,97,48,7,232,38,71,
14,0,221,31,22,0,221,55,22,0,61,223,13,0,61,215,9,0,8,16,
8,72,27,120,26,112,14,80,14,104,232,119,32,2,234,23,34,10,191,74,
125,119,9,0,232,127,32,2,233,111,32,2,1,80,202,121,207,105,125,111,
13,0,38,95,113,0,38,87,109,0,235,217,193,21,187,5,234,209,147,21,
38,87,97,0,10,130,38,111,101,0,176,81,225,95,0,0,141,89,235,217,
235,5,177,5,234,209,185,5,221,159,22,0,38,135,21,0,48,23,105,0,
2,22,16,0,34,55,0,0,34,127,5,0,29,56,63,6,124,124,128,0,
208,49,111,0,221,159,22,0,0,82,125,223,13,0,125,215,9,0,64,6,
127,48,130,7,225,243,7,232,6,224,8,88,60,71,14,0,221,55,22,0,
61,215,9,0,8,16,8,72,61,223,13,0,26,112,14,80,14,104,232,119,
32,2,27,120,125,119,9,0,234,23,34,10,191,74,232,127,32,2,233,111,
32,2,1,80,202,121,207,105,125,111,13,0,60,55,81,0,99,95,1,0,
27,72,26,64,128,255,132,4,60,79,113,0,60,71,109,0,10,184,233,217,
161,21,187,5,232,209,243,13,61,231,25,0,32,102,17,0,125,103,25,0,
29,64,12,50,12,58,191,255,50,200,125,231,25,0,197,77,61,183,18,0,
233,217,250,5,232,209,218,5,60,119,117,0,125,119,18,0,220,247,2,0,
0,98,210,37,60,23,105,0,2,22,48,1,34,55,0,0,34,111,5,0,
63,6,74,125,128,0,220,49,109,0,60,119,14,0,10,96,12,200,14,16,
238,95,32,2,14,120,238,103,32,2,234,23,34,10,191,122,239,207,32,2,
1,80,202,89,203,201,125,207,13,0,125,103,9,0,1,98,60,86,16,0,
194,98,12,88,202,89,43,23,1,0,202,97,34,23,105,0,44,87,1,0,
72,18,34,55,0,0,34,127,5,0,29,56,63,6,166,125,128,0,202,49,
111,0,125,183,18,0,125,215,9,0,125,223,13,0,23,80,66,6,255,243,
134,7,225,48,7,216,59,87,9,0,59,95,13,0,6,224,99,87,5,0,
99,95,9,0,60,135,21,0,8,208,48,23,105,0,35,70,4,0,26,56,
0,234,2,22,80,1,34,55,0,0,34,127,5,0,63,6,250,125,128,0,
3,72,208,49,111,0,224,81,226,37,60,127,93,0,60,119,89,0,35,71,
5,0,60,55,14,0,35,79,9,0,14,80,14,104,230,119,32,2,6,56,
6,16,234,23,34,10,191,58,230,127,32,2,231,111,32,2,1,80,202,121,
207,105,237,73,225,23,0,0,237,73,226,239,0,0,238,65,225,87,0,0,
74,233,2,233,60,102,16,0,194,234,29,104,204,105,45,23,1,0,204,233,
34,23,105,0,61,87,1,0,2,22,96,1,34,55,0,0,202,49,34,87,
5,0,27,56,26,64,63,6,122,126,128,0,106,0,70,6,255,48,134,7,
225,112,7,216,59,87,9,0,59,95,13,0,6,224,99,87,5,0,99,95,
9,0,60,135,21,0,8,208,0,234,48,23,105,0,9,200,35,70,4,0,
26,56,2,22,80,1,34,55,0,0,34,127,5,0,63,6,194,126,128,0,
3,72,208,49,111,0,224,81,226,37,60,127,93,0,60,119,89,0,35,71,
5,0,60,55,14,0,35,79,9,0,14,80,14,104,230,119,32,2,6,56,
6,16,234,23,34,10,191,58,230,127,32,2,231,111,32,2,1,80,202,121,
207,105,237,73,225,23,0,0,237,73,226,239,0,0,238,65,225,87,0,0,
74,233,2,233,60,102,16,0,194,234,29,104,204,105,45,23,1,0,204,233,
34,23,105,0,61,87,1,0,2,22,88,1,34,55,0,0,27,56,202,49,
34,87,5,0,26,64,25,72,63,6,68,127,128,0,106,0,70,6,255,112,
128,7,33,0,6,143,7,0,127,138,154,21,38,135,21,0,48,23,105,0,
2,22,232,0,34,55,0,0,34,127,5,0,63,6,114,127,128,0,208,49,
111,0,181,5,128,255,40,2,64,6,63,0,128,7,33,0,6,143,7,0,
127,138,154,21,38,135,21,0,48,23,105,0,2,22,224,0,34,55,0,0,
34,127,5,0,63,6,166,127,128,0,208,49,111,0,181,5,128,255,252,1,
64,6,63,0,128,7,97,0,6,232,61,143,17,0,49,23,105,0,2,22,
112,0,34,55,0,0,34,135,5,0,63,6,212,127,128,0,209,49,112,0,
224,81,138,21,61,127,21,0,47,23,105,0,2,22,112,0,34,55,0,0,
34,119,5,0,63,6,246,127,128,0,207,49,110,0,64,6,127,0,128,7,
97,0,6,232,61,143,17,0,49,23,105,0,2,22,104,0,34,55,0,0,
34,135,5,0,63,6,30,128,128,0,209,49,112,0,224,81,138,21,61,127,
21,0,47,23,105,0,2,22,104,0,34,55,0,0,34,119,5,0,63,6,
64,128,128,0,207,49,110,0,64,6,127,0,1,66,191,7,98,237,0,66,
191,7,92,237,0,82,127,0,128,7,33,0,38,135,21,0,48,23,105,0,
2,22,208,1,34,55,0,0,34,127,5,0,63,6,118,128,128,0,208,49,
111,0,64,6,63,0,128,7,33,0,38,135,21,0,48,23,105,0,2,22,
200,1,34,55,0,0,34,127,5,0,63,6,156,128,128,0,208,49,111,0,
64,6,63,0,31,82,127,0,6,127,2,0,199,118,1,0,193,114,207,126,
253,0,14,121,70,127,2,0,127,0,128,7,33,0,38,135,21,0,48,23,
105,0,2,22,192,0,34,55,0,0,34,127,5,0,63,6,220,128,128,0,
208,49,111,0,64,6,63,0,128,7,33,0,38,135,21,0,48,23,105,0,
2,22,144,0,34,55,0,0,34,127,5,0,63,6,2,129,128,0,208,49,
111,0,64,6,63,0,0,82,127,0,0,82,127,0,128,7,33,0,38,135,
21,0,48,23,105,0,2,22,24,0,34,55,0,0,34,127,5,0,63,6,
48,129,128,0,208,49,111,0,64,6,63,0,128,7,33,0,38,135,17,0,
0,90,1,82,224,129,242,13,16,80,42,23,105,0,2,22,24,0,34,55,
0,0,34,127,5,0,63,6,96,129,128,0,202,49,111,0,64,6,63,0,
33,6,244,105,1,0,97,0,33,6,98,105,1,0,97,0,33,6,240,115,
0,0,97,0,33,6,220,106,1,0,97,0,33,6,138,106,1,0,97,0,
33,6,68,132,0,0,97,0,33,6,158,127,0,0,97,0,33,6,144,129,
0,0,97,0,33,6,150,130,0,0,97,0,39,55,1,0,32,142,40,1,
31,58,102,143,12,0,191,7,194,205,128,7,225,0,6,232,7,224,224,233,
210,29,49,6,220,47,134,0,17,22,192,1,34,55,0,0,34,135,5,0,
125,143,105,0,221,49,63,6,234,129,128,0,112,0,29,63,0,0,38,6,
124,61,133,0,130,255,18,57,129,226,201,5,29,48,130,255,26,37,64,6,
255,0,128,7,33,0,38,143,17,0,224,137,130,21,17,80,42,23,105,0,
2,22,40,1,34,55,0,0,34,135,5,0,63,6,46,130,128,0,202,49,
112,0,181,5,32,86,44,1,64,6,63,0,128,7,33,0,38,143,17,0,
224,137,130,21,17,80,42,23,105,0,2,22,240,0,34,55,0,0,34,135,
5,0,63,6,96,130,128,0,202,49,112,0,181,5,191,255,50,255,64,6,
63,0,128,7,33,0,38,143,17,0,224,137,130,21,17,80,42,23,105,0,
2,22,232,0,34,55,0,0,34,135,5,0,63,6,146,130,128,0,202,49,
112,0,181,5,191,255,8,255,64,6,63,0,128,7,33,0,38,143,17,0,
224,137,130,21,17,80,42,23,105,0,2,22,224,0,34,55,0,0,34,135,
5,0,63,6,196,130,128,0,202,49,112,0,165,5,1,82,64,6,63,0,
130,7,97,0,39,127,17,0,6,232,64,150,255,255,82,17,224,121,162,29,
15,80,42,23,105,0,2,22,184,0,34,63,0,0,34,119,5,0,3,48,
63,6,254,130,128,0,202,57,110,0,35,23,1,0,194,110,1,0,226,5,
64,150,255,255,82,17,130,22,1,0,125,23,1,0,29,80,66,6,127,0,
128,7,33,0,38,135,17,0,224,129,130,21,16,80,42,23,105,0,2,22,
24,0,34,55,0,0,34,127,5,0,63,6,68,131,128,0,202,49,111,0,
181,5,1,82,0,90,64,6,63,0,128,7,225,0,6,232,7,224,224,233,
138,13,32,54,108,0,130,255,56,34,10,232,224,233,194,21,29,48,128,255,
182,0,49,6,220,47,134,0,125,143,105,0,224,225,226,5,125,231,17,0,
1,130,125,135,4,0,32,126,64,0,93,127,6,0,29,80,64,6,255,0,
0,82,127,0,32,86,35,1,127,0,0,82,127,0,0,82,127,0,0,82,
127,0,0,82,127,0,0,82,127,0,0,82,127,0,0,82,127,0,0,82,
127,0,0,82,127,0,127,0,32,86,34,1,127,0,0,82,127,0,32,86,
34,1,127,0,32,86,34,1,127,0,127,0,32,86,35,1,127,0,32,86,
35,1,127,0,32,86,33,1,127,0,0,82,127,0,127,0,0,82,127,0,
103,7,1,0,1,82,127,0,0,82,127,0,0,82,127,0,0,82,127,0,
0,82,127,0,0,82,127,0,0,82,127,0,191,7,148,253,191,7,144,253,
33,6,128,115,0,0,97,0,132,7,33,0,41,6,240,175,128,0,99,7,
1,0,99,7,5,0,38,6,88,49,141,0,32,62,16,0,32,70,96,2,
130,255,60,31,68,6,63,0,128,7,225,0,128,230,238,238,61,6,228,49,
134,0,15,138,125,143,0,0,61,86,6,0,224,81,234,5,2,50,130,255,
40,33,224,81,194,5,1,130,106,135,0,0,61,86,12,0,224,81,234,5,
2,50,130,255,16,33,224,81,194,5,2,122,106,127,0,0,61,86,18,0,
224,81,234,5,2,50,130,255,248,32,224,81,194,5,4,114,106,119,0,0,
61,86,24,0,224,81,234,5,2,50,130,255,224,32,224,81,194,5,8,106,
106,111,0,0,61,86,30,0,224,81,234,5,2,50,130,255,200,32,224,81,
178,5,106,231,0,0,61,86,36,0,224,81,234,5,2,50,130,255,178,32,
224,81,178,5,106,231,0,0,61,86,42,0,224,81,234,5,2,50,130,255,
156,32,224,81,210,5,128,94,255,255,106,95,0,0,61,6,20,50,134,0,
15,82,125,87,0,0,61,86,6,0,224,81,234,5,2,50,130,255,118,32,
224,81,194,5,1,138,106,143,0,0,61,86,12,0,224,81,234,5,2,50,
130,255,94,32,224,81,194,5,2,130,106,135,0,0,61,86,18,0,224,81,
234,5,2,50,130,255,70,32,224,81,194,5,4,122,106,127,0,0,61,86,
24,0,224,81,234,5,2,50,130,255,46,32,224,81,194,5,8,114,106,119,
0,0,61,86,30,0,224,81,234,5,2,50,130,255,22,32,224,81,178,5,
106,231,0,0,61,86,36,0,224,81,234,5,2,50,130,255,0,32,224,81,
178,5,106,231,0,0,61,86,42,0,224,81,234,5,2,50,130,255,234,31,
224,81,210,5,128,102,255,255,106,103,0,0,15,90,100,95,96,136,32,62,
16,0,100,63,104,136,41,6,28,176,128,0,38,6,88,49,141,0,32,70,
96,2,130,255,80,31,38,6,204,49,134,0,130,255,236,25,64,14,142,0,
65,7,164,183,38,6,216,49,134,0,130,255,218,25,64,6,255,0,128,7,
225,0,6,232,7,224,224,233,178,21,61,79,0,0,224,73,162,13,61,63,
5,0,61,71,9,0,38,6,100,62,133,0,130,255,230,52,129,226,201,5,
29,48,130,255,238,32,64,6,255,0,128,7,225,0,6,232,7,224,224,233,
242,13,61,63,5,0,36,71,245,178,38,6,140,62,133,0,130,255,186,52,
129,226,201,5,29,48,130,255,194,32,64,6,255,0,128,7,33,0,191,255,
82,201,224,81,162,13,38,6,176,62,133,0,32,62,255,0,0,66,191,255,
82,127,224,81,64,6,63,0,128,7,225,16,6,224,7,216,224,225,162,29,
0,234,60,119,1,0,1,138,253,143,192,0,78,137,146,13,253,54,96,2,
42,6,88,49,141,0,202,49,191,255,182,255,65,234,29,6,240,255,230,237,
129,218,201,5,28,48,130,255,94,32,64,6,255,16,128,7,97,0,6,232,
29,48,31,58,191,255,224,200,224,81,186,253,64,6,127,0,128,7,225,0,
6,224,7,232,224,225,250,5,4,50,130,255,176,30,10,224,224,225,242,21,
124,239,1,0,0,234,60,119,1,0,1,138,253,143,192,0,78,137,146,13,
253,54,96,2,42,6,88,49,141,0,202,49,191,255,178,255,65,234,29,6,
240,255,230,237,28,80,64,6,255,0,128,7,225,0,6,232,7,224,224,233,
178,29,157,143,1,0,224,137,130,21,38,6,120,183,141,0,191,255,120,200,
224,81,146,13,38,6,188,62,133,0,32,62,255,0,0,66,191,255,120,126,
93,7,0,0,129,226,201,5,29,48,130,255,186,31,64,6,255,0,128,7,
97,0,6,232,224,233,250,5,1,50,130,255,36,30,10,232,224,233,194,13,
1,138,93,143,0,0,38,6,120,183,141,0,31,58,191,255,34,200,224,81,
154,253,29,80,64,6,127,0,7,104,0,66,0,74,6,22,4,0,34,55,
1,0,200,49,6,64,225,63,0,0,201,57,7,72,68,18,237,17,225,245,
31,122,79,65,9,80,200,81,127,0,128,7,97,0,6,232,29,62,0,2,
191,255,204,255,125,87,1,0,64,6,127,0,128,7,97,0,6,232,29,62,
0,18,191,255,182,255,125,87,1,0,64,6,127,0,128,7,97,0,6,232,
29,62,0,2,191,255,160,255,61,127,1,0,239,81,234,87,0,0,64,6,
127,0,199,0,0,98,6,135,121,0,0,82,133,29,10,16,230,23,64,2,
38,94,122,0,194,89,235,119,1,0,231,113,218,13,38,94,122,0,2,96,
203,97,44,87,2,0,203,17,226,103,5,0,104,87,1,0,197,5,65,82,
240,81,134,237,12,80,127,0,130,7,225,0,6,224,252,143,85,0,7,232,
224,137,154,13,38,6,200,62,133,0,32,62,164,5,0,66,191,255,96,125,
28,48,4,58,3,64,191,255,152,255,10,64,224,65,202,5,32,86,128,1,
213,37,35,119,1,0,60,55,57,0,29,56,201,66,201,114,206,49,191,255,
46,204,224,81,154,29,29,48,29,62,0,2,191,255,248,254,61,23,1,0,
226,81,178,13,60,63,49,0,38,6,212,62,133,0,130,255,80,50,32,86,
131,1,229,5,61,127,5,0,0,82,124,127,81,0,66,6,255,0,130,7,
225,243,6,216,251,143,85,0,7,224,224,137,154,13,38,6,116,63,133,0,
32,62,46,5,0,66,191,255,222,124,187,135,69,0,8,58,224,129,178,5,
32,62,16,0,27,48,3,64,191,255,10,255,35,111,1,0,59,55,57,0,
28,56,10,64,201,106,205,49,201,66,191,255,170,203,224,81,178,5,128,7,
16,1,60,127,5,0,60,103,50,1,3,194,123,127,77,0,12,6,255,207,
250,77,1,186,28,206,0,6,0,234,29,104,217,105,141,103,1,0,224,97,
130,69,224,185,146,13,59,63,49,0,38,6,4,63,133,0,130,255,174,49,
0,186,24,82,74,233,29,56,38,6,56,63,133,0,130,255,156,49,29,208,
165,13,26,136,217,137,145,63,1,0,37,54,184,131,130,255,136,49,65,210,
29,182,8,0,246,209,198,245,37,54,180,131,130,255,118,49,29,208,165,21,
26,120,217,121,143,23,1,0,32,62,126,0,2,110,224,255,13,6,161,255,
161,5,2,56,37,54,194,131,130,255,82,49,65,210,246,209,230,237,37,54,
192,131,130,255,68,49,71,234,65,234,29,6,0,244,134,189,197,13,12,6,
255,191,186,5,9,194,245,5,9,90,91,95,92,2,32,86,129,1,197,37,
24,56,201,58,220,57,28,48,191,255,168,253,60,23,1,0,226,81,242,5,
8,130,91,135,92,2,32,86,130,1,197,21,60,127,52,1,224,121,210,5,
60,119,5,0,224,113,186,13,59,63,49,0,38,6,72,63,133,0,130,255,
228,48,32,86,132,1,165,5,0,82,66,6,255,243,130,7,225,0,6,224,
252,143,85,0,7,232,224,137,154,13,38,6,172,63,133,0,32,62,227,4,
0,66,191,255,122,123,28,48,2,58,3,64,191,255,178,253,10,64,224,65,
202,5,32,86,128,1,213,61,35,119,1,0,60,55,57,0,29,56,201,66,
201,114,206,49,191,255,72,202,224,81,154,53,61,135,5,0,29,48,29,62,
0,6,124,135,73,0,191,255,10,253,61,23,1,0,226,81,242,5,6,114,
92,119,92,2,32,86,130,1,229,29,61,111,5,0,224,105,242,13,61,23,
49,0,224,17,183,13,2,6,175,254,129,13,61,23,25,3,224,17,199,5,
2,6,175,254,185,13,60,63,49,0,38,6,128,63,133,0,130,255,50,48,
32,86,133,1,165,5,0,82,66,6,255,0,130,7,225,0,6,224,42,6,
184,63,133,0,60,238,92,0,60,22,100,0,0,90,65,18,65,82,10,135,
255,255,2,143,255,255,240,137,178,5,0,82,149,37,65,90,104,90,198,245,
29,48,191,255,216,252,224,81,178,5,4,82,245,21,253,119,25,0,174,6,
2,144,226,5,174,6,3,144,178,5,5,82,213,13,28,48,32,62,16,0,
3,64,191,255,204,252,224,81,234,23,0,0,92,23,69,0,1,82,66,6,
255,0,128,7,225,16,7,224,8,216,6,232,39,6,196,63,133,0,1,66,
129,255,184,8,125,231,49,0,125,223,57,0,31,138,125,143,61,0,125,143,
65,0,93,7,68,0,93,7,69,0,125,7,73,0,125,7,77,0,125,7,
81,0,125,143,53,0,125,7,84,0,93,7,93,2,93,7,94,2,93,7,
95,2,125,7,89,0,2,114,93,119,92,2,61,54,92,0,0,58,32,70,
0,2,191,255,48,118,64,6,255,16,152,7,225,0,6,232,61,23,57,0,
61,119,49,0,32,134,0,32,99,135,45,0,99,23,41,0,99,23,37,0,
1,226,238,231,192,0,191,255,74,185,32,94,232,3,106,7,9,0,45,6,
98,46,1,0,106,111,5,0,44,6,88,183,141,0,106,103,29,0,106,231,
33,0,106,95,21,0,125,87,89,0,10,48,1,58,191,255,106,195,61,23,
89,0,99,7,16,0,35,86,28,0,99,87,5,0,99,23,1,0,99,7,
9,0,99,7,13,0,32,134,16,0,99,135,18,0,32,126,17,0,99,127,
25,0,99,7,22,0,12,50,12,58,3,64,191,255,240,184,61,55,89,0,
125,7,84,0,128,255,8,36,61,55,89,0,10,224,102,7,0,0,191,255,
222,184,28,80,88,6,255,0,70,63,118,0,7,136,177,0,102,143,53,0,
38,54,92,0,191,7,66,251,128,7,33,0,38,55,49,0,128,255,224,103,
10,86,4,216,64,6,63,0,128,7,225,0,6,232,7,224,188,0,61,54,
92,0,0,58,32,70,0,2,191,255,58,117,29,48,191,255,210,255,125,87,
65,0,224,225,210,85,61,86,100,0,34,6,216,63,133,0,2,94,9,0,
2,103,0,0,65,18,74,103,0,0,65,82,226,89,154,253,61,119,53,0,
1,130,125,135,113,0,128,126,2,144,125,127,116,0,93,119,118,0,32,110,
40,0,93,111,120,0,8,106,93,111,121,0,28,6,180,255,202,13,4,90,
125,95,65,0,32,86,76,0,93,87,119,0,42,6,20,50,134,0,197,29,
32,86,78,0,93,87,119,0,42,6,228,49,134,0,197,21,13,16,230,23,
64,2,61,142,122,0,194,137,202,17,34,135,0,0,113,135,0,0,34,127,
2,0,113,127,2,0,34,119,4,0,113,119,4,0,13,16,95,106,224,17,
170,237,93,23,69,0,61,54,92,0,191,255,96,250,64,6,255,0,154,7,
225,48,7,216,8,208,218,0,6,232,26,56,3,64,191,255,144,250,10,224,
224,225,130,93,219,55,2,0,219,31,3,0,201,82,125,215,84,0,35,23,
1,0,99,7,40,0,99,223,25,0,99,231,42,0,11,90,99,87,21,0,
99,7,5,0,99,7,9,0,99,95,49,0,61,103,57,0,2,120,201,122,
61,111,61,0,204,121,99,127,17,0,99,127,13,0,35,102,4,0,99,103,
29,0,2,82,205,17,99,23,33,0,99,7,37,0,61,55,49,0,99,87,
46,0,9,58,35,70,24,0,191,255,80,183,99,7,40,0,99,223,25,0,
35,110,4,0,99,111,29,0,99,231,42,0,61,119,65,0,35,127,1,0,
11,98,99,103,49,0,2,90,206,121,99,127,33,0,99,7,37,0,61,55,
49,0,99,95,46,0,9,58,35,70,24,0,191,255,16,183,2,82,90,6,
255,48,128,7,225,0,6,232,191,255,134,248,93,7,92,2,29,48,191,255,
120,253,10,224,224,225,170,61,61,127,49,0,1,226,239,231,192,0,191,255,
210,182,32,102,244,1,106,7,9,0,46,6,98,46,1,0,106,119,5,0,
45,6,88,183,141,0,106,111,29,0,106,231,33,0,106,103,21,0,125,87,
89,0,29,48,10,56,15,66,191,255,222,254,61,55,89,0,10,56,191,255,
230,192,61,55,89,0,128,255,194,33,61,55,89,0,10,224,102,7,0,0,
191,255,152,182,61,63,49,0,29,71,119,0,38,6,228,63,133,0,130,255,
72,44,29,48,191,255,154,247,28,80,64,6,255,0,152,7,225,112,6,232,
7,208,8,200,9,224,28,6,239,255,153,13,38,6,24,64,133,0,32,62,
93,10,0,66,191,255,220,118,29,48,191,255,204,252,10,216,224,217,218,117,
61,119,49,0,1,218,238,223,192,0,191,255,38,182,106,7,9,0,45,6,
98,46,1,0,106,111,5,0,44,6,88,183,141,0,106,103,29,0,106,223,
33,0,32,94,244,1,106,95,21,0,202,55,2,0,202,31,3,0,2,58,
125,87,89,0,28,120,99,7,1,0,99,7,5,0,61,87,57,0,61,55,
89,0,201,122,99,127,17,0,99,87,9,0,99,87,13,0,191,255,32,192,
61,23,89,0,99,7,36,0,99,31,25,0,99,231,38,0,99,23,21,0,
11,98,99,103,45,0,2,90,99,215,29,0,99,7,33,0,61,55,49,0,
99,95,42,0,9,58,35,70,20,0,191,255,170,181,61,23,89,0,0,74,
99,7,36,0,99,31,25,0,99,23,21,0,99,231,38,0,11,130,99,135,
45,0,2,122,99,207,29,0,99,7,33,0,61,55,49,0,99,127,42,0,
9,58,35,70,20,0,191,255,114,181,61,55,89,0,128,255,142,32,61,55,
89,0,10,216,102,7,0,0,191,255,100,181,27,80,88,6,255,112,128,7,
225,48,6,232,191,255,210,246,29,23,92,2,97,18,242,13,99,18,129,29,
226,5,101,18,243,13,105,18,131,13,165,21,61,231,61,0,0,210,4,218,
92,226,149,21,29,143,119,0,17,6,180,255,250,5,4,210,61,231,61,0,
32,222,16,0,229,5,29,48,191,255,46,246,0,226,213,21,61,63,49,0,
38,6,36,64,133,0,27,64,130,255,194,42,29,48,26,56,28,64,27,72,
191,255,126,254,10,224,93,7,92,2,29,48,191,255,2,246,28,80,64,6,
255,48,130,7,225,0,199,0,8,224,6,232,3,64,191,255,152,247,201,82,
10,64,202,5,32,86,128,1,197,13,35,119,1,0,61,55,57,0,125,7,
84,0,28,56,201,114,206,49,191,255,232,177,66,6,255,0,128,7,225,112,
6,208,7,200,249,0,0,218,61,6,88,49,141,0,0,226,128,7,52,1,
218,142,1,0,186,5,128,7,38,1,25,6,255,191,170,13,252,118,96,2,
221,113,174,103,69,0,224,97,226,223,0,0,229,5,252,86,96,2,221,81,
170,223,69,0,224,217,130,125,252,22,96,2,2,112,221,113,14,111,119,0,
48,6,228,49,134,0,13,6,180,255,202,5,48,6,20,50,134,0,8,122,
229,21,15,80,230,87,64,2,2,88,221,89,43,118,122,0,202,113,208,81,
42,111,0,0,110,111,0,0,42,103,2,0,110,103,2,0,42,95,4,0,
110,95,4,0,15,80,95,122,224,81,138,237,25,6,255,191,186,61,1,130,
2,72,221,73,73,135,69,0,128,126,3,144,105,127,116,0,36,118,96,136,
46,103,0,0,41,110,122,0,109,103,0,0,46,95,2,0,109,95,2,0,
46,87,4,0,0,98,9,138,109,87,4,0,73,143,121,0,12,88,230,95,
64,2,2,120,221,121,47,110,122,0,203,105,36,86,104,136,202,89,43,127,
0,0,13,134,48,0,112,127,0,0,43,119,2,0,65,98,112,119,2,0,
43,111,4,0,97,98,112,111,4,0,214,229,149,21,221,17,66,7,69,0,
128,102,2,144,98,103,116,0,8,90,66,95,121,0,34,54,170,0,0,58,
6,66,191,255,24,112,252,126,96,2,221,121,47,54,92,0,191,255,230,245,
65,226,129,210,224,209,178,5,191,7,204,254,27,80,138,0,64,6,255,112,
172,7,225,243,6,224,7,208,218,0,0,218,28,176,191,255,42,179,106,7,
9,0,49,6,98,46,1,0,106,143,5,0,48,6,88,183,141,0,106,135,
29,0,106,231,33,0,32,126,244,1,106,127,21,0,10,232,0,202,149,21,
220,118,1,0,194,13,249,54,96,2,42,6,88,49,141,0,29,56,202,49,
26,64,191,255,36,251,202,217,65,202,129,226,224,225,250,237,29,48,27,56,
191,255,36,189,29,48,128,255,2,30,10,200,224,201,130,69,32,119,169,182,
32,126,180,179,239,113,170,61,35,54,8,0,0,58,32,70,80,0,191,255,
104,111,253,231,19,0,37,70,208,131,28,102,255,255,92,97,204,0,224,97,
178,5,37,70,200,131,99,71,5,0,32,70,61,0,0,194,35,190,8,0,
245,13,220,118,1,0,162,13,23,48,24,72,37,62,216,131,130,255,132,30,
202,185,32,70,44,0,129,226,65,194,224,225,154,245,224,55,241,176,35,71,
5,0,32,134,32,0,99,135,1,0,37,62,224,131,35,78,8,0,128,255,
254,161,125,7,0,0,29,48,191,255,88,178,22,56,26,64,27,72,99,207,
1,0,38,6,84,64,133,0,130,255,6,40,25,80,108,6,255,243,6,23,
92,2,102,18,153,13,97,18,179,37,99,18,193,37,210,29,101,18,209,21,
245,21,105,18,217,5,103,18,129,21,162,21,229,13,106,18,241,13,178,13,
108,18,177,5,210,5,181,21,32,62,236,0,149,21,32,62,238,0,229,13,
32,62,221,0,181,13,32,62,219,0,133,13,32,62,217,0,213,5,32,62,
255,0,165,5,0,58,38,55,49,0,0,66,128,7,36,101,128,7,225,243,
6,200,7,192,8,184,9,176,0,226,25,216,0,210,213,69,219,142,1,0,
130,69,250,238,96,2,46,6,88,49,141,0,1,58,206,233,29,48,61,70,
92,0,191,255,204,252,10,224,224,225,218,53,29,48,24,64,2,58,191,255,
188,252,10,224,224,225,218,45,56,95,5,0,29,48,23,64,4,58,125,95,
73,0,191,255,164,252,10,224,224,81,154,37,55,143,5,0,189,135,69,0,
8,58,125,143,81,0,224,129,178,5,32,62,16,0,29,48,22,64,191,255,
128,252,10,224,224,225,250,13,54,119,5,0,1,106,93,111,92,2,29,48,
125,119,77,0,191,255,10,255,65,210,129,218,224,217,186,189,224,225,234,5,
25,48,15,58,191,255,224,253,10,224,28,80,64,6,255,243,0,90,0,18,
224,49,226,143,0,0,1,130,226,135,192,0,81,129,202,13,226,102,96,2,
42,6,88,49,141,0,202,97,44,87,73,0,235,81,163,5,10,88,65,18,
2,6,240,255,166,237,11,86,1,0,127,0,0,90,0,18,224,49,226,143,
0,0,1,130,226,135,192,0,81,129,202,13,226,102,96,2,42,6,88,49,
141,0,202,97,44,87,81,0,235,81,163,5,10,88,65,18,2,6,240,255,
166,237,11,86,1,0,127,0,0,90,0,18,224,49,226,143,0,0,1,130,
226,135,192,0,81,129,202,13,226,102,96,2,42,6,88,49,141,0,202,97,
44,87,77,0,235,81,163,5,10,88,65,18,2,6,240,255,166,237,11,86,
1,0,127,0,128,7,225,112,6,224,7,216,0,58,8,200,32,70,0,18,
191,255,14,109,59,23,105,0,2,22,232,0,34,55,0,0,34,143,5,0,
60,62,56,1,63,6,250,148,128,0,219,49,113,0,10,232,27,48,128,255,
106,27,10,216,27,48,128,255,106,27,124,87,48,1,0,82,27,6,240,255,
177,13,27,16,197,18,32,110,164,180,205,17,34,103,5,0,224,97,162,5,
2,80,29,56,244,63,64,2,60,142,56,1,42,54,16,0,209,57,129,255,
212,0,10,208,218,233,29,6,93,255,151,13,29,64,38,6,152,64,133,0,
32,62,140,12,191,255,116,112,124,239,52,1,27,48,128,255,26,27,224,81,
234,127,0,0,32,134,20,0,124,135,54,1,32,22,1,48,224,209,234,5,
224,121,202,5,29,6,205,255,183,5,32,22,1,64,124,23,50,1,124,207,
5,0,28,48,191,255,72,242,64,6,255,112,130,7,225,240,6,192,7,216,
0,210,123,7,1,0,0,202,0,226,149,53,56,23,105,0,28,64,2,22,
184,0,34,63,0,0,34,143,5,0,3,48,63,6,202,149,128,0,216,57,
113,0,35,239,1,0,221,134,1,0,194,29,252,54,96,2,65,210,44,6,
88,49,141,0,204,49,29,56,176,58,191,255,138,246,29,80,222,82,159,82,
218,5,1,138,252,143,192,0,17,201,216,234,159,234,226,5,59,119,1,0,
65,114,123,119,1,0,65,226,4,111,233,135,237,225,214,205,59,23,1,0,
224,17,178,13,250,17,146,13,38,6,164,64,133,0,32,62,192,6,0,66,
191,255,156,111,25,80,66,6,255,240,128,7,225,16,6,224,7,232,8,216,
29,48,0,58,32,70,0,2,191,255,158,107,28,6,240,255,129,13,28,48,
61,62,12,0,32,70,244,1,129,255,180,36,32,134,3,64,125,135,8,0,
125,223,5,0,29,48,29,62,0,2,191,255,38,241,125,87,1,0,64,6,
255,16,144,7,225,240,58,6,8,215,255,255,99,7,20,0,39,6,176,64,
133,0,99,63,25,0,6,232,99,239,29,0,99,239,13,0,36,79,245,178,
99,63,17,0,29,64,38,6,192,64,133,0,130,255,86,36,35,54,2,0,
191,255,174,240,1,138,67,143,3,0,26,48,31,58,191,255,230,184,10,48,
224,49,170,253,29,6,240,255,129,13,29,120,197,122,32,102,164,180,204,121,
47,55,5,0,56,6,88,62,133,0,224,49,170,45,163,87,3,0,32,94,
10,1,99,95,20,0,32,238,10,1,224,81,226,13,67,7,3,0,26,48,
191,255,172,184,224,81,242,5,24,48,32,62,255,0,0,66,191,255,176,110,
35,54,2,0,2,58,191,255,0,240,35,54,12,0,2,58,191,255,6,239,
35,54,20,0,2,58,191,255,200,238,29,80,128,7,50,1,35,62,4,0,
191,255,84,254,35,143,5,0,10,224,224,137,218,37,163,135,3,0,35,239,
20,0,224,129,226,13,67,7,3,0,26,48,191,255,80,184,224,81,242,5,
24,48,32,62,255,0,0,66,191,255,84,110,35,54,2,0,2,58,191,255,
164,239,35,54,12,0,2,58,191,255,170,238,35,54,20,0,2,58,191,255,
108,238,29,80,181,109,28,56,35,54,8,0,191,255,56,239,32,54,0,2,
130,255,238,13,10,216,224,217,154,13,38,6,228,64,133,0,32,62,158,9,
0,66,191,255,10,110,28,48,191,255,148,252,29,48,27,56,10,64,191,255,
104,254,0,202,28,232,213,21,221,126,1,0,130,21,249,54,96,2,43,6,
88,49,141,0,27,64,203,49,4,58,191,255,120,248,99,87,20,0,234,0,
224,81,250,13,65,202,161,234,224,233,186,237,35,143,20,0,224,137,250,5,
28,48,4,58,191,255,228,249,99,87,20,0,35,239,20,0,27,48,130,255,
250,14,35,54,8,0,2,58,191,255,88,238,163,135,3,0,224,129,226,13,
67,7,3,0,26,48,191,255,122,183,224,81,242,5,24,48,32,62,255,0,
0,66,191,255,126,109,35,54,2,0,2,58,191,255,206,238,35,54,12,0,
2,58,191,255,212,237,35,54,20,0,2,58,191,255,150,237,29,80,80,6,
255,240,0,82,0,130,245,13,198,142,1,0,162,13,240,126,96,2,45,6,
88,49,141,0,205,121,15,87,119,0,213,5,65,130,129,50,224,49,154,245,
10,6,180,255,226,5,10,6,178,255,178,5,32,86,78,0,127,0,130,7,
225,240,6,224,28,6,240,255,0,50,129,13,28,128,197,130,32,110,164,180,
205,129,48,55,5,0,224,49,202,5,32,86,10,1,213,93,3,56,191,255,
198,252,10,208,35,87,1,0,224,81,186,5,234,0,181,85,32,54,0,2,
130,255,174,12,10,232,224,233,154,13,38,6,44,65,133,0,32,62,135,13,
0,66,191,255,202,108,0,194,31,202,0,218,245,21,218,102,1,0,162,21,
251,54,96,2,48,6,88,49,141,0,29,56,208,49,191,255,46,239,224,81,
250,5,61,23,5,0,248,17,183,5,2,192,27,200,65,218,161,210,224,209,
154,237,127,202,202,13,28,56,38,6,240,64,133,0,130,255,192,33,29,48,
130,255,204,13,0,82,181,29,249,54,96,2,43,6,88,49,141,0,29,56,
203,49,191,255,234,238,10,216,224,81,226,5,29,48,130,255,170,13,27,80,
165,13,28,48,61,62,12,0,129,255,186,33,29,48,130,255,150,13,0,82,
66,6,255,240,130,7,225,16,6,224,224,225,186,5,28,80,149,37,0,218,
0,234,149,29,60,23,105,0,29,64,2,22,184,0,34,63,0,0,34,143,
5,0,3,48,63,6,190,153,128,0,220,57,113,0,35,23,1,0,129,18,
217,5,1,122,253,127,192,0,15,217,65,234,4,111,233,135,237,233,214,229,
27,80,66,6,255,16,0,18,6,6,240,255,241,5,197,50,32,110,164,180,
205,49,38,23,5,0,2,48,191,7,152,255,152,7,225,48,6,232,61,23,
57,0,7,208,8,216,27,128,99,23,37,0,99,23,41,0,61,111,49,0,
201,130,99,135,45,0,1,226,237,231,192,0,191,255,12,171,10,48,32,86,
244,1,102,7,9,0,44,6,98,46,1,0,102,103,5,0,43,6,56,193,
141,0,102,95,29,0,102,231,33,0,102,87,21,0,125,55,89,0,1,58,
191,255,44,181,61,23,89,0,0,58,35,134,28,0,99,135,5,0,194,7,
3,0,194,31,3,0,99,23,1,0,12,122,99,7,16,0,99,223,18,0,
99,215,9,0,99,7,13,0,61,55,49,0,99,127,25,0,99,7,22,0,
3,64,191,255,174,170,1,114,93,119,95,2,88,6,255,48,128,7,97,0,
6,232,61,127,49,0,1,58,38,6,56,193,141,0,0,66,239,63,192,0,
191,255,36,140,1,82,93,87,94,2,93,87,95,2,93,87,93,2,64,6,
127,0,128,7,97,0,6,232,61,55,89,0,224,49,178,5,128,255,168,21,
12,138,93,143,92,2,29,48,191,255,38,248,29,48,191,255,116,235,93,7,
94,2,93,7,95,2,93,7,93,2,64,6,127,0,128,7,97,0,6,232,
29,143,92,2,108,138,194,5,11,130,93,135,92,2,93,7,94,2,29,48,
191,255,242,247,29,48,191,255,64,235,0,82,64,6,127,0,128,7,97,0,
70,7,94,2,6,232,191,255,216,247,29,48,191,255,38,235,11,82,64,6,
127,0,128,7,225,0,6,232,61,55,89,0,93,7,95,2,38,231,12,0,
102,7,0,0,191,255,236,169,125,7,89,0,224,225,226,13,1,130,93,135,
68,0,61,71,49,0,28,72,32,54,67,0,39,6,56,65,133,0,191,255,
30,108,11,82,64,6,255,0,128,7,225,0,6,232,61,55,89,0,93,7,
95,2,38,231,12,0,102,7,0,0,191,255,170,169,125,7,89,0,224,225,
202,13,61,55,57,0,32,70,0,2,61,62,92,0,191,255,14,185,10,224,
224,225,130,37,61,63,49,0,38,6,76,65,133,0,28,64,130,255,62,31,
11,18,28,6,252,253,170,5,12,18,93,23,92,2,29,48,191,255,168,240,
61,23,65,0,234,17,234,5,4,106,125,111,65,0,6,82,213,37,93,7,
92,2,12,82,149,37,61,94,20,2,37,102,232,131,4,106,139,143,1,0,
140,23,1,0,65,90,65,98,145,17,218,5,224,137,178,5,95,106,218,245,
224,17,170,13,3,130,4,122,125,127,65,0,32,118,76,0,93,119,119,0,
165,5,0,128,93,135,92,2,11,82,64,6,255,0,128,7,225,0,6,232,
61,55,89,0,93,7,95,2,38,231,12,0,102,7,0,0,191,255,240,168,
125,7,89,0,224,225,202,13,61,55,57,0,32,70,0,2,61,62,92,0,
191,255,84,184,10,224,224,225,194,29,61,63,49,0,38,6,124,65,133,0,
28,64,130,255,132,30,11,18,28,6,252,253,170,5,12,18,93,23,92,2,
29,48,191,255,238,239,61,23,65,0,234,17,202,5,28,6,254,253,162,21,
12,82,133,45,29,48,191,255,54,238,93,87,92,2,170,0,224,81,234,13,
29,48,191,255,198,239,61,23,65,0,234,17,218,5,4,82,125,87,65,0,
213,21,5,82,181,21,97,82,138,21,29,23,118,0,15,138,125,143,84,0,
127,18,125,23,53,0,194,5,2,6,240,255,199,5,10,122,93,127,92,2,
11,82,64,6,255,0,128,7,225,0,6,232,61,55,89,0,93,7,95,2,
38,231,12,0,102,7,0,0,191,255,48,168,125,7,89,0,224,225,202,13,
61,55,57,0,32,70,0,2,61,62,92,0,191,255,148,183,10,224,224,225,
242,29,61,63,49,0,38,6,192,65,133,0,28,64,130,255,196,29,1,114,
93,119,68,0,61,71,49,0,28,72,32,54,66,0,39,6,172,65,133,0,
191,255,60,106,11,18,28,6,252,253,170,5,12,18,93,23,92,2,4,82,
229,45,29,48,191,255,112,237,93,87,92,2,10,16,162,0,224,17,186,5,
5,82,181,37,97,18,170,29,29,135,119,0,15,138,125,143,84,0,16,6,
180,255,202,5,4,122,125,127,65,0,29,23,118,0,127,18,125,23,53,0,
194,5,2,6,240,255,199,13,10,106,93,111,92,2,4,82,133,13,100,18,
178,5,101,18,186,5,4,82,165,5,3,82,64,6,255,0,128,7,97,0,
6,232,61,63,49,0,0,66,38,6,240,65,133,0,130,255,36,29,29,48,
0,58,4,66,191,255,12,252,10,82,64,6,127,0,128,7,33,0,38,143,
61,0,4,66,17,62,252,255,191,255,244,251,10,82,64,6,63,0,142,7,
225,0,6,232,61,127,49,0,1,226,239,231,192,0,191,255,14,167,32,102,
244,1,106,7,9,0,46,6,98,46,1,0,106,119,5,0,45,6,56,193,
141,0,106,111,29,0,106,231,33,0,106,103,21,0,125,87,89,0,10,48,
1,58,191,255,46,177,61,23,89,0,99,7,5,0,99,7,25,0,61,95,
65,0,194,7,3,0,194,31,3,0,99,23,1,0,32,86,16,0,99,7,
16,0,99,87,18,0,99,95,9,0,99,7,13,0,61,55,49,0,99,7,
22,0,3,58,3,64,191,255,174,166,1,130,93,135,95,2,8,82,78,6,
255,0,128,7,97,0,6,232,61,63,49,0,61,71,65,0,38,6,32,66,
133,0,130,255,84,28,61,63,65,0,32,70,16,0,29,48,191,255,56,251,
9,82,64,6,127,0,128,7,33,0,38,63,61,0,32,70,16,0,191,255,
34,251,7,82,64,6,63,0,128,7,97,0,6,232,61,55,49,0,128,255,
130,85,10,22,4,252,125,23,61,0,29,48,191,255,140,237,125,87,65,0,
125,7,84,0,61,54,92,0,0,58,32,70,0,2,191,255,216,98,1,138,
93,143,94,2,93,7,95,2,2,82,64,6,127,0,70,7,94,2,70,7,
95,2,0,82,127,0,128,7,225,0,6,232,29,143,93,2,109,138,150,13,
38,6,76,66,133,0,32,62,202,2,0,66,191,255,128,102,29,23,93,2,
45,6,228,67,133,0,196,18,205,17,34,55,8,0,34,95,10,0,221,49,
224,89,206,5,34,231,13,0,213,13,34,87,12,0,198,81,42,87,1,0,
195,90,202,89,43,87,0,0,43,231,5,0,202,49,63,6,142,159,128,0,
124,0,189,95,95,2,93,87,93,2,224,89,218,5,157,87,95,2,224,81,
170,205,157,87,95,2,64,6,255,0,130,7,33,0,0,82,6,6,240,255,
241,5,197,50,32,110,164,180,205,49,38,87,5,0,10,48,224,49,186,5,
6,80,181,13,3,56,191,255,202,245,10,48,191,255,158,248,10,6,178,255,
226,87,0,0,138,0,66,6,63,0,130,7,33,0,0,82,6,6,240,255,
241,5,197,50,32,110,164,180,205,49,38,87,5,0,10,48,224,49,186,5,
6,80,165,13,3,56,191,255,142,245,35,95,1,0,224,89,234,103,0,0,
12,80,138,0,66,6,63,0,132,7,225,48,6,208,0,50,7,6,240,255,
241,5,197,58,32,110,164,180,205,57,39,55,5,0,224,49,146,13,3,56,
191,255,88,245,35,103,1,0,10,224,224,97,186,5,0,82,133,53,28,56,
35,54,4,0,191,255,128,230,0,218,0,234,133,37,220,94,1,0,178,29,
253,54,96,2,48,6,88,49,141,0,208,49,134,127,69,0,224,121,146,21,
230,71,85,0,111,66,130,13,29,56,38,6,88,66,133,0,130,255,122,26,
229,5,26,56,15,66,191,255,212,236,202,217,65,234,161,226,224,225,138,229,
35,54,4,0,2,58,191,255,214,229,27,80,68,6,255,48,132,7,225,48,
6,208,7,224,28,48,0,58,32,70,88,1,191,255,34,97,224,209,186,5,
26,80,165,93,1,138,67,143,3,0,38,6,8,215,255,255,31,58,191,255,
206,174,224,81,154,253,60,238,8,0,0,218,181,29,58,23,105,0,27,64,
2,22,184,0,34,63,0,0,34,135,5,0,35,54,4,0,63,6,14,161,
128,0,218,57,112,0,35,23,5,0,129,18,233,5,27,48,29,56,128,255,
22,82,10,232,65,218,4,119,233,135,238,217,182,229,36,111,245,178,60,94,
8,0,171,233,124,239,1,0,124,111,5,0,29,6,176,254,150,13,38,6,
144,66,133,0,32,62,124,11,0,66,191,255,122,100,163,143,3,0,60,215,
1,0,224,137,162,21,67,7,3,0,38,6,8,215,255,255,191,255,76,174,
224,81,146,13,38,6,88,62,133,0,32,62,255,0,0,66,191,255,76,100,
26,80,68,6,255,48,138,7,225,243,60,6,204,66,133,0,31,218,99,223,
13,0,61,6,156,66,133,0,99,239,17,0,29,56,36,79,245,178,31,66,
6,176,38,6,168,66,133,0,130,255,86,25,99,7,0,0,99,239,5,0,
99,223,9,0,32,54,0,6,130,255,210,3,10,232,32,54,0,2,130,255,
200,3,10,200,32,54,0,18,130,255,190,3,10,216,224,233,250,5,28,48,
32,62,4,11,0,66,191,255,222,99,224,201,250,5,28,48,32,62,5,11,
0,66,191,255,206,99,224,217,138,13,28,48,32,62,6,11,0,66,191,255,
190,99,224,81,0,210,22,192,128,7,144,1,216,134,1,0,186,5,128,7,
130,1,250,230,96,2,45,6,88,49,141,0,205,225,28,48,191,255,186,237,
99,87,0,0,234,0,224,81,178,5,128,7,130,1,28,48,0,58,191,255,
42,234,28,48,32,62,78,0,191,255,72,234,28,48,60,70,92,0,1,58,
191,255,10,238,99,87,0,0,234,0,224,81,178,5,128,7,86,1,29,48,
0,58,32,70,0,6,191,255,112,95,61,190,48,0,61,62,56,0,26,48,
128,255,172,80,36,143,245,178,55,126,8,0,175,81,119,87,1,0,218,137,
119,143,5,0,61,54,24,3,23,56,32,70,88,1,191,255,226,93,32,118,
1,32,125,119,8,0,1,106,125,111,5,0,32,102,21,0,125,103,10,0,
32,94,88,1,125,95,12,0,32,86,144,1,125,87,14,0,29,48,29,62,
0,6,191,255,194,228,125,87,1,0,28,48,29,64,2,58,191,255,130,237,
99,87,0,0,234,0,224,81,138,109,61,127,5,0,25,56,31,50,1,66,
124,127,73,0,191,255,54,243,28,48,25,64,4,58,191,255,92,237,99,87,
0,0,234,0,224,81,218,85,57,111,5,0,27,48,0,58,32,70,0,18,
124,111,81,0,191,255,190,94,1,98,123,103,52,1,32,94,253,15,123,95,
48,1,32,86,20,0,123,87,54,1,32,142,1,48,123,143,50,1,123,103,
5,0,12,122,59,190,56,1,87,127,1,0,32,118,31,0,87,119,5,0,
87,215,3,0,26,48,128,255,6,81,10,22,0,184,119,23,13,0,27,48,
191,255,100,228,28,48,27,64,8,58,191,255,232,236,99,87,0,0,234,0,
224,81,186,29,59,103,5,0,1,90,92,95,92,2,28,48,124,103,77,0,
191,255,110,239,65,210,161,194,224,193,178,5,191,7,112,254,35,87,0,0,
224,81,250,5,22,48,15,58,191,255,60,238,99,87,0,0,29,48,130,255,
86,3,25,48,130,255,80,3,27,48,130,255,74,3,35,239,0,0,3,48,
2,58,191,255,36,226,35,54,12,0,2,58,191,255,78,226,29,80,74,6,
255,243,128,7,33,0,224,49,202,5,32,86,10,1,229,5,191,255,144,245,
10,48,191,255,132,253,64,6,63,0,191,7,116,242,144,7,225,243,58,6,
8,215,255,255,99,7,20,0,7,216,39,6,252,66,133,0,99,63,25,0,
6,232,99,239,29,0,99,239,13,0,36,79,245,178,99,63,17,0,29,64,
38,6,216,66,133,0,130,255,196,22,35,54,1,0,191,255,28,227,1,138,
67,143,2,0,26,48,31,58,191,255,84,171,10,224,224,225,170,253,29,6,
240,255,241,5,197,234,32,102,164,180,204,233,61,231,5,0,56,6,88,62,
133,0,224,225,170,45,131,87,3,0,32,94,10,1,99,95,20,0,32,238,
10,1,224,81,226,13,67,7,2,0,26,48,191,255,28,171,224,81,242,5,
24,48,32,62,255,0,0,66,191,255,32,97,35,54,1,0,2,58,191,255,
112,226,35,54,12,0,2,58,191,255,118,225,35,54,20,0,2,58,191,255,
56,225,29,80,128,7,192,1,28,48,35,62,4,0,191,255,194,240,35,143,
5,0,27,232,74,233,224,137,234,37,131,135,3,0,35,239,20,0,224,129,
226,13,67,7,2,0,26,48,191,255,188,170,224,81,242,5,24,48,32,62,
255,0,0,66,191,255,192,96,35,54,1,0,2,58,191,255,16,226,35,54,
12,0,2,58,191,255,22,225,35,54,20,0,2,58,191,255,216,224,29,80,
128,7,96,1,29,56,35,54,8,0,191,255,162,225,32,54,0,18,130,255,
88,0,10,216,224,217,154,13,38,6,12,67,133,0,32,62,71,9,0,66,
191,255,116,96,29,48,191,255,54,239,27,48,28,56,10,64,191,255,100,239,
59,63,50,1,29,48,191,255,46,235,131,119,3,0,67,87,3,0,224,113,
226,13,67,7,2,0,26,48,191,255,48,170,224,81,242,5,24,48,32,62,
255,0,0,66,191,255,52,96,0,186,0,178,29,200,245,45,217,110,1,0,
162,45,246,230,96,2,59,143,5,0,42,6,88,49,141,0,202,225,188,191,
69,0,8,58,124,143,77,0,224,185,178,5,32,62,16,0,28,48,27,64,
191,255,154,234,99,87,20,0,234,0,224,81,250,45,163,119,3,0,224,113,
194,13,28,48,60,70,92,0,1,58,191,255,124,234,99,87,20,0,234,0,
224,81,138,37,65,178,129,202,224,201,154,213,35,103,20,0,224,97,138,29,
8,58,224,185,178,5,32,62,16,0,29,48,191,255,224,235,99,87,20,0,
234,0,224,81,186,13,163,143,3,0,224,137,242,5,29,48,1,58,191,255,
198,235,99,87,20,0,35,239,20,0,27,48,130,255,220,0,35,54,8,0,
2,58,191,255,58,224,131,135,3,0,224,129,226,13,67,7,2,0,26,48,
191,255,92,169,224,81,242,5,24,48,32,62,255,0,0,66,191,255,96,95,
35,54,1,0,2,58,191,255,176,224,35,54,12,0,2,58,191,255,182,223,
35,54,20,0,2,58,191,255,120,223,29,80,80,6,255,243,156,7,225,243,
56,6,8,215,255,255,99,7,44,0,99,63,29,0,39,6,24,67,133,0,
99,63,49,0,6,176,99,183,53,0,99,183,37,0,36,79,245,178,99,63,
41,0,22,64,38,6,36,67,133,0,130,255,64,20,35,54,1,0,191,255,
152,224,1,138,67,143,2,0,24,48,31,58,191,255,208,168,10,48,224,49,
170,253,22,6,240,255,129,13,22,120,197,122,32,102,164,180,204,121,47,55,
5,0,55,6,88,62,133,0,99,55,25,0,224,49,170,45,131,87,3,0,
32,94,10,1,99,95,44,0,32,238,10,1,224,81,226,13,67,7,2,0,
24,48,191,255,146,168,224,81,242,5,23,48,32,62,255,0,0,66,191,255,
150,94,35,54,1,0,2,58,191,255,230,223,35,54,36,0,2,58,191,255,
236,222,35,54,44,0,2,58,191,255,174,222,29,80,128,7,96,5,35,62,
4,0,191,255,58,238,99,87,17,0,10,56,35,54,8,0,191,255,108,223,
32,54,0,6,129,255,34,254,10,232,224,233,154,13,38,6,72,67,133,0,
32,62,134,8,0,66,191,255,62,94,29,208,26,48,0,58,32,70,0,6,
191,255,78,90,22,48,61,62,48,0,128,255,230,8,99,87,44,0,234,0,
224,81,210,45,10,232,26,48,129,255,100,255,35,54,8,0,2,58,191,255,
194,222,131,135,3,0,224,129,226,13,67,7,2,0,24,48,191,255,228,167,
224,81,242,5,23,48,32,62,255,0,0,66,191,255,232,93,35,54,1,0,
2,58,191,255,56,223,35,54,36,0,2,58,191,255,62,222,35,54,44,0,
2,58,191,255,0,222,29,80,128,7,178,4,35,55,25,0,61,62,24,3,
191,255,164,248,35,55,17,0,191,255,8,236,125,87,5,0,32,126,21,0,
125,127,10,0,32,118,88,1,125,119,12,0,32,110,144,1,125,111,14,0,
26,48,29,62,0,6,191,255,90,223,125,87,1,0,32,54,0,6,129,255,
76,253,10,224,224,225,154,13,38,6,72,67,133,0,32,62,152,8,0,66,
191,255,104,93,99,231,21,0,28,48,0,58,32,70,0,6,191,255,118,89,
60,54,48,0,61,62,24,3,32,70,88,1,191,255,8,88,60,54,24,3,
61,62,24,3,32,70,88,1,191,255,248,87,61,95,5,0,32,86,21,0,
124,87,10,0,32,142,88,1,65,90,124,95,5,0,124,143,12,0,32,134,
144,1,124,135,14,0,28,48,28,62,0,6,191,255,220,222,124,87,1,0,
32,54,0,18,129,255,206,252,10,216,224,217,154,13,38,6,72,67,133,0,
32,62,164,8,0,66,191,255,234,92,35,55,17,0,191,255,170,235,35,63,
25,0,10,64,27,48,191,255,214,235,32,54,0,2,129,255,156,252,10,200,
224,201,154,13,38,6,72,67,133,0,32,62,169,8,0,66,191,255,184,92,
35,55,17,0,191,255,64,235,10,70,255,255,22,48,25,56,191,255,18,237,
131,119,3,0,224,113,226,13,67,7,2,0,24,48,191,255,126,166,224,81,
242,5,23,48,32,62,255,0,0,66,191,255,130,92,35,111,5,0,0,82,
224,105,162,13,35,151,29,0,50,48,35,151,17,0,82,49,191,255,18,239,
170,0,67,87,3,0,99,7,13,0,35,183,29,0,165,37,214,86,1,0,
146,29,35,143,13,0,241,158,96,2,47,6,88,49,141,0,207,153,99,159,
33,0,19,48,191,255,90,230,99,87,44,0,234,0,224,81,250,13,3,63,
3,0,35,55,33,0,191,255,242,226,35,159,13,0,161,178,65,154,99,159,
13,0,224,177,234,221,35,55,29,0,35,151,17,0,59,63,50,1,18,49,
191,255,212,230,35,87,5,0,224,81,210,5,35,143,44,0,224,137,130,61,
35,239,44,0,25,48,129,255,54,253,27,48,129,255,48,253,35,55,21,0,
129,255,40,253,26,48,129,255,34,253,35,54,8,0,2,58,191,255,128,220,
131,135,3,0,224,129,226,13,67,7,2,0,24,48,191,255,162,165,224,81,
242,5,23,48,32,62,255,0,0,66,191,255,166,91,35,54,1,0,2,58,
191,255,246,220,35,54,36,0,2,58,191,255,252,219,35,54,44,0,2,58,
191,255,190,219,29,80,128,7,112,2,35,55,29,0,28,56,25,64,27,72,
191,255,24,233,99,87,44,0,234,0,224,81,242,53,10,232,25,48,129,255,
178,252,27,48,129,255,172,252,35,55,21,0,129,255,164,252,26,48,129,255,
158,252,35,54,8,0,2,58,191,255,252,219,131,119,3,0,224,113,226,13,
67,7,2,0,24,48,191,255,30,165,224,81,242,5,23,48,32,62,255,0,
0,66,191,255,34,91,35,54,1,0,2,58,191,255,114,220,35,54,36,0,
2,58,191,255,120,219,35,54,44,0,2,58,191,255,58,219,29,80,128,7,
236,1,35,151,29,0,50,176,35,151,17,0,99,7,29,0,82,177,99,183,
17,0,245,37,129,154,185,29,35,95,29,0,49,6,88,49,141,0,235,158,
96,2,26,64,2,58,209,153,99,159,33,0,19,48,191,255,100,229,99,87,
44,0,234,0,224,81,186,37,35,151,33,0,61,127,5,0,114,127,73,0,
35,159,29,0,65,154,99,159,29,0,35,159,17,0,129,154,99,159,17,0,
35,159,17,0,224,153,250,213,35,119,44,0,224,113,186,13,22,48,2,58,
191,255,176,230,99,87,44,0,10,104,237,0,224,105,242,53,35,239,44,0,
25,48,129,255,190,251,27,48,129,255,184,251,35,55,21,0,129,255,176,251,
26,48,129,255,170,251,35,54,8,0,2,58,191,255,8,219,131,103,3,0,
224,97,226,13,67,7,2,0,24,48,191,255,42,164,224,81,242,5,23,48,
32,62,255,0,0,66,191,255,46,90,35,54,1,0,2,58,191,255,126,219,
35,54,36,0,2,58,191,255,132,218,35,54,44,0,2,58,191,255,70,218,
29,80,197,125,22,48,28,56,25,64,27,72,191,255,164,231,99,87,44,0,
234,0,224,81,226,53,10,232,25,48,129,255,62,251,27,48,129,255,56,251,
35,55,21,0,129,255,48,251,26,48,129,255,42,251,35,54,8,0,2,58,
191,255,136,218,131,87,3,0,224,81,226,13,67,7,2,0,24,48,191,255,
170,163,224,81,242,5,23,48,32,62,255,0,0,66,191,255,174,89,35,54,
1,0,2,58,191,255,254,218,35,54,36,0,2,58,191,255,4,218,35,54,
44,0,2,58,191,255,198,217,29,80,197,61,35,55,25,0,60,62,48,0,
128,255,72,4,35,239,44,0,25,48,129,255,198,250,27,48,129,255,192,250,
35,55,21,0,129,255,184,250,26,48,129,255,178,250,35,54,8,0,2,58,
191,255,16,218,131,143,3,0,224,137,226,13,67,7,2,0,24,48,191,255,
50,163,224,81,242,5,23,48,32,62,255,0,0,66,191,255,54,89,35,54,
1,0,2,58,191,255,134,218,35,54,36,0,2,58,191,255,140,217,35,54,
44,0,2,58,191,255,78,217,29,80,92,6,255,243,128,7,225,0,6,232,
29,143,0,0,7,224,224,137,146,13,38,6,84,67,133,0,32,62,243,9,
0,66,191,255,242,88,28,48,191,255,2,237,10,48,191,255,144,235,29,55,
3,0,10,224,128,255,128,71,28,6,180,255,234,5,10,126,0,248,32,22,
0,4,197,5,10,126,0,184,0,18,125,127,13,0,125,23,9,0,64,6,
255,0,144,7,225,243,6,224,99,231,25,0,61,6,132,67,133,0,99,239,
29,0,36,79,245,178,29,56,28,64,38,6,96,67,133,0,130,255,210,13,
99,7,12,0,99,239,17,0,99,231,21,0,35,54,3,0,191,255,30,218,
0,210,28,6,240,255,129,13,28,128,197,130,32,110,164,180,205,129,48,215,
5,0,224,209,202,21,35,54,3,0,2,58,191,255,182,217,35,54,12,0,
2,58,191,255,136,216,35,54,24,0,2,58,191,255,178,216,32,238,10,1,
128,7,228,1,26,48,35,62,4,0,191,255,6,232,10,200,25,56,35,54,
8,0,191,255,58,217,0,194,25,216,133,45,219,102,1,0,178,37,248,238,
96,2,49,6,88,49,141,0,209,233,29,48,191,255,46,226,99,87,12,0,
234,0,224,81,154,29,29,48,32,62,78,0,191,255,200,222,35,127,5,0,
224,121,154,13,29,48,191,255,88,224,99,87,12,0,234,0,224,81,138,13,
29,48,191,255,28,229,65,194,129,218,224,217,138,221,35,111,5,0,224,105,
210,5,35,103,12,0,224,97,146,29,35,239,12,0,35,54,8,0,2,58,
191,255,108,216,35,54,3,0,2,58,191,255,4,217,35,54,12,0,2,58,
191,255,214,215,35,54,24,0,2,58,191,255,0,216,128,7,54,1,54,6,
144,67,133,0,32,54,0,6,129,255,82,247,10,232,224,233,250,5,22,48,
32,62,18,8,0,66,191,255,114,87,29,184,23,48,0,58,32,70,0,6,
191,255,130,83,61,62,48,0,28,6,240,255,209,5,28,48,128,255,20,2,
197,5,26,48,191,255,56,242,61,54,24,3,61,62,48,0,32,70,88,1,
191,255,252,81,32,86,1,32,125,87,8,0,1,138,125,143,5,0,32,134,
21,0,125,135,10,0,32,126,88,1,125,127,12,0,32,118,144,1,125,119,
14,0,23,48,29,62,0,6,191,255,220,216,125,87,1,0,32,54,0,18,
129,255,206,246,10,216,32,54,0,2,129,255,196,246,10,192,224,217,250,5,
22,48,32,62,45,8,0,66,191,255,228,86,224,193,250,5,22,48,32,62,
46,8,0,66,191,255,212,86,27,48,26,56,1,66,191,255,202,229,59,63,
50,1,25,48,191,255,148,225,28,48,0,58,129,255,38,12,28,48,24,56,
1,66,191,255,28,231,25,48,29,56,24,64,27,72,191,255,70,228,99,87,
12,0,10,232,253,0,24,48,129,255,228,247,27,48,129,255,222,247,23,48,
129,255,216,247,35,54,8,0,2,58,191,255,54,215,35,54,3,0,2,58,
191,255,206,215,35,54,12,0,2,58,191,255,160,214,35,54,24,0,2,58,
191,255,202,214,29,80,80,6,255,243,128,7,33,0,4,55,233,135,196,50,
191,255,248,146,100,87,141,142,64,6,63,0,128,7,97,0,38,6,88,183,
141,0,39,6,180,67,133,0,129,255,196,205,224,81,146,13,38,6,200,67,
133,0,32,62,106,2,0,66,191,255,28,86,38,6,120,183,141,0,39,6,
156,67,133,0,1,66,128,255,94,228,0,234,133,21,253,54,96,2,46,6,
88,49,141,0,36,71,141,142,206,49,29,56,29,80,205,82,202,65,191,255,
116,219,65,234,4,143,233,135,241,233,230,237,64,6,127,0,224,49,210,5,
129,58,185,5,129,7,32,247,127,0,128,7,33,0,224,49,250,5,6,50,
129,255,142,245,10,48,224,49,178,5,102,7,0,0,6,80,64,6,63,0,
128,7,97,0,6,232,224,233,138,13,32,54,96,2,129,255,108,245,10,232,
224,233,210,13,93,7,44,0,61,54,122,0,41,6,254,175,128,0,32,62,
40,0,6,66,129,255,226,244,29,80,64,6,127,0,224,49,210,5,129,58,
185,5,129,7,190,246,127,0,33,6,122,50,1,0,97,0,33,6,50,175,
1,0,97,0,33,6,6,175,1,0,97,0,33,6,168,143,1,0,97,0,
33,6,82,53,1,0,97,0,33,6,94,144,1,0,97,0,33,6,194,176,
1,0,97,0,148,7,225,0,39,55,1,0,39,6,216,68,133,0,130,255,
170,11,224,81,186,69,35,54,4,0,39,6,170,170,102,102,128,255,236,152,
35,54,4,0,128,255,22,169,224,81,162,37,32,230,0,32,35,54,4,0,
128,255,180,147,10,6,0,224,225,5,35,54,4,0,128,255,166,147,10,224,
28,48,129,255,82,246,10,232,29,56,28,64,99,7,1,0,35,54,4,0,
0,74,128,255,40,151,28,134,255,255,221,129,80,7,0,0,149,37,32,54,
80,0,129,255,42,246,10,232,29,96,45,6,180,68,133,0,13,94,34,0,
13,87,0,0,65,106,76,87,0,0,65,98,237,89,154,253,213,13,32,54,
0,32,129,255,2,246,10,232,29,48,32,62,0,32,129,255,24,119,93,7,
255,31,60,6,228,68,133,0,28,48,129,255,224,118,29,48,129,255,218,118,
28,48,129,255,212,118,29,48,129,255,240,245,84,6,255,0,132,7,225,48,
6,208,7,216,97,210,163,93,0,226,252,238,12,0,47,6,16,82,133,0,
59,55,5,0,207,233,61,63,1,0,130,255,194,10,224,81,154,69,98,210,
218,29,61,55,9,0,99,7,5,0,35,62,4,0,4,66,129,255,238,10,
10,56,224,57,226,5,38,6,20,76,133,0,130,255,78,9,35,79,5,0,
61,63,1,0,38,6,140,75,133,0,9,64,130,255,58,9,197,85,59,55,
9,0,37,62,156,132,35,70,4,0,129,255,76,254,97,82,146,13,59,63,
5,0,38,6,196,75,133,0,130,255,22,9,165,69,61,55,9,0,4,66,
35,62,4,0,129,255,204,10,10,56,224,57,130,61,38,6,20,76,133,0,
130,255,246,8,165,53,65,226,103,226,134,181,59,63,5,0,38,6,52,76,
133,0,130,255,224,8,38,6,156,75,133,0,130,255,214,8,0,226,252,238,
12,0,48,6,16,82,133,0,208,233,61,55,9,0,4,66,35,62,4,0,
129,255,74,10,61,79,9,0,35,71,5,0,61,127,5,0,61,63,1,0,
41,79,5,0,99,127,1,0,38,6,248,75,133,0,130,255,152,8,65,226,
103,226,134,229,68,6,255,48,128,7,225,0,7,224,100,50,242,5,38,6,
92,76,133,0,130,255,122,8,197,45,60,55,9,0,32,70,16,0,0,58,
130,255,20,27,60,55,13,0,10,232,0,58,32,70,16,0,130,255,4,27,
60,23,5,0,2,23,0,0,2,6,207,255,130,13,2,6,206,255,130,13,
2,6,204,255,130,13,165,13,93,87,0,0,197,13,125,87,0,0,149,13,
125,87,1,0,229,5,38,6,76,76,133,0,130,255,34,8,64,6,255,0,
128,7,97,0,7,232,99,50,242,5,38,6,180,76,133,0,130,255,10,8,
181,53,61,55,9,0,32,70,16,0,0,58,130,255,164,26,61,23,5,0,
2,23,0,0,2,6,207,255,130,13,2,6,206,255,210,13,2,6,204,255,
162,21,149,29,10,63,0,0,38,6,132,76,133,0,130,255,208,7,229,21,
42,63,0,0,38,6,148,76,133,0,130,255,192,7,229,13,42,63,1,0,
38,6,164,76,133,0,130,255,176,7,229,5,38,6,212,76,133,0,130,255,
164,7,64,6,127,0,128,7,225,48,64,230,16,0,1,50,128,255,106,162,
28,232,128,255,104,166,252,81,218,5,128,255,132,166,74,238,16,0,61,135,
13,0,61,231,25,0,0,210,16,134,208,255,130,130,16,222,255,255,29,238,
28,0,165,29,61,111,1,0,60,71,1,0,237,65,130,21,28,56,38,6,
252,76,133,0,130,255,78,7,61,71,1,0,38,6,228,76,133,0,29,56,
130,255,62,7,65,210,68,226,68,234,106,210,222,5,27,96,95,218,224,97,
202,229,128,255,248,5,64,6,255,48,148,7,225,48,7,216,100,50,242,5,
38,6,28,77,133,0,130,255,16,7,229,93,59,55,5,0,32,70,16,0,
0,58,130,255,170,25,59,55,9,0,10,224,0,58,32,70,16,0,130,255,
154,25,10,232,59,55,13,0,202,234,0,58,32,70,16,0,130,255,136,25,
202,82,10,216,155,0,28,56,35,54,4,0,128,255,108,149,35,54,4,0,
128,255,150,165,35,54,4,0,224,81,178,13,128,255,56,144,28,56,10,64,
38,6,108,77,133,0,130,255,172,6,149,45,29,56,0,66,128,255,120,156,
29,48,129,255,206,242,10,208,26,48,27,56,29,64,191,255,112,77,26,56,
29,64,99,7,1,0,35,54,4,0,0,74,128,255,152,159,10,232,26,48,
129,255,196,242,224,233,138,13,28,56,38,6,156,77,133,0,130,255,102,6,
229,5,38,6,80,77,133,0,130,255,90,6,1,50,128,255,44,161,84,6,
255,48,146,7,225,0,7,232,98,50,249,5,38,6,232,77,133,0,130,255,
60,6,213,117,61,55,5,0,39,6,248,77,133,0,130,255,118,7,224,81,
218,5,60,6,238,238,34,34,133,77,61,55,5,0,39,6,4,78,133,0,
130,255,92,7,224,81,218,5,60,6,221,221,51,51,181,61,61,55,5,0,
39,6,184,77,133,0,130,255,66,7,224,81,218,5,60,6,187,187,85,85,
229,45,61,55,5,0,39,6,20,78,133,0,130,255,40,7,224,81,218,5,
60,6,170,170,102,102,149,37,61,55,5,0,39,6,32,78,133,0,130,255,
14,7,224,81,218,5,60,6,68,51,34,17,197,21,61,55,5,0,37,62,
160,132,60,6,153,153,119,119,130,255,240,6,224,81,146,13,61,55,5,0,
32,70,16,0,0,58,130,255,62,24,10,224,28,56,3,48,128,255,40,148,
3,48,128,255,2,143,10,224,224,225,210,13,3,48,128,255,192,151,61,63,
5,0,38,6,196,77,133,0,28,64,130,255,104,5,133,13,61,63,5,0,
38,6,44,78,133,0,130,255,88,5,1,50,128,255,42,160,82,6,255,0,
128,7,97,0,229,87,64,0,224,7,96,1,36,239,234,135,32,254,116,241,
223,55,0,0,64,86,0,0,0,90,74,95,144,244,32,254,118,241,223,55,
0,0,64,86,0,0,0,90,74,95,144,244,32,254,36,241,223,55,0,0,
64,86,0,0,0,90,74,95,144,244,100,234,215,21,32,254,38,241,223,55,
0,0,64,86,0,0,0,90,74,95,144,244,104,234,167,13,32,254,40,241,
223,55,0,0,64,86,0,0,0,90,74,95,144,244,32,254,34,241,223,55,
0,0,64,86,0,0,0,90,74,95,144,244,32,254,32,241,223,55,0,0,
64,86,0,0,0,90,74,95,144,244,3,138,68,143,88,137,129,255,18,154,
129,255,84,148,129,255,146,154,32,254,116,241,223,183,0,0,64,86,0,0,
0,90,74,95,144,244,32,254,118,241,223,183,0,0,64,86,0,0,0,90,
74,95,144,244,32,254,36,241,223,183,0,0,64,86,0,0,0,90,74,95,
144,244,100,234,215,21,32,254,38,241,223,183,0,0,64,86,0,0,0,90,
74,95,144,244,104,234,167,13,32,254,40,241,223,183,0,0,64,86,0,0,
0,90,74,95,144,244,32,254,34,241,223,183,0,0,64,86,0,0,0,90,
74,95,144,244,32,254,32,241,223,183,0,0,64,86,0,0,0,90,74,95,
144,244,64,6,127,0,128,7,240,2,128,7,97,0,0,234,253,134,12,0,
47,6,192,80,133,0,207,129,48,71,5,0,48,63,1,0,38,6,72,78,
133,0,130,255,244,3,65,234,29,6,228,255,230,237,64,6,127,0,130,7,
33,0,38,6,88,78,133,0,39,6,104,78,133,0,130,255,212,3,4,138,
99,143,1,0,38,6,124,78,133,0,32,62,24,0,32,70,28,0,9,74,
130,255,186,3,38,6,168,78,133,0,39,6,204,78,133,0,40,6,216,78,
133,0,37,78,168,132,130,255,160,3,38,6,228,78,133,0,39,6,108,24,
134,0,130,255,144,3,66,6,63,0,128,7,225,48,6,208,7,216,224,209,
162,53,59,87,1,0,10,16,65,18,2,143,255,255,224,137,202,253,170,17,
2,126,255,255,226,37,0,234,253,230,12,0,44,6,192,80,133,0,59,63,
1,0,204,225,60,55,1,0,130,255,152,4,224,81,170,13,60,95,9,0,
26,48,27,56,63,6,208,183,128,0,107,0,229,13,65,234,29,6,228,255,
230,229,38,6,244,78,133,0,130,255,38,3,26,48,27,56,191,255,10,255,
64,6,255,48,128,7,225,16,6,216,7,224,60,55,5,0,0,66,0,58,
130,255,176,21,0,50,10,232,29,6,240,255,177,13,29,16,197,18,32,118,
164,180,206,17,34,111,5,0,224,105,162,5,2,48,224,49,178,5,98,218,
146,13,60,63,5,0,38,6,40,79,133,0,130,255,210,2,197,13,128,255,
148,1,10,56,224,57,242,5,29,64,38,6,68,79,133,0,130,255,186,2,
64,6,255,16,1,138,100,143,105,137,127,0,128,54,255,255,129,7,46,103,
136,7,225,16,6,216,7,224,60,55,5,0,35,70,4,0,37,62,172,132,
129,255,178,247,60,55,9,0,10,232,37,62,172,132,35,70,8,0,129,255,
160,247,202,233,98,234,242,5,38,6,184,79,133,0,130,255,108,2,149,77,
35,54,12,0,0,58,4,66,191,255,62,73,35,70,12,0,99,218,250,29,
35,55,5,0,35,63,9,0,4,74,129,255,204,2,10,232,224,233,242,5,
29,56,38,6,16,80,133,0,130,255,54,2,35,79,13,0,35,71,9,0,
35,63,5,0,99,79,1,0,38,6,156,79,133,0,130,255,28,2,149,29,
60,55,13,0,37,62,172,132,129,255,50,247,97,82,242,5,38,6,108,79,
133,0,130,255,0,2,181,21,35,55,5,0,35,63,9,0,4,74,35,70,
12,0,129,255,212,2,10,232,224,233,242,5,29,56,38,6,236,79,133,0,
130,255,218,1,72,6,255,16,154,7,33,0,32,143,177,182,38,6,104,80,
133,0,99,143,21,0,130,255,192,1,35,55,21,0,224,49,194,61,35,134,
36,0,99,135,1,0,35,126,40,0,99,127,5,0,35,118,44,0,99,119,
9,0,35,110,20,0,99,111,13,0,35,102,48,0,99,103,17,0,35,62,
24,0,35,70,28,0,35,78,32,0,129,255,186,190,10,56,224,57,242,5,
38,6,48,80,133,0,130,255,112,1,245,21,35,143,29,0,35,63,25,0,
47,6,68,50,134,0,194,138,207,137,49,71,1,0,38,6,92,80,133,0,
130,255,78,1,32,119,177,182,35,111,21,0,238,105,170,197,90,6,63,0,
127,0,33,6,80,145,1,0,97,0,33,6,0,37,0,0,97,0,33,6,
150,175,1,0,97,0,135,0,0,18,2,136,198,137,81,63,0,0,65,18,
2,6,0,254,150,253,127,0,0,18,245,13,2,136,198,137,2,120,199,121,
143,119,1,0,145,135,1,0,238,129,194,5,32,86,19,48,229,5,65,18,
232,17,150,245,31,18,0,82,105,23,1,0,127,0,132,7,225,240,6,192,
9,200,35,215,37,0,7,232,8,224,221,225,99,7,5,0,229,69,29,48,
26,56,32,70,0,2,191,255,118,154,10,216,224,217,194,13,61,6,228,82,
133,0,24,48,29,56,128,255,130,122,29,48,130,255,162,0,229,53,25,48,
26,56,32,70,0,2,35,78,4,0,191,255,134,255,10,216,224,217,210,37,
35,23,5,0,24,48,2,64,2,104,218,17,130,87,1,0,217,105,141,79,
1,0,39,6,100,82,133,0,99,87,1,0,221,65,128,255,62,122,35,23,
5,0,2,56,2,120,218,17,217,121,143,71,1,0,130,79,1,0,221,57,
38,6,164,82,133,0,130,255,68,0,245,5,29,238,0,2,28,94,0,254,
235,233,131,189,27,80,68,6,255,240,130,7,225,241,7,208,8,200,9,184,
64,198,160,0,32,238,130,3,6,216,38,6,140,83,133,0,130,255,18,0,
196,207,84,144,226,85,50,6,20,222,136,0,50,239,1,0,38,6,36,83,
133,0,29,56,93,230,160,0,129,255,242,255,28,56,38,6,64,83,133,0,
129,255,230,255,38,6,176,83,133,0,64,62,160,0,129,255,216,255,25,48,
32,62,170,0,191,255,174,254,27,48,29,56,25,72,99,191,1,0,64,70,
160,0,191,255,224,254,38,6,212,221,136,0,10,58,10,232,224,233,226,5,
191,255,12,129,191,255,112,114,165,37,191,255,2,129,10,232,224,233,226,13,
60,6,92,83,133,0,27,48,28,56,128,255,102,121,28,48,129,255,134,255,
191,255,76,114,133,21,191,255,70,114,10,232,224,233,178,13,60,6,204,83,
133,0,27,48,28,56,128,255,66,121,28,48,129,255,98,255,38,6,252,82,
133,0,129,255,88,255,58,111,1,0,29,80,65,106,122,111,1,0,66,6,
255,241,128,7,225,48,6,232,61,223,8,0,224,217,218,37,245,29,27,224,
61,215,13,0,61,79,21,0,61,71,17,0,61,55,25,0,193,226,220,209,
61,62,28,0,191,255,238,254,61,119,13,0,122,87,0,0,206,225,60,111,
0,0,224,105,226,5,61,103,33,0,65,98,125,103,33,0,65,218,61,95,
37,0,235,217,246,221,229,5,61,87,33,0,65,82,125,87,33,0,36,143,
121,136,38,6,228,83,133,0,17,62,1,0,100,63,121,136,129,255,210,254,
61,135,33,0,0,82,224,129,178,5,32,86,19,48,64,6,255,48,128,7,
225,112,6,232,7,200,224,233,186,5,128,7,28,1,49,6,124,50,134,0,
61,63,29,0,125,143,49,0,60,6,164,84,133,0,28,48,129,255,150,254,
61,63,29,0,38,6,192,84,133,0,129,255,136,254,61,63,33,0,38,6,
216,84,133,0,129,255,122,254,61,63,29,0,28,48,129,255,112,254,61,135,
8,0,224,129,162,29,61,55,25,0,39,6,248,83,133,0,6,64,128,255,
50,120,61,55,25,0,61,71,8,0,39,6,240,84,133,0,128,255,32,120,
61,63,8,0,38,6,68,84,133,0,129,255,56,254,213,53,61,111,33,0,
224,105,146,53,38,6,48,84,133,0,129,255,36,254,61,55,25,0,37,62,
184,132,128,255,242,119,0,226,133,37,61,95,13,0,28,216,193,218,219,89,
43,79,0,0,224,73,226,21,61,55,25,0,28,214,1,0,26,64,39,6,
108,84,133,0,128,255,200,119,61,119,13,0,206,217,59,71,0,0,38,6,
128,84,133,0,26,56,129,255,216,253,65,226,61,103,37,0,236,225,230,221,
61,95,1,0,61,87,5,0,203,15,53,0,61,143,33,0,61,55,13,0,
106,143,5,0,129,255,0,234,61,55,17,0,129,255,248,233,61,55,21,0,
129,255,240,233,129,202,201,5,29,48,129,255,170,233,64,6,255,112,128,7,
225,0,6,232,7,224,224,233,146,13,0,58,191,255,198,254,129,226,201,5,
29,48,129,255,138,233,64,6,255,0,128,7,225,48,6,232,7,216,8,208,
9,224,224,233,138,13,32,54,52,0,129,255,236,231,10,232,224,233,194,69,
125,7,29,0,125,7,33,0,60,127,5,0,252,95,9,0,125,223,1,0,
49,6,124,50,134,0,125,127,37,0,60,111,1,0,125,143,49,0,125,95,
44,0,252,143,11,0,125,231,5,0,125,111,41,0,218,134,255,255,125,143,
46,0,125,135,25,0,15,48,193,50,129,255,62,233,125,87,13,0,0,18,
149,13,61,143,13,0,2,96,193,98,65,18,209,97,108,7,0,0,61,135,
37,0,240,17,214,245,125,7,8,0,32,54,0,2,129,255,18,233,125,87,
17,0,32,54,0,2,129,255,6,233,125,87,21,0,29,80,64,6,255,48,
128,7,225,48,6,232,7,224,8,216,9,208,224,233,138,13,32,54,52,0,
129,255,66,231,10,232,224,233,146,21,29,48,28,56,27,64,26,72,191,255,
48,255,49,6,140,52,134,0,125,143,49,0,38,6,4,85,133,0,129,255,
140,252,29,80,64,6,255,48,128,7,97,0,6,232,224,233,138,13,32,54,
52,0,129,255,4,231,10,232,224,233,130,61,49,6,124,50,134,0,125,143,
49,0,125,7,1,0,125,7,29,0,125,7,33,0,1,50,125,55,37,0,
125,7,25,0,2,50,129,255,122,232,125,87,13,0,0,18,149,13,61,143,
13,0,2,96,193,98,65,18,209,97,108,7,0,0,61,135,37,0,240,17,
214,245,64,126,137,0,47,127,17,222,125,7,8,0,32,54,0,2,100,127,
117,136,129,255,66,232,125,87,17,0,32,54,0,2,129,255,54,232,125,87,
21,0,29,80,64,6,127,0,128,7,97,0,6,232,224,233,138,13,32,54,
52,0,129,255,120,230,10,232,224,233,146,13,29,48,191,255,90,255,49,6,
140,52,134,0,125,143,49,0,29,80,64,6,127,0,130,7,225,243,7,184,
8,192,9,176,64,222,160,0,32,238,130,3,6,200,38,6,112,85,133,0,
129,255,174,251,196,207,84,144,186,5,128,7,6,1,50,6,20,222,136,0,
50,215,1,0,38,6,84,85,133,0,26,56,90,230,160,0,129,255,138,251,
28,56,38,6,152,85,133,0,129,255,126,251,38,6,56,86,133,0,64,62,
160,0,129,255,112,251,38,6,180,85,133,0,129,255,102,251,24,48,32,62,
170,0,191,255,60,250,26,216,213,21,27,48,24,56,32,70,0,2,191,255,
194,130,10,232,224,233,162,13,60,6,220,85,133,0,25,48,28,56,128,255,
18,117,28,48,133,77,27,222,0,2,28,126,0,254,239,217,147,237,38,6,
84,86,133,0,129,255,30,251,38,6,132,86,133,0,129,255,20,251,25,48,
26,56,24,72,99,183,1,0,64,70,160,0,191,255,38,250,10,232,38,6,
244,85,133,0,129,255,246,250,224,233,154,45,60,6,212,221,136,0,28,48,
9,58,191,255,70,124,10,232,224,233,162,13,60,6,36,85,133,0,25,48,
28,56,128,255,170,116,28,48,197,21,196,7,84,144,191,255,64,118,10,232,
224,233,242,13,28,48,0,58,191,255,24,124,60,6,32,86,133,0,25,48,
28,56,128,255,130,116,28,48,129,255,162,250,38,6,168,86,133,0,129,255,
152,250,55,95,1,0,29,80,65,90,119,95,1,0,66,6,255,243,128,7,
225,48,6,232,61,223,8,0,224,217,218,37,245,29,27,224,61,215,13,0,
61,79,21,0,61,71,17,0,61,55,25,0,193,226,220,209,61,62,28,0,
191,255,146,254,61,119,13,0,122,87,0,0,206,225,60,111,0,0,224,105,
226,5,61,103,33,0,65,98,125,103,33,0,65,218,61,95,37,0,235,217,
246,221,229,5,61,87,33,0,65,82,125,87,33,0,36,143,121,136,38,6,
216,86,133,0,17,62,1,0,100,63,121,136,129,255,18,250,61,135,33,0,
0,82,224,129,178,5,32,86,19,48,64,6,255,48,128,7,225,0,6,232,
7,224,224,233,146,13,0,58,191,255,50,251,129,226,201,5,29,48,129,255,
246,229,64,6,255,0,128,7,225,48,6,232,7,224,8,216,9,208,224,233,
138,13,32,54,52,0,129,255,88,228,10,232,224,233,146,21,29,48,28,56,
27,64,26,72,191,255,70,252,49,6,116,52,134,0,125,143,49,0,38,6,
236,86,133,0,129,255,162,249,29,80,64,6,255,48,128,7,97,0,6,232,
224,233,138,13,32,54,52,0,129,255,26,228,10,232,224,233,146,13,29,48,
191,255,252,252,49,6,116,52,134,0,125,143,49,0,29,80,64,6,127,0,
128,7,225,48,196,207,84,144,32,238,130,3,7,208,6,216,130,37,1,50,
37,62,192,132,191,255,104,105,10,232,224,233,146,13,60,6,16,87,133,0,
27,48,28,56,128,255,24,115,213,13,191,255,224,111,10,232,224,233,178,13,
60,6,48,87,133,0,27,48,28,56,128,255,254,114,28,48,129,255,30,249,
58,119,1,0,29,80,65,114,122,119,1,0,64,6,255,48,128,7,225,48,
6,232,61,223,8,0,224,217,154,37,181,29,61,215,13,0,27,224,193,226,
61,55,25,0,61,62,28,0,220,209,191,255,126,255,61,119,13,0,122,87,
0,0,206,225,60,111,0,0,224,105,226,5,61,103,33,0,65,98,125,103,
33,0,65,218,61,95,37,0,235,217,182,229,229,5,61,87,33,0,65,82,
125,87,33,0,36,143,121,136,38,6,80,87,133,0,17,62,1,0,100,63,
121,136,129,255,160,248,61,135,33,0,0,82,224,129,178,5,32,86,19,48,
64,6,255,48,128,7,225,0,6,232,7,224,224,233,146,13,0,58,191,255,
192,249,129,226,201,5,29,48,129,255,132,228,64,6,255,0,128,7,225,48,
6,232,7,224,8,216,9,208,224,233,138,13,32,54,52,0,129,255,230,226,
10,232,224,233,146,21,29,48,28,56,27,64,26,72,191,255,212,250,49,6,
92,52,134,0,125,143,49,0,38,6,100,87,133,0,129,255,48,248,29,80,
64,6,255,48,128,7,97,0,7,232,191,255,56,111,61,143,1,0,65,138,
125,143,1,0,64,6,127,0,128,7,225,48,6,232,61,223,8,0,224,217,
154,37,181,29,61,215,13,0,27,224,193,226,61,55,25,0,61,62,28,0,
220,209,191,255,198,255,61,119,13,0,122,87,0,0,206,225,60,111,0,0,
224,105,226,5,61,103,33,0,65,98,125,103,33,0,65,218,61,95,37,0,
235,217,182,229,229,5,61,87,33,0,65,82,125,87,33,0,36,143,121,136,
38,6,132,87,133,0,17,62,1,0,100,63,121,136,129,255,164,247,61,135,
33,0,0,82,224,129,178,5,32,86,19,48,64,6,255,48,128,7,225,0,
6,232,7,224,224,233,146,13,0,58,191,255,196,248,129,226,201,5,29,48,
129,255,136,227,64,6,255,0,128,7,225,48,6,232,7,224,8,216,9,208,
224,233,138,13,32,54,52,0,129,255,234,225,10,232,224,233,146,21,29,48,
28,56,27,64,26,72,191,255,216,249,49,6,68,52,134,0,125,143,49,0,
38,6,152,87,133,0,129,255,52,247,29,80,64,6,255,48,128,7,97,0,
7,232,200,0,8,48,134,0,191,255,84,110,61,127,1,0,65,122,125,127,
1,0,64,6,127,0,128,7,225,48,6,232,61,223,8,0,224,217,186,37,
213,29,27,224,61,215,13,0,253,71,45,0,61,55,25,0,193,226,220,209,
61,62,28,0,191,255,188,255,61,111,13,0,122,87,0,0,205,225,60,103,
0,0,224,97,226,5,61,95,33,0,65,90,125,95,33,0,65,218,61,87,
37,0,234,217,150,229,229,5,61,143,33,0,65,138,125,143,33,0,36,135,
121,136,38,6,172,87,133,0,16,62,1,0,100,63,121,136,129,255,158,246,
61,127,33,0,0,82,224,121,178,5,32,86,19,48,64,6,255,48,128,7,
225,0,6,232,7,224,224,233,146,13,0,58,191,255,190,247,129,226,201,5,
29,48,129,255,130,226,64,6,255,0,128,7,225,48,6,232,7,224,8,216,
9,208,224,233,138,13,32,54,52,0,129,255,228,224,10,232,224,233,130,29,
29,48,28,56,27,64,26,72,191,255,210,248,49,6,44,52,134,0,125,143,
49,0,38,6,216,87,133,0,129,255,46,246,253,63,45,0,38,6,192,87,
133,0,129,255,32,246,29,80,64,6,255,48,128,7,97,0,7,232,191,255,
140,114,61,143,1,0,65,138,125,143,1,0,64,6,127,0,128,7,225,48,
6,232,61,223,8,0,224,217,154,37,181,29,61,215,13,0,27,224,193,226,
61,55,25,0,61,62,28,0,220,209,191,255,198,255,61,119,13,0,122,87,
0,0,206,225,60,111,0,0,224,105,226,5,61,103,33,0,65,98,125,103,
33,0,65,218,61,95,37,0,235,217,182,229,229,5,61,87,33,0,65,82,
125,87,33,0,36,143,121,136,38,6,252,87,133,0,17,62,1,0,100,63,
121,136,129,255,148,245,61,135,33,0,0,82,224,129,178,5,32,86,19,48,
64,6,255,48,128,7,225,0,6,232,7,224,224,233,146,13,0,58,191,255,
180,246,129,226,201,5,29,48,129,255,120,225,64,6,255,0,128,7,225,48,
6,232,7,224,8,216,9,208,224,233,138,13,32,54,52,0,129,255,218,223,
10,232,224,233,146,21,29,48,28,56,27,64,26,72,191,255,200,247,49,6,
20,52,134,0,125,143,49,0,38,6,16,88,133,0,129,255,36,245,29,80,
64,6,255,48,128,7,97,0,6,232,38,6,68,88,133,0,129,255,14,245,
129,255,112,9,61,143,29,0,0,82,65,138,125,143,29,0,64,6,127,0,
146,7,97,0,6,232,3,48,39,6,238,238,34,34,128,255,134,131,3,48,
128,255,178,147,224,81,210,13,3,48,128,255,32,135,38,6,112,88,133,0,
129,255,206,244,1,138,125,143,29,0,229,5,38,6,148,88,133,0,129,255,
188,244,0,82,82,6,127,0,128,7,225,112,8,200,7,216,227,63,25,0,
9,232,29,208,0,50,128,255,106,43,10,224,224,225,202,69,29,56,0,50,
32,70,0,2,191,255,72,142,10,224,224,225,186,61,38,6,8,89,133,0,
129,255,126,244,250,119,177,0,14,104,168,106,205,238,127,0,29,16,2,6,
240,255,225,5,100,18,226,13,104,18,138,37,181,13,2,6,240,255,210,13,
2,6,224,255,242,13,2,6,192,255,146,21,213,21,2,234,38,6,28,89,
133,0,197,21,4,234,38,6,40,89,133,0,245,13,5,234,38,6,240,88,
133,0,165,13,6,234,38,6,252,88,133,0,213,5,0,234,38,6,228,88,
133,0,129,255,24,244,121,239,10,0,59,103,1,0,28,80,65,98,123,103,
1,0,64,6,255,112,130,7,225,48,6,232,61,223,8,0,224,217,154,45,
181,37,61,215,13,0,27,224,193,226,253,127,45,0,61,55,25,0,61,71,
5,0,61,79,17,0,99,127,1,0,220,209,61,62,28,0,191,255,28,255,
61,111,13,0,122,87,0,0,205,225,60,103,0,0,224,97,226,5,61,95,
33,0,65,90,125,95,33,0,65,218,61,87,37,0,234,217,182,221,229,5,
61,143,33,0,65,138,125,143,33,0,36,135,121,136,38,6,52,89,133,0,
16,62,1,0,100,63,121,136,129,255,134,243,61,127,33,0,0,82,224,121,
178,5,32,86,19,48,66,6,255,48,128,7,225,0,6,232,7,224,224,233,
146,13,0,58,191,255,166,244,129,226,201,5,29,48,129,255,106,223,64,6,
255,0,128,7,225,48,6,232,7,224,8,216,9,208,224,233,138,13,32,54,
52,0,129,255,204,221,10,232,224,233,130,29,29,48,28,56,27,64,26,72,
191,255,186,245,49,6,52,53,134,0,125,143,49,0,38,6,72,89,133,0,
129,255,22,243,253,63,45,0,38,6,100,89,133,0,129,255,8,243,29,80,
64,6,255,48,130,7,225,112,7,200,9,48,0,58,8,232,32,134,36,0,
99,135,1,0,32,78,0,2,128,255,184,41,10,208,224,209,202,61,189,103,
3,0,157,135,3,0,216,98,208,130,204,129,189,103,1,0,157,223,1,0,
38,6,152,89,133,0,200,98,208,97,204,217,27,56,129,255,184,242,189,119,
5,0,157,231,5,0,200,114,206,225,129,226,220,0,224,225,226,29,28,6,
127,255,185,5,32,230,128,0,28,56,38,6,116,89,133,0,129,255,142,242,
0,18,213,13,29,80,194,81,170,103,7,0,138,95,7,0,66,18,200,98,
204,89,123,95,0,0,66,218,28,128,193,130,240,17,150,245,57,119,1,0,
26,80,65,114,121,119,1,0,66,6,255,112,128,7,225,48,6,232,61,223,
8,0,224,217,218,37,245,29,27,224,61,215,13,0,61,79,41,0,61,71,
17,0,61,55,25,0,193,226,220,209,61,62,28,0,191,255,46,255,61,119,
13,0,122,87,0,0,206,225,60,111,0,0,224,105,226,5,61,103,33,0,
65,98,125,103,33,0,65,218,61,95,37,0,235,217,246,221,229,5,61,87,
33,0,65,82,125,87,33,0,36,143,121,136,38,6,180,89,133,0,17,62,
1,0,100,63,121,136,129,255,228,241,61,135,33,0,0,82,224,129,178,5,
32,86,19,48,64,6,255,48,128,7,225,0,6,232,7,224,224,233,146,13,
0,58,191,255,4,243,129,226,201,5,29,48,129,255,200,221,64,6,255,0,
128,7,225,48,6,232,7,224,8,216,9,208,224,233,138,13,32,54,52,0,
129,255,42,220,10,232,224,233,146,21,29,48,28,56,27,64,26,72,191,255,
24,244,49,6,28,53,134,0,125,143,49,0,38,6,200,89,133,0,129,255,
116,241,29,80,64,6,255,48,130,7,225,240,7,200,9,192,24,48,0,58,
8,232,32,134,36,0,99,135,1,0,32,78,0,2,128,255,34,40,10,208,
224,209,218,77,189,103,3,0,157,135,3,0,216,98,208,130,204,129,189,103,
1,0,157,223,1,0,38,6,224,89,133,0,200,98,208,97,204,217,27,56,
129,255,34,241,189,119,5,0,157,231,5,0,200,114,206,225,129,226,220,0,
224,225,242,45,28,6,127,255,185,5,32,230,128,0,28,56,38,6,248,89,
133,0,129,255,248,240,6,18,133,21,251,127,1,0,66,218,29,80,194,81,
10,134,1,0,2,112,221,113,78,127,0,0,168,122,80,127,0,0,66,18,
28,104,193,106,13,94,6,0,235,17,198,237,24,48,0,58,29,64,32,86,
129,0,99,87,1,0,32,78,0,2,128,255,134,39,10,208,57,135,1,0,
26,80,65,130,121,135,1,0,66,6,255,240,128,7,225,48,6,232,61,223,
8,0,224,217,218,37,245,29,27,224,61,215,13,0,61,79,41,0,61,71,
17,0,61,55,25,0,193,226,220,209,61,62,28,0,191,255,10,255,61,119,
13,0,122,87,0,0,206,225,60,111,0,0,224,105,226,5,61,103,33,0,
65,98,125,103,33,0,65,218,61,95,37,0,235,217,246,221,229,5,61,87,
33,0,65,82,125,87,33,0,36,143,121,136,38,6,28,90,133,0,17,62,
1,0,100,63,121,136,129,255,44,240,61,135,33,0,0,82,224,129,178,5,
32,86,19,48,64,6,255,48,128,7,225,0,6,232,7,224,224,233,146,13,
0,58,191,255,76,241,129,226,201,5,29,48,129,255,16,220,64,6,255,0,
128,7,225,48,6,232,7,224,8,216,9,208,224,233,138,13,32,54,52,0,
129,255,114,218,10,232,224,233,146,21,29,48,28,56,27,64,26,72,191,255,
96,242,49,6,4,53,134,0,125,143,49,0,38,6,48,90,133,0,129,255,
188,239,29,80,64,6,255,48,130,7,225,112,7,200,9,48,0,58,8,232,
32,134,36,0,99,135,1,0,32,78,0,2,128,255,108,38,10,208,224,209,
250,53,189,103,3,0,157,135,3,0,216,98,208,130,204,129,189,103,1,0,
157,223,1,0,38,6,108,90,133,0,200,98,208,97,204,217,27,56,129,255,
108,239,189,119,5,0,157,231,5,0,200,114,206,225,220,0,224,225,162,29,
28,6,255,254,185,5,32,230,0,1,28,56,38,6,72,90,133,0,129,255,
68,239,0,18,181,13,29,120,194,121,15,118,6,0,142,111,1,0,65,18,
91,111,0,0,65,218,252,17,214,245,57,95,1,0,26,80,65,90,121,95,
1,0,66,6,255,112,128,7,225,48,6,232,61,223,8,0,224,217,218,37,
245,29,27,224,61,215,13,0,61,79,41,0,61,71,17,0,61,55,25,0,
193,226,220,209,61,62,28,0,191,255,56,255,61,119,13,0,122,87,0,0,
206,225,60,111,0,0,224,105,226,5,61,103,33,0,65,98,125,103,33,0,
65,218,61,95,37,0,235,217,246,221,229,5,61,87,33,0,65,82,125,87,
33,0,36,143,121,136,38,6,136,90,133,0,17,62,1,0,100,63,121,136,
129,255,162,238,61,135,33,0,0,82,224,129,178,5,32,86,19,48,64,6,
255,48,128,7,225,0,6,232,7,224,224,233,146,13,0,58,191,255,194,239,
129,226,201,5,29,48,129,255,134,218,64,6,255,0,128,7,225,48,6,232,
7,224,8,216,9,208,224,233,138,13,32,54,52,0,129,255,232,216,10,232,
224,233,146,21,29,48,28,56,27,64,26,72,191,255,214,240,49,6,236,52,
134,0,125,143,49,0,38,6,156,90,133,0,129,255,50,238,29,80,64,6,
255,48,130,7,225,240,7,200,9,192,24,48,0,58,8,232,32,134,36,0,
99,135,1,0,32,78,0,2,128,255,224,36,10,208,224,209,186,69,189,103,
3,0,157,135,3,0,216,98,208,130,204,129,189,103,1,0,157,223,1,0,
38,6,180,90,133,0,200,98,208,97,204,217,27,56,129,255,224,237,189,119,
5,0,157,231,5,0,200,114,206,225,220,0,224,225,226,37,28,6,255,254,
185,5,32,230,0,1,28,56,38,6,204,90,133,0,129,255,184,237,6,18,
149,13,155,119,1,0,2,120,221,121,65,218,79,119,0,0,65,18,28,102,
6,0,236,17,214,245,24,48,0,58,29,64,32,94,129,0,99,95,1,0,
32,78,0,2,128,255,88,36,10,208,57,87,1,0,65,82,121,87,1,0,
26,80,66,6,255,240,128,7,225,48,6,232,61,223,8,0,224,217,218,37,
245,29,27,224,61,215,13,0,61,79,41,0,61,71,17,0,61,55,25,0,
193,226,220,209,61,62,28,0,191,255,30,255,61,119,13,0,122,87,0,0,
206,225,60,111,0,0,224,105,226,5,61,103,33,0,65,98,125,103,33,0,
65,218,61,95,37,0,235,217,246,221,229,5,61,87,33,0,65,82,125,87,
33,0,36,143,121,136,38,6,240,90,133,0,17,62,1,0,100,63,121,136,
129,255,254,236,61,135,33,0,0,82,224,129,178,5,32,86,19,48,64,6,
255,48,128,7,225,0,6,232,7,224,224,233,146,13,0,58,191,255,30,238,
129,226,201,5,29,48,129,255,226,216,64,6,255,0,128,7,225,48,6,232,
7,224,8,216,9,208,224,233,138,13,32,54,52,0,129,255,68,215,10,232,
224,233,146,21,29,48,28,56,27,64,26,72,191,255,50,239,49,6,212,52,
134,0,125,143,49,0,38,6,4,91,133,0,129,255,142,236,29,80,64,6,
255,48,128,7,225,241,6,224,7,184,8,200,0,194,0,234,128,255,80,35,
10,248,97,202,185,5,128,7,174,2,226,5,99,202,161,13,242,13,128,7,
162,2,223,134,32,0,16,6,224,255,146,125,197,13,223,102,96,0,12,6,
160,255,178,117,229,5,223,134,224,0,16,6,32,255,210,109,61,6,140,91,
133,0,28,48,29,56,128,255,10,102,29,48,129,255,42,236,128,7,104,2,
97,234,209,5,242,5,98,234,130,13,149,13,32,222,32,0,229,5,32,222,
64,0,181,5,32,222,128,0,29,208,194,210,26,48,191,255,212,61,128,255,
214,34,91,81,242,13,59,6,200,91,133,0,28,48,27,56,29,64,128,255,
194,101,27,48,29,56,129,255,224,235,128,7,30,2,26,48,191,255,128,61,
128,255,172,34,27,136,74,137,251,137,242,13,59,6,4,92,133,0,28,48,
27,56,29,64,128,255,148,101,27,48,29,56,129,255,178,235,128,7,240,1,
97,234,209,5,226,13,98,234,226,21,229,29,32,254,36,241,223,191,0,0,
64,86,0,0,0,90,74,95,144,244,197,21,32,254,38,241,223,191,0,0,
64,86,0,0,0,90,74,95,144,244,165,13,32,254,40,241,223,191,0,0,
64,86,0,0,0,90,74,95,144,244,65,234,249,233,246,157,1,50,128,255,
62,34,32,54,232,3,129,255,178,119,128,255,58,34,10,248,223,126,2,0,
242,29,32,254,32,241,223,191,0,0,64,86,0,0,0,90,74,95,144,244,
32,254,34,241,223,191,0,0,64,86,0,0,0,90,74,95,144,244,61,6,
68,92,133,0,28,48,29,56,128,255,240,100,29,48,129,255,16,235,128,7,
78,1,223,238,4,0,0,50,128,255,228,33,100,234,242,29,32,254,32,241,
223,191,0,0,64,86,0,0,0,90,74,95,144,244,32,254,34,241,223,191,
0,0,64,86,0,0,0,90,74,95,144,244,61,6,124,92,133,0,28,48,
29,56,128,255,166,100,29,48,129,255,198,234,128,7,4,1,32,54,232,3,
129,255,24,119,128,255,160,33,202,126,2,0,98,122,210,21,32,254,32,241,
223,191,0,0,64,86,0,0,0,90,74,95,144,244,61,6,28,91,133,0,
28,48,29,56,128,255,104,100,29,48,129,255,136,234,181,101,32,254,32,241,
223,191,0,0,64,86,0,0,0,90,74,95,144,244,32,254,34,241,223,191,
0,0,64,86,0,0,0,90,74,95,144,244,128,255,80,33,32,54,232,3,
129,255,180,118,128,255,60,33,131,82,233,29,32,254,32,241,223,191,0,0,
64,86,0,0,0,90,74,95,144,244,32,254,34,241,223,191,0,0,64,86,
0,0,0,90,74,95,144,244,61,6,184,92,133,0,28,48,29,56,128,255,
246,99,29,48,129,255,22,234,165,45,128,255,2,33,32,54,232,3,129,255,
102,118,128,255,238,32,10,248,32,238,32,241,221,191,0,0,64,86,0,0,
0,90,74,95,144,244,32,238,34,241,221,191,0,0,64,86,0,0,0,90,
74,95,144,244,223,126,4,0,100,122,210,13,61,6,84,91,133,0,28,48,
29,56,128,255,162,99,29,48,129,255,194,233,32,198,106,48,55,103,1,0,
24,80,65,98,119,103,1,0,64,6,255,241,128,7,225,48,6,232,61,223,
8,0,224,217,186,37,213,29,27,224,61,215,13,0,61,71,53,0,61,55,
25,0,193,226,220,209,61,62,28,0,191,255,0,253,61,119,13,0,122,87,
0,0,206,225,60,111,0,0,224,105,226,5,61,103,33,0,65,98,125,103,
33,0,65,218,61,95,37,0,235,217,150,229,229,5,61,87,33,0,65,82,
125,87,33,0,36,143,121,136,38,6,240,92,133,0,17,62,1,0,100,63,
121,136,129,255,60,233,61,135,33,0,0,82,224,129,178,5,32,86,19,48,
64,6,255,48,128,7,225,0,6,232,7,224,224,233,146,13,0,58,191,255,
92,234,129,226,201,5,29,48,129,255,32,213,64,6,255,0,128,7,225,48,
6,232,7,224,8,216,9,208,224,233,138,13,32,54,56,0,129,255,130,211,
10,232,224,233,146,37,29,48,28,56,27,64,26,72,191,255,112,235,253,127,
45,0,49,6,188,52,134,0,125,143,49,0,130,122,125,127,53,0,202,5,
1,98,125,103,53,0,38,6,4,93,133,0,129,255,186,232,61,63,53,0,
38,6,48,93,133,0,129,255,172,232,29,80,64,6,255,48,132,7,225,112,
6,200,0,50,8,232,7,208,227,63,33,0,32,70,0,80,9,224,32,78,
0,2,128,255,130,31,224,81,154,69,29,56,0,50,32,70,0,2,191,255,
50,130,224,81,154,61,10,16,220,17,130,119,1,0,65,82,174,118,255,0,
66,119,0,0,10,6,0,254,214,245,29,48,28,56,32,70,0,2,35,78,
4,0,191,255,66,231,224,81,178,37,35,23,5,0,25,48,2,88,2,64,
221,17,130,135,1,0,220,89,139,79,1,0,59,6,100,93,133,0,99,135,
1,0,27,56,128,255,252,97,35,23,5,0,2,56,2,120,220,121,221,17,
143,71,1,0,130,79,1,0,27,48,129,255,8,232,32,86,104,48,58,95,
1,0,65,90,122,95,1,0,68,6,255,112,130,7,225,48,6,232,61,223,
8,0,224,217,154,45,181,37,61,215,13,0,27,224,193,226,253,127,45,0,
61,55,25,0,61,71,17,0,61,79,21,0,99,127,1,0,220,209,61,62,
28,0,191,255,30,255,61,111,13,0,122,87,0,0,205,225,60,103,0,0,
224,97,226,5,61,95,33,0,65,90,125,95,33,0,65,218,61,87,37,0,
234,217,182,221,229,5,61,143,33,0,65,138,125,143,33,0,36,135,121,136,
38,6,164,93,133,0,16,62,1,0,100,63,121,136,129,255,120,231,61,127,
33,0,0,82,224,121,178,5,32,86,19,48,66,6,255,48,128,7,225,0,
6,232,7,224,224,233,146,13,0,58,191,255,152,232,129,226,201,5,29,48,
129,255,92,211,64,6,255,0,0,18,2,136,198,137,2,126,1,0,81,127,
0,0,65,18,2,6,0,254,246,245,127,0,128,7,225,48,6,232,7,224,
8,216,9,208,224,233,138,13,32,54,52,0,129,255,166,209,10,232,224,233,
242,69,29,48,28,56,27,64,26,72,191,255,148,233,49,6,164,52,134,0,
125,143,49,0,38,6,184,93,133,0,129,255,240,230,253,63,45,0,38,6,
204,93,133,0,129,255,226,230,61,55,21,0,191,255,152,255,61,63,21,0,
32,70,0,2,0,50,191,255,66,110,125,87,8,0,234,0,224,81,138,37,
61,55,17,0,32,62,255,0,191,255,150,229,61,63,17,0,32,70,0,2,
32,54,0,2,191,255,28,110,125,87,8,0,234,0,224,81,218,13,253,63,
45,0,32,54,0,2,32,70,0,80,32,78,0,2,128,255,138,29,125,87,
8,0,29,80,64,6,255,48,130,7,225,16,7,224,8,216,99,7,2,0,
35,54,2,0,128,255,178,133,227,63,3,0,10,232,38,6,220,93,133,0,
129,255,90,230,227,135,3,0,60,127,1,0,29,80,123,135,10,0,65,122,
124,127,1,0,66,6,255,16,128,7,225,48,6,232,61,223,8,0,224,217,
186,37,213,29,27,224,61,215,13,0,61,71,5,0,61,55,25,0,193,226,
220,209,61,62,28,0,191,255,158,255,61,119,13,0,122,87,0,0,206,225,
60,111,0,0,224,105,226,5,61,103,33,0,65,98,125,103,33,0,65,218,
61,95,37,0,235,217,150,229,229,5,61,87,33,0,65,82,125,87,33,0,
36,143,121,136,38,6,244,93,133,0,17,62,1,0,100,63,121,136,129,255,
208,229,61,135,33,0,0,82,224,129,178,5,32,86,19,48,64,6,255,48,
128,7,225,0,6,232,7,224,224,233,146,13,0,58,191,255,240,230,129,226,
201,5,29,48,129,255,180,209,64,6,255,0,128,7,225,48,6,232,7,224,
8,216,9,208,224,233,138,13,32,54,52,0,129,255,22,208,10,232,224,233,
146,21,29,48,28,56,27,64,26,72,191,255,4,232,49,6,252,51,134,0,
125,143,49,0,38,6,8,94,133,0,129,255,96,229,29,80,64,6,255,48,
130,7,33,0,99,7,1,0,3,72,191,255,66,228,66,6,63,0,128,7,
225,112,9,216,219,0,35,207,25,0,6,232,7,208,8,224,32,70,0,2,
191,255,164,108,224,81,234,45,29,48,27,56,25,64,32,78,0,2,128,255,
30,28,224,81,218,37,28,48,32,62,238,0,191,255,238,227,29,48,28,56,
32,70,0,2,191,255,120,108,224,81,138,29,29,48,27,56,25,64,32,78,
0,2,128,255,250,27,224,81,250,13,29,48,28,56,32,70,0,2,191,255,
154,126,224,81,250,5,26,48,28,56,32,70,0,2,191,255,122,255,64,6,
255,112,0,18,2,136,198,137,32,134,165,0,81,135,0,0,65,18,2,6,
0,254,246,245,127,0,130,7,225,112,7,208,227,231,29,0,8,232,9,216,
6,200,28,48,128,255,174,28,224,81,138,21,61,6,40,94,133,0,25,48,
29,56,28,64,128,255,100,94,29,48,28,56,129,255,130,228,32,86,105,48,
213,45,29,48,0,58,191,255,84,227,29,56,27,64,28,72,32,110,0,80,
99,111,1,0,0,50,191,255,28,255,224,81,218,29,29,48,191,255,20,253,
29,56,27,64,28,72,32,86,0,80,99,87,1,0,0,50,191,255,254,254,
224,81,234,13,29,48,191,255,112,255,29,56,27,64,28,72,32,126,0,80,
99,127,1,0,0,50,191,255,224,254,58,119,1,0,65,114,122,119,1,0,
66,6,255,112,130,7,225,48,6,232,61,223,8,0,224,217,154,45,181,37,
61,215,13,0,27,224,193,226,253,127,45,0,61,55,25,0,61,71,17,0,
61,79,21,0,99,127,1,0,220,209,61,62,28,0,191,255,48,255,61,111,
13,0,122,87,0,0,205,225,60,103,0,0,224,97,226,5,61,95,33,0,
65,90,125,95,33,0,65,218,61,87,37,0,234,217,182,221,229,5,61,143,
33,0,65,138,125,143,33,0,36,135,121,136,38,6,64,94,133,0,16,62,
1,0,100,63,121,136,129,255,152,227,61,127,33,0,0,82,224,121,178,5,
32,86,19,48,66,6,255,48,128,7,225,0,6,232,7,224,224,233,146,13,
0,58,191,255,184,228,129,226,201,5,29,48,129,255,124,207,64,6,255,0,
128,7,225,48,6,232,7,224,8,216,9,208,224,233,138,13,32,54,52,0,
129,255,222,205,10,232,224,233,130,29,29,48,28,56,27,64,26,72,191,255,
204,229,49,6,228,51,134,0,125,143,49,0,38,6,84,94,133,0,129,255,
40,227,253,63,45,0,38,6,116,94,133,0,129,255,26,227,29,80,64,6,
255,48,128,7,225,240,9,208,218,0,35,199,29,0,6,232,7,200,8,216,
32,70,0,2,191,255,112,106,224,81,234,53,29,48,26,56,24,64,32,78,
0,2,128,255,250,25,224,81,218,45,10,224,133,45,27,48,32,62,238,0,
191,255,182,225,29,48,27,56,32,70,0,2,191,255,64,106,224,81,234,29,
29,48,28,56,24,64,32,78,0,2,128,255,194,25,224,81,218,21,29,48,
27,56,32,70,0,2,191,255,98,124,224,81,218,13,25,48,27,56,32,70,
0,2,191,255,66,253,224,81,218,5,65,226,250,225,134,221,0,82,64,6,
255,240,130,7,225,240,6,192,7,200,8,232,9,208,227,231,33,0,0,218,
229,21,27,48,128,255,126,26,224,81,138,21,61,6,132,94,133,0,24,48,
29,56,28,64,128,255,52,92,29,48,28,56,129,255,82,226,32,86,105,48,
197,45,65,218,252,217,166,237,29,48,0,58,191,255,30,225,29,56,26,64,
28,72,32,110,0,80,99,111,1,0,0,50,191,255,26,255,29,48,191,255,
226,250,29,56,26,64,28,72,32,94,0,80,99,95,1,0,0,50,191,255,
0,255,29,48,191,255,66,253,29,56,26,64,28,72,32,142,0,80,99,143,
1,0,0,50,191,255,230,254,57,135,1,0,65,130,121,135,1,0,66,6,
255,240,130,7,225,48,6,232,61,223,8,0,224,217,154,45,181,37,61,215,
13,0,27,224,193,226,253,127,45,0,61,55,25,0,61,71,17,0,61,79,
21,0,99,127,1,0,220,209,61,62,28,0,191,255,46,255,61,111,13,0,
122,87,0,0,205,225,60,103,0,0,224,97,226,5,61,95,33,0,65,90,
125,95,33,0,65,218,61,87,37,0,234,217,182,221,229,5,61,143,33,0,
65,138,125,143,33,0,36,135,121,136,38,6,188,94,133,0,16,62,1,0,
100,63,121,136,129,255,106,225,61,127,33,0,0,82,224,121,178,5,32,86,
19,48,66,6,255,48,128,7,225,0,6,232,7,224,224,233,146,13,0,58,
191,255,138,226,129,226,201,5,29,48,129,255,78,205,64,6,255,0,128,7,
225,48,6,232,7,224,8,216,9,208,224,233,138,13,32,54,52,0,129,255,
176,203,10,232,224,233,130,29,29,48,28,56,27,64,26,72,191,255,158,227,
49,6,204,51,134,0,125,143,49,0,38,6,240,94,133,0,129,255,250,224,
253,63,45,0,38,6,208,94,133,0,129,255,236,224,29,80,64,6,255,48,
39,143,1,0,0,82,65,138,103,143,1,0,127,0,128,7,225,48,6,232,
61,223,8,0,224,217,154,37,181,29,61,215,13,0,27,224,193,226,61,55,
25,0,61,62,28,0,220,209,191,255,208,255,61,119,13,0,122,87,0,0,
206,225,60,111,0,0,224,105,226,5,61,103,33,0,65,98,125,103,33,0,
65,218,61,95,37,0,235,217,182,229,229,5,61,87,33,0,65,82,125,87,
33,0,36,143,121,136,38,6,16,95,133,0,17,62,1,0,100,63,121,136,
129,255,106,224,61,135,33,0,0,82,224,129,178,5,32,86,19,48,64,6,
255,48,128,7,225,0,6,232,7,224,224,233,146,13,0,58,191,255,138,225,
129,226,201,5,29,48,129,255,78,204,64,6,255,0,128,7,225,48,6,232,
7,224,8,216,9,208,224,233,138,13,32,54,52,0,129,255,176,202,10,232,
224,233,146,21,29,48,28,56,27,64,26,72,191,255,158,226,49,6,180,51,
134,0,125,143,49,0,38,6,36,95,133,0,129,255,250,223,29,80,64,6,
255,48,132,7,225,112,7,208,154,0,9,216,35,207,33,0,8,232,6,224,
29,48,156,0,28,56,191,255,184,222,27,48,28,56,191,255,176,222,29,56,
0,50,32,70,0,1,191,255,58,103,224,81,234,13,29,48,26,56,191,255,
152,222,29,56,32,54,0,2,32,70,0,1,191,255,32,103,224,81,226,13,
61,6,76,95,133,0,25,48,29,56,128,255,114,89,29,48,129,255,146,223,
32,86,39,48,133,69,29,56,0,50,8,66,191,255,60,121,224,81,226,13,
61,6,100,95,133,0,25,48,29,56,128,255,74,89,29,48,129,255,106,223,
32,86,39,48,197,45,29,48,27,56,8,66,35,78,4,0,191,255,76,222,
224,81,178,37,35,23,5,0,25,48,2,80,2,64,219,17,130,127,1,0,
221,81,138,79,1,0,60,6,124,95,133,0,99,127,1,0,28,56,128,255,
6,89,35,23,5,0,2,56,2,112,221,113,219,17,142,71,1,0,130,79,
1,0,28,48,129,255,18,223,32,86,37,48,68,6,255,112,1,114,0,122,
0,18,2,128,195,130,198,129,112,119,1,0,112,127,5,0,193,122,14,72,
159,74,9,121,193,114,14,96,15,97,186,5,1,114,0,122,65,18,2,6,
192,255,201,237,127,0,128,7,193,0,6,232,253,23,1,0,64,110,1,0,
1,122,2,54,3,0,6,80,224,87,34,82,230,111,32,2,2,54,2,0,
230,127,32,2,202,105,6,80,224,87,34,82,202,121,0,102,0,0,225,95,
0,0,207,89,203,105,2,80,208,82,74,86,1,0,10,120,191,122,204,81,
225,95,0,0,207,89,203,105,194,81,225,95,0,0,205,89,2,134,4,0,
125,135,0,0,64,6,223,0,131,58,195,58,198,57,103,71,1,0,103,79,
5,0,127,0,131,58,195,58,198,57,39,95,5,0,39,87,1,0,127,0,
142,7,225,243,6,176,99,63,25,0,99,71,21,0,0,226,32,134,17,0,
99,135,18,0,32,238,0,1,245,37,22,48,0,58,191,255,12,221,35,54,
18,0,191,255,80,255,22,48,10,64,11,72,0,58,191,255,170,255,29,48,
22,56,32,70,0,1,191,255,130,101,10,224,224,225,242,13,35,55,21,0,
61,6,12,96,133,0,29,56,128,255,208,87,29,48,129,255,240,221,32,230,
39,48,245,117,193,234,35,143,25,0,241,233,241,213,32,118,17,0,99,119,
18,0,32,238,0,1,32,190,0,1,213,101,23,48,22,56,32,70,32,0,
191,255,124,119,10,224,224,225,242,13,35,55,21,0,61,6,36,96,133,0,
29,56,128,255,134,87,29,48,129,255,166,221,32,230,39,48,165,85,22,48,
0,58,191,255,58,255,10,208,11,216,253,185,186,45,35,54,18,0,191,255,
180,254,10,192,11,200,249,217,186,5,248,209,242,29,60,6,204,95,133,0,
35,55,21,0,28,56,29,64,99,199,1,0,99,207,5,0,99,215,9,0,
99,223,13,0,128,255,52,87,28,48,29,56,24,64,25,72,99,215,1,0,
99,223,5,0,129,255,70,221,32,230,38,48,165,37,193,234,165,29,26,112,
27,113,242,21,60,6,60,96,133,0,35,55,21,0,28,56,29,64,99,215,
1,0,99,223,5,0,128,255,246,86,28,48,29,56,26,64,27,72,129,255,
16,221,32,230,38,48,245,5,23,190,0,1,35,143,25,0,241,185,145,157,
28,80,78,6,255,243,132,7,225,241,6,224,7,184,9,216,36,23,77,142,
8,192,35,215,41,0,35,207,45,0,120,23,1,0,224,17,128,255,240,19,
36,55,77,142,191,255,74,102,10,232,224,233,146,21,128,255,230,19,61,6,
140,96,133,0,28,48,29,56,128,255,144,86,29,48,129,255,176,220,32,238,
39,48,128,7,122,1,217,134,1,0,210,29,27,64,26,72,99,231,1,0,
32,54,85,0,32,62,170,0,191,255,158,252,10,232,224,233,178,5,128,7,
8,1,27,64,26,72,99,231,1,0,32,54,170,0,32,62,85,0,191,255,
128,252,10,232,224,233,234,117,217,110,2,0,242,101,27,48,191,255,88,253,
26,48,32,62,238,0,191,255,52,219,27,56,0,50,32,70,0,2,191,255,
190,99,224,81,130,21,128,255,98,19,61,6,164,96,133,0,28,48,29,56,
128,255,12,86,29,48,129,255,44,220,32,238,39,48,181,125,26,56,0,50,
32,70,0,2,191,255,212,117,224,81,130,21,128,255,52,19,61,6,188,96,
133,0,28,48,29,56,128,255,222,85,29,48,129,255,254,219,32,238,39,48,
197,101,27,48,26,56,32,70,0,2,35,78,4,0,191,255,222,218,10,232,
224,81,226,37,128,255,0,19,35,23,5,0,28,48,2,136,2,64,218,17,
130,119,1,0,219,137,145,79,1,0,61,6,212,96,133,0,99,119,1,0,
29,56,128,255,146,85,35,23,5,0,2,56,2,104,219,105,218,17,141,71,
1,0,130,79,1,0,29,48,129,255,158,219,32,238,36,48,197,53,217,142,
4,0,210,13,56,63,1,0,28,64,27,48,191,255,56,253,10,232,224,233,
194,5,128,255,158,18,213,37,132,202,185,37,36,55,77,142,191,255,234,100,
224,81,202,13,128,255,136,18,64,54,137,0,38,55,17,222,191,255,214,100,
10,232,224,233,226,13,61,6,140,96,133,0,28,48,29,56,128,255,32,85,
29,48,129,255,64,219,32,238,39,48,213,5,128,255,96,18,120,87,1,0,
55,103,1,0,29,80,65,98,119,103,1,0,68,6,255,241,132,7,225,112,
6,232,61,223,8,0,7,200,224,217,186,45,213,37,61,215,13,0,27,224,
193,226,61,127,21,0,220,209,61,62,28,0,61,55,25,0,61,79,17,0,
99,127,1,0,99,207,5,0,36,70,116,136,191,255,242,253,61,111,13,0,
122,87,0,0,205,225,60,103,0,0,224,97,226,5,61,95,33,0,65,90,
125,95,33,0,65,218,61,87,37,0,234,217,150,221,229,5,61,143,33,0,
65,138,125,143,33,0,36,135,121,136,38,6,36,97,133,0,16,62,1,0,
100,63,121,136,129,255,158,218,61,127,33,0,0,82,224,121,178,5,32,86,
19,48,68,6,255,112,132,7,225,48,6,232,61,223,8,0,224,217,202,45,
229,37,61,215,13,0,27,224,193,226,61,127,21,0,220,209,61,62,28,0,
61,55,25,0,61,79,17,0,99,127,1,0,31,114,99,119,5,0,36,70,
116,136,191,255,92,253,61,103,13,0,122,87,0,0,204,225,60,95,0,0,
224,89,226,5,61,87,33,0,65,82,125,87,33,0,65,218,61,143,37,0,
241,217,134,221,229,5,61,135,33,0,65,130,125,135,33,0,36,127,121,136,
38,6,56,97,133,0,15,62,1,0,100,63,121,136,129,255,8,218,61,119,
33,0,0,82,224,113,178,5,32,86,19,48,68,6,255,48,128,7,225,0,
6,232,7,224,224,233,146,13,0,58,191,255,40,219,129,226,201,5,29,48,
129,255,236,197,64,6,255,0,128,7,225,48,6,232,7,224,8,216,9,208,
224,233,138,13,32,54,52,0,129,255,78,196,10,232,224,233,146,21,29,48,
28,56,27,64,26,72,191,255,60,220,49,6,156,51,134,0,125,143,49,0,
38,6,76,97,133,0,129,255,152,217,29,80,64,6,255,48,128,7,97,0,
6,232,224,233,138,13,32,54,52,0,129,255,16,196,10,232,224,233,146,13,
29,48,191,255,242,220,49,6,156,51,134,0,125,143,49,0,29,80,64,6,
127,0,128,7,225,48,8,224,9,216,219,0,6,232,7,208,32,70,0,2,
191,255,196,96,224,81,202,45,29,48,27,56,32,70,0,2,128,255,112,16,
224,81,202,37,28,48,32,62,238,0,191,255,16,216,29,48,28,56,32,70,
0,2,191,255,154,96,224,81,250,21,29,48,27,56,32,70,0,2,128,255,
78,16,224,81,250,13,29,48,28,56,32,70,0,2,191,255,190,114,224,81,
250,5,26,48,28,56,32,70,0,2,191,255,158,243,64,6,255,48,128,7,
225,48,9,224,227,223,21,0,8,232,29,48,7,208,0,58,191,255,186,215,
29,56,28,64,27,72,0,50,191,255,110,255,224,81,218,21,29,48,191,255,
130,241,29,56,28,64,27,72,0,50,191,255,88,255,224,81,170,13,29,48,
191,255,230,243,29,56,28,64,27,72,0,50,191,255,66,255,58,103,1,0,
65,98,122,103,1,0,64,6,255,48,130,7,225,48,6,232,61,223,8,0,
224,217,154,45,181,37,61,215,13,0,27,224,193,226,253,127,45,0,61,55,
25,0,61,71,17,0,61,79,21,0,99,127,1,0,220,209,61,62,28,0,
191,255,114,255,61,111,13,0,122,87,0,0,205,225,60,103,0,0,224,97,
226,5,61,95,33,0,65,90,125,95,33,0,65,218,61,87,37,0,234,217,
182,221,229,5,61,143,33,0,65,138,125,143,33,0,36,135,121,136,38,6,
100,97,133,0,16,62,1,0,100,63,121,136,129,255,22,216,61,127,33,0,
0,82,224,121,178,5,32,86,19,48,66,6,255,48,128,7,225,0,6,232,
7,224,224,233,146,13,0,58,191,255,54,217,129,226,201,5,29,48,129,255,
250,195,64,6,255,0,128,7,225,48,6,232,7,224,8,216,9,208,224,233,
138,13,32,54,52,0,129,255,92,194,10,232,224,233,130,29,29,48,28,56,
27,64,26,72,191,255,74,218,49,6,132,51,134,0,125,143,49,0,38,6,
120,97,133,0,129,255,166,215,253,63,45,0,38,6,164,97,133,0,129,255,
152,215,29,80,64,6,255,48,102,63,1,0,127,0,38,87,1,0,127,0,
132,7,225,243,6,208,7,184,99,71,5,0,9,224,35,239,45,0,35,183,
49,0,0,202,0,218,149,85,29,48,26,56,191,255,212,255,29,48,191,255,
212,255,10,192,250,193,210,21,60,6,244,97,133,0,22,48,28,56,29,64,
26,72,99,199,1,0,128,255,26,81,28,48,29,56,26,64,24,72,129,255,
52,215,32,206,100,48,213,53,35,151,53,0,27,128,194,130,210,129,48,111,
1,0,0,18,125,111,1,0,149,37,35,151,53,0,2,96,194,98,60,135,
1,0,210,97,44,143,1,0,241,129,178,21,22,48,29,64,28,72,39,6,
48,98,133,0,128,255,204,80,29,56,28,64,38,6,180,97,133,0,129,255,
228,214,32,206,101,48,213,13,92,230,1,0,65,18,247,17,246,221,35,231,
5,0,93,238,1,0,65,218,247,217,246,173,25,80,68,6,255,243,134,7,
225,243,35,223,57,0,7,176,35,207,53,0,6,184,27,192,27,232,25,48,
194,50,129,255,214,194,10,208,0,18,181,13,61,95,1,0,2,112,194,114,
218,113,110,95,1,0,93,238,1,0,65,18,249,17,214,245,27,232,25,56,
27,64,29,72,99,199,1,0,99,191,5,0,99,215,9,0,0,50,191,255,
234,254,10,224,224,225,250,45,25,56,27,64,29,72,99,199,1,0,99,191,
5,0,99,215,9,0,128,54,255,255,191,255,202,254,10,224,224,225,250,29,
25,56,27,64,29,72,99,199,1,0,99,191,5,0,99,215,9,0,32,54,
85,85,191,255,170,254,10,224,224,225,250,13,25,56,27,64,29,72,99,199,
1,0,99,191,5,0,99,215,9,0,128,54,170,170,191,255,138,254,10,224,
26,48,129,255,82,194,54,111,1,0,28,80,65,106,118,111,1,0,70,6,
255,243,134,7,225,48,6,232,61,223,8,0,224,217,154,53,181,45,61,215,
13,0,61,127,61,0,61,55,25,0,61,71,53,0,61,79,57,0,99,127,
1,0,61,119,65,0,27,224,193,226,99,119,5,0,61,111,69,0,61,62,
28,0,220,209,99,111,9,0,191,255,242,254,61,95,13,0,122,87,0,0,
203,225,60,87,0,0,224,81,226,5,61,143,33,0,65,138,125,143,33,0,
65,218,61,135,37,0,240,217,182,213,229,5,61,127,33,0,65,122,125,127,
33,0,36,119,121,136,38,6,116,98,133,0,14,62,1,0,100,63,121,136,
129,255,102,213,61,111,33,0,0,82,224,105,178,5,32,86,19,48,70,6,
255,48,128,7,225,0,6,232,7,224,224,233,146,13,0,58,191,255,134,214,
129,226,201,5,29,48,129,255,74,193,64,6,255,0,130,7,225,48,6,232,
7,224,8,216,9,208,224,233,138,13,32,54,72,0,129,255,172,191,10,232,
224,233,210,45,29,48,28,56,27,64,26,72,191,255,154,215,49,6,108,51,
134,0,125,143,49,0,38,6,136,98,133,0,129,255,246,212,39,6,0,0,
128,0,125,63,53,0,64,134,0,1,48,70,0,0,125,71,57,0,8,72,
167,73,125,79,61,0,125,63,69,0,9,96,144,98,125,103,65,0,99,103,
1,0,38,6,152,98,133,0,129,255,190,212,29,80,66,6,255,48,132,7,
225,112,6,200,7,208,8,232,9,224,29,48,191,255,100,237,32,22,0,1,
2,136,221,137,32,134,238,0,81,135,0,0,65,18,2,6,0,254,246,245,
29,48,32,62,0,1,128,255,198,11,28,48,32,62,238,0,191,255,90,211,
28,48,32,62,0,1,128,255,186,11,29,48,28,56,32,70,0,2,35,78,
4,0,191,255,86,211,224,81,178,37,35,23,5,0,25,48,2,112,2,64,
220,17,130,95,1,0,221,113,142,79,1,0,59,6,232,98,133,0,99,95,
1,0,27,56,128,255,16,78,35,23,5,0,2,56,2,80,221,81,220,17,
138,71,1,0,130,79,1,0,27,48,129,255,28,212,32,86,103,48,58,119,
1,0,65,114,122,119,1,0,68,6,255,112,128,7,225,48,6,232,61,223,
8,0,224,217,218,37,245,29,27,224,61,215,13,0,61,79,21,0,61,71,
17,0,61,55,25,0,193,226,220,209,61,62,28,0,191,255,40,255,61,119,
13,0,122,87,0,0,206,225,60,111,0,0,224,105,226,5,61,103,33,0,
65,98,125,103,33,0,65,218,61,95,37,0,235,217,246,221,229,5,61,87,
33,0,65,82,125,87,33,0,36,143,121,136,38,6,44,99,133,0,17,62,
1,0,100,63,121,136,129,255,148,211,61,135,33,0,0,82,224,129,178,5,
32,86,19,48,64,6,255,48,128,7,225,0,6,232,7,224,224,233,146,13,
0,58,191,255,180,212,129,226,201,5,29,48,129,255,120,191,64,6,255,0,
128,7,225,48,6,232,7,224,8,216,9,208,224,233,138,13,32,54,52,0,
129,255,218,189,10,232,224,233,130,45,29,48,28,56,27,64,26,72,191,255,
200,213,49,6,84,51,134,0,125,143,49,0,38,6,64,99,133,0,129,255,
36,211,61,55,17,0,191,255,218,235,32,22,0,1,61,135,17,0,32,118,
238,0,194,129,80,119,0,0,65,18,2,6,0,254,230,245,61,55,17,0,
32,62,0,1,128,255,56,10,29,80,64,6,255,48,130,7,225,112,9,216,
219,0,35,207,29,0,6,232,8,224,7,208,26,64,0,58,32,134,129,0,
99,135,1,0,32,78,0,2,128,255,156,9,224,81,138,61,29,48,27,56,
25,64,32,78,0,2,128,255,10,10,224,81,250,45,28,48,32,62,238,0,
191,255,138,209,29,48,0,58,28,64,32,102,129,0,99,103,1,0,32,78,
0,2,128,255,102,9,224,81,218,29,29,48,27,56,25,64,32,78,0,2,
128,255,220,9,224,81,202,21,29,48,0,58,28,64,32,126,36,0,99,127,
1,0,32,78,0,2,128,255,58,9,224,81,250,5,26,48,28,56,32,70,
0,2,191,255,2,237,66,6,255,112,130,7,225,112,9,224,35,223,29,0,
227,215,33,0,8,232,29,48,7,200,0,58,191,255,26,209,27,48,29,56,
28,64,26,72,32,134,0,80,99,135,1,0,191,255,58,255,224,81,218,29,
29,48,191,255,218,234,27,48,29,56,28,64,26,72,32,110,0,80,99,111,
1,0,191,255,28,255,224,81,234,13,29,48,191,255,54,237,27,48,29,56,
28,64,26,72,32,86,0,80,99,87,1,0,191,255,254,254,57,143,1,0,
65,138,121,143,1,0,66,6,255,112,132,7,225,48,6,232,61,223,8,0,
224,217,218,45,245,37,27,224,61,215,13,0,61,127,41,0,61,55,25,0,
61,71,17,0,61,79,21,0,99,127,1,0,253,119,45,0,193,226,220,209,
61,62,28,0,99,119,5,0,191,255,78,255,61,103,13,0,122,87,0,0,
204,225,60,95,0,0,224,89,226,5,61,87,33,0,65,82,125,87,33,0,
65,218,61,143,37,0,241,217,246,213,229,5,61,135,33,0,65,130,125,135,
33,0,36,127,121,136,38,6,108,99,133,0,15,62,1,0,100,63,121,136,
129,255,86,209,61,119,33,0,0,82,224,113,178,5,32,86,19,48,68,6,
255,48,128,7,225,0,6,232,7,224,224,233,146,13,0,58,191,255,118,210,
129,226,201,5,29,48,129,255,58,189,64,6,255,0,128,7,225,48,6,232,
7,224,8,216,9,208,224,233,138,13,32,54,52,0,129,255,156,187,10,232,
224,233,130,29,29,48,28,56,27,64,26,72,191,255,138,211,49,6,60,51,
134,0,125,143,49,0,38,6,128,99,133,0,129,255,230,208,253,63,45,0,
38,6,176,99,133,0,129,255,216,208,29,80,64,6,255,48,39,143,1,0,
0,82,65,138,103,143,1,0,127,0,128,7,225,48,6,232,61,223,8,0,
224,217,154,37,181,29,61,215,13,0,27,224,193,226,61,55,25,0,61,62,
28,0,220,209,191,255,208,255,61,119,13,0,122,87,0,0,206,225,60,111,
0,0,224,105,226,5,61,103,33,0,65,98,125,103,33,0,65,218,61,95,
37,0,235,217,182,229,229,5,61,87,33,0,65,82,125,87,33,0,36,143,
121,136,38,6,192,99,133,0,17,62,1,0,100,63,121,136,129,255,86,208,
61,135,33,0,0,82,224,129,178,5,32,86,19,48,64,6,255,48,128,7,
225,0,6,232,7,224,224,233,146,13,0,58,191,255,118,209,129,226,201,5,
29,48,129,255,58,188,64,6,255,0,128,7,225,48,6,232,7,224,8,216,
9,208,224,233,138,13,32,54,52,0,129,255,156,186,10,232,224,233,146,21,
29,48,28,56,27,64,26,72,191,255,138,210,49,6,36,51,134,0,125,143,
49,0,38,6,212,99,133,0,129,255,230,207,29,80,64,6,255,48,128,7,
225,48,8,216,35,215,21,0,9,232,29,48,7,224,0,58,191,255,170,206,
29,56,0,50,32,70,0,2,191,255,52,87,224,81,250,21,26,48,0,58,
32,70,0,2,128,255,16,7,224,81,250,13,29,56,0,50,32,70,0,2,
191,255,88,105,224,81,250,5,27,48,29,56,32,70,0,2,191,255,56,234,
60,119,1,0,65,114,124,119,1,0,64,6,255,48,130,7,225,48,6,232,
61,223,8,0,224,217,154,45,181,37,61,215,13,0,27,224,193,226,61,127,
41,0,61,55,25,0,61,71,17,0,61,79,21,0,99,127,1,0,220,209,
61,62,28,0,191,255,110,255,61,111,13,0,122,87,0,0,205,225,60,103,
0,0,224,97,226,5,61,95,33,0,65,90,125,95,33,0,65,218,61,87,
37,0,234,217,182,221,229,5,61,143,33,0,65,138,125,143,33,0,36,135,
121,136,38,6,224,99,133,0,16,62,1,0,100,63,121,136,129,255,2,207,
61,127,33,0,0,82,224,121,178,5,32,86,19,48,66,6,255,48,128,7,
225,0,6,232,7,224,224,233,146,13,0,58,191,255,34,208,129,226,201,5,
29,48,129,255,230,186,64,6,255,0,130,7,225,48,6,232,7,224,8,216,
9,208,224,233,138,13,32,54,52,0,129,255,72,185,10,232,224,233,194,37,
29,48,28,56,27,64,26,72,191,255,54,209,48,6,12,51,134,0,125,135,
49,0,38,6,244,99,133,0,129,255,146,206,61,55,17,0,191,255,72,231,
0,58,61,55,41,0,61,71,17,0,32,118,129,0,99,119,1,0,32,78,
0,2,128,255,66,5,125,87,8,0,29,80,66,6,255,48,130,7,225,48,
8,208,35,231,25,0,9,232,29,48,7,216,0,58,191,255,48,205,28,48,
0,58,29,64,32,134,129,0,99,135,1,0,32,78,0,2,128,255,12,5,
224,81,202,29,28,48,0,58,32,70,0,2,128,255,148,5,224,81,202,21,
28,48,0,58,29,64,32,110,36,0,99,111,1,0,32,78,0,2,128,255,
226,4,224,81,250,5,26,48,29,56,32,70,0,2,191,255,170,232,59,95,
1,0,65,90,123,95,1,0,66,6,255,48,130,7,225,48,6,232,61,223,
8,0,224,217,154,45,181,37,61,215,13,0,27,224,193,226,61,127,41,0,
61,55,25,0,61,71,17,0,61,79,21,0,99,127,1,0,220,209,61,62,
28,0,191,255,90,255,61,111,13,0,122,87,0,0,205,225,60,103,0,0,
224,97,226,5,61,95,33,0,65,90,125,95,33,0,65,218,61,87,37,0,
234,217,182,221,229,5,61,143,33,0,65,138,125,143,33,0,36,135,121,136,
38,6,28,100,133,0,16,62,1,0,100,63,121,136,129,255,116,205,61,127,
33,0,0,82,224,121,178,5,32,86,19,48,66,6,255,48,128,7,225,0,
6,232,7,224,224,233,146,13,0,58,191,255,148,206,129,226,201,5,29,48,
129,255,88,185,64,6,255,0,128,7,225,48,6,232,7,224,8,216,9,208,
224,233,138,13,32,54,52,0,129,255,186,183,10,232,224,233,226,29,29,48,
28,56,27,64,26,72,191,255,168,207,49,6,244,50,134,0,125,143,49,0,
38,6,48,100,133,0,129,255,4,205,61,55,17,0,191,255,186,229,61,63,
17,0,32,70,0,2,0,50,191,255,100,84,125,87,8,0,29,80,64,6,
255,48,130,7,225,48,8,208,35,231,25,0,9,232,29,48,7,216,32,62,
238,0,191,255,172,203,28,48,0,58,29,64,32,134,129,0,99,135,1,0,
32,78,0,2,128,255,136,3,10,16,224,17,202,37,28,48,0,58,26,64,
32,118,129,0,99,119,1,0,32,78,0,2,128,255,108,3,10,16,224,17,
234,21,28,48,0,58,29,64,32,102,36,0,99,103,1,0,32,78,0,2,
128,255,80,3,10,16,224,17,138,13,26,48,29,56,32,70,0,2,191,255,
22,231,10,16,59,87,1,0,65,82,123,87,1,0,2,80,66,6,255,48,
130,7,225,48,6,232,61,223,8,0,224,217,154,45,181,37,61,215,13,0,
27,224,193,226,61,127,41,0,61,55,25,0,61,71,17,0,61,79,21,0,
99,127,1,0,220,209,61,62,28,0,191,255,68,255,61,111,13,0,122,87,
0,0,205,225,60,103,0,0,224,97,226,5,61,95,33,0,65,90,125,95,
33,0,65,218,61,87,37,0,234,217,182,221,229,5,61,143,33,0,65,138,
125,143,33,0,36,135,121,136,38,6,88,100,133,0,16,62,1,0,100,63,
121,136,129,255,220,203,61,127,33,0,0,82,224,121,178,5,32,86,19,48,
66,6,255,48,128,7,225,0,6,232,7,224,224,233,146,13,0,58,191,255,
252,204,129,226,201,5,29,48,129,255,192,183,64,6,255,0,128,7,225,48,
6,232,7,224,8,216,9,208,224,233,138,13,32,54,52,0,129,255,34,182,
10,232,224,233,210,21,29,48,28,56,27,64,26,72,191,255,16,206,49,6,
220,50,134,0,125,143,49,0,38,6,108,100,133,0,129,255,108,203,61,55,
17,0,191,255,34,228,29,80,64,6,255,48,128,7,225,112,35,239,25,0,
6,200,35,23,29,0,61,143,1,0,7,216,8,208,9,224,226,137,129,29,
125,7,1,0,64,54,137,0,38,55,17,222,191,255,174,84,224,81,226,13,
61,6,148,100,133,0,25,48,29,56,128,255,250,68,29,48,129,255,26,203,
32,86,39,48,213,45,28,48,32,62,238,0,191,255,234,201,61,55,1,0,
32,70,0,2,28,56,191,255,114,82,224,81,250,29,61,55,1,0,32,70,
0,2,26,56,191,255,96,82,224,81,234,21,61,55,1,0,32,70,0,2,
28,56,191,255,146,100,224,81,218,13,26,48,28,56,32,70,0,2,191,255,
114,229,61,103,1,0,12,102,0,2,125,103,1,0,59,95,1,0,65,90,
123,95,1,0,64,6,255,112,134,7,225,48,6,232,61,223,8,0,99,7,
9,0,224,217,218,45,245,37,27,224,61,215,13,0,61,55,25,0,61,71,
17,0,61,79,21,0,35,126,8,0,99,127,1,0,36,119,117,136,193,226,
220,209,61,62,28,0,99,119,5,0,191,255,18,255,61,103,13,0,122,87,
0,0,204,225,60,95,0,0,224,89,226,5,61,87,33,0,65,82,125,87,
33,0,65,218,61,143,37,0,241,217,246,213,229,5,61,135,33,0,65,130,
125,135,33,0,36,127,121,136,38,6,172,100,133,0,15,62,1,0,100,63,
121,136,129,255,36,202,61,119,33,0,0,82,224,113,178,5,32,86,19,48,
70,6,255,48,128,7,225,0,6,232,7,224,224,233,146,13,0,58,191,255,
68,203,129,226,201,5,29,48,129,255,8,182,64,6,255,0,128,7,225,48,
6,232,7,224,8,216,9,208,224,233,138,13,32,54,52,0,129,255,106,180,
10,232,224,233,130,37,29,48,28,56,27,64,26,72,191,255,88,204,49,6,
196,50,134,0,125,143,49,0,38,6,192,100,133,0,129,255,180,201,64,54,
137,0,38,55,17,222,191,255,36,83,125,87,8,0,234,0,224,81,218,5,
61,55,17,0,191,255,84,226,29,80,64,6,255,48,128,7,33,0,38,6,
232,100,133,0,129,255,130,201,32,86,33,48,64,6,63,0,128,7,225,0,
6,232,7,224,224,233,146,13,0,58,191,255,172,202,129,226,201,5,29,48,
129,255,112,181,64,6,255,0,128,7,225,0,6,232,7,224,224,233,146,13,
0,58,191,255,140,202,129,226,201,5,29,48,129,255,80,181,64,6,255,0,
33,6,166,81,1,0,97,0,33,6,232,67,1,0,97,0,33,6,84,81,
1,0,97,0,33,6,154,81,1,0,97,0,33,6,104,81,1,0,97,0,
33,6,124,81,1,0,97,0,33,6,208,82,1,0,97,0,33,6,60,83,
1,0,97,0,33,6,6,83,1,0,97,0,33,6,224,81,1,0,97,0,
33,6,78,79,1,0,97,0,33,6,124,79,1,0,97,0,33,6,122,37,
0,0,97,0,33,6,172,83,1,0,97,0,33,6,114,83,1,0,97,0,
33,6,186,67,1,0,97,0,33,6,220,67,1,0,97,0,33,6,28,84,
1,0,97,0,33,6,230,83,1,0,97,0,33,6,82,84,1,0,97,0,
33,6,216,84,1,0,97,0,134,0,39,6,8,103,133,0,0,82,34,6,
168,102,133,0,130,143,1,0,230,137,202,5,34,63,5,0,213,5,72,18,
65,82,108,82,230,245,6,64,38,6,24,103,133,0,129,7,96,200,230,134,
96,0,46,6,184,183,141,0,206,129,48,86,65,0,127,0,230,134,96,0,
46,6,184,183,141,0,206,129,112,63,18,0,127,0,230,134,96,0,46,6,
184,183,141,0,206,129,240,87,19,0,127,0,230,134,96,0,46,6,184,183,
141,0,206,129,80,63,23,0,127,0,230,134,96,0,46,6,184,183,141,0,
206,129,144,87,23,0,127,0,230,134,96,0,46,6,184,183,141,0,206,129,
176,87,23,0,127,0,47,6,168,183,141,0,207,49,6,119,0,0,206,110,
129,0,13,6,127,255,226,87,0,0,127,0,230,102,96,0,0,18,47,6,
184,183,141,0,207,97,44,94,24,0,0,82,11,119,0,0,65,90,65,82,
46,17,162,0,10,6,216,255,134,253,71,23,0,0,65,58,44,86,65,0,
0,18,10,111,0,0,65,82,65,18,71,111,0,0,65,58,2,6,236,255,
246,245,7,80,127,0,130,7,225,112,6,208,31,218,229,87,64,0,224,7,
96,1,10,200,0,234,32,230,164,180,0,82,29,6,240,255,177,5,60,87,
5,0,224,81,210,21,42,23,105,0,26,64,2,22,184,0,34,63,0,0,
34,135,5,0,3,48,63,6,192,243,128,0,202,57,112,0,195,199,0,0,
178,5,29,216,245,5,28,230,32,0,65,234,29,6,240,255,246,221,249,47,
32,0,27,80,66,6,255,112,230,134,96,0,46,6,184,183,141,0,206,129,
16,87,21,0,127,0,230,134,96,0,46,6,184,183,141,0,206,129,16,87,
20,0,127,0,128,7,225,48,7,208,8,216,6,224,191,255,210,255,10,232,
28,48,191,255,220,255,29,136,193,138,47,6,104,53,134,0,207,137,17,119,
0,0,90,119,0,0,17,111,1,0,234,105,91,111,0,0,183,5,91,7,
0,0,28,48,191,255,214,254,224,81,250,5,10,232,189,0,90,7,0,0,
91,7,0,0,29,80,64,6,255,48,230,134,96,0,46,6,184,183,141,0,
206,129,80,63,21,0,127,0,230,134,96,0,46,6,184,183,141,0,206,129,
48,87,1,0,127,0,230,134,96,0,46,6,184,183,141,0,206,129,48,103,
1,0,45,6,255,255,255,15,237,97,235,87,0,0,127,0,230,134,96,0,
46,6,184,183,141,0,206,129,48,111,18,0,205,86,4,0,127,0,230,134,
96,0,46,6,184,183,141,0,206,129,48,111,18,0,205,86,2,0,127,0,
230,134,96,0,46,6,184,183,141,0,206,129,48,111,18,0,205,86,1,0,
127,0,230,22,96,0,47,6,184,183,141,0,207,17,226,119,9,0,0,82,
245,113,226,5,226,111,11,0,245,105,162,5,1,82,127,0,230,134,96,0,
46,6,184,183,141,0,206,129,48,111,8,0,205,86,8,0,127,0,130,7,
225,16,6,224,28,56,38,6,208,103,133,0,129,255,226,197,28,232,248,239,
68,2,47,6,184,189,141,0,207,233,29,111,52,0,13,6,217,255,234,5,
37,54,224,132,129,255,194,197,197,13,196,106,42,6,92,109,133,0,202,105,
45,63,5,0,37,54,228,132,129,255,170,197,64,134,142,0,48,142,168,183,
220,137,145,223,1,0,38,6,224,103,133,0,129,255,146,197,27,48,191,255,
254,252,29,119,52,0,14,6,217,255,178,5,128,7,104,1,252,238,96,0,
43,6,184,183,141,0,38,6,36,103,133,0,203,233,61,62,24,0,129,255,
100,197,61,62,65,0,38,6,52,103,133,0,129,255,86,197,61,62,86,0,
38,6,68,103,133,0,129,255,72,197,61,63,1,0,38,6,240,103,133,0,
7,64,129,255,56,197,61,22,8,0,61,143,8,0,34,103,0,0,34,87,
2,0,38,6,176,104,133,0,209,62,1,0,130,98,225,71,0,0,202,126,
0,4,234,79,0,0,138,82,225,103,0,0,99,103,1,0,129,255,2,197,
61,23,12,0,38,6,12,104,133,0,194,110,0,8,234,63,0,0,194,142,
64,0,234,71,0,0,133,18,225,79,0,0,129,255,222,196,61,87,10,0,
138,82,169,13,189,63,23,0,157,71,23,0,38,6,116,103,133,0,129,255,
196,196,61,103,8,0,130,98,233,45,253,231,19,0,38,6,72,104,133,0,
28,56,129,255,172,196,224,225,242,29,39,6,112,104,133,0,220,110,2,0,
178,5,37,62,216,132,40,6,124,104,133,0,220,142,4,0,178,5,37,70,
240,132,37,78,236,132,220,110,24,0,194,5,41,6,136,104,133,0,38,6,
100,104,133,0,129,255,110,196,229,5,38,6,168,103,133,0,129,255,98,196,
253,23,15,0,224,17,178,13,245,17,146,13,136,18,194,62,1,0,38,6,
84,103,133,0,129,255,70,196,29,63,20,0,45,6,76,53,134,0,7,128,
194,130,205,129,48,71,1,0,38,6,152,104,133,0,129,255,40,196,253,63,
17,0,38,6,100,103,133,0,129,255,26,196,66,6,255,16,128,7,225,16,
7,232,29,22,54,0,6,216,251,230,96,0,0,82,41,6,184,183,141,0,
28,88,201,89,43,94,24,0,2,135,0,0,65,18,75,135,1,0,2,127,
0,0,65,18,66,82,75,127,0,0,66,90,10,6,216,255,166,245,28,88,
201,89,75,7,64,0,29,22,20,0,0,82,43,94,65,0,2,119,0,0,
65,18,75,119,1,0,2,111,0,0,65,18,66,82,75,111,0,0,66,90,
10,6,236,255,166,245,28,80,201,81,74,7,85,0,29,22,46,0,0,106,
42,86,86,0,2,103,0,0,65,18,74,103,1,0,2,95,0,0,65,18,
66,106,74,95,0,0,66,82,104,106,182,245,201,225,92,7,94,0,27,48,
191,255,108,18,253,23,123,0,253,87,121,0,61,127,166,0,208,18,10,17,
124,23,5,0,139,122,249,5,253,23,203,0,253,95,201,0,208,18,11,17,
124,23,1,0,27,48,191,255,184,252,224,81,194,5,27,48,191,255,164,16,
253,135,165,0,124,135,8,0,253,127,167,0,124,127,10,0,253,119,169,0,
124,119,12,0,61,111,166,0,0,130,138,106,185,5,253,135,189,0,253,127,
1,1,208,142,255,0,124,127,18,0,253,119,153,0,136,130,124,119,14,0,
61,111,176,0,32,22,255,0,92,135,22,0,92,143,23,0,205,102,127,0,
12,88,203,0,11,6,225,255,225,5,103,90,226,13,111,90,218,37,181,13,
11,6,225,255,162,13,11,6,193,255,146,21,11,6,129,255,162,21,165,29,
2,82,165,5,4,82,92,87,20,0,4,87,232,135,224,81,210,21,32,22,
254,0,165,21,5,138,92,143,20,0,229,13,4,135,232,135,6,82,224,129,
162,5,5,82,92,87,20,0,213,5,92,7,20,0,32,22,254,0,2,80,
64,6,255,16,128,7,225,112,6,200,7,232,157,0,8,224,156,0,229,87,
64,0,224,7,96,1,64,142,142,0,49,222,168,183,217,217,155,127,1,0,
10,208,61,121,136,122,169,29,29,120,136,122,36,103,144,142,185,13,12,118,
1,0,100,119,144,142,224,225,242,13,38,6,8,105,133,0,149,13,95,98,
100,103,144,142,224,225,226,5,38,6,248,104,133,0,129,255,32,194,91,239,
0,0,224,225,162,13,25,56,38,6,24,105,133,0,129,255,12,194,29,48,
191,255,120,249,250,47,32,0,64,6,255,112,128,7,33,0,38,6,184,183,
141,0,0,58,32,70,0,6,191,255,202,8,38,6,168,183,141,0,0,58,
32,70,16,0,191,255,186,8,100,7,144,142,64,6,63,0,166,143,45,0,
224,137,130,37,38,119,1,0,36,103,161,142,1,130,238,135,192,0,76,129,
242,21,4,23,129,136,98,18,174,5,2,18,32,86,232,3,226,87,32,2,
10,130,36,127,245,178,38,119,49,0,80,80,174,121,234,121,215,5,100,7,
161,142,68,7,164,142,127,0,38,135,9,0,36,143,245,178,36,119,125,136,
176,137,14,126,208,7,239,137,235,87,0,0,127,0,128,7,97,0,6,232,
61,55,13,0,38,135,12,0,102,7,0,0,93,7,7,0,125,135,16,0,
191,255,144,75,61,127,16,0,125,7,13,0,32,86,20,0,224,121,178,5,
32,86,36,0,64,6,127,0,128,7,225,0,6,232,191,255,170,255,224,81,
194,5,32,86,35,0,197,61,61,55,1,0,191,255,180,250,224,81,202,5,
32,86,20,0,181,53,61,135,1,0,1,226,240,231,192,0,191,255,44,75,
106,7,9,0,47,6,98,46,1,0,106,127,5,0,46,6,56,193,141,0,
106,119,29,0,106,231,33,0,32,110,232,3,106,111,21,0,202,47,2,0,
202,55,2,0,1,58,10,48,125,87,13,0,191,255,68,85,61,55,1,0,
61,63,13,0,36,71,169,142,32,78,242,0,128,255,92,20,1,98,93,103,
7,0,32,86,33,0,64,6,255,0,128,7,97,0,6,232,61,55,13,0,
38,135,12,0,102,7,0,0,93,7,7,0,125,135,16,0,191,255,204,74,
61,127,16,0,125,7,13,0,11,82,224,121,178,5,32,86,18,0,64,6,
127,0,128,7,225,0,6,232,191,255,232,254,224,81,194,5,32,86,35,0,
181,53,61,135,1,0,1,226,240,231,192,0,191,255,124,74,106,7,9,0,
47,6,98,46,1,0,106,127,5,0,46,6,56,193,141,0,106,119,29,0,
106,231,33,0,32,110,232,3,106,111,21,0,202,47,2,0,202,55,2,0,
1,58,10,48,125,87,13,0,191,255,148,84,61,55,1,0,61,63,13,0,
36,71,169,142,32,78,241,0,128,255,172,19,1,98,93,103,7,0,32,86,
31,0,64,6,255,0,130,7,225,0,6,232,61,55,13,0,38,135,12,0,
102,7,0,0,93,7,7,0,125,135,16,0,191,255,28,74,61,127,16,0,
125,7,13,0,224,121,146,13,38,6,80,107,133,0,129,255,200,191,32,86,
39,0,165,69,32,54,0,2,129,255,236,171,10,224,224,225,154,13,38,6,
108,107,133,0,32,62,111,7,0,66,191,255,102,10,61,119,1,0,32,110,
96,2,238,111,32,2,43,6,88,49,141,0,203,105,45,55,57,0,32,70,
0,2,28,56,191,255,60,89,28,48,125,87,16,0,234,0,224,81,226,5,
129,255,192,171,32,86,28,0,245,21,3,56,128,255,16,19,224,81,218,13,
61,143,1,0,35,23,1,0,241,134,96,0,46,6,184,183,141,0,206,129,
112,23,16,0,28,48,129,255,146,171,32,86,39,0,66,6,255,0,128,7,
225,0,6,232,191,255,172,253,224,81,194,5,32,86,35,0,149,61,61,135,
1,0,1,226,240,231,192,0,191,255,64,73,106,7,9,0,47,6,98,46,
1,0,106,127,5,0,46,6,56,193,141,0,106,119,29,0,106,231,33,0,
32,110,208,7,106,111,21,0,202,47,2,0,202,55,2,0,1,58,10,48,
125,87,13,0,191,255,88,83,61,55,1,0,32,94,96,2,230,95,32,2,
61,63,13,0,49,6,88,49,141,0,209,89,43,71,57,0,128,255,116,18,
1,130,93,135,7,0,32,86,29,0,64,6,255,0,128,7,97,0,6,232,
61,55,13,0,38,135,12,0,102,7,0,0,93,7,7,0,125,135,16,0,
191,255,212,72,61,127,16,0,125,7,13,0,224,121,146,13,38,6,128,107,
133,0,129,255,128,190,32,86,39,0,181,5,32,86,28,0,64,6,127,0,
128,7,225,0,38,143,1,0,241,134,96,0,46,6,184,183,141,0,6,232,
206,129,112,7,16,0,191,255,206,252,224,81,194,5,32,86,35,0,245,45,
61,103,1,0,1,226,236,231,192,0,191,255,98,72,10,48,102,7,9,0,
43,6,98,46,1,0,102,95,5,0,42,6,56,193,141,0,102,87,29,0,
102,231,33,0,32,142,232,3,102,143,21,0,198,47,2,0,198,55,2,0,
1,58,125,55,13,0,191,255,122,82,61,63,13,0,61,55,1,0,128,255,
178,17,1,130,93,135,7,0,32,86,27,0,64,6,255,0,128,7,97,0,
6,232,61,55,13,0,38,135,12,0,102,7,0,0,93,7,7,0,125,135,
16,0,191,255,10,72,61,127,16,0,125,7,13,0,32,86,26,0,224,121,
178,5,32,86,36,0,64,6,127,0,134,7,225,48,6,232,191,255,36,252,
224,81,194,5,32,86,35,0,197,109,61,55,1,0,191,255,132,245,61,55,
1,0,10,216,191,255,140,245,61,135,1,0,10,208,1,226,240,231,192,0,
191,255,164,71,106,7,9,0,47,6,98,46,1,0,106,127,5,0,46,6,
56,193,141,0,106,119,29,0,106,231,33,0,32,110,232,3,106,111,21,0,
10,56,199,47,2,0,4,23,131,136,199,55,2,0,125,87,13,0,97,18,
209,5,242,5,99,18,130,13,149,13,32,230,254,0,245,5,32,230,128,0,
197,5,27,224,165,5,26,224,0,18,27,6,128,255,182,37,250,225,146,37,
32,102,66,0,99,103,0,0,28,16,130,0,99,23,2,0,61,55,1,0,
99,7,5,0,67,7,8,0,32,94,239,0,67,95,9,0,8,82,99,87,
10,0,3,64,0,74,128,255,174,16,61,55,1,0,28,56,135,0,191,255,
186,244,1,18,61,55,13,0,2,56,191,255,74,81,1,122,93,127,7,0,
32,86,25,0,70,6,255,48,128,7,97,0,6,232,61,55,13,0,38,135,
12,0,102,7,0,0,93,7,7,0,125,135,16,0,191,255,230,70,61,127,
16,0,125,7,13,0,32,86,24,0,224,121,178,5,32,86,36,0,64,6,
127,0,134,7,225,0,6,232,191,255,0,251,224,81,194,5,32,86,35,0,
165,69,61,135,1,0,1,226,240,231,192,0,191,255,148,70,106,7,9,0,
47,6,98,46,1,0,106,127,5,0,46,6,56,193,141,0,106,119,29,0,
106,231,33,0,32,110,232,3,106,111,21,0,202,47,2,0,202,55,2,0,
1,58,10,48,125,87,13,0,191,255,172,80,61,63,13,0,32,102,170,0,
99,103,0,0,99,7,2,0,61,55,1,0,99,7,5,0,67,7,8,0,
32,94,239,0,67,95,9,0,8,82,99,87,10,0,3,64,0,74,128,255,
198,15,1,138,93,143,7,0,32,86,23,0,70,6,255,0,128,7,97,0,
6,232,61,55,13,0,38,135,12,0,102,7,0,0,93,7,7,0,125,135,
16,0,191,255,22,70,61,127,16,0,125,7,13,0,32,86,22,0,224,121,
178,5,32,86,36,0,64,6,127,0,134,7,225,0,6,232,191,255,48,250,
224,81,194,5,32,86,35,0,149,69,61,135,1,0,1,226,240,231,192,0,
191,255,196,69,106,7,9,0,47,6,98,46,1,0,106,127,5,0,46,6,
56,193,141,0,106,119,29,0,106,231,33,0,32,110,232,3,106,111,21,0,
202,47,2,0,202,55,2,0,1,58,10,48,125,87,13,0,191,255,220,79,
61,63,13,0,2,98,99,103,0,0,99,7,2,0,61,55,1,0,99,7,
5,0,67,7,8,0,32,94,239,0,67,95,9,0,8,82,99,87,10,0,
3,64,0,74,128,255,248,14,1,138,93,143,7,0,32,86,21,0,70,6,
255,0,128,7,97,0,6,232,61,55,13,0,38,135,12,0,102,7,0,0,
93,7,7,0,125,135,16,0,191,255,72,69,61,127,16,0,125,7,13,0,
32,86,32,0,224,121,178,5,32,86,36,0,64,6,127,0,134,7,225,16,
6,232,191,255,98,249,224,81,154,21,61,55,1,0,36,111,161,142,1,138,
230,143,192,0,49,112,78,105,100,111,161,142,191,255,182,243,10,224,224,225,
202,5,32,86,35,0,181,77,61,87,1,0,1,218,234,223,192,0,191,255,
214,68,106,7,9,0,49,6,98,46,1,0,106,143,5,0,48,6,56,193,
141,0,106,135,29,0,106,223,33,0,32,126,232,3,106,127,21,0,202,47,
2,0,202,55,2,0,1,58,10,48,125,87,13,0,191,255,238,78,61,55,
13,0,61,63,1,0,28,64,128,255,52,14,3,106,99,111,0,0,28,102,
64,0,99,103,2,0,61,55,1,0,99,7,5,0,67,7,8,0,32,94,
239,0,67,95,9,0,10,56,8,82,99,87,10,0,3,64,0,74,128,255,
250,13,93,231,4,0,1,138,93,143,7,0,32,86,19,0,70,6,255,16,
128,7,97,0,6,232,61,55,13,0,38,135,12,0,102,7,0,0,93,7,
7,0,125,135,16,0,191,255,70,68,61,23,16,0,125,7,13,0,2,6,
246,253,226,13,224,17,194,5,32,86,36,0,181,13,253,111,23,0,93,23,
44,0,244,105,178,5,13,82,181,5,32,86,18,0,64,6,127,0,128,7,
97,0,6,232,191,255,72,248,224,81,194,5,32,86,35,0,213,29,61,55,
1,0,1,66,61,78,20,0,39,6,56,193,141,0,230,71,192,0,191,255,
140,104,202,47,2,0,61,55,1,0,202,55,2,0,125,87,13,0,10,56,
191,255,126,104,1,122,93,127,7,0,32,86,17,0,64,6,127,0,128,7,
97,0,4,135,129,136,240,142,232,3,10,122,17,232,79,232,29,48,129,255,
102,137,224,81,146,13,38,6,148,107,133,0,32,62,37,8,0,66,191,255,
30,4,36,103,125,136,4,87,128,136,1,18,221,97,100,103,125,136,224,81,
162,5,10,16,100,23,149,142,13,82,64,6,127,0,128,7,97,0,6,232,
61,55,13,0,38,135,12,0,102,7,0,0,93,7,7,0,125,135,16,0,
191,255,92,67,61,127,16,0,125,7,13,0,4,82,224,121,178,5,32,86,
36,0,64,6,127,0,134,7,225,0,6,232,191,255,120,247,224,81,194,5,
32,86,35,0,181,125,36,135,149,142,16,142,255,255,100,143,149,142,224,129,
186,5,15,82,149,117,61,119,1,0,1,226,238,231,192,0,191,255,248,66,
106,7,9,0,45,6,98,46,1,0,106,111,5,0,44,6,56,193,141,0,
106,103,29,0,106,231,33,0,32,94,208,7,106,95,21,0,202,47,2,0,
202,55,2,0,1,58,10,48,125,87,13,0,191,255,16,77,36,63,245,178,
61,71,1,0,38,6,180,107,133,0,129,255,136,184,157,87,45,0,224,81,
242,29,38,6,212,107,133,0,129,255,118,184,61,63,13,0,7,138,99,143,
0,0,99,7,2,0,61,55,1,0,99,7,5,0,67,7,8,0,32,134,
239,0,67,135,9,0,8,122,99,127,10,0,3,64,0,74,128,255,8,12,
213,13,38,6,168,107,133,0,129,255,58,184,61,55,1,0,61,63,13,0,
0,66,128,255,254,11,189,119,45,0,224,113,242,13,61,95,1,0,1,106,
36,143,161,142,1,98,235,111,192,0,45,80,74,137,100,143,161,142,68,103,
164,142,1,122,93,127,7,0,14,82,70,6,255,0,128,7,225,0,6,232,
61,55,13,0,38,135,12,0,102,7,0,0,93,7,7,0,125,135,16,0,
191,255,28,66,61,127,16,0,125,7,13,0,224,121,194,5,32,86,36,0,
181,101,32,54,0,2,129,255,246,163,10,224,224,225,154,13,38,6,228,107,
133,0,32,62,59,5,0,66,191,255,112,2,61,119,1,0,32,110,96,2,
238,111,32,2,43,6,88,49,141,0,203,105,45,55,57,0,32,70,0,2,
28,56,191,255,70,81,125,87,16,0,234,0,224,81,226,5,28,48,129,255,
202,163,11,82,149,61,60,143,0,0,131,138,169,21,252,103,5,0,1,18,
12,6,56,200,210,5,12,6,116,140,162,5,0,18,93,23,44,0,28,48,
129,255,160,163,13,82,197,37,61,55,1,0,28,56,191,255,50,243,93,87,
5,0,28,48,129,255,136,163,189,95,5,0,11,6,2,255,202,5,32,86,
38,0,165,21,61,55,1,0,191,255,250,240,224,81,162,13,61,55,1,0,
191,255,16,241,224,81,194,5,32,86,16,0,181,5,32,86,18,0,64,6,
255,0,128,7,225,0,6,232,191,255,116,245,224,81,194,5,32,86,35,0,
133,61,61,135,1,0,1,226,240,231,192,0,191,255,8,65,106,7,9,0,
47,6,98,46,1,0,106,127,5,0,46,6,56,193,141,0,106,119,29,0,
106,231,33,0,32,110,208,7,106,111,21,0,202,47,2,0,202,55,2,0,
1,58,10,48,125,87,13,0,191,255,32,75,61,55,1,0,32,94,96,2,
230,95,32,2,61,63,13,0,49,6,88,49,141,0,209,89,43,71,57,0,
128,255,100,10,1,130,93,135,7,0,12,82,64,6,255,0,128,7,225,16,
6,232,61,55,13,0,38,135,12,0,102,7,0,0,93,7,7,0,125,135,
16,0,191,255,158,64,61,127,16,0,125,7,13,0,224,121,194,5,32,86,
37,0,133,77,32,54,0,2,129,255,120,162,10,216,224,217,154,13,38,6,
248,107,133,0,32,62,224,4,0,66,191,255,242,0,61,119,1,0,32,110,
96,2,238,111,32,2,43,6,88,49,141,0,203,105,45,55,57,0,32,70,
0,2,27,56,191,255,200,79,125,87,16,0,0,226,0,18,2,80,193,82,
219,81,234,127,1,0,2,112,200,114,2,96,14,97,47,97,12,225,220,0,
65,18,2,6,0,255,150,245,27,48,129,255,242,161,224,225,226,13,36,63,
245,178,61,71,1,0,38,6,12,108,133,0,28,72,129,255,200,181,32,86,
37,0,165,5,11,82,64,6,255,16,128,7,225,0,6,232,61,55,13,0,
38,135,12,0,102,7,0,0,93,7,7,0,125,135,16,0,191,255,220,63,
61,127,16,0,125,7,13,0,224,121,178,5,11,82,133,61,61,111,1,0,
1,226,237,231,192,0,191,255,166,63,10,48,102,7,9,0,44,6,98,46,
1,0,102,103,5,0,43,6,56,193,141,0,102,95,29,0,102,231,33,0,
32,86,208,7,102,87,21,0,198,47,2,0,198,55,2,0,1,58,125,55,
13,0,191,255,190,73,61,55,1,0,32,134,96,2,230,135,32,2,61,63,
13,0,46,6,88,49,141,0,206,129,48,71,57,0,128,255,10,9,1,106,
93,111,7,0,10,82,64,6,255,0,128,7,225,16,6,232,32,54,0,2,
129,255,64,161,10,224,0,18,2,136,193,138,220,137,2,112,200,114,2,104,
14,105,113,111,0,0,65,18,2,6,0,255,198,245,61,103,1,0,32,94,
96,2,236,95,32,2,59,6,88,49,141,0,219,89,43,55,57,0,32,70,
0,2,28,56,191,255,68,60,28,48,129,255,218,160,61,135,1,0,1,226,
240,231,192,0,191,255,224,62,106,7,9,0,47,6,98,46,1,0,106,127,
5,0,46,6,56,193,141,0,106,119,29,0,106,231,33,0,32,110,208,7,
106,111,21,0,202,47,2,0,202,55,2,0,125,87,13,0,10,48,1,58,
191,255,248,72,61,55,1,0,32,94,96,2,230,95,32,2,61,63,13,0,
219,89,43,71,57,0,128,255,82,8,1,138,93,143,7,0,9,82,64,6,
255,16,128,7,97,0,6,232,61,55,13,0,38,135,12,0,102,7,0,0,
93,7,7,0,125,135,16,0,191,255,124,62,61,127,16,0,125,7,13,0,
6,82,224,121,178,5,32,86,37,0,64,6,127,0,128,7,225,0,6,232,
191,255,152,242,224,81,194,5,32,86,36,0,133,69,61,143,41,0,17,6,
238,255,182,5,8,82,149,61,61,127,1,0,1,226,239,231,192,0,191,255,
30,62,106,7,9,0,46,6,98,46,1,0,106,119,5,0,45,6,56,193,
141,0,106,111,29,0,106,231,33,0,2,98,106,103,21,0,202,47,2,0,
202,55,2,0,125,87,13,0,10,48,1,58,191,255,56,72,61,23,41,0,
49,6,88,108,133,0,61,55,1,0,61,63,13,0,2,94,1,0,209,17,
130,71,1,0,125,95,41,0,128,255,144,7,1,122,93,127,7,0,7,82,
64,6,255,0,130,7,225,0,6,232,61,55,13,0,38,135,12,0,102,7,
0,0,93,7,7,0,125,135,16,0,191,255,178,61,61,127,16,0,125,7,
13,0,224,121,194,5,32,86,36,0,133,117,189,79,29,0,61,143,37,0,
201,230,253,0,224,137,146,13,157,127,33,0,239,225,218,5,61,119,37,0,
65,114,133,37,4,111,69,137,129,106,153,29,36,63,245,178,61,71,1,0,
38,6,108,108,133,0,129,255,40,179,61,71,37,0,224,65,130,13,157,63,
33,0,38,6,148,108,133,0,129,255,18,179,37,54,16,133,129,255,10,179,
1,114,93,231,32,0,189,95,29,0,125,119,37,0,203,118,63,0,14,6,
193,255,194,53,224,89,170,13,61,87,37,0,101,82,150,13,4,143,69,137,
129,138,169,45,165,29,220,118,128,0,178,5,4,82,133,45,220,126,36,0,
202,13,220,94,88,0,104,90,130,13,11,6,176,255,210,29,11,6,168,255,
162,29,181,5,1,82,133,29,4,143,69,137,129,138,137,21,61,111,37,0,
36,63,245,178,61,71,1,0,157,79,33,0,38,6,180,108,133,0,99,111,
1,0,129,255,140,178,32,86,35,0,165,5,6,82,66,6,255,0,128,7,
97,0,6,232,191,255,240,240,224,81,194,5,32,86,35,0,133,37,32,54,
20,5,129,255,194,62,61,55,1,0,1,66,61,78,20,0,39,6,56,193,
141,0,230,71,192,0,191,255,44,97,202,47,2,0,61,55,1,0,202,55,
2,0,125,87,13,0,10,56,128,255,48,6,1,122,93,127,7,0,5,82,
64,6,127,0,128,7,225,16,6,232,61,55,13,0,38,135,12,0,102,7,
0,0,93,7,7,0,125,135,16,0,191,255,74,60,125,7,13,0,29,48,
191,255,124,240,224,81,210,5,32,86,35,0,128,7,4,1,61,127,16,0,
224,121,194,5,32,86,36,0,165,125,36,231,245,178,61,135,49,0,189,95,
29,0,176,225,11,6,129,255,154,45,61,55,1,0,28,6,215,255,153,21,
1,90,36,127,157,142,230,95,192,0,36,119,153,142,43,128,80,121,100,127,
157,142,65,114,100,119,153,142,4,218,165,93,0,58,191,255,36,3,61,95,
1,0,2,218,1,58,38,6,56,193,141,0,235,63,192,0,0,66,191,255,
94,29,1,82,93,87,7,0,245,69,203,118,238,0,14,6,192,255,226,23,
0,0,28,6,105,255,177,5,224,17,178,61,4,218,11,6,128,255,242,13,
61,135,1,0,1,82,36,127,161,142,36,119,245,178,240,87,192,0,10,121,
100,127,161,142,125,119,49,0,61,95,1,0,36,143,157,142,1,106,235,111,
192,0,45,80,74,137,100,143,157,142,234,29,36,135,161,142,224,129,170,29,
4,119,129,136,238,126,232,3,10,106,15,232,77,232,188,233,224,233,151,13,
29,48,129,255,6,129,36,143,125,136,221,137,100,143,125,136,36,135,125,136,
220,129,100,135,125,136,165,5,2,218,27,80,64,6,255,16,128,7,97,0,
6,232,191,255,98,239,224,81,194,5,32,86,35,0,197,29,61,55,1,0,
1,66,61,78,20,0,39,6,56,193,141,0,230,71,192,0,191,255,166,95,
202,47,2,0,61,55,1,0,202,55,2,0,125,87,13,0,10,56,128,255,
170,4,1,122,93,127,7,0,3,82,64,6,127,0,128,7,225,0,6,232,
189,143,45,0,224,137,226,93,36,135,157,142,224,129,234,29,36,127,161,142,
224,121,170,29,132,119,165,142,224,113,130,21,4,103,129,136,236,110,232,3,
10,90,13,224,75,224,28,48,129,255,96,128,36,135,125,136,220,129,100,135,
125,136,4,127,128,136,68,7,164,142,100,127,153,142,36,119,153,142,224,113,
199,21,61,87,1,0,14,110,255,255,36,143,157,142,100,111,153,142,1,98,
36,135,245,178,234,103,192,0,12,137,100,143,157,142,125,135,9,0,229,37,
61,119,1,0,1,226,238,231,192,0,191,255,62,58,2,90,106,7,9,0,
45,6,98,46,1,0,106,111,5,0,44,6,56,193,141,0,106,103,29,0,
106,231,33,0,106,95,21,0,10,224,28,48,0,58,191,255,98,68,124,7,
0,0,28,48,191,255,32,58,1,82,1,18,197,21,61,55,1,0,191,255,
254,2,61,55,1,0,191,255,126,3,36,143,245,178,4,135,232,135,4,18,
125,143,49,0,224,129,162,5,2,18,0,80,93,87,7,0,2,80,64,6,
255,0,128,7,33,0,38,135,1,0,4,143,233,135,241,129,198,5,32,86,
34,0,165,21,36,127,245,178,102,7,41,0,102,127,9,0,32,54,96,2,
240,55,32,2,42,6,88,49,141,0,202,49,191,255,50,123,1,82,64,6,
63,0,128,7,225,0,6,232,29,119,53,0,44,6,92,109,133,0,7,224,
61,63,1,0,196,114,204,113,61,71,16,0,46,79,5,0,156,0,38,6,
232,108,133,0,129,255,66,175,61,55,1,0,36,127,157,142,1,90,230,95,
192,0,43,128,36,87,161,142,80,121,100,127,157,142,1,114,230,119,192,0,
46,88,75,81,100,87,161,142,28,56,0,66,191,255,152,236,61,135,1,0,
32,54,96,2,240,55,32,2,44,6,88,49,141,0,93,7,6,0,204,49,
191,255,78,122,64,6,255,0,128,7,97,0,6,232,61,55,1,0,189,63,
5,0,0,66,191,255,100,236,93,7,6,0,32,86,39,0,64,6,127,0,
128,7,33,0,32,62,254,0,191,255,90,255,32,86,38,0,64,6,63,0,
128,7,33,0,0,58,191,255,72,255,32,86,37,0,64,6,63,0,128,7,
33,0,0,58,191,255,54,255,32,86,36,0,64,6,63,0,128,7,97,0,
6,232,61,55,1,0,36,111,157,142,1,138,36,135,161,142,230,143,192,0,
49,112,78,105,100,111,157,142,1,98,230,103,192,0,44,136,81,129,100,135,
161,142,0,58,0,66,191,255,234,235,61,127,1,0,32,54,96,2,239,55,
32,2,93,7,6,0,43,6,88,49,141,0,203,49,191,255,160,121,32,86,
35,0,64,6,127,0,128,7,97,0,6,232,61,55,1,0,0,66,0,58,
191,255,180,235,93,7,6,0,32,86,34,0,64,6,127,0,128,7,225,16,
6,232,29,143,52,0,17,6,216,255,150,13,38,6,36,109,133,0,32,62,
103,1,0,66,190,255,196,248,29,231,52,0,46,6,92,109,133,0,28,16,
196,18,206,17,34,55,8,0,34,95,10,0,221,49,224,89,206,5,34,223,
13,0,213,13,34,87,12,0,198,81,42,87,1,0,195,90,202,89,43,87,
0,0,43,223,5,0,202,49,63,6,76,13,129,0,123,0,189,103,7,0,
93,87,52,0,224,97,218,5,157,95,7,0,224,89,138,205,157,87,7,0,
93,231,53,0,64,6,255,16,128,7,97,0,6,232,93,7,52,0,1,138,
93,143,6,0,93,7,7,0,125,7,9,0,32,134,255,0,132,127,131,136,
93,135,32,0,4,119,232,135,125,7,37,0,125,7,16,0,93,127,45,0,
224,113,210,5,4,111,129,136,224,105,186,5,93,7,45,0,61,55,1,0,
0,66,0,58,191,255,212,234,4,87,128,136,29,103,45,0,97,82,230,95,
0,0,76,89,139,0,224,89,194,5,1,114,68,119,128,136,189,111,45,0,
32,22,16,0,100,7,125,136,224,105,186,5,4,23,128,136,36,103,245,178,
100,23,149,142,100,7,157,142,100,7,161,142,125,103,49,0,68,7,164,142,
64,6,127,0,128,7,97,0,6,232,61,55,13,0,224,49,178,5,191,255,
106,162,61,55,1,0,0,66,0,58,191,255,106,234,61,143,1,0,32,54,
96,2,93,7,6,0,241,55,32,2,45,6,88,49,141,0,93,7,7,0,
205,49,191,255,28,120,32,102,35,0,93,103,52,0,32,94,4,2,125,95,
16,0,64,6,127,0,128,7,33,0,38,6,56,193,141,0,39,6,56,109,
133,0,129,255,242,110,224,81,146,13,38,6,72,109,133,0,32,62,241,0,
0,66,190,255,74,247,1,50,191,255,240,51,100,87,169,142,0,18,42,6,
184,189,141,0,106,23,1,0,65,18,10,86,56,0,2,6,240,255,150,253,
64,6,63,0,33,6,152,18,0,0,97,0,33,6,10,159,1,0,97,0,
33,6,34,22,0,0,97,0,33,6,14,21,0,0,97,0,33,6,138,11,
0,0,97,0,33,6,190,51,1,0,97,0,33,6,174,20,0,0,97,0,
33,6,104,22,0,0,97,0,33,6,10,18,0,0,97,0,33,6,80,18,
0,0,97,0,33,6,154,21,0,0,97,0,33,6,216,21,0,0,97,0,
128,7,97,0,229,87,64,0,224,7,96,1,36,143,181,136,10,232,224,137,
178,13,32,54,192,248,128,255,54,36,32,54,128,254,128,255,54,36,100,7,
181,136,253,47,32,0,64,6,127,0,128,7,97,0,229,87,64,0,224,7,
96,1,36,143,181,136,10,232,224,137,202,13,32,54,64,7,128,255,4,36,
32,54,128,1,128,255,4,36,1,130,100,135,181,136,253,47,32,0,64,6,
127,0,128,7,97,0,229,87,64,0,224,7,96,1,36,143,177,136,10,232,
224,137,178,13,32,54,235,255,128,255,208,35,32,54,176,255,128,255,208,35,
100,7,177,136,253,47,32,0,64,6,127,0,128,7,97,0,229,87,64,0,
224,7,96,1,36,143,177,136,10,232,224,137,202,13,32,54,21,0,128,255,
158,35,32,54,80,0,128,255,158,35,1,130,100,135,177,136,253,47,32,0,
64,6,127,0,166,143,9,0,32,22,7,2,134,127,1,0,209,142,237,0,
70,143,9,0,17,6,192,255,218,5,97,122,170,21,0,18,133,21,129,138,
233,13,101,122,226,5,108,122,194,5,15,6,236,255,250,5,4,87,232,135,
224,81,178,5,32,22,0,2,2,80,127,0,0,82,6,16,34,143,2,0,
138,138,193,29,34,23,9,0,224,17,154,253,32,86,20,16,6,16,34,111,
2,0,133,106,241,5,34,23,9,0,224,17,154,253,197,13,2,48,38,23,
9,0,224,17,202,253,38,143,29,0,209,207,52,0,162,5,0,82,127,0,
128,7,225,16,6,232,253,0,7,216,60,6,88,193,141,0,28,48,37,62,
45,133,129,255,172,54,29,56,27,64,28,72,38,6,60,114,133,0,129,255,
132,170,64,6,255,16,128,7,225,16,6,232,61,231,9,0,224,225,210,93,
221,207,2,0,154,13,38,6,116,114,133,0,32,62,122,6,0,66,190,255,
30,245,61,143,14,0,224,137,154,13,38,6,116,114,133,0,32,62,123,6,
0,66,190,255,6,245,253,135,19,0,224,129,154,13,38,6,44,114,133,0,
32,62,63,3,0,66,190,255,238,244,0,50,1,18,61,127,18,0,2,104,
230,111,192,0,79,105,205,0,224,105,218,5,65,50,6,6,240,255,198,245,
6,216,61,55,14,0,61,63,9,0,191,255,86,255,29,16,34,143,2,0,
133,138,225,5,34,23,9,0,224,17,154,253,245,5,32,230,19,16,38,6,
80,114,133,0,229,5,32,230,17,16,38,6,136,114,133,0,27,56,129,255,
208,169,61,63,14,0,29,48,128,255,40,34,125,231,14,0,27,48,128,255,
38,34,165,5,252,0,28,80,64,6,255,16,128,7,225,16,6,232,29,16,
34,143,2,0,133,138,241,5,34,23,9,0,224,17,154,253,128,7,28,1,
61,223,9,0,224,217,186,5,128,7,12,1,221,207,2,0,154,13,38,6,
196,114,133,0,32,62,246,6,0,66,190,255,54,244,253,111,19,0,224,105,
154,13,38,6,44,114,133,0,32,62,63,3,0,66,190,255,30,244,0,58,
1,18,61,103,18,0,2,80,231,87,192,0,76,81,202,0,224,81,218,5,
65,58,7,6,240,255,198,245,7,224,61,55,14,0,61,63,9,0,191,255,
134,254,28,56,38,6,168,114,133,0,129,255,36,169,61,63,14,0,29,48,
32,222,16,16,128,255,120,33,32,110,21,16,125,111,14,0,28,48,191,255,
124,225,10,48,1,58,252,63,192,0,128,255,110,33,28,48,224,81,210,13,
128,255,108,33,28,48,191,255,96,225,197,82,32,126,164,180,207,81,202,143,
31,0,229,29,191,255,78,225,197,82,32,94,164,180,203,81,202,207,31,0,
218,21,28,48,191,255,58,225,10,64,28,72,10,50,39,6,216,114,133,0,
190,255,72,245,28,48,191,255,36,225,197,82,32,118,164,180,206,81,202,15,
31,0,28,48,128,255,8,33,36,159,133,136,3,98,65,154,100,159,133,136,
236,159,128,106,224,105,186,13,1,82,100,87,173,136,245,5,251,0,213,5,
29,48,191,255,252,253,10,216,27,80,64,6,255,16,136,7,97,0,6,232,
38,6,40,115,133,0,224,57,194,5,38,6,236,114,133,0,129,255,86,168,
189,63,9,0,189,103,5,0,189,71,7,0,157,127,9,0,157,79,7,0,
99,103,1,0,157,95,5,0,99,95,5,0,253,87,3,0,99,87,9,0,
253,143,1,0,15,65,38,6,100,115,133,0,99,143,13,0,129,255,26,168,
0,82,72,6,127,0,128,7,225,240,7,224,8,200,0,58,6,208,25,72,
0,66,191,255,224,86,10,232,224,225,162,13,28,216,10,138,241,223,194,2,
125,223,21,0,36,135,245,178,208,217,221,47,2,0,224,225,226,199,0,0,
26,48,29,56,128,255,88,32,61,127,0,0,224,121,218,253,61,231,12,0,
29,48,1,58,191,255,56,60,185,23,9,0,4,143,232,135,2,112,136,114,
225,95,0,0,224,137,130,13,2,6,129,255,226,127,0,0,11,121,15,88,
139,0,224,225,170,13,224,89,130,13,224,193,234,5,36,87,245,178,251,81,
131,221,197,5,28,6,252,253,242,13,26,48,29,56,128,255,254,31,61,135,
0,0,224,129,218,253,61,231,12,0,25,48,1,58,191,255,252,254,125,7,
0,0,29,48,191,255,156,49,28,80,64,6,255,240,3,30,200,255,99,79,
53,0,99,71,49,0,99,255,37,0,99,191,29,0,6,184,99,231,9,0,
7,224,99,183,33,0,35,183,65,0,99,207,21,0,99,223,13,0,99,239,
5,0,99,215,17,0,99,199,25,0,36,207,245,178,0,210,56,6,98,46,
1,0,191,255,54,49,28,136,10,130,240,143,194,2,1,58,10,232,106,7,
9,0,106,199,5,0,106,7,29,0,106,7,33,0,106,143,21,0,29,48,
191,255,96,59,221,47,2,0,35,54,48,0,23,56,35,159,69,0,22,72,
35,127,61,0,29,64,99,159,1,0,63,6,66,20,129,0,111,0,61,119,
0,0,224,113,218,253,61,223,12,0,125,7,0,0,29,48,191,255,240,48,
27,6,0,254,242,5,27,6,253,253,194,5,27,6,248,253,250,13,36,111,
245,178,185,105,234,111,64,2,173,225,224,225,207,5,32,222,4,2,197,5,
65,210,99,210,150,189,27,80,35,183,33,0,35,191,29,0,35,199,25,0,
35,207,21,0,35,215,17,0,35,223,13,0,35,231,9,0,35,239,5,0,
35,255,37,0,3,30,56,0,127,0,3,30,200,255,99,79,53,0,99,71,
49,0,99,255,37,0,99,215,29,0,6,208,99,207,33,0,7,200,99,239,
17,0,35,239,65,0,99,223,25,0,35,223,69,0,99,231,21,0,0,226,
35,142,56,0,49,127,1,0,35,22,48,0,34,71,1,0,34,79,5,0,
99,127,1,0,49,119,5,0,26,48,25,56,99,223,9,0,99,119,5,0,
99,7,13,0,191,255,162,254,10,16,224,17,202,37,61,23,1,0,2,22,
16,0,34,55,0,0,34,95,5,0,63,6,52,21,129,0,221,49,107,0,
27,48,10,56,32,70,0,2,191,255,132,63,10,16,224,81,234,13,61,23,
1,0,72,18,34,55,0,0,34,143,5,0,63,6,94,21,129,0,221,49,
113,0,10,16,65,226,99,226,206,5,2,6,249,239,210,189,35,223,25,0,
35,255,37,0,35,239,17,0,35,231,21,0,35,215,29,0,35,207,33,0,
2,80,3,30,56,0,127,0,128,7,225,0,6,232,253,143,19,0,0,226,
224,137,154,13,38,6,44,114,133,0,32,62,63,3,0,66,190,255,32,240,
0,58,1,18,61,135,18,0,2,112,231,119,192,0,80,113,206,0,224,113,
218,5,65,58,7,6,240,255,198,245,7,232,29,6,240,255,193,13,29,48,
191,255,166,221,10,48,1,58,253,63,192,0,128,255,152,29,224,81,186,5,
0,82,245,21,36,63,73,143,36,119,69,143,10,98,29,48,206,57,236,63,
194,2,128,255,146,29,224,81,159,13,32,230,4,2,29,56,38,6,172,115,
133,0,129,255,244,164,28,80,64,6,255,0,160,7,225,16,6,232,221,207,
2,0,0,218,154,13,38,6,200,115,133,0,32,62,224,10,0,66,190,255,
146,239,253,143,19,0,224,137,154,13,38,6,44,114,133,0,32,62,63,3,
0,66,190,255,122,239,0,50,1,18,61,135,18,0,2,112,230,119,192,0,
80,113,206,0,224,113,218,5,65,50,6,6,240,255,198,245,6,224,61,55,
14,0,61,63,9,0,191,255,226,249,28,48,191,255,72,222,28,56,224,81,
242,85,38,6,220,115,133,0,129,255,118,164,99,7,17,0,99,7,25,0,
99,7,41,0,34,6,132,16,0,0,99,23,33,0,42,6,22,51,129,0,
99,87,45,0,35,142,32,0,49,127,1,0,35,94,48,0,107,127,1,0,
49,119,5,0,107,119,5,0,49,111,9,0,107,111,9,0,49,103,13,0,
35,86,16,0,107,103,13,0,106,127,1,0,43,135,5,0,106,135,5,0,
43,127,9,0,106,127,9,0,43,119,13,0,42,71,1,0,35,110,24,0,
106,119,13,0,45,95,1,0,42,79,5,0,99,95,1,0,45,87,5,0,
32,134,242,0,99,87,5,0,36,143,173,142,99,135,13,0,28,48,32,62,
136,19,99,143,9,0,191,255,132,252,10,216,229,5,38,6,244,115,133,0,
129,255,202,163,27,80,96,6,255,16,128,7,97,0,6,232,253,143,19,0,
224,137,154,13,38,6,44,114,133,0,32,62,63,3,0,66,190,255,104,238,
0,50,1,18,61,135,18,0,2,112,230,119,192,0,80,113,206,0,224,113,
218,5,65,50,6,6,240,255,198,245,6,6,240,255,177,5,128,255,248,27,
0,82,64,6,127,0,128,7,225,112,6,224,60,215,14,0,60,207,2,0,
0,218,222,202,159,202,242,37,252,143,19,0,224,137,154,13,38,6,44,114,
133,0,32,62,63,3,0,66,190,255,12,238,0,234,1,18,60,135,18,0,
2,112,253,119,192,0,80,113,206,0,224,113,218,5,65,234,29,6,240,255,
198,245,60,55,14,0,60,63,9,0,191,255,118,248,29,56,37,54,48,133,
129,255,22,163,28,16,34,87,2,0,137,82,225,5,34,23,9,0,224,17,
154,253,229,5,26,6,252,253,186,5,32,222,17,16,28,16,34,111,2,0,
140,106,225,5,34,23,9,0,224,17,154,253,165,13,26,6,254,253,210,5,
26,22,248,253,98,18,187,5,32,222,17,16,28,16,34,143,2,0,138,138,
225,5,34,23,9,0,224,17,154,253,245,13,26,6,252,253,234,5,224,217,
202,5,32,222,4,2,229,21,26,6,253,253,178,21,224,217,154,21,229,13,
28,48,191,255,174,247,224,81,186,13,224,217,154,13,26,6,253,253,226,5,
26,6,0,254,178,5,32,222,19,16,224,201,242,37,224,217,178,13,27,6,
252,253,194,21,27,6,239,239,178,13,27,6,237,239,226,13,181,21,38,6,
20,116,133,0,129,255,94,162,213,21,38,6,60,116,133,0,129,255,82,162,
245,13,38,6,36,116,133,0,129,255,70,162,149,13,27,64,38,6,80,116,
133,0,32,62,174,7,190,255,246,236,27,80,64,6,255,112,146,7,225,243,
6,208,218,207,2,0,154,13,38,6,236,116,133,0,32,62,51,12,0,66,
190,255,212,236,218,215,3,0,32,222,2,2,178,5,128,7,180,1,250,135,
19,0,224,129,154,13,38,6,44,114,133,0,32,62,63,3,0,66,190,255,
174,236,0,50,1,18,58,127,18,0,2,104,230,111,192,0,79,105,205,0,
224,105,218,5,65,50,6,6,240,255,198,245,6,200,0,58,35,70,24,0,
191,255,178,249,10,216,224,81,218,5,35,151,29,0,99,151,5,0,25,48,
191,255,38,219,224,81,130,29,25,48,190,255,246,244,25,48,0,58,35,70,
12,0,191,255,136,249,10,216,224,217,178,5,128,7,62,1,35,23,17,0,
35,151,5,0,216,18,2,145,99,151,5,0,213,5,224,217,178,5,128,7,
36,1,26,72,41,111,2,0,133,106,185,5,1,74,213,5,41,79,9,0,
224,73,250,245,99,79,1,0,224,73,130,21,26,16,181,5,34,23,9,0,
34,135,9,0,224,129,186,253,34,127,29,0,207,199,52,0,178,5,99,7,
1,0,0,234,35,151,5,0,0,186,3,178,0,194,18,230,255,255,50,6,
100,194,141,0,99,151,9,0,213,85,58,55,14,0,58,63,9,0,191,255,
102,246,25,56,28,64,29,72,38,6,144,116,133,0,129,255,0,161,35,71,
9,0,35,79,1,0,28,56,25,48,128,255,130,25,10,216,27,6,234,239,
138,13,38,6,0,117,133,0,129,255,222,160,0,218,229,53,224,217,242,21,
27,6,247,254,162,29,27,6,222,254,178,13,27,6,217,254,202,29,38,6,
172,116,133,0,129,255,186,160,0,218,181,29,38,6,52,117,133,0,129,255,
172,160,213,21,37,54,56,133,129,255,162,160,65,186,245,13,95,178,38,6,
100,116,133,0,129,255,146,160,0,218,245,5,27,56,38,6,200,116,133,0,
129,255,130,160,65,226,225,79,0,0,201,233,65,194,99,194,190,5,224,217,
178,173,224,185,210,13,246,185,186,13,35,79,5,0,25,64,32,54,35,0,
39,6,216,116,133,0,190,255,230,236,27,80,82,6,255,243,160,7,225,16,
6,232,221,207,2,0,210,37,253,143,19,0,224,137,154,13,38,6,44,114,
133,0,32,62,63,3,0,66,190,255,236,234,0,50,1,18,61,135,18,0,
2,112,230,119,192,0,80,113,206,0,224,113,218,5,65,50,6,6,240,255,
198,245,6,232,29,6,240,255,225,5,191,255,218,216,10,224,224,225,186,5,
0,82,213,85,99,7,17,0,99,7,25,0,99,7,41,0,34,6,214,17,
0,0,99,23,33,0,42,6,58,51,129,0,99,87,45,0,35,142,32,0,
49,127,1,0,35,94,48,0,107,127,1,0,49,119,5,0,107,119,5,0,
49,111,9,0,107,111,9,0,49,103,13,0,35,86,16,0,107,103,13,0,
106,127,1,0,43,135,5,0,106,135,5,0,43,127,9,0,106,127,9,0,
43,119,13,0,35,110,24,0,42,71,1,0,106,119,13,0,45,95,1,0,
42,79,5,0,29,48,99,95,1,0,45,87,5,0,99,231,9,0,99,7,
13,0,32,62,232,3,99,87,5,0,191,255,12,248,10,216,224,217,234,5,
29,48,28,56,199,0,128,255,234,23,27,80,96,6,255,16,176,7,225,243,
6,232,221,207,2,0,154,13,38,6,144,117,133,0,32,62,112,11,0,66,
190,255,240,233,253,143,19,0,224,137,154,13,38,6,44,114,133,0,32,62,
63,3,0,66,190,255,216,233,0,50,1,18,61,135,18,0,2,112,230,119,
192,0,80,113,206,0,224,113,218,5,65,50,6,6,240,255,198,245,6,224,
28,6,240,255,201,5,0,82,128,7,128,2,4,87,232,135,0,18,224,81,
194,13,252,134,96,0,46,6,184,183,141,0,206,129,240,111,17,0,224,105,
162,5,1,18,224,17,226,207,0,0,28,48,191,255,152,215,61,55,14,0,
61,63,9,0,10,192,191,255,6,244,29,16,34,95,2,0,133,90,185,5,
1,18,213,5,34,23,9,0,224,17,250,245,2,184,38,6,96,117,133,0,
224,201,194,5,38,6,164,117,133,0,28,56,129,255,130,158,224,193,170,13,
38,6,124,117,133,0,129,255,116,158,61,87,14,0,128,7,2,2,99,7,
81,0,99,7,89,0,224,201,226,61,99,7,57,0,34,6,20,17,0,0,
99,23,49,0,47,6,58,51,129,0,99,127,61,0,35,118,48,0,46,103,
1,0,35,134,64,0,112,103,1,0,46,95,5,0,112,95,5,0,46,87,
9,0,112,87,9,0,46,143,13,0,35,126,80,0,112,143,13,0,111,103,
1,0,48,111,5,0,111,111,5,0,48,103,9,0,111,103,9,0,48,95,
13,0,32,54,4,2,111,95,13,0,129,255,136,136,10,216,224,217,178,69,
49,6,104,93,134,0,123,143,1,0,213,61,99,207,25,0,34,6,206,16,
0,0,99,23,17,0,48,6,58,51,129,0,99,135,29,0,35,126,16,0,
47,111,1,0,35,142,32,0,113,111,1,0,47,103,5,0,113,103,5,0,
47,95,9,0,113,95,9,0,47,87,13,0,35,134,80,0,113,87,13,0,
112,111,1,0,49,119,5,0,112,119,5,0,49,111,9,0,112,111,9,0,
49,103,13,0,32,54,4,2,112,103,13,0,129,255,14,136,10,216,224,217,
226,5,42,6,128,93,134,0,123,87,1,0,224,217,154,13,38,6,144,117,
133,0,32,62,183,11,0,66,190,255,28,232,35,142,88,0,49,127,1,0,
35,22,80,0,34,71,1,0,34,79,5,0,99,127,1,0,49,119,5,0,
99,223,9,0,99,119,5,0,36,111,173,142,28,48,32,62,232,3,99,111,
13,0,191,255,208,246,10,208,224,209,186,85,26,176,27,48,224,201,226,13,
129,255,248,6,10,200,24,56,25,64,38,6,72,117,133,0,129,255,2,157,
249,193,178,29,197,29,129,255,136,6,252,206,96,0,49,6,184,183,141,0,
10,192,209,201,249,183,17,0,24,64,38,6,72,117,133,0,22,56,129,255,
216,156,246,193,226,45,224,185,226,5,121,199,16,0,181,5,224,177,242,37,
28,64,32,54,58,0,37,62,60,133,190,255,74,233,32,214,5,2,224,185,
130,29,28,48,191,255,30,213,10,224,28,48,128,255,68,21,224,81,130,13,
28,64,32,54,37,0,37,62,68,133,190,255,34,233,29,48,191,255,64,252,
224,81,242,5,10,208,213,5,128,54,255,255,128,255,36,21,224,217,194,5,
27,48,129,255,130,136,26,80,112,6,255,243,134,7,225,16,6,232,221,207,
2,0,154,13,38,6,220,117,133,0,32,62,250,8,0,66,190,255,16,231,
253,143,19,0,224,137,154,13,38,6,44,114,133,0,32,62,63,3,0,66,
190,255,248,230,0,58,1,18,61,135,18,0,2,112,231,119,192,0,80,113,
206,0,224,113,218,5,65,58,7,6,240,255,198,245,36,95,234,135,7,224,
235,225,182,5,0,82,149,85,61,55,14,0,61,63,9,0,191,255,84,241,
28,56,38,6,240,117,133,0,129,255,242,155,28,48,190,255,158,239,32,222,
40,35,28,48,191,255,86,212,10,48,1,58,252,63,192,0,128,255,72,20,
224,81,178,5,32,222,184,11,28,48,27,56,3,64,191,255,180,243,10,216,
224,217,186,29,3,48,191,255,134,240,10,216,224,217,218,21,4,103,232,135,
224,97,210,29,252,86,96,0,48,6,184,183,141,0,208,81,234,127,17,0,
224,121,178,21,29,48,191,255,70,251,10,216,224,217,210,13,61,63,9,0,
27,48,191,255,214,240,28,56,38,6,192,117,133,0,129,255,116,155,197,5,
29,48,191,255,130,246,27,80,70,6,255,16,134,7,225,16,4,143,232,135,
6,232,224,137,194,45,221,207,2,0,154,13,38,6,40,118,133,0,32,62,
138,9,0,66,190,255,4,230,253,135,19,0,224,129,154,13,38,6,44,114,
133,0,32,62,63,3,0,66,190,255,236,229,0,58,1,18,61,127,18,0,
2,104,231,111,192,0,79,105,205,0,224,105,218,5,65,58,7,6,240,255,
198,245,36,87,234,135,7,216,234,217,182,5,0,82,133,69,61,55,14,0,
61,63,9,0,191,255,72,240,27,56,38,6,12,118,133,0,129,255,230,154,
27,48,1,58,190,255,94,236,27,48,32,62,184,11,3,64,191,255,194,242,
10,224,224,225,250,21,3,48,191,255,148,239,10,224,224,225,154,21,251,110,
96,0,43,6,184,183,141,0,203,105,237,87,17,0,224,81,178,21,29,48,
191,255,92,250,10,224,224,225,210,13,61,63,9,0,28,48,191,255,236,239,
27,56,38,6,60,118,133,0,129,255,138,154,197,5,29,48,191,255,152,245,
28,80,70,6,255,16,134,7,225,0,6,232,221,207,2,0,154,13,38,6,
96,118,133,0,32,62,163,8,0,66,190,255,34,229,253,143,19,0,224,137,
154,13,38,6,44,114,133,0,32,62,63,3,0,66,190,255,10,229,0,58,
1,18,61,135,18,0,2,112,231,119,192,0,80,113,206,0,224,113,218,5,
65,58,7,6,240,255,198,245,36,95,234,135,7,224,235,225,182,5,0,82,
181,85,61,55,14,0,61,63,9,0,191,255,102,239,28,56,38,6,116,118,
133,0,129,255,4,154,28,48,190,255,112,237,28,48,32,62,184,11,3,64,
191,255,226,241,10,48,224,49,218,5,3,48,191,255,180,238,10,48,6,6,
0,254,154,21,28,48,190,255,74,237,28,48,32,62,232,3,3,64,191,255,
188,241,10,48,224,49,250,5,3,48,191,255,142,238,10,48,224,49,194,21,
61,63,9,0,191,255,8,239,28,56,38,6,144,118,133,0,129,255,166,153,
4,103,232,135,224,97,242,13,29,48,191,255,54,254,10,48,229,13,4,95,
232,135,224,89,162,13,61,87,14,0,10,6,252,253,218,5,29,48,191,255,
22,253,10,48,6,80,70,6,255,0,128,7,225,48,6,232,221,207,2,0,
154,13,38,6,196,118,133,0,32,62,17,10,0,66,190,255,26,228,229,87,
64,0,224,7,96,1,253,143,19,0,10,208,224,137,154,13,38,6,44,114,
133,0,32,62,63,3,0,66,190,255,248,227,0,50,1,18,61,135,18,0,
2,112,230,119,192,0,80,113,206,0,224,113,218,5,65,50,6,6,240,255,
198,245,6,216,128,255,196,17,224,81,194,29,29,16,34,95,2,0,135,90,
225,5,34,23,9,0,224,17,154,253,133,21,61,55,14,0,61,63,9,0,
191,255,68,238,27,56,38,6,216,118,133,0,129,255,226,152,32,230,4,2,
149,21,0,226,245,13,61,55,14,0,61,63,9,0,191,255,34,238,27,56,
38,6,168,118,133,0,129,255,192,152,32,230,17,16,250,47,32,0,28,6,
239,239,146,21,29,48,38,103,2,0,133,98,225,5,38,55,9,0,224,49,
154,253,245,5,27,64,9,50,37,62,76,133,190,255,36,229,28,80,64,6,
255,48,134,7,225,16,6,232,221,207,2,0,154,13,38,6,24,119,133,0,
32,62,222,9,0,66,190,255,50,227,229,87,64,0,224,7,96,1,253,143,
19,0,10,216,224,137,154,13,38,6,44,114,133,0,32,62,63,3,0,66,
190,255,16,227,0,58,1,18,61,135,18,0,2,112,231,119,192,0,80,113,
206,0,224,113,218,5,65,58,7,6,240,255,198,245,7,224,61,55,14,0,
61,63,9,0,191,255,120,237,28,56,38,6,0,119,133,0,129,255,22,152,
28,48,190,255,216,234,28,48,128,255,196,16,229,87,64,0,224,135,96,1,
28,48,0,58,3,64,191,255,232,239,251,47,32,0,0,82,70,6,255,16,
130,7,225,16,6,232,221,207,2,0,154,13,38,6,44,119,133,0,32,62,
96,10,0,66,190,255,148,226,4,143,232,135,224,137,178,5,0,82,213,93,
253,135,19,0,224,129,154,13,38,6,44,114,133,0,32,62,63,3,0,66,
190,255,112,226,0,50,1,18,61,127,18,0,2,104,230,111,192,0,79,105,
205,0,224,105,218,5,65,50,6,6,240,255,198,245,6,224,35,62,2,0,
35,70,3,0,191,255,128,208,61,55,14,0,61,63,9,0,10,216,191,255,
202,236,3,79,2,0,28,56,27,64,38,6,64,119,133,0,129,255,98,151,
3,71,2,0,224,65,202,5,32,230,0,2,181,37,28,72,32,54,33,0,
39,6,104,119,133,0,190,255,214,227,3,71,2,0,28,56,0,50,191,255,
2,235,10,232,3,71,2,0,221,47,2,0,29,56,28,48,128,255,232,15,
61,95,0,0,224,89,218,253,61,231,12,0,125,7,0,0,29,48,191,255,
78,33,28,80,66,6,255,16,132,7,225,240,6,232,191,255,82,237,10,192,
224,193,138,93,253,223,19,0,61,55,14,0,29,56,191,255,66,236,27,56,
38,6,124,119,133,0,129,255,224,150,35,78,4,0,99,7,1,0,32,54,
12,177,32,62,0,4,0,66,191,255,148,2,224,81,194,245,0,202,0,234,
1,226,253,231,192,0,28,112,91,113,130,37,29,48,191,255,36,207,10,208,
26,48,27,56,128,255,24,15,224,81,162,29,60,104,77,217,26,48,29,56,
128,255,96,15,224,81,186,13,29,48,128,255,94,15,29,48,1,58,128,255,
94,15,224,81,170,5,1,202,29,48,128,255,90,15,65,234,29,6,240,255,
134,221,224,201,146,21,26,48,31,58,191,255,108,127,10,6,246,254,170,13,
38,6,156,119,133,0,32,62,79,13,0,66,190,255,16,225,224,81,24,80,
68,6,255,240,128,7,225,0,6,232,191,255,192,235,224,81,170,37,221,247,
3,0,250,29,61,231,29,0,60,231,49,0,61,55,14,0,29,56,156,231,
27,0,191,255,114,235,38,6,176,119,133,0,28,56,129,255,16,150,61,231,
29,0,29,48,128,255,240,14,10,56,28,48,128,255,240,14,224,81,186,5,
32,86,16,16,64,6,255,0,128,7,225,0,6,232,191,255,116,242,224,81,
130,13,10,6,239,239,226,45,10,6,237,239,242,37,213,45,29,48,128,255,
202,14,253,143,19,0,10,224,224,137,154,13,38,6,44,114,133,0,32,62,
63,3,0,66,190,255,120,224,0,50,1,18,61,135,18,0,2,112,230,119,
192,0,80,113,206,0,224,113,218,5,65,50,6,6,240,255,198,245,28,56,
128,255,148,14,32,86,16,16,133,13,29,48,191,255,68,255,197,5,29,48,
191,255,2,235,64,6,255,0,128,7,225,48,6,232,191,255,244,234,10,224,
224,225,178,5,128,7,42,1,221,247,3,0,178,5,128,7,32,1,61,223,
29,0,59,215,49,0,61,55,14,0,29,56,154,215,27,0,191,255,156,234,
38,6,204,119,133,0,26,56,129,255,58,149,219,207,52,0,242,29,253,127,
19,0,224,121,154,13,38,6,44,114,133,0,32,62,63,3,0,66,190,255,
222,223,0,50,1,18,61,119,18,0,2,96,230,103,192,0,78,97,204,0,
224,97,218,5,65,50,6,6,240,255,198,245,128,255,4,14,213,5,26,48,
1,58,128,255,2,14,10,224,28,6,246,254,154,13,38,6,232,119,133,0,
32,62,191,13,0,66,190,255,154,223,224,225,170,61,219,207,52,0,38,6,
20,120,133,0,194,5,38,6,252,119,133,0,129,255,190,148,29,48,128,255,
162,13,27,48,10,56,128,255,162,13,219,207,52,0,10,224,242,29,253,127,
19,0,224,121,154,13,38,6,44,114,133,0,32,62,63,3,0,66,190,255,
82,223,0,50,1,18,61,119,18,0,2,96,230,103,192,0,78,97,204,0,
224,97,218,5,65,50,6,6,240,255,198,245,128,255,136,13,181,21,26,48,
0,58,128,255,118,13,229,13,38,6,48,120,133,0,129,255,88,148,29,48,
128,255,60,13,27,48,10,56,128,255,60,13,10,224,224,225,186,5,32,230,
16,16,28,80,64,6,255,48,128,7,225,0,6,232,191,255,180,233,224,81,
178,5,128,7,28,1,61,63,14,0,29,48,128,255,128,12,29,48,128,255,
58,13,224,81,226,61,61,231,29,0,60,231,49,0,61,55,14,0,29,56,
156,231,27,0,191,255,84,233,38,6,92,120,133,0,28,56,129,255,242,147,
253,111,19,0,224,105,146,37,253,103,19,0,224,97,154,13,38,6,44,114,
133,0,32,62,63,3,0,66,190,255,148,222,0,66,1,18,61,95,18,0,
2,136,232,143,192,0,75,137,209,0,224,137,218,5,65,66,8,6,240,255,
198,245,29,48,37,62,84,133,128,255,194,14,61,55,29,0,61,63,14,0,
128,255,200,12,125,7,12,0,29,48,128,255,198,12,224,81,130,61,61,103,
29,0,44,103,49,0,29,56,224,97,226,37,61,231,29,0,60,231,49,0,
61,55,14,0,156,231,27,0,191,255,196,232,38,6,128,120,133,0,28,56,
129,255,98,147,28,64,32,54,37,0,37,62,92,133,190,255,230,223,32,54,
12,177,64,62,2,0,0,66,190,255,24,255,61,23,29,0,34,23,49,0,
194,23,31,0,165,13,61,55,14,0,191,255,134,232,38,6,68,120,133,0,
129,255,38,147,125,7,12,0,61,127,5,0,63,6,246,39,129,0,29,48,
111,0,32,86,17,16,64,6,255,0,128,7,97,0,6,232,61,55,14,0,
29,56,191,255,82,232,38,6,164,120,133,0,129,255,242,146,61,135,14,0,
16,6,233,253,234,5,253,55,19,0,128,255,26,12,165,13,61,119,14,0,
14,6,234,253,218,5,125,7,14,0,125,7,12,0,32,86,17,16,64,6,
127,0,176,7,225,16,6,232,221,207,2,0,154,13,38,6,236,120,133,0,
32,62,19,11,0,66,190,255,106,221,253,143,19,0,224,137,154,13,38,6,
44,114,133,0,32,62,63,3,0,66,190,255,82,221,0,58,1,18,61,135,
18,0,2,112,231,119,192,0,80,113,206,0,224,113,218,5,65,58,7,6,
240,255,198,245,7,224,28,6,240,255,201,5,0,82,128,7,178,1,61,55,
14,0,61,63,9,0,191,255,174,231,28,56,38,6,208,120,133,0,129,255,
76,146,32,54,4,2,129,255,212,124,10,232,224,233,226,5,48,6,104,93,
134,0,125,135,1,0,224,233,154,13,38,6,236,120,133,0,32,62,37,11,
0,66,190,255,226,220,99,7,49,0,99,7,57,0,99,7,73,0,34,6,
20,17,0,0,99,23,65,0,47,6,58,51,129,0,99,127,77,0,35,118,
64,0,46,103,1,0,35,134,80,0,112,103,1,0,46,95,5,0,112,95,
5,0,46,87,9,0,112,87,9,0,46,143,13,0,35,126,48,0,112,143,
13,0,111,103,1,0,48,111,5,0,111,111,5,0,48,103,9,0,111,103,
9,0,48,95,13,0,35,86,56,0,47,71,1,0,111,95,13,0,42,135,
1,0,47,79,5,0,99,135,1,0,42,127,5,0,99,239,9,0,99,127,
5,0,36,119,173,142,28,48,32,62,232,3,99,119,13,0,191,255,50,235,
10,216,224,217,170,93,29,48,128,255,164,251,224,81,130,85,38,6,0,121,
133,0,129,255,108,145,99,7,25,0,34,6,164,17,0,0,99,23,17,0,
44,6,238,50,129,0,99,103,29,0,35,94,16,0,43,143,1,0,35,110,
32,0,109,143,1,0,43,135,5,0,109,135,5,0,43,127,9,0,109,127,
9,0,43,119,13,0,35,102,48,0,109,119,13,0,108,143,1,0,45,87,
5,0,108,87,5,0,45,143,9,0,108,143,9,0,45,135,13,0,44,71,
1,0,35,126,56,0,108,135,13,0,47,111,1,0,44,79,5,0,28,48,
7,90,99,111,1,0,47,103,5,0,99,95,9,0,99,7,13,0,32,62,
16,39,99,103,5,0,191,255,136,233,10,216,197,13,37,54,100,133,129,255,
208,144,245,5,27,56,38,6,16,121,133,0,129,255,194,144,224,233,194,5,
29,48,129,255,202,124,27,80,112,6,255,16,128,7,225,0,6,232,253,55,
31,0,128,255,182,13,61,55,14,0,29,56,10,224,191,255,238,229,28,56,
38,6,64,121,133,0,129,255,140,144,61,127,14,0,15,6,233,253,218,37,
253,119,19,0,224,113,154,13,38,6,44,114,133,0,32,62,63,3,0,66,
190,255,44,219,0,66,1,18,61,111,18,0,2,88,232,95,192,0,77,89,
203,0,224,89,218,5,65,66,8,6,240,255,198,245,28,72,32,54,37,0,
39,6,40,121,133,0,190,255,206,220,149,13,28,64,32,54,57,0,39,6,
96,121,133,0,190,255,188,220,0,82,64,6,255,0,130,7,97,0,6,232,
253,143,19,0,224,137,154,13,38,6,44,114,133,0,32,62,63,3,0,66,
190,255,200,218,0,18,1,82,61,135,18,0,10,112,226,119,192,0,80,113,
206,0,224,113,218,5,65,18,2,6,240,255,198,245,253,55,31,0,3,56,
128,255,8,13,35,55,1,0,1,58,191,255,104,231,0,82,66,6,127,0,
130,7,97,0,6,232,253,143,19,0,224,137,154,13,38,6,44,114,133,0,
32,62,63,3,0,66,190,255,114,218,0,18,1,82,61,135,18,0,10,112,
226,119,192,0,80,113,206,0,224,113,218,5,65,18,2,6,240,255,198,245,
253,55,29,0,3,56,128,255,178,12,35,55,1,0,0,58,191,255,18,231,
0,82,66,6,127,0,128,7,225,16,6,224,7,216,0,130,34,6,100,193,
141,0,0,250,61,6,136,55,134,0,133,69,31,136,194,138,220,137,49,127,
1,0,15,119,0,0,14,6,130,255,218,53,15,63,1,0,0,74,29,112,
16,64,8,54,1,0,14,103,6,0,236,57,202,37,110,55,1,0,232,129,
138,37,197,13,66,95,0,0,65,122,15,95,0,0,65,18,65,122,65,130,
66,95,0,0,65,18,15,95,0,0,11,6,129,255,194,5,16,6,128,255,
230,237,66,95,0,0,65,122,15,143,0,0,65,18,65,122,65,130,66,143,
0,0,65,18,14,118,16,0,65,74,9,6,235,255,201,213,65,250,251,249,
134,197,32,86,127,0,133,13,66,87,0,0,65,18,66,87,0,0,65,18,
65,130,16,6,128,255,246,245,0,234,60,6,136,55,134,0,60,127,1,0,
127,122,154,13,29,64,38,6,112,121,133,0,32,62,164,5,190,255,100,217,
28,230,16,0,65,234,29,6,235,255,249,237,64,6,255,16,128,7,225,16,
6,232,61,127,16,0,60,6,100,193,141,0,193,122,220,121,15,111,0,0,
42,6,24,123,133,0,13,16,195,18,202,17,34,223,5,0,13,6,234,255,
166,13,61,71,16,0,32,62,33,5,38,6,132,121,133,0,190,255,20,217,
29,48,63,6,194,44,129,0,123,0,61,119,16,0,10,16,224,17,234,5,
14,86,1,0,125,87,16,0,149,61,28,142,1,0,193,114,209,113,14,223,
0,0,2,6,239,239,130,53,2,6,240,239,210,45,2,6,237,239,162,45,
27,6,131,255,234,29,61,135,16,0,65,130,125,135,16,0,133,37,61,127,
16,0,65,122,125,127,16,0,61,103,16,0,193,98,220,97,12,87,0,0,
10,6,129,255,170,13,61,71,16,0,32,62,68,5,38,6,132,121,133,0,
190,255,152,216,61,111,16,0,193,106,220,105,13,95,0,0,235,217,170,229,
0,18,2,80,64,6,255,16,128,7,225,240,6,224,60,143,14,0,17,6,
237,239,226,5,60,135,14,0,16,6,235,239,250,5,60,127,12,0,124,127,
14,0,128,7,102,1,0,218,60,207,12,0,28,232,61,119,14,0,251,113,
178,5,61,223,14,0,251,201,170,13,61,87,16,0,0,202,65,82,124,87,
16,0,124,223,14,0,213,5,61,239,9,0,224,233,202,237,0,210,28,16,
34,135,2,0,133,130,185,5,28,232,149,13,34,23,9,0,224,17,250,245,
28,16,213,45,61,239,9,0,61,103,9,0,224,97,186,253,61,199,29,0,
216,207,52,0,202,13,216,199,52,0,154,13,38,6,164,121,133,0,32,62,
119,4,0,66,190,255,224,215,29,48,128,255,58,6,216,207,52,0,146,13,
224,81,194,5,154,214,2,0,165,29,154,214,8,0,245,21,224,81,194,5,
154,214,4,0,165,21,154,214,16,0,245,13,34,95,2,0,134,90,225,5,
34,23,9,0,224,17,154,253,197,5,32,206,17,16,213,5,154,214,1,0,
224,201,242,77,0,114,47,6,136,55,134,0,15,16,34,103,1,0,34,87,
4,0,124,103,16,0,234,201,234,5,34,143,9,0,90,137,241,209,130,13,
2,22,16,0,65,114,14,6,235,255,233,237,197,5,14,6,235,255,185,5,
32,118,20,0,60,111,12,0,124,111,14,0,60,103,9,0,224,97,194,5,
60,239,9,0,165,5,28,232,196,114,207,113,46,215,13,0,26,135,0,0,
224,129,234,5,60,55,12,0,128,255,42,9,10,208,37,54,108,133,129,255,
92,140,60,55,12,0,29,56,191,255,168,225,26,56,38,6,152,121,133,0,
129,255,70,140,224,217,242,5,27,56,38,6,184,121,133,0,129,255,54,140,
124,7,12,0,64,6,255,240,128,7,225,48,6,224,0,234,224,225,146,37,
32,222,224,255,1,210,129,255,200,160,10,136,191,138,209,118,31,0,202,113,
91,113,174,81,26,16,234,23,192,0,92,17,178,245,0,82,43,6,200,123,
133,0,43,103,1,0,66,97,178,5,11,232,229,5,76,90,65,82,10,6,
240,255,233,245,29,80,64,6,255,48,128,7,97,0,229,87,64,0,224,7,
96,1,10,232,36,87,101,144,202,54,128,255,202,22,127,0,224,17,202,5,
224,49,170,29,213,29,224,49,130,21,36,159,137,136,211,86,1,0,178,5,
0,18,165,5,10,48,36,159,137,136,65,154,100,159,137,136,224,17,226,5,
1,138,96,143,173,179,100,23,77,143,224,49,178,5,128,255,198,4,253,47,
32,0,64,6,127,0,130,7,225,0,6,232,7,224,97,234,195,53,60,55,
5,0,37,62,116,133,129,255,174,140,224,81,138,29,99,234,210,5,38,6,
48,122,133,0,229,77,60,55,9,0,32,70,16,0,0,58,129,255,240,157,
10,232,29,56,38,6,80,122,133,0,129,255,56,139,100,239,101,144,197,29,
60,55,5,0,37,62,112,133,129,255,112,140,224,81,154,13,38,6,124,122,
133,0,129,255,24,139,100,7,101,144,213,5,38,6,4,122,133,0,149,45,
97,234,234,5,38,6,152,122,133,0,129,255,252,138,0,226,61,6,200,123,
133,0,61,63,1,0,36,143,101,144,40,6,36,122,133,0,71,137,194,5,
40,6,24,122,133,0,61,119,9,0,61,79,4,0,38,6,180,122,133,0,
99,119,1,0,129,255,198,138,76,234,65,226,28,6,240,255,217,229,181,5,
129,255,182,138,66,6,255,0,128,7,225,0,6,232,61,55,12,0,7,224,
29,56,191,255,246,223,61,55,12,0,128,255,92,7,28,56,10,64,38,6,
216,122,133,0,129,255,138,138,29,48,191,255,186,250,29,48,191,255,94,250,
32,54,60,0,128,255,52,249,64,6,255,0,130,7,33,0,99,55,1,0,
38,135,12,0,0,66,38,6,88,146,145,0,3,56,16,6,237,239,202,5,
129,255,240,80,181,5,129,255,250,71,224,81,146,13,38,6,240,122,133,0,
32,62,109,3,0,66,190,255,250,212,32,54,12,177,32,62,0,8,0,66,
190,255,252,245,66,6,63,0,130,7,225,0,99,55,1,0,6,80,10,16,
34,143,2,0,134,138,185,5,1,18,213,5,34,23,9,0,224,17,250,245,
2,232,224,233,234,29,42,111,12,0,10,16,13,6,252,253,218,13,34,103,
2,0,135,98,185,5,1,18,213,5,34,23,9,0,224,17,250,245,2,232,
197,13,34,135,2,0,136,130,185,5,1,18,213,5,34,23,9,0,224,17,
250,245,2,232,234,103,19,0,224,97,154,13,38,6,44,114,133,0,32,62,
63,3,0,66,190,255,112,212,0,58,35,55,1,0,1,18,38,95,18,0,
2,136,231,143,192,0,75,137,209,0,224,137,218,5,65,58,7,6,240,255,
198,245,7,224,224,233,242,5,191,255,212,254,28,48,128,255,230,1,181,53,
38,119,12,0,224,113,154,13,38,6,4,123,133,0,32,62,49,3,0,66,
190,255,36,212,35,23,1,0,34,111,12,0,13,6,252,253,138,13,194,23,
2,0,1,50,252,55,192,0,128,255,144,2,3,56,38,6,32,146,145,0,
0,66,129,255,214,79,224,81,146,13,38,6,4,123,133,0,32,62,63,3,
0,66,190,255,230,211,32,54,12,177,32,62,0,4,0,66,190,255,232,244,
66,6,255,0,130,7,33,0,3,56,38,6,88,146,145,0,0,66,129,255,
126,76,106,82,146,21,191,255,250,220,35,55,1,0,191,255,54,251,35,55,
1,0,191,255,90,250,224,81,178,253,191,255,20,221,1,82,165,5,0,82,
66,6,63,0,130,7,33,0,3,56,38,6,32,146,145,0,0,66,129,255,
66,76,106,82,162,29,191,255,36,221,35,55,1,0,191,255,250,250,35,55,
1,0,191,255,30,250,224,81,178,253,191,255,62,221,36,143,173,136,97,138,
234,5,100,7,173,136,1,50,129,255,136,88,1,82,165,5,0,82,66,6,
63,0,128,7,225,0,61,6,100,194,141,0,100,7,177,136,100,7,181,136,
191,255,12,221,191,255,162,220,4,135,233,135,16,230,255,255,28,48,191,255,
206,15,100,87,173,142,125,7,1,0,125,7,5,0,125,87,9,0,125,87,
13,0,4,95,128,142,201,226,125,231,17,0,38,6,116,54,134,0,224,89,
194,5,38,6,80,55,134,0,14,58,191,255,184,248,4,87,124,142,99,82,
178,5,100,7,101,144,64,6,255,0,128,7,33,0,6,96,7,48,8,56,
9,120,35,111,5,0,143,0,15,64,44,103,1,0,141,0,13,72,63,6,
18,51,129,0,108,0,64,6,63,0,128,7,33,0,6,120,7,48,8,56,
35,87,5,0,9,128,47,127,1,0,16,64,10,72,63,6,54,51,129,0,
111,0,64,6,63,0,128,7,33,0,6,120,7,48,8,56,47,127,1,0,
9,128,16,64,63,6,84,51,129,0,111,0,64,6,63,0,33,6,132,54,
1,0,97,0,33,6,26,23,0,0,97,0,33,6,106,52,1,0,97,0,
33,6,110,94,1,0,97,0,33,6,102,173,1,0,97,0,33,6,198,99,
1,0,97,0,33,6,90,17,0,0,97,0,33,6,152,53,1,0,97,0,
33,6,232,123,1,0,97,0,33,6,158,26,0,0,97,0,33,6,200,172,
1,0,97,0,33,6,250,168,1,0,97,0,33,6,170,96,1,0,97,0,
33,6,40,74,1,0,97,0,33,6,214,17,0,0,97,0,33,6,2,173,
1,0,97,0,33,6,144,100,1,0,97,0,33,6,246,155,1,0,97,0,
33,6,210,97,1,0,97,0,33,6,82,51,1,0,97,0,33,6,52,95,
0,0,97,0,33,6,230,50,1,0,97,0,33,6,38,101,1,0,97,0,
33,6,136,155,1,0,97,0,33,6,166,154,1,0,97,0,33,6,26,155,
1,0,97,0,33,6,18,53,1,0,97,0,33,6,226,38,1,0,97,0,
33,6,238,52,1,0,97,0,33,6,12,96,1,0,97,0,33,6,224,69,
1,0,97,0,33,6,182,95,1,0,97,0,128,7,97,0,6,232,194,234,
47,6,120,194,141,0,207,233,61,55,1,0,129,255,232,114,125,7,1,0,
64,6,127,0,136,7,97,0,230,0,61,6,216,56,134,0,0,18,61,71,
0,0,232,49,202,29,189,127,3,0,61,63,9,0,29,79,2,0,99,127,
1,0,157,119,5,0,99,119,5,0,29,111,5,0,99,111,9,0,29,103,
6,0,38,6,188,157,133,0,99,103,13,0,129,255,74,134,29,80,213,13,
76,234,65,18,2,6,209,254,217,221,6,56,38,6,152,157,133,0,129,255,
48,134,0,82,72,6,127,0,3,30,196,255,99,79,57,0,99,255,41,0,
99,207,33,0,99,215,29,0,99,223,25,0,99,239,17,0,99,231,21,0,
6,224,99,199,37,0,7,192,99,71,53,0,229,87,64,0,224,7,96,1,
10,200,35,22,52,0,99,23,9,0,35,22,44,0,194,226,64,134,142,0,
48,214,120,194,220,209,58,239,1,0,194,22,7,0,99,23,13,0,0,218,
224,233,210,13,29,16,65,18,2,127,255,255,224,121,202,253,189,17,2,222,
255,255,219,233,162,85,149,21,32,54,98,0,129,255,220,113,10,232,122,239,
1,0,224,233,130,77,29,48,0,58,32,70,98,0,190,255,116,204,197,5,
27,6,158,255,238,61,32,54,196,0,129,255,182,113,10,208,224,209,242,53,
35,22,8,0,34,95,1,0,99,95,1,0,34,23,5,0,35,71,1,0,
99,23,5,0,35,79,5,0,26,48,24,56,129,255,52,123,32,86,98,0,
187,81,226,21,29,16,26,96,65,98,12,95,255,255,65,18,224,89,66,95,
255,255,186,5,95,18,181,5,95,82,218,245,224,81,226,5,66,7,0,0,
65,18,95,82,202,253,48,6,120,194,141,0,208,225,60,239,1,0,26,48,
93,7,97,0,129,255,96,113,249,47,32,0,35,199,37,0,35,207,33,0,
35,215,29,0,35,223,25,0,35,231,21,0,35,239,17,0,35,255,41,0,
3,30,60,0,127,0,3,30,228,255,99,79,25,0,99,255,9,0,99,231,
5,0,99,239,1,0,6,232,7,224,99,71,21,0,181,5,61,239,9,0,
61,143,9,0,224,137,186,253,29,48,191,255,222,253,224,81,130,13,61,135,
24,0,28,56,208,54,255,127,191,255,132,254,35,231,5,0,35,239,1,0,
35,255,9,0,3,30,28,0,127,0,128,7,225,240,6,224,7,232,253,0,
8,208,9,192,29,48,191,255,246,253,10,216,124,239,22,0,28,48,0,58,
32,70,18,0,190,255,82,203,224,217,194,29,27,135,6,0,28,23,25,0,
187,87,5,0,92,135,0,0,27,127,2,0,202,86,7,0,194,22,248,0,
92,127,2,0,187,119,3,0,10,17,92,119,12,0,155,111,5,0,92,23,
25,0,92,111,13,0,60,54,26,0,0,58,32,70,98,0,190,255,10,203,
0,234,224,209,242,13,26,16,65,18,2,103,255,255,224,97,202,253,186,17,
2,238,255,255,29,6,158,255,182,5,32,238,97,0,60,206,26,0,25,48,
26,56,29,64,190,255,124,201,29,136,217,137,81,7,0,0,224,209,202,5,
58,6,8,158,133,0,26,56,37,54,124,133,129,255,222,131,59,63,9,0,
65,234,221,201,29,214,26,0,7,16,65,18,2,119,255,255,224,113,202,253,
32,86,97,0,189,81,167,17,2,94,255,255,234,89,185,13,7,16,65,18,
2,143,255,255,224,137,202,253,167,17,2,238,255,255,165,5,10,232,25,48,
29,64,190,255,26,201,29,112,217,113,78,7,0,0,65,234,221,209,248,209,
167,5,24,208,26,110,248,255,92,111,7,0,64,6,255,240,128,7,97,0,
8,232,29,136,194,138,46,6,120,194,141,0,206,137,49,71,1,0,231,0,
191,255,202,254,29,96,194,98,49,6,120,194,141,0,209,97,44,135,1,0,
224,129,194,5,29,48,191,255,150,252,64,6,127,0,230,0,42,6,36,158,
133,0,34,6,216,56,134,0,2,94,52,14,34,135,0,0,240,49,202,5,
34,87,9,0,197,5,76,18,235,17,241,245,127,0,36,143,177,142,65,138,
100,143,177,142,17,6,156,255,186,5,100,7,177,142,36,135,176,142,240,86,
28,0,46,6,120,198,141,0,206,81,127,0,230,134,28,0,47,6,120,198,
141,0,207,129,48,87,25,0,32,118,224,255,78,81,127,0,230,134,28,0,
47,6,120,198,141,0,0,82,207,129,48,118,12,0,103,119,1,0,127,0,
132,7,225,243,6,216,7,200,185,0,8,208,250,0,191,255,156,255,36,199,
245,178,10,232,93,207,8,0,93,223,9,0,125,199,5,0,27,48,128,255,
76,1,36,191,177,142,10,224,125,231,1,0,25,6,191,255,23,176,202,77,
34,6,0,0,32,0,226,135,5,0,125,135,12,0,226,127,1,0,26,6,
233,253,125,127,14,0,138,21,226,111,85,0,226,103,87,0,128,143,105,177,
208,98,13,97,125,103,25,0,224,137,194,21,32,214,22,2,149,21,26,6,
234,253,170,13,226,127,81,0,226,119,83,0,208,114,15,113,125,119,25,0,
213,5,31,90,125,95,25,0,245,29,60,6,104,209,141,0,60,87,12,0,
224,81,250,21,60,143,14,0,224,137,186,21,124,7,9,0,124,7,12,0,
124,7,14,0,124,7,16,0,124,7,2,0,124,7,18,0,27,6,240,255,
214,5,220,63,19,0,165,5,0,226,25,6,190,255,202,53,32,126,67,0,
93,127,8,0,27,48,3,56,128,255,150,0,227,23,5,0,125,23,24,0,
227,23,7,0,27,48,61,70,12,0,1,58,125,23,26,0,128,255,130,0,
191,255,166,254,227,23,1,0,32,118,68,0,10,232,93,119,8,0,125,23,
24,0,227,23,3,0,125,199,5,0,93,223,9,0,125,231,1,0,125,23,
26,0,36,183,177,142,27,48,61,70,12,0,0,58,128,255,72,0,125,215,
10,0,224,225,194,21,28,48,26,56,191,255,214,249,27,6,240,255,145,13,
252,143,19,0,1,90,251,95,192,0,11,137,124,143,18,0,124,191,28,0,
124,183,30,0,28,80,68,6,255,243,33,6,150,97,1,0,97,0,33,6,
208,25,0,0,97,0,33,6,8,26,0,0,97,0,38,23,1,0,2,80,
127,0,38,23,5,0,2,80,127,0,38,23,13,0,2,80,127,0,34,6,
0,192,23,0,2,80,127,0,128,7,225,16,6,232,0,226,229,87,64,0,
224,7,96,1,10,216,61,143,21,0,128,134,170,170,113,135,0,0,61,127,
25,0,32,118,85,85,111,119,0,0,61,111,21,0,128,102,144,144,109,103,
0,0,32,54,32,78,129,255,54,13,61,95,1,0,235,87,1,0,10,136,
208,138,61,135,29,0,240,127,1,0,15,224,17,225,61,119,21,0,128,110,
170,170,110,111,0,0,61,103,25,0,32,94,85,85,108,95,0,0,61,87,
21,0,128,142,240,240,106,143,0,0,32,54,32,78,129,255,242,12,251,47,
32,0,48,6,186,186,31,31,240,225,186,5,0,18,181,5,32,22,192,1,
2,80,64,6,255,16,190,7,225,241,3,30,124,254,6,232,7,208,8,192,
9,200,35,142,0,0,64,134,0,64,17,216,16,217,61,127,1,0,239,209,
161,13,25,112,218,113,61,111,5,0,61,103,1,0,204,105,237,113,195,5,
32,22,193,1,149,85,26,88,61,87,1,0,11,136,170,137,17,16,61,135,
9,0,240,23,194,2,2,184,165,69,61,127,1,0,15,112,23,104,61,103,
9,0,13,88,236,95,34,2,11,96,12,224,206,225,29,48,28,56,27,64,
128,255,226,0,0,74,28,16,165,21,250,17,234,13,224,201,194,13,9,80,
219,81,65,194,24,142,255,255,17,135,0,0,74,135,0,0,95,202,65,210,
65,18,65,74,61,119,9,0,14,120,129,122,15,96,193,98,12,104,13,88,
220,89,235,17,209,229,29,48,28,56,27,64,128,255,44,0,29,48,28,56,
27,64,128,255,184,0,10,16,224,17,194,5,32,22,194,1,213,5,65,186,
224,201,234,189,0,18,2,80,3,30,132,1,126,6,255,241,128,7,225,16,
6,248,7,232,8,224,229,87,64,0,224,7,96,1,10,216,63,143,21,0,
128,134,170,170,113,135,0,0,63,127,25,0,32,118,85,85,111,119,0,0,
63,111,21,0,128,102,160,160,109,103,0,0,0,18,197,13,66,234,29,94,
254,255,66,226,28,86,254,255,234,143,1,0,107,143,0,0,65,18,63,127,
9,0,15,128,129,130,240,17,129,245,32,54,32,78,129,255,138,11,251,47,
32,0,64,6,255,16,0,18,197,13,66,66,8,142,254,255,66,58,7,134,
254,255,240,127,1,0,113,127,0,0,65,18,38,111,9,0,13,112,129,114,
238,17,129,245,127,0,0,18,149,21,66,66,8,142,254,255,241,135,1,0,
66,58,7,126,254,255,239,119,1,0,238,129,194,5,32,22,194,1,165,13,
65,18,2,104,38,95,9,0,11,96,129,98,236,105,161,237,0,18,2,80,
127,0,38,23,1,0,2,80,127,0,38,23,5,0,2,80,127,0,38,23,
13,0,2,80,127,0,34,6,0,192,23,0,2,80,127,0,128,7,225,16,
6,232,0,226,229,87,64,0,224,7,96,1,10,216,61,143,21,0,128,134,
170,170,113,135,0,0,61,127,25,0,32,118,85,85,111,119,0,0,61,111,
21,0,128,102,144,144,109,103,0,0,32,54,32,78,129,255,194,10,61,95,
1,0,235,87,1,0,10,136,208,138,61,135,29,0,240,127,1,0,15,224,
17,225,61,119,21,0,128,110,170,170,110,111,0,0,61,103,25,0,32,94,
85,85,108,95,0,0,61,87,21,0,128,142,240,240,106,143,0,0,32,54,
32,78,129,255,126,10,251,47,32,0,48,6,186,186,31,31,240,225,186,5,
0,18,181,5,32,22,192,1,2,80,64,6,255,16,190,7,225,241,3,30,
124,254,6,232,7,224,8,216,9,208,35,142,0,0,64,134,0,64,17,200,
16,201,61,127,1,0,239,225,161,13,26,112,220,113,61,111,5,0,61,103,
1,0,204,105,237,113,195,5,32,22,193,1,133,101,28,88,61,87,1,0,
11,136,170,137,17,16,61,135,9,0,240,23,194,2,2,184,149,85,61,127,
1,0,15,112,23,104,61,103,9,0,13,88,236,95,34,2,11,96,12,192,
206,193,29,48,24,56,25,64,128,255,32,1,0,18,24,72,149,37,252,73,
218,29,224,209,178,29,2,80,217,81,65,218,27,142,255,255,17,135,0,0,
74,135,0,0,95,210,65,226,224,209,226,13,2,126,1,0,15,112,217,113,
65,218,27,110,255,255,13,103,0,0,78,103,0,0,95,210,65,226,66,74,
68,18,61,87,9,0,10,88,129,90,11,128,193,130,16,136,17,120,216,121,
239,73,225,213,29,48,24,56,25,64,128,255,44,0,29,48,24,56,25,64,
128,255,248,0,10,16,224,17,194,5,32,22,194,1,213,5,65,186,224,209,
250,173,0,18,2,80,3,30,132,1,126,6,255,241,128,7,225,48,6,224,
7,216,8,248,60,135,5,0,16,136,129,138,17,232,59,233,229,87,64,0,
224,7,96,1,10,208,60,127,21,0,128,118,170,170,111,119,0,0,60,111,
25,0,32,102,85,85,109,103,0,0,60,95,21,0,128,86,160,160,107,87,
0,0,0,18,229,21,66,218,27,142,254,255,66,250,31,134,254,255,240,127,
1,0,113,127,0,0,66,234,29,118,254,255,66,250,31,110,254,255,237,103,
1,0,110,103,0,0,65,18,60,87,9,0,10,88,129,90,235,17,225,229,
32,54,32,78,129,255,216,8,250,47,32,0,64,6,255,48,38,135,5,0,
16,136,129,138,17,16,39,17,0,74,229,21,66,66,8,126,254,255,66,58,
7,118,254,255,238,111,1,0,111,111,0,0,66,66,8,102,254,255,66,18,
2,94,254,255,235,87,1,0,108,87,0,0,65,74,38,135,9,0,16,136,
129,138,241,73,225,229,127,0,38,135,5,0,16,136,129,138,17,16,39,17,
0,74,133,37,66,66,8,126,254,255,239,119,1,0,66,58,7,110,254,255,
237,103,1,0,236,113,194,5,32,22,194,1,149,29,66,66,8,94,254,255,
235,87,1,0,66,18,2,142,254,255,241,135,1,0,240,81,194,5,32,22,
194,1,165,13,65,74,9,120,38,111,9,0,13,112,129,114,238,121,177,221,
0,18,2,80,127,0,128,7,33,0,224,49,138,13,32,54,40,0,129,255,
72,102,10,48,224,49,226,37,48,6,76,72,134,0,102,135,17,0,64,126,
16,0,102,127,5,0,32,118,0,64,102,119,13,0,102,127,1,0,44,6,
170,10,16,0,102,103,21,0,43,6,84,5,16,0,102,95,25,0,102,127,
29,0,47,6,2,0,16,0,102,127,33,0,48,6,91,34,1,0,102,135,
37,0,6,80,64,6,63,0,128,7,97,0,6,232,224,233,138,13,32,54,
40,0,129,255,224,101,10,232,224,233,242,37,29,48,191,255,128,255,64,142,
16,0,125,143,5,0,32,134,0,64,125,135,13,0,125,143,1,0,46,6,
170,170,16,0,125,119,21,0,44,6,84,85,16,0,125,103,25,0,43,6,
0,2,16,0,125,95,29,0,49,6,2,0,16,0,125,143,33,0,49,6,
91,34,28,0,125,143,37,0,29,80,64,6,127,0,128,7,97,0,6,232,
224,233,138,13,32,54,40,0,129,255,118,101,10,232,224,233,194,37,29,48,
191,255,22,255,64,142,16,0,125,143,5,0,32,134,0,64,125,135,13,0,
125,143,1,0,46,6,170,170,16,0,125,119,21,0,44,6,84,85,16,0,
125,103,25,0,125,143,29,0,49,6,2,0,16,0,125,143,33,0,49,6,
91,34,194,0,125,143,37,0,29,80,64,6,127,0,128,7,97,0,6,232,
224,233,138,13,32,54,40,0,129,255,18,101,10,232,224,233,194,37,29,48,
191,255,178,254,64,142,16,0,125,143,5,0,32,134,0,64,125,135,13,0,
125,143,1,0,46,6,170,170,16,0,125,119,21,0,44,6,84,85,16,0,
125,103,25,0,125,143,29,0,49,6,2,0,16,0,125,143,33,0,49,6,
91,34,32,0,125,143,37,0,29,80,64,6,127,0,128,7,97,0,6,232,
224,233,138,13,32,54,40,0,129,255,174,100,10,232,224,233,194,37,29,48,
191,255,78,254,64,142,16,0,125,143,5,0,32,134,0,64,125,135,13,0,
125,143,1,0,46,6,170,170,16,0,125,119,21,0,44,6,84,85,16,0,
125,103,25,0,125,143,29,0,49,6,2,0,16,0,125,143,33,0,49,6,
91,0,32,0,125,143,37,0,29,80,64,6,127,0,0,18,213,13,232,143,
1,0,231,135,1,0,66,66,66,58,240,137,194,5,32,86,194,1,165,13,
65,18,9,112,159,114,9,96,206,97,161,98,236,17,230,237,0,82,127,0,
0,18,133,13,231,143,1,0,66,58,65,18,104,143,0,0,66,66,9,120,
159,122,9,104,207,105,161,106,237,17,177,245,127,0,128,7,193,0,6,232,
9,224,34,6,240,255,31,0,0,74,229,69,231,143,1,0,232,135,1,0,
240,137,202,5,66,58,66,66,197,61,61,127,21,0,32,118,170,0,111,119,
0,0,61,111,25,0,32,102,85,0,109,103,0,0,61,95,21,0,32,86,
160,0,107,87,0,0,66,58,7,142,254,255,66,66,8,134,254,255,240,127,
1,0,113,127,0,0,226,127,1,0,226,55,1,0,207,118,32,0,224,113,
130,21,226,127,1,0,226,55,1,0,15,104,205,102,64,0,6,88,203,86,
64,0,234,97,194,5,32,22,205,1,197,21,15,136,209,134,64,0,6,120,
207,118,64,0,238,129,170,229,65,74,28,104,13,96,159,98,28,88,204,89,
11,80,161,82,234,73,177,181,0,18,2,80,64,6,223,0,34,6,240,255,
31,0,38,143,21,0,32,134,170,0,113,135,0,0,38,127,25,0,32,118,
85,0,111,119,0,0,38,111,21,0,32,102,128,0,109,103,0,0,38,95,
21,0,32,86,170,0,107,87,0,0,38,143,25,0,32,134,85,0,113,135,
0,0,32,126,48,0,103,127,0,0,226,127,1,0,226,79,1,0,207,118,
32,0,224,113,130,21,226,127,1,0,226,79,1,0,15,104,205,102,64,0,
9,88,203,86,64,0,234,97,194,5,32,22,206,1,165,13,15,136,209,134,
64,0,9,120,207,118,64,0,238,129,170,229,0,18,2,80,127,0,38,87,
1,0,127,0,34,6,60,158,133,0,34,135,5,0,34,87,9,0,208,81,
202,82,127,0,38,87,13,0,127,0,38,87,5,0,127,0,38,87,1,0,
127,0,128,7,193,16,6,224,229,87,64,0,224,7,96,1,60,23,21,0,
60,103,29,0,32,142,170,0,60,135,25,0,98,143,0,0,32,126,85,0,
32,118,144,0,112,127,0,0,60,239,33,0,98,119,0,0,44,103,0,0,
10,216,253,239,1,0,32,118,240,0,204,94,255,0,208,90,11,233,98,119,
0,0,251,47,32,0,60,111,37,0,32,86,192,1,237,233,170,5,0,82,
64,6,223,16,134,7,225,243,8,216,6,184,55,23,1,0,9,232,0,194,
7,224,226,225,129,13,55,135,5,0,29,136,220,137,194,129,240,137,195,5,
32,86,193,1,149,117,64,54,1,0,129,255,166,99,10,176,99,183,9,0,
224,177,202,5,32,86,21,1,213,101,55,215,1,0,0,82,44,6,60,158,
133,0,12,88,43,23,1,0,202,18,218,17,226,225,241,5,2,208,68,90,
65,82,10,6,180,255,217,245,99,87,5,0,194,82,99,87,1,0,149,69,
51,207,1,0,23,48,26,56,22,64,202,202,25,72,191,255,134,253,35,23,
9,0,28,88,28,96,186,97,204,17,25,104,218,105,181,13,27,87,0,0,
65,218,95,234,65,226,65,90,66,87,0,0,65,18,65,98,237,89,185,5,
224,233,186,245,23,48,26,56,191,255,40,254,10,192,224,193,154,37,23,48,
26,56,22,64,25,72,191,255,96,253,10,192,224,193,138,29,23,48,26,56,
22,64,25,72,191,255,254,252,10,192,224,193,250,13,35,159,5,0,4,98,
217,209,65,154,99,159,5,0,35,159,1,0,204,153,99,159,1,0,224,233,
170,189,22,48,129,255,236,98,24,80,70,6,255,243,64,14,142,0,65,7,
176,209,38,6,140,72,134,0,129,7,80,91,38,23,1,0,226,127,11,0,
34,87,13,0,193,122,175,81,127,0,128,7,225,0,8,232,38,143,4,0,
9,224,124,7,1,0,125,7,1,0,224,137,170,21,38,23,33,0,224,57,
202,13,124,23,1,0,191,255,202,255,60,23,1,0,162,81,125,87,1,0,
0,82,133,69,224,17,202,5,32,86,203,1,181,61,97,58,218,5,125,23,
1,0,0,82,213,53,38,23,1,0,32,78,204,1,32,110,16,0,2,22,
24,0,245,37,130,119,17,0,2,22,16,0,238,57,250,29,34,102,1,0,
194,114,78,118,134,0,46,95,153,72,7,114,139,135,1,0,140,87,1,0,
65,90,65,98,144,81,250,13,224,129,178,5,95,114,218,245,34,127,9,0,
124,127,1,0,34,119,13,0,0,74,125,119,1,0,245,5,13,110,16,0,
38,103,33,0,236,105,241,213,9,80,64,6,255,0,38,87,13,0,230,135,
11,0,198,81,176,81,127,0,128,7,97,0,6,232,61,135,1,0,48,135,
13,0,208,6,3,0,146,13,38,6,136,158,133,0,32,62,74,4,0,66,
190,255,76,192,61,111,1,0,205,118,3,0,146,13,38,6,136,158,133,0,
32,62,75,4,0,66,190,255,50,192,61,23,1,0,2,126,24,0,226,87,
11,0,34,23,13,0,0,106,0,98,193,82,170,17,130,18,194,18,207,17,
47,71,1,0,200,97,225,79,0,0,201,105,68,122,226,121,129,253,205,97,
12,80,64,6,127,0,128,7,33,0,36,87,193,142,6,88,7,96,42,23,
17,0,11,56,8,72,34,135,8,0,34,127,13,0,12,64,63,6,252,69,
129,0,16,48,202,49,111,0,64,6,63,0,140,7,97,0,6,232,61,23,
1,0,224,17,202,5,32,86,198,1,213,69,34,127,1,0,99,127,1,0,
34,119,5,0,99,119,5,0,34,111,9,0,99,111,9,0,34,103,13,0,
99,103,13,0,34,95,17,0,205,134,255,255,99,95,17,0,34,87,21,0,
98,130,99,87,21,0,210,13,99,130,178,13,61,63,1,0,38,6,152,158,
133,0,129,255,172,116,32,86,201,1,213,29,29,48,191,255,246,254,99,87,
17,0,227,71,11,0,61,55,1,0,3,122,99,127,8,0,3,56,191,255,
84,255,224,81,186,13,61,55,1,0,191,255,196,254,227,71,11,0,3,56,
10,48,191,255,60,255,0,82,76,6,127,0,128,7,97,0,6,232,61,23,
1,0,49,6,64,48,32,16,241,17,226,5,48,6,128,112,96,80,240,17,
218,21,29,48,191,255,142,254,253,23,11,0,10,88,224,17,130,21,157,87,
1,0,139,119,1,0,65,234,65,90,174,81,186,5,95,18,250,245,224,81,
194,5,32,86,202,1,165,5,0,82,64,6,127,0,128,7,225,48,7,216,
8,208,6,232,213,21,61,135,1,0,49,6,64,48,32,16,241,129,218,13,
29,224,28,48,191,255,144,255,224,81,250,5,60,127,5,0,239,209,186,5,
28,80,213,5,68,234,251,233,177,237,0,82,64,6,255,48,38,87,21,0,
198,81,127,0,128,7,225,240,36,239,197,142,29,80,29,208,224,81,194,109,
6,224,0,218,229,101,61,135,1,0,60,143,1,0,241,129,250,5,61,119,
5,0,60,127,5,0,239,113,194,93,61,111,21,0,224,105,194,5,65,218,
106,218,167,61,196,199,97,144,0,234,154,85,36,87,193,142,42,23,17,0,
34,95,24,0,11,48,202,49,34,87,29,0,63,6,152,71,129,0,106,0,
36,95,193,142,10,200,43,87,17,0,42,135,24,0,10,238,32,0,42,127,
29,0,63,6,186,71,129,0,16,48,203,49,111,0,61,111,0,0,36,55,
193,142,10,192,61,95,5,0,13,96,204,49,63,6,212,71,129,0,107,0,
60,71,5,0,10,56,216,57,25,48,191,255,20,255,10,232,165,29,29,48,
191,255,72,255,10,232,250,233,161,21,36,87,193,142,42,23,17,0,34,143,
32,0,34,135,37,0,63,6,14,72,129,0,17,48,202,49,112,0,218,81,
234,233,179,5,0,234,181,5,224,233,170,157,29,80,64,6,255,240,136,7,
225,240,7,192,6,232,61,87,4,0,8,200,9,216,35,215,45,0,224,81,
178,5,128,7,102,1,64,134,142,0,48,230,144,209,99,231,9,0,1,122,
67,127,12,0,28,48,31,58,190,255,220,189,224,81,186,253,60,6,196,158,
133,0,29,48,26,56,35,70,4,0,3,72,191,255,42,252,224,81,242,21,
131,111,13,0,10,232,224,105,242,13,35,55,9,0,67,7,12,0,190,255,
90,222,224,81,242,5,28,48,32,62,178,1,0,66,190,255,50,189,29,80,
128,7,4,1,35,87,5,0,27,88,217,89,234,89,195,21,131,143,13,0,
224,137,146,53,35,55,9,0,67,7,12,0,190,255,36,222,224,81,146,45,
28,48,32,62,178,1,0,66,190,255,252,188,165,37,35,135,1,0,61,215,
1,0,208,217,250,95,11,0,58,143,13,0,27,112,217,113,193,90,171,137,
241,113,227,21,131,135,13,0,224,129,242,13,35,55,9,0,67,7,12,0,
190,255,224,221,224,81,242,5,28,48,32,62,178,1,0,66,190,255,184,188,
32,86,199,1,197,69,29,48,191,255,64,252,58,23,17,0,234,17,146,37,
61,119,1,0,238,119,9,0,99,114,186,29,131,103,13,0,32,110,200,1,
125,111,4,0,32,238,200,1,224,97,242,13,35,55,9,0,67,7,12,0,
190,255,144,221,224,81,242,5,28,48,32,62,178,1,0,66,190,255,104,188,
29,80,213,29,61,95,1,0,24,48,25,64,11,62,24,0,219,57,190,255,
18,183,131,143,13,0,224,137,242,13,35,55,9,0,67,7,12,0,190,255,
86,221,224,81,242,5,28,48,32,62,178,1,0,66,190,255,46,188,0,82,
72,6,255,240,138,7,225,112,6,232,7,224,224,233,170,13,32,54,36,0,
129,255,226,91,10,232,224,233,186,5,128,7,44,1,125,231,13,0,34,6,
64,48,32,16,49,6,136,119,102,85,241,225,202,5,34,6,128,112,96,80,
125,23,9,0,61,54,8,0,191,255,84,253,125,87,1,0,125,7,33,0,
10,56,7,16,224,17,178,21,231,127,9,0,98,122,210,13,99,122,178,13,
38,6,208,158,133,0,129,255,252,112,32,118,201,1,125,119,4,0,165,109,
0,106,213,5,125,23,1,0,32,110,198,1,125,111,4,0,237,0,224,105,
250,93,29,48,35,62,4,0,99,7,1,0,32,70,16,0,0,74,191,255,
228,253,224,81,186,85,35,223,17,0,131,215,5,0,27,224,97,210,202,77,
35,87,13,0,224,81,138,77,29,48,191,255,38,250,234,225,185,69,57,6,
152,72,134,0,194,210,217,209,58,23,1,0,35,86,5,0,7,90,130,103,
1,0,138,119,1,0,65,18,65,82,140,113,154,53,224,97,178,5,95,90,
218,245,27,78,240,255,29,48,35,62,4,0,99,7,1,0,32,70,16,0,
191,255,126,253,131,119,5,0,98,114,234,29,35,135,13,0,252,129,170,29,
35,127,17,0,224,121,234,21,194,114,217,113,46,23,1,0,35,102,5,0,
7,106,130,143,1,0,140,95,1,0,65,18,65,98,145,89,250,5,224,137,
178,5,95,106,218,245,125,231,33,0,29,80,74,6,255,112,128,7,225,16,
7,216,6,232,149,21,61,135,1,0,49,6,64,48,32,16,241,129,154,13,
29,224,28,48,191,255,148,251,224,81,186,5,28,80,213,5,68,234,251,233,
241,237,0,82,64,6,255,16,134,7,225,16,36,87,193,142,42,23,17,0,
34,135,24,0,34,127,29,0,0,226,63,6,70,75,129,0,16,48,202,49,
111,0,10,216,38,6,168,159,133,0,129,255,184,111,36,239,197,142,224,233,
154,13,38,6,204,159,133,0,129,255,166,111,32,86,202,1,149,125,0,226,
38,6,92,160,133,0,129,255,148,111,38,6,252,158,133,0,129,255,138,111,
61,23,13,0,29,72,61,63,1,0,61,71,5,0,99,23,1,0,99,23,
5,0,38,6,236,159,133,0,129,255,106,111,29,48,191,255,254,250,224,81,
162,77,38,6,20,160,133,0,129,255,86,111,36,87,193,142,42,23,17,0,
34,111,32,0,34,103,37,0,99,7,9,0,63,6,212,75,129,0,13,48,
202,49,108,0,10,56,219,57,29,48,191,255,22,255,10,232,224,233,194,13,
224,233,242,13,38,6,92,159,133,0,129,255,24,111,188,233,99,239,9,0,
229,5,38,6,52,159,133,0,129,255,6,111,28,232,60,54,20,0,35,62,
8,0,4,66,191,255,194,249,28,48,191,255,56,249,42,54,20,0,35,62,
8,0,4,66,191,255,174,249,10,224,224,81,130,13,38,6,72,160,133,0,
129,255,210,110,28,80,133,21,29,224,29,48,191,255,240,250,60,143,21,0,
10,232,224,137,170,157,38,6,128,159,133,0,129,255,178,110,0,82,70,6,
255,16,128,7,225,48,36,87,193,142,42,23,17,0,34,135,24,0,34,127,
29,0,63,6,126,76,129,0,16,48,202,49,111,0,10,232,36,87,193,142,
42,23,17,0,34,111,56,0,34,103,61,0,63,6,156,76,129,0,13,48,
202,49,108,0,234,233,202,85,36,95,193,142,43,23,17,0,34,87,24,0,
2,238,40,0,34,143,29,0,63,6,192,76,129,0,10,48,203,49,113,0,
61,127,0,0,36,55,193,142,10,216,61,111,5,0,15,112,206,49,63,6,
218,76,129,0,109,0,10,224,36,87,193,142,42,23,17,0,34,95,24,0,
219,225,11,48,202,49,34,87,29,0,2,222,48,0,2,238,40,0,63,6,
2,77,129,0,106,0,61,135,0,0,36,55,193,142,10,208,61,119,5,0,
16,120,207,49,63,6,28,77,129,0,110,0,59,103,0,0,10,232,218,233,
36,55,193,142,59,87,5,0,12,88,63,6,56,77,129,0,203,49,106,0,
28,48,221,81,10,62,8,0,191,255,176,253,10,232,100,239,197,142,64,6,
255,48,156,7,225,112,6,200,57,239,1,0,64,142,142,0,49,230,144,209,
99,231,25,0,1,130,67,135,28,0,28,48,31,58,190,255,194,184,224,81,
186,253,196,199,97,144,250,13,191,255,168,253,224,81,186,13,196,7,97,144,
37,62,208,133,32,54,64,0,190,255,8,186,191,255,202,254,59,6,176,160,
133,0,29,48,191,255,152,249,10,232,224,233,250,21,131,127,29,0,224,121,
242,13,35,55,25,0,67,7,28,0,190,255,38,217,224,81,242,5,27,48,
32,62,178,1,0,66,190,255,254,183,32,86,198,1,128,7,254,1,61,23,
5,0,46,6,68,51,34,17,238,17,242,5,36,231,197,142,60,111,5,0,
237,17,218,69,61,87,1,0,99,87,33,0,61,143,5,0,99,143,37,0,
61,135,9,0,99,135,41,0,61,127,13,0,99,127,45,0,61,119,17,0,
99,119,49,0,61,111,21,0,31,98,35,62,32,0,99,111,53,0,253,71,
11,0,99,103,37,0,99,103,33,0,29,48,191,255,158,247,10,232,191,255,
36,254,131,135,29,0,32,142,198,1,121,143,4,0,224,129,242,13,35,55,
25,0,67,7,28,0,190,255,138,216,224,81,242,5,27,48,32,62,178,1,
0,66,190,255,98,183,29,80,128,7,100,1,28,48,191,255,190,248,10,224,
28,48,191,255,182,248,253,81,138,253,60,111,1,0,99,111,33,0,60,103,
5,0,99,103,37,0,60,95,9,0,99,95,41,0,60,87,13,0,99,87,
45,0,60,143,17,0,99,143,49,0,60,135,21,0,99,135,53,0,61,23,
21,0,224,17,194,5,60,127,21,0,207,17,227,215,43,0,99,23,53,0,
28,48,35,62,32,0,26,64,191,255,2,247,10,16,224,17,162,29,131,103,
29,0,32,110,198,1,121,111,4,0,2,232,224,97,242,13,35,55,25,0,
67,7,28,0,190,255,236,215,224,81,242,5,27,48,32,62,178,1,0,66,
190,255,196,182,29,80,181,101,28,48,191,255,64,246,10,48,35,62,32,0,
26,64,191,255,184,246,10,16,224,17,162,29,131,143,29,0,32,86,198,1,
121,87,4,0,2,232,224,137,242,13,35,55,25,0,67,7,28,0,190,255,
162,215,224,81,242,5,27,48,32,62,178,1,0,66,190,255,122,182,29,80,
229,61,61,119,1,0,3,56,103,119,1,0,61,111,5,0,103,111,5,0,
61,103,9,0,103,103,9,0,61,95,13,0,103,95,13,0,61,87,17,0,
103,87,17,0,61,143,21,0,31,130,29,48,26,64,103,143,21,0,99,135,
1,0,99,135,5,0,191,255,60,246,29,48,191,255,178,245,10,48,3,56,
26,64,191,255,44,246,131,119,29,0,224,113,242,13,35,55,25,0,67,7,
28,0,190,255,38,215,224,81,242,5,27,48,32,62,178,1,0,66,190,255,
254,181,0,82,92,6,255,112,140,7,225,112,6,224,8,208,0,90,0,234,
0,18,2,136,194,138,197,137,49,111,129,133,231,105,226,5,65,18,98,18,
241,245,224,89,146,45,36,87,193,142,42,23,17,0,34,143,24,0,2,222,
40,0,34,135,29,0,63,6,26,80,129,0,17,48,202,49,112,0,59,119,
0,0,36,55,193,142,10,200,59,103,5,0,14,104,205,49,63,6,52,80,
129,0,108,0,36,95,197,142,124,95,1,0,36,143,197,142,217,81,170,137,
250,137,163,69,133,77,48,6,64,48,32,16,99,135,1,0,47,6,68,51,
34,17,99,127,5,0,3,48,191,255,216,246,124,87,1,0,224,81,226,53,
245,45,60,55,1,0,38,23,5,0,45,6,136,119,102,85,237,17,226,5,
44,6,136,136,136,136,236,17,218,13,38,95,21,0,224,89,154,29,38,239,
13,0,49,6,0,128,1,0,198,233,209,233,181,29,38,135,13,0,38,23,
21,0,130,129,250,129,187,5,224,17,138,13,60,55,1,0,191,255,150,244,
10,238,24,0,181,13,191,255,110,246,124,87,1,0,60,55,1,0,191,255,
210,245,224,81,210,205,29,80,76,6,255,112,158,7,225,240,36,143,197,142,
6,232,61,135,4,0,99,143,1,0,136,0,224,129,218,5,32,86,196,1,
128,7,36,3,224,65,178,5,7,16,229,13,7,6,0,253,193,5,32,22,
0,4,133,13,7,16,130,18,199,17,125,23,21,0,130,18,194,18,61,127,
9,0,125,23,21,0,99,127,37,0,61,119,13,0,99,119,41,0,61,111,
17,0,64,118,142,0,32,134,24,0,99,111,45,0,61,103,21,0,1,106,
46,230,144,209,3,122,12,142,48,0,99,103,49,0,61,95,25,0,99,7,
57,0,99,143,49,0,99,135,46,0,99,95,53,0,99,127,44,0,99,231,
29,0,67,111,32,0,28,48,31,58,190,255,182,180,224,81,186,253,35,63,
41,0,35,71,49,0,3,48,59,6,188,160,133,0,191,255,66,254,10,224,
224,225,210,93,36,87,193,142,42,23,17,0,34,95,24,0,35,215,49,0,
11,48,202,49,34,87,29,0,2,206,32,0,220,209,63,6,194,81,129,0,
106,0,57,135,0,0,36,55,193,142,10,192,57,119,5,0,16,120,207,49,
63,6,220,81,129,0,110,0,216,81,234,209,179,29,131,103,33,0,32,110,
198,1,125,111,4,0,224,97,242,13,35,55,29,0,67,7,32,0,190,255,
230,212,224,81,242,5,27,48,32,62,178,1,0,66,190,255,190,179,32,86,
197,1,128,7,10,2,35,87,1,0,224,81,210,13,252,81,153,13,42,23,
21,0,224,17,162,53,42,87,13,0,130,81,197,45,188,81,165,45,36,87,
193,142,42,23,17,0,34,143,48,0,34,135,53,0,63,6,82,82,129,0,
17,48,202,49,112,0,181,29,131,119,33,0,32,126,198,1,125,127,4,0,
224,113,242,13,35,55,29,0,67,7,32,0,190,255,116,212,224,81,242,5,
27,48,32,62,178,1,0,66,190,255,76,179,32,86,195,1,128,7,152,1,
99,87,57,0,227,215,47,0,35,62,36,0,28,48,26,64,191,255,58,243,
10,16,224,17,178,29,131,95,33,0,32,102,198,1,125,103,4,0,2,232,
224,89,242,13,35,55,29,0,67,7,32,0,190,255,36,212,224,81,242,5,
27,48,32,62,178,1,0,66,190,255,252,178,29,80,128,7,74,1,28,200,
28,48,191,255,116,242,10,48,35,62,36,0,26,64,191,255,236,242,10,16,
224,81,162,29,131,135,33,0,32,142,198,1,125,143,4,0,2,232,224,129,
242,13,35,55,29,0,67,7,32,0,190,255,214,211,224,81,242,5,27,48,
32,62,178,1,0,66,190,255,174,178,29,80,229,125,35,55,1,0,224,49,
210,93,252,49,185,93,38,111,1,0,99,111,5,0,38,103,5,0,99,103,
9,0,38,95,9,0,99,95,13,0,38,87,13,0,166,201,99,87,17,0,
38,143,17,0,99,207,25,0,35,62,4,0,26,64,99,143,21,0,191,255,
112,242,10,16,224,17,130,29,131,111,33,0,125,23,4,0,2,232,224,105,
242,13,35,55,29,0,67,7,32,0,190,255,94,211,224,81,242,5,27,48,
32,62,178,1,0,66,190,255,54,178,29,80,165,69,35,55,1,0,191,255,
176,241,10,48,35,62,4,0,26,64,191,255,40,242,10,16,224,17,130,29,
131,95,33,0,125,23,4,0,2,232,224,89,242,13,35,55,29,0,67,7,
32,0,190,255,22,211,224,81,242,5,27,48,32,62,178,1,0,66,190,255,
238,177,29,80,229,29,191,255,124,248,61,54,8,0,191,255,78,243,125,87,
1,0,131,87,33,0,125,7,4,0,224,81,242,13,35,55,29,0,67,7,
32,0,190,255,218,210,224,81,242,5,27,48,32,62,178,1,0,66,190,255,
178,177,0,82,94,6,255,240,136,7,225,240,7,200,6,232,61,143,4,0,
8,208,9,216,35,199,45,0,224,137,210,5,26,56,0,66,191,255,160,252,
64,134,142,0,48,230,144,209,99,231,9,0,1,122,67,127,12,0,28,48,
31,58,190,255,218,177,224,81,186,253,196,199,97,144,60,6,200,160,133,0,
210,5,61,119,4,0,224,113,210,37,191,255,178,246,224,81,170,13,196,7,
97,144,37,62,209,133,32,54,64,0,190,255,18,179,133,29,131,111,13,0,
61,239,4,0,224,105,242,13,35,55,9,0,67,7,12,0,190,255,64,210,
224,81,242,5,28,48,32,62,178,1,0,66,190,255,24,177,29,80,128,7,
36,1,29,48,24,56,35,70,4,0,3,72,191,255,210,239,224,81,226,21,
131,95,13,0,10,232,224,89,242,13,35,55,9,0,67,7,12,0,190,255,
2,210,224,81,242,5,28,48,32,62,178,1,0,66,190,255,218,176,29,80,
181,117,35,143,5,0,27,80,218,81,241,81,195,21,131,135,13,0,224,129,
146,53,35,55,9,0,67,7,12,0,190,255,206,209,224,81,146,45,28,48,
32,62,178,1,0,66,190,255,166,176,165,37,35,127,1,0,61,23,1,0,
207,217,226,95,11,0,34,143,13,0,27,112,218,113,193,90,171,137,241,113,
227,21,131,135,13,0,224,129,242,13,35,55,9,0,67,7,12,0,190,255,
138,209,224,81,242,5,28,48,32,62,178,1,0,66,190,255,98,176,32,86,
199,1,229,53,2,54,24,0,219,49,25,56,26,64,191,255,88,240,224,81,
226,21,131,111,13,0,10,232,224,105,242,13,35,55,9,0,67,7,12,0,
190,255,76,209,224,81,242,5,28,48,32,62,178,1,0,66,190,255,36,176,
29,80,133,29,29,48,191,255,82,240,131,103,13,0,10,232,224,97,242,13,
35,55,9,0,67,7,12,0,190,255,28,209,224,81,242,5,28,48,32,62,
178,1,0,66,190,255,244,175,29,80,72,6,255,240,134,7,225,243,36,215,
197,142,6,232,157,0,0,194,224,209,202,13,224,233,226,5,38,6,184,161,
133,0,129,255,12,101,32,86,202,1,128,7,72,2,36,87,193,142,42,23,
17,0,34,127,24,0,34,119,29,0,63,6,34,86,129,0,15,48,202,49,
110,0,10,184,0,178,0,218,224,233,178,13,38,6,108,162,133,0,129,255,
212,100,38,6,212,160,133,0,129,255,202,100,26,224,60,23,13,0,252,159,
11,0,2,200,220,201,153,153,99,159,9,0,224,233,242,13,28,72,60,63,
1,0,60,71,5,0,99,23,1,0,99,23,5,0,38,6,232,161,133,0,
129,255,150,100,247,209,161,21,36,87,193,142,42,23,17,0,34,143,32,0,
34,135,37,0,63,6,148,86,129,0,17,48,202,49,112,0,215,81,234,209,
195,13,32,198,202,1,224,233,186,5,128,7,90,1,38,6,12,162,133,0,
128,7,76,1,60,23,1,0,46,6,64,48,32,16,238,17,130,21,45,6,
128,112,96,80,237,17,178,13,32,198,202,1,224,233,226,5,38,6,36,162,
133,0,129,255,48,100,65,218,252,87,9,0,10,94,254,255,98,90,145,13,
224,233,226,5,38,6,56,162,133,0,129,255,20,100,65,218,35,159,9,0,
211,134,3,0,146,13,224,233,226,5,38,6,120,161,133,0,129,255,250,99,
65,218,252,23,11,0,35,103,9,0,28,88,224,17,242,21,139,87,1,0,
140,111,1,0,65,90,65,98,173,81,186,5,95,18,250,245,224,81,178,13,
224,233,226,5,38,6,28,161,133,0,129,255,196,99,32,198,202,1,65,218,
218,94,3,0,146,13,224,233,226,5,38,6,12,161,133,0,129,255,170,99,
65,218,247,201,161,21,36,87,193,142,42,23,17,0,34,135,32,0,34,127,
37,0,63,6,130,87,129,0,16,48,202,49,111,0,215,81,234,201,147,13,
32,198,202,1,224,233,242,53,38,6,56,161,133,0,149,53,224,233,210,5,
37,54,210,133,129,255,102,99,60,215,21,0,224,209,178,5,220,209,149,21,
36,87,193,142,42,23,17,0,34,95,32,0,11,48,202,49,34,87,37,0,
63,6,204,87,129,0,106,0,10,208,215,209,26,72,185,73,162,13,224,233,
130,13,25,56,9,64,38,6,76,161,133,0,129,255,34,99,65,178,106,178,
167,13,224,233,226,5,38,6,80,162,133,0,129,255,14,99,65,218,245,5,
60,127,21,0,224,121,178,5,191,7,56,254,224,233,130,13,22,56,27,64,
38,6,140,161,133,0,129,255,236,98,224,193,202,5,196,7,97,144,149,21,
196,135,97,144,191,255,248,242,224,81,186,13,196,7,97,144,37,62,212,133,
32,54,64,0,190,255,88,175,191,255,26,244,24,80,70,6,255,243,180,7,
225,112,49,6,64,48,32,16,99,143,81,0,48,6,68,51,34,17,99,135,
85,0,35,54,80,0,191,255,206,238,10,200,224,201,226,109,0,218,0,226,
28,120,194,122,197,121,47,95,129,133,35,54,80,0,99,95,85,0,191,255,
174,238,10,232,224,233,146,85,249,233,243,77,224,217,250,5,1,218,38,6,
200,162,133,0,129,255,98,98,61,23,13,0,29,72,61,63,1,0,61,71,
5,0,99,23,1,0,99,23,5,0,38,6,20,163,133,0,129,255,66,98,
35,63,85,0,35,54,44,0,191,255,212,240,35,54,44,0,191,255,172,235,
10,232,29,48,129,255,88,78,10,208,26,56,29,64,99,7,1,0,35,54,
44,0,0,74,191,255,46,239,224,81,170,29,35,54,44,0,191,255,78,244,
35,63,85,0,35,54,8,0,191,255,152,240,29,56,35,54,8,0,1,66,
191,255,196,247,26,56,29,64,99,7,1,0,35,54,8,0,0,74,191,255,
246,250,26,48,129,255,36,78,65,226,98,226,129,165,224,217,146,13,38,6,
0,163,133,0,129,255,194,97,1,50,191,255,148,252,116,6,255,112,130,7,
33,0,3,72,191,255,62,235,66,6,63,0,132,7,33,0,37,143,217,133,
37,135,221,133,0,18,99,143,1,0,99,135,5,0,181,45,7,80,3,88,
4,98,138,111,1,0,139,127,1,0,65,82,65,90,141,121,234,29,224,105,
178,5,95,98,218,245,7,22,21,0,35,110,4,0,4,114,130,87,1,0,
141,103,1,0,65,18,65,106,138,97,154,21,224,81,178,5,95,114,218,245,
68,58,9,48,32,70,16,0,190,255,200,166,1,82,229,5,65,18,65,58,
232,17,209,213,0,82,68,6,63,0,38,135,4,0,224,129,226,87,0,0,
127,0,128,7,33,0,36,87,193,142,42,23,17,0,34,135,56,0,34,127,
61,0,63,6,2,90,129,0,16,48,202,49,111,0,64,6,63,0,128,7,
33,0,36,87,193,142,42,23,17,0,34,135,40,0,34,127,45,0,63,6,
38,90,129,0,16,48,202,49,111,0,64,6,63,0,128,7,33,0,36,87,
193,142,42,23,17,0,34,135,48,0,34,127,53,0,63,6,74,90,129,0,
16,48,202,49,111,0,64,6,63,0,140,7,225,48,6,208,0,226,122,7,
0,0,191,255,136,255,10,232,191,255,166,255,10,16,0,82,213,13,29,135,
0,0,250,103,1,0,65,226,65,234,208,126,255,0,207,97,122,103,0,0,
65,82,226,81,177,245,42,6,64,48,32,16,99,87,1,0,49,6,68,51,
34,17,99,143,5,0,3,48,191,255,156,236,10,216,224,217,170,13,38,6,
92,163,133,0,129,255,90,96,32,86,107,48,128,7,24,2,191,255,114,255,
202,233,253,217,146,21,38,6,128,163,133,0,129,255,62,96,29,56,27,64,
38,6,172,163,133,0,129,255,48,96,32,86,107,48,128,7,238,1,251,135,
11,0,16,6,232,255,178,21,38,6,216,163,133,0,129,255,20,96,251,71,
11,0,32,62,24,0,38,6,0,164,133,0,129,255,2,96,32,86,107,48,
128,7,192,1,0,18,213,13,29,111,0,0,250,143,1,0,65,226,65,234,
205,102,255,0,204,137,122,143,0,0,65,18,251,119,11,0,14,110,252,255,
237,17,241,237,59,103,13,0,68,226,68,234,12,22,208,255,0,98,213,13,
29,87,0,0,250,119,1,0,65,226,65,234,202,142,255,0,209,113,122,119,
0,0,65,98,226,97,177,245,0,18,213,13,29,95,0,0,250,127,1,0,
65,226,65,234,203,86,255,0,202,121,122,127,0,0,65,18,251,103,11,0,
12,94,252,255,235,17,241,237,59,239,21,0,68,226,42,6,128,112,96,80,
99,87,1,0,219,233,49,6,136,119,102,85,99,143,5,0,3,48,191,255,
142,235,10,216,224,217,170,13,38,6,60,163,133,0,129,255,76,95,32,86,
107,48,128,7,10,1,253,217,130,21,38,6,44,164,133,0,129,255,54,95,
29,56,27,64,38,6,172,163,133,0,129,255,40,95,32,86,107,48,181,117,
251,135,11,0,16,6,232,255,162,21,38,6,84,164,133,0,129,255,14,95,
251,71,11,0,32,62,24,0,38,6,0,164,133,0,129,255,252,94,32,86,
107,48,213,93,0,18,213,13,29,111,0,0,250,143,1,0,65,226,65,234,
205,102,255,0,204,137,122,143,0,0,65,18,251,119,11,0,14,110,252,255,
237,17,241,237,59,103,13,0,68,226,68,234,12,22,208,255,0,98,213,13,
29,87,0,0,250,119,1,0,65,226,65,234,202,142,255,0,209,113,122,119,
0,0,65,98,226,97,177,245,0,18,213,13,29,95,0,0,250,127,1,0,
65,226,65,234,203,86,255,0,202,121,122,127,0,0,65,18,251,103,11,0,
12,94,252,255,235,17,241,237,36,87,193,142,42,23,17,0,68,234,34,143,
32,0,34,135,37,0,68,226,63,6,176,92,129,0,17,48,202,49,112,0,
10,16,188,17,0,82,133,13,250,127,1,0,65,82,15,126,255,0,122,127,
0,0,226,81,129,253,0,82,76,6,255,48,128,7,33,0,38,6,120,164,
133,0,129,255,44,94,0,50,191,255,254,248,224,81,194,5,1,50,191,255,
244,248,191,255,96,251,64,6,63,0,128,7,97,0,38,6,144,209,141,0,
39,6,152,164,133,0,1,66,128,255,220,54,0,50,191,255,52,226,42,23,
17,0,100,87,193,142,34,55,16,0,34,111,21,0,10,120,63,6,46,93,
129,0,207,49,109,0,10,232,224,233,210,5,36,55,193,142,129,255,224,73,
224,233,130,109,0,50,191,255,152,227,42,23,17,0,100,87,193,142,34,55,
16,0,34,119,21,0,10,128,63,6,98,93,129,0,208,49,110,0,10,232,
224,233,210,5,36,55,193,142,129,255,172,73,224,233,226,77,0,50,191,255,
0,227,42,23,17,0,100,87,193,142,34,55,16,0,34,127,21,0,10,136,
63,6,150,93,129,0,209,49,111,0,10,232,224,233,210,5,36,55,193,142,
129,255,120,73,224,233,194,53,0,50,191,255,104,226,42,23,17,0,34,55,
16,0,34,135,21,0,100,87,193,142,63,6,200,93,129,0,202,49,112,0,
10,232,224,233,210,5,36,55,193,142,129,255,70,73,224,233,178,29,0,50,
191,255,204,225,42,23,17,0,34,95,16,0,34,143,21,0,100,87,193,142,
63,6,252,93,129,0,11,48,202,49,113,0,10,232,224,233,210,5,36,55,
193,142,129,255,18,73,224,233,186,5,191,255,80,238,29,80,64,6,127,0,
224,49,210,5,129,58,185,5,129,7,248,72,127,0,128,7,97,0,6,232,
12,138,93,143,1,0,32,134,31,0,93,135,5,0,93,7,0,0,93,7,
4,0,93,7,2,0,93,63,3,0,125,7,9,0,7,48,191,255,28,150,
10,22,0,184,125,23,13,0,64,6,127,0,132,7,225,48,7,224,6,208,
26,64,38,6,80,166,133,0,129,255,150,92,99,7,1,0,28,48,3,56,
128,255,176,29,35,143,1,0,10,232,224,137,194,5,32,238,8,2,133,37,
224,233,234,29,32,54,188,12,129,255,160,72,10,216,28,48,27,56,35,70,
4,0,128,255,142,29,10,232,224,233,218,13,35,71,5,0,26,48,27,56,
1,74,128,255,130,29,10,232,28,48,0,58,128,255,128,29,27,48,129,255,
78,72,29,80,68,6,255,48,128,7,225,241,6,200,7,192,184,0,8,232,
32,54,188,12,129,255,84,72,10,216,32,54,188,12,129,255,74,72,10,208,
224,217,178,5,224,209,186,13,27,48,129,255,86,72,26,48,129,255,80,72,
32,86,16,1,128,7,26,1,224,193,226,63,0,0,38,6,116,166,133,0,
129,255,234,91,25,48,27,56,26,64,128,255,38,29,10,224,224,225,218,117,
224,193,202,5,27,48,26,192,181,5,26,48,27,192,128,255,22,29,10,184,
224,185,146,109,24,48,0,58,128,255,16,29,125,87,1,0,10,6,240,255,
129,101,32,54,244,1,129,255,218,71,10,224,224,225,194,53,28,48,0,58,
32,70,244,1,190,255,118,162,25,48,28,56,32,70,244,1,128,255,148,91,
61,55,1,0,28,56,128,255,176,91,38,6,148,166,133,0,129,255,118,91,
61,55,1,0,230,62,20,0,49,6,232,46,153,0,32,70,20,0,209,57,
128,255,188,28,61,63,1,0,38,6,100,163,145,0,128,255,44,91,224,81,
226,5,38,6,180,166,133,0,129,255,66,91,28,48,129,255,138,71,61,55,
1,0,0,58,191,255,188,70,10,224,224,225,226,13,61,55,1,0,0,58,
128,255,96,28,25,48,0,58,191,255,164,70,31,122,125,127,1,0,149,21,
25,48,23,56,128,255,112,28,10,224,224,225,234,5,25,48,0,58,191,255,
134,70,10,224,61,55,1,0,128,255,96,28,27,48,129,255,58,71,26,48,
129,255,52,71,28,80,64,6,255,241,140,7,225,243,6,224,156,0,7,192,
99,71,5,0,9,200,224,65,186,5,128,7,148,3,0,234,35,222,8,0,
221,217,91,7,0,0,29,48,191,255,198,146,224,81,226,13,1,210,29,48,
191,255,30,147,127,82,226,5,28,120,222,122,159,122,170,5,0,210,91,215,
0,0,65,234,29,6,240,255,230,229,24,135,1,0,111,130,154,13,132,111,
69,137,224,105,218,5,32,86,93,2,128,7,70,3,31,82,0,18,121,87,
1,0,121,7,5,0,28,96,218,98,159,98,138,13,108,130,226,5,109,130,
194,5,111,130,162,5,1,18,67,23,3,0,24,232,128,7,236,2,4,87,
233,135,29,111,0,0,234,105,179,5,128,7,116,1,224,105,178,125,29,23,
1,0,101,18,249,5,224,17,178,37,98,18,163,69,128,7,138,2,101,18,
146,13,2,6,224,255,226,53,2,6,192,255,178,53,128,7,118,2,1,98,
133,21,12,16,244,23,64,2,221,17,2,95,0,0,224,89,250,29,2,23,
1,0,106,18,178,5,108,18,154,29,65,98,237,97,135,245,165,37,29,135,
20,0,224,129,234,29,29,119,21,0,1,18,165,21,2,120,244,127,64,2,
221,121,15,87,1,0,238,81,218,5,106,82,242,5,108,82,210,5,32,86,
88,2,128,7,134,2,65,18,237,17,231,237,229,5,220,86,1,0,186,5,
128,7,12,2,29,135,2,0,105,130,215,5,32,86,92,2,128,7,100,2,
220,126,1,0,178,5,128,7,40,2,29,119,3,0,224,113,223,93,29,111,
4,0,224,105,154,93,29,103,5,0,224,97,218,85,61,95,6,0,203,6,
255,127,138,85,61,87,13,0,224,81,202,77,61,135,9,0,224,129,138,77,
61,127,16,0,224,121,202,69,29,119,18,0,224,113,186,5,128,7,226,1,
213,61,29,23,1,0,86,18,99,18,147,13,101,18,178,5,128,7,152,1,
248,233,178,5,128,7,144,1,29,103,3,0,234,97,137,13,35,94,8,0,
203,97,140,135,1,0,224,129,218,5,32,86,14,1,128,7,218,1,29,127,
2,0,224,121,218,29,29,119,5,0,224,113,154,29,61,111,6,0,205,6,
255,127,202,21,61,103,16,0,224,97,138,21,29,95,18,0,224,89,202,13,
220,86,1,0,218,13,29,135,4,0,224,129,218,5,29,127,19,0,224,121,
210,5,32,86,82,2,128,7,146,1,29,111,3,0,35,102,8,0,28,88,
221,90,204,105,77,7,0,0,159,90,186,5,125,7,9,0,29,55,3,0,
191,255,8,146,0,58,1,210,0,218,10,48,6,72,163,135,3,0,151,74,
6,64,201,66,224,129,194,13,36,95,197,136,36,87,193,136,224,89,230,5,
191,5,224,81,179,5,10,208,11,216,106,74,191,21,230,5,42,6,0,130,
53,122,234,65,217,13,224,217,182,13,239,5,45,6,0,202,154,59,237,209,
211,5,58,6,0,202,154,59,0,218,251,73,198,37,191,5,250,65,145,37,
8,48,26,64,9,56,27,72,129,255,140,111,26,16,234,23,34,10,0,74,
250,95,32,2,10,176,1,80,27,184,246,191,32,2,250,183,32,2,202,89,
203,185,22,54,255,1,225,63,0,0,215,57,32,70,0,2,129,255,92,111,
10,48,11,56,61,23,9,0,29,87,1,0,162,49,225,79,0,0,169,57,
106,82,145,45,226,5,109,82,243,29,111,82,242,37,181,37,32,110,33,0,
237,23,194,122,224,121,194,5,32,86,91,2,229,77,32,94,0,72,171,49,
225,79,0,0,169,57,32,70,33,0,0,74,129,255,16,111,197,90,10,56,
155,58,11,57,10,48,197,50,181,13,32,94,0,72,171,49,225,79,0,0,
169,57,197,5,32,86,90,2,165,53,61,23,13,0,224,17,130,13,231,1,
239,5,182,5,230,17,185,5,2,48,0,58,57,95,5,0,57,87,1,0,
235,57,139,13,177,5,234,49,217,5,121,55,1,0,121,63,5,0,29,238,
20,0,35,95,5,0,244,95,64,2,216,89,235,233,185,5,191,7,10,253,
57,95,5,0,57,87,1,0,224,89,139,13,193,5,10,6,0,246,193,5,
32,86,83,2,165,5,0,82,76,6,255,243,80,26,49,6,228,166,133,0,
49,127,1,0,99,127,1,0,49,119,5,0,99,119,5,0,49,111,9,0,
99,111,9,0,49,103,12,0,99,103,12,0,6,96,12,16,197,29,2,104,
3,112,14,122,141,143,1,0,142,95,1,0,65,106,65,114,145,89,218,5,
224,137,178,5,95,122,218,245,11,80,224,81,154,13,38,135,13,0,234,0,
101,130,178,13,32,86,50,2,133,13,65,18,12,126,2,16,239,17,161,229,
32,86,51,2,3,30,16,0,127,0,128,7,65,0,6,80,7,232,0,18,
0,114,0,122,181,13,2,128,194,130,202,129,48,71,1,0,200,113,225,79,
0,0,201,121,65,18,253,17,209,245,15,80,206,81,64,6,95,0,128,7,
225,16,167,0,8,232,189,0,0,218,100,58,233,5,224,57,226,45,98,58,
242,29,149,45,101,58,145,21,194,5,102,58,130,13,181,37,29,64,1,58,
128,255,212,23,10,216,245,29,29,64,0,58,128,255,200,23,10,216,149,29,
0,226,28,48,29,64,1,58,128,255,184,23,65,226,28,6,240,255,134,253,
229,13,0,226,28,48,29,64,0,58,128,255,162,23,65,226,28,6,240,255,
134,253,181,5,32,222,13,1,27,80,64,6,255,16,134,7,225,0,6,224,
191,255,30,142,224,81,202,5,32,86,14,1,149,53,28,48,35,62,2,0,
35,70,3,0,191,255,244,142,3,143,3,0,32,86,1,16,224,137,218,5,
4,135,232,135,224,129,130,37,1,234,252,239,192,0,4,119,232,135,29,48,
198,0,0,82,224,113,234,5,35,62,4,0,128,255,68,23,234,0,224,81,
250,13,29,48,198,0,35,62,8,0,128,255,58,23,224,81,250,5,4,95,
232,135,224,89,178,5,32,86,1,16,70,6,255,0,134,7,225,0,6,224,
191,255,166,141,224,81,202,5,32,86,14,1,149,45,28,48,0,58,0,66,
3,72,191,255,96,4,10,232,1,138,125,143,0,0,28,48,29,56,128,255,
254,22,61,135,0,0,224,129,218,253,61,231,12,0,125,7,0,0,29,48,
190,255,152,223,224,225,218,13,163,119,5,0,14,6,12,255,138,13,131,111,
7,0,13,6,212,255,186,5,32,230,96,2,28,80,70,6,255,0,136,7,
225,112,144,58,9,200,8,232,29,79,11,0,157,71,11,0,7,216,6,224,
38,6,244,166,133,0,129,255,24,85,29,23,8,0,97,18,250,13,253,23,
7,0,32,118,20,0,32,94,20,0,2,208,78,208,2,80,235,87,128,98,
224,97,226,5,133,13,32,86,87,2,128,7,90,1,2,6,68,243,215,5,
32,86,80,2,128,7,76,1,252,119,9,0,201,114,238,17,215,5,32,86,
81,2,128,7,58,1,224,209,151,13,157,111,11,0,224,105,210,5,32,86,
13,1,128,7,38,1,29,55,9,0,25,56,26,64,35,78,8,0,198,54,
221,0,134,54,34,0,191,255,196,249,10,224,224,225,178,5,128,7,2,1,
128,255,102,171,191,255,102,3,10,224,224,225,154,125,27,48,128,255,24,22,
128,255,28,22,27,48,3,56,128,255,156,21,35,111,1,0,224,105,194,5,
32,230,8,2,197,93,224,225,170,93,224,209,250,53,29,95,11,0,99,95,
5,0,221,199,10,0,146,13,27,48,11,56,32,70,175,255,191,255,190,253,
10,224,133,37,221,207,10,0,146,13,27,48,0,58,35,70,4,0,191,255,
254,247,10,224,213,21,221,215,10,0,146,13,27,48,1,58,35,70,4,0,
191,255,232,247,10,224,165,13,221,223,10,0,242,5,35,63,5,0,27,48,
191,255,96,247,10,224,35,135,5,0,93,135,11,0,221,199,10,0,130,37,
165,37,132,127,113,137,224,121,202,5,32,230,72,2,181,29,25,16,0,82,
197,13,2,119,0,0,224,113,218,5,35,103,9,0,98,103,13,0,65,82,
2,22,20,0,250,81,198,245,27,48,25,56,26,64,0,74,128,255,240,20,
10,224,27,48,128,255,32,21,32,54,12,177,64,62,2,0,0,66,190,255,
118,191,128,255,72,170,224,225,186,5,128,255,96,154,28,80,72,6,255,112,
132,7,225,16,0,226,232,239,7,0,6,216,38,6,52,167,133,0,129,255,
124,83,97,234,177,5,130,37,245,61,37,54,36,134,129,255,108,83,128,255,
6,21,0,234,29,16,197,18,32,126,164,180,207,17,34,87,5,0,224,81,
162,13,0,50,29,6,240,255,193,5,224,81,162,5,2,48,128,255,232,20,
65,234,29,6,240,255,182,237,133,45,37,54,32,134,129,255,48,83,59,23,
45,0,128,86,255,255,99,87,1,0,3,56,34,87,0,0,99,23,5,0,
38,6,0,147,145,0,31,66,65,82,98,87,0,0,129,255,166,25,32,54,
12,177,64,62,1,0,0,66,190,255,204,190,133,13,32,230,13,1,38,6,
84,167,133,0,129,255,234,82,28,80,68,6,255,16,128,7,33,0,9,56,
38,6,100,167,133,0,129,255,212,82,0,82,64,6,63,0,128,7,225,16,
40,231,9,0,38,6,124,167,133,0,28,56,129,255,186,82,0,234,1,218,
253,223,192,0,28,128,91,129,146,21,4,127,233,135,239,233,190,13,29,48,
191,255,18,139,127,82,234,5,29,48,191,255,164,138,224,81,186,5,59,112,
78,225,65,234,29,6,224,255,246,229,224,225,178,13,28,48,128,255,40,183,
32,54,12,177,32,62,64,0,0,66,190,255,62,190,0,82,64,6,255,16,
132,7,225,0,40,63,9,0,6,232,38,6,164,167,133,0,99,63,1,0,
129,255,78,82,61,23,45,0,0,234,99,23,5,0,35,23,1,0,1,226,
253,231,192,0,92,17,130,21,4,135,233,135,240,233,238,5,29,48,191,255,
156,138,127,82,242,5,35,23,1,0,60,80,74,17,99,23,1,0,65,234,
29,6,224,255,246,229,35,87,5,0,42,23,0,0,3,56,38,6,0,147,
145,0,31,66,65,18,106,23,0,0,129,255,146,24,32,54,12,177,64,62,
1,0,0,66,190,255,184,189,0,82,68,6,255,0,128,7,225,241,64,142,
137,0,17,143,228,221,102,138,202,5,32,86,140,3,229,109,36,135,214,143,
232,223,7,0,240,217,194,5,32,86,13,1,213,101,9,192,27,56,38,6,
200,167,133,0,129,255,170,81,0,210,0,226,149,45,28,120,216,121,15,239,
0,0,28,56,37,54,44,134,29,64,129,255,144,81,1,18,253,23,192,0,
90,17,218,13,29,6,240,255,161,13,29,88,197,90,32,134,164,180,208,89,
43,23,5,0,224,17,154,13,38,6,240,167,133,0,129,255,100,81,32,86,
10,1,133,61,1,122,253,127,192,0,15,209,65,226,251,225,246,213,37,54,
52,134,129,255,72,81,0,226,1,50,128,255,238,18,31,186,0,234,197,29,
29,104,216,105,13,215,0,0,23,56,26,48,128,255,224,18,10,184,26,48,
31,58,191,255,40,58,10,200,224,201,178,13,25,56,26,64,38,6,0,168,
133,0,129,255,12,81,224,225,170,5,25,224,65,234,251,233,198,229,0,50,
128,255,168,18,37,54,52,134,129,255,242,80,28,80,64,6,255,241,128,7,
225,48,7,224,8,216,6,232,38,6,92,168,133,0,129,255,216,80,251,215,
7,0,38,6,108,168,133,0,26,56,129,255,200,80,59,254,8,0,229,87,
64,0,224,7,96,1,10,216,26,16,2,6,230,255,193,29,66,0,43,0,
52,0,61,0,70,0,79,0,88,0,97,0,106,0,115,0,124,0,133,0,
142,0,151,0,160,0,169,0,178,0,187,0,195,0,203,0,211,0,219,0,
3,1,11,1,19,1,27,1,35,1,2,6,230,255,186,5,128,7,28,2,
2,6,102,255,186,5,128,7,130,1,2,6,101,255,186,5,128,7,152,1,
128,7,20,2,29,56,28,64,31,72,0,50,191,255,96,134,10,232,128,7,
24,2,29,56,28,64,31,72,0,50,191,255,150,132,10,232,128,7,6,2,
29,56,28,64,31,72,0,50,191,255,236,130,10,232,128,7,244,1,29,56,
28,64,31,72,0,50,191,255,76,129,10,232,128,7,226,1,29,56,28,64,
31,72,0,50,191,255,230,127,10,232,128,7,208,1,29,56,28,64,31,72,
0,50,191,255,212,126,10,232,128,7,190,1,29,56,28,64,31,72,0,50,
191,255,132,124,10,232,128,7,172,1,29,56,28,64,31,72,0,50,191,255,
160,122,10,232,128,7,154,1,29,56,28,64,31,72,0,50,191,255,222,119,
10,232,128,7,136,1,29,56,28,64,31,72,0,50,191,255,218,117,10,232,
128,7,118,1,29,56,28,64,31,72,0,50,191,255,102,111,10,232,128,7,
100,1,29,56,28,64,31,72,0,50,191,255,84,110,10,232,128,7,82,1,
29,56,28,64,31,72,0,50,191,255,20,108,10,232,128,7,64,1,29,56,
28,64,31,72,0,50,191,255,202,105,10,232,128,7,46,1,29,56,28,64,
31,72,0,50,191,255,40,104,10,232,128,7,28,1,29,56,28,64,31,72,
0,50,191,255,58,102,10,232,128,7,10,1,29,56,28,64,31,72,0,50,
191,255,102,98,10,232,197,125,29,56,28,64,31,72,0,50,191,255,178,96,
10,232,197,117,29,56,28,64,31,72,0,50,191,255,24,95,10,232,197,109,
29,56,28,64,31,72,0,50,191,255,80,93,10,232,197,101,29,56,28,64,
31,72,0,50,191,255,158,91,10,232,197,93,32,54,52,0,129,255,114,57,
10,232,224,233,210,85,29,48,191,255,84,82,48,6,148,50,134,0,125,135,
49,0,197,77,32,54,52,0,129,255,82,57,10,232,224,233,210,69,29,48,
191,255,52,82,47,6,172,50,134,0,125,127,49,0,197,61,29,56,28,64,
31,72,0,50,191,255,64,89,10,232,197,53,29,56,28,64,31,72,0,50,
191,255,38,88,10,232,197,45,29,56,28,64,31,72,0,50,191,255,16,87,
10,232,197,37,29,56,28,64,31,72,0,50,191,255,4,86,10,232,197,29,
29,56,28,64,31,72,0,50,191,255,130,84,10,232,197,21,29,56,28,64,
31,72,0,50,191,255,136,81,10,232,197,13,251,47,32,0,26,56,38,6,
56,168,133,0,129,255,58,78,32,86,20,48,197,53,38,6,160,134,1,0,
128,255,136,218,61,23,49,0,2,22,16,0,34,55,0,0,34,119,5,0,
63,6,250,108,129,0,221,49,110,0,38,6,164,168,133,0,10,224,224,225,
194,5,38,6,128,168,133,0,129,255,250,77,224,233,226,13,61,23,49,0,
72,18,34,55,0,0,34,103,5,0,3,58,63,6,46,109,129,0,221,49,
108,0,251,47,32,0,37,54,56,134,129,255,208,77,28,80,64,6,255,48,
128,7,225,0,232,239,7,0,40,231,9,0,29,136,208,138,159,138,202,5,
224,233,170,5,3,234,29,48,198,126,255,127,0,106,0,18,15,88,1,98,
226,103,192,0,75,97,204,0,224,97,162,5,65,106,65,18,2,6,240,255,
198,245,32,86,13,1,198,118,3,0,235,113,250,5,29,136,208,138,159,138,
242,21,97,106,194,5,32,86,13,1,213,21,221,134,1,0,130,13,28,48,
191,255,78,247,10,6,255,239,170,5,0,82,222,234,159,234,130,13,28,48,
191,255,178,247,197,5,190,255,204,238,0,82,64,6,255,0,142,7,225,16,
232,223,7,0,38,6,240,168,133,0,27,232,208,234,152,234,29,56,129,255,
40,77,4,135,233,135,240,233,153,61,0,226,84,217,27,56,130,13,99,58,
225,45,186,5,128,7,26,1,128,7,34,1,29,48,0,58,191,255,220,197,
10,224,224,225,138,29,29,48,191,255,106,133,10,48,6,6,240,255,177,13,
29,56,191,255,178,197,224,81,226,5,1,50,253,55,192,0,191,255,90,51,
29,48,128,255,146,14,10,224,224,225,194,5,28,6,246,254,202,117,29,48,
0,58,1,66,191,255,68,138,0,226,213,109,29,48,191,255,196,132,224,81,
194,5,32,86,14,1,229,101,1,226,1,18,253,23,192,0,99,23,21,0,
190,255,192,214,106,7,9,0,47,6,98,46,1,0,106,127,5,0,106,7,
29,0,106,7,33,0,32,118,232,3,106,119,21,0,99,87,25,0,106,231,
0,0,35,62,20,0,38,6,0,147,145,0,31,66,129,255,2,19,32,54,
12,177,64,62,1,0,0,66,190,255,40,184,35,55,25,0,38,111,0,0,
224,105,210,5,5,50,129,255,58,28,245,245,102,7,0,0,190,255,120,214,
29,48,191,255,68,132,224,81,162,29,29,56,3,48,191,255,72,239,98,218,
202,5,13,90,67,95,1,0,3,48,0,58,128,255,108,13,10,48,191,255,
28,62,10,224,32,54,12,177,32,62,64,0,0,66,190,255,210,183,245,13,
32,230,14,1,197,13,38,6,12,169,133,0,129,255,238,75,229,5,38,6,
192,168,133,0,129,255,226,75,28,80,78,6,255,16,128,7,225,0,7,224,
38,6,64,169,133,0,129,255,204,75,128,255,156,162,128,255,138,13,224,81,
202,21,61,6,0,0,32,0,221,239,5,0,226,253,128,255,78,13,125,231,
54,0,221,239,5,0,226,253,4,50,190,255,184,238,128,255,106,13,0,82,
64,6,255,0,170,7,225,0,9,224,35,118,44,0,47,6,88,169,133,0,
15,110,40,0,47,103,1,0,68,122,110,103,1,0,68,114,239,105,154,253,
8,232,157,87,7,0,106,82,251,37,194,82,35,126,44,0,207,81,42,63,
1,0,35,54,8,0,191,255,242,217,35,54,8,0,191,255,28,234,224,81,
202,5,32,86,198,1,165,37,189,63,7,0,35,70,4,0,35,54,8,0,
191,255,126,233,224,81,138,29,61,79,13,0,35,71,5,0,61,87,9,0,
169,65,232,81,201,5,32,86,13,1,197,13,189,135,7,0,28,56,125,71,
9,0,35,54,8,0,99,135,1,0,191,255,28,216,106,6,255,0,128,7,
225,0,8,224,144,58,6,232,38,6,128,169,133,0,129,255,232,74,252,71,
7,0,8,120,200,230,63,0,216,122,158,122,98,122,250,13,61,55,49,0,
208,66,134,55,27,0,32,62,223,255,152,66,128,255,152,12,224,81,202,13,
128,255,130,145,61,55,49,0,134,55,27,0,32,70,223,255,28,56,191,255,
32,244,64,6,255,0,128,7,225,0,8,143,3,0,232,239,7,0,6,224,
38,6,152,169,133,0,209,62,15,0,84,233,29,64,129,255,132,74,60,55,
49,0,134,55,27,0,29,56,31,66,128,255,82,12,64,6,255,0,128,7,
225,16,8,232,144,58,6,216,38,6,200,169,133,0,129,255,92,74,253,231,
7,0,0,234,224,225,138,21,196,239,96,144,32,238,13,1,138,45,59,55,
49,0,134,55,27,0,23,66,2,58,128,255,174,11,10,232,229,29,28,112,
215,114,159,114,226,13,59,55,49,0,134,55,27,0,31,66,23,58,128,255,
242,11,10,232,224,233,186,5,128,255,218,144,28,56,167,0,224,233,154,13,
59,55,49,0,134,55,27,0,23,66,191,255,116,243,10,232,29,80,64,6,
255,16,128,7,225,16,8,216,144,58,6,224,38,6,224,169,133,0,129,255,
224,73,60,231,49,0,251,223,7,0,156,231,27,0,0,234,27,128,208,130,
159,130,242,13,28,48,3,58,27,66,128,255,54,11,10,232,224,233,218,21,
28,48,31,58,191,255,186,50,10,232,245,13,27,112,215,114,159,114,178,13,
28,48,27,58,31,66,128,255,114,11,10,232,224,233,186,5,128,255,90,144,
27,56,167,0,224,233,234,5,28,48,27,66,191,255,250,242,10,232,29,80,
64,6,255,16,150,7,225,112,6,208,4,143,233,135,40,238,8,0,7,216,
144,218,241,217,214,5,32,230,13,1,128,7,18,1,253,135,1,0,8,207,
6,0,253,127,3,0,61,119,4,0,99,135,32,0,61,95,6,0,99,127,
34,0,26,231,11,0,206,110,255,0,61,119,8,0,203,86,255,0,200,82,
13,81,206,110,255,0,208,106,10,105,99,111,37,0,222,226,159,226,224,225,
242,5,61,143,4,0,209,22,0,255,208,18,229,5,29,119,10,0,206,22,
15,0,216,18,35,95,37,0,29,87,10,0,189,127,11,0,227,119,35,0,
2,89,99,95,37,0,202,142,240,0,67,143,40,0,67,127,41,0,99,7,
20,0,99,119,22,0,99,7,26,0,27,48,0,58,0,66,99,79,9,0,
35,78,32,0,190,255,162,247,202,47,2,0,28,56,25,64,35,102,4,0,
35,78,32,0,27,48,99,87,5,0,99,103,1,0,128,255,138,10,35,55,
5,0,6,16,34,95,0,0,224,89,218,253,38,231,12,0,102,7,0,0,
190,255,200,210,218,15,53,0,163,127,37,0,131,135,37,0,227,87,33,0,
163,111,39,0,163,103,41,0,131,119,39,0,125,87,0,0,227,143,35,0,
125,135,4,0,125,127,6,0,125,119,8,0,125,143,2,0,93,111,10,0,
93,103,11,0,28,80,86,6,255,112,128,7,225,112,230,223,9,0,36,63,
205,136,9,200,38,6,8,170,133,0,201,218,7,134,1,0,100,135,205,136,
129,255,38,72,36,127,205,136,97,122,183,53,36,215,209,136,26,232,29,48,
191,255,228,240,10,224,224,225,218,125,36,23,201,136,25,56,61,87,5,0,
27,104,194,105,2,48,218,49,234,105,201,13,27,64,190,255,114,141,36,87,
201,136,32,230,49,2,219,81,100,87,201,136,229,117,10,70,0,2,27,136,
194,137,232,137,175,13,27,64,190,255,80,141,36,119,201,136,219,113,100,119,
201,136,133,37,162,65,190,255,62,141,197,29,25,232,29,48,191,255,132,240,
10,224,224,225,218,77,61,23,5,0,226,217,153,21,2,54,0,2,129,255,
206,51,100,87,209,136,10,48,29,56,27,64,190,255,16,141,100,223,201,136,
32,230,49,2,133,77,61,63,5,0,61,231,9,0,125,7,9,0,29,48,
130,58,191,255,184,240,252,81,170,45,253,231,3,0,38,6,52,170,133,0,
221,225,129,255,92,71,128,255,216,182,128,255,66,9,229,87,64,0,224,7,
96,1,10,232,63,6,200,115,129,0,124,0,10,224,253,47,32,0,128,255,
38,9,224,225,130,13,28,56,38,6,248,169,133,0,129,255,40,71,165,13,
38,6,88,170,133,0,129,255,28,71,245,5,32,230,52,2,197,5,28,6,
207,253,210,13,36,55,209,136,224,49,178,5,129,255,80,51,100,7,205,136,
100,7,201,136,100,7,209,136,28,80,64,6,255,112,130,7,225,240,6,224,
8,208,7,232,144,234,128,255,180,157,29,48,3,56,128,255,254,7,60,55,
49,0,190,255,22,219,0,218,0,226,28,48,191,255,58,127,253,81,218,5,
1,138,252,143,192,0,17,217,65,226,28,6,240,255,198,245,35,119,1,0,
250,111,7,0,0,226,46,120,79,217,13,6,0,128,218,5,1,226,37,70,
64,134,181,5,37,70,68,134,29,56,38,6,112,170,133,0,129,255,134,70,
224,225,250,5,35,95,1,0,224,89,186,5,128,255,20,8,0,210,29,56,
135,0,56,6,212,221,136,0,24,48,190,255,98,201,10,200,29,48,224,225,
162,21,0,58,128,255,148,7,10,208,224,209,250,13,27,48,191,255,202,44,
224,201,162,13,29,56,135,0,24,48,190,255,128,200,197,5,25,56,128,255,
114,7,128,255,216,156,26,80,66,6,255,240,190,7,225,240,6,200,8,224,
31,130,92,135,3,0,153,127,11,0,9,232,0,218,98,122,178,5,28,223,
8,0,188,71,9,0,38,6,188,170,133,0,27,56,129,255,252,69,97,218,
234,13,252,223,7,0,32,62,20,0,38,6,148,170,133,0,71,216,27,64,
129,255,226,69,0,210,229,61,32,86,87,2,128,7,192,3,26,16,244,23,
64,2,221,17,2,111,2,0,2,71,0,0,2,79,1,0,99,111,1,0,
2,103,3,0,99,103,5,0,2,95,4,0,99,95,9,0,2,87,5,0,
99,87,13,0,34,135,6,0,209,130,177,130,99,135,17,0,34,127,9,0,
99,127,21,0,34,87,13,0,99,87,25,0,34,87,16,0,99,87,29,0,
2,87,18,0,99,87,33,0,2,23,19,0,38,6,176,171,133,0,26,56,
99,23,37,0,129,255,102,69,65,210,251,209,230,197,252,23,7,0,32,110,
20,0,2,96,237,103,128,114,224,113,234,5,224,17,194,5,2,6,68,243,
215,5,32,86,80,2,128,7,38,3,249,127,9,0,201,122,239,17,215,5,
32,86,81,2,128,7,20,3,188,119,9,0,35,22,40,0,67,119,40,0,
34,55,1,0,29,56,27,64,35,78,116,0,191,255,50,234,224,81,178,5,
128,7,240,2,29,16,197,29,2,95,0,0,32,102,31,0,66,103,5,0,
224,89,170,21,35,79,121,0,34,87,13,0,35,71,117,0,233,1,129,13,
187,5,232,81,211,5,32,86,83,2,128,7,190,2,98,71,13,0,2,22,
20,0,27,80,244,87,64,2,221,81,234,17,129,229,31,130,74,135,1,0,
38,6,244,170,133,0,129,255,176,68,0,210,197,21,26,16,244,23,64,2,
221,17,2,111,0,0,224,105,186,13,2,71,3,0,34,79,13,0,38,6,
16,171,133,0,26,56,129,255,136,68,65,210,251,209,198,237,29,48,0,58,
128,255,208,5,10,232,127,234,218,5,32,86,84,2,128,7,86,2,0,210,
29,6,240,255,129,13,29,80,197,82,32,118,164,180,206,81,42,215,5,0,
224,209,154,13,38,6,56,171,133,0,32,62,132,3,0,66,190,255,4,143,
58,23,105,0,2,22,224,0,34,55,0,0,34,111,5,0,63,6,226,118,
129,0,218,49,109,0,29,48,251,81,130,13,0,58,128,255,90,5,32,86,
89,2,128,7,254,1,35,62,44,0,128,255,50,5,10,216,224,217,130,13,
29,48,0,58,128,255,60,5,27,80,128,7,226,1,220,231,9,0,234,13,
29,48,191,255,248,53,10,216,224,217,130,13,29,48,0,58,128,255,28,5,
27,80,128,7,194,1,38,6,100,163,145,0,29,56,128,255,168,67,224,81,
226,5,38,6,76,171,133,0,129,255,190,67,220,223,9,0,92,239,3,0,
178,5,128,7,88,1,99,7,57,0,1,50,35,62,48,0,35,70,52,0,
35,78,56,0,128,255,144,5,0,226,128,7,10,1,35,55,49,0,190,255,
208,203,224,81,218,125,35,55,49,0,0,58,35,70,88,0,1,74,190,255,
166,205,97,82,146,13,38,6,56,171,133,0,32,62,195,3,0,66,190,255,
38,142,190,255,134,205,106,7,9,0,48,6,98,46,1,0,106,135,5,0,
106,7,29,0,106,7,33,0,32,126,232,3,106,127,21,0,10,216,27,48,
1,58,190,255,174,215,0,98,29,6,240,255,177,13,29,16,197,18,32,94,
164,180,203,17,34,87,5,0,224,81,162,5,2,96,44,87,17,0,0,90,
28,16,224,81,178,5,138,95,1,0,31,66,31,74,235,17,137,13,244,23,
66,2,202,17,34,79,9,0,34,71,5,0,28,56,8,192,9,200,38,6,
116,171,133,0,129,255,230,66,99,223,61,0,35,134,88,0,99,135,65,0,
99,7,76,0,99,199,69,0,99,207,73,0,58,23,105,0,1,122,99,127,
78,0,99,7,82,0,2,22,16,0,34,55,0,0,11,114,99,119,85,0,
34,111,5,0,218,49,35,62,60,0,63,6,106,120,129,0,109,0,27,48,
191,255,244,55,123,7,0,0,27,48,190,255,206,204,65,226,0,82,29,6,
240,255,177,13,29,16,197,18,32,134,164,180,208,17,34,127,5,0,224,121,
162,5,2,80,170,111,27,0,237,225,185,5,191,7,214,254,35,55,49,0,
1,58,128,255,90,4,29,56,38,6,156,171,133,0,129,255,80,66,29,48,
128,255,184,3,2,18,99,23,113,0,99,7,109,0,35,62,108,0,38,6,
56,147,145,0,31,66,129,255,206,8,196,239,96,144,130,13,32,54,12,177,
32,62,64,0,0,66,190,255,238,173,0,82,126,6,255,240,128,7,97,0,
144,58,6,232,38,6,64,172,133,0,129,255,4,66,61,55,49,0,190,255,
66,214,64,6,127,0,128,7,33,0,38,6,88,172,133,0,129,255,234,65,
0,82,64,6,63,0,132,7,225,240,8,224,252,239,7,0,7,216,6,192,
38,6,52,173,133,0,29,56,129,255,202,65,29,6,0,255,215,5,32,86,
13,1,128,7,216,2,97,234,191,5,128,7,18,1,99,7,1,0,190,255,
210,203,106,7,9,0,49,6,98,46,1,0,106,143,5,0,106,7,29,0,
106,7,33,0,32,134,208,7,106,135,21,0,99,87,5,0,1,18,106,23,
0,0,0,234,245,13,29,48,191,255,138,121,224,81,146,13,35,87,1,0,
1,18,253,23,192,0,2,81,99,87,1,0,65,234,4,127,233,135,239,233,
246,237,3,56,38,6,0,147,145,0,31,66,129,255,236,7,32,54,12,177,
64,62,1,0,0,66,190,255,18,173,35,55,5,0,6,16,34,119,0,0,
224,113,218,253,102,7,0,0,190,255,104,203,196,239,96,144,186,45,128,54,
255,255,191,255,198,185,0,234,29,48,128,255,26,3,224,81,250,5,29,64,
8,50,37,62,72,134,190,255,150,141,29,48,128,255,12,3,224,81,218,5,
29,48,31,58,191,255,250,41,29,48,128,255,2,3,97,82,242,5,29,64,
6,50,37,62,72,134,190,255,110,141,65,234,29,6,240,255,230,221,190,255,
154,179,32,54,255,127,128,255,230,2,128,255,108,151,196,47,96,144,0,50,
128,255,150,204,32,54,12,177,32,62,64,0,0,66,190,255,126,172,128,255,
206,2,229,13,128,255,118,151,196,47,96,144,128,255,56,2,5,50,128,255,
178,2,128,255,190,2,196,175,96,144,188,111,1,0,98,106,187,5,128,7,
144,1,60,238,8,0,61,103,1,0,28,90,12,56,75,97,210,13,27,48,
198,0,7,64,39,6,232,172,133,0,191,255,58,186,32,86,13,1,128,7,
116,1,38,6,248,172,133,0,129,255,78,64,221,207,0,0,186,5,128,7,
44,1,188,71,1,0,102,66,201,13,27,48,198,0,39,6,12,173,133,0,
191,255,8,186,32,86,13,1,128,7,66,1,61,71,13,0,224,65,194,13,
27,48,198,0,39,6,220,172,133,0,191,255,234,185,32,86,13,1,128,7,
36,1,253,231,5,0,253,223,7,0,61,215,8,0,61,207,10,0,28,6,
228,255,231,119,0,0,1,18,239,5,28,110,232,255,101,106,161,5,0,18,
2,128,0,18,101,218,218,5,28,6,232,255,166,5,1,18,0,106,224,17,
226,5,100,210,186,5,105,202,167,5,1,106,4,82,125,87,8,0,9,138,
29,127,12,0,125,143,10,0,32,102,28,0,125,103,4,0,207,126,254,0,
206,118,1,0,14,121,207,102,253,0,5,90,125,95,6,0,208,94,1,0,
193,90,11,97,204,142,251,0,194,134,1,0,194,130,16,137,209,118,247,0,
205,110,1,0,195,106,13,113,93,119,12,0,38,6,24,173,133,0,129,255,
104,63,28,56,38,6,108,172,133,0,32,70,28,0,129,255,88,63,27,56,
38,6,132,172,133,0,5,66,129,255,74,63,26,56,38,6,156,172,133,0,
4,66,129,255,60,63,25,56,38,6,180,172,133,0,9,66,129,255,46,63,
61,63,13,0,38,6,204,172,133,0,129,255,32,63,216,15,53,0,221,199,
0,0,162,13,38,6,80,173,133,0,129,255,12,63,1,98,68,103,104,144,
229,13,38,6,100,173,133,0,129,255,250,62,68,7,104,144,229,5,38,6,
120,173,133,0,129,255,234,62,0,82,68,6,255,240,32,86,1,1,127,0,
33,6,64,152,1,0,97,0,33,6,18,176,1,0,97,0,33,6,232,180,
1,0,97,0,33,6,200,145,1,0,97,0,33,6,94,179,1,0,97,0,
33,6,78,135,0,0,97,0,33,6,168,187,1,0,97,0,33,6,108,138,
1,0,97,0,33,6,244,176,1,0,97,0,33,6,194,146,1,0,97,0,
33,6,202,143,1,0,97,0,33,6,24,157,1,0,97,0,33,6,86,151,
1,0,97,0,33,6,84,21,0,0,97,0,33,6,170,168,1,0,97,0,
33,6,142,169,1,0,97,0,33,6,138,188,1,0,97,0,33,6,12,174,
1,0,97,0,33,6,86,132,1,0,97,0,33,6,158,150,1,0,97,0,
33,6,42,172,1,0,97,0,33,6,10,105,0,0,97,0,33,6,2,154,
1,0,97,0,33,6,196,147,1,0,97,0,33,6,226,18,0,0,97,0,
33,6,6,105,0,0,97,0,33,6,150,34,0,0,97,0,33,6,128,27,
0,0,97,0,33,6,4,165,1,0,97,0,33,6,164,167,1,0,97,0,
33,6,142,131,1,0,97,0,33,6,230,168,1,0,97,0,33,6,76,164,
1,0,97,0,33,6,156,161,1,0,97,0,34,6,232,203,142,0,42,6,
220,203,142,0,41,6,208,203,142,0,8,138,98,143,1,0,32,134,20,0,
98,135,5,0,47,6,216,80,134,0,98,127,9,0,32,118,28,0,106,119,
1,0,12,106,106,111,5,0,44,6,240,80,134,0,106,103,9,0,105,7,
1,0,2,90,105,95,5,0,42,6,244,79,134,0,105,87,9,0,127,0,
128,7,225,48,6,208,7,216,8,232,32,54,244,0,129,255,150,41,10,224,
28,48,32,62,32,0,4,66,190,255,54,132,29,48,28,56,32,70,244,0,
128,255,122,9,10,232,26,48,28,56,253,217,253,223,60,67,190,255,188,130,
28,48,129,255,130,41,29,80,64,6,255,48,144,7,225,16,6,224,3,48,
7,216,0,58,8,232,32,70,32,0,190,255,248,131,3,135,0,0,32,142,
28,0,67,143,3,0,3,119,1,0,208,134,240,0,144,134,2,0,67,135,
0,0,206,118,240,0,142,118,1,0,67,119,1,0,35,54,4,0,104,234,
232,239,18,67,39,6,140,173,133,0,190,255,94,130,60,71,49,0,136,71,
27,0,35,54,12,0,32,62,20,0,191,255,86,255,27,48,3,56,29,64,
190,255,64,130,32,86,32,0,80,6,255,16,130,7,33,0,37,142,80,134,
17,127,0,0,35,134,1,0,80,127,0,0,17,119,1,0,7,16,80,119,
1,0,17,111,2,0,224,17,80,111,2,0,190,5,0,82,149,13,35,62,
1,0,99,18,227,23,28,67,190,255,252,129,3,82,66,6,63,0,198,15,
53,0,102,63,1,0,127,0,128,7,225,241,6,192,135,0,8,224,9,232,
0,186,0,218,28,200,7,208,38,6,152,173,133,0,129,255,76,60,224,209,
130,13,26,6,128,255,210,13,26,6,125,255,226,21,229,29,28,54,4,0,
29,62,252,255,191,255,124,255,10,216,213,29,56,71,49,0,136,71,27,0,
29,62,252,255,28,54,4,0,191,255,164,254,10,216,149,21,24,48,28,62,
4,0,29,70,252,255,191,255,218,254,10,216,133,13,38,6,172,173,133,0,
129,255,246,59,32,190,13,1,89,223,3,0,89,7,0,0,89,215,1,0,
27,134,4,0,253,129,253,135,50,59,24,48,191,255,102,255,23,80,64,6,
255,241,128,7,225,241,6,192,7,216,8,184,9,208,32,94,13,1,0,234,
26,6,193,255,234,207,0,0,0,226,64,134,134,0,48,142,12,80,220,137,
49,87,1,0,23,64,59,63,1,0,42,127,1,0,167,65,1,18,250,121,
194,5,224,201,162,5,0,18,130,0,224,17,210,21,42,23,9,0,72,18,
34,55,0,0,34,95,5,0,216,57,63,6,156,127,129,0,202,49,107,0,
10,16,59,87,1,0,0,90,194,81,123,87,1,0,68,226,65,234,99,234,
182,213,11,80,64,6,255,241,128,7,225,241,6,216,7,224,61,6,24,80,
134,0,245,61,28,56,38,6,188,173,133,0,129,255,54,59,27,143,0,0,
0,210,0,202,209,198,63,0,24,6,193,255,234,191,0,0,61,134,244,255,
217,129,48,87,1,0,42,119,1,0,1,18,248,113,194,5,224,185,162,5,
0,18,130,0,224,17,178,29,42,23,9,0,27,56,2,22,16,0,34,55,
0,0,34,95,5,0,28,64,63,6,38,128,129,0,202,49,107,0,224,81,
143,13,32,62,210,1,224,81,234,13,32,62,209,1,181,13,170,225,202,217,
68,202,65,210,99,210,182,213,224,225,154,197,28,56,231,0,7,80,64,6,
255,241,0,90,6,22,3,0,6,143,0,0,2,135,0,0,49,129,70,135,
0,0,2,111,0,0,48,105,66,111,0,0,6,87,0,0,95,18,65,90,
45,81,70,87,0,0,65,50,98,90,182,237,127,0,128,7,225,112,6,216,
59,63,49,0,135,63,27,0,8,200,9,208,38,6,228,173,133,0,129,255,
104,58,59,231,49,0,185,239,9,0,153,135,9,0,185,119,7,0,188,231,
27,0,153,103,7,0,200,130,16,233,208,114,14,233,216,98,12,233,100,234,
241,61,195,226,28,142,8,0,253,137,253,143,50,203,26,48,25,64,0,58,
190,255,10,129,122,231,1,0,28,62,8,0,27,48,191,255,172,253,26,48,
191,255,98,255,29,6,240,255,249,37,26,230,8,0,32,214,64,0,25,22,
248,255,131,18,2,6,191,255,161,5,2,208,0,234,133,29,59,23,49,0,
34,23,17,0,0,82,224,17,178,5,130,87,1,0,29,96,140,0,234,97,
169,13,92,239,1,0,29,56,38,6,212,173,133,0,129,255,204,57,72,226,
65,234,250,233,134,237,0,82,64,6,255,112,0,90,6,22,7,0,6,143,
0,0,2,135,0,0,49,129,70,135,0,0,2,111,0,0,48,105,66,111,
0,0,6,87,0,0,95,18,65,90,45,81,70,87,0,0,65,50,100,90,
182,237,127,0,128,7,225,0,168,135,1,0,6,224,16,6,240,255,194,5,
32,86,1,1,197,53,9,232,29,48,0,58,32,70,32,0,190,255,70,128,
60,103,49,0,44,103,17,0,0,106,156,23,19,0,224,97,178,5,140,111,
1,0,0,82,0,90,237,17,137,13,244,23,66,2,204,17,34,95,17,0,
34,87,13,0,1,114,10,64,174,65,225,79,0,0,139,73,125,71,1,0,
125,79,5,0,29,48,191,255,102,255,32,126,0,2,125,127,9,0,61,54,
8,0,191,255,92,254,0,82,64,6,255,0,128,7,97,0,196,207,84,144,
0,234,218,13,200,207,1,0,38,55,49,0,210,5,0,58,128,255,38,5,
197,5,190,255,46,205,10,232,29,80,64,6,127,0,134,7,225,48,8,239,
1,0,6,216,59,63,49,0,221,238,1,0,200,199,4,0,135,63,27,0,
194,85,38,6,28,174,133,0,129,255,186,56,224,233,226,5,38,6,16,174,
133,0,129,255,172,56,37,54,83,134,129,255,164,56,0,226,0,234,1,210,
149,37,59,87,49,0,42,87,5,0,42,23,105,0,29,64,2,22,184,0,
34,63,0,0,34,143,5,0,3,48,63,6,148,130,129,0,202,57,113,0,
35,23,1,0,194,134,1,0,130,13,222,18,159,18,218,5,26,112,253,119,
192,0,14,225,65,234,4,111,233,135,237,233,214,221,59,23,45,0,99,231,
5,0,35,62,4,0,34,87,0,0,38,6,0,147,145,0,99,23,9,0,
31,66,65,82,98,87,0,0,128,255,204,254,32,54,12,177,64,62,1,0,
0,66,190,255,242,163,197,13,38,6,0,174,133,0,129,255,20,56,191,255,
174,249,59,55,49,0,191,255,174,249,0,82,70,6,255,48,128,7,225,0,
38,23,49,0,8,232,189,143,1,0,130,23,27,0,209,54,1,0,9,224,
100,23,1,143,128,255,204,25,252,23,7,0,253,127,9,0,2,54,8,0,
15,56,166,57,220,49,191,255,126,252,64,6,255,0,128,7,225,0,38,23,
49,0,8,232,189,143,1,0,130,23,27,0,209,54,1,0,9,224,100,23,
1,143,128,255,146,25,188,127,3,0,157,119,5,0,15,54,4,0,14,56,
166,57,220,49,191,255,68,252,64,6,255,0,0,90,6,22,1,0,6,143,
0,0,2,135,0,0,49,129,70,135,0,0,2,111,0,0,48,105,66,111,
0,0,6,87,0,0,95,18,65,90,45,81,70,87,0,0,65,50,97,90,
182,237,127,0,130,7,225,48,6,208,58,23,49,0,9,232,221,135,4,0,
29,48,8,138,130,23,27,0,125,7,6,0,8,80,170,135,7,0,100,23,
1,143,10,23,2,0,138,111,9,0,93,7,2,0,216,18,158,18,100,23,
5,143,29,23,4,0,93,7,3,0,93,7,5,0,200,130,194,22,1,0,
93,23,4,0,13,216,99,143,1,0,10,143,2,0,16,217,219,0,27,64,
209,78,63,0,3,56,191,255,36,251,35,23,1,0,10,224,29,48,94,18,
125,23,0,0,191,255,84,255,35,127,1,0,26,48,251,121,251,127,60,59,
191,255,94,250,28,80,66,6,255,48,130,7,225,48,6,216,59,23,49,0,
130,23,27,0,8,224,4,138,9,208,100,23,1,143,28,23,2,0,156,71,
5,0,9,232,99,143,1,0,216,18,158,18,100,23,5,143,8,16,224,17,
186,5,2,232,245,29,29,48,0,58,190,255,104,125,156,119,5,0,28,111,
2,0,29,48,3,56,14,64,205,78,63,0,191,255,166,250,35,23,1,0,
10,232,2,94,255,255,90,95,0,0,156,87,5,0,27,48,234,17,234,23,
60,59,191,255,228,249,29,80,66,6,255,48,128,7,225,0,6,224,9,232,
29,48,0,58,8,66,190,255,28,125,60,87,49,0,42,87,17,0,0,90,
156,23,19,0,224,81,178,5,138,95,1,0,0,66,0,74,235,17,137,13,
244,23,66,2,202,17,34,79,17,0,34,71,13,0,31,130,233,129,234,5,
232,129,202,5,32,86,10,1,213,29,1,90,8,16,171,17,225,63,0,0,
137,57,186,5,127,18,161,5,31,18,125,23,1,0,29,48,191,255,46,251,
32,22,0,2,125,23,5,0,61,54,4,0,191,255,30,251,28,48,8,58,
191,255,90,249,0,82,64,6,255,0,128,7,225,48,6,208,7,216,27,224,
28,48,8,232,32,62,32,0,190,255,142,124,106,234,234,239,18,83,224,81,
242,21,28,16,36,94,68,136,65,90,11,119,255,255,65,18,224,113,66,119,
255,255,186,5,95,18,181,5,95,82,218,245,224,81,226,5,66,7,0,0,
65,18,95,82,202,253,107,234,243,21,58,55,49,0,5,66,60,62,11,0,
128,255,166,1,0,18,197,13,2,96,219,97,12,95,0,0,224,89,218,5,
32,86,32,0,76,87,0,0,65,18,253,17,198,245,64,6,255,48,128,7,
225,112,8,224,188,127,1,0,6,216,9,200,25,232,222,122,159,122,146,13,
38,6,48,174,133,0,129,255,36,53,32,86,13,1,149,109,220,199,1,0,
250,13,224,121,218,13,156,119,3,0,224,113,146,13,38,6,132,174,133,0,
129,255,2,53,32,86,13,1,133,93,156,215,5,0,29,48,0,58,26,64,
190,255,206,123,220,199,1,0,162,13,156,103,3,0,27,48,25,64,26,72,
12,56,191,255,114,248,213,69,221,39,3,0,221,15,7,0,29,87,0,0,
8,66,39,6,100,174,133,0,61,54,8,0,202,86,224,0,32,134,51,0,
29,119,3,0,3,122,93,87,0,0,93,135,4,0,93,127,2,0,206,118,
240,0,142,118,2,0,93,119,3,0,190,255,22,122,27,48,61,62,16,0,
32,70,16,0,191,255,198,254,61,54,32,0,39,6,117,174,133,0,4,66,
190,255,248,121,59,55,49,0,134,55,27,0,61,62,36,0,32,70,20,0,
128,255,146,0,32,86,56,0,26,6,200,255,234,215,34,59,27,48,191,255,
224,247,0,82,64,6,255,112,190,7,225,0,92,26,6,224,136,71,5,0,
9,232,29,48,0,58,190,255,20,123,3,48,190,255,50,128,163,63,11,0,
35,126,12,0,35,110,4,0,173,121,207,57,28,48,191,255,168,247,29,48,
35,62,4,0,32,70,124,0,190,255,140,121,0,82,68,26,126,6,255,0,
128,7,33,0,8,56,38,71,49,0,135,63,1,0,136,71,27,0,38,6,
212,174,133,0,129,255,230,51,0,82,64,6,63,0,0,82,127,0,0,82,
127,0,0,82,127,0,33,6,236,139,1,0,97,0,33,6,74,166,1,0,
97,0,33,6,86,188,1,0,97,0,1,66,128,7,148,12,128,7,193,0,
38,239,53,0,134,231,61,0,253,231,224,0,64,86,0,0,0,90,74,95,
144,244,64,6,223,0,128,7,193,0,38,239,53,0,134,231,61,0,253,231,
228,0,64,86,0,0,0,90,74,95,144,244,64,6,223,0,128,7,193,112,
0,210,6,224,60,239,41,0,156,223,49,0,253,223,224,0,64,86,0,0,
0,90,74,95,144,244,128,238,80,195,60,223,45,0,156,207,49,0,27,87,
0,0,138,0,1,18,249,23,192,0,74,17,130,0,224,17,186,5,95,234,
154,245,224,233,186,5,32,214,68,2,26,80,64,6,223,112,128,7,225,0,
6,248,63,239,41,0,159,231,49,0,253,231,228,0,64,86,0,0,0,90,
74,95,144,244,31,48,191,255,86,255,64,6,255,0,128,7,193,0,38,239,
57,0,134,231,61,0,29,87,0,0,138,0,1,18,252,23,192,0,74,17,
130,0,224,17,234,87,0,0,64,6,223,0,128,7,225,0,6,224,191,255,
94,255,10,232,5,50,128,255,42,191,28,48,191,255,160,255,5,50,128,255,
30,191,29,80,64,6,255,0,128,7,225,0,6,224,0,234,28,48,191,255,
210,255,224,81,202,5,65,234,105,234,150,253,64,6,255,0,128,7,97,0,
6,232,191,255,0,255,29,48,191,255,180,255,64,6,127,0,128,7,97,0,
6,232,191,255,206,254,29,48,191,255,160,255,64,6,127,0,128,7,225,0,
6,232,191,255,246,254,10,224,224,225,154,29,29,48,191,255,174,254,29,48,
191,255,90,255,224,81,202,5,32,86,69,2,229,13,29,48,191,255,182,254,
5,50,128,255,162,190,29,48,191,255,24,255,5,50,128,255,150,190,28,80,
64,6,255,0,128,7,225,0,6,224,191,255,2,255,28,48,191,255,142,254,
5,50,128,255,122,190,28,48,191,255,160,254,10,232,5,50,128,255,108,190,
28,48,191,255,86,254,5,50,128,255,96,190,29,80,64,6,255,0,128,7,
225,240,7,224,8,216,9,232,157,0,35,215,29,0,35,207,33,0,131,199,
37,0,224,49,138,13,32,54,64,0,129,255,104,28,10,48,224,49,146,29,
49,6,24,80,134,0,102,143,37,0,70,7,32,0,48,6,88,80,134,0,
102,135,37,0,102,215,41,0,102,207,45,0,70,199,48,0,102,231,53,0,
102,223,57,0,70,239,60,0,6,80,64,6,255,240,128,7,97,0,6,232,
39,6,20,176,133,0,191,255,212,253,29,48,191,255,208,254,29,48,191,255,
206,253,29,48,191,255,4,254,5,50,128,255,210,189,29,48,191,255,64,255,
29,48,191,255,58,255,29,48,191,255,52,255,64,6,127,0,128,7,225,16,
6,224,191,255,222,253,10,216,224,217,138,29,128,238,80,195,5,50,128,255,
162,189,28,48,191,255,62,254,224,81,178,5,95,234,170,253,28,48,191,255,
10,254,5,50,128,255,136,189,224,233,202,5,32,86,70,2,165,5,27,80,
64,6,255,16,128,7,225,48,6,224,7,232,93,7,0,0,0,210,157,143,
1,0,28,48,193,138,93,143,0,0,191,255,134,253,10,216,224,217,218,21,
5,50,128,255,78,189,28,48,191,255,234,253,157,23,1,0,28,48,10,17,
93,23,0,0,191,255,180,253,5,50,128,255,50,189,65,210,104,210,166,229,
224,217,194,5,28,48,191,255,150,254,27,80,64,6,255,48,128,7,225,48,
7,208,154,0,6,224,191,255,138,253,32,222,128,0,26,112,91,113,142,0,
28,48,224,113,194,5,191,255,234,252,181,5,191,255,2,253,28,48,191,255,
182,253,10,232,224,233,202,5,161,218,224,217,223,237,224,233,250,5,28,48,
191,255,32,255,10,232,224,233,194,5,28,48,191,255,64,254,29,80,64,6,
255,48,128,7,225,0,7,232,157,0,6,224,191,255,232,253,224,81,154,13,
28,48,29,56,191,255,148,255,224,81,178,5,32,86,64,2,64,6,255,0,
132,7,225,112,6,224,7,232,157,0,8,208,9,200,99,231,1,0,1,138,
67,143,4,0,28,216,27,48,31,58,190,255,74,123,224,81,186,253,59,6,
32,176,133,0,193,234,221,238,254,0,157,62,1,0,28,48,191,255,162,255,
10,232,224,233,194,53,131,119,5,0,224,113,242,13,67,7,4,0,35,55,
1,0,190,255,198,155,224,81,242,5,27,48,32,62,178,1,0,66,190,255,
158,122,29,80,165,69,29,56,218,57,191,255,186,254,224,81,226,21,131,95,
5,0,10,232,224,89,242,13,67,7,4,0,35,55,1,0,190,255,144,155,
224,81,242,5,27,48,32,62,178,1,0,66,190,255,104,122,29,80,245,37,
28,48,191,255,2,253,65,234,25,62,255,255,28,48,231,233,214,221,218,57,
191,255,116,254,28,48,191,255,254,252,28,48,191,255,80,253,131,143,5,0,
10,232,224,137,242,13,67,7,4,0,35,55,1,0,190,255,66,155,224,81,
242,5,27,48,32,62,178,1,0,66,190,255,26,122,29,80,68,6,255,112,
134,7,225,240,6,232,7,224,156,0,8,208,9,192,99,239,5,0,1,138,
67,143,8,0,29,216,27,48,31,58,190,255,90,122,224,81,186,253,59,6,
44,176,133,0,193,226,220,230,254,0,156,62,1,0,29,48,191,255,178,254,
10,224,224,225,242,21,131,119,9,0,10,232,224,113,242,13,67,7,8,0,
35,55,5,0,190,255,212,154,224,81,242,5,27,48,32,62,178,1,0,66,
190,255,172,121,29,80,128,7,24,1,29,48,26,56,191,255,198,253,224,81,
226,21,131,103,9,0,10,232,224,97,242,13,67,7,8,0,35,55,5,0,
190,255,156,154,224,81,242,5,27,48,32,62,178,1,0,66,190,255,116,121,
29,80,133,117,29,48,191,255,14,252,154,207,1,0,65,226,224,201,202,5,
28,6,206,255,182,221,1,226,149,69,248,225,135,37,35,62,3,0,191,255,
114,253,29,48,191,255,252,251,29,48,191,255,78,252,131,95,9,0,224,89,
242,13,67,7,8,0,35,55,5,0,190,255,66,154,224,81,242,5,27,48,
32,62,178,1,0,66,190,255,26,121,32,86,71,2,165,69,28,56,218,57,
191,255,52,253,224,81,226,21,131,135,9,0,10,224,224,129,242,13,67,7,
8,0,35,55,5,0,190,255,10,154,224,81,242,5,27,48,32,62,178,1,
0,66,190,255,226,120,28,80,245,37,29,48,191,255,124,251,65,226,25,62,
255,255,29,48,231,225,198,189,218,57,191,255,238,252,10,224,29,48,191,255,
118,251,29,48,191,255,200,251,131,119,9,0,224,113,242,13,67,7,8,0,
35,55,5,0,190,255,188,153,224,81,242,5,27,48,32,62,178,1,0,66,
190,255,148,120,28,80,70,6,255,240,132,7,225,240,6,208,7,232,157,0,
8,200,9,192,99,215,1,0,1,138,67,143,4,0,26,224,28,48,31,58,
190,255,212,120,224,81,186,253,59,6,56,176,133,0,193,234,157,0,26,48,
29,56,191,255,48,253,10,232,29,224,224,225,178,53,131,119,5,0,224,113,
242,13,67,7,4,0,35,55,1,0,190,255,82,153,224,81,242,5,27,48,
32,62,178,1,0,66,190,255,42,120,29,80,245,53,28,104,217,105,141,63,
1,0,191,255,158,252,10,232,224,233,210,21,131,87,5,0,224,81,242,13,
67,7,4,0,35,55,1,0,190,255,24,153,224,81,242,5,27,48,32,62,
178,1,0,66,190,255,240,119,29,80,165,29,65,226,26,48,248,225,134,229,
191,255,240,250,131,143,5,0,224,137,242,13,67,7,4,0,35,55,1,0,
190,255,228,152,224,81,242,5,27,48,32,62,178,1,0,66,190,255,188,119,
29,80,68,6,255,240,132,7,225,112,6,224,7,232,157,0,8,208,154,0,
9,200,99,231,1,0,1,138,67,143,4,0,28,216,27,48,31,58,190,255,
250,119,224,81,186,253,59,6,68,176,133,0,193,234,157,0,28,48,29,56,
191,255,86,252,224,81,226,21,131,119,5,0,10,232,224,113,242,13,67,7,
4,0,35,55,1,0,190,255,122,152,224,81,242,5,27,48,32,62,178,1,
0,66,190,255,82,119,29,80,229,85,28,48,26,56,191,255,202,251,224,81,
226,21,131,95,5,0,10,232,224,89,242,13,67,7,4,0,35,55,1,0,
190,255,68,152,224,81,242,5,27,48,32,62,178,1,0,66,190,255,28,119,
29,80,181,61,157,62,1,0,28,48,191,255,232,251,224,81,226,21,131,135,
5,0,10,232,224,129,242,13,67,7,4,0,35,55,1,0,190,255,12,152,
224,81,242,5,27,48,32,62,178,1,0,66,190,255,228,118,29,80,245,29,
28,48,25,56,191,255,0,251,10,232,28,48,191,255,136,249,28,48,191,255,
218,249,131,127,5,0,224,121,242,13,67,7,4,0,35,55,1,0,190,255,
206,151,224,81,242,5,27,48,32,62,178,1,0,66,190,255,166,118,29,80,
68,6,255,112,132,7,225,112,6,224,7,232,157,0,8,208,154,0,9,200,
153,0,99,231,1,0,1,138,67,143,4,0,28,216,27,48,31,58,190,255,
226,118,224,81,186,253,59,6,80,176,133,0,193,234,157,0,28,48,29,56,
191,255,62,251,224,81,226,21,131,119,5,0,10,232,224,113,242,13,67,7,
4,0,35,55,1,0,190,255,98,151,224,81,242,5,27,48,32,62,178,1,
0,66,190,255,58,118,29,80,229,77,28,48,26,56,191,255,178,250,224,81,
226,21,131,95,5,0,10,232,224,89,242,13,67,7,4,0,35,55,1,0,
190,255,44,151,224,81,242,5,27,48,32,62,178,1,0,66,190,255,4,118,
29,80,181,53,28,48,25,56,191,255,124,250,224,81,226,21,131,135,5,0,
10,232,224,129,242,13,67,7,4,0,35,55,1,0,190,255,246,150,224,81,
242,5,27,48,32,62,178,1,0,66,190,255,206,117,29,80,133,29,28,48,
191,255,212,248,131,127,5,0,10,232,224,121,242,13,67,7,4,0,35,55,
1,0,190,255,198,150,224,81,242,5,27,48,32,62,178,1,0,66,190,255,
158,117,29,80,68,6,255,112,128,7,225,48,6,232,35,215,21,0,61,23,
37,0,136,0,7,224,156,0,34,135,8,0,28,120,34,111,13,0,15,56,
16,48,221,49,9,216,63,6,98,144,129,0,109,0,224,81,218,21,61,23,
37,0,28,136,17,56,27,134,1,0,34,87,40,0,16,64,34,119,45,0,
26,126,255,255,10,48,221,49,15,72,63,6,142,144,129,0,110,0,64,6,
255,48,132,7,225,240,7,232,157,0,8,224,156,0,9,200,35,199,37,0,
6,208,99,215,1,0,1,138,67,143,4,0,26,216,27,48,31,58,190,255,
122,117,224,81,186,253,59,6,92,176,133,0,193,234,157,0,26,48,29,56,
191,255,214,249,10,232,224,233,210,21,131,119,5,0,224,113,242,13,67,7,
4,0,35,55,1,0,190,255,250,149,224,81,242,5,27,48,32,62,178,1,
0,66,190,255,210,116,29,80,181,85,26,48,28,56,191,255,74,249,10,232,
29,224,224,225,178,53,131,95,5,0,224,89,242,13,67,7,4,0,35,55,
1,0,190,255,194,149,224,81,242,5,27,48,32,62,178,1,0,66,190,255,
154,116,29,80,245,53,28,80,217,81,138,63,1,0,191,255,14,249,10,232,
224,233,210,21,131,127,5,0,224,121,242,13,67,7,4,0,35,55,1,0,
190,255,136,149,224,81,242,5,27,48,32,62,178,1,0,66,190,255,96,116,
29,80,165,29,65,226,26,48,248,225,134,229,191,255,96,247,131,119,5,0,
224,113,242,13,67,7,4,0,35,55,1,0,190,255,84,149,224,81,242,5,
27,48,32,62,178,1,0,66,190,255,44,116,29,80,68,6,255,240,134,7,
225,112,6,216,7,232,157,0,8,224,156,0,9,200,99,223,5,0,1,138,
67,143,8,0,27,208,26,48,31,58,190,255,106,116,224,81,186,253,27,48,
29,56,28,64,25,72,1,114,99,119,1,0,128,255,106,1,131,111,9,0,
10,232,224,105,146,21,67,7,8,0,35,55,5,0,190,255,238,148,224,81,
146,13,38,6,116,176,133,0,32,62,178,1,0,66,190,255,194,115,29,80,
70,6,255,112,136,7,225,48,6,216,7,232,157,0,8,224,156,0,67,79,
7,0,99,223,9,0,1,138,67,143,12,0,27,208,26,48,31,58,190,255,
254,115,224,81,186,253,27,48,29,56,28,64,99,7,1,0,35,78,7,0,
128,255,254,0,131,119,13,0,10,232,224,113,146,21,67,7,12,0,35,55,
9,0,190,255,130,148,224,81,146,13,38,6,128,176,133,0,32,62,178,1,
0,66,190,255,86,115,29,80,72,6,255,48,128,7,225,240,6,208,7,224,
156,0,8,216,155,0,35,199,29,0,9,200,0,234,133,29,58,23,37,0,
28,120,15,56,27,88,34,135,8,0,221,89,139,0,11,64,16,48,218,49,
34,143,13,0,29,72,217,73,63,6,188,146,129,0,113,0,224,81,202,5,
65,234,248,233,134,237,64,6,255,240,128,7,225,240,6,208,7,224,156,0,
8,216,155,0,35,199,29,0,9,200,0,234,165,29,58,23,37,0,28,120,
15,56,27,88,34,55,16,0,221,89,139,0,29,80,218,49,217,81,138,143,
1,0,34,135,21,0,11,64,63,6,14,147,129,0,17,72,112,0,224,81,
202,5,65,234,248,233,230,229,64,6,255,240,128,7,33,0,32,54,12,177,
64,62,4,0,0,66,190,255,174,147,64,14,32,0,225,143,111,0,100,143,
224,142,228,23,225,142,97,23,110,0,64,6,63,0,132,7,225,240,7,216,
155,0,8,208,131,207,37,0,61,6,0,0,32,0,253,143,111,0,154,0,
9,192,0,226,100,143,224,142,196,255,225,142,138,61,26,120,200,122,27,104,
193,106,15,105,25,80,13,81,125,87,108,0,224,201,218,5,152,23,1,0,
125,23,106,0,196,191,224,142,196,55,224,142,196,47,224,142,64,62,4,0,
1,66,228,23,225,142,35,78,4,0,31,122,32,54,12,177,125,23,110,0,
99,127,1,0,190,255,28,147,196,215,224,142,210,5,65,226,99,226,182,213,
197,13,196,207,224,142,154,13,97,202,218,5,253,111,107,0,88,111,0,0,
0,82,181,5,32,86,65,2,68,6,255,240,128,7,97,0,6,232,157,143,
33,0,224,137,202,21,125,71,29,0,128,255,30,242,224,81,146,13,38,6,
32,177,133,0,32,62,198,0,0,66,190,255,190,113,1,130,93,135,32,0,
100,239,245,142,64,6,127,0,128,7,97,0,6,232,157,143,45,0,224,137,
170,21,128,255,174,227,224,81,146,13,38,6,80,177,133,0,32,62,74,0,
0,66,190,255,138,113,1,130,93,135,44,0,100,239,241,142,64,6,127,0,
100,7,253,142,127,0,128,7,65,0,0,143,48,177,32,126,159,255,166,0,
197,50,79,137,17,49,64,55,48,177,198,238,255,0,64,86,0,0,74,239,
8,240,64,6,95,0,128,7,33,0,32,23,45,177,36,143,253,142,34,87,
9,0,72,138,100,143,253,142,234,137,218,5,34,23,5,0,100,23,253,142,
36,55,253,142,6,55,0,0,191,255,174,255,36,87,253,142,42,87,5,0,
64,6,63,0,128,7,97,0,36,143,249,142,224,137,250,13,191,255,186,255,
34,6,52,60,2,0,234,23,32,2,32,86,232,3,74,16,224,17,100,23,
249,142,178,21,36,23,249,142,128,238,255,255,245,17,199,5,128,54,255,255,
181,5,2,232,29,48,128,255,172,0,36,127,249,142,189,121,100,127,249,142,
64,6,127,0,128,7,33,0,48,6,52,60,2,0,230,135,32,2,32,110,
232,3,77,128,100,135,249,142,191,255,152,255,64,86,0,0,43,6,115,0,
0,0,74,95,100,245,64,6,63,0,128,7,97,0,32,143,45,177,6,232,
224,137,162,29,224,233,162,45,61,55,5,0,224,49,162,13,61,87,9,0,
6,16,165,5,72,18,234,17,234,253,129,255,186,17,125,7,5,0,125,7,
9,0,125,7,13,0,29,48,129,255,168,17,181,21,61,23,5,0,2,55,
0,0,100,23,253,142,96,239,45,177,191,255,208,254,36,55,253,142,38,55,
5,0,224,49,178,5,191,255,114,255,64,6,127,0,191,7,26,255,33,6,
90,100,0,0,97,0,128,7,225,16,6,216,0,226,0,234,165,37,28,56,
38,6,92,177,133,0,129,255,72,37,59,23,1,0,221,17,34,71,5,0,
34,79,9,0,38,6,104,177,133,0,129,255,48,37,59,23,1,0,221,17,
34,71,13,0,34,79,17,0,38,6,124,177,133,0,129,255,24,37,29,238,
20,0,65,226,59,87,1,0,0,18,224,81,178,5,138,23,1,0,226,225,
241,213,64,6,255,16,128,7,97,0,7,16,38,63,1,0,0,234,224,57,
130,21,167,143,1,0,224,137,194,13,0,234,224,57,178,5,135,239,1,0,
29,64,244,71,66,2,2,48,190,255,80,106,29,80,64,6,127,0,128,7,
225,240,35,215,29,0,6,216,59,55,1,0,154,239,1,0,9,200,8,192,
224,49,178,5,129,255,248,16,224,209,138,13,37,54,88,134,32,62,3,1,
0,66,190,255,90,111,29,6,192,255,135,13,29,64,37,54,88,134,32,62,
4,1,190,255,70,111,1,226,224,233,226,5,186,135,1,0,224,129,162,5,
0,226,156,0,224,225,162,5,1,234,244,239,66,2,29,48,129,255,148,16,
123,87,1,0,224,81,138,13,37,54,88,134,32,62,17,1,0,66,190,255,
14,111,59,55,1,0,224,225,146,21,1,130,70,135,0,0,70,7,1,0,
70,7,2,0,102,199,13,0,102,207,17,0,102,7,5,0,102,7,9,0,
213,5,26,56,29,64,190,255,158,105,59,23,1,0,0,82,224,17,178,5,
130,87,1,0,64,6,255,240,134,7,225,243,99,55,1,0,132,135,217,136,
99,71,5,0,99,79,9,0,131,239,49,0,224,129,226,21,164,23,217,136,
224,17,242,13,35,63,9,0,35,55,5,0,0,74,2,64,129,255,232,57,
10,214,1,0,225,223,0,0,203,217,229,5,31,210,0,218,181,5,9,216,
8,208,35,111,5,0,35,119,9,0,14,105,194,5,26,80,27,81,154,13,
38,6,140,177,133,0,129,255,164,35,0,82,128,7,106,2,35,119,1,0,
46,119,1,0,224,113,186,5,128,7,114,1,224,233,186,5,128,7,106,1,
0,226,0,234,0,178,224,113,178,5,142,183,1,0,0,122,213,13,46,87,
13,0,46,111,17,0,202,225,225,95,0,0,205,89,203,233,14,118,20,0,
65,122,246,121,182,245,35,119,9,0,253,113,225,5,203,13,35,103,5,0,
252,97,137,13,37,54,96,134,32,62,142,0,0,66,190,255,250,109,35,87,
9,0,253,81,138,13,35,127,5,0,252,121,202,5,22,80,128,7,238,1,
35,87,1,0,35,119,9,0,35,71,5,0,22,104,42,87,1,0,244,111,
64,2,188,65,225,79,0,0,13,22,236,255,202,17,34,207,17,0,142,73,
189,73,34,199,13,0,251,201,235,45,177,5,250,193,185,45,26,48,184,49,
225,63,0,0,155,57,185,57,231,73,177,21,187,5,230,65,131,21,98,215,
13,0,98,223,17,0,166,65,225,207,0,0,185,73,167,73,198,225,225,135,
0,0,208,57,199,233,149,21,34,103,13,0,34,111,17,0,22,80,204,65,
98,71,13,0,225,103,0,0,201,97,205,97,98,103,17,0,128,7,98,1,
8,48,26,64,1,82,170,49,225,63,0,0,137,57,27,72,129,255,148,56,
65,82,202,177,22,200,244,207,66,2,25,48,129,255,164,14,10,192,224,193,
138,13,37,54,96,134,32,62,176,0,0,66,190,255,32,109,24,48,25,64,
0,58,190,255,52,105,35,63,1,0,39,63,1,0,0,202,224,57,178,5,
135,207,1,0,25,64,244,71,64,2,24,48,190,255,184,103,35,55,1,0,
38,55,1,0,129,255,120,14,35,143,1,0,113,199,1,0,197,109,35,55,
1,0,38,55,1,0,129,255,98,14,35,55,5,0,1,82,35,95,9,0,
26,64,170,49,225,63,0,0,139,57,27,72,129,255,12,56,10,182,1,0,
22,232,244,239,66,2,29,48,129,255,28,14,35,143,1,0,224,81,113,87,
1,0,138,13,37,54,96,134,32,62,205,0,0,66,190,255,146,108,35,55,
1,0,38,55,1,0,0,58,29,64,190,255,160,104,0,226,0,234,0,202,
133,61,25,16,244,23,64,2,12,80,132,127,217,136,194,81,74,7,0,0,
0,90,224,121,210,5,97,178,183,5,32,94,128,0,74,95,1,0,74,207,
2,0,22,118,255,255,238,201,206,5,26,64,27,72,165,13,35,71,5,0,
35,119,9,0,188,65,225,79,0,0,142,73,189,73,35,111,1,0,45,111,
1,0,205,17,98,71,13,0,98,239,9,0,98,79,17,0,98,231,5,0,
218,225,225,79,0,0,219,73,201,233,65,202,35,103,1,0,246,201,44,103,
1,0,198,197,76,183,0,0,22,80,70,6,255,243,128,7,225,16,7,216,
59,23,1,0,0,226,6,232,224,17,178,5,130,231,1,0,61,55,1,0,
224,49,178,5,129,255,96,13,224,225,146,29,244,231,66,2,28,48,129,255,
54,13,125,87,1,0,224,81,138,13,37,54,104,134,32,62,68,1,0,66,
190,255,176,107,61,55,1,0,59,63,1,0,28,64,190,255,98,102,181,5,
125,231,1,0,29,80,64,6,255,16,128,7,225,0,6,232,7,224,224,233,
194,13,61,55,1,0,224,49,178,5,129,255,10,13,129,226,201,5,29,48,
129,255,196,12,64,6,255,0,128,7,33,0,224,49,250,5,4,50,129,255,
48,11,10,48,224,49,178,5,102,7,1,0,6,80,64,6,63,0,38,87,
5,0,127,0,128,7,225,0,6,224,60,71,5,0,7,232,29,48,0,58,
190,255,86,103,60,135,1,0,208,134,127,0,93,135,0,0,60,111,5,0,
65,234,8,98,94,106,93,111,0,0,65,234,93,103,0,0,60,87,5,0,
64,6,255,0,128,7,225,16,6,216,59,143,5,0,7,23,1,0,8,80,
17,70,254,255,232,17,146,13,2,56,38,6,248,177,133,0,129,255,42,32,
0,82,229,125,7,23,0,0,194,134,192,0,146,13,2,56,38,6,44,178,
133,0,129,255,16,32,31,82,149,117,7,23,2,0,194,126,1,0,154,13,
2,56,38,6,176,177,133,0,129,255,246,31,31,82,197,101,61,6,72,155,
145,0,61,71,5,0,10,22,254,255,232,17,158,13,2,56,38,6,164,178,
133,0,129,255,212,31,0,82,181,85,61,23,49,0,7,118,2,0,36,79,
1,143,14,56,2,22,16,0,34,55,0,0,34,111,5,0,1,66,63,6,
96,155,129,0,221,49,109,0,36,63,1,143,10,224,61,102,13,0,199,97,
140,87,1,0,224,81,210,13,224,225,186,13,38,6,216,177,133,0,0,58,
129,255,134,31,59,87,5,0,128,81,165,45,224,225,159,13,28,56,38,6,
92,178,133,0,129,255,110,31,28,80,133,37,61,134,29,0,199,129,144,119,
1,0,0,18,224,113,146,13,61,110,13,0,199,105,141,95,1,0,224,89,
170,5,1,18,130,0,224,17,178,13,29,55,12,0,128,255,174,30,10,56,
38,6,116,178,133,0,129,255,48,31,59,87,5,0,64,6,255,16,128,7,
225,240,6,224,60,55,5,0,8,200,7,192,129,255,72,11,10,232,60,71,
5,0,29,208,29,48,0,58,190,255,230,101,59,6,72,155,145,0,36,63,
1,143,27,55,12,0,128,255,238,30,224,81,242,5,60,119,1,0,14,22,
128,0,162,0,181,5,28,23,0,0,93,23,0,0,60,103,5,0,65,234,
94,98,93,103,0,0,36,23,5,143,65,234,97,18,209,5,130,37,99,18,
225,53,234,61,38,6,12,179,133,0,129,255,180,30,59,23,49,0,36,79,
1,143,29,56,72,18,34,55,0,0,34,95,5,0,25,64,63,6,118,156,
129,0,219,49,107,0,224,81,202,45,26,48,129,255,216,10,31,82,213,53,
38,6,48,179,133,0,129,255,124,30,36,143,1,143,59,134,13,0,208,137,
145,127,1,0,224,121,218,5,4,114,93,119,0,0,213,21,38,6,84,179,
133,0,129,255,88,30,245,13,38,6,128,179,133,0,129,255,76,30,1,106,
93,111,0,0,229,5,38,6,240,178,133,0,129,255,58,30,60,71,5,0,
232,201,174,5,25,64,24,48,26,56,190,255,170,99,26,48,129,255,112,10,
60,87,5,0,64,6,255,240,68,55,28,137,127,0,130,7,225,48,61,6,
152,173,145,0,59,6,204,86,134,0,60,6,172,151,145,0,37,62,160,134,
38,6,184,149,145,0,0,66,0,74,128,255,190,56,36,62,144,142,38,6,
152,156,145,0,2,66,0,74,128,255,172,56,39,6,168,183,141,0,38,6,
204,156,145,0,32,70,16,0,0,74,128,255,150,56,36,62,128,136,1,66,
99,71,1,0,38,6,4,158,145,0,0,74,128,255,148,54,36,62,129,136,
1,66,99,71,1,0,38,6,60,158,145,0,0,74,128,255,126,54,36,62,
131,136,1,66,99,71,1,0,38,6,116,158,145,0,0,74,128,255,104,54,
36,62,128,142,3,106,99,111,1,0,38,6,108,154,145,0,1,66,0,74,
128,255,80,54,38,6,128,155,145,0,32,62,168,176,1,66,99,71,1,0,
0,74,128,255,58,54,43,6,108,86,134,0,49,6,176,155,145,0,113,95,
1,0,36,62,233,135,38,6,88,153,145,0,1,66,128,255,76,55,39,6,
108,82,134,0,6,82,99,87,1,0,38,6,116,151,145,0,32,70,0,4,
0,74,128,255,254,53,28,48,29,56,0,66,0,74,128,255,222,55,48,6,
100,89,134,0,124,135,49,0,124,239,53,0,38,6,228,151,145,0,29,56,
0,66,0,74,128,255,192,55,47,6,132,89,134,0,49,6,20,152,145,0,
113,127,1,0,49,6,24,152,145,0,113,239,1,0,37,62,114,135,38,6,
28,152,145,0,2,66,0,74,128,255,148,55,36,62,212,143,1,114,99,119,
1,0,38,6,244,162,145,0,2,66,0,74,128,255,144,53,38,6,160,163,
145,0,36,62,68,137,1,66,128,255,46,55,38,6,184,155,145,0,32,62,
169,176,1,66,99,71,1,0,0,74,128,255,106,53,44,6,140,86,134,0,
49,6,232,155,145,0,113,103,1,0,36,62,232,135,38,6,148,153,145,0,
1,66,0,74,128,255,52,55,38,6,172,158,145,0,36,62,130,136,1,66,
128,255,230,54,36,62,192,136,99,7,1,0,38,6,32,173,145,0,8,66,
1,74,128,255,34,53,38,6,240,155,145,0,32,62,170,176,1,66,128,255,
192,54,38,6,40,156,145,0,32,62,171,176,1,66,128,255,176,54,38,6,
68,161,145,0,36,62,216,136,1,66,128,255,160,54,36,62,36,136,38,6,
164,154,145,0,32,70,16,0,0,74,128,255,202,54,39,6,172,180,133,0,
38,6,80,152,145,0,32,70,16,0,0,74,128,255,180,54,39,6,108,24,
134,0,38,6,200,153,145,0,32,70,16,0,0,74,128,255,158,54,36,62,
56,136,38,6,216,154,145,0,8,66,0,74,128,255,140,54,39,6,200,221,
136,0,38,6,36,153,145,0,8,66,0,74,128,255,120,54,39,6,152,209,
150,0,38,6,228,158,145,0,8,66,0,74,128,255,100,54,36,62,68,136,
38,6,12,155,145,0,32,70,16,0,128,255,152,53,39,6,84,82,134,0,
38,6,124,149,145,0,32,70,20,0,128,255,132,53,39,6,16,222,136,0,
38,6,124,172,145,0,4,66,0,74,128,255,42,54,37,62,152,134,38,6,
72,149,145,0,4,66,0,74,128,255,24,54,37,62,148,134,38,6,20,149,
145,0,4,66,0,74,128,255,6,54,37,62,156,134,38,6,224,148,145,0,
4,66,0,74,128,255,244,53,37,62,168,134,38,6,172,148,145,0,2,66,
0,74,128,255,226,53,37,62,170,134,38,6,120,148,145,0,2,66,0,74,
128,255,208,53,39,6,196,180,133,0,38,6,68,148,145,0,9,66,0,74,
128,255,188,53,39,6,208,180,133,0,38,6,16,148,145,0,9,66,0,74,
128,255,168,53,38,6,60,151,145,0,29,56,0,66,0,74,128,255,152,53,
43,6,68,89,134,0,49,6,108,151,145,0,113,95,1,0,49,6,112,151,
145,0,113,239,1,0,32,62,190,180,38,6,180,161,145,0,1,66,32,78,
32,0,128,255,106,53,38,6,4,151,145,0,29,56,0,66,0,74,128,255,
90,53,42,6,36,89,134,0,49,6,52,151,145,0,113,87,1,0,49,6,
56,151,145,0,113,239,1,0,38,6,204,150,145,0,29,56,0,66,0,74,
128,255,48,53,48,6,164,89,134,0,49,6,252,150,145,0,113,135,1,0,
49,6,0,151,145,0,113,239,1,0,37,62,144,134,38,6,132,152,145,0,
1,66,0,74,128,255,4,53,38,6,148,150,145,0,29,56,0,66,0,74,
128,255,244,52,47,6,196,88,134,0,49,6,196,150,145,0,113,127,1,0,
49,6,200,150,145,0,113,239,1,0,37,62,164,134,38,6,184,152,145,0,
1,66,0,74,128,255,200,52,38,6,92,150,145,0,29,56,0,66,0,74,
128,255,184,52,46,6,228,88,134,0,49,6,140,150,145,0,113,119,1,0,
49,6,144,150,145,0,113,239,1,0,32,62,172,180,38,6,232,161,145,0,
8,66,32,78,32,0,128,255,138,52,39,6,24,229,152,0,38,6,72,155,
145,0,2,106,99,111,1,0,1,66,32,78,136,4,128,255,130,50,44,6,
172,86,134,0,49,6,120,155,145,0,113,103,1,0,32,62,192,180,2,90,
99,95,1,0,38,6,132,162,145,0,1,66,32,78,32,0,128,255,88,50,
32,62,193,180,2,82,99,87,1,0,38,6,188,162,145,0,1,66,32,78,
32,0,128,255,62,50,32,62,191,180,38,6,28,162,145,0,1,66,32,78,
32,0,128,255,22,52,39,6,152,45,153,0,2,130,99,135,1,0,38,6,
44,163,145,0,32,70,21,0,32,78,21,0,128,255,12,50,39,6,232,46,
153,0,38,6,100,163,145,0,32,70,20,0,32,78,20,0,128,255,240,50,
60,6,184,183,141,0,28,56,38,6,0,157,145,0,4,66,32,78,96,0,
128,255,200,51,60,62,4,0,38,6,52,157,145,0,4,66,32,78,96,0,
128,255,180,51,60,62,65,0,38,6,156,157,145,0,32,70,20,0,32,78,
96,0,128,255,158,51,60,62,24,0,38,6,208,157,145,0,32,70,40,0,
32,78,96,0,128,255,136,51,60,62,86,0,38,6,104,157,145,0,8,66,
32,78,96,0,128,255,116,51,38,6,36,150,145,0,29,56,0,66,0,74,
128,255,100,51,47,6,4,89,134,0,49,6,84,150,145,0,113,127,1,0,
49,6,88,150,145,0,113,239,1,0,36,62,214,143,38,6,80,162,145,0,
2,66,0,74,128,255,56,51,38,6,236,149,145,0,29,56,0,66,0,74,
128,255,40,51,46,6,164,88,134,0,49,6,28,150,145,0,113,119,1,0,
49,6,32,150,145,0,113,239,1,0,38,6,96,156,145,0,36,62,24,137,
0,66,128,255,192,50,38,6,236,152,145,0,36,62,28,137,0,66,128,255,
176,50,38,6,176,172,145,0,36,62,113,136,4,66,128,255,160,50,38,6,
232,172,145,0,36,62,112,136,4,66,128,255,144,50,36,62,69,137,4,106,
99,111,1,0,38,6,216,163,145,0,1,66,0,74,128,255,202,48,38,6,
12,172,145,0,36,62,12,136,4,66,128,255,104,50,38,6,68,172,145,0,
36,62,108,137,4,66,128,255,88,50,36,62,217,136,4,98,99,103,1,0,
38,6,124,161,145,0,1,66,0,74,128,255,146,48,36,62,120,176,38,6,
160,160,145,0,4,66,0,74,128,255,108,50,36,62,116,176,99,7,1,0,
38,6,212,160,145,0,4,66,0,74,128,255,106,48,38,6,12,161,145,0,
36,62,128,176,0,66,128,255,160,48,37,62,174,134,38,6,220,147,145,0,
1,66,0,74,128,255,52,50,38,6,48,160,145,0,36,62,83,143,1,66,
99,71,1,0,0,74,128,255,50,48,49,6,96,160,145,0,113,223,1,0,
38,6,104,160,145,0,36,62,84,143,1,66,99,71,1,0,0,74,128,255,
18,48,49,6,152,160,145,0,113,223,1,0,36,62,80,143,1,66,99,71,
1,0,38,6,24,159,145,0,0,74,128,255,242,47,36,62,81,143,1,66,
99,71,1,0,38,6,80,159,145,0,0,74,128,255,220,47,36,62,82,143,
1,66,99,71,1,0,38,6,136,159,145,0,0,74,128,255,198,47,37,62,
172,134,38,6,168,147,145,0,2,66,0,74,128,255,160,49,36,62,130,142,
1,106,99,111,1,0,38,6,52,154,145,0,2,66,0,74,128,255,156,47,
39,6,176,28,141,0,1,98,99,103,1,0,38,6,252,153,145,0,2,66,
2,74,128,255,130,47,39,6,100,213,152,0,38,6,192,159,145,0,1,90,
99,95,1,0,4,66,4,74,128,255,104,47,49,6,240,159,145,0,113,223,
1,0,39,6,128,213,152,0,38,6,248,159,145,0,1,82,99,87,1,0,
4,66,4,74,128,255,68,47,49,6,40,160,145,0,113,223,1,0,61,6,
192,28,141,0,38,6,16,164,145,0,29,56,4,66,2,74,128,255,138,43,
34,6,196,87,134,0,49,6,64,164,145,0,113,23,1,0,29,56,38,6,
76,164,145,0,32,70,20,0,3,74,128,255,174,43,38,6,60,82,134,0,
128,255,220,250,29,56,38,6,140,164,145,0,32,70,16,0,4,74,128,255,
76,43,29,56,38,6,200,164,145,0,32,70,16,0,5,74,128,255,58,43,
29,56,38,6,4,165,145,0,1,66,6,74,128,255,112,43,38,6,72,82,
134,0,128,255,158,250,38,6,68,165,145,0,29,56,32,70,32,0,7,74,
128,255,14,43,59,6,228,87,134,0,49,6,116,165,145,0,113,223,1,0,
38,6,128,165,145,0,29,56,12,66,8,74,128,255,238,42,58,6,36,88,
134,0,49,6,176,165,145,0,113,215,1,0,38,6,188,165,145,0,29,56,
12,66,9,74,128,255,206,42,49,6,236,165,145,0,113,215,1,0,38,6,
248,165,145,0,29,56,1,66,10,74,128,255,180,42,49,6,40,166,145,0,
113,223,1,0,38,6,52,166,145,0,29,56,1,66,11,74,128,255,154,42,
49,6,100,166,145,0,113,223,1,0,29,56,38,6,112,166,145,0,4,66,
12,74,128,255,128,42,29,56,38,6,172,166,145,0,1,66,13,74,128,255,
112,42,38,6,232,166,145,0,29,56,2,66,15,74,128,255,96,42,60,6,
4,88,134,0,49,6,24,167,145,0,113,231,1,0,38,6,36,167,145,0,
29,56,2,66,32,78,16,0,128,255,62,42,49,6,84,167,145,0,113,231,
1,0,38,6,96,167,145,0,29,56,1,66,32,78,18,0,128,255,34,42,
49,6,144,167,145,0,113,223,1,0,38,6,156,167,145,0,29,56,12,66,
32,78,19,0,128,255,6,42,49,6,204,167,145,0,113,215,1,0,38,6,
216,167,145,0,29,56,2,66,32,78,20,0,128,255,234,41,49,6,8,168,
145,0,113,231,1,0,38,6,20,168,145,0,29,56,12,66,32,78,21,0,
128,255,206,41,49,6,68,168,145,0,113,215,1,0,38,6,80,168,145,0,
29,56,2,66,32,78,17,0,128,255,178,41,49,6,128,168,145,0,113,231,
1,0,38,6,140,168,145,0,29,56,12,66,32,78,22,0,128,255,150,41,
49,6,188,168,145,0,113,215,1,0,38,6,244,169,145,0,29,56,1,66,
2,74,128,255,124,41,48,6,68,88,134,0,49,6,36,170,145,0,113,135,
1,0,38,6,48,170,145,0,29,56,32,70,20,0,2,74,128,255,90,41,
47,6,100,88,134,0,49,6,96,170,145,0,113,127,1,0,38,6,124,169,
145,0,29,56,4,66,8,74,128,255,58,41,49,6,172,169,145,0,113,231,
1,0,38,6,184,169,145,0,29,56,4,66,9,74,128,255,32,41,49,6,
232,169,145,0,113,231,1,0,38,6,200,168,145,0,29,56,4,66,32,78,
19,0,128,255,4,41,49,6,248,168,145,0,113,231,1,0,38,6,4,169,
145,0,29,56,4,66,32,78,21,0,128,255,232,40,49,6,52,169,145,0,
113,231,1,0,38,6,64,169,145,0,29,56,4,66,32,78,22,0,128,255,
204,40,49,6,112,169,145,0,113,231,1,0,29,56,38,6,108,170,145,0,
1,66,32,78,23,0,128,255,176,40,29,56,38,6,168,170,145,0,1,66,
32,78,24,0,128,255,158,40,38,6,228,170,145,0,29,56,2,66,32,78,
25,0,128,255,140,40,49,6,20,171,145,0,113,231,1,0,38,6,32,171,
145,0,29,56,2,66,32,78,26,0,128,255,112,40,49,6,80,171,145,0,
113,231,1,0,38,6,92,171,145,0,29,56,1,66,32,78,27,0,128,255,
84,40,49,6,140,171,145,0,113,223,1,0,38,6,152,171,145,0,29,56,
1,66,32,78,28,0,128,255,56,40,38,6,212,171,145,0,36,62,13,136,
49,6,200,171,145,0,113,223,1,0,3,114,99,119,1,0,1,66,0,74,
128,255,176,43,45,6,236,86,134,0,49,6,4,172,145,0,113,111,1,0,
36,103,221,136,36,95,245,136,34,6,148,81,134,0,36,87,249,136,98,103,
9,0,36,103,229,136,98,95,21,0,36,95,225,136,36,135,253,136,98,87,
33,0,36,87,1,137,98,103,93,0,98,135,45,0,36,119,237,136,36,135,
5,137,36,127,241,136,98,95,105,0,98,119,69,0,36,119,13,137,36,111,
233,136,98,127,57,0,36,127,9,137,98,135,129,0,98,111,81,0,36,111,
17,137,98,87,117,0,98,119,153,0,98,127,141,0,98,111,165,0,66,6,
255,48,128,7,97,0,6,232,8,50,128,255,102,254,61,71,57,0,125,87,
45,0,10,48,39,6,180,183,133,0,129,255,86,8,103,82,162,13,38,6,
192,183,133,0,32,62,245,8,0,66,190,255,206,92,224,81,64,6,127,0,
0,82,224,49,242,21,38,23,0,0,2,6,222,221,170,21,38,23,6,0,
224,17,231,13,230,127,5,0,230,103,3,0,15,94,8,0,235,97,234,5,
226,134,6,0,239,129,175,5,1,82,138,0,127,0,128,7,225,16,38,239,
1,0,8,216,7,224,29,48,191,255,188,255,224,81,138,13,28,48,27,64,
0,58,190,255,144,88,1,82,197,13,253,71,3,0,232,217,190,5,0,82,
229,5,28,48,29,56,190,255,26,87,1,82,64,6,255,16,166,0,34,6,
148,81,134,0,165,29,34,87,5,0,165,21,42,95,5,0,11,135,12,0,
240,49,186,13,43,126,13,0,199,121,79,7,0,0,43,110,29,0,199,105,
77,7,0,0,72,82,34,95,9,0,235,81,193,237,76,18,36,87,21,137,
234,17,193,229,127,0,128,7,225,48,6,232,61,23,57,0,2,6,240,255,
225,61,59,6,88,173,145,0,194,18,219,17,34,55,1,0,128,255,120,253,
61,215,1,0,26,48,191,255,30,255,224,81,202,13,61,63,57,0,2,50,
7,88,194,90,219,89,107,87,1,0,191,255,122,255,181,37,61,231,57,0,
250,55,3,0,194,226,219,225,128,255,40,253,61,71,1,0,61,143,57,0,
232,71,3,0,124,87,1,0,194,138,219,137,49,63,1,0,29,48,191,255,
12,255,224,81,170,13,38,6,208,183,133,0,32,62,30,9,0,66,190,255,
134,91,224,81,64,6,255,48,128,7,97,0,6,232,191,255,108,255,61,55,
57,0,190,255,176,249,64,6,127,0,128,7,97,0,7,232,224,49,138,13,
32,54,32,0,128,255,38,251,10,48,224,49,130,21,102,7,1,0,102,7,
9,0,102,7,18,0,102,7,21,0,49,6,184,149,145,0,102,143,25,0,
102,239,29,0,6,80,64,6,127,0,102,63,1,0,102,71,18,0,127,0,
128,7,225,16,6,232,7,224,8,216,224,233,138,13,32,54,56,0,128,255,
220,250,10,232,224,233,130,29,49,6,12,87,134,0,125,143,53,0,61,54,
8,0,27,56,191,255,142,255,93,7,48,0,125,231,1,0,28,62,8,0,
125,63,5,0,61,54,8,0,0,66,191,255,176,255,29,80,64,6,255,16,
128,7,225,16,6,232,7,224,8,216,224,233,138,13,32,54,60,0,128,255,
140,250,10,232,224,233,130,21,29,48,27,56,28,64,191,255,142,255,49,6,
92,87,134,0,125,143,53,0,125,231,57,0,29,48,191,255,156,253,29,80,
64,6,255,16,34,6,148,81,134,0,213,53,130,127,3,0,230,143,13,0,
34,87,0,0,47,112,81,113,206,0,234,113,154,45,34,95,5,0,245,29,
38,103,13,0,204,134,0,127,16,6,0,129,242,13,43,111,0,0,134,87,
17,0,237,81,154,21,2,119,2,0,162,143,3,0,76,113,142,0,241,113,
235,21,102,23,21,0,43,23,5,0,0,82,102,23,25,0,133,21,72,90,
34,127,9,0,239,89,241,221,32,86,12,1,133,13,76,18,36,119,21,137,
238,17,145,205,32,86,11,1,127,0,230,135,19,0,38,143,1,0,16,16,
16,126,5,0,209,17,207,137,102,143,1,0,162,111,1,0,130,95,1,0,
200,106,13,89,102,95,13,0,130,143,3,0,70,143,16,0,130,135,5,0,
162,119,3,0,102,7,5,0,200,130,16,113,102,119,18,0,191,7,64,255,
38,87,29,0,224,81,158,13,38,135,21,0,38,87,13,0,16,135,2,0,
80,81,138,0,127,0,128,7,225,112,38,143,1,0,7,200,8,216,187,0,
17,214,251,255,38,231,25,0,6,232,191,255,206,255,28,127,12,0,0,18,
239,217,154,13,60,110,29,0,205,81,138,103,1,0,224,97,162,5,1,18,
130,0,224,17,242,21,29,48,191,255,168,255,60,142,29,0,202,137,145,127,
1,0,0,18,224,121,146,13,60,110,13,0,205,81,138,103,1,0,224,97,
170,5,1,18,130,0,224,17,178,5,0,82,213,13,253,143,19,0,26,56,
25,48,17,70,5,0,190,255,250,83,253,127,19,0,15,86,5,0,64,6,
255,112,128,7,225,240,6,232,61,215,1,0,8,200,7,192,26,48,191,255,
86,252,224,81,146,37,0,226,0,218,58,215,6,0,165,21,61,54,8,0,
191,255,242,254,224,81,202,13,29,71,40,0,24,56,61,54,8,0,191,255,
64,255,224,81,178,5,202,225,65,218,26,112,95,210,224,113,202,237,57,111,
0,0,28,80,219,105,121,111,0,0,64,6,255,240,128,7,225,0,6,232,
7,224,224,233,178,21,157,135,49,0,49,6,12,87,134,0,125,143,53,0,
224,129,210,5,61,55,1,0,128,255,56,250,129,226,201,5,29,48,128,255,
242,249,64,6,255,0,128,7,225,0,6,232,7,224,224,233,178,21,61,55,
45,0,49,6,92,87,134,0,125,143,53,0,128,255,12,250,29,48,0,58,
191,255,170,255,129,226,201,5,29,48,128,255,190,249,64,6,255,0,158,7,
225,0,7,232,38,63,57,0,8,224,0,66,7,6,240,255,145,13,7,128,
194,130,45,6,88,173,145,0,205,129,48,71,1,0,3,48,191,255,112,253,
3,48,29,56,28,64,191,255,12,255,10,232,3,48,2,58,191,255,146,255,
29,80,94,6,255,0,128,7,225,0,6,232,61,55,1,0,7,224,28,64,
0,58,190,255,48,84,61,23,57,0,2,6,240,255,161,21,194,18,44,6,
88,173,145,0,204,17,34,63,1,0,224,57,146,13,231,71,3,0,232,225,
214,5,61,55,1,0,190,255,166,82,64,6,255,0,128,7,225,16,38,223,
25,0,59,231,49,0,6,232,28,230,16,0,191,255,0,254,60,55,0,0,
253,143,19,0,61,63,1,0,60,135,5,0,219,49,17,64,10,72,63,6,
30,174,129,0,112,0,253,127,19,0,32,230,15,1,239,81,170,5,0,226,
224,81,186,5,32,230,210,1,61,23,5,0,224,17,162,13,224,81,174,5,
128,81,66,87,0,0,65,18,168,82,66,87,0,0,224,225,194,13,61,63,
13,0,157,71,17,0,253,79,19,0,38,6,224,183,133,0,129,255,162,12,
28,80,64,6,255,16,128,7,225,16,6,224,60,55,1,0,191,255,140,250,
224,81,210,45,60,23,1,0,1,138,60,63,45,0,34,239,6,0,226,79,
3,0,68,143,28,137,38,6,16,184,133,0,29,64,129,255,104,12,29,216,
229,13,60,54,8,0,191,255,12,253,224,81,138,13,60,54,8,0,191,255,
52,255,224,81,170,5,95,218,29,128,95,234,224,129,138,245,224,217,242,5,
27,56,38,6,76,184,133,0,129,255,50,12,64,6,255,16,128,7,97,0,
6,232,191,255,220,250,61,143,57,0,17,6,240,255,193,5,29,48,191,255,
124,255,64,6,127,0,128,7,225,16,6,232,7,216,187,0,8,224,224,233,
138,13,32,54,56,0,128,255,136,246,10,232,224,233,146,61,49,6,12,87,
134,0,125,143,53,0,61,54,8,0,28,56,191,255,58,251,93,223,40,0,
32,54,208,7,128,255,4,248,10,224,224,225,154,13,38,6,128,184,133,0,
32,62,221,6,0,66,190,255,126,86,28,48,0,58,32,70,208,7,190,255,
144,82,125,231,1,0,28,62,8,0,125,63,5,0,61,54,8,0,32,70,
200,7,191,255,48,251,1,122,93,127,48,0,224,217,242,5,61,23,1,0,
32,86,34,34,98,87,0,0,29,80,64,6,255,16,128,7,225,0,6,232,
7,224,224,233,138,13,32,54,60,0,128,255,248,245,10,232,224,233,130,21,
29,48,28,64,2,58,191,255,76,255,49,6,92,87,134,0,125,143,53,0,
125,231,57,0,29,48,191,255,8,249,29,80,64,6,255,0,38,23,57,0,
50,6,204,204,68,68,242,17,201,13,50,6,255,255,17,17,242,17,242,21,
50,6,238,238,34,34,242,17,162,29,133,45,50,6,204,204,68,68,242,17,
130,21,50,6,187,187,85,85,242,17,194,21,50,6,153,153,119,119,242,17,
194,21,133,29,1,138,37,22,184,134,133,29,3,138,37,22,176,134,197,21,
5,138,34,6,144,184,133,0,245,13,6,138,34,6,156,184,133,0,165,13,
4,138,34,6,172,184,133,0,213,5,0,136,34,6,188,184,133,0,70,143,
40,0,102,23,45,0,127,0,6,23,40,0,100,18,233,5,97,18,162,13,
99,18,130,21,165,53,101,18,241,37,194,21,102,18,178,29,197,45,49,6,
255,255,17,17,102,143,57,0,37,22,200,134,245,37,49,6,204,204,68,68,
102,143,57,0,37,22,192,134,245,29,49,6,238,238,34,34,102,143,57,0,
34,6,208,184,133,0,229,21,49,6,187,187,85,85,102,143,57,0,34,6,
220,184,133,0,213,13,49,6,153,153,119,119,102,143,57,0,34,6,236,184,
133,0,197,5,34,6,252,184,133,0,102,23,45,0,127,0,128,7,225,0,
6,232,7,224,224,233,138,13,32,54,56,0,128,255,182,244,10,232,224,233,
210,21,49,6,12,87,134,0,125,143,53,0,125,7,1,0,125,7,5,0,
61,54,8,0,28,56,191,255,96,249,93,7,40,0,125,7,45,0,93,7,
48,0,29,80,64,6,255,0,152,7,225,16,6,232,7,216,224,233,138,13,
32,54,60,0,128,255,110,244,10,232,224,233,194,117,29,48,31,58,191,255,
154,255,49,6,52,87,134,0,125,143,53,0,125,223,57,0,27,56,35,54,
12,0,191,255,86,152,35,54,12,0,191,255,128,168,224,81,226,93,35,62,
4,0,99,7,1,0,35,54,12,0,8,66,0,74,191,255,180,150,10,224,
224,225,250,5,35,54,4,0,191,255,136,247,224,81,234,21,27,56,38,6,
92,185,133,0,129,255,122,9,227,23,9,0,35,79,10,0,35,71,4,0,
28,56,99,23,1,0,38,6,16,185,133,0,129,255,94,9,165,53,227,55,
7,0,128,255,134,245,125,87,5,0,224,81,154,13,38,6,76,185,133,0,
32,62,19,8,0,66,190,255,254,83,227,71,7,0,61,63,5,0,99,7,
1,0,35,54,12,0,0,74,191,255,66,150,61,95,5,0,10,224,1,98,
93,103,48,0,125,95,1,0,11,62,8,0,125,63,5,0,61,54,8,0,
0,66,191,255,156,248,29,48,191,255,196,253,224,225,210,5,35,54,12,0,
191,255,58,155,29,80,88,6,255,16,128,7,225,0,6,232,7,224,224,233,
146,13,0,58,191,255,206,250,129,226,201,5,29,48,128,255,226,244,64,6,
255,0,158,7,225,0,7,232,38,63,57,0,8,224,3,48,191,255,204,254,
3,48,29,56,28,64,191,255,72,250,10,232,3,48,2,58,191,255,190,255,
29,80,94,6,255,0,148,7,97,0,6,232,61,63,57,0,35,54,4,0,
191,255,44,151,61,63,1,0,231,23,5,0,224,17,178,13,231,71,3,0,
99,7,1,0,35,54,4,0,0,74,191,255,138,161,229,5,35,54,4,0,
191,255,174,154,0,82,84,6,127,0,128,7,225,0,6,232,7,224,188,0,
224,233,138,13,32,54,60,0,128,255,218,242,10,232,224,233,130,21,29,48,
28,56,31,66,191,255,46,252,48,6,52,87,134,0,125,135,53,0,125,7,
57,0,29,48,191,255,112,253,29,80,64,6,255,0,128,7,33,0,166,0,
0,138,97,50,225,13,242,5,99,50,241,5,194,5,91,50,97,50,251,5,
1,138,213,5,7,48,190,255,220,236,10,136,17,80,138,0,64,6,63,0,
38,135,1,0,199,129,102,135,1,0,127,0,128,7,225,16,6,232,61,23,
9,0,224,17,146,13,2,143,0,0,209,134,3,0,194,5,32,86,208,1,
165,101,61,23,13,0,194,110,0,127,13,6,0,129,234,37,157,55,17,0,
194,102,255,0,200,98,204,49,230,0,191,255,108,132,10,56,7,224,65,226,
28,119,255,255,224,113,202,253,253,95,19,0,61,55,1,0,167,225,252,89,
252,95,50,219,27,64,190,255,6,77,224,217,146,37,61,127,1,0,27,142,
255,255,207,137,81,7,0,0,149,29,61,223,25,0,59,231,49,0,29,48,
72,226,191,255,86,248,60,55,0,0,253,119,19,0,61,63,1,0,60,111,
5,0,219,49,14,64,10,72,63,6,200,179,129,0,109,0,10,224,61,23,
5,0,224,17,146,29,66,231,0,0,65,18,136,226,66,231,0,0,61,95,
9,0,224,89,242,13,61,87,25,0,10,87,12,0,0,18,95,82,100,82,
169,5,1,18,130,0,224,17,178,5,203,63,0,0,0,82,64,6,255,16,
134,7,225,243,6,232,67,63,3,0,99,71,9,0,0,202,0,194,60,6,
148,81,134,0,128,7,12,1,60,215,5,0,213,125,61,23,29,0,224,17,
254,5,188,159,3,0,0,218,99,159,5,0,229,109,2,216,99,23,5,0,
165,109,58,79,5,0,3,143,3,0,9,16,2,135,12,0,0,82,240,137,
154,13,34,118,29,0,219,113,142,103,1,0,224,97,162,5,1,82,138,0,
224,81,194,85,27,80,34,142,29,0,202,137,145,127,1,0,0,90,224,121,
146,13,34,110,13,0,205,81,138,103,1,0,224,97,170,5,1,90,139,0,
224,89,130,69,41,191,5,0,253,143,19,0,125,231,21,0,23,182,5,0,
125,79,25,0,246,137,190,13,61,63,13,0,157,71,17,0,38,6,160,185,
133,0,129,255,72,6,165,45,61,23,1,0,60,103,0,0,2,126,3,0,
2,118,5,0,125,127,5,0,125,119,1,0,27,97,125,103,13,0,66,103,
0,0,61,143,13,0,136,138,66,143,1,0,58,87,0,0,29,48,66,87,
2,0,191,255,42,254,61,127,1,0,253,111,19,0,214,201,65,194,215,121,
125,127,1,0,182,105,125,111,18,0,65,218,35,151,5,0,242,217,195,149,
72,210,60,103,9,0,236,209,145,133,76,226,36,95,21,137,235,225,185,5,
191,7,240,254,35,151,9,0,50,87,0,0,216,81,114,87,0,0,25,80,
70,6,255,243,128,7,225,0,6,232,61,63,45,0,38,6,212,185,133,0,
129,255,170,5,61,23,53,0,61,87,1,0,61,63,5,0,2,22,24,0,
34,55,0,0,34,143,5,0,63,6,134,181,129,0,221,49,42,70,6,0,
113,0,61,54,8,0,10,224,28,56,191,255,138,253,61,23,1,0,29,63,
40,0,226,87,5,0,34,70,6,0,61,54,8,0,220,81,98,87,4,0,
191,255,92,254,61,23,1,0,10,88,226,87,5,0,203,81,98,87,4,0,
72,82,98,87,2,0,61,23,53,0,2,22,32,0,34,55,0,0,34,127,
5,0,63,6,224,181,129,0,221,49,111,0,10,224,224,225,146,13,61,63,
45,0,38,6,20,186,133,0,129,255,22,5,197,13,61,23,1,0,226,71,
5,0,34,63,6,0,38,6,248,185,133,0,129,255,254,4,28,80,64,6,
255,0,34,6,148,81,134,0,213,21,130,127,3,0,230,143,13,0,34,87,
0,0,47,112,81,113,206,0,234,113,154,13,34,135,5,0,102,23,21,0,
0,82,102,135,33,0,133,13,76,18,36,127,21,137,239,17,145,237,32,86,
11,1,127,0,230,143,19,0,224,137,234,87,0,0,127,0,128,7,97,0,
38,239,25,0,29,135,12,0,0,18,95,130,100,130,169,5,1,18,130,0,
224,17,130,53,38,23,9,0,130,23,1,0,224,17,194,5,98,18,130,29,
197,37,191,255,114,245,10,16,61,94,13,0,194,89,139,143,1,0,224,137,
210,29,61,134,13,0,194,129,80,7,0,0,61,110,29,0,205,17,1,98,
66,103,0,0,149,21,191,255,70,245,61,94,13,0,202,89,75,7,0,0,
61,134,29,0,208,81,74,7,0,0,197,5,32,86,208,1,165,5,0,82,
64,6,127,0,128,7,225,0,6,232,253,143,19,0,61,135,1,0,209,129,
125,135,1,0,176,127,1,0,144,111,1,0,200,122,15,105,205,94,255,63,
125,95,13,0,144,87,3,0,125,7,5,0,67,130,125,135,9,0,93,87,
16,0,224,81,138,53,61,127,33,0,125,87,18,0,224,121,218,13,29,48,
191,255,234,254,61,63,13,0,38,6,92,186,133,0,10,224,129,255,206,3,
229,5,15,118,8,0,125,119,33,0,0,226,61,23,33,0,61,95,21,0,
34,87,5,0,2,110,8,0,43,95,9,0,125,87,25,0,34,87,0,0,
235,105,93,87,16,0,177,45,4,82,125,87,18,0,125,7,33,0,213,37,
4,138,39,127,1,0,125,143,18,0,125,7,33,0,209,134,255,255,176,121,
103,127,1,0,204,5,32,86,209,1,181,37,29,48,191,255,158,243,10,224,
224,225,250,13,61,103,25,0,12,103,12,0,0,18,95,98,100,98,169,5,
1,18,130,0,224,17,186,5,32,230,211,1,61,79,9,0,157,71,17,0,
61,63,13,0,137,79,1,0,38,6,144,186,133,0,129,255,48,3,28,80,
64,6,255,0,128,7,225,0,6,232,253,143,19,0,61,23,1,0,209,17,
125,23,1,0,162,127,1,0,130,111,1,0,200,122,15,105,125,111,13,0,
130,95,3,0,144,106,93,95,16,0,249,21,162,143,5,0,130,127,5,0,
61,103,13,0,2,110,6,0,200,138,17,121,125,127,18,0,125,111,5,0,
204,102,255,127,125,103,13,0,2,94,3,0,8,18,149,13,162,87,3,0,
125,7,5,0,0,88,4,18,125,87,18,0,61,135,1,0,125,95,9,0,
39,111,1,0,253,127,19,0,194,129,125,135,1,0,207,17,162,105,103,111,
1,0,204,5,32,86,209,1,181,21,29,48,191,255,196,242,10,224,224,225,
194,13,61,63,13,0,157,71,17,0,253,79,19,0,38,6,196,186,133,0,
129,255,118,2,28,80,64,6,255,0,130,7,225,48,6,224,7,216,9,232,
128,255,108,25,10,208,224,209,231,29,29,56,35,54,3,0,190,255,76,120,
60,143,9,0,60,23,53,0,241,239,32,2,0,82,221,17,197,13,65,18,
65,218,27,111,255,255,2,119,255,255,237,113,178,5,0,210,229,5,65,82,
60,103,5,0,236,81,166,245,26,80,66,6,255,48,130,7,225,48,6,224,
7,216,9,232,128,255,24,25,10,208,224,209,231,29,29,56,35,54,3,0,
128,255,14,73,60,143,9,0,60,23,53,0,241,239,32,2,0,82,221,17,
197,13,65,18,65,218,27,111,255,255,2,119,255,255,237,113,178,5,0,210,
229,5,65,82,60,103,5,0,236,81,166,245,26,80,66,6,255,48,132,7,
225,48,6,216,7,208,8,224,9,232,1,138,99,143,5,0,31,50,190,255,
210,76,27,48,26,56,28,64,29,72,128,255,174,24,10,224,224,225,191,13,
35,135,5,0,224,129,210,5,99,7,5,0,190,255,192,76,28,80,245,37,
29,56,35,54,3,0,190,255,54,140,59,127,9,0,59,23,53,0,239,239,
32,2,0,106,221,17,197,13,65,18,65,210,26,95,255,255,2,103,255,255,
235,97,178,5,0,226,229,5,65,106,59,87,5,0,234,105,166,245,35,143,
5,0,224,137,210,5,99,7,5,0,190,255,114,76,28,80,68,6,255,48,
130,7,225,48,6,224,7,216,9,232,128,255,54,24,10,208,224,209,231,29,
29,56,35,54,3,0,190,255,192,139,60,143,9,0,60,23,53,0,241,239,
32,2,0,82,221,17,197,13,65,18,65,218,27,111,255,255,2,119,255,255,
237,113,178,5,0,210,229,5,65,82,60,103,5,0,236,81,166,245,26,80,
66,6,255,48,130,7,225,48,6,224,7,216,9,232,128,255,226,23,10,208,
224,209,231,29,29,56,35,54,3,0,190,255,112,139,60,143,9,0,60,23,
53,0,241,239,32,2,0,82,221,17,197,13,65,18,65,218,27,111,255,255,
2,119,255,255,237,113,178,5,0,210,229,5,65,82,60,103,5,0,236,81,
166,245,26,80,66,6,255,48,128,7,225,0,166,0,97,50,145,21,210,5,
98,50,146,13,102,50,235,13,6,56,0,50,191,255,26,248,10,232,133,21,
0,50,191,255,244,244,10,232,181,13,0,82,213,29,38,6,244,186,133,0,
32,62,99,10,0,66,190,255,22,75,29,48,191,255,148,250,10,224,224,233,
226,13,61,23,53,0,72,18,34,55,0,0,34,135,5,0,3,58,63,6,
220,186,129,0,221,49,112,0,28,80,64,6,255,0,38,142,13,0,199,137,
81,7,0,0,38,126,29,0,199,121,1,106,79,111,0,0,6,55,12,0,
191,7,124,255,128,7,33,0,166,0,191,255,228,247,138,0,64,6,63,0,
158,7,97,0,7,16,8,232,6,56,2,64,3,48,191,255,218,239,29,56,
3,48,191,255,128,242,3,48,2,58,191,255,0,242,94,6,127,0,158,7,
33,0,7,64,6,56,3,48,191,255,184,239,3,48,191,255,150,243,3,48,
2,58,191,255,224,241,94,6,63,0,158,7,33,0,6,56,3,48,191,255,
186,245,35,23,53,0,2,22,16,0,34,55,0,0,34,135,5,0,3,80,
63,6,126,187,129,0,202,49,112,0,3,48,2,58,191,255,156,246,94,6,
63,0,144,7,225,0,9,224,99,71,1,0,99,7,9,0,99,55,13,0,
67,63,16,0,99,231,18,0,99,7,21,0,49,6,184,149,145,0,99,143,
25,0,31,130,99,135,29,0,3,48,191,255,126,239,10,232,224,233,186,21,
3,48,191,255,94,247,10,232,224,233,218,13,35,71,25,0,40,71,5,0,
252,65,247,5,28,56,38,6,4,187,133,0,128,255,34,255,29,80,80,6,
255,0,144,7,225,16,198,222,15,0,99,71,1,0,99,7,9,0,99,55,
13,0,67,63,16,0,99,79,18,0,99,7,21,0,49,6,184,149,145,0,
99,143,25,0,31,130,99,135,29,0,3,48,191,255,24,239,10,232,224,233,
202,53,35,23,25,0,227,119,19,0,34,23,5,0,226,113,183,5,99,23,
18,0,132,23,25,137,3,48,68,23,28,137,191,255,162,241,10,232,224,233,
138,37,35,231,25,0,3,48,191,255,164,239,10,16,60,102,29,0,194,97,
140,87,1,0,0,106,224,81,146,13,60,134,13,0,208,17,130,127,1,0,
224,121,170,5,1,106,141,0,224,105,242,5,28,55,12,0,27,56,191,255,
238,253,10,232,29,80,80,6,255,16,128,7,33,0,8,16,38,71,5,0,
232,17,206,5,32,86,15,1,133,21,38,23,49,0,72,18,34,87,0,0,
34,143,5,0,0,74,63,6,198,188,129,0,198,81,10,48,113,0,0,82,
64,6,63,0,128,7,97,0,6,232,8,16,61,71,5,0,232,17,206,5,
32,86,15,1,229,37,132,23,25,137,68,23,28,137,61,23,49,0,2,22,
16,0,34,55,0,0,34,143,5,0,0,74,63,6,6,189,129,0,221,49,
113,0,189,135,29,0,0,82,0,18,224,129,226,5,189,127,13,0,224,121,
170,5,1,18,130,0,224,17,226,5,29,55,12,0,0,58,191,255,80,253,
64,6,127,0,164,7,225,241,230,143,9,0,9,232,8,184,247,63,7,0,
201,138,99,143,1,0,38,6,44,187,133,0,128,255,186,253,0,218,99,239,
37,0,99,7,45,0,99,7,54,0,99,7,57,0,46,6,184,149,145,0,
99,119,61,0,31,106,99,111,65,0,99,7,69,0,99,7,25,0,99,7,
29,0,99,7,33,0,0,202,128,7,46,1,35,54,36,0,3,56,191,255,
78,249,10,216,224,217,178,5,128,7,38,1,35,54,36,0,191,255,188,248,
10,216,224,217,178,5,128,7,20,1,35,54,36,0,191,255,158,248,224,81,
162,5,65,202,35,239,61,0,29,239,12,0,0,18,29,86,255,255,100,82,
169,5,1,18,130,0,224,17,242,109,35,54,36,0,191,255,34,238,67,239,
12,0,99,87,17,0,35,22,12,0,34,95,1,0,35,86,4,0,106,95,
1,0,34,23,5,0,106,23,5,0,35,111,25,0,35,95,29,0,35,127,
9,0,3,135,4,0,13,16,11,112,165,13,10,103,0,0,240,97,218,5,
42,87,5,0,239,81,210,5,72,18,2,80,238,81,218,245,235,17,170,69,
0,18,224,105,194,5,11,16,173,17,163,18,0,98,224,105,210,5,35,103,
33,0,173,97,163,98,11,56,236,17,249,29,7,208,26,232,1,226,29,80,
224,81,130,21,224,81,234,5,8,50,128,255,52,231,224,81,146,13,3,23,
4,0,74,23,0,0,35,23,9,0,106,23,5,0,95,226,72,234,224,225,
186,237,26,94,8,0,99,95,29,0,197,21,224,105,194,5,173,89,163,90,
186,5,0,234,197,5,7,232,173,233,163,234,35,54,20,0,1,66,35,78,
4,0,128,255,128,3,195,234,221,193,247,119,7,0,238,201,190,5,191,7,
206,254,35,239,25,0,181,13,2,55,0,0,34,63,5,0,191,255,172,251,
224,217,170,5,10,216,72,234,35,87,29,0,29,16,234,17,161,245,35,55,
25,0,224,49,130,13,6,16,165,5,72,18,234,17,234,253,128,255,36,232,
99,7,25,0,99,7,29,0,99,7,33,0,27,80,100,6,255,241,162,7,
225,243,6,176,246,143,9,0,8,184,132,23,25,137,99,79,37,0,201,138,
99,143,1,0,68,23,28,137,99,7,45,0,99,7,54,0,99,7,57,0,
47,6,184,149,145,0,99,127,61,0,31,114,99,119,65,0,99,7,25,0,
99,7,29,0,99,7,33,0,0,218,0,202,128,7,68,1,35,54,36,0,
3,56,191,255,130,248,10,216,224,217,178,5,128,7,60,1,35,54,36,0,
191,255,122,238,10,216,224,217,178,5,128,7,42,1,35,239,61,0,35,54,
36,0,191,255,118,236,10,16,61,94,29,0,194,89,139,143,1,0,0,98,
224,137,146,13,61,126,13,0,207,17,130,119,1,0,224,113,170,5,1,98,
140,0,224,97,178,117,35,239,61,0,35,54,36,0,29,239,12,0,191,255,
62,236,99,87,17,0,35,22,12,0,67,239,12,0,34,95,1,0,35,86,
4,0,106,95,1,0,34,23,5,0,106,23,5,0,35,103,25,0,35,95,
29,0,35,127,9,0,3,135,4,0,12,16,11,112,165,13,10,111,0,0,
240,105,218,5,42,87,5,0,239,81,210,5,72,18,2,80,238,81,218,245,
235,17,170,69,0,18,224,97,194,5,11,16,172,17,163,18,0,138,224,97,
210,5,35,143,33,0,172,137,163,138,11,56,241,17,249,29,7,208,26,232,
1,226,29,80,224,81,130,21,224,81,234,5,8,50,128,255,80,229,224,81,
146,13,3,23,4,0,74,23,0,0,35,23,9,0,106,23,5,0,95,226,
72,234,224,225,186,237,26,134,8,0,99,135,29,0,197,21,224,97,194,5,
172,89,163,90,186,5,0,234,197,5,7,232,172,233,163,234,35,54,20,0,
1,66,35,78,4,0,128,255,156,1,195,234,221,193,65,202,247,95,7,0,
235,201,190,5,191,7,184,254,22,135,52,0,224,217,234,87,0,0,202,126,
1,0,208,134,191,0,198,122,15,129,86,135,52,0,35,239,25,0,181,13,
2,55,0,0,34,63,5,0,191,255,172,249,224,217,170,5,10,216,72,234,
35,87,29,0,29,16,234,17,161,245,35,55,25,0,224,49,130,13,6,16,
165,5,72,18,234,17,234,253,128,255,36,230,99,7,25,0,99,7,29,0,
99,7,33,0,27,80,98,6,255,243,146,7,225,0,230,143,9,0,8,224,
99,79,5,0,99,7,13,0,201,138,99,143,1,0,99,7,22,0,99,7,
25,0,47,6,184,149,145,0,99,127,29,0,31,114,99,119,33,0,0,234,
245,13,35,54,4,0,3,56,191,255,156,246,224,81,218,13,35,54,4,0,
191,255,212,241,224,81,250,5,65,234,252,95,7,0,235,233,246,237,0,82,
82,6,255,0,224,49,210,5,129,58,185,5,128,7,168,229,127,0,128,7,
4,214,128,7,0,214,128,7,225,0,6,232,7,224,224,233,130,29,61,135,
33,0,16,6,240,255,217,5,61,55,13,0,128,255,128,229,15,122,125,127,
33,0,61,86,12,0,125,7,29,0,74,7,0,0,129,226,201,5,29,48,
128,255,100,229,64,6,255,0,128,7,190,213,38,135,33,0,16,6,240,255,
201,5,38,87,13,0,181,5,38,86,12,0,127,0,128,7,225,0,6,232,
7,224,224,233,130,29,61,135,33,0,16,6,240,255,217,5,61,55,13,0,
128,255,40,229,15,122,125,127,33,0,61,86,12,0,125,7,29,0,74,7,
0,0,129,226,201,5,29,48,128,255,12,229,64,6,255,0,127,0,38,87,
1,0,127,0,224,49,210,5,129,58,185,5,128,7,244,228,127,0,168,7,
225,243,41,87,1,0,35,22,8,0,98,87,1,0,41,87,5,0,6,224,
8,216,7,192,98,87,5,0,60,23,5,0,0,210,46,6,255,255,255,31,
61,6,84,82,134,0,224,17,210,5,60,215,13,0,162,209,163,210,224,217,
186,5,128,7,94,8,0,82,224,17,210,5,60,87,9,0,162,81,163,82,
14,96,170,97,251,97,177,5,128,7,134,5,42,6,236,180,133,0,15,90,
99,95,41,0,35,102,20,0,99,7,37,0,76,7,0,0,10,16,65,18,
2,127,255,255,224,121,202,253,35,94,16,0,170,17,2,206,255,255,11,16,
34,111,25,0,10,192,13,6,240,255,201,5,34,95,5,0,181,5,34,94,
4,0,235,81,185,5,128,7,164,1,34,103,25,0,12,6,240,255,201,5,
34,103,5,0,181,5,34,102,4,0,34,95,21,0,204,89,234,89,187,5,
128,7,130,1,35,87,41,0,35,22,20,0,10,6,240,255,185,5,35,23,
21,0,35,135,37,0,24,216,162,217,251,129,217,5,35,54,16,0,128,255,
206,216,35,23,37,0,2,224,187,225,252,201,169,5,25,224,64,214,134,0,
58,215,201,97,219,225,252,17,217,5,35,54,16,0,128,255,170,216,35,23,
37,0,188,17,250,17,169,5,2,208,224,209,210,69,35,87,41,0,35,102,
20,0,10,6,240,255,185,5,35,103,21,0,28,88,204,89,35,102,20,0,
10,6,240,255,185,5,35,103,21,0,220,97,218,97,186,17,226,29,11,104,
172,105,226,105,171,21,2,80,203,81,10,94,255,255,2,128,204,129,16,102,
255,255,12,127,0,0,95,98,75,127,0,0,95,90,95,18,154,253,149,13,
12,119,0,0,65,98,75,119,0,0,65,90,95,18,154,253,35,111,37,0,
35,103,41,0,186,105,35,22,20,0,12,6,240,255,185,5,35,23,21,0,
99,111,37,0,194,105,77,7,0,0,35,87,37,0,251,81,169,5,10,216,
224,217,186,5,128,7,144,1,35,23,41,0,35,126,20,0,2,6,240,255,
185,5,35,127,21,0,35,94,20,0,2,6,240,255,185,5,35,95,21,0,
27,128,203,129,10,16,187,17,226,29,15,80,176,81,226,81,171,21,2,112,
207,113,14,126,255,255,2,104,208,105,13,134,255,255,16,103,0,0,95,130,
79,103,0,0,95,122,95,18,154,253,149,13,16,95,0,0,65,130,79,95,
0,0,65,122,95,18,154,253,35,87,37,0,35,135,41,0,187,81,35,22,
20,0,16,6,240,255,185,5,35,23,21,0,99,87,37,0,194,81,74,7,
0,0,128,7,6,1,25,216,126,218,211,5,35,54,16,0,128,255,56,217,
35,23,41,0,251,17,217,77,35,215,37,0,155,230,15,0,126,226,179,5,
27,224,245,13,28,112,3,106,237,119,194,2,2,80,129,82,234,113,249,5,
30,98,170,97,236,17,187,5,10,224,194,225,28,54,1,0,128,255,218,224,
10,184,224,209,226,13,35,87,41,0,35,62,20,0,23,48,10,6,240,255,
185,5,35,63,21,0,26,64,190,255,172,59,35,135,41,0,16,6,240,255,
217,5,35,55,21,0,128,255,42,226,15,122,99,127,41,0,35,86,20,0,
99,7,37,0,74,7,0,0,99,191,21,0,99,231,41,0,35,22,20,0,
28,6,240,255,169,5,23,16,99,215,37,0,194,209,90,7,0,0,229,13,
224,217,202,13,35,86,20,0,2,6,240,255,185,5,35,87,21,0,99,7,
37,0,74,7,0,0,224,217,194,29,35,87,41,0,35,54,20,0,10,6,
240,255,185,5,35,55,21,0,24,56,25,64,190,255,48,59,35,135,41,0,
35,22,20,0,16,6,240,255,185,5,35,23,21,0,99,207,37,0,194,201,
89,7,0,0,35,102,16,0,37,22,128,134,99,23,45,0,61,22,212,254,
99,23,49,0,15,114,99,119,77,0,35,86,56,0,99,7,73,0,74,7,
0,0,64,222,134,0,59,223,201,97,35,231,37,0,27,16,252,17,169,5,
2,224,35,94,52,0,236,89,170,93,35,87,73,0,252,81,217,5,35,54,
52,0,128,255,34,214,35,23,73,0,188,17,251,17,169,5,2,216,224,217,
186,5,128,7,162,1,35,87,77,0,35,94,56,0,10,6,240,255,185,5,
35,95,57,0,28,96,203,97,35,94,56,0,10,6,240,255,185,5,35,95,
57,0,203,225,27,104,220,105,187,17,226,29,12,112,173,113,226,113,171,21,
2,88,204,89,11,102,255,255,2,80,205,81,10,110,255,255,13,135,0,0,
95,106,76,135,0,0,95,98,95,18,154,253,149,13,13,127,0,0,65,106,
76,127,0,0,65,98,95,18,154,253,35,119,73,0,35,111,77,0,187,113,
35,22,56,0,13,6,240,255,185,5,35,23,57,0,99,119,73,0,194,113,
78,7,0,0,128,7,20,1,126,226,211,5,35,54,52,0,128,255,68,215,
35,23,77,0,252,17,217,77,35,215,73,0,156,222,15,0,126,218,179,5,
28,216,245,13,27,88,3,82,234,95,194,2,2,96,129,98,236,89,249,5,
30,130,172,129,240,17,187,5,12,216,194,217,27,54,1,0,128,255,230,222,
10,200,224,209,226,13,35,119,77,0,35,62,56,0,25,48,14,6,240,255,
185,5,35,63,57,0,26,64,190,255,184,57,35,111,77,0,13,6,240,255,
217,5,35,55,57,0,128,255,54,224,15,98,99,103,77,0,35,86,56,0,
99,7,73,0,74,7,0,0,99,207,57,0,99,223,77,0,35,22,56,0,
27,6,240,255,169,5,25,16,99,215,73,0,194,209,90,7,0,0,229,13,
224,225,202,13,35,86,56,0,2,6,240,255,185,5,35,87,57,0,99,7,
73,0,74,7,0,0,224,225,194,37,35,119,77,0,35,54,56,0,14,6,
240,255,185,5,35,55,57,0,35,111,41,0,35,62,20,0,13,6,240,255,
185,5,35,63,21,0,28,64,190,255,44,57,35,103,77,0,35,22,56,0,
12,6,240,255,185,5,35,23,57,0,99,231,73,0,194,225,92,7,0,0,
61,22,244,254,99,23,49,0,64,230,134,0,60,231,205,97,35,238,44,0,
224,225,226,5,29,48,63,6,158,199,129,0,124,0,35,23,49,0,2,22,
24,0,34,55,0,0,34,87,5,0,63,6,184,199,129,0,221,49,106,0,
29,48,128,255,192,207,35,135,77,0,16,6,240,255,217,5,35,55,57,0,
128,255,76,223,15,122,99,127,77,0,35,86,56,0,99,7,73,0,74,7,
0,0,35,103,41,0,12,6,240,255,217,5,35,55,21,0,128,255,40,223,
15,90,99,95,41,0,35,86,20,0,99,7,37,0,74,7,0,0,128,7,
194,2,0,82,224,17,210,5,60,87,9,0,162,81,163,82,27,104,202,105,
237,209,177,5,128,7,118,1,0,82,26,88,129,90,14,96,171,97,250,97,
177,5,11,80,218,81,10,208,0,82,224,17,210,5,60,87,9,0,162,81,
163,82,27,128,202,129,240,209,169,13,0,82,224,17,210,5,60,87,9,0,
162,81,163,82,27,208,202,209,238,209,179,29,36,111,249,143,224,105,186,21,
1,98,100,103,249,143,34,6,220,180,133,0,100,23,241,143,61,22,20,255,
36,142,244,143,113,23,1,0,61,54,52,255,128,255,68,215,36,54,240,143,
128,255,230,206,26,200,195,202,25,48,128,255,248,220,60,239,5,0,99,199,
5,0,10,176,22,208,213,21,26,80,224,81,130,21,224,81,234,5,8,50,
128,255,218,220,224,81,146,13,29,23,0,0,74,23,0,0,61,23,5,0,
106,23,5,0,72,210,72,234,248,233,186,237,99,215,1,0,26,232,27,208,
35,199,13,0,3,191,8,0,149,21,29,80,224,81,194,13,224,81,234,5,
8,50,128,255,156,220,224,81,210,5,74,191,0,0,106,199,5,0,95,210,
72,234,224,209,250,237,35,215,1,0,27,80,195,82,60,199,9,0,202,209,
99,215,1,0,35,239,5,0,213,21,26,80,224,81,130,21,224,81,234,5,
8,50,128,255,96,220,224,81,146,13,29,23,0,0,74,23,0,0,61,23,
5,0,106,23,5,0,72,210,72,234,248,233,186,237,60,55,5,0,0,18,
224,49,210,5,60,23,9,0,166,17,163,18,194,217,224,49,162,13,60,87,
9,0,6,16,165,5,72,18,234,17,234,253,128,255,156,221,214,201,124,207,
13,0,195,218,214,217,124,223,9,0,124,183,5,0,128,7,54,1,60,23,
9,0,24,200,2,120,185,121,163,122,251,121,153,85,2,192,27,184,195,186,
23,208,217,209,25,232,213,21,26,80,224,81,130,21,224,81,234,5,8,50,
128,255,214,219,224,81,146,13,29,23,0,0,74,23,0,0,61,23,5,0,
106,23,5,0,72,210,72,234,248,233,186,237,60,239,9,0,35,215,13,0,
3,199,8,0,29,96,185,97,163,98,172,217,149,21,29,80,224,81,194,13,
224,81,234,5,8,50,128,255,148,219,224,81,210,5,74,199,0,0,106,215,
5,0,95,218,72,234,224,217,250,237,60,87,9,0,25,56,215,81,124,87,
9,0,183,81,197,13,35,22,8,0,34,95,1,0,103,95,1,0,34,23,
5,0,103,23,5,0,72,58,234,57,202,245,165,69,2,208,27,192,195,194,
26,232,184,233,2,216,213,21,27,80,224,81,130,21,224,81,234,5,8,50,
128,255,54,219,224,81,146,13,29,23,0,0,74,23,0,0,61,23,5,0,
106,23,5,0,72,218,72,234,250,233,186,237,124,223,9,0,25,96,26,16,
184,17,26,80,181,13,88,18,34,95,1,0,88,82,106,95,1,0,34,95,
5,0,106,95,5,0,226,97,218,245,25,16,24,216,217,217,197,13,35,86,
8,0,42,95,1,0,98,95,1,0,42,87,5,0,98,87,5,0,72,18,
251,17,202,245,104,6,255,243,38,87,5,0,127,0,132,7,97,0,6,232,
61,135,53,0,7,48,80,7,0,0,128,255,106,11,99,87,1,0,99,95,
5,0,61,55,53,0,3,56,8,66,190,255,146,53,8,82,68,6,127,0,
128,7,33,0,38,55,53,0,32,62,0,32,128,255,78,93,32,86,0,32,
64,6,63,0,148,7,97,0,6,232,35,54,4,0,39,6,170,170,102,102,
191,255,124,126,35,54,4,0,191,255,166,142,61,55,53,0,32,70,0,32,
224,81,162,13,6,56,99,7,1,0,35,54,4,0,0,74,191,255,214,124,
197,21,0,58,190,255,146,54,61,143,53,0,47,6,80,187,133,0,15,110,
33,0,17,112,15,103,0,0,65,122,78,103,0,0,65,114,239,105,154,253,
32,86,0,32,84,6,127,0,7,64,38,63,53,0,32,54,0,32,190,7,
2,60,130,7,225,16,6,224,60,143,53,0,0,234,7,6,240,255,81,7,
0,0,241,5,197,58,32,102,164,180,204,57,39,239,5,0,224,233,130,69,
61,23,105,0,2,22,96,0,34,55,0,0,34,95,5,0,30,218,63,6,
208,203,129,0,221,49,107,0,224,81,162,5,31,218,60,87,53,0,74,223,
0,0,61,23,105,0,3,48,31,66,2,22,184,0,34,63,0,0,34,143,
5,0,31,218,63,6,254,203,129,0,221,57,113,0,195,199,0,0,162,5,
29,218,60,127,53,0,15,119,0,0,91,113,79,119,0,0,157,111,7,0,
31,98,13,6,192,255,186,5,32,102,127,0,60,95,53,0,11,87,0,0,
76,81,75,87,0,0,1,82,66,6,255,16,128,7,97,0,38,239,53,0,
7,48,191,255,56,39,93,87,0,0,1,82,64,6,127,0,128,7,33,0,
6,88,0,82,7,6,240,255,241,5,197,58,32,110,164,180,205,57,39,87,
5,0,224,81,162,21,42,23,105,0,43,63,53,0,2,22,232,0,34,55,
0,0,34,103,5,0,63,6,140,204,129,0,202,49,108,0,244,87,64,2,
64,6,63,0,128,7,225,0,6,232,0,82,7,6,240,255,241,5,197,58,
32,110,164,180,205,57,39,87,5,0,224,81,242,21,42,23,105,0,61,231,
53,0,2,22,224,0,34,55,0,0,34,103,5,0,63,6,208,204,129,0,
202,49,108,0,92,87,0,0,61,95,53,0,2,82,75,7,1,0,64,6,
255,0,130,7,225,112,38,215,53,0,0,226,0,234,0,218,28,6,240,255,
129,13,28,128,197,130,32,110,164,180,205,129,48,223,5,0,224,217,162,53,
59,23,105,0,2,22,96,0,34,55,0,0,34,103,5,0,30,234,63,6,
36,205,129,0,219,49,108,0,224,81,162,5,31,234,59,23,105,0,31,202,
3,48,2,22,184,0,34,63,0,0,34,95,5,0,31,66,63,6,74,205,
129,0,219,57,107,0,195,199,0,0,162,5,29,202,155,143,7,0,89,233,
189,0,31,130,17,6,192,255,186,5,32,134,127,0,80,233,189,0,90,239,
0,0,65,210,65,226,28,6,240,255,182,189,32,86,16,0,66,6,255,112,
130,7,225,16,8,232,38,55,53,0,99,7,1,0,7,216,3,56,190,255,
58,85,32,22,21,0,29,6,235,255,161,5,29,16,27,48,39,6,116,187,
133,0,2,232,29,64,190,255,218,50,164,231,13,136,3,48,28,56,190,255,
138,114,10,16,65,18,2,119,255,255,224,113,202,253,170,17,2,94,255,255,
235,233,225,13,3,48,28,56,190,255,108,114,10,16,65,18,2,143,255,255,
224,137,202,253,170,17,2,238,255,255,3,48,28,56,190,255,82,114,27,48,
10,56,29,64,190,255,140,50,29,80,66,6,255,16,130,7,97,0,38,55,
53,0,99,7,1,0,7,232,3,56,190,255,182,84,164,63,13,136,3,48,
190,255,170,113,93,87,0,0,1,82,66,6,127,0,130,7,33,0,6,16,
7,80,100,66,194,5,32,86,15,1,197,13,10,72,34,55,53,0,34,63,
57,0,1,138,99,143,1,0,4,66,190,255,210,86,66,6,63,0,130,7,
33,0,6,16,34,55,53,0,7,72,34,63,57,0,1,138,99,143,1,0,
190,255,12,86,66,6,63,0,132,7,225,16,35,78,4,0,6,16,34,55,
53,0,7,224,34,63,57,0,1,138,99,143,1,0,8,216,4,66,190,255,
230,85,224,81,178,5,0,82,165,37,12,234,108,218,169,5,27,232,35,23,
5,0,224,17,210,5,64,102,0,128,76,17,146,13,28,48,39,6,140,187,
133,0,29,64,190,255,196,49,213,13,35,54,4,0,129,255,24,6,10,72,
28,48,29,56,40,6,152,187,133,0,128,255,32,244,12,82,68,6,255,16,
130,7,225,48,6,232,8,216,61,71,5,0,7,208,232,217,194,5,8,80,
128,81,213,53,60,6,152,173,145,0,61,55,53,0,61,63,57,0,28,72,
99,7,1,0,190,255,104,85,224,81,250,5,156,95,1,0,224,89,210,5,
244,89,178,5,0,82,245,29,1,18,61,103,5,0,28,86,1,0,245,5,
10,119,0,0,235,113,218,245,65,82,65,18,236,17,150,253,61,55,53,0,
61,63,57,0,99,7,1,0,26,72,27,64,190,255,204,85,0,66,224,81,
186,5,61,71,5,0,8,80,66,6,255,48,130,7,225,16,0,226,38,6,
152,173,145,0,0,58,32,70,0,32,190,255,104,50,36,239,33,137,59,6,
152,173,145,0,133,29,61,55,53,0,61,63,57,0,61,71,5,0,27,72,
99,7,1,0,190,255,132,85,10,56,224,57,242,5,38,6,164,187,133,0,
128,255,86,235,229,5,65,226,61,239,61,0,224,233,138,237,28,80,66,6,
255,16,128,7,225,0,6,232,7,224,224,233,178,21,49,6,68,90,134,0,
125,143,49,0,38,6,216,187,133,0,32,62,108,2,0,66,190,255,224,53,
129,226,201,5,29,48,128,255,38,215,64,6,255,0,128,7,225,48,7,232,
8,224,9,216,3,215,20,0,224,49,138,13,32,54,52,0,128,255,134,213,
10,48,224,49,162,29,49,6,132,87,134,0,102,143,49,0,102,239,1,0,
102,231,5,0,102,223,9,0,70,215,12,0,0,18,38,86,13,0,74,7,
0,0,74,7,16,0,65,82,65,18,2,6,240,255,134,253,6,80,64,6,
255,48,130,7,225,48,6,232,7,224,8,216,9,208,224,233,138,13,32,54,
60,0,128,255,48,213,10,232,224,233,162,21,29,48,27,64,99,7,1,0,
0,58,0,74,191,255,126,255,49,6,164,87,134,0,125,143,49,0,125,231,
53,0,125,215,57,0,29,80,66,6,255,48,128,7,225,48,6,232,7,224,
8,216,9,208,224,233,138,13,32,54,64,0,128,255,234,212,10,232,224,233,
162,21,29,48,28,56,27,64,26,72,191,255,148,255,36,135,33,137,49,6,
68,90,134,0,125,143,49,0,100,239,33,137,125,135,61,0,29,80,64,6,
255,48,130,7,97,0,6,232,61,87,5,0,7,16,234,65,178,5,128,81,
149,21,61,55,53,0,61,63,57,0,1,138,99,143,1,0,2,72,190,255,
34,84,0,18,224,81,186,5,61,23,5,0,2,80,66,6,127,0,130,7,
97,0,6,232,61,87,5,0,7,16,234,65,178,5,128,81,133,21,61,55,
53,0,61,63,57,0,2,72,99,7,1,0,190,255,236,83,0,18,224,81,
186,5,61,23,5,0,2,80,66,6,127,0,130,7,225,16,6,232,7,216,
27,48,8,224,0,58,190,255,140,48,61,135,5,0,27,72,61,55,53,0,
61,63,57,0,240,225,240,231,60,67,1,122,99,127,1,0,190,255,4,83,
0,18,224,81,186,5,61,23,5,0,2,80,66,6,255,16,130,7,225,16,
6,232,7,224,224,225,186,5,61,231,5,0,28,48,128,255,154,213,61,71,
5,0,10,216,27,48,0,58,190,255,58,48,61,55,53,0,61,63,57,0,
99,7,1,0,27,72,28,64,190,255,100,83,10,232,27,48,128,255,140,213,
29,80,66,6,255,16,130,7,225,16,6,232,7,216,27,48,8,224,0,58,
190,255,6,48,61,135,5,0,27,72,61,55,53,0,61,63,57,0,240,225,
240,231,60,67,99,7,1,0,190,255,128,82,0,18,224,81,186,5,61,23,
5,0,2,80,66,6,255,16,128,7,225,0,6,232,61,23,53,0,9,224,
2,80,224,81,194,69,61,87,5,0,234,65,178,5,128,81,229,61,61,55,
9,0,252,55,32,2,0,82,194,49,0,18,245,13,7,119,0,0,6,127,
0,0,238,121,226,5,162,65,190,255,60,46,1,82,133,13,65,50,65,58,
65,18,61,71,5,0,232,17,246,237,29,103,12,0,224,97,226,21,132,95,
29,137,224,89,162,21,224,81,138,13,61,142,13,0,220,137,145,127,1,0,
224,121,146,21,61,118,29,0,220,113,1,98,78,103,0,0,0,18,197,5,
224,81,242,5,1,18,61,142,13,0,209,225,92,23,0,0,61,87,5,0,
64,6,255,0,148,7,225,16,6,224,7,232,9,216,104,66,185,5,0,82,
181,61,35,54,4,0,0,58,32,70,36,0,190,255,30,47,189,23,1,0,
99,23,5,0,157,23,3,0,99,23,9,0,189,23,3,0,99,23,13,0,
157,23,5,0,99,23,17,0,189,23,5,0,157,87,7,0,31,130,95,18,
99,23,21,0,189,23,7,0,35,54,4,0,99,135,37,0,200,18,202,17,
2,22,148,248,99,23,25,0,128,255,234,244,99,87,1,0,28,48,3,56,
27,72,4,66,191,255,236,254,35,55,1,0,190,255,190,99,8,82,84,6,
255,16,128,7,225,48,6,232,61,23,49,0,8,216,7,208,9,224,2,22,
24,0,34,55,0,0,34,143,5,0,28,56,63,6,94,211,129,0,221,49,
113,0,61,135,9,0,125,87,5,0,26,48,61,63,1,0,240,231,32,2,
251,81,251,87,60,67,220,57,190,255,16,45,61,87,5,0,64,6,255,48,
130,7,97,0,7,232,104,66,185,5,0,82,197,45,3,56,4,66,191,255,
160,255,3,48,129,255,74,1,42,23,33,0,93,23,0,0,42,23,1,0,
93,23,1,0,42,23,5,0,93,23,2,0,42,23,9,0,93,23,3,0,
42,23,13,0,42,135,21,0,93,23,4,0,42,23,17,0,8,82,65,18,
93,23,5,0,16,22,108,7,194,0,93,23,6,0,168,18,93,23,7,0,
66,6,127,0,130,7,225,112,7,224,8,216,9,208,3,207,28,0,6,232,
224,233,138,13,32,54,56,0,128,255,146,209,10,232,224,233,130,21,29,48,
28,56,27,64,26,72,99,207,1,0,191,255,224,251,48,6,196,89,134,0,
125,135,49,0,125,231,53,0,29,80,66,6,255,112,130,7,225,16,6,232,
7,216,8,224,188,0,224,233,138,13,32,54,56,0,128,255,80,209,10,232,
224,233,226,13,29,48,27,56,99,231,1,0,4,66,0,74,191,255,144,255,
48,6,4,90,134,0,125,135,49,0,29,80,66,6,255,16,1,138,38,119,
57,0,38,111,9,0,231,143,192,0,49,120,38,95,53,0,237,63,32,2,
79,113,102,119,57,0,199,89,0,18,213,5,75,7,0,0,65,90,65,18,
38,87,5,0,234,17,150,253,127,0,130,7,225,112,7,224,8,216,9,208,
3,207,28,0,6,232,224,233,138,13,32,54,60,0,128,255,216,208,10,232,
224,233,226,13,29,48,28,56,27,64,26,72,99,207,1,0,191,255,24,255,
48,6,36,90,134,0,125,135,49,0,29,80,66,6,255,112,130,7,225,48,
6,232,7,224,8,216,9,208,224,233,138,13,32,54,60,0,128,255,154,208,
10,232,224,233,162,13,29,48,28,56,27,64,26,72,2,138,99,143,1,0,
191,255,146,255,29,80,66,6,255,48,130,7,225,16,6,232,7,224,8,216,
224,233,138,13,32,54,60,0,128,255,102,208,10,232,224,233,162,13,29,48,
28,56,27,64,5,138,99,143,1,0,0,74,191,255,94,255,29,80,66,6,
255,16,128,7,225,0,6,224,60,135,57,0,1,234,233,239,192,0,93,129,
178,5,0,82,133,13,191,255,166,252,60,119,57,0,29,113,124,119,57,0,
64,6,255,0,130,7,33,0,7,143,0,0,35,62,3,0,224,137,234,23,
0,0,67,23,3,0,191,255,126,252,66,6,63,0,130,7,225,16,6,232,
7,216,8,224,188,0,224,233,138,13,32,54,56,0,128,255,232,207,10,232,
224,233,226,13,29,48,27,56,99,231,1,0,1,66,0,74,191,255,40,254,
48,6,228,89,134,0,125,135,49,0,29,80,66,6,255,16,130,7,225,48,
6,232,7,224,8,216,9,208,224,233,138,13,32,54,52,0,128,255,170,207,
10,232,224,233,226,13,29,48,28,56,27,64,26,72,99,7,1,0,191,255,
248,249,49,6,132,88,134,0,125,143,49,0,29,80,66,6,255,48,0,82,
127,0,0,82,127,0,0,82,127,0,0,82,127,0,0,82,127,0,0,82,
127,0,0,82,127,0,0,82,127,0,0,82,127,0,0,82,127,0,0,82,
127,0,38,87,5,0,127,0,0,82,127,0,33,6,230,137,1,0,97,0,
0,82,0,90,6,104,0,18,45,71,1,0,200,81,225,79,0,0,201,89,
68,106,65,18,2,6,225,255,233,245,203,81,127,0,128,7,33,0,6,248,
64,86,0,0,0,90,74,95,144,244,255,63,117,0,36,55,37,137,32,118,
0,254,44,6,152,205,145,0,199,58,78,57,199,49,204,57,32,70,0,2,
190,255,216,107,10,64,224,65,146,13,38,6,104,188,133,0,32,62,196,5,
190,255,16,47,224,81,64,6,63,0,128,7,225,112,6,200,121,63,1,0,
57,54,4,0,7,232,32,70,32,0,190,255,178,41,61,239,25,0,29,22,
252,255,34,143,1,0,0,226,57,222,52,0,57,214,36,0,121,143,113,0,
122,239,1,0,27,48,12,66,224,233,242,5,29,56,190,255,134,41,61,239,
9,0,197,5,0,58,190,255,216,42,76,218,68,210,65,226,100,226,214,237,
224,233,146,13,29,64,38,6,120,188,133,0,32,62,98,5,190,255,156,46,
25,48,191,255,34,255,121,87,125,0,25,48,191,255,58,255,64,6,255,112,
128,7,97,0,6,232,61,71,20,0,224,65,142,13,38,6,136,188,133,0,
32,62,10,5,190,255,108,46,61,71,20,0,8,6,0,248,134,13,38,6,
136,188,133,0,32,62,11,5,190,255,84,46,61,55,20,0,42,6,152,205,
145,0,29,56,199,50,202,49,191,255,58,255,64,6,127,0,128,7,225,16,
6,232,60,6,173,222,173,222,229,87,64,0,224,7,96,1,228,71,17,143,
10,216,8,6,255,247,137,13,38,6,184,188,133,0,32,62,37,6,190,255,
14,46,125,231,105,0,228,127,17,143,125,231,109,0,125,7,113,0,125,231,
125,0,36,111,13,143,65,122,100,127,16,143,125,127,118,0,125,111,121,0,
100,239,13,143,251,47,32,0,64,6,255,16,128,7,225,16,6,232,61,71,
20,0,60,6,200,188,133,0,224,65,238,5,28,48,32,62,39,5,190,255,
190,45,61,71,20,0,8,6,0,248,230,5,28,48,32,62,40,5,190,255,
170,45,61,239,20,0,59,6,152,205,145,0,199,234,219,233,251,233,249,5,
28,48,29,64,32,62,44,5,190,255,140,45,91,142,4,0,241,233,241,5,
28,48,29,64,32,62,45,5,190,255,120,45,29,48,191,255,58,255,29,48,
191,255,26,254,64,6,255,16,128,7,193,0,229,87,64,0,224,7,96,1,
10,232,149,13,229,87,64,0,224,135,96,1,229,87,64,0,224,7,96,1,
36,23,13,143,224,17,210,245,34,143,121,0,228,135,17,143,2,224,128,126,
255,255,100,143,13,143,95,130,100,135,16,143,124,127,118,0,253,47,32,0,
28,80,64,6,223,0,128,7,225,16,6,224,7,216,191,255,170,255,60,71,
20,0,10,232,127,66,130,13,38,6,248,188,133,0,32,62,227,4,190,255,
246,44,253,71,117,0,124,71,20,0,232,0,8,6,0,248,134,13,38,6,
248,188,133,0,32,62,230,4,190,255,216,44,125,7,105,0,125,7,109,0,
125,7,113,0,125,223,101,0,29,48,28,56,191,255,186,253,64,6,255,16,
128,7,225,0,0,234,60,6,152,209,149,0,28,48,230,143,19,0,224,137,
194,5,198,199,23,0,162,13,198,199,23,0,130,21,198,247,23,0,218,13,
198,207,23,0,170,13,38,135,25,0,224,129,194,5,128,255,194,2,181,5,
128,255,196,2,28,230,32,0,65,234,29,6,0,248,150,229,64,6,255,0,
128,7,225,0,6,224,7,232,32,70,52,0,190,255,28,39,29,62,52,0,
60,54,52,0,4,66,190,255,14,39,60,87,53,0,228,143,19,143,10,16,
144,18,241,17,179,5,100,23,18,143,228,119,21,143,45,6,152,205,149,0,
0,234,14,128,195,130,205,129,112,87,1,0,112,231,5,0,65,114,100,119,
20,143,28,48,29,56,128,255,98,2,65,234,109,234,166,253,32,86,56,0,
64,6,255,0,128,7,225,0,6,224,7,232,29,48,28,56,32,70,52,0,
190,255,176,38,29,54,52,0,60,62,52,0,4,66,190,255,162,38,0,234,
28,48,29,56,128,255,40,2,65,234,109,234,166,253,32,86,56,0,64,6,
255,0,199,0,0,18,6,80,106,7,1,0,68,82,65,18,109,18,182,253,
228,143,19,143,102,7,61,0,102,7,57,0,17,110,1,0,17,128,208,130,
16,57,102,63,53,0,100,111,18,143,127,0,128,7,33,0,128,255,232,1,
100,7,20,143,1,138,100,143,18,143,64,6,63,0,128,7,225,0,6,232,
8,224,72,58,61,54,8,0,32,70,24,0,190,255,44,38,28,48,29,56,
128,255,196,1,64,6,255,0,128,7,225,48,6,208,191,255,226,251,58,23,
125,0,226,81,218,29,58,55,1,0,58,71,101,0,58,62,4,0,191,255,
192,255,0,234,58,230,52,0,58,222,36,0,59,55,1,0,224,49,226,5,
58,71,113,0,28,56,190,255,222,103,76,226,68,218,65,234,100,234,182,245,
213,13,250,23,119,0,245,17,146,13,228,127,17,143,239,17,211,5,100,23,
16,143,100,215,13,143,64,6,255,48,128,7,97,0,36,143,37,137,224,137,
250,5,32,54,0,2,190,255,146,103,100,87,37,137,61,6,152,205,145,0,
29,48,32,62,250,0,64,70,4,0,190,255,236,38,0,82,29,16,32,94,
0,8,98,87,116,0,98,95,118,0,2,134,128,0,98,135,121,0,16,16,
95,90,65,82,10,6,0,248,182,245,34,6,152,205,145,0,47,6,128,255,
3,0,194,121,111,7,121,0,100,23,13,143,32,110,0,8,100,111,16,143,
64,6,127,0,128,7,97,0,229,87,64,0,224,7,96,1,36,55,37,137,
10,232,39,6,152,205,145,0,64,70,4,0,190,255,28,103,10,64,224,65,
130,13,38,6,48,189,133,0,32,62,146,4,190,255,84,42,29,248,255,47,
32,0,64,6,127,0,128,7,225,16,100,7,16,143,36,55,37,137,59,6,
152,205,145,0,27,56,64,70,4,0,190,255,38,121,10,56,224,57,138,45,
7,224,28,232,199,234,219,233,29,48,191,255,190,254,29,238,128,0,65,226,
28,6,0,248,134,253,228,127,17,143,224,121,154,13,38,6,64,189,133,0,
32,62,186,4,0,66,190,255,246,41,228,71,17,143,8,6,255,247,185,21,
38,6,64,189,133,0,32,62,187,4,190,255,222,41,224,81,165,13,38,6,
80,189,133,0,128,255,14,223,191,255,214,254,191,255,68,255,64,6,255,16,
33,6,208,61,1,0,97,0,33,6,244,55,1,0,97,0,33,6,92,58,
1,0,97,0,33,6,34,58,1,0,97,0,33,6,126,61,1,0,97,0,
64,7,84,177,38,6,100,90,134,0,128,7,150,195,224,49,210,5,129,58,
185,5,128,7,210,202,127,0,128,7,225,16,6,224,156,0,61,6,0,0,
32,0,229,87,64,0,224,7,96,1,10,216,15,138,125,143,74,0,125,143,
74,0,224,225,170,13,64,86,0,0,0,90,74,95,144,244,32,54,200,0,
128,255,228,106,32,118,0,4,125,119,76,0,10,106,125,111,74,0,15,98,
125,103,74,0,8,82,224,225,178,5,32,86,0,16,0,18,32,94,25,0,
32,102,41,0,229,5,125,103,74,0,125,95,74,0,65,18,234,17,166,253,
32,86,39,0,164,127,49,143,125,87,76,0,8,138,125,143,74,0,224,121,
194,5,15,6,236,255,201,5,128,22,0,128,165,5,0,18,132,119,53,143,
125,23,76,0,132,103,49,143,132,95,51,143,238,22,10,0,164,135,51,143,
128,118,0,128,226,103,194,2,11,86,248,255,16,126,244,255,36,95,34,143,
198,98,200,82,10,97,203,86,0,32,36,95,45,143,206,122,204,0,140,110,
47,144,226,95,194,2,11,121,125,111,74,0,143,134,0,144,10,129,100,135,
34,143,125,135,78,0,64,86,0,0,0,90,74,95,144,244,128,255,224,2,
27,248,255,47,32,0,64,6,255,16,128,7,225,16,60,6,0,0,32,0,
32,222,0,4,252,239,1,0,221,134,0,4,242,5,124,223,18,0,128,255,
190,2,191,255,98,159,140,234,201,245,128,255,186,2,191,255,86,159,245,237,
128,7,225,48,6,232,128,255,244,101,100,87,45,143,29,48,128,255,228,101,
68,87,49,143,29,48,128,255,212,101,68,87,48,143,29,48,128,255,36,102,
68,87,50,143,29,48,128,255,32,102,132,63,49,143,68,87,51,143,224,57,
194,5,7,6,225,255,169,13,38,6,16,192,133,0,128,255,56,221,32,118,
30,0,68,119,48,143,132,63,51,143,7,110,248,255,101,106,225,5,38,6,
240,191,133,0,128,255,26,221,132,23,51,143,8,82,104,18,179,5,2,80,
138,0,68,87,50,143,12,130,202,22,255,0,108,18,185,5,2,128,144,0,
61,6,0,0,32,0,68,135,50,143,32,54,52,177,37,62,216,134,1,66,
191,255,192,181,1,122,68,127,52,143,32,118,195,4,125,119,12,0,125,7,
78,0,0,18,32,86,25,0,32,94,41,0,125,95,74,0,125,87,74,0,
65,18,2,6,0,240,150,253,64,86,0,0,0,90,74,95,144,244,10,50,
128,255,4,105,128,255,216,1,64,86,0,0,0,90,74,95,144,244,10,50,
128,255,240,104,190,255,216,93,128,102,0,192,4,87,232,135,125,103,12,0,
32,94,48,42,125,95,18,0,224,81,242,5,36,143,234,135,100,138,239,111,
0,0,197,13,132,135,127,142,1,106,224,129,226,5,36,119,234,135,104,114,
175,5,0,106,141,0,128,22,0,128,224,105,178,5,32,22,0,64,125,23,
20,0,8,98,125,103,20,0,32,94,51,0,125,95,48,0,125,7,48,0,
96,7,5,227,61,126,32,6,29,142,0,6,96,143,93,177,96,127,97,177,
0,18,61,86,0,4,1,114,106,7,30,0,32,95,5,227,14,104,226,111,
192,0,45,96,76,89,96,95,5,227,10,86,32,0,65,18,2,6,238,255,
134,245,100,7,32,143,68,7,40,143,64,7,88,177,96,7,90,177,29,231,
3,0,38,6,48,192,133,0,29,223,3,0,64,7,89,177,216,226,156,226,
28,56,219,222,15,0,27,64,128,255,194,219,58,6,152,209,150,0,26,48,
32,62,32,0,9,66,190,255,144,34,32,142,46,0,90,7,8,0,28,86,
48,0,90,87,0,0,90,143,1,0,27,134,48,0,90,135,2,0,32,126,
48,0,90,127,3,0,100,218,226,119,0,0,64,119,104,177,181,5,253,23,
65,0,221,231,5,0,194,253,11,50,39,6,193,19,2,16,128,255,168,0,
15,50,128,255,170,0,202,0,64,110,9,0,13,81,10,56,15,50,128,255,
146,0,7,50,128,255,148,0,16,18,66,81,4,95,124,142,100,87,37,143,
32,102,16,4,125,103,14,0,99,90,202,5,1,50,191,255,118,252,32,86,
28,0,125,87,72,0,32,142,15,16,125,143,14,0,32,254,32,241,223,191,
0,0,64,86,0,0,0,90,74,95,144,244,32,254,32,241,223,183,0,0,
64,86,0,0,0,90,74,95,144,244,32,254,34,241,223,191,0,0,64,86,
0,0,0,90,74,95,144,244,64,6,255,48,33,6,158,86,1,0,97,0,
33,6,146,66,1,0,97,0,33,6,50,66,1,0,97,0,33,6,182,101,
0,0,97,0,33,6,96,69,1,0,97,0,33,6,28,69,1,0,97,0,
128,7,225,240,32,142,48,117,100,143,65,143,32,134,56,74,100,135,69,143,
32,126,136,19,100,127,73,143,128,255,158,0,0,234,60,6,244,18,151,0,
59,6,196,215,255,255,32,214,108,177,57,6,154,211,1,0,1,194,36,119,
69,143,10,106,26,16,98,7,20,0,237,119,194,2,66,239,22,0,24,96,
98,7,1,0,98,7,5,0,98,7,9,0,66,7,23,0,98,223,13,0,
34,87,13,0,253,103,192,0,107,234,2,90,106,207,5,0,106,103,18,0,
106,95,2,0,106,119,21,0,159,13,98,231,17,0,28,48,32,62,20,0,
128,255,54,0,181,5,98,7,17,0,28,230,52,0,27,222,40,0,26,214,
32,0,65,234,29,6,238,255,150,205,100,7,61,143,96,7,173,179,100,7,
77,143,64,6,255,240,33,6,132,102,1,0,97,0,33,6,136,90,1,0,
97,0,128,7,33,0,38,6,8,215,255,255,190,255,140,110,224,81,146,13,
38,6,40,193,133,0,32,62,255,0,0,66,190,255,140,36,190,255,248,36,
64,6,63,0,128,7,225,0,7,224,28,48,190,255,216,36,10,232,224,233,
210,13,38,6,8,215,255,255,28,56,190,255,74,110,224,81,226,239,0,0,
178,5,190,255,202,36,29,80,64,6,255,0,132,7,225,16,7,232,252,239,
72,2,6,216,219,233,61,127,13,0,224,121,178,13,197,5,2,50,128,255,
106,169,61,111,13,0,45,111,0,0,224,105,138,253,59,54,76,1,0,58,
3,64,128,255,86,167,224,81,146,13,38,6,52,193,133,0,32,62,31,10,
0,66,190,255,10,36,61,55,13,0,125,7,17,0,224,49,242,5,102,7,
0,0,190,255,114,99,125,7,13,0,0,226,61,238,28,0,61,55,33,0,
224,49,226,5,1,58,191,255,26,155,125,7,33,0,61,55,1,0,224,49,
210,5,190,255,114,159,125,7,1,0,68,234,65,226,104,226,198,237,35,63,
1,0,35,70,4,0,59,54,76,1,128,255,234,166,68,6,255,16,128,7,
225,0,6,224,7,232,3,50,128,255,212,168,93,234,224,233,215,5,188,143,
5,1,224,137,242,245,64,6,255,0,130,7,97,0,6,232,0,98,29,88,
107,103,1,0,75,7,4,0,107,7,9,0,107,7,17,0,107,7,13,0,
0,82,43,22,28,0,98,7,33,0,98,7,1,0,68,18,65,82,104,82,
150,253,11,94,92,0,65,98,98,98,246,229,1,138,125,143,9,0,99,7,
1,0,61,54,184,0,3,56,31,66,128,255,22,159,1,130,99,135,1,0,
61,54,184,0,3,56,31,66,128,255,4,159,66,6,127,0,130,7,225,16,
6,224,60,23,241,13,2,22,80,0,34,55,0,0,34,143,5,0,7,232,
63,6,202,226,129,0,220,49,113,0,224,81,218,13,28,48,29,56,191,255,
166,254,28,48,32,62,200,0,191,255,66,255,1,130,124,135,9,1,60,23,
241,13,29,56,2,22,96,0,34,55,0,0,34,127,5,0,3,64,63,6,
4,227,129,0,220,49,111,0,10,232,103,234,202,53,38,6,68,193,133,0,
128,255,246,215,0,234,1,218,60,55,241,0,190,255,76,205,35,63,1,0,
10,48,191,255,82,80,224,81,170,13,38,6,112,193,133,0,128,255,210,215,
92,7,6,1,7,82,165,29,35,95,1,0,27,96,253,103,192,0,75,97,
210,5,29,48,0,58,191,255,142,80,65,234,29,6,240,255,230,221,28,48,
191,255,222,254,0,234,38,6,164,193,133,0,128,255,154,215,29,80,66,6,
255,16,132,7,225,112,7,200,25,232,252,239,72,2,6,224,60,55,241,0,
220,233,61,223,25,0,61,215,21,0,3,56,128,255,46,51,235,217,250,21,
234,209,218,21,60,87,241,0,61,119,17,0,42,23,105,0,14,72,63,6,
200,227,129,0,2,22,24,1,34,55,0,0,34,111,5,0,191,74,14,64,
202,49,109,0,28,48,25,56,191,255,172,253,68,6,255,112,134,7,97,0,
6,232,191,255,156,255,61,55,241,0,35,62,4,0,198,183,2,0,128,255,
216,50,93,7,244,13,61,55,1,14,99,7,1,0,11,72,10,64,128,255,
8,86,93,7,6,1,70,6,127,0,130,7,225,112,8,216,252,223,72,2,
6,232,61,54,184,0,221,217,7,224,8,56,128,255,170,50,61,215,241,0,
124,87,1,0,123,87,13,0,11,106,58,215,14,0,124,111,25,0,32,54,
0,5,128,255,250,194,124,87,5,0,0,202,10,64,224,65,186,5,128,7,
50,1,59,55,61,0,0,58,26,72,190,255,218,96,61,103,249,13,224,97,
202,5,3,90,93,95,244,13,29,95,244,13,97,90,138,61,27,135,4,0,
61,87,241,0,2,114,95,130,42,23,105,0,91,135,4,0,93,119,244,13,
63,6,170,228,129,0,2,22,48,1,34,55,0,0,34,111,5,0,60,223,
13,0,60,215,9,0,202,49,109,0,124,87,9,0,124,95,13,0,61,87,
241,0,42,23,105,0,2,22,112,1,34,55,0,0,34,103,5,0,28,56,
63,6,210,228,129,0,202,49,108,0,224,81,170,5,1,202,124,215,9,0,
124,223,13,0,181,77,98,90,250,37,61,87,249,13,224,81,247,29,61,87,
241,0,42,23,105,0,2,22,56,1,34,55,0,0,34,135,5,0,63,6,
12,229,129,0,202,49,112,0,125,87,249,13,60,111,13,0,60,103,9,0,
10,112,191,114,238,105,225,5,187,5,234,97,179,5,125,7,249,13,61,23,
241,0,194,55,2,0,1,122,93,127,6,1,157,119,245,13,60,79,13,0,
60,71,9,0,61,55,1,14,99,119,1,0,128,255,186,84,61,87,241,0,
42,23,105,0,2,22,112,1,34,55,0,0,34,103,5,0,28,56,63,6,
112,229,129,0,202,49,108,0,224,81,170,5,1,202,60,55,5,0,128,255,
218,193,245,5,60,95,1,0,32,86,112,1,107,87,12,0,60,255,1,0,
229,87,64,0,224,7,96,1,63,239,0,0,10,224,217,233,127,239,0,0,
252,47,32,0,224,233,138,13,31,48,63,135,5,0,63,6,186,229,129,0,
112,0,66,6,255,112,128,7,225,48,8,232,252,239,72,2,6,216,59,54,
184,0,219,233,7,224,8,56,128,255,246,48,59,215,241,0,124,87,1,0,
125,87,13,0,12,114,58,215,14,0,124,119,25,0,32,54,0,5,128,255,
70,193,124,87,5,0,0,58,10,64,224,65,178,37,61,55,61,0,26,72,
190,255,44,95,59,87,241,0,60,111,1,0,42,23,105,0,1,98,109,103,
0,0,28,56,2,22,104,1,34,55,0,0,34,95,5,0,1,66,63,6,
56,230,129,0,202,49,107,0,60,55,5,0,125,87,29,0,128,255,20,193,
149,13,60,55,1,0,32,86,112,1,102,87,12,0,190,255,42,105,1,138,
125,143,9,0,91,143,244,13,64,6,255,48,130,7,225,16,8,232,29,16,
252,23,72,2,6,224,220,17,97,234,138,13,6,122,66,127,4,0,98,7,
17,0,0,82,213,29,1,114,98,119,17,0,39,55,18,0,0,66,34,62,
60,0,0,218,128,255,58,48,224,81,250,5,28,48,29,56,191,255,212,250,
32,222,112,1,99,239,1,0,60,54,184,0,3,56,31,66,128,255,236,154,
27,80,66,6,255,16,130,7,225,48,167,0,6,232,61,143,9,1,8,224,
9,208,0,218,97,138,234,45,97,58,250,37,61,54,184,0,3,56,32,70,
50,0,128,255,158,151,224,81,186,29,61,54,184,0,3,56,31,66,128,255,
174,154,35,127,1,0,252,127,72,2,221,121,15,111,4,0,97,106,194,5,
1,82,128,7,108,1,28,96,242,103,70,2,136,98,12,54,20,0,128,255,
222,163,125,7,9,1,165,13,122,7,1,0,0,82,128,7,76,1,97,58,
178,5,128,7,66,1,61,55,241,0,190,255,42,201,0,98,10,16,2,6,
240,255,161,13,197,18,32,94,164,180,203,17,34,87,5,0,224,81,162,5,
2,96,61,127,29,1,61,119,33,1,61,111,25,1,61,95,13,1,15,80,
238,127,192,2,44,23,21,0,207,105,125,111,25,1,130,89,224,89,154,13,
10,102,255,255,125,103,29,1,14,80,234,97,206,13,149,13,61,103,37,1,
65,82,125,87,29,1,236,81,199,5,12,80,125,87,29,1,61,135,25,1,
100,130,230,77,125,7,25,1,125,23,13,1,61,23,21,1,224,89,170,37,
224,17,231,5,61,119,21,1,95,114,125,119,21,1,51,6,5,0,32,0,
211,231,0,0,170,21,36,111,57,137,65,106,100,111,57,137,98,106,167,53,
36,103,53,137,129,98,12,54,1,0,128,255,10,163,100,7,57,137,133,45,
100,7,57,137,213,37,195,226,28,86,200,0,234,89,185,21,224,17,247,5,
61,127,21,1,95,122,125,127,21,1,133,29,61,103,33,1,1,218,125,223,
9,1,125,223,21,1,125,103,29,1,229,13,2,80,191,82,158,82,202,17,
162,18,2,6,236,255,238,5,61,127,21,1,65,122,125,127,21,1,61,119,
17,1,65,114,125,119,17,1,106,114,183,5,125,7,17,1,61,23,21,1,
61,135,17,1,2,88,191,90,158,90,203,17,162,18,226,129,239,111,0,0,
122,111,1,0,27,80,66,6,255,48,128,7,225,16,6,232,132,71,81,143,
61,135,253,13,240,71,34,2,38,231,9,1,167,0,191,255,44,254,10,216,
97,226,234,13,61,111,9,1,224,105,170,13,132,95,81,143,235,102,100,0,
136,98,12,54,1,0,128,255,70,162,27,80,64,6,255,16,138,7,225,243,
9,184,7,192,8,232,29,56,7,208,6,216,59,23,241,13,252,215,72,2,
35,183,57,0,99,63,1,0,2,22,80,0,34,55,0,0,219,209,34,119,
5,0,26,207,4,0,219,49,63,6,252,232,129,0,110,0,224,81,178,5,
128,7,150,1,101,202,186,5,1,202,197,5,101,202,174,5,65,202,90,207,
4,0,101,202,178,5,128,7,90,1,58,95,25,0,55,111,5,0,55,103,
1,0,58,23,21,0,237,89,186,5,236,17,194,37,59,54,184,0,35,62,
4,0,31,66,128,255,68,149,35,111,5,0,1,90,59,54,184,0,252,111,
72,2,35,62,4,0,31,66,219,105,109,95,9,0,128,255,70,152,95,202,
90,207,4,0,59,54,184,0,3,56,31,66,128,255,52,152,25,80,170,0,
128,7,44,3,59,23,241,13,35,63,1,0,2,22,72,0,34,55,0,0,
34,87,5,0,63,6,154,233,129,0,219,49,106,0,59,55,241,0,35,62,
12,0,128,255,32,45,119,87,1,0,119,95,5,0,35,95,17,0,35,87,
13,0,11,81,218,5,6,202,90,207,4,0,165,93,29,102,1,0,204,22,
1,0,99,23,5,0,252,23,72,2,2,80,219,81,10,135,4,0,224,129,
226,21,219,17,2,119,4,0,102,114,146,21,59,54,184,0,35,62,4,0,
10,66,128,255,146,148,224,81,138,13,59,54,184,0,35,62,4,0,31,66,
128,255,160,151,59,54,184,0,3,56,31,66,128,255,148,151,59,111,17,1,
97,106,159,45,224,233,250,37,59,55,241,0,190,255,26,131,59,103,237,13,
10,64,131,66,236,65,210,29,36,151,41,137,37,54,228,134,65,146,100,151,
41,137,210,94,15,0,111,90,170,5,8,202,27,63,40,1,123,71,237,13,
128,255,178,208,36,151,41,137,210,134,7,0,103,130,218,5,37,54,236,134,
128,255,158,208,25,80,170,0,128,7,52,2,59,23,241,13,2,22,24,0,
34,55,0,0,34,127,5,0,32,62,35,0,63,6,146,234,129,0,219,49,
111,0,224,81,234,5,7,82,90,87,4,0,128,7,8,2,58,55,13,0,
224,49,210,5,102,7,0,0,190,255,152,90,122,7,13,0,97,202,178,5,
128,7,30,1,59,151,29,1,104,146,99,151,9,0,199,5,8,146,99,151,
9,0,59,55,241,0,35,62,12,0,128,255,236,43,35,239,17,0,55,71,
1,0,54,55,1,0,54,63,5,0,35,231,13,0,55,95,5,0,134,65,
225,79,0,0,135,73,137,89,168,225,225,87,0,0,157,81,171,81,99,87,
17,0,99,231,13,0,10,225,138,37,35,135,1,0,6,202,65,130,208,22,
1,0,99,23,5,0,252,23,72,2,1,106,90,207,4,0,219,17,2,103,
4,0,98,111,9,0,98,98,178,5,128,7,76,1,59,54,184,0,35,62,
4,0,31,66,128,255,92,150,128,7,58,1,35,143,9,0,10,104,35,103,
13,0,17,88,191,90,234,89,225,5,187,5,236,137,179,5,99,103,9,0,
122,55,21,0,122,63,25,0,59,23,241,13,35,71,1,0,35,151,9,0,
24,56,2,22,48,0,34,55,0,0,34,119,5,0,122,151,17,0,63,6,
156,235,129,0,219,49,110,0,224,81,186,21,58,71,17,0,54,119,1,0,
54,135,5,0,8,56,191,58,206,65,118,71,1,0,225,127,0,0,199,121,
208,121,118,127,5,0,165,101,95,202,90,207,4,0,1,50,123,55,29,1,
128,255,44,159,149,93,99,202,242,5,98,202,186,37,58,95,9,0,224,89,
247,29,58,87,21,0,58,95,25,0,35,71,1,0,120,87,9,0,120,95,
13,0,59,23,241,13,122,7,9,0,3,82,24,56,2,22,56,0,34,55,
0,0,34,135,5,0,90,87,4,0,63,6,32,236,129,0,219,49,112,0,
181,53,100,202,154,53,58,87,21,0,58,95,25,0,120,87,9,0,120,95,
13,0,59,23,241,13,35,71,1,0,2,22,64,0,34,55,0,0,34,127,
5,0,24,56,63,6,86,236,129,0,219,49,111,0,35,119,1,0,65,114,
206,22,1,0,99,23,5,0,252,23,72,2,1,90,219,17,2,87,4,0,
98,95,9,0,98,82,138,13,59,54,184,0,35,62,4,0,31,66,128,255,
34,149,59,23,241,13,2,22,32,0,34,55,0,0,34,135,5,0,63,6,
160,236,129,0,219,49,112,0,25,80,170,0,74,6,255,243,132,7,97,0,
6,232,0,90,0,82,29,16,2,119,4,0,224,113,242,5,98,114,210,5,
102,114,178,5,103,114,170,5,65,90,2,22,92,0,65,82,98,82,150,245,
98,90,206,29,61,54,184,0,35,62,4,0,31,66,128,255,162,145,35,111,
5,0,98,106,145,13,38,6,224,193,133,0,32,62,126,10,0,66,190,255,
206,24,35,103,5,0,252,103,72,2,221,97,76,7,4,0,149,213,61,54,
184,0,3,56,0,66,128,255,110,145,224,81,146,253,68,6,127,0,136,7,
225,48,6,232,58,6,8,215,255,255,26,224,28,48,31,58,190,255,120,98,
224,81,186,253,29,143,72,1,97,138,170,101,29,135,71,1,97,130,234,93,
32,223,169,182,60,6,240,193,133,0,93,7,71,1,0,58,27,48,3,64,
128,255,160,155,224,81,242,5,28,48,32,62,198,10,0,66,190,255,88,24,
61,126,76,1,239,217,210,13,61,54,76,1,128,255,16,155,224,81,242,5,
28,48,32,62,204,10,0,66,190,255,56,24,26,48,190,255,30,98,224,81,
146,13,38,6,0,194,133,0,32,62,255,0,0,66,190,255,30,24,99,239,
9,0,1,18,67,23,12,0,35,62,8,0,38,6,200,146,145,0,31,66,
128,255,224,147,224,81,242,5,28,48,32,62,222,10,0,66,190,255,244,23,
32,54,12,177,32,62,32,0,0,66,190,255,246,56,224,81,242,5,28,48,
32,62,226,10,0,66,190,255,214,23,35,63,1,0,35,70,4,0,27,48,
128,255,0,155,245,13,26,48,190,255,172,97,224,81,162,13,38,6,0,194,
133,0,32,62,255,0,0,66,190,255,172,23,224,81,72,6,255,48,168,7,
225,16,6,232,61,54,76,1,9,58,35,70,4,0,128,255,202,154,1,226,
229,21,229,87,64,0,224,7,96,1,36,23,53,137,10,248,99,18,254,5,
2,134,1,0,100,135,53,137,93,231,70,1,255,47,32,0,32,54,20,0,
128,255,152,156,29,127,70,1,224,121,130,237,60,6,8,215,255,255,28,48,
31,58,190,255,50,97,224,81,186,253,61,55,241,0,190,255,226,193,10,224,
28,56,61,70,40,1,38,6,28,194,133,0,128,255,110,204,61,87,241,0,
42,23,105,0,2,22,240,0,34,55,0,0,34,119,5,0,63,6,186,238,
129,0,202,49,110,0,61,23,241,0,2,23,7,0,123,18,226,13,119,18,
162,13,2,6,33,0,210,5,2,6,81,0,146,13,245,13,11,50,133,13,
12,50,229,5,32,54,41,0,181,5,32,54,51,0,37,62,240,134,28,64,
190,255,168,24,38,6,8,215,255,255,190,255,186,96,224,81,146,13,38,6,
52,194,133,0,32,62,255,0,0,66,190,255,186,22,28,48,31,58,190,255,
248,180,29,48,191,255,34,243,61,55,241,0,99,7,68,0,99,7,74,0,
38,111,8,0,99,7,57,0,99,7,53,0,35,62,40,0,99,111,70,0,
128,255,130,39,99,87,61,0,99,95,65,0,61,55,241,0,190,255,238,125,
10,88,191,90,157,90,203,81,163,82,125,87,237,13,35,87,41,0,35,95,
45,0,10,112,11,113,218,13,10,16,252,23,72,2,6,90,221,17,66,95,
4,0,2,22,92,0,65,82,98,82,166,253,35,87,61,0,35,95,65,0,
125,7,17,1,125,7,25,1,125,87,245,0,125,87,253,0,125,95,249,0,
125,95,1,1,0,18,28,6,240,255,161,13,197,226,32,126,164,180,207,225,
60,119,5,0,224,113,162,5,28,16,34,111,21,0,125,7,9,1,125,111,
13,1,61,54,184,0,35,62,8,0,31,66,128,255,172,142,35,103,9,0,
98,98,145,13,38,6,12,194,133,0,32,62,206,1,0,66,190,255,216,21,
35,95,9,0,61,23,241,13,132,127,81,143,35,78,12,0,252,95,72,2,
2,22,40,0,34,55,0,0,221,89,11,223,4,0,34,119,5,0,221,49,
15,64,27,128,16,56,63,6,42,240,129,0,110,0,97,82,154,13,61,54,
184,0,35,62,8,0,31,66,128,255,108,145,149,205,97,218,138,21,35,103,
13,0,3,95,74,0,224,97,226,23,0,0,203,94,253,0,194,86,1,0,
193,82,10,89,67,95,74,0,61,87,253,0,61,95,1,1,29,48,35,71,
9,0,99,87,33,0,99,95,37,0,61,87,245,0,61,95,249,0,35,134,
24,0,99,135,1,0,99,87,25,0,99,95,29,0,35,62,52,0,35,78,
32,0,191,255,42,248,10,216,35,87,33,0,35,95,37,0,125,87,253,0,
125,95,1,1,35,87,25,0,35,95,29,0,104,218,125,87,245,0,125,95,
249,0,138,45,29,48,191,255,230,251,0,226,29,48,28,56,191,255,172,240,
65,226,98,226,166,253,61,55,241,0,35,62,16,0,128,255,228,37,125,87,
253,0,125,95,1,1,125,87,245,0,61,55,241,0,125,95,249,0,1,114,
125,119,29,1,190,255,108,191,10,48,31,58,190,255,10,179,29,48,191,255,
52,241,103,218,218,85,61,23,241,13,35,231,9,0,63,6,58,241,129,0,
2,22,80,0,34,55,0,0,28,102,1,0,34,95,5,0,204,222,1,0,
221,49,27,56,107,0,224,81,242,21,27,16,252,23,72,2,221,17,34,95,
25,0,34,87,21,0,28,16,252,23,72,2,221,17,34,111,25,0,34,103,
21,0,237,89,219,5,177,5,236,81,169,5,27,224,61,23,241,13,2,22,
88,0,34,55,0,0,34,87,5,0,28,56,63,6,134,241,129,0,221,49,
106,0,61,55,241,0,10,216,35,62,16,0,128,255,50,37,125,87,253,0,
125,95,1,1,125,87,245,0,125,95,249,0,1,130,125,135,29,1,103,218,
146,61,35,87,17,0,35,95,21,0,11,81,178,5,102,218,202,53,35,87,
9,0,65,82,202,22,1,0,252,23,72,2,221,17,2,119,4,0,102,114,
138,45,61,55,241,0,190,255,142,190,61,23,241,0,2,23,7,0,10,64,
123,18,226,13,119,18,162,13,2,6,33,0,210,5,2,6,81,0,146,13,
229,13,5,50,133,13,7,50,229,5,32,54,43,0,181,5,32,54,53,0,
37,62,240,134,190,255,132,21,31,106,93,111,4,1,1,98,93,103,5,1,
189,95,5,1,224,89,186,5,191,7,162,253,157,87,7,1,224,81,178,5,
191,7,150,253,29,48,191,255,228,250,61,54,76,1,128,255,74,150,38,6,
12,194,133,0,32,62,106,2,0,66,190,255,114,19,224,81,191,7,114,253,
142,7,225,208,6,232,35,54,16,0,37,62,248,134,128,255,176,84,38,6,
108,194,133,0,35,62,16,0,128,255,138,200,1,226,197,21,229,87,64,0,
224,7,96,1,36,23,53,137,10,248,224,17,218,5,100,231,53,137,93,231,
70,1,255,47,32,0,32,54,20,0,128,255,86,152,29,135,70,1,224,129,
162,237,38,6,64,194,133,0,128,255,78,200,32,54,88,1,128,255,214,178,
10,216,27,48,0,58,32,70,88,1,190,255,24,15,60,6,8,215,255,255,
28,48,31,58,190,255,208,92,224,81,186,253,61,55,241,0,190,255,128,189,
10,48,27,56,190,255,152,189,61,55,241,0,35,62,4,0,128,255,198,35,
10,192,61,87,241,0,42,23,105,0,2,22,56,1,34,55,0,0,34,127,
5,0,11,200,63,6,34,243,129,0,202,49,111,0,125,87,249,13,10,120,
191,122,239,201,225,5,187,5,234,193,179,5,125,7,249,13,61,87,241,0,
42,111,14,0,42,23,105,0,1,58,63,6,108,243,129,0,13,120,191,122,
151,122,207,105,169,106,2,22,72,1,34,55,0,0,34,95,5,0,67,106,
125,111,253,13,202,49,107,0,38,6,8,215,255,255,190,255,66,92,224,81,
146,13,38,6,148,194,133,0,32,62,255,0,0,66,190,255,66,18,61,87,
241,0,0,122,202,247,2,0,162,5,2,122,27,56,24,64,25,72,143,0,
99,127,1,0,0,50,128,255,192,74,125,87,1,14,27,48,128,255,104,179,
29,48,191,255,112,250,78,6,255,208,128,7,225,16,6,224,60,55,241,0,
28,223,72,1,92,7,72,1,224,49,242,45,97,218,218,45,28,135,70,1,
97,130,154,45,190,255,136,188,28,63,4,1,10,232,29,48,31,66,191,255,
238,136,60,23,241,0,2,23,7,0,123,18,130,21,119,18,178,13,2,6,
33,0,210,5,2,6,81,0,178,13,149,21,32,54,59,0,149,13,32,54,
60,0,229,5,32,54,61,0,181,5,32,54,62,0,37,62,252,134,29,64,
190,255,108,19,0,234,28,48,29,56,191,255,66,237,65,234,98,234,166,253,
28,119,73,1,61,6,160,194,133,0,97,114,250,13,60,54,184,0,128,255,
42,144,224,81,242,5,29,48,32,62,64,11,0,66,190,255,102,17,92,7,
73,1,97,218,170,29,60,54,76,1,128,255,30,148,224,81,242,5,29,48,
32,62,72,11,0,66,190,255,70,17,60,54,76,1,128,255,246,149,224,81,
130,13,29,48,32,62,75,11,0,66,190,255,46,17,224,81,64,6,255,16,
128,7,225,16,6,232,7,216,224,233,162,77,49,6,112,90,134,0,125,143,
241,13,191,255,4,255,60,6,8,215,255,255,28,48,31,58,190,255,228,90,
224,81,186,253,61,55,241,0,190,255,148,187,10,56,7,6,240,255,193,13,
61,23,241,0,61,70,40,1,38,6,176,194,133,0,66,7,3,0,128,255,
20,198,38,6,8,215,255,255,190,255,184,90,224,81,146,13,38,6,200,194,
133,0,32,62,255,0,0,66,190,255,184,16,229,87,64,0,224,7,96,1,
29,127,70,1,10,248,97,122,138,13,93,7,70,1,36,119,53,137,95,114,
100,119,53,137,255,47,32,0,129,218,201,5,29,48,128,255,218,177,64,6,
255,16,136,7,225,243,6,232,7,176,224,233,186,5,128,7,116,2,49,6,
224,92,134,0,125,143,241,13,35,54,4,0,37,62,4,135,128,255,182,81,
38,6,212,194,133,0,35,62,4,0,128,255,144,197,29,48,191,255,66,254,
29,23,70,1,97,18,242,13,61,55,1,14,224,49,194,5,3,58,128,255,
134,70,38,6,236,194,133,0,128,255,106,197,128,7,20,2,58,6,8,215,
255,255,67,23,3,0,26,224,28,48,31,58,190,255,248,89,224,81,186,253,
61,55,241,0,55,6,16,193,133,0,190,255,162,186,10,224,28,6,240,255,
137,29,163,127,3,0,224,121,186,5,128,7,218,1,67,7,3,0,26,48,
190,255,208,89,224,81,186,5,128,7,200,1,23,48,32,62,255,0,0,66,
190,255,208,15,128,7,184,1,61,87,241,0,42,23,105,0,0,218,0,58,
2,22,72,1,34,55,0,0,34,119,5,0,74,7,3,0,63,6,38,246,
129,0,202,49,110,0,61,111,241,0,13,111,7,0,127,106,178,5,128,7,
2,1,38,6,28,195,133,0,128,255,202,196,61,87,241,0,42,23,105,0,
2,22,224,0,34,55,0,0,34,103,5,0,63,6,94,246,129,0,202,49,
108,0,10,48,244,55,66,2,128,255,212,176,10,200,224,201,178,85,61,87,
241,0,42,23,105,0,2,22,144,0,34,55,0,0,34,127,5,0,63,6,
140,246,129,0,202,49,111,0,61,87,241,0,42,23,105,0,2,22,232,0,
34,55,0,0,34,119,5,0,25,56,63,6,172,246,129,0,202,49,110,0,
25,48,191,255,166,133,10,192,25,48,128,255,158,176,163,111,3,0,224,105,
226,13,67,7,3,0,26,48,190,255,236,88,224,81,242,5,23,48,32,62,
255,0,0,66,190,255,240,14,224,193,194,21,28,48,24,56,191,255,136,133,
56,23,105,0,2,22,240,0,34,55,0,0,34,95,5,0,10,216,63,6,
4,247,129,0,216,49,107,0,229,13,38,6,68,195,133,0,128,255,250,195,
133,13,32,222,16,1,38,6,160,195,133,0,128,255,234,195,32,54,12,177,
32,62,64,0,0,66,190,255,174,47,224,217,138,29,165,21,163,87,3,0,
224,81,226,13,67,7,3,0,26,48,190,255,114,88,224,81,242,5,23,48,
32,62,255,0,0,66,190,255,118,14,28,48,31,58,190,255,180,172,10,216,
61,55,1,14,224,49,210,13,224,217,234,5,128,255,204,67,28,48,191,255,
42,133,61,55,1,14,3,58,128,255,156,68,29,63,40,1,38,6,132,195,
133,0,125,7,241,0,128,255,120,195,163,103,3,0,224,97,226,13,67,7,
3,0,26,48,190,255,20,88,224,81,242,5,23,48,32,62,255,0,0,66,
190,255,24,14,29,48,0,58,191,255,236,252,129,178,201,5,29,48,128,255,
86,175,72,6,255,243,128,7,225,16,6,232,224,233,138,13,32,54,244,13,
128,255,190,173,10,232,224,233,242,77,49,6,112,90,134,0,125,143,241,13,
61,54,228,1,0,58,8,66,190,255,242,9,61,54,236,1,32,62,254,0,
32,70,0,12,190,255,226,9,1,130,93,135,71,1,93,7,72,1,93,7,
73,1,93,7,70,1,125,7,241,0,32,126,223,255,93,127,4,1,93,7,
5,1,93,7,6,1,0,218,29,224,28,48,0,58,32,70,92,0,190,255,
172,9,28,230,92,0,65,218,98,218,230,245,10,114,125,119,21,1,61,54,
40,1,0,58,32,70,30,0,190,255,142,9,36,111,49,137,32,102,45,0,
93,103,41,1,39,6,228,195,133,0,13,110,65,0,93,111,40,1,61,54,
42,1,128,255,194,195,29,80,64,6,255,16,128,7,97,0,6,232,224,233,
138,13,32,54,4,14,128,255,4,173,10,232,224,233,194,29,29,48,191,255,
44,255,36,135,49,137,49,6,224,92,134,0,125,143,241,13,39,6,240,195,
133,0,16,134,65,0,93,135,40,1,32,126,45,0,93,127,41,1,61,54,
42,1,128,255,114,195,125,7,1,14,29,80,64,6,127,0,130,7,225,0,
6,232,61,23,241,13,2,22,96,0,34,55,0,0,34,143,5,0,3,64,
63,6,250,248,129,0,221,49,113,0,10,224,103,226,202,37,61,55,241,0,
190,255,100,183,35,63,1,0,10,48,191,255,106,58,224,81,186,5,7,82,
133,29,0,50,1,18,32,86,239,255,35,111,1,0,2,112,230,119,192,0,
77,113,130,13,93,87,4,1,0,58,191,255,170,58,7,82,229,5,65,50,
6,6,240,255,246,237,28,80,66,6,255,0,132,7,225,48,6,232,61,23,
241,13,2,22,80,0,34,55,0,0,34,135,5,0,7,224,63,6,110,249,
129,0,221,49,112,0,10,208,29,48,28,56,191,255,100,255,10,216,103,218,
202,85,26,6,254,253,210,5,60,6,8,215,255,255,197,37,61,87,241,0,
42,23,105,0,1,66,2,22,24,1,34,55,0,0,34,111,5,0,0,74,
63,6,174,249,129,0,202,49,109,0,61,55,241,0,3,56,128,255,14,29,
35,103,5,0,35,87,1,0,12,81,186,5,6,218,245,45,29,48,191,255,
116,232,0,218,165,45,28,48,31,58,190,255,214,85,224,81,186,253,61,87,
241,0,42,23,105,0,3,58,2,22,152,1,34,55,0,0,34,135,5,0,
27,66,63,6,0,250,129,0,202,49,112,0,38,6,8,215,255,255,190,255,
174,85,224,81,146,13,38,6,252,195,133,0,32,62,255,0,0,66,190,255,
174,11,31,122,93,127,4,1,27,80,68,6,255,48,132,7,225,241,8,208,
252,215,72,2,6,184,55,54,184,0,215,209,7,232,8,56,128,255,138,28,
125,87,1,0,122,87,13,0,61,151,9,0,61,159,13,0,99,151,1,0,
99,159,5,0,55,103,241,0,44,103,14,0,0,218,0,226,125,103,18,0,
12,104,35,119,1,0,12,16,35,127,5,0,191,106,14,200,14,80,236,119,
32,2,234,23,34,10,236,127,32,2,125,119,9,0,237,207,32,2,1,80,
202,121,207,201,125,207,13,0,149,29,55,55,241,0,29,56,128,255,54,28,
61,119,18,0,61,103,9,0,61,111,13,0,14,120,191,122,204,113,125,119,
9,0,225,23,0,0,207,17,205,17,125,23,13,0,65,218,65,226,58,103,
17,0,236,225,214,229,61,255,1,0,229,87,64,0,224,7,96,1,63,231,
0,0,219,225,127,231,0,0,10,216,251,47,32,0,224,225,138,13,31,48,
63,95,5,0,63,6,4,251,129,0,107,0,35,151,1,0,35,159,5,0,
125,151,9,0,125,159,13,0,68,6,255,241,130,7,33,0,99,71,1,0,
38,54,184,0,3,56,31,66,128,255,124,134,66,6,63,0,130,7,33,0,
99,71,1,0,38,54,184,0,3,56,31,66,128,255,100,134,0,82,66,6,
63,0,128,7,225,16,164,71,81,143,167,0,38,231,9,1,6,232,191,255,
104,235,10,216,97,226,234,13,61,127,9,1,224,121,170,13,164,111,81,143,
237,118,50,0,136,114,14,54,1,0,128,255,130,143,27,80,64,6,255,16,
128,7,97,0,6,232,224,233,138,13,32,54,244,13,128,255,4,170,10,232,
224,233,162,29,29,48,191,255,44,252,36,135,49,137,49,6,120,92,134,0,
125,143,241,13,39,6,8,196,133,0,16,134,65,0,93,135,40,1,32,126,
45,0,93,127,41,1,61,54,42,1,128,255,114,192,29,80,64,6,127,0,
128,7,225,16,6,232,61,23,241,13,2,22,80,0,34,55,0,0,34,143,
5,0,7,224,63,6,246,251,129,0,221,49,113,0,10,216,29,48,28,56,
191,255,220,252,10,224,103,226,250,21,27,6,143,254,202,21,23,114,93,119,
4,1,38,6,20,196,133,0,128,255,238,190,61,55,241,0,190,255,72,180,
10,64,32,54,42,0,37,62,8,135,190,255,106,11,28,80,64,6,255,16,
168,7,225,240,8,216,27,208,252,215,72,2,6,224,7,232,220,209,125,31,
5,0,190,255,222,72,60,102,184,0,106,7,9,0,32,118,232,3,106,119,
21,0,45,6,200,42,1,0,106,111,5,0,106,223,33,0,106,103,29,0,
125,87,1,0,122,87,13,0,0,202,0,226,58,222,60,0,32,198,16,0,
165,37,59,55,1,0,61,71,5,0,61,79,18,0,0,58,190,255,156,72,
100,82,151,13,38,6,44,196,133,0,32,62,139,15,0,66,190,255,28,9,
221,7,22,0,125,199,25,0,12,58,12,50,29,64,190,255,126,72,221,135,
22,0,65,202,65,226,68,218,58,143,17,0,241,225,198,221,61,255,1,0,
229,87,64,0,224,7,96,1,63,239,0,0,10,224,217,233,127,239,0,0,
252,47,32,0,224,233,138,13,31,48,63,135,5,0,63,6,2,253,129,0,
112,0,104,6,255,240,168,7,225,243,8,208,252,215,72,2,6,192,7,232,
216,209,125,31,5,0,56,54,184,0,8,56,128,255,170,25,12,98,125,103,
25,0,125,87,1,0,122,87,13,0,61,191,13,0,61,183,9,0,0,202,
0,218,58,230,28,0,245,53,60,55,33,0,61,71,5,0,61,79,18,0,
0,58,190,255,226,71,100,82,151,13,38,6,60,196,133,0,32,62,72,15,
0,66,190,255,98,8,56,87,241,0,42,23,105,0,2,22,120,1,34,55,
0,0,202,49,34,87,5,0,63,6,140,253,129,0,1,66,29,56,106,0,
124,87,1,0,61,103,9,0,61,111,13,0,65,202,12,86,1,0,125,87,
9,0,225,23,0,0,205,17,125,23,13,0,68,226,65,218,58,135,17,0,
240,217,246,197,125,183,9,0,125,191,13,0,61,255,1,0,229,87,64,0,
224,7,96,1,63,239,0,0,10,224,217,233,127,239,0,0,252,47,32,0,
224,233,138,13,31,48,63,127,5,0,63,6,238,253,129,0,111,0,104,6,
255,243,128,7,225,16,164,71,81,143,167,0,38,231,9,1,6,232,191,255,
192,232,10,216,97,226,234,13,61,127,9,1,224,121,170,13,164,111,81,143,
237,118,50,0,136,114,14,54,1,0,128,255,218,140,27,80,64,6,255,16,
128,7,97,0,6,232,224,233,138,13,32,54,244,13,128,255,92,167,10,232,
224,233,162,29,29,48,191,255,132,249,36,135,49,137,49,6,16,92,134,0,
125,143,241,13,39,6,76,196,133,0,16,134,65,0,93,135,40,1,32,126,
45,0,93,127,41,1,61,54,42,1,128,255,202,189,29,80,64,6,127,0,
182,7,225,243,8,176,252,183,72,2,99,55,13,0,7,208,198,177,38,54,
184,0,8,56,128,255,54,24,122,87,1,0,118,87,13,0,58,151,9,0,
58,159,13,0,35,207,13,0,11,106,99,151,21,0,99,159,25,0,58,151,
18,0,218,55,22,0,99,151,9,0,99,151,17,0,122,111,25,0,57,207,
241,0,57,207,14,0,122,207,18,0,242,207,192,2,25,48,194,50,244,55,
66,2,128,255,86,168,58,119,18,0,99,87,5,0,58,103,9,0,122,87,
5,0,14,120,58,111,13,0,12,80,12,232,238,103,32,2,14,16,234,23,
34,10,122,103,9,0,191,122,238,111,32,2,239,239,32,2,1,80,202,105,
205,233,122,239,13,0,35,151,5,0,99,7,1,0,224,145,226,93,0,194,
54,190,60,0,149,85,55,55,1,0,35,79,17,0,35,70,28,0,0,58,
190,255,240,69,10,216,100,218,151,13,38,6,88,196,133,0,32,62,204,14,
0,66,190,255,110,6,35,239,5,0,0,226,244,223,66,2,149,13,29,48,
35,62,28,0,27,64,190,255,22,1,219,233,65,226,249,225,246,245,35,87,
13,0,42,87,241,0,42,23,105,0,26,56,2,22,64,0,34,55,0,0,
34,119,5,0,35,70,28,0,63,6,166,255,129,0,202,49,110,0,58,119,
18,0,58,103,9,0,58,111,13,0,14,120,191,122,204,113,122,119,9,0,
225,23,0,0,207,17,205,17,122,23,13,0,35,151,1,0,65,194,68,186,
65,146,99,151,1,0,54,111,17,0,237,193,214,173,35,55,5,0,128,255,
114,167,245,5,58,103,1,0,32,94,112,1,108,95,12,0,58,255,1,0,
229,87,64,0,224,7,96,1,35,143,1,0,63,239,0,0,10,224,209,233,
127,239,0,0,252,47,32,0,224,233,138,13,31,48,63,87,5,0,63,6,
38,0,130,0,106,0,35,151,21,0,35,159,25,0,122,151,9,0,35,151,
9,0,122,159,13,0,122,151,18,0,118,6,255,243,130,7,33,0,99,71,
1,0,38,54,184,0,3,56,31,66,128,255,82,129,66,6,63,0,128,7,
97,0,6,232,224,233,138,13,32,54,244,13,128,255,46,165,10,232,224,233,
146,29,29,48,191,255,86,247,36,135,49,137,49,6,168,91,134,0,125,143,
241,13,37,62,16,135,16,134,65,0,93,135,40,1,32,126,45,0,93,127,
41,1,61,54,42,1,128,255,158,187,29,80,64,6,127,0,128,7,225,0,
167,0,6,232,7,224,191,255,16,230,101,226,186,13,61,127,241,0,15,127,
7,0,119,122,218,5,61,119,37,1,125,119,29,1,64,6,255,0,128,7,
97,0,6,232,224,233,138,13,32,54,244,13,128,255,182,164,10,232,224,233,
162,29,29,48,191,255,222,246,36,135,49,137,49,6,64,91,134,0,125,143,
241,13,39,6,104,196,133,0,16,134,65,0,93,135,40,1,32,126,45,0,
93,127,41,1,61,54,42,1,128,255,36,187,29,80,64,6,127,0,130,7,
225,241,7,184,0,194,8,200,25,216,252,223,72,2,0,234,6,208,218,217,
59,230,60,0,165,21,55,55,18,0,0,66,28,56,128,255,140,21,224,81,
138,13,26,48,25,56,191,255,38,224,32,198,112,1,245,5,68,226,65,234,
59,119,17,0,238,233,198,237,99,207,1,0,58,54,184,0,3,56,31,66,
128,255,48,128,24,80,66,6,255,241,128,7,97,0,6,232,224,233,138,13,
32,54,244,13,128,255,10,164,10,232,224,233,162,29,29,48,191,255,50,246,
36,135,49,137,49,6,216,90,134,0,125,143,241,13,39,6,120,196,133,0,
16,134,65,0,93,135,40,1,32,126,45,0,93,127,41,1,61,54,42,1,
128,255,120,186,29,80,64,6,127,0,128,7,33,0,196,239,96,144,226,29,
196,231,96,144,178,29,4,135,83,143,98,130,146,13,97,130,242,5,4,119,
84,143,98,114,178,5,97,114,250,13,36,111,125,176,224,105,202,5,1,50,
128,255,226,68,32,54,12,177,128,62,0,128,0,66,190,255,202,36,64,6,
63,0,191,7,184,255,132,7,225,0,6,232,35,54,3,0,7,224,35,62,
4,0,128,255,132,68,32,142,60,0,241,87,194,2,0,90,165,29,61,103,
2,0,61,23,0,0,32,118,96,39,68,234,12,120,194,121,238,127,194,106,
224,97,194,13,237,17,203,5,226,81,131,13,181,5,226,81,185,5,237,81,
185,5,1,82,213,5,65,90,252,89,230,229,0,82,68,6,255,0,184,7,
225,115,6,232,61,223,241,0,29,224,8,176,9,184,59,223,8,0,99,183,
93,0,99,191,97,0,99,7,100,0,99,7,106,0,99,7,85,0,132,127,
83,143,35,134,4,0,99,135,89,0,99,223,102,0,224,121,210,5,32,86,
113,1,128,7,68,2,57,6,8,215,255,255,0,58,191,255,182,222,25,208,
26,48,31,58,190,255,224,76,224,81,186,253,58,6,152,196,133,0,27,48,
60,62,60,0,31,66,128,255,240,19,60,55,61,0,27,72,0,58,35,70,
4,0,190,255,66,66,60,55,61,0,190,255,80,64,224,81,194,21,25,48,
190,255,176,76,224,81,242,5,26,48,32,62,255,0,0,66,190,255,180,2,
29,48,0,58,191,255,92,222,32,86,113,1,128,7,214,1,61,54,184,0,
0,58,128,255,156,19,99,87,85,0,10,112,61,87,241,0,14,104,1,98,
42,23,105,0,109,103,0,0,124,119,13,0,35,62,84,0,2,22,104,1,
34,55,0,0,34,95,5,0,1,66,63,6,104,3,130,0,202,49,107,0,
124,87,29,0,25,48,10,16,224,17,186,21,60,87,13,0,106,23,0,0,
190,255,56,76,224,81,242,5,26,48,32,62,255,0,0,66,190,255,60,2,
32,222,34,1,128,7,92,1,190,255,28,76,224,81,242,5,26,48,32,62,
255,0,0,66,190,255,32,2,61,54,184,0,3,56,31,66,128,255,208,122,
35,135,1,0,224,129,146,13,38,6,136,196,133,0,32,62,251,7,0,66,
190,255,252,1,61,23,241,13,2,22,80,0,34,55,0,0,34,127,5,0,
0,58,63,6,236,3,130,0,221,49,111,0,10,216,224,217,178,5,128,7,
254,0,25,216,27,48,31,58,190,255,176,75,224,81,186,253,60,55,13,0,
102,7,0,0,190,255,56,65,61,54,184,0,0,58,128,255,180,18,99,87,
85,0,10,104,61,87,241,0,1,90,13,96,42,23,105,0,108,95,0,0,
2,22,112,1,34,55,0,0,202,49,34,87,5,0,63,6,78,4,130,0,
35,62,84,0,124,111,13,0,106,0,25,48,10,216,224,217,146,21,60,127,
13,0,111,7,0,0,190,255,86,75,224,81,226,69,26,48,32,62,255,0,
0,66,190,255,90,1,224,81,229,61,190,255,62,75,224,81,242,5,26,48,
32,62,255,0,0,66,190,255,66,1,22,64,23,72,38,6,164,196,133,0,
128,255,114,182,61,55,241,0,190,255,204,171,10,64,32,54,54,0,37,62,
24,135,190,255,238,2,61,54,184,0,3,56,31,66,128,255,206,121,35,119,
1,0,224,113,146,13,38,6,136,196,133,0,32,62,51,8,0,66,190,255,
250,0,61,23,241,13,2,22,80,0,34,55,0,0,34,111,5,0,0,58,
63,6,238,4,130,0,221,49,109,0,10,216,29,48,0,58,191,255,132,220,
27,80,120,6,255,115,190,7,225,243,92,26,99,63,17,0,99,7,116,0,
99,7,122,0,6,232,99,71,109,0,99,79,113,0,61,151,241,0,99,7,
101,0,35,134,20,0,99,135,105,0,99,151,13,0,50,151,8,0,0,226,
0,218,0,194,99,151,13,0,29,200,57,190,28,0,54,6,8,215,255,255,
128,7,146,2,29,48,0,58,191,255,40,220,27,6,254,253,234,5,29,48,
32,62,232,3,191,255,190,220,22,48,31,58,190,255,68,74,224,81,186,253,
23,62,32,0,1,50,31,66,128,255,90,17,55,55,33,0,0,58,35,70,
20,0,1,74,190,255,172,63,61,54,184,0,28,56,128,255,56,17,99,87,
101,0,10,104,61,87,241,0,13,96,121,111,13,0,35,71,17,0,42,23,
105,0,1,146,108,151,0,0,99,199,118,0,2,22,128,1,34,55,0,0,
34,95,5,0,35,62,100,0,1,74,202,49,63,6,212,5,130,0,107,0,
119,87,1,0,28,80,194,82,57,118,28,0,206,81,42,23,1,0,22,48,
224,17,234,21,57,111,13,0,109,23,0,0,190,255,192,73,224,81,186,5,
128,7,234,1,38,6,220,196,133,0,32,62,255,0,0,66,189,255,188,255,
224,81,128,7,212,1,190,255,158,73,224,81,146,13,38,6,220,196,133,0,
32,62,255,0,0,66,189,255,158,255,61,54,184,0,3,56,31,66,128,255,
78,120,35,103,1,0,236,225,146,13,38,6,204,196,133,0,32,62,34,7,
0,66,189,255,122,255,61,23,241,13,2,22,80,0,34,55,0,0,34,95,
5,0,28,56,63,6,110,6,130,0,221,49,107,0,10,216,189,87,5,1,
224,81,178,5,128,7,110,1,224,217,186,5,128,7,88,1,27,6,254,253,
178,5,128,7,92,1,61,55,241,0,190,255,214,169,10,208,26,48,190,255,
222,169,224,81,186,13,197,210,32,94,164,180,203,209,186,87,29,0,224,81,
186,5,128,7,38,1,131,127,165,0,224,121,178,5,128,7,26,1,22,216,
27,48,31,58,190,255,228,72,224,81,186,253,57,55,13,0,102,7,0,0,
190,255,108,62,61,54,184,0,28,56,128,255,232,15,99,87,101,0,10,112,
61,87,241,0,14,104,1,146,42,23,105,0,109,151,0,0,121,119,13,0,
35,71,17,0,2,22,136,1,34,55,0,0,34,103,5,0,35,62,100,0,
63,6,30,7,130,0,202,49,108,0,22,48,10,216,224,217,162,21,57,87,
13,0,106,7,0,0,190,255,134,72,224,81,146,77,38,6,220,196,133,0,
32,62,255,0,0,66,189,255,134,254,133,69,190,255,108,72,224,81,146,13,
38,6,220,196,133,0,32,62,255,0,0,66,189,255,108,254,35,63,17,0,
38,6,232,196,133,0,24,64,128,255,154,179,35,71,17,0,37,62,32,135,
32,54,44,0,190,255,28,0,61,54,184,0,3,56,31,66,128,255,252,118,
35,135,1,0,240,225,146,13,38,6,204,196,133,0,32,62,102,7,0,66,
189,255,40,254,61,23,241,13,2,22,80,0,34,55,0,0,34,127,5,0,
28,56,63,6,192,7,130,0,221,49,111,0,10,216,224,217,154,21,29,48,
28,56,191,255,174,217,29,48,32,62,232,3,191,255,74,218,65,194,35,143,
13,0,241,193,190,5,191,7,106,253,29,48,28,56,191,255,142,217,27,80,
68,26,126,6,255,243,138,7,225,240,6,208,8,224,28,48,7,192,35,62,
2,0,35,70,3,0,190,255,250,235,3,79,2,0,0,202,10,64,224,73,
162,125,4,135,232,135,224,129,234,117,59,6,8,215,255,255,28,56,38,6,
16,197,133,0,128,255,214,178,27,232,29,48,31,58,190,255,114,71,224,81,
186,253,24,232,252,239,72,2,58,54,184,0,24,56,218,233,128,255,122,14,
125,87,13,0,1,90,3,71,2,0,106,95,0,0,10,48,28,56,191,255,
106,6,3,23,2,0,3,130,1,138,106,143,0,0,99,135,8,0,2,126,
64,0,99,127,10,0,99,7,13,0,67,7,16,0,32,118,239,0,67,119,
17,0,8,106,99,111,18,0,28,48,10,56,35,70,8,0,0,74,191,255,
38,6,27,48,190,255,12,71,224,81,146,13,38,6,60,197,133,0,32,62,
255,0,0,66,189,255,12,253,58,54,184,0,35,62,4,0,31,66,128,255,
186,117,27,224,28,48,31,58,190,255,216,70,224,81,186,253,61,55,13,0,
38,207,12,0,102,7,0,0,190,255,92,60,125,7,13,0,27,48,190,255,
194,70,224,81,162,13,38,6,60,197,133,0,32,62,255,0,0,66,189,255,
194,252,224,81,25,80,74,6,255,240,188,7,225,243,99,63,65,0,252,63,
72,2,99,71,77,0,6,208,218,57,99,63,17,0,7,87,4,0,103,82,
178,5,128,7,108,5,99,7,28,0,99,7,30,0,99,7,22,0,99,7,
32,0,99,7,34,0,99,7,44,0,26,48,191,255,88,227,58,111,241,0,
99,7,114,0,99,7,108,0,35,103,17,0,45,111,8,0,99,7,97,0,
99,7,93,0,99,111,110,0,44,199,17,0,44,239,25,0,44,231,21,0,
122,199,29,1,44,207,13,0,35,143,77,0,249,207,19,0,113,207,1,0,
58,23,241,13,35,63,65,0,2,22,80,0,34,55,0,0,34,95,5,0,
63,6,178,9,130,0,218,49,107,0,99,87,46,0,0,218,26,48,27,56,
191,255,188,215,65,218,98,218,166,253,35,87,46,0,224,81,226,21,36,71,
245,178,58,62,40,1,10,72,38,6,112,197,133,0,128,255,40,177,35,143,
17,0,49,71,21,0,49,79,25,0,38,6,72,197,133,0,128,255,18,177,
58,55,241,0,99,7,25,0,190,255,104,166,99,87,73,0,10,6,240,255,
153,13,38,6,96,197,133,0,32,62,48,5,0,66,189,255,174,251,31,146,
99,151,69,0,0,18,1,82,25,184,247,0,10,96,226,103,192,0,87,97,
204,0,224,97,194,5,99,23,69,0,213,5,65,18,2,6,240,255,150,245,
35,23,46,0,2,6,0,254,161,13,224,17,210,21,2,6,143,254,186,5,
128,7,10,1,128,7,122,1,2,6,0,254,194,21,2,6,254,253,130,53,
2,6,252,253,186,5,128,7,46,1,128,7,96,1,2,50,128,255,124,128,
26,48,191,255,184,215,0,82,128,7,18,4,227,135,31,0,16,150,1,0,
99,151,30,0,100,130,179,5,128,7,74,1,0,218,1,202,25,112,251,119,
192,0,87,113,206,0,224,113,242,5,35,63,65,0,27,64,26,48,191,255,
56,253,65,218,27,6,240,255,134,245,128,7,58,1,26,48,32,62,220,5,
191,255,74,215,227,95,23,0,11,150,1,0,99,151,22,0,106,90,147,21,
35,71,69,0,35,79,73,0,32,54,38,0,39,6,152,197,133,0,189,255,
158,252,1,146,99,151,25,0,128,7,0,1,210,86,255,255,97,82,179,125,
227,135,23,0,0,202,98,130,226,151,0,0,99,151,41,0,1,114,249,119,
192,0,87,113,206,0,224,113,130,29,0,218,35,183,41,0,165,21,26,48,
25,56,27,96,191,98,27,64,220,65,225,79,0,0,204,73,221,73,99,183,
1,0,191,255,176,249,224,81,202,5,65,218,248,217,230,237,65,202,25,6,
240,255,246,221,133,85,227,87,35,0,10,150,1,0,99,151,34,0,98,82,
211,5,1,146,99,151,25,0,197,69,0,218,245,13,26,48,27,80,191,82,
27,64,220,65,225,79,0,0,202,73,221,73,191,255,226,246,224,81,218,53,
65,218,248,217,150,245,149,53,227,135,33,0,16,150,1,0,99,151,32,0,
106,130,227,13,35,71,69,0,35,79,73,0,9,50,39,6,152,197,133,0,
189,255,212,251,1,146,99,151,25,0,26,48,32,62,220,5,191,255,74,214,
229,21,227,127,45,0,15,150,1,0,99,151,44,0,100,122,227,13,35,71,
69,0,35,79,73,0,10,50,39,6,152,197,133,0,189,255,158,251,1,146,
99,151,25,0,186,119,5,1,224,113,194,5,0,82,128,7,144,2,35,151,
25,0,97,146,250,117,61,6,8,215,255,255,29,48,31,58,190,255,136,67,
224,81,186,253,58,23,241,0,2,23,7,0,123,18,226,69,119,18,162,69,
2,6,33,0,210,5,2,6,81,0,226,69,213,77,0,234,1,226,58,87,
241,0,42,23,105,0,29,64,2,22,184,0,34,63,0,0,34,111,5,0,
35,54,8,0,63,6,114,12,130,0,202,57,109,0,35,23,9,0,194,102,
1,0,194,29,221,18,159,18,146,29,35,135,77,0,28,16,48,135,1,0,
253,23,192,0,226,129,130,21,35,143,77,0,113,23,1,0,35,79,69,0,
35,71,73,0,39,6,172,197,133,0,32,54,45,0,189,255,234,250,65,234,
29,6,240,255,182,205,4,50,213,13,14,50,181,13,35,127,46,0,15,6,
254,253,194,13,32,54,42,0,181,5,32,54,52,0,35,71,73,0,37,62,
40,135,189,255,186,250,38,6,8,215,255,255,190,255,204,66,224,81,146,13,
38,6,192,197,133,0,32,62,255,0,0,66,189,255,204,248,7,82,128,7,
156,1,26,48,32,62,144,1,191,255,18,213,57,6,8,215,255,255,25,48,
31,58,190,255,146,66,10,216,224,217,170,253,227,119,29,0,1,202,224,113,
226,183,0,0,25,96,251,103,192,0,87,97,204,0,224,97,130,13,224,177,
234,5,58,55,241,0,27,56,128,255,154,9,65,218,27,6,240,255,246,237,
38,6,8,215,255,255,190,255,90,66,224,81,146,13,38,6,192,197,133,0,
32,62,255,0,0,66,189,255,90,248,35,143,17,0,113,199,17,0,35,143,
17,0,81,7,4,0,35,143,17,0,1,146,113,151,9,0,35,151,65,0,
58,54,184,0,35,62,4,0,18,134,1,0,208,22,1,0,252,23,72,2,
99,151,5,0,31,66,218,17,66,7,4,0,128,255,244,115,58,54,184,0,
35,62,4,0,31,66,128,255,198,112,35,151,65,0,35,103,5,0,236,145,
146,13,38,6,96,197,133,0,32,62,32,6,0,66,189,255,238,247,99,231,
81,0,99,239,85,0,26,48,35,71,5,0,35,78,80,0,99,79,1,0,
35,62,92,0,191,255,200,218,10,216,102,82,178,5,101,218,202,69,58,54,
184,0,35,62,4,0,0,66,128,255,116,112,60,6,8,215,255,255,28,48,
31,58,190,255,142,65,10,232,224,233,170,253,58,87,241,0,42,23,105,0,
29,64,2,22,184,0,34,63,0,0,34,127,5,0,35,54,12,0,63,6,
76,14,130,0,202,57,111,0,195,199,12,0,226,5,58,55,241,0,29,56,
128,255,146,8,65,234,29,6,240,255,182,229,38,6,8,215,255,255,190,255,
74,65,224,81,146,13,38,6,192,197,133,0,32,62,255,0,0,66,189,255,
74,247,26,48,191,255,186,211,27,80,165,13,103,218,186,149,227,151,29,0,
65,146,99,151,28,0,191,7,180,250,124,6,255,243,252,63,72,2,198,57,
39,23,13,0,0,82,224,17,178,5,34,87,12,0,127,0,168,7,225,243,
8,208,252,215,72,2,6,192,7,232,216,209,125,31,5,0,56,54,184,0,
8,56,128,255,248,7,125,87,1,0,122,87,13,0,61,191,13,0,61,183,
9,0,0,202,0,226,58,222,60,0,229,53,59,55,1,0,61,71,5,0,
61,79,18,0,0,58,190,255,54,54,100,82,151,13,38,6,204,197,133,0,
32,62,56,4,0,66,189,255,182,246,56,87,241,0,42,23,105,0,2,22,
112,1,34,55,0,0,34,95,5,0,29,56,63,6,54,15,130,0,202,49,
107,0,224,81,170,5,65,202,61,103,9,0,61,111,13,0,12,86,1,0,
125,87,9,0,225,23,0,0,205,17,125,23,13,0,68,218,65,226,58,135,
17,0,240,225,134,205,125,183,9,0,125,191,13,0,61,255,1,0,229,87,
64,0,224,7,96,1,63,239,0,0,10,224,217,233,127,239,0,0,252,47,
32,0,224,233,138,13,31,48,63,127,5,0,63,6,152,15,130,0,111,0,
104,6,255,243,168,7,225,243,8,208,252,215,72,2,6,192,7,232,216,209,
125,31,5,0,56,54,184,0,8,56,128,255,20,7,125,87,1,0,122,87,
13,0,61,191,13,0,61,183,9,0,0,202,0,218,58,230,28,0,245,53,
60,55,33,0,61,71,5,0,61,79,18,0,0,58,190,255,82,53,100,82,
151,13,38,6,220,197,133,0,32,62,238,3,0,66,189,255,210,245,56,87,
241,0,42,23,105,0,29,56,2,22,104,1,34,55,0,0,34,95,5,0,
1,66,63,6,28,16,130,0,202,49,107,0,124,87,1,0,61,103,9,0,
65,202,61,111,13,0,12,86,1,0,125,87,9,0,225,23,0,0,205,17,
125,23,13,0,68,226,65,218,58,87,17,0,234,217,246,197,125,183,9,0,
125,191,13,0,61,255,1,0,229,87,64,0,224,7,96,1,63,239,0,0,
10,224,217,233,127,239,0,0,252,47,32,0,224,233,138,13,31,48,63,135,
5,0,63,6,126,16,130,0,112,0,104,6,255,243,170,7,225,240,8,192,
24,224,252,231,72,2,6,200,57,54,184,0,217,225,7,232,24,56,128,255,
48,6,125,87,1,0,124,87,13,0,32,118,17,0,125,119,25,0,0,218,
60,214,60,0,165,29,61,55,18,0,0,66,26,56,128,255,20,6,224,81,
138,21,25,48,24,56,191,255,174,208,99,199,1,0,57,54,184,0,3,56,
31,66,128,255,202,112,32,86,112,1,229,69,68,210,65,218,60,103,17,0,
236,217,198,229,35,94,4,0,125,95,5,0,0,218,60,214,60,0,181,29,
58,55,1,0,61,79,18,0,35,70,4,0,0,58,190,255,38,52,100,82,
151,13,38,6,236,197,133,0,32,62,170,3,0,66,189,255,166,244,29,64,
12,50,12,58,190,255,16,52,68,210,65,218,60,23,17,0,226,217,182,229,
61,255,1,0,2,224,229,87,64,0,224,7,96,1,63,239,0,0,220,233,
127,239,0,0,10,224,252,47,32,0,224,233,138,13,31,48,63,143,5,0,
63,6,108,17,130,0,113,0,0,82,106,6,255,240,128,7,33,0,6,80,
42,23,241,13,2,22,16,0,34,55,0,0,34,143,5,0,63,6,146,17,
130,0,202,49,113,0,64,6,63,0,128,7,97,0,0,234,29,48,128,255,
84,5,65,234,29,6,240,255,166,253,64,6,127,0,128,7,65,0,229,87,
64,0,224,7,96,1,36,143,65,137,10,232,95,138,100,143,65,137,224,137,
223,5,100,7,65,137,100,7,61,137,253,47,32,0,64,6,95,0,128,7,
33,0,229,87,64,0,224,7,96,1,36,135,65,137,10,248,1,138,100,143,
61,137,65,130,100,135,65,137,255,47,32,0,191,255,154,255,36,127,53,137,
224,121,154,13,32,54,22,0,128,255,240,120,36,119,53,137,224,113,210,5,
2,50,128,255,226,120,245,237,64,6,63,0,134,7,225,243,36,23,61,137,
224,17,178,5,128,7,70,2,64,150,255,255,82,233,194,134,255,255,16,233,
0,226,28,48,35,62,8,0,35,70,4,0,128,255,174,4,224,81,170,13,
35,119,4,0,64,150,255,255,29,113,82,233,206,102,255,255,12,233,65,226,
28,6,240,255,182,237,29,208,220,210,159,210,29,200,221,202,159,202,29,224,
219,226,159,226,4,87,83,143,29,216,218,218,159,218,224,81,186,5,128,7,
54,1,224,209,250,5,224,201,218,5,224,217,186,5,128,7,38,1,98,82,
146,13,38,6,100,213,152,0,7,58,191,255,108,239,224,81,146,93,224,225,
186,5,224,217,242,45,36,143,53,137,224,137,178,45,0,234,224,225,226,231,
0,0,224,209,226,199,0,0,224,217,226,191,0,0,224,201,226,183,0,0,
224,225,234,5,29,48,0,58,27,66,191,255,146,105,224,185,138,21,224,177,
250,5,29,48,0,58,32,70,223,255,191,255,126,105,224,193,234,5,29,48,
0,58,23,66,191,255,112,105,65,234,29,6,240,255,214,229,0,226,1,130,
100,135,89,143,0,234,224,217,226,223,0,0,224,209,226,215,0,0,224,201,
226,207,0,0,224,217,202,5,32,70,175,255,197,13,224,201,250,5,29,48,
1,58,32,70,223,255,191,255,50,105,224,209,234,5,23,66,29,48,1,58,
191,255,36,105,65,234,29,6,240,255,150,237,133,53,36,127,53,137,224,121,
167,45,36,119,89,143,97,114,234,37,0,234,224,201,226,207,0,0,224,209,
226,215,0,0,224,217,226,223,0,0,224,201,250,5,29,48,0,58,32,70,
223,255,191,255,230,104,224,217,250,5,29,48,0,58,32,70,175,255,191,255,
214,104,224,209,234,5,29,48,0,58,23,66,191,255,200,104,65,234,29,6,
240,255,230,229,100,7,89,143,4,103,84,143,224,97,226,85,98,98,146,13,
38,6,128,213,152,0,7,58,191,255,66,238,224,81,226,53,1,90,100,95,
93,143,224,225,194,13,0,234,29,48,1,58,27,66,191,255,138,104,65,234,
29,6,240,255,134,253,197,61,35,54,3,0,35,62,8,0,128,255,166,50,
36,87,53,137,224,81,170,53,4,143,44,137,3,23,3,0,226,137,194,45,
68,23,44,137,0,234,32,230,164,180,156,127,29,0,224,121,226,5,29,48,
27,58,31,66,191,255,164,104,28,230,32,0,65,234,29,6,240,255,166,245,
245,21,224,225,210,21,36,119,53,137,224,113,247,13,36,111,93,143,97,106,
186,13,0,234,29,48,0,58,27,66,191,255,22,104,65,234,29,6,240,255,
134,253,100,7,93,143,70,6,255,243,100,7,53,137,100,7,49,137,32,142,
200,0,68,143,80,143,68,143,81,143,100,7,89,143,100,7,93,143,2,122,
68,127,83,143,68,127,84,143,0,18,42,6,128,213,152,0,46,6,100,213,
152,0,32,134,160,5,7,98,2,88,236,95,128,106,49,6,128,81,1,0,
237,143,32,2,32,126,60,0,79,136,65,18,110,135,2,0,106,135,2,0,
110,143,0,0,106,143,0,0,68,82,68,114,103,18,134,237,127,0,140,7,
225,0,6,232,7,224,229,87,64,0,224,7,96,1,36,143,49,137,10,248,
65,138,209,142,15,0,100,143,49,137,255,47,32,0,29,127,73,1,224,121,
218,101,29,119,72,1,224,113,154,101,60,23,8,0,32,110,128,0,125,231,
241,0,226,111,192,2,125,111,33,1,224,105,207,5,1,82,125,87,33,1,
32,134,0,2,226,135,192,2,61,143,33,1,104,130,125,135,37,1,125,143,
29,1,199,5,8,106,125,111,37,1,61,103,37,1,224,97,207,5,1,90,
125,95,37,1,61,78,228,1,61,54,184,0,61,62,40,1,8,82,99,87,
1,0,1,66,128,255,224,111,224,81,202,37,1,138,93,143,73,1,61,54,
76,1,61,62,40,1,40,6,114,17,130,0,29,72,61,134,236,1,99,135,
1,0,32,126,0,12,99,127,5,0,99,7,9,0,9,114,99,119,13,0,
99,7,17,0,99,143,21,0,128,255,84,118,224,81,202,5,1,98,93,103,
72,1,29,95,73,1,97,90,250,5,29,87,72,1,97,82,186,5,0,82,
181,5,32,86,112,1,76,6,255,0,128,7,225,0,6,232,7,224,224,233,
146,13,0,58,191,255,180,222,129,226,201,5,29,48,128,255,30,145,64,6,
255,0,128,7,225,0,6,232,7,224,224,233,146,13,0,58,191,255,148,222,
129,226,201,5,29,48,128,255,254,144,64,6,255,0,128,7,225,0,6,232,
7,224,224,233,146,13,0,58,191,255,116,222,129,226,201,5,29,48,128,255,
222,144,64,6,255,0,128,7,225,0,6,232,7,224,224,233,146,13,0,58,
191,255,84,222,129,226,201,5,29,48,128,255,190,144,64,6,255,0,128,7,
225,0,6,232,7,224,224,233,146,13,0,58,191,255,52,222,129,226,201,5,
29,48,128,255,158,144,64,6,255,0,128,7,33,0,38,6,8,215,255,255,
190,255,40,57,224,81,162,13,38,6,28,193,133,0,32,62,255,0,0,66,
189,255,40,239,224,81,64,6,63,0,128,7,33,0,38,6,8,215,255,255,
190,255,248,56,224,81,226,87,0,0,64,6,63,0,33,6,112,124,0,0,
97,0,33,6,52,52,1,0,97,0,33,6,104,34,0,0,97,0,33,6,
108,132,0,0,97,0,33,6,26,132,0,0,97,0,33,6,240,131,0,0,
97,0,33,6,118,153,1,0,97,0,33,6,110,142,1,0,97,0,130,7,
225,48,6,216,0,210,27,6,240,255,129,13,27,128,197,130,32,110,164,180,
205,129,48,215,5,0,224,209,162,61,0,234,60,6,156,213,152,0,149,53,
58,23,105,0,29,64,2,22,184,0,34,63,0,0,34,103,5,0,3,48,
63,6,74,23,130,0,218,57,108,0,35,23,1,0,129,18,185,29,156,87,
17,0,224,81,242,21,27,56,29,64,38,6,108,198,133,0,128,255,162,163,
27,48,0,58,190,255,36,143,92,7,16,0,27,64,29,72,32,54,252,0,
39,6,88,198,133,0,189,255,22,240,28,230,20,0,65,234,4,143,233,135,
241,233,214,205,66,6,255,48,128,7,193,48,7,232,125,7,1,0,38,63,
52,1,0,74,38,22,56,1,0,82,31,90,181,13,2,143,0,0,224,137,
202,5,66,95,3,0,65,74,65,82,2,22,20,0,231,81,214,245,49,6,
156,213,152,0,0,66,1,226,4,223,233,135,5,210,133,45,17,135,0,0,
100,130,154,37,0,82,38,22,56,1,149,21,2,127,0,0,224,121,170,13,
49,111,5,0,2,119,4,0,237,113,202,5,66,71,3,0,95,74,65,82,
2,22,20,0,231,81,246,237,61,95,1,0,81,215,0,0,28,96,232,103,
192,0,12,89,125,95,1,0,65,66,17,142,20,0,251,65,134,221,224,73,
226,87,0,0,64,6,223,48,128,7,97,0,0,234,230,22,20,0,0,98,
42,6,156,213,152,0,202,17,4,111,233,135,149,21,2,80,10,135,0,0,
100,130,154,13,42,95,13,0,43,87,5,0,234,97,185,5,10,96,11,232,
2,22,20,0,65,50,237,49,246,237,224,97,154,13,38,6,176,198,133,0,
32,62,191,3,0,66,189,255,66,237,29,80,64,6,127,0,144,7,225,243,
6,184,247,158,20,0,54,6,156,213,152,0,22,16,19,72,194,73,41,87,
9,0,7,216,42,70,48,0,40,135,1,0,42,62,24,3,99,159,9,0,
0,210,224,129,170,13,23,56,38,6,192,198,133,0,128,255,60,162,0,82,
128,7,200,2,4,127,233,135,239,206,20,0,1,194,4,226,99,207,13,0,
194,201,229,117,9,119,0,0,99,114,250,109,1,106,230,111,192,0,27,88,
77,89,146,109,41,23,9,0,34,238,24,3,34,254,48,0,63,87,1,0,
40,23,1,0,234,17,186,29,40,135,5,0,63,143,5,0,241,129,218,21,
40,86,8,0,63,94,8,0,224,17,210,13,65,82,65,90,171,119,255,255,
170,127,255,255,174,121,186,5,95,18,250,245,224,121,186,5,73,231,0,0,
61,111,1,0,39,23,1,0,237,17,186,29,39,95,5,0,61,103,5,0,
236,89,218,21,39,94,8,0,61,102,8,0,224,17,210,13,65,90,65,98,
172,143,255,255,171,87,255,255,177,81,186,5,95,18,250,245,224,81,186,5,
73,231,0,0,9,135,0,0,100,130,250,29,224,209,218,29,63,127,1,0,
61,23,1,0,226,121,186,21,63,86,8,0,61,94,8,0,224,17,146,21,
65,82,65,90,171,111,255,255,170,119,255,255,173,113,186,5,95,18,250,245,
224,113,210,5,41,215,9,0,73,199,16,0,9,78,20,0,65,50,249,73,
161,141,224,209,242,101,23,48,35,79,9,0,35,239,13,0,58,62,24,3,
58,70,48,0,214,73,214,233,4,250,133,93,9,103,0,0,99,98,154,85,
1,90,230,95,192,0,27,136,75,137,178,77,41,135,9,0,39,95,1,0,
48,22,24,3,34,127,1,0,239,89,202,29,39,111,5,0,34,119,5,0,
238,105,234,21,39,86,8,0,34,110,8,0,11,16,224,17,210,13,65,82,
65,106,173,95,255,255,170,103,255,255,171,97,186,5,95,18,250,245,224,97,
186,5,73,255,0,0,41,87,9,0,40,103,1,0,42,22,48,0,34,143,
1,0,241,97,202,29,40,127,5,0,34,135,5,0,240,121,234,21,40,86,
8,0,34,94,8,0,12,16,224,17,210,13,65,82,65,90,171,111,255,255,
170,119,255,255,173,113,186,5,95,18,250,245,224,113,186,5,73,255,0,0,
9,78,20,0,65,50,253,73,129,173,0,18,35,86,16,0,31,90,74,95,
0,0,65,82,65,18,2,6,240,255,166,253,23,232,32,190,96,2,35,231,
9,0,22,192,32,222,96,2,253,223,32,2,216,225,57,6,88,49,141,0,
217,217,165,93,28,87,0,0,100,82,154,85,4,143,69,137,131,138,201,13,
50,6,88,93,134,0,50,71,1,0,38,6,236,198,133,0,29,56,128,255,
8,160,156,119,17,0,224,113,242,5,29,56,38,6,252,198,133,0,128,255,
244,159,60,23,5,0,35,110,16,0,205,17,2,87,0,0,127,82,202,5,
66,239,0,0,197,45,10,16,23,88,226,95,32,2,59,87,73,0,217,89,
43,95,73,0,235,81,233,5,29,56,10,112,2,72,11,80,197,5,29,72,
2,56,11,112,231,126,20,0,6,106,4,103,69,137,216,121,79,111,0,0,
131,98,249,13,50,6,96,93,134,0,50,71,1,0,99,119,1,0,99,87,
5,0,38,6,40,199,133,0,128,255,134,159,28,230,20,0,27,222,96,2,
65,234,4,143,233,135,241,233,198,165,26,80,80,6,255,243,168,7,225,243,
6,192,67,63,43,0,0,186,38,6,116,199,133,0,128,255,88,159,54,6,
228,199,133,0,0,226,58,6,156,213,152,0,1,202,128,7,98,1,25,216,
252,223,192,0,24,128,91,129,186,5,128,7,80,1,4,127,69,137,130,122,
217,21,252,94,20,0,218,89,11,135,0,0,224,129,226,13,194,130,45,6,
72,93,134,0,205,129,48,71,1,0,38,6,164,199,133,0,28,56,128,255,
4,159,252,238,20,0,218,233,29,143,0,0,97,138,218,45,15,138,67,143,
61,0,32,134,31,0,67,135,65,0,67,7,60,0,67,7,64,0,67,7,
62,0,67,231,63,0,99,7,69,0,28,48,190,255,52,216,132,127,69,137,
99,87,73,0,224,121,130,21,163,63,43,0,35,54,60,0,191,255,12,96,
127,82,130,13,5,106,93,111,0,0,25,96,234,103,192,0,12,185,59,88,
75,193,197,93,99,138,178,5,103,138,138,93,32,54,0,18,128,255,30,137,
125,87,13,0,224,81,250,5,22,48,32,62,17,3,0,66,189,255,60,233,
61,55,13,0,32,70,0,18,0,58,189,255,76,229,32,54,0,6,128,255,
244,136,125,87,9,0,224,81,250,5,22,48,32,62,21,3,0,66,189,255,
18,233,61,55,9,0,32,70,0,6,0,58,189,255,34,229,32,222,96,2,
252,223,32,2,43,6,88,49,141,0,61,63,9,0,203,217,27,48,190,255,
84,109,61,63,13,0,27,48,99,87,54,0,190,255,226,107,10,136,35,87,
54,0,224,81,186,5,224,137,194,13,2,130,93,135,0,0,28,48,32,62,
221,0,0,66,190,255,128,219,95,226,133,13,59,127,53,0,3,114,93,119,
0,0,125,127,5,0,65,226,4,111,233,135,237,225,190,5,191,7,154,254,
38,6,244,199,133,0,128,255,208,157,0,210,57,6,156,213,152,0,51,6,
156,213,152,0,99,159,53,0,51,6,72,93,134,0,99,159,57,0,128,7,
164,1,1,98,250,103,192,0,24,88,76,89,186,5,128,7,142,1,25,87,
0,0,99,82,146,13,4,143,69,137,131,138,177,5,128,7,122,1,128,7,
86,1,26,48,24,56,191,255,10,251,224,81,194,5,42,238,48,0,213,5,
57,119,9,0,46,238,48,0,26,48,191,255,154,250,10,216,27,48,35,62,
44,0,191,255,238,249,27,111,57,1,108,106,130,117,163,71,43,0,29,56,
59,54,56,1,128,255,124,6,10,48,127,50,154,117,35,63,45,0,38,6,
28,200,133,0,128,255,50,157,0,18,35,95,53,0,4,103,233,135,35,111,
45,0,1,114,7,122,197,13,14,80,226,87,192,0,13,136,74,137,178,5,
75,127,0,0,11,94,20,0,65,18,236,17,198,245,59,63,52,1,38,6,
180,199,133,0,128,255,246,156,59,238,56,1,0,226,133,61,29,111,2,0,
29,71,0,0,29,79,1,0,99,111,1,0,29,103,3,0,99,103,5,0,
29,95,4,0,99,95,9,0,29,87,5,0,99,87,13,0,61,143,6,0,
209,138,177,138,99,143,17,0,61,135,9,0,99,135,21,0,61,127,13,0,
99,127,25,0,61,23,16,0,99,23,29,0,29,23,18,0,99,23,33,0,
29,23,19,0,28,56,38,6,76,200,133,0,99,23,37,0,128,255,134,156,
65,226,29,238,20,0,59,119,52,1,238,225,230,197,213,29,4,111,69,137,
131,106,153,29,26,56,38,6,92,199,133,0,128,255,98,156,165,21,251,63,
49,1,1,82,230,87,192,0,10,185,128,255,142,5,224,81,130,13,22,48,
32,62,137,3,0,66,189,255,2,231,224,81,4,127,69,137,131,122,153,21,
25,95,0,0,224,89,210,13,35,151,57,0,194,90,210,89,43,71,1,0,
38,6,164,199,133,0,26,56,128,255,22,156,25,206,20,0,65,210,4,135,
233,135,240,209,190,5,191,7,88,254,128,255,70,5,23,81,104,6,255,243,
132,7,33,0,36,135,97,143,36,143,245,178,36,127,125,136,176,137,15,22,
84,11,177,17,244,13,99,23,1,0,38,6,56,193,141,0,128,62,255,255,
1,66,35,78,4,0,190,255,146,7,224,81,178,5,0,82,181,5,35,87,
5,0,68,6,63,0,128,7,225,0,61,6,156,213,152,0,0,226,61,55,
13,0,224,49,210,5,128,255,178,135,125,7,13,0,61,55,9,0,224,49,
210,5,128,255,162,135,125,7,9,0,65,226,29,238,20,0,28,6,240,255,
182,237,64,6,255,0,128,7,225,16,6,216,0,234,1,226,28,128,253,135,
192,0,91,129,194,5,29,48,190,255,114,213,65,234,29,6,240,255,214,245,
64,6,255,16,128,7,225,112,6,216,0,234,60,6,156,213,152,0,1,210,
26,128,253,135,192,0,91,129,178,21,29,48,190,255,170,211,10,6,240,255,
217,13,29,48,190,255,58,211,224,81,130,13,28,127,0,0,101,122,202,5,
3,114,92,119,0,0,28,230,20,0,65,234,29,6,224,255,198,229,219,54,
255,255,0,58,191,255,152,251,10,224,0,210,190,255,32,37,10,216,123,7,
9,0,44,6,98,46,1,0,123,103,5,0,43,6,56,193,141,0,123,95,
29,0,123,231,33,0,32,86,32,3,123,87,21,0,219,7,3,0,219,31,
3,0,57,6,212,221,136,0,0,234,197,93,220,142,1,0,242,85,29,48,
190,255,90,120,29,48,128,255,254,3,29,48,31,58,190,255,176,131,29,48,
191,255,158,246,27,48,29,56,190,255,180,127,202,209,29,56,38,6,32,201,
133,0,128,255,140,154,29,56,135,0,25,48,190,255,128,29,224,81,210,53,
29,48,190,255,154,27,224,81,130,53,29,56,38,6,52,201,133,0,128,255,
104,154,64,126,137,0,15,127,228,221,102,122,146,13,38,6,108,201,133,0,
32,62,18,2,0,66,189,255,14,229,29,48,134,0,190,255,110,27,10,72,
29,64,224,73,146,13,32,54,95,0,39,6,220,200,133,0,189,255,192,230,
245,5,32,54,94,0,37,62,52,135,189,255,178,230,29,56,135,0,25,48,
190,255,90,28,29,48,191,255,126,91,65,234,129,226,224,225,202,165,128,255,
90,3,27,48,26,56,190,255,114,46,27,48,190,255,80,143,10,232,123,7,
0,0,27,48,190,255,40,36,224,233,242,5,29,56,38,6,124,201,133,0,
128,255,218,153,224,209,178,13,26,112,159,114,26,56,206,57,161,58,38,6,
240,200,133,0,128,255,194,153,191,255,10,254,64,6,255,112,3,30,236,255,
49,6,176,201,133,0,49,127,1,0,99,127,1,0,49,119,5,0,99,119,
5,0,49,111,9,0,99,111,9,0,49,103,13,0,230,110,20,0,47,6,
156,213,152,0,99,103,13,0,49,95,17,0,35,103,1,0,207,105,99,95,
17,0,109,103,1,0,35,95,5,0,109,95,5,0,35,87,9,0,109,87,
9,0,35,143,13,0,109,143,13,0,35,127,17,0,109,127,17,0,3,30,
20,0,127,0,136,7,225,243,198,158,255,255,196,223,96,144,99,159,13,0,
130,13,38,6,196,201,133,0,128,255,50,153,128,7,90,1,38,6,244,201,
133,0,128,255,36,153,0,234,60,6,184,189,141,0,1,218,35,151,13,0,
27,128,253,135,192,0,82,129,242,5,28,48,190,255,108,235,29,48,191,255,
74,255,28,230,56,0,65,234,29,6,240,255,230,237,36,127,245,178,35,207,
13,0,128,158,255,255,99,159,5,0,100,127,97,143,25,176,35,151,5,0,
0,186,61,6,156,213,152,0,59,6,184,189,141,0,50,112,78,201,58,6,
88,49,141,0,35,111,13,0,1,226,247,231,192,0,28,192,88,105,146,61,
27,48,190,255,222,214,35,151,5,0,82,225,162,53,24,80,86,81,178,21,
27,48,190,255,122,234,224,81,186,21,27,135,52,0,16,6,217,255,218,37,
26,48,190,255,26,120,224,81,130,37,24,201,56,177,213,29,26,48,190,255,
156,124,224,81,178,5,24,201,229,21,29,119,0,0,101,114,162,21,26,23,
92,2,97,18,177,5,226,5,149,13,1,154,93,159,0,0,133,13,3,106,
93,111,0,0,197,5,2,98,93,103,0,0,29,238,20,0,27,222,56,0,
26,214,96,2,65,186,23,6,240,255,246,181,1,50,128,255,30,104,224,201,
242,5,191,255,42,252,99,87,5,0,224,81,234,157,61,6,184,189,141,0,
60,6,88,49,141,0,197,21,217,94,1,0,178,13,214,86,1,0,210,5,
29,48,190,255,250,234,197,5,28,48,190,255,180,119,129,202,129,178,29,238,
56,0,28,230,96,2,224,201,202,237,35,55,13,0,191,255,96,252,72,6,
255,243,128,7,97,0,0,234,29,48,191,255,18,254,65,234,29,6,240,255,
166,253,64,6,127,0,138,7,225,48,37,54,60,135,128,255,176,151,128,54,
255,255,191,255,94,254,4,143,124,142,99,138,226,63,0,0,128,54,255,255,
191,255,44,248,10,232,128,255,238,0,0,218,190,255,176,33,106,7,9,0,
47,6,98,46,1,0,106,127,5,0,46,6,56,193,141,0,106,119,29,0,
106,239,33,0,32,110,32,3,106,111,21,0,10,208,218,7,3,0,218,31,
3,0,32,230,164,180,0,234,29,48,190,255,244,116,60,103,5,0,224,97,
242,5,29,48,3,56,32,70,20,0,191,255,108,99,29,48,191,255,50,243,
26,48,29,56,190,255,72,124,202,217,28,230,32,0,65,234,29,6,240,255,
230,229,128,255,114,0,26,48,27,56,190,255,138,43,26,48,190,255,104,140,
10,232,122,7,0,0,26,48,190,255,64,33,224,233,242,5,29,56,38,6,
32,202,133,0,128,255,242,150,224,217,178,13,27,128,159,130,27,56,208,57,
161,58,38,6,84,202,133,0,128,255,218,150,190,255,174,149,191,255,30,251,
74,6,255,48,33,6,248,185,1,0,97,0,33,6,114,174,1,0,97,0,
33,6,96,178,1,0,97,0,33,6,228,132,1,0,97,0,33,6,56,180,
1,0,97,0,33,6,230,178,1,0,97,0,0,82,38,22,6,0,0,90,
130,135,1,0,231,129,138,13,130,87,7,0,162,127,5,0,200,82,207,81,
229,5,76,18,65,90,11,6,226,255,150,245,127,0,12,58,191,7,212,255,
0,82,0,18,135,143,1,0,65,58,65,18,209,81,138,0,2,6,0,254,
134,253,127,0,128,7,225,0,6,232,61,23,1,0,2,22,16,0,34,55,
0,0,34,143,5,0,0,226,63,6,214,36,130,0,221,49,113,0,29,48,
10,56,191,255,194,255,224,81,178,5,32,230,7,16,28,80,64,6,255,0,
230,143,181,0,17,128,168,130,208,22,127,0,2,6,240,255,225,5,100,18,
226,13,104,18,202,21,181,13,2,6,240,255,162,13,2,6,224,255,146,13,
2,6,192,255,130,13,149,13,2,82,133,13,4,82,229,5,5,82,197,5,
6,82,165,5,0,82,127,0,38,143,4,0,0,90,131,138,201,13,230,103,
9,0,1,90,12,6,56,200,210,5,12,6,116,140,162,5,0,90,139,0,
11,80,138,0,127,0,128,7,225,0,6,232,61,143,2,2,0,226,209,134,
255,0,16,6,91,255,234,21,61,23,1,0,2,22,16,0,34,55,0,0,
34,111,5,0,63,6,134,37,130,0,221,49,109,0,29,48,10,56,191,255,
18,255,224,81,178,5,32,230,7,16,28,80,64,6,255,0,38,86,4,0,
127,0,38,86,4,0,127,0,64,14,153,0,65,7,32,221,38,6,152,93,
134,0,128,7,26,122,128,7,225,16,6,224,7,216,0,234,149,21,29,136,
220,137,17,135,0,0,106,130,202,5,13,50,128,255,150,13,29,120,220,121,
15,55,0,0,128,255,138,13,65,234,251,233,246,237,64,6,255,16,128,7,
33,0,132,143,101,137,224,137,202,101,63,6,64,13,3,0,64,86,0,0,
10,87,36,250,138,0,136,82,185,5,95,250,138,253,224,249,226,85,36,127,
113,176,36,134,108,144,16,62,0,32,231,121,209,5,36,118,108,144,100,119,
113,176,36,111,109,176,36,23,113,176,226,105,201,29,36,102,108,144,100,103,
97,137,162,57,97,58,186,53,36,95,113,176,65,90,100,95,113,176,2,55,
0,0,128,255,20,13,64,86,0,0,10,87,36,250,138,0,136,82,161,253,
36,142,108,144,100,143,113,176,36,63,109,176,36,23,113,176,100,63,97,137,
162,57,97,58,234,21,2,134,1,0,100,135,113,176,2,55,0,0,128,255,
220,12,36,103,113,176,36,110,108,144,13,118,0,32,238,97,129,21,36,94,
108,144,100,95,113,176,181,13,224,57,146,13,36,55,113,176,1,82,68,87,
100,137,199,0,128,255,182,12,64,6,63,0,132,7,225,240,6,208,7,232,
60,6,136,202,133,0,29,216,128,7,70,1,36,199,245,178,64,142,153,0,
49,206,0,221,99,207,1,0,1,130,67,135,4,0,25,48,31,58,189,255,
62,223,224,81,186,253,36,87,109,176,36,126,108,144,15,126,0,32,10,22,
1,0,239,17,177,5,36,22,108,144,36,119,113,176,238,17,210,37,26,95,
0,0,106,90,170,29,13,98,74,103,0,0,10,90,66,95,0,0,65,18,
239,17,177,5,36,22,108,144,13,82,66,87,0,0,65,18,239,17,177,5,
36,22,108,144,36,143,113,176,241,17,162,13,65,218,181,5,74,95,0,0,
100,23,109,176,65,210,95,234,218,205,131,135,5,0,224,129,242,13,35,55,
1,0,67,7,4,0,189,255,110,255,224,81,242,5,28,48,32,62,178,1,
0,66,189,255,70,222,191,255,104,254,229,87,64,0,133,82,129,82,201,21,
131,127,5,0,224,121,194,69,35,55,1,0,67,7,4,0,189,255,60,255,
224,81,194,61,28,48,32,62,178,1,0,66,189,255,20,222,213,53,36,111,
245,178,184,105,13,6,190,255,137,29,36,103,109,176,131,95,5,0,100,103,
113,176,224,89,242,37,35,55,1,0,67,7,4,0,189,255,2,255,224,81,
242,29,28,48,32,62,178,1,0,66,189,255,218,221,133,29,131,87,5,0,
224,81,130,21,35,55,1,0,67,7,4,0,189,255,220,254,224,81,130,13,
28,48,32,62,178,1,0,66,189,255,180,221,224,81,224,233,178,5,191,7,
186,254,36,143,109,176,27,80,189,81,81,7,0,0,68,6,255,240,128,7,
97,0,6,232,181,13,106,138,202,5,13,50,128,255,42,11,29,55,0,0,
65,234,128,255,32,11,29,143,0,0,224,137,186,245,64,6,127,0,128,7,
193,0,6,224,7,232,29,6,255,223,185,5,32,238,0,32,229,87,64,0,
224,7,96,1,36,23,109,176,10,72,36,126,108,144,189,17,239,17,217,13,
2,22,0,32,165,13,65,18,36,110,108,144,13,118,0,32,238,17,177,5,
36,22,108,144,2,103,0,0,224,97,194,245,245,13,2,95,0,0,65,18,
36,142,108,144,17,86,0,32,92,95,0,0,65,226,234,17,177,5,36,22,
108,144,29,128,95,234,224,129,250,237,9,232,253,47,32,0,64,6,223,0,
148,7,225,0,36,143,93,137,224,137,214,5,4,135,128,142,224,129,194,5,
100,7,93,137,165,109,36,63,245,178,38,6,148,202,133,0,60,6,192,202,
133,0,128,255,8,146,32,54,0,32,128,255,50,126,10,232,224,233,250,5,
28,48,32,62,234,2,0,66,189,255,176,220,29,48,32,62,0,32,191,255,
56,255,35,54,4,0,39,6,170,170,102,102,191,255,116,32,35,54,4,0,
32,62,0,32,1,66,191,255,158,39,29,56,99,7,1,0,35,54,4,0,
32,70,0,32,0,74,191,255,206,42,36,63,245,178,38,6,180,202,133,0,
128,255,166,145,29,48,128,255,238,125,31,122,100,127,93,137,61,6,212,220,
152,0,29,48,128,255,74,93,224,81,242,5,28,48,32,62,248,2,0,66,
189,255,64,220,29,48,32,62,112,23,0,66,128,255,0,93,224,81,242,5,
28,48,32,62,249,2,0,66,189,255,36,220,29,48,128,255,210,93,224,81,
130,13,28,48,32,62,250,2,0,66,189,255,14,220,224,81,84,6,255,0,
128,7,225,16,4,143,128,142,224,137,194,5,100,7,93,137,245,85,224,49,
186,21,36,135,93,137,65,130,100,135,93,137,97,130,202,5,0,50,191,255,
234,254,36,127,93,137,224,121,250,69,1,114,100,119,93,137,181,69,32,238,
232,3,230,239,32,2,10,82,74,232,224,233,170,5,1,234,36,143,93,137,
224,137,222,5,1,130,100,135,93,137,133,13,17,126,1,0,100,127,93,137,
15,6,0,255,191,45,59,6,208,202,133,0,60,6,212,220,152,0,28,48,
128,255,134,92,224,81,242,5,27,48,32,62,192,2,0,66,189,255,124,219,
28,48,29,56,0,66,128,255,62,92,224,81,242,5,27,48,32,62,193,2,
0,66,189,255,98,219,28,48,128,255,16,93,224,81,130,13,27,48,32,62,
194,2,0,66,189,255,76,219,224,81,64,6,255,16,128,7,97,0,31,234,
229,87,64,0,133,82,129,82,129,13,132,143,101,137,224,137,210,29,95,234,
186,253,165,29,132,135,101,137,224,129,226,21,128,255,206,8,224,81,186,5,
95,234,186,253,36,127,97,137,68,7,100,137,32,254,146,241,100,127,113,176,
223,191,0,0,64,86,0,0,0,90,74,95,144,244,61,6,64,13,3,0,
64,86,0,0,10,87,36,250,138,0,136,82,185,5,95,234,138,253,36,119,
109,176,36,23,113,176,226,113,233,13,2,48,36,102,108,144,172,17,32,62,
0,32,162,57,191,255,178,250,36,142,108,144,100,143,113,176,36,135,109,176,
80,7,0,0,36,55,113,176,191,255,18,253,36,127,109,176,61,6,64,13,
3,0,100,127,113,176,100,127,97,137,64,86,0,0,10,87,36,250,138,0,
136,82,185,5,95,234,138,253,64,6,127,0,188,7,33,0,4,135,124,142,
97,130,162,29,100,130,130,29,36,23,109,176,36,126,108,144,226,121,171,21,
36,118,108,144,14,86,0,32,234,17,201,13,36,95,113,176,36,110,108,144,
235,105,235,5,234,89,201,5,66,7,0,0,245,101,36,102,108,144,100,103,
109,176,38,6,224,202,133,0,191,255,154,252,35,54,84,0,39,6,170,170,
102,102,191,255,254,29,35,54,84,0,191,255,40,46,224,81,146,37,36,62,
108,144,99,7,1,0,35,54,84,0,32,70,0,32,0,74,191,255,90,28,
224,81,202,21,229,5,36,95,109,176,65,90,100,95,109,176,36,23,109,176,
2,87,0,0,224,81,242,13,36,134,108,144,16,142,255,31,241,17,129,245,
133,13,36,54,108,144,0,58,32,70,0,32,189,255,230,213,36,71,109,176,
36,118,108,144,35,54,4,0,39,6,8,203,133,0,100,71,113,176,174,65,
128,255,32,133,35,22,4,0,213,21,36,111,109,176,77,87,0,0,36,103,
109,176,36,86,108,144,10,94,0,32,65,98,100,103,109,176,235,97,209,5,
36,142,108,144,100,143,109,176,65,18,2,87,0,0,224,81,154,237,124,6,
63,0,128,7,33,0,32,254,146,241,223,191,0,0,64,86,0,0,0,90,
74,95,144,244,36,23,97,137,36,143,109,176,68,7,100,137,100,23,113,176,
241,17,178,5,191,255,106,249,64,6,63,0,128,7,97,0,36,55,85,137,
191,255,158,251,36,55,109,143,191,255,150,251,32,54,62,0,128,255,198,6,
38,6,220,219,152,0,191,255,132,251,13,50,128,255,182,6,36,55,109,143,
191,255,118,251,32,54,62,0,128,255,166,6,0,234,133,21,29,136,81,142,
153,0,17,127,220,219,224,121,202,5,100,239,113,143,165,13,36,55,77,137,
191,255,78,251,65,234,36,119,113,143,238,233,234,237,64,6,127,0,128,7,
33,0,165,13,36,143,113,143,36,55,77,137,65,138,100,143,113,143,191,255,
40,251,36,135,113,143,80,134,153,0,16,119,220,219,224,113,138,245,64,6,
63,0,128,7,225,0,36,239,101,143,224,233,194,5,29,142,255,255,165,5,
9,138,100,143,101,143,60,6,220,214,152,0,17,48,199,50,220,49,37,62,
80,135,128,255,6,143,224,81,202,5,100,239,101,143,229,13,36,63,101,143,
38,6,220,219,152,0,199,58,220,57,128,255,214,142,191,255,34,255,191,255,
136,255,64,6,255,0,128,7,225,0,36,239,101,143,10,122,60,6,220,214,
152,0,37,62,81,135,29,54,1,0,239,55,194,50,100,55,101,143,199,50,
220,49,128,255,182,142,224,81,202,5,100,239,101,143,229,13,36,63,101,143,
38,6,220,219,152,0,199,58,220,57,128,255,134,142,191,255,210,254,191,255,
56,255,64,6,255,0,36,143,113,143,81,142,153,0,17,127,220,219,224,121,
162,13,36,119,113,143,36,55,77,137,65,114,100,119,113,143,191,7,78,250,
127,0,36,143,113,143,224,137,146,13,36,55,81,137,17,134,255,255,100,135,
113,143,191,7,52,250,127,0,128,7,33,0,149,13,36,55,81,137,16,142,
255,255,100,143,113,143,191,255,28,250,36,135,113,143,224,129,218,245,64,6,
63,0,128,7,97,0,36,239,113,143,29,136,81,142,153,0,17,127,220,219,
224,121,130,37,34,6,220,219,152,0,29,104,194,105,13,55,1,0,29,96,
194,97,65,234,76,55,0,0,224,49,194,5,128,255,18,5,133,245,32,54,
32,0,128,255,8,5,229,5,36,55,81,137,95,234,191,255,196,249,36,143,
113,143,241,233,139,253,64,6,127,0,128,7,33,0,36,143,113,143,224,137,
178,13,36,55,81,137,17,134,255,255,100,135,113,143,191,255,156,249,191,255,
140,255,64,6,63,0,128,7,33,0,165,13,36,143,113,143,36,55,77,137,
65,138,100,143,113,143,191,255,124,249,36,135,113,143,80,134,153,0,16,111,
220,219,13,6,224,255,194,5,224,105,218,237,165,13,36,103,113,143,36,55,
77,137,65,98,100,103,113,143,191,255,82,249,36,95,113,143,75,94,153,0,
11,143,220,219,17,6,224,255,242,237,64,6,63,0,132,7,97,0,37,127,
85,135,3,56,64,22,153,0,103,127,1,0,5,119,88,135,34,238,92,220,
71,119,4,0,100,7,121,143,128,255,160,140,125,87,1,0,149,29,36,111,
121,143,0,50,3,56,13,238,1,0,100,239,121,143,194,234,194,233,128,255,
130,140,36,103,121,143,125,87,1,0,12,6,227,255,234,5,12,94,1,0,
100,95,121,143,197,13,36,135,121,143,34,6,92,220,152,0,194,130,194,129,
48,119,1,0,224,113,234,221,68,6,127,0,190,7,14,136,128,7,97,0,
61,6,220,219,152,0,29,48,37,62,92,135,128,255,204,140,224,81,130,29,
36,55,105,143,45,6,220,214,152,0,29,56,6,142,1,0,100,143,105,143,
199,50,205,49,128,255,152,140,36,103,105,143,10,90,235,103,194,98,100,103,
105,143,100,103,101,143,37,54,93,135,191,255,116,248,29,48,191,255,54,255,
36,55,121,143,39,6,92,220,152,0,191,255,158,255,133,87,93,135,93,87,
0,0,100,7,113,143,191,255,170,252,64,6,127,0,128,7,225,0,6,232,
189,0,29,134,224,255,16,6,161,255,145,85,29,102,191,255,12,6,230,255,
233,119,0,0,197,114,206,233,189,0,60,6,220,219,152,0,28,16,2,143,
0,0,65,18,224,137,202,253,188,17,2,126,255,255,15,6,130,255,217,5,
7,50,128,255,60,3,213,53,36,23,113,143,2,112,220,113,14,111,0,0,
224,105,154,21,29,48,128,255,36,3,36,95,113,143,11,80,220,89,75,239,
0,0,65,82,100,87,113,143,220,81,74,7,0,0,213,29,2,224,2,134,
1,0,100,135,113,143,28,16,66,22,153,0,29,48,2,239,220,219,66,55,
220,219,65,226,224,49,130,13,128,255,230,2,181,245,36,55,81,137,191,255,
164,247,36,103,113,143,95,226,236,225,139,253,64,6,255,0,128,7,33,0,
166,0,6,6,229,255,218,5,1,130,100,135,117,143,229,93,6,6,177,255,
194,5,6,6,165,255,154,13,36,111,117,143,97,106,218,5,2,130,100,135,
117,143,133,85,36,95,117,143,98,90,170,45,6,6,188,255,145,13,6,6,
191,255,153,37,242,13,6,6,189,255,249,13,149,21,6,6,188,255,146,21,
6,6,184,255,146,21,6,6,181,255,146,21,165,21,191,255,32,252,245,13,
191,255,110,252,197,13,191,255,184,252,149,13,191,255,214,252,229,5,191,255,
234,252,181,5,191,255,214,251,100,7,117,143,181,37,6,16,109,18,233,5,
104,18,210,13,105,18,226,13,149,29,109,18,226,13,2,6,238,255,226,13,
2,6,129,255,226,13,133,21,191,255,50,253,245,13,191,255,80,253,197,13,
191,255,28,254,149,13,191,255,46,251,229,5,191,255,194,252,181,5,191,255,
128,254,64,6,63,0,128,7,33,0,64,86,0,0,10,87,38,250,138,0,
68,87,124,143,32,254,174,241,223,191,0,0,64,86,0,0,0,90,74,95,
144,244,4,143,88,137,224,137,234,5,4,55,124,143,191,255,254,254,133,13,
32,54,12,177,32,62,0,2,0,66,189,255,38,245,64,6,63,0,38,6,
0,221,152,0,37,62,96,135,1,66,191,7,30,98,100,55,109,143,127,0,
128,7,33,0,0,18,133,111,113,135,2,136,199,138,81,142,153,0,81,111,
220,214,65,18,106,18,230,245,37,54,104,135,191,255,218,255,100,7,117,143,
100,7,113,143,64,14,153,0,65,7,220,219,100,7,105,143,100,7,101,143,
64,6,63,0,128,7,225,0,4,119,88,137,7,224,6,56,8,232,224,113,
154,21,132,135,109,137,224,129,138,13,28,64,29,72,38,6,1,0,4,0,
128,255,100,167,28,48,29,56,191,255,126,243,245,21,99,114,178,5,98,114,
186,5,0,234,149,21,132,111,109,137,224,105,138,13,28,64,29,72,38,6,
1,0,4,0,128,255,56,167,28,48,29,56,191,255,92,244,10,232,29,80,
64,6,255,0,128,7,97,0,36,239,109,143,128,255,6,1,36,54,72,137,
191,255,70,255,100,7,105,137,68,7,88,137,191,255,252,249,64,62,134,0,
39,63,101,228,38,6,76,203,133,0,128,255,100,136,32,63,169,182,39,63,
41,0,38,6,56,203,133,0,128,255,82,136,197,29,64,86,0,0,10,87,
174,241,138,0,136,82,169,253,64,86,0,0,10,87,38,250,138,0,68,87,
124,143,32,254,174,241,223,191,0,0,64,86,0,0,0,90,74,95,144,244,
4,55,124,143,191,255,180,253,36,127,105,137,224,121,162,229,1,114,68,119,
88,137,29,48,191,255,202,254,191,255,136,249,128,255,118,31,64,6,127,0,
128,7,97,0,6,232,38,6,164,203,133,0,191,255,22,245,32,63,169,182,
39,63,41,0,38,6,204,203,133,0,29,64,128,255,214,135,133,5,128,7,
97,0,6,232,38,6,240,203,133,0,191,255,240,244,32,63,169,182,39,63,
41,0,38,6,40,204,133,0,29,64,128,255,176,135,133,5,224,49,210,5,
129,58,185,5,128,7,180,115,127,0,33,6,160,104,0,0,97,0,33,6,
24,104,0,0,97,0,33,6,106,103,0,0,97,0,33,6,6,102,0,0,
97,0,64,14,153,0,65,7,80,221,38,6,164,93,134,0,128,7,56,108,
134,135,7,0,166,143,7,0,134,111,3,0,166,119,1,0,166,95,3,0,
209,129,134,143,5,0,206,105,166,119,5,0,205,89,203,137,134,103,9,0,
209,113,208,113,14,22,1,0,2,136,136,138,194,137,70,143,8,0,0,82,
209,126,255,0,239,97,138,13,134,111,1,0,166,119,7,0,237,113,170,5,
1,82,138,0,127,0,128,7,97,0,6,232,224,233,250,5,1,50,128,255,
152,113,10,232,224,233,146,13,38,6,36,221,152,0,31,58,190,255,156,27,
224,81,154,253,29,80,64,6,127,0,128,7,160,12,128,7,97,0,32,142,
16,0,100,143,141,143,100,63,129,143,100,55,133,143,1,50,128,255,142,12,
0,50,128,255,144,12,245,53,128,255,146,12,36,55,129,143,6,6,240,255,
238,5,100,55,141,143,134,0,128,255,118,12,36,119,129,143,36,111,141,143,
0,234,173,113,100,119,129,143,197,13,36,23,133,143,2,102,1,0,100,103,
133,143,130,55,1,0,128,255,96,12,65,234,36,87,141,143,234,233,166,245,
61,6,64,13,3,0,128,255,84,12,133,82,185,5,95,234,186,253,224,233,
202,5,32,86,73,2,133,21,128,255,62,12,68,87,136,143,36,143,129,143,
224,137,250,197,4,135,136,143,32,86,72,2,134,130,169,5,0,82,64,6,
127,0,128,7,225,0,6,232,7,224,224,233,210,21,38,6,36,221,152,0,
190,255,216,26,224,81,146,13,38,6,76,204,133,0,32,62,255,0,0,66,
189,255,216,208,129,226,201,5,29,48,128,255,30,114,64,6,255,0,128,7,
225,0,32,142,16,0,100,143,141,143,100,63,129,143,100,55,133,143,0,50,
128,255,174,11,0,50,128,255,176,11,165,69,128,255,178,11,36,55,129,143,
6,6,240,255,238,5,100,55,141,143,134,0,128,255,150,11,36,119,129,143,
36,111,141,143,0,234,173,113,100,119,129,143,213,5,0,50,128,255,142,11,
65,234,36,103,141,143,236,233,150,253,61,6,64,13,3,0,128,255,130,11,
133,82,185,5,95,234,186,253,224,233,202,5,32,86,73,2,165,37,128,255,
108,11,68,87,136,143,0,234,213,13,36,231,133,143,128,255,100,11,92,87,
0,0,36,95,133,143,65,234,65,90,100,95,133,143,36,87,141,143,234,233,
150,245,36,143,129,143,224,137,202,189,4,135,136,143,32,86,72,2,134,130,
169,5,0,82,64,6,255,0,128,7,54,11,130,7,225,16,6,232,221,0,
7,224,8,216,3,48,191,255,32,254,3,138,67,143,1,0,29,128,168,130,
67,135,2,0,67,239,3,0,191,255,54,254,35,54,1,0,3,58,191,255,
48,254,10,232,224,233,226,5,3,48,2,58,191,255,202,254,181,21,28,48,
27,56,191,255,248,254,10,232,224,233,226,5,3,48,2,58,191,255,178,254,
245,5,191,255,162,255,3,48,2,58,191,255,164,254,29,80,66,6,255,16,
128,7,33,0,38,135,5,0,9,136,199,137,240,137,195,5,32,86,13,1,
181,13,38,119,13,0,206,57,7,48,198,0,8,56,9,64,191,255,112,255,
0,82,64,6,63,0,144,7,225,243,99,55,1,0,99,63,5,0,99,71,
13,0,99,79,9,0,0,178,0,202,32,190,0,1,31,210,32,54,92,1,
128,255,22,111,10,232,0,218,0,194,35,230,16,0,35,55,1,0,24,56,
29,64,32,78,92,1,191,255,150,255,189,135,1,0,157,127,3,0,61,86,
4,0,0,18,208,121,15,94,1,0,138,111,1,0,65,18,65,82,205,89,
2,6,168,254,153,253,11,136,136,138,203,137,157,135,1,0,209,126,255,0,
93,143,0,0,239,129,242,5,224,209,254,13,27,208,93,7,2,0,181,13,
35,63,5,0,61,54,4,0,128,255,18,10,224,81,178,5,27,208,1,178,
157,119,3,0,249,113,124,119,1,0,167,5,14,200,60,103,1,0,247,97,
174,5,12,184,24,198,112,1,68,226,65,218,100,218,166,189,29,48,128,255,
250,111,0,122,0,106,0,98,32,118,0,2,35,22,16,0,183,201,25,6,
128,255,231,135,0,0,224,129,170,13,34,95,1,0,11,6,128,255,222,5,
11,86,0,1,98,87,1,0,34,87,1,0,237,81,167,5,10,104,238,81,
190,5,10,112,12,120,68,18,65,98,100,98,150,237,13,200,224,201,170,5,
65,202,224,209,174,5,15,208,35,151,9,0,26,136,194,138,35,118,16,0,
82,207,0,0,206,137,49,111,1,0,249,105,130,13,35,151,9,0,146,103,
1,0,65,98,82,103,0,0,35,151,13,0,240,215,110,2,22,80,138,0,
114,215,1,0,80,6,255,243,190,7,225,243,3,30,216,254,35,143,201,1,
99,55,17,0,99,71,21,0,99,79,25,0,81,7,0,0,35,55,17,0,
35,78,11,0,35,70,12,0,191,255,130,254,224,81,186,5,128,7,84,1,
132,135,113,137,224,129,186,5,128,7,72,1,35,55,17,0,35,63,13,0,
35,70,72,0,32,78,92,1,191,255,44,254,163,119,73,0,35,143,201,1,
0,178,0,210,97,114,226,127,0,0,81,127,0,0,35,191,13,0,35,222,
52,0,35,206,28,0,35,198,36,0,23,190,92,1,31,106,121,111,1,0,
35,55,17,0,23,56,27,64,9,74,191,255,238,253,73,186,27,48,191,255,
82,251,26,56,224,81,210,45,155,95,3,0,187,127,3,0,187,103,1,0,
200,90,208,122,204,89,155,103,5,0,203,121,187,87,5,0,216,98,207,97,
12,70,0,0,120,71,1,0,225,79,0,0,202,73,120,79,5,0,155,127,
7,0,99,127,1,0,187,119,7,0,38,6,152,204,133,0,99,119,5,0,
128,255,106,130,187,111,7,0,65,178,121,111,1,0,229,5,38,6,88,204,
133,0,128,255,84,130,73,218,68,202,72,194,65,210,98,210,150,189,224,177,
202,5,32,86,145,3,149,61,97,178,250,5,35,103,29,0,224,97,230,71,
0,0,165,13,131,135,33,0,131,95,29,0,176,89,171,0,224,89,231,71,
0,0,8,88,195,90,35,126,36,0,207,89,43,111,5,0,35,143,21,0,
43,103,1,0,35,94,52,0,113,111,5,0,232,110,9,0,113,103,1,0,
35,143,25,0,203,105,141,87,7,0,81,87,0,0,35,63,201,1,135,63,
1,0,38,6,116,204,133,0,128,255,214,129,0,82,181,5,32,86,146,3,
3,30,40,1,126,6,255,243,130,7,225,16,6,232,221,0,7,224,8,216,
3,48,191,255,160,250,6,138,67,143,1,0,29,128,168,130,67,135,2,0,
67,239,3,0,191,255,182,250,35,54,1,0,1,58,191,255,176,250,10,232,
224,233,226,5,3,48,2,58,191,255,74,251,245,37,191,255,58,252,2,106,
67,111,1,0,191,255,142,250,35,54,1,0,3,58,191,255,136,250,10,232,
224,233,226,5,3,48,2,58,191,255,34,251,181,21,28,48,27,56,191,255,
112,250,10,232,224,233,226,5,3,48,2,58,191,255,10,251,245,5,191,255,
250,251,3,48,2,58,191,255,252,250,29,80,66,6,255,16,128,7,33,0,
38,135,5,0,9,136,199,137,240,137,195,5,32,86,13,1,181,13,38,119,
13,0,206,57,7,48,198,0,8,56,9,64,191,255,72,255,0,82,64,6,
63,0,134,7,225,0,6,232,157,135,17,0,131,63,25,0,224,129,202,5,
32,86,144,3,197,53,189,127,19,0,61,111,29,0,93,63,18,0,8,16,
65,122,207,86,1,0,233,87,66,2,93,127,19,0,2,96,205,81,10,230,
92,1,136,98,125,71,21,0,125,79,25,0,67,103,2,0,2,88,144,90,
67,95,3,0,67,23,1,0,152,18,67,23,4,0,67,79,5,0,67,127,
7,0,67,127,0,0,67,63,6,0,3,48,191,255,40,249,29,48,28,56,
3,64,9,74,191,255,88,255,70,6,255,0,128,7,225,48,132,143,113,137,
6,208,224,137,130,85,32,54,92,1,128,255,252,106,10,232,224,233,146,77,
38,6,216,204,133,0,128,255,92,128,0,226,0,218,26,48,27,56,29,64,
32,78,92,1,191,255,116,251,27,222,112,1,28,56,38,6,232,204,133,0,
128,255,58,128,189,127,1,0,157,119,3,0,61,86,4,0,0,18,207,113,
14,94,1,0,138,103,1,0,65,18,65,82,204,89,2,6,168,254,153,253,
11,128,136,130,203,129,157,127,1,0,208,118,255,0,93,135,0,0,238,121,
242,5,38,6,248,204,133,0,128,255,246,127,165,13,157,63,3,0,189,71,
1,0,38,6,192,204,133,0,128,255,226,127,65,226,100,226,182,197,29,48,
128,255,232,107,64,6,255,48,128,7,97,0,6,232,157,143,17,0,224,137,
242,37,61,63,29,0,38,6,8,205,133,0,128,255,182,127,157,127,35,0,
93,7,33,0,61,86,36,0,0,18,15,94,1,0,138,111,1,0,65,18,
65,82,205,89,2,6,168,254,153,253,11,136,136,138,203,137,93,143,32,0,
61,63,29,0,29,48,61,70,32,0,32,78,92,1,191,255,74,254,64,6,
127,0,132,7,225,16,32,222,146,3,6,224,35,70,4,0,35,78,3,0,
191,255,182,250,224,81,162,53,32,54,92,1,128,255,226,105,10,232,224,233,
178,45,35,63,5,0,28,48,29,64,32,78,92,1,191,255,102,250,157,135,
3,0,93,7,1,0,61,86,4,0,0,18,16,94,1,0,138,119,1,0,
65,18,65,82,206,89,2,6,168,254,153,253,11,80,136,82,203,81,93,87,
0,0,35,63,5,0,28,48,29,64,32,78,92,1,191,255,210,253,29,48,
128,255,12,107,0,218,27,80,68,6,255,16,224,49,210,13,36,143,117,137,
224,137,215,5,17,134,255,255,100,135,117,137,129,58,185,5,128,7,232,106,
127,0,128,7,225,0,7,232,189,0,8,224,224,49,138,13,32,54,16,0,
128,255,78,105,10,48,224,49,210,5,102,239,1,0,102,231,5,0,6,80,
64,6,255,0,144,7,225,112,6,232,57,6,181,53,125,145,0,218,0,226,
32,214,0,32,61,135,5,0,26,120,188,121,16,142,16,0,239,137,195,13,
61,63,1,0,38,6,132,205,133,0,128,255,120,126,32,222,18,1,128,7,
202,1,28,48,198,0,35,62,16,0,32,70,16,0,191,255,30,249,35,23,
25,0,249,17,250,29,227,103,19,0,227,95,21,0,227,143,23,0,35,127,
29,0,227,87,17,0,204,89,203,137,209,121,207,17,65,18,2,88,144,90,
194,89,99,95,16,0,203,142,255,255,241,81,186,5,128,7,40,1,35,135,
25,0,249,129,210,5,38,6,176,205,133,0,197,5,38,6,28,206,133,0,
61,63,1,0,128,255,6,126,61,63,1,0,28,64,38,6,44,205,133,0,
128,255,246,125,35,54,16,0,0,58,32,70,16,0,189,255,200,196,61,23,
5,0,61,127,1,0,99,207,25,0,227,135,23,0,2,214,3,0,26,104,
191,106,158,106,205,209,162,210,99,215,20,0,99,127,18,0,207,0,35,119,
29,0,218,86,255,255,207,81,202,129,208,113,206,201,25,22,1,0,2,80,
144,82,194,81,99,87,16,0,26,48,194,50,128,255,204,105,10,200,224,201,
138,13,37,54,116,135,32,62,76,2,0,66,189,255,72,200,25,48,194,210,
26,64,0,58,189,255,90,196,125,231,9,0,28,102,16,0,125,103,13,0,
204,54,255,255,25,56,26,64,191,255,160,251,25,48,128,255,170,105,253,55,
9,0,32,70,16,0,35,62,16,0,191,255,138,251,3,48,0,58,32,70,
16,0,189,255,32,196,253,55,9,0,32,70,16,0,3,56,191,255,240,247,
35,86,16,0,3,88,0,18,139,103,1,0,138,111,1,0,236,105,146,13,
38,6,96,205,133,0,128,255,20,125,32,222,72,2,181,53,65,18,65,82,
65,90,2,6,240,255,217,237,197,45,61,143,1,0,241,97,138,37,227,63,
21,0,61,71,5,0,194,58,232,57,169,21,38,6,224,205,133,0,128,255,
224,124,61,63,1,0,38,6,76,206,133,0,128,255,210,124,32,222,18,1,
125,7,5,0,133,21,125,231,9,0,28,110,16,0,125,111,13,0,149,13,
227,95,21,0,194,90,11,94,16,0,203,225,191,7,24,254,27,80,80,6,
255,112,136,7,225,112,7,224,8,208,9,216,131,207,41,0,6,232,224,233,
170,13,32,54,124,1,128,255,24,103,10,232,224,233,186,5,128,7,4,1,
29,48,2,58,32,70,192,5,191,255,162,253,36,135,117,137,93,207,18,0,
29,48,65,130,100,135,117,137,125,215,21,0,125,223,25,0,191,255,176,253,
224,81,186,109,1,122,68,127,112,137,93,127,16,0,61,54,32,0,0,58,
32,70,92,1,189,255,26,195,38,6,120,206,133,0,128,255,48,124,29,48,
28,56,61,70,28,0,61,78,17,0,191,255,120,247,224,81,162,21,38,6,
132,206,133,0,128,255,18,124,29,48,28,56,35,110,7,0,99,111,1,0,
35,70,8,0,35,78,6,0,191,255,168,248,189,95,17,0,1,98,93,103,
33,0,61,54,36,0,93,95,34,0,28,56,32,70,88,1,189,255,96,193,
189,87,33,0,157,135,35,0,0,18,202,129,16,94,1,0,61,86,36,0,
138,119,1,0,65,18,65,82,206,89,2,6,168,254,153,253,11,80,136,82,
203,81,93,87,32,0,61,63,29,0,29,48,61,70,32,0,32,78,92,1,
191,255,112,250,29,48,26,64,27,72,93,7,19,0,99,207,1,0,191,255,
140,250,29,48,26,64,27,72,99,207,1,0,191,255,126,250,29,80,72,6,
255,112,128,7,97,0,6,232,224,233,138,13,32,54,124,1,128,255,246,101,
10,232,224,233,210,21,29,48,2,58,32,70,192,5,191,255,132,252,93,7,
18,0,125,7,21,0,125,7,25,0,29,48,191,255,156,252,224,81,202,5,
1,130,68,135,112,137,29,80,64,6,127,0,190,7,33,0,3,30,0,255,
3,48,191,255,176,255,3,48,191,255,160,250,3,48,2,58,191,255,40,252,
3,30,0,1,126,6,63,0,138,7,225,16,38,6,188,206,133,0,128,255,
0,123,0,234,0,226,59,6,181,53,125,145,29,48,198,0,35,62,4,0,
32,70,16,0,191,255,164,245,35,23,13,0,251,17,154,53,227,119,7,0,
227,111,9,0,227,95,11,0,35,143,17,0,227,103,5,0,206,105,205,89,
203,137,209,17,65,18,2,104,144,106,194,105,99,111,4,0,205,94,255,255,
235,97,154,29,227,79,9,0,28,56,65,226,14,64,194,74,99,239,1,0,
38,6,208,206,133,0,128,255,148,122,227,111,9,0,194,106,13,110,16,0,
205,233,29,142,16,0,17,6,0,224,217,197,224,225,234,5,38,6,164,206,
133,0,128,255,112,122,74,6,255,16,38,6,36,221,152,0,39,6,0,207,
133,0,0,66,191,7,112,83,224,49,210,5,129,58,185,5,128,7,96,102,
127,0,33,6,144,100,0,0,97,0,33,6,196,100,0,0,97,0,33,6,
244,100,0,0,97,0,33,6,18,101,0,0,97,0,33,6,166,100,0,0,
97,0,33,6,44,101,0,0,97,0,33,6,108,100,0,0,97,0,33,6,
122,100,0,0,97,0,33,6,254,169,1,0,97,0,128,7,225,0,6,232,
0,226,0,58,61,86,8,0,0,18,138,143,1,0,65,82,65,18,209,57,
135,0,2,6,193,255,134,253,189,119,71,0,238,57,130,13,38,6,12,207,
133,0,128,255,208,121,32,230,66,2,157,63,9,0,7,6,128,255,129,13,
38,6,16,208,133,0,128,255,184,121,32,230,66,2,157,63,11,0,100,58,
162,13,38,6,192,208,133,0,128,255,162,121,32,86,67,2,128,7,2,2,
189,63,11,0,199,134,240,0,162,13,38,6,156,207,133,0,128,255,134,121,
32,86,67,2,128,7,230,1,157,63,13,0,7,142,248,255,101,138,201,5,
199,134,240,0,130,13,38,6,228,208,133,0,128,255,98,121,32,230,66,2,
189,63,13,0,98,58,187,5,224,57,170,13,38,6,32,209,133,0,128,255,
72,121,32,86,67,2,128,7,168,1,253,63,15,0,7,6,184,255,210,13,
7,6,192,255,242,13,38,6,52,208,133,0,128,255,38,121,32,86,67,2,
128,7,134,1,38,6,44,207,133,0,128,255,20,121,157,63,17,0,97,58,
162,13,38,6,64,209,133,0,128,255,2,121,32,86,67,2,128,7,98,1,
189,63,17,0,7,6,95,255,137,13,38,6,200,207,133,0,128,255,230,120,
32,230,66,2,189,63,19,0,98,58,161,13,38,6,84,208,133,0,128,255,
208,120,32,86,67,2,128,7,48,1,157,63,21,0,199,102,128,0,170,13,
38,6,104,209,133,0,128,255,180,120,32,86,67,2,128,7,20,1,189,63,
23,0,100,58,147,13,38,6,36,210,133,0,128,255,154,120,32,86,67,2,
213,125,157,63,25,0,199,94,128,0,154,13,38,6,140,209,133,0,128,255,
128,120,32,86,67,2,133,117,189,63,25,0,100,58,146,13,38,6,236,207,
133,0,128,255,104,120,32,86,67,2,197,101,157,63,27,0,199,142,7,0,
154,13,38,6,100,207,133,0,128,255,78,120,32,86,67,2,245,85,189,63,
27,0,199,102,1,0,154,13,38,6,176,209,133,0,128,255,52,120,32,86,
67,2,165,77,157,63,29,0,199,126,1,0,154,13,38,6,208,209,133,0,
128,255,26,120,32,86,67,2,213,61,189,63,29,0,199,86,98,0,146,13,
38,6,128,208,133,0,128,255,0,120,32,86,67,2,133,53,189,63,35,0,
224,57,138,13,38,6,168,208,133,0,128,255,232,119,32,230,66,2,189,63,
35,0,7,6,225,255,137,13,38,6,132,207,133,0,128,255,208,119,32,230,
66,2,189,63,37,0,224,57,138,13,38,6,240,209,133,0,128,255,186,119,
32,230,66,2,189,63,37,0,7,6,214,255,137,13,38,6,8,210,133,0,
128,255,162,119,32,230,66,2,28,80,64,6,255,0,166,87,37,0,127,0,
166,87,35,0,127,0,6,143,20,0,209,134,127,0,16,120,143,0,99,122,
217,5,97,122,145,13,178,13,213,13,100,122,225,13,130,21,101,122,146,21,
197,21,32,86,9,61,165,21,32,86,60,15,245,13,32,86,120,30,197,13,
32,86,68,122,149,13,128,86,36,244,229,5,42,6,72,232,1,0,165,5,
0,82,127,0,134,87,13,0,127,0,166,87,11,0,127,0,130,7,97,0,
6,232,61,87,5,0,157,127,3,0,32,110,128,0,61,78,8,0,42,23,
37,0,15,112,14,56,0,66,34,135,24,0,99,111,1,0,34,103,29,0,
63,6,16,68,130,0,16,48,202,49,108,0,125,87,0,0,234,0,224,81,
234,5,29,48,191,255,234,252,125,87,0,0,61,87,0,0,66,6,127,0,
134,135,13,0,166,143,11,0,38,103,0,0,166,119,13,0,209,129,0,82,
208,113,14,22,4,0,224,97,202,5,1,82,226,87,192,0,127,0,128,7,
225,16,6,232,7,224,188,0,8,216,224,233,138,13,32,54,136,0,128,255,
48,97,10,232,224,233,226,13,93,231,2,0,125,7,0,0,125,223,5,0,
61,54,8,0,0,58,32,70,128,0,189,255,96,189,29,80,64,6,255,16,
128,7,33,0,64,14,153,0,65,7,248,228,38,6,176,93,134,0,128,255,
46,91,48,6,8,116,153,0,47,6,8,100,153,0,175,129,100,135,193,143,
45,6,8,148,153,0,44,6,8,132,153,0,172,105,100,111,189,143,42,6,
8,164,153,0,49,6,8,148,153,0,177,81,100,87,185,143,48,6,8,235,
255,255,47,6,8,227,255,255,175,129,100,135,181,143,46,6,8,132,153,0,
45,6,8,116,153,0,173,113,100,119,177,143,44,6,8,100,153,0,43,6,
8,84,153,0,171,97,100,103,173,143,42,6,8,180,153,0,49,6,8,164,
153,0,46,6,8,212,153,0,45,6,8,196,153,0,173,113,100,119,161,143,
43,6,8,4,154,0,177,81,100,87,169,143,42,6,8,244,153,0,170,89,
100,95,157,143,48,6,8,196,153,0,47,6,8,180,153,0,175,129,100,135,
165,143,48,6,8,8,154,0,47,6,8,4,154,0,175,129,100,135,153,143,
45,6,8,12,154,0,44,6,8,8,154,0,172,105,36,103,181,143,42,6,
8,28,154,0,34,6,188,93,134,0,49,6,8,12,154,0,98,103,21,0,
36,103,169,143,36,135,185,143,177,81,98,103,69,0,36,103,173,143,100,87,
145,143,36,127,189,143,100,111,149,143,98,103,117,0,36,103,177,143,98,95,
149,1,36,111,193,143,98,135,53,1,98,103,165,0,36,103,165,143,98,127,
101,1,36,95,149,143,98,119,5,1,98,103,213,0,36,103,153,143,98,111,
197,1,98,95,37,2,98,87,85,2,98,103,245,1,64,6,63,0,128,7,
33,0,34,6,16,172,156,0,166,17,2,6,0,255,128,255,44,0,190,255,
48,25,190,255,110,24,4,135,124,142,97,130,202,5,0,50,128,255,92,64,
64,6,63,0,224,49,210,5,129,58,185,5,128,7,236,96,127,0,33,6,
52,120,1,0,97,0,128,7,193,0,6,232,64,86,0,0,42,87,80,245,
202,0,228,23,133,142,10,224,226,231,34,2,128,126,27,183,220,0,220,233,
239,239,192,234,252,233,231,13,64,86,0,0,42,87,80,245,202,0,228,23,
133,142,226,87,34,2,202,0,253,81,214,245,245,21,64,86,0,0,42,87,
80,245,202,0,228,23,133,142,133,13,64,86,0,0,42,87,80,245,202,0,
228,23,133,142,226,87,34,2,202,0,252,81,223,245,253,81,182,245,64,6,
223,0,36,23,117,176,32,126,44,1,239,23,194,2,236,23,102,2,43,6,
128,81,1,0,7,130,2,96,235,103,194,2,240,103,194,82,2,112,235,119,
194,122,70,87,0,0,103,127,1,0,2,80,127,0,128,7,33,0,32,22,
184,11,224,49,194,5,36,23,121,137,198,17,100,23,121,137,2,6,71,244,
249,13,196,239,96,144,162,13,32,54,49,0,37,62,144,135,189,255,140,192,
1,138,100,143,125,176,100,7,121,137,64,6,63,0,130,7,225,0,36,143,
129,176,7,224,6,232,3,48,99,143,1,0,128,255,182,141,29,48,28,64,
10,72,32,62,30,0,128,255,192,123,66,6,255,0,128,102,27,183,12,104,
230,111,34,2,199,0,32,86,16,39,199,105,237,87,34,2,0,90,236,87,
194,2,127,0,128,7,225,16,6,224,128,222,26,183,28,6,155,255,233,5,
32,238,213,1,28,230,156,255,165,29,48,6,140,134,71,0,252,135,34,2,
45,6,64,66,15,0,0,226,237,135,194,2,16,238,1,0,251,233,179,13,
128,54,26,183,191,255,154,254,50,6,230,72,255,255,210,233,234,245,197,5,
29,48,191,255,136,254,224,225,186,221,64,6,255,16,36,23,93,144,224,17,
154,13,100,23,117,176,100,7,121,176,100,7,129,176,100,7,125,176,127,0,
132,7,33,0,41,6,64,74,130,0,99,7,1,0,99,7,5,0,32,54,
164,180,32,62,16,0,32,70,32,0,128,255,142,91,68,6,63,0,128,7,
33,0,41,6,100,74,130,0,32,54,164,180,32,62,16,0,32,70,32,0,
128,255,22,93,38,6,44,96,134,0,128,255,178,87,64,6,63,0,0,98,
181,37,12,16,240,23,68,2,38,134,4,0,39,119,5,0,194,129,48,111,
1,0,238,105,234,21,38,94,4,0,203,17,68,18,39,94,8,0,32,110,
42,0,130,135,1,0,139,87,1,0,65,18,65,90,144,81,234,5,224,129,
146,13,95,106,218,245,229,5,65,98,38,127,2,0,239,97,182,221,12,80,
127,0,38,23,2,0,226,57,174,53,167,17,95,18,240,23,70,2,224,17,
242,37,240,63,68,2,38,102,4,0,7,120,204,57,7,86,48,0,204,121,
15,136,170,137,226,137,171,21,2,112,207,113,14,126,255,255,2,104,202,105,
13,86,255,255,10,103,0,0,95,82,79,103,0,0,95,122,95,18,154,253,
149,13,10,95,0,0,65,82,79,95,0,0,65,122,95,18,154,253,38,87,
2,0,95,82,102,87,2,0,127,0,128,7,33,0,38,127,2,0,224,121,
226,5,230,135,1,0,176,6,237,172,178,5,0,82,197,13,108,122,151,13,
12,114,102,119,2,0,38,6,224,215,133,0,128,255,246,113,1,82,64,6,
63,0,128,7,225,0,6,232,61,135,2,0,7,224,128,142,237,172,125,143,
0,0,108,130,246,5,0,58,191,255,70,255,11,122,125,127,2,0,61,23,
2,0,60,87,5,0,61,110,4,0,60,62,8,0,226,118,48,0,2,102,
1,0,125,103,2,0,205,113,110,87,1,0,46,54,4,0,32,70,42,0,
189,255,32,183,61,63,2,0,38,6,36,216,133,0,128,255,144,113,64,6,
255,0,128,7,97,0,6,232,224,233,138,13,32,54,68,2,128,255,10,92,
10,232,224,233,226,13,128,142,173,222,125,143,0,0,125,7,2,0,61,54,
4,0,0,58,32,70,64,2,189,255,58,184,29,80,64,6,127,0,132,7,
225,115,99,55,1,0,99,63,5,0,8,200,9,232,157,0,104,234,147,13,
29,56,38,6,192,218,133,0,8,66,128,255,48,113,8,234,224,201,138,13,
38,6,220,218,133,0,0,58,128,255,30,113,133,45,29,208,193,210,0,226,
165,37,29,104,188,105,195,106,13,70,8,0,8,120,159,122,207,65,35,55,
1,0,35,63,5,0,161,66,28,216,217,217,128,255,220,133,202,86,15,0,
91,87,0,0,32,102,55,0,106,82,190,5,32,102,48,0,27,95,0,0,
65,226,204,89,91,95,0,0,250,225,230,221,68,6,255,115,128,7,225,0,
6,232,7,224,224,233,178,13,61,54,16,0,2,58,191,255,228,79,129,226,
201,5,29,48,128,255,188,92,64,6,255,0,128,7,97,0,6,232,224,233,
138,13,32,54,32,0,128,255,36,91,10,232,224,233,210,5,61,54,16,0,
191,255,220,79,29,80,64,6,127,0,0,0,32,102,32,0,236,47,32,0,
45,6,164,182,255,255,109,31,1,0,44,6,16,172,155,0,45,6,244,244,
133,0,109,103,1,0,127,0,224,7,32,0,0,0,224,15,32,0,0,0,
224,23,32,0,0,0,224,31,32,0,0,0,224,135,32,0,0,0,224,143,
32,0,0,0,224,151,32,0,0,0,224,159,32,0,0,0,0,0,128,7,
190,8,64,30,153,0,35,30,212,51,128,255,214,8,128,255,124,26,181,45,
128,7,92,8,124,255,125,0,128,255,230,0,64,14,130,0,33,14,14,75,
97,0,64,14,153,0,33,14,212,51,225,25,223,5,1,14,112,254,225,25,
239,5,64,14,153,0,33,14,212,51,1,24,228,55,64,0,229,15,64,0,
193,14,128,0,162,5,144,50,198,54,255,255,60,62,128,0,128,255,166,24,
0,81,196,5,128,255,244,23,0,0,128,255,116,1,60,255,125,0,60,231,
113,0,0,0,224,7,64,1,0,0,128,7,20,8,124,255,125,0,128,255,
108,2,64,14,130,0,33,14,124,75,97,0,64,14,153,0,33,14,212,51,
225,25,223,5,1,14,112,254,225,25,239,5,64,14,153,0,33,14,212,51,
1,24,32,54,96,0,60,62,128,0,128,255,72,24,0,81,196,21,128,255,
236,22,0,0,224,7,96,1,0,50,128,255,92,38,0,0,0,0,64,248,
0,0,0,0,0,0,1,50,128,255,74,38,0,0,0,0,128,255,250,2,
60,255,125,0,60,231,113,0,0,0,224,7,70,1,0,0,0,0,124,7,
1,0,124,15,5,0,124,23,9,0,124,31,13,0,124,39,17,0,124,47,
21,0,124,55,25,0,124,63,29,0,124,71,33,0,124,79,37,0,124,87,
41,0,124,95,45,0,124,103,49,0,124,111,53,0,124,119,57,0,124,127,
61,0,124,135,65,0,124,143,69,0,124,151,73,0,124,159,77,0,124,167,
81,0,124,175,85,0,124,183,89,0,124,191,93,0,124,199,97,0,124,207,
101,0,124,215,105,0,124,223,109,0,124,239,117,0,124,247,121,0,224,55,
64,0,0,0,225,63,64,0,0,0,226,71,64,0,0,0,227,79,64,0,
0,0,124,55,133,0,124,63,137,0,124,71,141,0,124,79,145,0,240,95,
64,0,0,0,241,103,64,0,0,0,244,111,64,0,0,0,124,95,197,0,
124,103,201,0,124,111,213,0,229,15,64,0,193,14,128,0,186,5,6,64,
7,72,124,71,129,0,124,79,153,0,228,15,64,0,124,15,149,0,127,0,
0,0,60,55,129,0,60,63,153,0,229,15,64,0,193,14,128,0,170,37,
60,71,141,0,60,79,145,0,230,7,32,0,0,0,231,15,32,0,0,0,
232,23,32,0,0,0,233,31,32,0,0,0,60,95,197,0,60,103,201,0,
60,111,213,0,235,135,32,0,0,0,236,143,32,0,0,0,237,167,32,0,
0,0,0,0,165,37,60,71,133,0,60,79,137,0,232,7,32,0,0,0,
233,15,32,0,0,0,230,23,32,0,0,0,231,31,32,0,0,0,60,95,
197,0,60,103,201,0,60,111,213,0,235,135,32,0,0,0,236,143,32,0,
0,0,237,167,32,0,0,0,0,0,149,5,60,7,1,0,60,15,5,0,
60,23,9,0,60,31,13,0,60,39,17,0,60,47,21,0,60,55,25,0,
60,63,29,0,60,71,33,0,60,79,37,0,60,87,41,0,60,95,45,0,
60,103,49,0,60,111,53,0,60,119,57,0,60,127,61,0,60,135,65,0,
60,143,69,0,60,151,73,0,60,159,77,0,60,167,81,0,60,175,85,0,
60,183,89,0,60,191,93,0,60,199,97,0,60,207,101,0,60,215,105,0,
60,223,109,0,60,239,117,0,60,247,121,0,0,0,127,0,0,0,124,7,
1,0,124,15,5,0,124,23,9,0,124,31,13,0,124,39,17,0,124,47,
21,0,124,55,25,0,124,63,29,0,124,71,33,0,124,79,37,0,124,87,
41,0,124,95,45,0,124,103,49,0,124,111,53,0,124,119,57,0,124,127,
61,0,124,135,65,0,124,143,69,0,124,151,73,0,124,159,77,0,124,167,
81,0,124,175,85,0,124,183,89,0,124,191,93,0,124,199,97,0,124,207,
101,0,124,215,105,0,124,223,109,0,124,239,117,0,124,247,121,0,224,55,
64,0,0,0,225,63,64,0,0,0,226,71,64,0,0,0,227,79,64,0,
0,0,124,55,133,0,124,63,137,0,124,71,141,0,124,79,145,0,240,95,
64,0,0,0,241,103,64,0,0,0,242,111,64,0,0,0,243,119,64,0,
0,0,245,127,64,0,0,0,244,135,64,0,0,0,124,95,197,0,124,103,
201,0,124,111,205,0,124,119,209,0,124,127,217,0,124,135,213,0,124,111,
129,0,124,119,153,0,228,15,64,0,124,15,149,0,127,0,0,0,60,55,
129,0,60,63,209,0,60,127,217,0,230,151,32,0,0,0,231,159,32,0,
0,0,239,175,32,0,60,55,133,0,60,63,137,0,60,71,141,0,60,79,
145,0,230,7,32,0,0,0,231,15,32,0,0,0,232,23,32,0,0,0,
233,31,32,0,0,0,60,95,197,0,60,103,201,0,60,135,213,0,235,135,
32,0,0,0,236,143,32,0,0,0,240,167,32,0,0,0,60,7,1,0,
60,15,5,0,60,23,9,0,60,31,13,0,60,39,17,0,60,47,21,0,
60,55,25,0,60,63,29,0,60,71,33,0,60,79,37,0,60,87,41,0,
60,95,45,0,60,103,49,0,60,111,53,0,60,119,57,0,60,127,61,0,
60,135,65,0,60,143,69,0,60,151,73,0,60,159,77,0,60,167,81,0,
60,175,85,0,60,183,89,0,60,191,93,0,60,199,97,0,60,207,101,0,
60,215,105,0,60,223,109,0,60,239,117,0,60,247,121,0,0,0,127,0,
0,0,224,87,64,0,127,0,0,0,225,87,64,0,127,0,0,0,226,87,
64,0,127,0,0,0,227,87,64,0,127,0,0,0,229,87,64,0,127,0,
0,0,228,87,64,0,127,0,0,0,240,87,64,0,127,0,0,0,241,87,
64,0,127,0,0,0,242,87,64,0,127,0,0,0,243,87,64,0,127,0,
0,0,244,87,64,0,127,0,0,0,245,87,64,0,127,0,0,0,230,7,
32,0,127,0,0,0,230,15,32,0,127,0,0,0,230,23,32,0,127,0,
0,0,230,31,32,0,127,0,0,0,230,47,32,0,127,0,0,0,230,39,
32,0,127,0,0,0,230,135,32,0,127,0,0,0,230,143,32,0,127,0,
0,0,230,151,32,0,127,0,0,0,230,159,32,0,127,0,0,0,230,167,
32,0,127,0,0,0,230,175,32,0,127,0,0,0,64,14,134,0,33,14,
200,226,97,231,113,0,1,224,124,7,1,0,124,15,5,0,124,23,9,0,
124,31,13,0,124,39,17,0,124,47,21,0,124,55,25,0,124,63,29,0,
124,71,33,0,124,79,37,0,124,87,41,0,124,95,45,0,124,103,49,0,
124,111,53,0,124,119,57,0,124,127,61,0,124,135,65,0,124,143,69,0,
124,151,73,0,124,159,77,0,124,167,81,0,124,175,85,0,124,183,89,0,
124,191,93,0,124,199,97,0,124,207,101,0,124,215,105,0,124,223,109,0,
124,239,117,0,124,247,121,0,127,0,64,230,134,0,60,230,200,226,60,7,
1,0,60,15,5,0,60,23,9,0,60,31,13,0,60,39,17,0,60,47,
21,0,60,55,25,0,60,63,29,0,60,71,33,0,60,79,37,0,60,87,
41,0,60,95,45,0,60,103,49,0,60,111,53,0,60,119,57,0,60,127,
61,0,60,135,65,0,60,143,69,0,60,151,73,0,60,159,77,0,60,167,
81,0,60,175,85,0,60,183,89,0,60,191,93,0,60,199,97,0,60,207,
101,0,60,215,105,0,60,223,109,0,60,239,117,0,60,247,121,0,127,0,
64,254,134,0,63,254,224,227,127,7,1,0,127,15,5,0,127,23,9,0,
127,31,13,0,127,39,17,0,127,47,21,0,127,55,25,0,127,63,29,0,
127,71,33,0,127,79,37,0,127,87,41,0,127,95,45,0,127,103,49,0,
127,111,53,0,127,119,57,0,127,127,61,0,127,135,65,0,127,143,69,0,
127,151,73,0,127,159,77,0,127,167,81,0,127,175,85,0,127,183,89,0,
127,191,93,0,127,199,97,0,127,207,101,0,127,215,105,0,127,223,109,0,
127,231,113,0,127,239,117,0,127,247,121,0,224,55,64,0,0,0,225,63,
64,0,0,0,226,71,64,0,0,0,227,79,64,0,0,0,127,55,133,0,
127,63,137,0,127,71,141,0,127,79,145,0,240,95,64,0,0,0,241,103,
64,0,0,0,242,111,64,0,0,0,243,119,64,0,0,0,245,127,64,0,
0,0,244,135,64,0,0,0,127,95,197,0,127,103,201,0,127,111,205,0,
127,119,209,0,127,127,217,0,127,135,213,0,127,111,129,0,127,119,153,0,
228,15,64,0,127,15,149,0,64,30,155,0,35,30,8,172,64,254,130,0,
63,254,116,50,127,0,64,14,134,0,33,14,224,227,1,224,60,55,133,0,
60,63,137,0,60,71,141,0,60,79,145,0,230,7,32,0,0,0,231,15,
32,0,0,0,232,23,32,0,0,0,233,31,32,0,0,0,60,95,197,0,
60,103,201,0,60,135,213,0,235,135,32,0,0,0,236,143,32,0,0,0,
240,167,32,0,0,0,60,7,1,0,60,15,5,0,60,23,9,0,60,31,
13,0,60,39,17,0,60,47,21,0,60,55,25,0,60,63,29,0,60,71,
33,0,60,79,37,0,60,87,41,0,60,95,45,0,60,103,49,0,60,111,
53,0,60,119,57,0,60,127,61,0,60,135,65,0,60,143,69,0,60,151,
73,0,60,159,77,0,60,167,81,0,60,175,85,0,60,183,89,0,60,191,
93,0,60,199,97,0,60,207,101,0,60,215,105,0,60,223,109,0,60,239,
117,0,60,247,121,0,60,231,113,0,35,255,233,255,0,0,224,7,64,1,
35,15,1,0,68,26,92,26,99,255,1,0,64,254,153,0,63,254,40,48,
127,231,113,0,31,224,35,255,1,0,68,26,191,7,136,247,0,0,35,15,
1,0,68,26,92,26,99,255,1,0,64,254,153,0,63,254,40,48,127,231,
113,0,31,224,35,255,1,0,68,26,191,7,208,247,0,0,64,230,153,0,
60,230,40,48,124,231,113,0,124,255,125,0,191,255,54,248,191,7,50,247,
0,0,0,0,42,6,224,74,130,0,106,0,128,7,33,0,128,255,204,34,
64,14,153,0,97,7,53,53,64,14,153,0,97,7,33,53,64,6,63,0,
34,6,231,51,153,0,6,143,0,0,65,50,66,143,0,0,145,0,65,18,
224,137,138,253,38,6,228,51,153,0,166,17,6,240,128,19,2,82,129,83,
93,18,130,19,128,7,96,19,4,18,42,6,52,50,153,0,43,6,212,51,
153,0,165,13,44,6,240,240,240,240,107,103,1,0,68,90,106,103,1,0,
68,82,2,136,95,18,224,137,202,245,127,0,128,7,33,0,4,18,42,6,
52,50,153,0,43,6,212,51,153,0,42,135,1,0,49,6,240,240,240,240,
68,82,241,129,154,13,43,119,1,0,47,6,240,240,240,240,68,90,239,113,
146,13,38,6,0,223,133,0,191,255,108,255,191,255,152,255,181,5,95,18,
250,229,64,6,63,0,197,5,70,23,0,0,65,50,7,23,0,0,65,58,
224,17,154,253,6,80,127,0,128,7,225,0,6,232,39,6,76,224,133,0,
191,255,222,255,10,224,128,255,30,35,28,48,10,56,191,255,208,255,10,48,
39,6,100,224,133,0,191,255,196,255,189,81,64,6,255,0,7,240,96,136,
70,143,0,0,97,128,70,135,1,0,98,120,70,127,2,0,99,112,6,86,
4,0,70,119,3,0,127,0,0,18,181,13,65,18,104,18,250,5,32,22,
48,0,71,23,0,0,65,58,149,29,196,50,64,134,0,240,70,129,178,245,
149,21,64,86,0,240,70,81,156,82,32,94,87,0,106,82,190,5,32,94,
48,0,202,89,71,95,0,0,65,58,196,50,65,18,104,18,246,237,71,7,
0,0,127,0,190,7,33,0,3,30,180,255,7,80,3,56,213,5,71,23,
0,0,65,58,65,50,6,23,0,0,224,17,154,253,10,48,191,255,148,255,
3,48,191,255,130,254,3,30,76,0,126,6,63,0,132,7,225,0,34,6,
100,55,153,0,3,240,1,21,66,55,0,0,0,141,64,134,153,0,65,138,
1,141,16,135,98,54,61,6,228,52,153,0,224,129,194,21,64,86,153,0,
42,119,132,56,206,118,0,255,168,114,81,119,0,0,0,93,65,90,1,93,
42,87,132,56,75,87,0,0,0,133,65,130,1,133,60,6,64,53,153,0,
97,50,209,37,186,5,128,7,246,2,99,50,185,5,128,7,226,2,186,5,
128,7,232,2,100,50,186,5,128,7,214,1,103,50,185,5,128,7,182,2,
186,5,128,7,210,2,6,6,224,255,178,5,128,7,188,2,35,55,1,0,
191,255,160,254,3,240,0,21,202,17,1,21,128,7,180,2,64,22,153,0,
34,23,117,56,224,17,186,5,128,7,52,1,98,18,186,5,128,7,44,1,
111,18,194,21,2,6,240,255,194,77,2,6,238,255,242,93,2,22,230,255,
98,18,185,5,128,7,16,1,210,109,99,18,186,5,128,7,14,1,128,7,
114,2,3,240,0,125,29,119,0,0,79,119,0,0,0,53,61,62,4,0,
65,50,1,53,191,255,104,254,99,87,1,0,10,48,61,62,8,0,191,255,
90,254,99,87,1,0,10,48,61,62,12,0,191,255,76,254,99,87,1,0,
10,48,61,62,32,0,191,255,62,254,99,87,1,0,10,48,61,62,36,0,
191,255,48,254,99,87,1,0,10,48,61,62,40,0,191,255,34,254,99,87,
1,0,10,48,61,62,44,0,191,255,20,254,99,87,1,0,128,7,252,1,
29,240,100,96,0,109,12,16,130,0,197,5,141,23,1,0,65,106,3,240,
0,93,12,136,75,23,0,0,0,85,95,98,65,82,1,85,224,137,186,245,
128,7,208,1,61,127,0,0,3,240,0,133,207,126,0,255,168,122,80,127,
0,0,0,101,61,95,0,0,65,98,1,101,76,95,0,0,0,141,65,138,
1,141,128,7,166,1,35,55,1,0,28,56,191,255,172,253,0,234,181,13,
10,48,29,56,194,58,45,6,68,53,153,0,205,57,191,255,150,253,65,234,
60,103,1,0,99,87,1,0,236,233,150,245,128,7,116,1,35,55,1,0,
29,56,181,181,3,240,0,93,157,87,1,0,75,87,0,0,0,141,61,135,
2,0,65,138,1,141,208,134,0,255,168,130,81,135,0,0,0,109,61,103,
2,0,65,106,1,109,77,103,0,0,0,85,0,18,65,82,1,85,229,13,
61,135,5,0,3,240,0,141,194,129,16,119,0,0,81,119,0,0,0,109,
65,18,65,106,1,109,61,103,2,0,236,17,134,245,128,7,14,1,3,240,
29,87,0,0,0,93,75,87,0,0,0,141,29,23,0,0,65,138,1,141,
98,18,209,21,226,29,99,18,162,13,102,18,193,117,178,21,104,18,209,13,
178,37,105,18,194,69,213,109,35,55,1,0,61,62,4,0,191,255,224,252,
99,87,1,0,3,48,128,255,230,22,149,101,35,55,1,0,61,62,4,0,
191,7,180,254,35,55,1,0,61,62,4,0,191,255,188,252,99,87,1,0,
10,48,61,62,8,0,191,7,154,254,61,62,4,0,61,239,5,0,176,234,
97,234,174,5,1,234,29,6,193,255,185,5,32,238,62,0,35,55,1,0,
191,255,140,252,1,226,197,13,28,48,128,255,90,26,3,240,0,53,35,62,
4,0,3,85,191,255,116,252,65,226,99,87,1,0,253,225,166,245,181,45,
35,55,1,0,28,56,191,7,74,254,64,102,153,0,44,103,109,56,3,240,
0,117,140,103,1,0,78,103,0,0,0,93,64,22,153,0,65,90,1,93,
34,246,108,56,0,141,65,138,1,141,64,22,153,0,34,246,112,56,0,125,
15,134,255,255,1,133,224,121,186,229,245,5,6,56,38,6,56,223,133,0,
191,255,128,252,35,111,1,0,38,6,99,55,153,0,166,105,95,106,70,111,
0,0,128,255,158,14,68,6,255,0,64,14,153,0,33,247,105,56,96,136,
70,143,0,0,97,128,70,135,1,0,98,120,70,127,2,0,99,112,68,242,
70,119,3,0,97,247,105,56,127,0,128,7,225,16,61,6,104,56,153,0,
60,6,120,56,153,0,6,56,59,6,99,54,153,0,27,48,128,255,60,15,
29,240,1,221,155,143,1,0,64,14,153,0,65,218,64,118,153,0,97,143,
117,56,1,221,14,119,98,54,224,113,178,5,66,218,1,221,64,22,153,0,
34,23,117,56,97,18,129,45,130,53,99,18,177,61,130,77,102,18,161,69,
178,85,103,18,178,93,105,18,211,61,2,6,240,255,194,77,2,6,238,255,
146,109,2,6,236,255,130,101,2,6,234,255,210,117,2,6,230,255,226,45,
2,6,229,255,178,45,2,6,227,255,130,125,2,6,206,255,186,5,128,7,
2,1,128,7,14,1,29,240,0,133,144,87,1,0,92,87,0,0,65,130,
1,133,213,125,61,119,1,0,29,240,0,101,142,119,1,0,60,54,4,0,
65,98,1,101,92,119,0,0,197,13,28,48,191,255,14,255,29,240,0,133,
144,87,1,0,124,87,9,0,245,229,28,48,191,255,250,254,165,101,28,48,
191,255,242,254,60,54,4,0,191,255,234,254,29,240,0,101,140,119,1,0,
124,119,9,0,133,29,28,48,191,255,214,254,29,240,0,133,144,87,1,0,
92,87,4,0,181,205,28,48,191,255,194,254,60,54,4,0,191,255,186,254,
29,240,0,101,140,119,1,0,92,119,8,0,65,98,1,101,165,61,38,6,
112,223,133,0,191,255,168,249,197,53,29,240,0,93,139,87,1,0,11,118,
1,0,1,117,200,82,124,87,0,0,171,111,1,0,205,81,124,87,0,0,
65,114,1,117,165,37,61,119,1,0,29,240,0,101,142,119,1,0,65,98,
1,101,124,119,5,0,165,181,149,181,29,240,0,133,144,87,1,0,65,130,
1,133,92,87,0,0,144,127,1,0,92,127,1,0,165,141,29,240,0,141,
145,95,1,0,65,138,1,141,92,95,0,0,64,6,255,16,64,14,153,0,
97,7,65,53,34,6,60,53,153,0,2,240,1,53,0,141,224,137,242,5,
64,134,153,0,48,135,81,54,98,135,1,0,34,127,1,0,64,14,153,0,
0,50,97,127,229,52,191,7,144,250,128,7,97,0,61,6,228,52,153,0,
0,82,125,7,2,0,224,49,154,13,7,48,61,62,2,0,61,70,4,0,
128,255,240,24,229,5,97,50,202,5,7,48,128,255,234,24,93,87,0,0,
0,50,191,255,88,250,64,6,127,0,128,7,225,16,1,18,64,14,153,0,
97,23,29,53,0,234,7,216,6,224,28,56,27,64,0,50,128,255,148,28,
224,81,226,23,0,0,64,14,153,0,97,23,25,53,64,22,153,0,34,23,
25,53,224,17,234,5,28,48,27,56,128,255,160,25,10,232,64,14,153,0,
97,7,29,53,29,80,64,6,255,16,128,7,225,0,6,224,64,14,153,0,
97,231,229,52,199,238,255,0,64,14,153,0,97,239,233,52,197,13,29,48,
220,49,1,58,191,255,142,255,64,134,153,0,48,135,25,53,224,129,218,5,
29,120,95,234,224,121,170,245,64,110,153,0,45,111,25,53,224,105,234,55,
0,0,191,255,184,249,64,6,255,0,128,7,33,0,191,255,92,255,64,14,
153,0,97,87,229,52,64,134,153,0,48,135,25,53,224,129,234,55,0,0,
191,255,146,249,64,6,63,0,128,7,225,0,6,224,28,232,133,13,64,142,
153,0,49,143,25,53,224,137,138,13,65,234,29,48,1,58,191,255,30,255,
224,81,202,245,188,233,64,14,153,0,97,239,229,52,64,118,153,0,46,119,
25,53,224,113,234,55,0,0,191,255,78,249,64,6,255,0,128,7,33,0,
1,18,64,14,153,0,97,23,25,53,64,14,153,0,97,23,29,53,224,65,
242,5,64,14,153,0,97,7,25,53,128,255,178,23,64,14,153,0,97,7,
29,53,64,6,63,0,128,7,225,0,6,232,7,224,128,255,196,25,29,48,
28,56,128,255,92,27,64,6,255,0,128,7,225,0,6,232,8,224,191,255,
174,255,64,142,153,0,49,143,25,53,224,137,218,5,29,48,28,56,191,255,
204,255,64,118,153,0,46,119,25,53,224,113,234,55,0,0,191,255,206,248,
64,6,255,0,128,7,225,240,6,192,7,216,155,0,61,6,24,53,153,0,
24,224,27,208,181,37,64,142,153,0,49,143,105,56,64,22,153,0,28,48,
145,207,1,0,65,138,98,143,105,56,1,66,25,56,191,255,78,255,61,111,
1,0,224,105,186,21,28,48,1,58,191,255,52,254,249,81,194,5,1,18,
125,23,1,0,61,103,1,0,224,97,234,5,65,226,26,88,95,210,224,89,
186,221,61,87,1,0,224,81,218,5,24,48,27,56,191,255,68,255,61,119,
1,0,224,113,234,55,0,0,191,255,74,248,64,6,255,240,128,7,225,241,
6,192,7,184,8,224,156,0,57,6,24,53,153,0,1,218,24,232,23,208,
23,16,184,17,97,18,186,5,29,48,229,13,98,18,250,29,29,48,28,56,
1,66,191,255,206,254,57,223,1,0,224,217,218,61,29,54,1,0,28,56,
1,66,191,255,186,254,57,223,1,0,224,217,226,45,165,53,29,48,28,56,
1,66,191,255,166,254,57,223,1,0,65,234,224,217,138,45,221,126,3,0,
226,13,250,233,161,245,181,13,95,210,26,48,28,56,1,66,191,255,132,254,
57,223,1,0,224,217,138,29,218,110,3,0,178,5,250,233,161,245,253,209,
194,13,28,56,200,58,28,57,200,58,28,57,200,58,28,57,29,48,26,64,
189,65,229,205,24,48,23,56,184,57,191,255,128,254,224,217,234,55,0,0,
191,255,138,247,64,6,255,241,128,7,225,16,7,216,64,62,153,0,39,63,
69,54,6,224,7,22,255,255,97,18,179,5,99,18,234,13,28,48,191,255,
20,253,64,70,153,0,40,71,69,54,10,232,28,48,27,56,191,255,12,254,
245,5,38,6,156,223,133,0,191,255,188,245,31,234,29,80,64,6,255,16,
128,7,225,0,6,224,42,6,180,59,153,0,31,234,0,18,0,90,197,21,
2,136,195,138,81,142,153,0,49,103,149,56,252,97,210,53,224,97,218,5,
127,234,202,5,2,232,165,5,65,90,65,18,2,6,156,255,222,5,42,111,
1,0,237,89,166,237,127,234,170,5,2,232,10,240,0,101,65,98,1,101,
12,6,156,255,215,5,95,98,1,101,3,82,149,29,195,234,93,238,153,0,
125,231,149,56,64,62,153,0,39,63,65,54,28,48,61,238,148,56,191,255,
66,255,125,87,5,0,64,62,153,0,39,63,69,54,28,48,191,255,158,253,
0,82,64,6,255,0,128,7,225,48,6,216,0,226,0,210,229,53,28,232,
195,234,93,238,153,0,61,55,149,56,61,238,148,56,224,49,130,45,224,217,
210,5,230,217,178,5,65,210,165,37,61,63,5,0,191,255,246,254,64,22,
153,0,34,23,65,54,226,81,130,13,61,63,1,0,38,6,188,223,133,0,
191,255,44,246,61,55,1,0,4,58,191,255,64,253,64,22,153,0,34,246,
180,59,0,109,125,7,1,0,95,106,1,109,224,217,218,13,65,226,28,6,
156,255,254,5,64,102,153,0,44,103,181,59,236,209,230,197,224,217,186,5,
0,82,165,5,7,82,64,6,255,48,0,18,2,136,195,138,81,142,153,0,
113,7,149,56,65,18,2,6,156,255,246,245,64,14,153,0,97,7,181,59,
127,0,128,7,33,0,128,255,10,10,64,14,153,0,97,7,41,53,64,14,
153,0,97,7,37,53,31,18,64,14,153,0,97,23,49,53,128,255,188,9,
64,14,153,0,65,7,96,54,64,14,153,0,65,7,98,54,191,255,170,255,
64,14,153,0,97,7,145,56,64,14,153,0,97,7,61,53,64,14,153,0,
97,7,185,59,64,14,153,0,65,7,97,54,64,6,63,0,128,7,33,0,
128,255,240,23,128,255,230,23,64,6,63,0,128,7,33,0,191,255,142,255,
191,255,232,255,64,22,153,0,34,23,120,56,64,14,153,0,32,86,100,0,
224,17,234,143,0,0,65,143,98,54,127,18,162,5,2,80,64,14,153,0,
97,87,132,56,64,14,153,0,97,87,228,52,64,54,153,0,64,62,153,0,
39,63,93,54,134,55,61,54,128,255,138,14,64,6,63,0,128,7,33,0,
0,50,191,255,136,254,1,18,64,14,153,0,65,23,96,54,0,50,191,255,
32,245,128,255,2,9,64,6,63,0,128,7,97,0,8,232,128,255,240,17,
224,233,146,13,1,18,64,14,153,0,65,23,228,52,4,50,191,255,250,244,
224,233,226,87,0,0,64,6,127,0,128,7,225,16,64,14,153,0,97,7,
29,53,64,14,153,0,97,7,145,56,64,142,153,0,17,143,96,54,61,6,
120,56,153,0,60,6,228,52,153,0,0,218,224,137,210,13,64,134,153,0,
48,135,33,53,224,129,186,5,128,7,218,1,64,14,153,0,65,7,96,54,
0,50,191,255,56,248,64,62,153,0,39,63,117,56,7,16,2,6,206,255,
209,37,2,6,226,255,185,5,128,7,160,1,66,0,82,0,87,0,93,0,
104,0,111,0,111,0,140,0,146,0,153,0,158,0,37,0,205,0,172,0,
37,0,186,0,43,0,75,0,205,0,164,0,205,0,205,0,192,0,175,0,
205,0,192,0,205,0,99,0,62,0,53,0,68,0,2,6,206,255,186,5,
128,7,70,1,128,7,84,1,32,54,32,0,191,255,54,244,128,7,82,1,
128,255,138,16,7,18,28,240,17,21,64,118,153,0,46,119,81,54,23,117,
0,50,191,255,24,244,64,14,153,0,97,7,65,53,128,7,44,1,61,55,
1,0,191,255,66,249,128,7,32,1,29,240,97,56,96,48,191,255,106,249,
128,7,18,1,29,240,100,56,0,53,191,255,232,249,128,7,4,1,157,55,
1,0,128,255,250,12,197,125,29,240,2,61,96,48,128,255,28,13,229,117,
29,240,4,61,0,53,191,255,20,250,133,117,61,55,1,0,191,255,48,250,
181,109,29,240,4,69,2,61,0,53,191,255,176,250,197,101,128,255,184,13,
61,23,1,0,97,18,162,13,64,134,153,0,48,135,57,54,194,130,80,134,
153,0,112,23,209,59,64,102,153,0,44,103,117,56,100,98,186,85,128,255,
224,7,1,18,64,14,153,0,97,23,145,56,181,77,29,240,100,56,0,53,
191,255,160,250,149,69,29,240,104,64,2,61,0,53,191,255,22,251,165,61,
61,55,1,0,191,255,20,252,213,5,61,55,1,0,191,255,156,252,10,48,
197,133,191,255,178,253,1,18,64,14,153,0,65,23,97,54,245,37,191,255,
246,253,133,45,29,240,2,21,0,53,194,70,2,0,194,62,1,0,191,255,
4,254,10,216,149,29,7,18,92,23,0,0,4,50,191,7,210,254,38,6,
28,224,133,0,213,13,29,87,0,0,64,14,153,0,0,50,97,87,185,59,
191,7,184,254,38,6,244,223,133,0,191,255,178,242,224,217,186,5,191,7,
54,254,64,6,255,16,128,7,97,0,128,255,230,16,64,22,153,0,34,23,
57,54,61,6,208,59,153,0,194,18,221,17,34,119,1,0,47,6,220,75,
130,0,239,113,250,5,64,110,153,0,45,111,77,54,98,111,1,0,191,255,
114,241,64,102,153,0,44,103,145,56,224,97,178,5,128,255,4,11,64,86,
153,0,42,87,137,56,202,94,17,0,194,13,9,18,129,82,169,5,7,18,
64,14,153,0,65,23,228,52,4,50,191,255,108,242,64,142,153,0,209,223,
136,56,146,13,64,54,153,0,38,55,141,56,128,255,132,12,224,81,178,5,
191,255,98,253,64,134,153,0,48,135,57,54,194,130,221,129,48,111,1,0,
64,14,153,0,97,111,77,54,128,255,144,16,64,6,127,0,128,7,97,0,
128,255,184,15,64,22,153,0,34,23,57,54,61,6,208,59,153,0,194,18,
221,17,34,119,1,0,47,6,94,75,130,0,239,113,250,5,64,110,153,0,
45,111,77,54,98,111,1,0,191,255,200,240,64,102,153,0,44,103,145,56,
224,97,178,5,128,255,90,10,64,86,153,0,42,87,137,56,202,94,17,0,
194,13,9,18,129,82,169,5,7,18,64,14,153,0,65,23,228,52,4,50,
191,255,194,241,64,142,153,0,209,223,136,56,146,13,64,54,153,0,38,55,
141,56,128,255,218,11,224,81,178,5,191,255,184,252,64,134,153,0,48,135,
57,54,194,130,221,129,48,111,1,0,64,14,153,0,97,111,77,54,128,255,
88,15,64,6,127,0,128,7,225,16,7,216,6,224,128,255,82,18,10,232,
224,233,170,5,8,234,41,6,20,53,153,0,29,136,130,138,169,109,34,6,
56,53,153,0,2,240,0,125,64,134,153,0,48,135,81,54,65,122,1,125,
239,129,203,13,64,14,153,0,97,7,57,53,64,22,153,0,34,246,52,53,
0,117,65,114,1,117,64,22,153,0,34,111,41,53,34,22,40,53,224,105,
210,37,2,240,0,101,45,6,36,53,153,0,95,98,1,101,186,13,13,240,
64,86,153,0,42,87,89,54,0,93,170,89,1,93,98,135,1,0,13,240,
64,134,153,0,48,135,85,54,0,141,176,137,1,141,172,13,1,82,64,14,
153,0,97,87,45,53,98,7,1,0,109,7,1,0,64,126,153,0,47,127,
61,53,224,121,130,37,41,119,1,0,224,113,202,29,64,86,153,0,42,23,
65,53,42,86,64,53,2,6,196,255,193,13,59,135,1,0,2,120,194,18,
66,22,153,0,98,135,69,53,65,122,106,127,1,0,42,119,1,0,14,6,
196,255,186,5,157,238,16,0,221,110,25,0,242,29,41,23,1,0,224,17,
146,45,64,102,153,0,44,103,29,53,224,97,226,13,28,48,128,255,248,13,
224,81,146,13,1,18,64,14,153,0,97,23,25,53,32,86,156,255,229,37,
129,234,137,13,1,18,64,14,153,0,97,23,33,53,31,82,213,29,59,55,
1,0,28,56,128,255,116,12,128,255,36,18,191,255,160,250,191,255,124,229,
133,5,64,14,153,0,97,23,33,53,1,18,105,23,1,0,64,14,153,0,
97,239,137,56,64,14,153,0,97,231,141,56,0,82,64,6,255,16,128,7,
33,0,128,255,100,18,128,255,90,18,64,6,63,0,128,7,33,0,1,18,
64,14,153,0,97,23,21,53,191,255,226,255,128,255,44,16,31,18,64,14,
153,0,97,23,93,54,128,255,158,17,64,142,153,0,49,143,81,54,224,137,
234,5,31,18,64,14,153,0,97,23,53,53,191,255,202,249,191,255,100,238,
64,14,153,0,97,7,137,56,64,6,63,0,128,7,33,0,64,14,153,0,
97,7,41,53,64,14,153,0,97,7,37,53,31,18,64,14,153,0,97,23,
49,53,64,14,153,0,97,7,61,53,6,18,64,14,153,0,65,23,228,52,
64,14,153,0,97,55,233,52,4,50,191,255,116,239,128,255,86,17,64,6,
63,0,128,7,225,16,0,218,0,226,0,50,128,255,152,12,10,232,1,50,
128,255,144,12,10,56,98,234,146,21,99,234,226,53,108,234,145,93,130,21,
110,234,209,21,130,77,29,6,240,255,169,53,194,45,29,6,236,255,226,61,
213,77,7,48,191,255,124,255,149,85,64,14,153,0,33,246,48,53,0,229,
1,61,229,93,64,22,153,0,34,23,81,54,31,226,224,17,242,85,64,14,
153,0,97,7,41,53,64,14,153,0,97,7,45,53,64,14,153,0,33,246,
36,53,0,229,1,61,224,57,242,69,64,14,153,0,97,23,41,53,165,69,
29,48,128,255,104,12,10,224,213,61,7,54,255,255,0,58,1,66,191,255,
134,245,64,134,153,0,48,135,25,53,224,129,234,223,0,0,27,224,128,225,
213,45,0,218,0,226,165,45,64,126,153,0,47,127,81,54,64,230,153,0,
60,231,53,53,224,121,138,37,61,6,14,0,1,0,64,118,224,255,93,113,
1,218,226,5,4,50,191,255,136,238,1,82,245,29,64,102,255,255,93,97,
242,13,8,18,64,14,153,0,65,23,228,52,64,14,153,0,97,239,233,52,
4,50,191,255,100,238,27,80,213,13,64,70,153,0,40,71,145,56,27,56,
28,48,191,255,60,249,64,86,153,0,42,87,145,56,64,6,255,16,245,5,
38,143,1,0,68,50,103,143,1,0,68,58,8,128,95,66,224,129,250,245,
127,0,128,7,225,16,6,224,7,216,224,225,186,5,28,80,197,13,0,234,
245,5,220,81,10,55,0,0,128,255,56,16,65,234,29,80,251,233,134,253,
64,6,255,16,128,7,225,0,64,142,153,0,49,143,197,59,6,232,157,231,
1,0,224,137,226,29,64,22,153,0,34,246,188,59,0,125,65,122,1,125,
15,6,235,255,185,13,64,14,153,0,97,7,189,59,38,6,30,225,133,0,
191,255,60,236,133,5,189,119,1,0,98,114,226,5,38,6,50,225,133,0,
191,255,40,236,0,130,29,22,1,0,229,5,130,111,1,0,65,18,205,129,
144,0,28,88,221,89,65,90,235,17,241,245,66,135,0,0,28,62,2,0,
29,48,191,255,96,255,189,119,1,0,98,114,130,13,64,22,153,0,34,246,
196,59,0,109,65,106,1,109,64,6,255,0,64,22,153,0,34,246,196,59,
0,141,64,22,153,0,162,63,99,55,34,54,99,55,65,138,1,141,66,58,
191,7,38,255,128,7,33,0,64,22,153,0,34,23,197,59,38,6,192,59,
153,0,6,240,4,58,2,142,20,0,130,19,131,139,191,255,4,255,64,22,
153,0,34,246,196,59,0,133,65,130,1,133,64,6,63,0,130,7,225,243,
6,224,99,63,1,0,58,6,32,53,153,0,28,192,128,255,4,15,224,81,
222,5,58,143,1,0,224,137,146,253,58,135,1,0,224,129,162,5,0,82,
54,6,196,59,153,0,10,232,157,0,29,216,0,202,133,13,128,255,218,14,
88,87,0,0,202,201,153,0,65,194,224,81,134,21,27,104,95,218,155,0,
224,105,186,245,58,103,1,0,224,97,234,29,128,255,182,14,10,184,151,0,
224,81,142,29,106,234,178,5,109,234,218,61,65,218,253,217,242,5,156,111,
1,0,106,106,178,5,109,106,202,53,28,48,191,255,192,235,28,48,10,56,
191,255,94,254,118,7,1,0,149,189,249,185,186,5,224,233,138,29,128,255,
116,14,224,81,222,253,35,159,1,0,224,153,178,13,58,143,1,0,224,137,
242,5,14,18,92,23,0,0,122,7,1,0,245,21,191,255,6,255,122,7,
1,0,229,157,156,135,1,0,16,6,236,255,218,13,54,119,1,0,188,127,
1,0,239,113,207,5,191,255,198,254,133,149,191,255,224,254,213,141,118,7,
1,0,29,80,66,6,255,243,64,22,153,0,34,246,192,59,2,82,128,83,
32,86,20,0,129,83,130,3,131,83,64,14,153,0,97,7,197,59,64,14,
153,0,97,7,189,59,64,14,153,0,97,7,33,53,127,0,32,142,3,14,
64,14,153,0,97,143,53,54,3,130,64,14,153,0,97,135,61,54,32,126,
32,0,64,14,153,0,97,127,57,54,128,118,64,248,64,14,153,0,97,119,
65,54,2,106,64,14,153,0,97,111,69,54,32,102,0,16,64,14,153,0,
97,103,73,54,64,14,153,0,97,7,218,61,127,0,128,7,225,112,2,210,
64,142,153,0,49,143,57,54,17,128,194,130,16,136,46,6,208,59,153,0,
17,120,206,121,47,239,1,0,29,48,2,58,191,255,38,241,202,0,10,16,
2,104,13,96,167,98,204,94,15,0,11,80,138,0,10,200,2,136,17,128,
165,130,208,126,63,0,15,112,142,0,14,216,25,104,107,106,211,13,2,208,
208,210,29,102,2,0,12,48,2,58,191,255,236,240,10,224,26,225,4,210,
165,5,2,224,64,14,153,0,97,7,218,61,25,88,107,90,250,69,1,82,
64,14,153,0,97,87,218,61,29,142,2,0,64,14,153,0,97,143,229,61,
64,54,153,0,38,55,229,61,2,58,191,255,176,240,202,0,64,14,153,0,
97,87,220,61,64,54,153,0,38,55,229,61,64,70,153,0,40,71,69,54,
128,62,64,248,191,255,152,241,64,54,153,0,38,55,229,61,64,134,153,0,
48,135,69,54,16,56,191,255,180,241,28,120,131,122,207,118,14,0,28,104,
135,106,205,102,240,1,12,216,14,217,27,88,136,90,11,80,128,81,32,134,
0,254,10,136,80,137,27,16,17,17,2,120,207,233,128,7,204,2,27,112,
98,114,170,45,28,104,139,106,205,102,31,0,224,97,138,37,26,88,11,80,
221,81,220,142,31,0,17,120,194,122,15,128,45,6,208,59,153,0,16,112,
205,113,46,95,1,0,11,96,193,98,12,216,202,217,27,80,193,82,10,48,
2,58,191,255,4,240,10,16,2,136,218,137,209,233,128,7,124,2,26,128,
208,233,128,7,116,2,27,120,99,122,186,29,28,112,139,114,206,110,31,0,
224,105,154,21,220,102,31,0,12,80,194,82,10,88,48,6,208,59,153,0,
11,136,208,137,49,239,1,0,30,122,79,233,128,7,66,2,26,112,206,233,
128,7,58,2,27,104,13,6,240,255,210,5,27,96,12,6,239,255,170,45,
28,88,139,90,203,86,31,0,224,81,138,37,48,6,208,59,153,0,16,142,
212,0,220,126,63,0,15,112,193,114,49,111,1,0,14,216,205,217,27,48,
2,58,191,255,120,239,202,0,10,16,43,6,208,59,153,0,11,102,212,0,
2,80,44,143,1,0,10,232,209,233,128,7,224,1,26,128,208,233,128,7,
216,1,27,120,15,6,207,255,234,13,28,112,155,114,206,110,31,0,224,105,
202,5,70,234,128,7,190,1,26,96,204,233,128,7,182,1,27,88,11,6,
206,255,242,5,27,80,10,6,205,255,178,5,128,7,8,1,28,136,155,138,
209,134,31,0,224,129,170,125,220,126,31,0,224,121,226,117,220,118,31,0,
14,6,236,255,201,101,220,222,224,255,219,110,0,15,27,96,136,98,204,94,
240,0,11,80,13,81,27,136,133,138,209,134,1,0,16,120,10,121,27,112,
132,114,206,110,12,0,13,96,15,97,28,88,144,90,203,86,1,0,10,136,
193,138,17,128,12,129,16,120,207,0,15,80,220,118,31,0,14,110,236,255,
32,102,0,8,12,16,237,23,160,0,10,88,2,80,75,81,224,81,130,45,
48,6,208,59,153,0,16,142,12,0,28,120,144,122,15,112,193,114,206,110,
124,0,49,95,1,0,13,96,203,97,2,80,10,128,194,130,16,136,17,126,
252,255,15,216,204,217,27,48,2,58,191,255,108,238,10,232,27,118,2,0,
14,48,2,58,191,255,94,238,10,16,2,104,208,106,13,233,181,109,220,102,
31,0,12,80,194,82,10,88,48,6,208,59,153,0,11,136,208,137,49,239,
1,0,229,93,220,126,31,0,15,104,194,106,13,112,43,6,208,59,153,0,
14,96,203,97,44,239,1,0,149,85,26,80,202,233,229,77,27,136,17,6,
196,255,210,5,27,128,16,6,195,255,250,53,220,126,1,0,224,121,186,21,
46,6,254,255,63,0,28,216,78,217,27,104,149,106,13,96,128,97,64,86,
192,255,12,88,74,89,27,16,11,17,2,136,209,233,133,53,28,128,155,130,
208,126,31,0,224,121,202,13,220,118,31,0,107,114,226,5,220,110,31,0,
13,6,237,255,186,5,70,234,245,29,28,96,155,98,0,90,224,89,130,13,
220,86,31,0,10,6,229,255,186,5,72,234,181,21,26,136,209,233,133,21,
48,6,68,1,224,7,240,225,154,13,46,6,208,59,153,0,14,126,196,0,
47,239,1,0,181,5,26,104,205,233,64,14,153,0,97,239,225,61,29,48,
2,58,191,255,112,237,202,0,64,14,153,0,97,87,216,61,29,48,64,70,
153,0,40,71,69,54,128,62,64,248,191,255,94,238,29,48,64,102,153,0,
44,103,69,54,12,56,191,255,128,238,64,6,255,112,128,7,33,0,64,54,
153,0,38,55,225,61,64,142,153,0,241,143,217,61,17,56,64,70,153,0,
40,71,69,54,191,255,40,238,64,54,153,0,38,55,225,61,64,134,153,0,
48,135,69,54,16,56,191,255,68,238,64,126,153,0,239,127,219,61,224,121,
178,29,64,54,153,0,38,55,229,61,64,118,153,0,238,119,221,61,14,56,
64,70,153,0,40,71,69,54,191,255,232,237,64,54,153,0,38,55,229,61,
64,110,153,0,45,111,69,54,13,56,191,255,4,238,43,6,208,59,153,0,
11,102,204,0,12,80,42,143,1,0,94,138,106,143,1,0,64,14,153,0,
97,7,220,61,64,14,153,0,97,7,216,61,64,14,153,0,97,7,218,61,
64,6,63,0,128,7,33,0,6,16,130,0,2,128,194,130,16,136,46,6,
208,59,153,0,17,120,206,121,47,111,1,0,64,14,153,0,97,111,229,52,
0,50,191,255,188,230,64,6,63,0,128,7,33,0,6,16,130,0,2,128,
194,130,16,136,46,6,208,59,153,0,17,120,206,121,111,63,1,0,0,50,
191,255,150,230,64,6,63,0,0,66,38,79,1,0,0,18,2,128,194,130,
16,136,46,6,212,60,153,0,17,120,206,121,2,96,194,98,12,104,42,6,
208,59,153,0,13,88,202,89,43,143,1,0,47,135,1,0,241,129,178,5,
65,66,168,0,65,18,162,0,2,120,15,6,191,255,182,229,65,74,9,118,
255,255,8,104,141,0,78,111,0,0,0,18,2,88,194,90,11,96,49,6,
212,60,153,0,12,80,209,81,2,120,194,122,15,128,45,6,208,59,153,0,
16,112,205,113,46,103,1,0,42,95,1,0,236,89,130,13,65,74,9,86,
255,255,2,136,145,0,74,143,0,0,65,18,162,0,2,128,16,6,191,255,
230,221,102,79,1,0,127,0,128,7,33,0,38,6,208,59,153,0,39,6,
212,60,153,0,32,70,65,0,191,255,154,247,64,6,63,0,128,7,225,0,
6,224,28,16,32,150,68,0,242,17,242,5,32,150,96,0,242,17,146,29,
128,7,158,1,64,142,153,0,49,143,57,54,17,128,194,130,16,136,46,6,
208,59,153,0,17,120,206,121,47,111,1,0,92,106,111,111,1,0,191,255,
44,246,10,16,128,7,140,1,64,102,153,0,44,103,57,54,12,88,194,90,
11,96,49,6,208,59,153,0,12,80,209,81,42,135,1,0,94,130,106,135,
1,0,64,126,153,0,47,127,145,56,224,121,226,77,64,118,153,0,46,119,
57,54,14,104,194,106,13,112,43,6,208,59,153,0,14,96,203,97,44,55,
1,0,2,58,191,255,238,234,10,232,208,234,64,142,153,0,49,143,57,54,
17,128,194,130,16,136,46,6,208,59,153,0,17,120,206,121,47,87,1,0,
66,82,10,48,2,58,191,255,196,234,10,233,29,104,135,106,205,102,15,0,
12,88,139,0,11,16,49,6,1,0,224,7,29,80,81,81,64,134,224,7,
240,81,154,21,2,120,103,122,225,13,2,112,111,114,187,13,3,106,64,14,
153,0,65,111,228,52,64,14,153,0,97,231,233,52,181,101,1,98,64,14,
153,0,65,103,228,52,213,93,64,94,153,0,43,95,57,54,11,80,194,82,
10,88,48,6,208,59,153,0,11,136,208,137,49,55,1,0,2,58,191,255,
84,234,170,6,64,248,234,5,64,14,153,0,65,7,228,52,197,69,64,126,
153,0,47,127,57,54,15,112,194,114,14,120,44,6,208,59,153,0,15,104,
204,105,45,55,1,0,2,58,191,255,34,234,170,6,64,216,218,29,7,90,
64,14,153,0,65,95,228,52,64,86,153,0,42,87,57,54,10,136,194,138,
17,80,47,6,208,59,153,0,10,128,207,129,48,55,1,0,64,118,153,0,
238,119,245,61,14,56,2,66,191,255,240,234,197,21,3,106,64,14,153,0,
65,111,228,52,64,14,153,0,97,231,233,52,165,13,3,98,64,14,153,0,
65,103,228,52,64,14,153,0,97,231,233,52,4,50,191,255,8,228,1,18,
2,80,64,6,255,0,92,26,99,7,2,0,1,138,67,143,2,0,35,135,
2,0,97,130,186,5,0,18,149,13,35,127,2,0,15,6,0,255,186,5,
1,18,165,5,1,18,2,80,68,26,127,0,128,7,33,0,6,16,2,138,
64,14,153,0,65,143,228,52,64,14,153,0,97,23,233,52,64,14,153,0,
97,63,237,52,4,50,191,255,172,227,64,6,63,0,128,7,33,0,191,255,
164,255,170,0,64,14,153,0,65,87,228,52,32,142,3,14,64,14,153,0,
97,143,233,52,32,134,32,0,64,14,153,0,97,135,237,52,3,122,64,14,
153,0,97,127,241,52,31,114,64,14,153,0,97,119,9,53,4,106,64,14,
153,0,97,111,13,53,64,6,63,0,224,49,154,21,64,158,134,0,51,159,
217,244,64,14,153,0,97,159,201,59,49,6,196,75,130,0,64,14,134,0,
97,143,217,244,149,13,64,158,153,0,51,159,201,59,64,14,134,0,97,159,
217,244,127,0,0,0,0,0,224,57,162,13,48,6,208,59,153,0,16,142,
152,0,17,120,207,31,0,0,149,13,45,6,208,59,153,0,13,118,152,0,
14,96,204,159,0,0,42,6,208,59,153,0,10,94,40,0,107,55,1,0,
64,142,153,0,49,143,57,54,17,128,194,130,16,136,46,6,208,59,153,0,
17,120,206,121,47,111,1,0,68,106,111,111,1,0,127,0,128,7,33,0,
6,16,100,18,238,13,48,6,208,59,153,0,16,142,24,0,2,112,194,114,
14,120,15,104,209,105,45,23,1,0,165,21,43,6,208,59,153,0,11,102,
12,0,2,136,194,138,17,80,44,127,1,0,10,128,207,129,16,48,4,58,
191,255,54,232,10,16,2,80,64,6,63,0,0,18,2,80,127,0,31,18,
2,80,127,0,128,7,33,0,191,255,202,220,202,22,128,0,224,17,202,13,
38,6,40,48,153,0,39,6,208,59,153,0,32,70,65,0,191,255,14,244,
181,13,38,6,48,49,153,0,39,6,208,59,153,0,32,70,65,0,191,255,
248,243,64,6,63,0,128,7,33,0,191,255,140,220,202,22,128,0,224,17,
202,13,38,6,208,59,153,0,39,6,40,48,153,0,32,70,65,0,191,255,
208,243,181,13,38,6,208,59,153,0,39,6,48,49,153,0,32,70,65,0,
191,255,186,243,64,14,153,0,97,7,21,53,64,6,63,0,128,7,33,0,
38,6,40,48,153,0,39,6,208,59,153,0,32,70,65,0,191,255,150,243,
92,26,99,103,1,0,229,103,64,0,0,0,236,159,32,0,64,102,130,0,
44,102,188,115,236,151,32,0,224,7,70,1,0,0,0,0,0,0,35,103,
1,0,68,26,64,6,63,0,128,7,33,0,38,6,208,59,153,0,39,6,
40,48,153,0,32,70,65,0,191,255,78,243,64,14,153,0,97,7,21,53,
64,6,63,0,0,18,2,80,127,0,0,18,2,80,127,0,130,7,225,243,
6,232,7,216,8,208,4,226,100,210,169,5,26,224,56,6,24,53,153,0,
64,134,240,15,93,129,186,85,2,90,97,226,146,13,98,226,242,5,100,226,
210,5,1,18,120,23,1,0,181,101,64,206,1,0,93,201,154,13,191,255,
148,219,10,176,150,54,224,0,191,255,234,219,1,90,0,111,10,248,28,22,
255,255,97,18,211,5,99,18,138,37,27,184,229,29,64,7,10,248,128,143,
11,248,224,137,218,253,28,130,93,129,48,119,1,0,97,226,99,119,1,0,
250,5,221,102,3,0,195,97,76,223,0,0,133,13,221,142,2,0,129,138,
193,138,195,137,113,223,0,0,35,191,1,0,13,16,11,17,64,23,10,248,
128,143,11,248,226,137,218,253,28,130,93,129,112,191,1,0,64,111,10,248,
224,201,138,29,22,48,191,255,116,219,197,21,97,226,226,5,98,226,242,5,
100,226,130,13,165,13,93,223,0,0,165,13,125,223,0,0,245,5,125,223,
1,0,197,5,1,18,120,23,1,0,56,119,1,0,68,234,224,113,202,5,
92,210,224,209,143,149,66,6,255,243,31,82,64,22,240,15,70,17,154,13,
128,95,11,248,64,7,10,248,128,135,11,248,224,129,218,253,97,58,226,5,
98,58,242,5,100,58,130,13,165,13,134,87,1,0,197,13,230,87,1,0,
149,13,38,87,1,0,229,5,1,98,64,14,153,0,97,103,25,53,224,17,
250,5,64,95,10,248,128,127,11,248,235,121,218,253,127,0,7,80,234,0,
170,57,144,58,34,6,92,26,99,15,6,240,1,21,34,6,1,0,64,14,
3,21,64,94,33,14,11,57,5,61,202,0,64,126,97,0,15,81,7,85,
127,0,7,16,226,0,162,57,144,58,42,6,92,26,99,15,6,240,1,85,
42,6,1,0,64,14,3,85,64,94,33,15,11,57,5,61,194,22,254,255,
47,6,1,0,97,0,15,17,7,21,127,0,128,7,33,0,3,18,64,23,
10,248,64,142,130,0,49,62,248,74,32,54,96,5,191,255,138,255,64,134,
130,0,48,62,248,74,32,54,112,5,191,255,122,255,64,126,130,0,47,62,
248,74,32,54,128,5,191,255,106,255,64,118,130,0,46,62,248,74,32,54,
144,5,191,255,90,255,64,110,134,0,45,62,216,244,32,54,96,0,191,255,
120,255,0,50,32,62,48,6,191,255,74,230,44,6,102,75,130,0,64,14,
134,0,97,103,217,244,64,6,63,0,32,143,112,240,209,134,3,0,202,253,
64,135,113,240,192,15,112,240,192,7,112,240,32,95,112,240,203,86,3,0,
202,253,127,0,128,7,33,0,6,6,240,255,210,29,6,6,64,252,194,29,
6,6,144,250,186,29,64,142,153,0,49,143,21,53,224,137,186,21,0,135,
46,250,208,6,31,0,226,13,128,63,39,250,224,57,130,13,244,57,226,5,
38,6,96,225,133,0,191,255,182,222,1,82,197,5,2,82,165,5,0,82,
64,6,63,0,32,22,64,0,64,23,174,241,127,0,192,191,32,250,7,18,
64,23,68,244,6,18,64,23,100,244,192,63,32,250,192,39,32,250,192,159,
32,250,192,151,32,250,192,15,32,250,192,135,32,250,32,22,162,0,96,23,
34,250,192,63,42,250,192,7,42,250,192,191,43,250,0,127,45,250,207,126,
240,0,64,127,45,250,0,111,44,250,205,110,240,0,64,111,44,250,192,55,
32,250,192,47,32,250,64,7,174,241,127,0,191,7,158,255,128,7,33,0,
191,255,140,255,191,255,244,255,64,14,153,0,97,7,81,54,64,14,153,0,
97,7,85,54,64,14,153,0,97,7,89,54,64,6,63,0,128,7,33,0,
191,255,212,255,32,22,0,252,64,14,153,0,97,23,93,54,64,7,10,248,
128,143,11,248,224,137,218,253,64,6,63,0,64,22,1,0,133,13,0,143,
47,250,209,142,31,0,17,6,240,255,177,5,95,18,138,253,127,0,64,22,
1,0,245,13,0,143,46,250,209,6,31,0,162,13,128,87,39,250,32,22,
32,0,2,128,95,18,224,129,218,253,197,5,95,18,154,245,31,82,127,0,
166,0,64,22,1,0,245,13,0,143,47,250,209,6,31,0,162,13,64,55,
40,250,32,22,32,0,2,128,95,18,224,129,218,253,181,5,95,18,154,245,
127,0,127,0,127,0,127,0,127,0,127,0,1,82,127,0,42,6,80,225,
133,0,127,0,1,50,127,0,128,7,193,0,6,232,125,63,5,0,125,7,
9,0,125,71,17,0,125,7,29,0,125,7,33,0,229,87,64,0,224,7,
96,1,36,23,1,144,10,224,49,6,69,84,85,77,125,143,1,0,224,17,
130,13,34,87,41,0,98,239,41,0,106,239,37,0,213,5,100,239,1,144,
29,16,29,80,125,87,41,0,125,23,37,0,36,135,5,144,65,130,100,135,
5,144,252,47,32,0,0,82,64,6,223,0,128,7,225,243,6,232,7,216,
8,208,9,200,35,199,37,0,35,191,41,0,35,183,45,0,35,255,49,0,
229,87,64,0,224,7,96,1,61,135,49,0,61,143,41,0,35,151,53,0,
61,95,141,0,122,135,1,0,61,119,45,0,10,224,61,127,5,0,127,95,
1,0,120,119,1,0,61,111,61,0,121,127,1,0,61,103,25,0,61,87,
113,0,123,143,1,0,119,111,1,0,118,103,1,0,114,87,1,0,252,47,
32,0,0,82,64,6,255,243,160,7,225,48,6,248,7,208,8,216,0,234,
229,87,64,0,224,7,96,1,63,143,21,0,10,224,224,137,218,125,224,217,
210,117,63,87,9,0,63,127,37,0,63,135,25,0,194,82,240,121,218,5,
63,95,29,0,170,89,181,5,15,88,170,89,63,127,21,0,127,95,37,0,
63,119,17,0,63,87,9,0,65,122,127,127,21,0,95,114,127,119,17,0,
11,16,3,72,1,234,97,82,242,77,98,82,242,69,100,82,178,61,104,82,
210,37,34,111,1,0,105,111,1,0,34,103,5,0,105,103,5,0,34,95,
9,0,105,95,9,0,34,87,13,0,105,87,13,0,34,143,17,0,105,143,
17,0,34,135,21,0,105,135,21,0,34,127,25,0,105,127,25,0,34,119,
29,0,2,22,32,0,105,119,29,0,9,78,32,0,34,111,1,0,105,111,
1,0,34,103,5,0,105,103,5,0,34,95,9,0,105,95,9,0,34,87,
13,0,2,22,16,0,105,87,13,0,9,78,16,0,34,143,1,0,105,143,
1,0,34,135,5,0,72,18,105,135,5,0,72,74,34,127,1,0,68,18,
105,127,1,0,68,74,34,119,1,0,105,119,1,0,63,111,21,0,224,105,
186,5,128,7,192,2,63,23,41,0,224,17,178,5,128,7,142,1,63,119,
9,0,63,95,33,0,63,103,25,0,194,114,236,89,218,5,63,127,29,0,
174,121,181,5,11,120,174,121,63,95,21,0,63,87,17,0,95,90,127,127,
33,0,65,82,127,87,17,0,63,87,9,0,15,72,127,95,21,0,26,16,
97,82,242,77,98,82,242,69,100,82,178,61,104,82,210,37,34,143,1,0,
105,143,1,0,34,135,5,0,105,135,5,0,34,127,9,0,105,127,9,0,
34,119,13,0,105,119,13,0,34,111,17,0,105,111,17,0,34,103,21,0,
105,103,21,0,34,95,25,0,105,95,25,0,34,87,29,0,2,22,32,0,
105,87,29,0,9,78,32,0,34,143,1,0,105,143,1,0,34,135,5,0,
105,135,5,0,34,127,9,0,105,127,9,0,34,119,13,0,2,22,16,0,
105,119,13,0,9,78,16,0,34,111,1,0,105,111,1,0,34,103,5,0,
72,18,105,103,5,0,72,74,34,95,1,0,68,18,105,95,1,0,68,74,
34,87,1,0,224,233,105,87,1,0,194,77,32,239,169,182,49,6,196,125,
130,0,125,255,109,0,125,31,125,0,63,23,41,0,125,143,105,0,224,17,
226,21,125,23,113,0,63,119,41,0,46,119,117,0,125,119,117,0,63,103,
41,0,44,103,117,0,108,239,113,0,63,95,41,0,107,239,117,0,127,239,
41,0,245,5,127,239,41,0,125,239,113,0,125,239,117,0,5,138,32,127,
69,184,125,143,49,0,1,130,63,87,45,0,125,135,57,0,65,122,96,127,
69,184,65,82,127,87,45,0,125,223,77,0,252,47,32,0,127,218,210,5,
61,54,76,0,128,255,54,16,29,48,128,255,70,1,61,87,133,0,128,7,
58,1,252,47,32,0,0,82,128,7,48,1,2,232,61,23,113,0,226,233,
202,5,127,7,41,0,245,13,127,23,41,0,61,111,117,0,61,119,113,0,
110,111,117,0,61,95,113,0,61,103,117,0,108,95,113,0,63,87,45,0,
32,143,69,184,125,7,105,0,95,82,127,87,45,0,65,138,96,143,69,184,
252,47,32,0,63,87,9,0,26,16,61,79,125,0,97,82,242,77,98,82,
242,69,100,82,178,61,104,82,210,37,34,135,1,0,105,135,1,0,34,127,
5,0,105,127,5,0,34,119,9,0,105,119,9,0,34,111,13,0,105,111,
13,0,34,103,17,0,105,103,17,0,34,95,21,0,105,95,21,0,34,87,
25,0,105,87,25,0,34,143,29,0,2,22,32,0,105,143,29,0,9,78,
32,0,34,135,1,0,105,135,1,0,34,127,5,0,105,127,5,0,34,119,
9,0,105,119,9,0,34,111,13,0,2,22,16,0,105,111,13,0,9,78,
16,0,34,103,1,0,105,103,1,0,34,95,5,0,72,18,105,95,5,0,
72,74,34,87,1,0,68,18,105,87,1,0,68,74,34,143,1,0,61,23,
101,0,105,143,1,0,224,17,226,5,61,54,76,0,128,255,192,11,181,5,
125,23,77,0,125,7,133,0,29,48,128,255,34,0,224,81,178,5,128,255,
34,0,0,82,197,5,252,47,32,0,11,82,96,6,255,48,33,6,46,201,
1,0,97,0,33,6,50,200,1,0,97,0,33,6,8,203,1,0,97,0,
128,7,193,0,6,232,35,95,9,0,125,63,5,0,125,7,33,0,125,7,
37,0,125,79,21,0,67,66,130,66,194,66,125,71,29,0,0,98,9,80,
130,90,194,90,125,95,25,0,201,89,8,110,4,0,213,5,65,98,106,23,
1,0,2,80,13,16,202,17,235,17,147,253,8,94,4,0,171,81,106,7,
1,0,125,103,9,0,125,103,13,0,0,18,224,97,162,5,9,16,125,23,
17,0,229,87,64,0,224,7,96,1,36,23,17,144,10,224,42,6,67,79,
76,66,125,87,1,0,224,17,130,13,34,87,45,0,98,239,45,0,106,239,
41,0,213,5,100,239,17,144,29,16,29,80,125,87,45,0,125,23,41,0,
36,143,21,144,65,138,100,143,21,144,252,47,32,0,0,82,64,6,223,0,
128,7,193,0,6,232,125,63,5,0,125,7,9,0,125,7,17,0,125,7,
21,0,125,7,13,0,229,87,64,0,224,7,96,1,36,23,229,142,10,224,
49,6,78,68,86,68,125,143,1,0,224,17,130,13,34,87,29,0,98,239,
29,0,106,239,25,0,213,5,100,239,229,142,29,16,29,80,125,87,29,0,
125,23,25,0,36,135,233,142,65,130,100,135,233,142,252,47,32,0,0,82,
64,6,223,0,128,7,225,0,6,232,61,255,109,0,229,87,64,0,224,7,
96,1,61,143,105,0,10,224,224,137,242,77,224,249,210,77,63,127,1,0,
48,6,85,69,85,81,240,121,234,69,61,23,113,0,125,7,105,0,226,233,
202,5,127,7,41,0,245,13,127,23,41,0,61,111,117,0,61,119,113,0,
110,111,117,0,61,95,113,0,61,103,117,0,108,95,113,0,63,87,45,0,
61,143,49,0,95,82,127,87,45,0,101,138,138,29,63,135,17,0,10,18,
224,129,162,5,11,18,32,127,69,184,125,23,133,0,65,122,96,127,69,184,
252,47,32,0,29,48,191,255,70,254,224,81,226,5,191,255,70,254,181,5,
252,47,32,0,61,23,101,0,224,17,226,5,61,54,76,0,128,255,182,9,
229,5,125,23,77,0,181,5,252,47,32,0,64,6,255,0,128,7,225,48,
6,248,7,208,8,216,229,87,64,0,224,7,96,1,63,143,17,0,10,224,
224,137,186,5,128,7,100,2,63,87,9,0,26,56,63,23,33,0,97,82,
242,77,98,82,242,69,100,82,178,61,104,82,210,37,34,135,1,0,103,135,
1,0,34,127,5,0,103,127,5,0,34,119,9,0,103,119,9,0,34,111,
13,0,103,111,13,0,34,103,17,0,103,103,17,0,34,95,21,0,103,95,
21,0,34,87,25,0,103,87,25,0,34,143,29,0,2,22,32,0,103,143,
29,0,7,62,32,0,34,135,1,0,103,135,1,0,34,127,5,0,103,127,
5,0,34,119,9,0,103,119,9,0,34,111,13,0,2,22,16,0,103,111,
13,0,7,62,16,0,34,103,1,0,103,103,1,0,34,95,5,0,72,18,
103,95,5,0,72,58,34,87,1,0,68,18,103,87,1,0,68,58,34,143,
1,0,63,135,9,0,63,119,33,0,103,143,1,0,63,111,29,0,194,130,
208,113,127,119,33,0,237,113,209,5,63,95,25,0,127,95,33,0,63,87,
41,0,0,234,224,81,218,13,63,143,21,0,63,135,17,0,65,138,127,143,
21,0,95,130,127,135,17,0,128,7,6,2,32,127,69,184,65,122,96,127,
69,184,252,47,32,0,229,87,64,0,224,7,96,1,32,119,69,184,63,239,
41,0,10,224,63,87,9,0,95,114,96,119,69,184,61,23,125,0,63,63,
37,0,97,82,242,77,98,82,242,69,100,82,178,61,104,82,210,37,34,111,
1,0,103,111,1,0,34,103,5,0,103,103,5,0,34,95,9,0,103,95,
9,0,34,87,13,0,103,87,13,0,34,143,17,0,103,143,17,0,34,135,
21,0,103,135,21,0,34,127,25,0,103,127,25,0,34,119,29,0,2,22,
32,0,103,119,29,0,7,62,32,0,34,111,1,0,103,111,1,0,34,103,
5,0,103,103,5,0,34,95,9,0,103,95,9,0,34,87,13,0,2,22,
16,0,103,87,13,0,7,62,16,0,34,143,1,0,103,143,1,0,34,135,
5,0,72,18,103,135,5,0,72,58,34,127,1,0,68,18,103,127,1,0,
68,58,34,119,1,0,63,111,9,0,63,95,37,0,103,119,1,0,63,87,
29,0,194,106,205,89,127,95,37,0,234,89,209,5,63,135,25,0,127,135,
37,0,61,23,113,0,226,233,202,5,127,7,41,0,245,13,127,23,41,0,
61,119,117,0,61,127,113,0,111,119,117,0,61,103,113,0,61,111,117,0,
109,103,113,0,63,95,45,0,32,87,69,184,125,7,105,0,95,90,127,95,
45,0,65,82,96,87,69,184,252,47,32,0,61,23,101,0,224,17,226,5,
61,54,76,0,128,255,66,7,181,5,125,23,77,0,125,7,133,0,29,48,
191,255,164,251,224,81,178,5,191,255,164,251,0,82,245,77,224,217,146,77,
32,239,169,182,49,6,196,125,130,0,125,255,109,0,125,215,125,0,63,23,
41,0,125,143,105,0,224,17,194,21,125,23,113,0,63,127,41,0,47,127,
117,0,125,127,117,0,63,111,41,0,45,111,117,0,109,239,113,0,63,103,
41,0,108,239,117,0,245,5,127,239,41,0,125,239,113,0,125,239,117,0,
5,82,32,135,69,184,125,87,49,0,1,138,63,95,45,0,125,143,57,0,
65,130,96,135,69,184,65,90,127,95,45,0,125,223,77,0,252,47,32,0,
127,218,210,5,61,54,76,0,128,255,242,9,29,48,191,255,2,251,61,87,
133,0,213,5,10,234,252,47,32,0,29,80,64,6,255,48,128,7,225,48,
6,248,7,216,8,208,229,87,64,0,224,7,96,1,63,143,21,0,10,224,
224,137,186,5,128,7,28,2,63,239,41,0,224,233,250,117,63,135,21,0,
63,127,17,0,63,87,9,0,27,56,95,130,127,135,21,0,65,122,127,127,
17,0,63,23,37,0,97,82,242,77,98,82,242,69,100,82,178,61,104,82,
210,37,39,119,1,0,98,119,1,0,39,111,5,0,98,111,5,0,39,103,
9,0,98,103,9,0,39,95,13,0,98,95,13,0,39,87,17,0,98,87,
17,0,39,143,21,0,98,143,21,0,39,135,25,0,98,135,25,0,39,127,
29,0,7,62,32,0,98,127,29,0,2,22,32,0,39,119,1,0,98,119,
1,0,39,111,5,0,98,111,5,0,39,103,9,0,98,103,9,0,39,95,
13,0,7,62,16,0,98,95,13,0,2,22,16,0,39,87,1,0,98,87,
1,0,39,143,5,0,72,58,98,143,5,0,72,18,39,135,1,0,68,58,
98,135,1,0,68,18,39,127,1,0,63,119,9,0,63,103,37,0,98,127,
1,0,63,95,29,0,194,114,206,97,127,103,37,0,235,97,209,5,63,143,
25,0,127,143,37,0,0,250,128,7,190,1,61,23,113,0,226,233,202,5,
127,7,41,0,245,13,127,23,41,0,61,127,117,0,61,135,113,0,112,127,
117,0,61,111,113,0,61,119,117,0,110,111,113,0,63,103,45,0,32,95,
69,184,125,7,105,0,95,98,127,103,45,0,65,90,96,95,69,184,252,47,
32,0,63,87,9,0,27,56,61,23,125,0,97,82,242,77,98,82,242,69,
100,82,178,61,104,82,210,37,39,87,1,0,98,87,1,0,39,143,5,0,
98,143,5,0,39,135,9,0,98,135,9,0,39,127,13,0,98,127,13,0,
39,119,17,0,98,119,17,0,39,111,21,0,98,111,21,0,39,103,25,0,
98,103,25,0,39,95,29,0,7,62,32,0,98,95,29,0,2,22,32,0,
39,87,1,0,98,87,1,0,39,143,5,0,98,143,5,0,39,135,9,0,
98,135,9,0,39,127,13,0,7,62,16,0,98,127,13,0,2,22,16,0,
39,119,1,0,98,119,1,0,39,111,5,0,72,58,98,111,5,0,72,18,
39,103,1,0,68,58,98,103,1,0,68,18,39,95,1,0,98,95,1,0,
61,23,101,0,224,17,226,5,61,54,76,0,128,255,106,4,181,5,125,23,
77,0,125,7,133,0,29,48,191,255,204,248,224,81,178,5,191,255,204,248,
0,82,245,77,224,209,146,77,32,239,169,182,42,6,196,125,130,0,125,255,
109,0,125,223,125,0,63,23,41,0,125,87,105,0,224,17,194,21,125,23,
113,0,63,135,41,0,48,135,117,0,125,135,117,0,63,119,41,0,46,119,
117,0,110,239,113,0,63,111,41,0,109,239,117,0,245,5,127,239,41,0,
125,239,113,0,125,239,117,0,5,90,32,143,69,184,125,95,49,0,1,82,
63,103,45,0,125,87,57,0,65,138,96,143,69,184,65,98,127,103,45,0,
125,215,77,0,252,47,32,0,127,210,210,5,61,54,76,0,128,255,26,7,
29,48,191,255,42,248,61,87,133,0,213,5,11,250,252,47,32,0,31,80,
64,6,255,48,128,7,225,16,6,224,229,87,64,0,224,7,96,1,36,143,
13,144,10,248,60,23,49,0,124,7,1,0,95,138,100,143,13,144,226,225,
186,5,0,18,149,21,60,135,53,0,36,111,9,144,98,135,53,0,60,119,
49,0,60,127,53,0,252,105,111,119,49,0,218,5,60,23,49,0,100,23,
9,144,32,103,69,184,65,98,96,103,69,184,255,47,32,0,60,239,41,0,
1,218,165,37,229,87,64,0,224,7,96,1,32,95,69,184,125,7,105,0,
10,248,65,90,96,95,69,184,255,47,32,0,61,54,76,0,128,255,38,3,
125,7,77,0,125,223,133,0,61,239,113,0,61,55,117,0,191,255,132,247,
60,87,45,0,95,82,124,87,45,0,60,143,45,0,224,137,202,221,229,87,
64,0,224,7,96,1,32,135,69,184,10,248,95,130,96,135,69,184,255,47,
32,0,32,119,169,182,32,127,173,182,239,113,178,5,191,255,82,247,0,82,
64,6,255,16,128,7,193,0,6,232,35,23,9,0,125,63,5,0,125,7,
41,0,125,7,45,0,125,71,9,0,97,66,202,5,130,18,2,104,229,21,
98,66,218,5,131,18,2,104,193,106,133,21,100,66,218,5,132,18,2,104,
194,106,165,13,104,66,218,5,133,18,2,104,195,106,197,5,134,18,2,104,
196,106,125,79,25,0,194,106,201,105,125,111,29,0,125,79,33,0,125,79,
37,0,125,7,17,0,125,23,21,0,125,23,13,0,229,87,64,0,224,7,
96,1,36,23,9,144,10,224,42,6,85,69,85,81,125,87,1,0,224,17,
130,13,34,87,53,0,98,239,53,0,106,239,49,0,213,5,100,239,9,144,
29,16,29,80,125,87,53,0,125,23,49,0,36,143,13,144,65,138,100,143,
13,144,252,47,32,0,0,82,64,6,223,0,128,7,193,0,6,232,125,63,
5,0,125,71,9,0,125,7,13,0,125,7,17,0,229,87,64,0,224,7,
96,1,36,23,25,144,10,224,49,6,65,77,69,83,125,143,1,0,224,17,
130,13,34,87,25,0,98,239,25,0,106,239,21,0,213,5,100,239,25,144,
29,16,29,80,125,87,25,0,125,23,21,0,36,135,29,144,65,130,100,135,
29,144,252,47,32,0,0,82,64,6,223,0,128,7,193,0,6,224,229,87,
64,0,224,7,96,1,10,232,100,231,245,178,253,47,32,0,64,6,223,0,
128,7,193,48,6,232,7,216,8,208,229,87,64,0,224,7,96,1,61,143,
33,0,10,224,224,137,218,5,125,223,9,0,125,215,13,0,252,47,32,0,
0,82,64,6,223,48,128,7,193,0,38,238,8,0,229,87,64,0,224,7,
96,1,61,23,25,0,36,103,33,144,10,224,236,17,161,37,36,87,37,144,
234,17,233,29,36,95,41,144,235,17,193,5,171,17,162,18,149,13,61,119,
25,0,171,81,162,82,172,113,162,114,206,81,10,16,2,86,1,0,61,23,
1,0,2,6,223,255,217,5,2,22,224,255,202,17,165,5,10,16,125,23,
1,0,61,23,25,0,224,17,210,37,61,87,17,0,234,233,250,5,34,143,
1,0,253,137,186,29,0,18,213,21,61,135,21,0,106,135,21,0,61,127,
21,0,61,119,17,0,61,87,25,0,111,119,17,0,42,111,1,0,253,105,
154,13,61,23,17,0,98,87,25,0,61,95,25,0,107,23,1,0,125,7,
25,0,252,47,32,0,0,82,64,6,223,0,128,7,33,0,38,143,33,0,
224,137,218,5,38,135,9,0,224,129,202,5,32,86,23,0,213,5,72,50,
128,255,226,3,0,82,64,6,63,0,128,7,225,0,6,248,35,23,13,0,
35,87,17,0,35,231,21,0,127,63,5,0,127,23,9,0,127,87,13,0,
127,71,17,0,127,79,21,0,127,7,33,0,229,87,64,0,224,7,96,1,
36,23,45,144,10,232,49,6,77,73,84,65,127,143,1,0,224,17,130,13,
34,87,41,0,98,255,41,0,106,255,37,0,213,5,100,255,45,144,31,16,
31,80,127,87,41,0,127,23,37,0,36,135,49,144,65,130,100,135,49,144,
253,47,32,0,224,225,210,5,63,54,8,0,128,255,94,3,0,82,64,6,
255,0,128,7,193,0,6,232,229,87,64,0,224,7,96,1,61,23,25,0,
10,224,224,17,210,37,61,87,17,0,234,233,250,5,34,143,1,0,253,137,
186,29,0,18,213,21,61,135,21,0,106,135,21,0,61,127,21,0,61,119,
17,0,61,87,25,0,111,119,17,0,42,111,1,0,253,105,154,13,61,23,
17,0,98,87,25,0,61,95,25,0,107,23,1,0,125,7,25,0,252,47,
32,0,0,82,64,6,223,0,128,7,225,0,6,232,61,54,76,0,191,255,
140,255,229,87,64,0,224,7,96,1,61,23,49,0,10,248,97,18,194,37,
98,18,162,37,2,138,125,143,49,0,1,130,125,135,57,0,224,17,202,13,
32,127,69,184,65,122,96,127,69,184,255,47,32,0,29,48,191,255,188,243,
149,21,61,231,105,0,255,47,32,0,224,225,226,5,29,48,63,6,240,136,
130,0,124,0,125,7,57,0,181,5,255,47,32,0,0,82,64,6,255,0,
128,7,225,16,6,248,7,232,8,216,229,87,64,0,224,7,96,1,63,143,
45,0,123,143,1,0,63,135,49,0,10,224,224,129,226,13,127,239,45,0,
127,239,61,0,1,122,253,127,192,0,127,127,65,0,252,47,32,0,128,7,
64,1,63,103,33,0,63,23,45,0,255,97,194,37,194,18,34,87,197,183,
34,22,196,183,255,81,186,13,63,135,65,0,32,127,189,182,48,136,98,103,
1,0,81,121,96,127,189,182,63,119,33,0,63,111,37,0,1,82,253,87,
192,0,110,111,37,0,63,95,33,0,63,103,37,0,127,87,65,0,108,95,
33,0,165,77,63,103,65,0,194,18,98,7,197,183,32,23,185,182,44,88,
32,87,189,182,1,138,75,17,96,23,185,182,75,81,96,87,189,182,253,143,
192,0,127,143,65,0,194,126,255,0,130,13,194,110,255,0,141,143,197,182,
96,143,193,182,181,45,194,134,0,255,162,13,136,18,194,110,255,0,141,143,
197,182,72,138,96,143,193,182,245,29,64,126,255,0,66,121,178,13,144,18,
194,94,255,0,139,127,197,182,15,126,16,0,96,127,193,182,149,21,64,110,
0,255,66,105,146,13,152,18,130,111,197,182,13,110,24,0,96,111,193,182,
213,5,32,94,32,0,96,95,193,182,32,87,173,182,234,249,202,13,32,23,
193,182,0,82,2,6,224,255,194,5,194,18,34,87,197,183,96,87,173,182,
127,239,45,0,32,103,69,184,127,239,61,0,3,106,127,111,49,0,65,98,
96,103,69,184,252,47,32,0,31,48,191,255,58,242,32,87,169,182,32,95,
173,182,235,81,242,5,36,143,133,137,224,137,186,5,191,255,42,242,0,82,
64,6,255,16,128,7,225,16,6,232,61,23,49,0,0,218,97,18,178,5,
98,18,138,53,229,87,64,0,224,7,96,1,37,159,221,135,10,224,224,153,
210,5,61,54,136,0,128,255,4,0,61,23,141,0,125,7,1,0,226,233,
186,5,0,18,149,21,61,143,145,0,32,119,177,182,98,143,145,0,61,127,
141,0,61,135,145,0,253,113,112,127,141,0,218,5,61,23,141,0,96,23,
177,182,32,111,181,182,95,106,96,111,181,182,252,47,32,0,181,5,32,222,
17,0,27,80,64,6,255,16,128,7,97,0,32,23,169,182,6,248,224,17,
162,13,49,6,48,64,153,0,241,17,210,5,36,135,133,137,224,129,194,5,
32,86,19,0,181,45,224,249,186,5,31,80,245,37,229,87,64,0,224,7,
96,1,32,23,169,182,10,232,4,122,32,111,69,184,98,127,49,0,1,114,
98,119,57,0,98,7,133,0,65,106,96,111,69,184,253,47,32,0,32,23,
169,182,98,255,77,0,34,54,76,0,128,255,24,0,32,55,169,182,191,255,
38,241,32,87,169,182,42,87,133,0,64,6,127,0,128,7,193,0,6,232,
229,87,64,0,224,7,96,1,61,23,1,0,10,224,224,17,146,61,61,143,
25,0,224,137,218,53,32,86,31,0,2,6,223,255,177,5,2,86,255,255,
36,119,41,144,10,16,36,87,37,144,194,18,206,17,234,17,129,13,170,17,
162,18,2,136,36,23,33,144,194,138,209,17,34,87,1,0,224,81,162,21,
125,87,17,0,34,127,1,0,47,127,21,0,125,127,21,0,111,239,17,0,
34,111,1,0,125,23,25,0,109,239,21,0,149,13,125,239,17,0,125,239,
21,0,125,23,25,0,98,239,1,0,252,47,32,0,0,82,64,6,223,0,
128,7,225,243,9,184,35,223,37,0,35,183,45,0,35,215,53,0,35,231,
41,0,6,232,27,48,8,192,28,64,7,200,32,62,239,0,189,255,182,117,
29,48,0,58,32,70,152,0,189,255,170,117,125,207,41,0,125,199,69,0,
125,191,73,0,125,223,13,0,125,231,21,0,28,142,255,255,35,159,49,0,
219,137,125,143,17,0,214,22,31,0,125,23,45,0,211,126,31,0,125,127,
61,0,125,215,25,0,125,215,29,0,3,114,125,119,49,0,45,6,98,149,
130,0,125,111,85,0,125,239,89,0,1,98,226,103,192,0,125,103,65,0,
29,48,39,6,150,141,130,0,128,255,224,2,229,87,64,0,224,7,96,1,
32,23,177,182,10,224,42,6,68,82,72,84,125,87,1,0,224,17,130,13,
34,87,145,0,98,239,145,0,106,239,141,0,213,5,96,239,177,182,29,16,
29,80,125,87,145,0,125,23,141,0,32,143,181,182,32,135,69,184,37,159,
225,135,65,138,96,143,181,182,65,130,96,135,69,184,224,153,210,5,61,54,
136,0,128,255,4,0,252,47,32,0,35,159,57,0,224,153,146,13,29,48,
191,255,136,239,224,81,130,21,191,255,136,239,213,13,229,87,64,0,224,7,
96,1,32,127,69,184,10,224,95,122,96,127,69,184,252,47,32,0,0,82,
64,6,255,243,128,7,97,0,6,232,229,87,64,0,224,7,96,1,61,143,
49,0,10,248,99,138,154,21,32,135,69,184,65,130,96,135,69,184,255,47,
32,0,29,48,191,255,52,239,224,81,178,5,191,255,52,239,0,82,133,21,
61,127,53,0,224,121,130,13,125,7,53,0,255,47,32,0,32,86,25,0,
213,5,255,47,32,0,32,86,18,0,64,6,127,0,128,7,33,0,32,23,
169,182,34,143,69,0,34,55,73,0,63,6,174,141,130,0,113,0,229,87,
64,0,224,7,96,1,32,23,169,182,32,119,69,184,1,130,98,135,57,0,
98,135,49,0,10,248,65,114,96,119,69,184,255,47,32,0,32,55,169,182,
191,255,184,238,64,6,63,0,128,7,33,0,96,7,169,182,96,7,173,182,
96,7,185,182,96,7,189,182,32,142,32,0,96,143,193,182,64,7,196,182,
32,134,196,182,16,102,1,0,1,90,11,80,0,18,197,5,129,82,65,18,
130,0,202,126,1,0,178,253,76,23,0,0,65,98,65,90,11,6,0,255,
153,245,32,54,196,183,0,58,32,70,128,0,189,255,178,115,96,7,177,182,
96,7,181,182,96,7,69,184,64,6,63,0,140,7,97,0,100,7,53,144,
100,7,57,144,100,7,61,144,61,6,200,64,153,0,29,48,0,58,32,70,
128,0,189,255,128,115,100,239,33,144,100,239,41,144,29,134,128,0,100,135,
37,144,34,6,8,212,153,0,100,23,65,144,40,6,170,149,130,0,47,6,
8,228,153,0,162,121,100,127,69,144,100,7,73,144,99,23,1,0,36,103,
69,144,99,7,9,0,99,7,13,0,99,7,17,0,99,103,5,0,99,7,
21,0,38,6,48,64,153,0,39,6,136,225,133,0,41,6,77,73,84,65,
191,255,68,253,100,7,45,144,100,7,49,144,76,6,127,0,128,7,33,0,
49,6,240,240,240,240,100,143,133,137,191,255,166,187,128,255,86,0,48,6,
241,240,240,240,100,135,133,137,64,6,63,0,128,7,97,0,36,135,133,137,
49,6,241,240,240,240,61,6,240,240,240,240,241,129,242,5,100,239,133,137,
191,255,116,187,128,255,36,0,36,55,253,143,100,239,133,137,191,255,206,182,
100,7,133,137,128,255,8,0,64,6,127,0,33,6,72,216,1,0,97,0,
128,7,33,0,191,255,156,254,191,255,0,255,100,7,25,144,100,7,29,144,
100,7,9,144,100,7,13,144,100,7,229,142,100,7,233,142,100,7,17,144,
100,7,21,144,100,7,77,144,100,7,81,144,100,7,1,144,100,7,5,144,
64,6,63,0,38,103,17,0,28,106,77,97,12,102,116,255,1,106,108,111,
1,0,0,106,108,111,5,0,108,111,9,0,108,47,13,0,108,111,17,0,
108,111,21,0,108,111,25,0,108,111,29,0,108,111,33,0,108,111,37,0,
108,111,41,0,108,111,45,0,108,111,49,0,108,111,53,0,108,111,57,0,
108,111,61,0,108,111,65,0,108,111,69,0,108,167,73,0,108,175,77,0,
108,111,81,0,108,111,85,0,108,111,89,0,108,111,93,0,108,111,97,0,
108,111,101,0,108,111,105,0,108,239,109,0,108,247,113,0,108,111,117,0,
244,111,64,0,108,111,121,0,241,111,64,0,108,111,125,0,240,111,64,0,
108,111,129,0,0,106,108,111,133,0,108,63,137,0,102,103,9,0,127,0,
128,7,225,0,6,232,61,231,109,0,229,87,64,0,224,7,96,1,61,143,
105,0,10,248,224,137,178,77,224,225,146,77,60,127,1,0,48,6,69,84,
85,77,240,121,170,69,61,23,113,0,125,7,105,0,226,233,202,5,124,7,
29,0,245,13,124,23,29,0,61,111,117,0,61,119,113,0,110,111,117,0,
61,95,113,0,61,103,117,0,108,95,113,0,60,87,33,0,61,143,49,0,
95,82,124,87,33,0,109,138,202,21,32,127,69,184,32,134,29,0,125,135,
133,0,65,122,96,127,69,184,255,47,32,0,29,48,191,255,226,235,224,81,
226,5,191,255,226,235,181,5,255,47,32,0,61,23,101,0,224,17,226,5,
61,54,76,0,191,255,82,247,229,5,125,23,77,0,181,5,255,47,32,0,
64,6,255,0,128,7,225,16,6,248,7,232,8,216,229,87,64,0,224,7,
96,1,63,143,49,0,10,224,224,137,226,13,127,239,45,0,127,223,61,0,
1,130,253,135,192,0,127,135,65,0,252,47,32,0,128,7,40,1,63,87,
33,0,63,23,45,0,255,81,194,37,194,18,34,95,197,183,34,22,196,183,
255,89,186,13,63,143,65,0,32,135,189,182,98,87,1,0,49,80,74,129,
96,135,189,182,63,127,33,0,63,119,37,0,1,90,253,95,192,0,111,119,
37,0,63,103,33,0,63,111,37,0,127,95,65,0,109,103,33,0,165,77,
63,111,65,0,194,18,98,7,197,183,32,23,185,182,32,95,189,182,45,80,
74,17,96,23,185,182,74,89,96,95,189,182,1,82,253,87,192,0,127,87,
65,0,194,134,255,0,130,13,194,118,255,0,142,87,197,182,96,87,193,182,
181,45,194,142,0,255,162,13,136,18,194,118,255,0,142,87,197,182,72,82,
96,87,193,182,245,29,64,134,255,0,66,129,178,13,144,18,194,102,255,0,
140,135,197,182,16,134,16,0,96,135,193,182,149,21,64,118,0,255,66,113,
146,13,152,18,130,119,197,182,14,118,24,0,96,119,193,182,213,5,32,102,
32,0,96,103,193,182,32,95,173,182,235,249,202,13,32,23,193,182,0,82,
2,6,224,255,194,5,194,18,34,87,197,183,96,87,173,182,127,239,45,0,
32,111,69,184,127,239,61,0,3,114,127,119,49,0,65,106,96,111,69,184,
252,47,32,0,31,48,191,255,90,234,64,6,255,16,128,7,193,0,6,232,
229,87,64,0,224,7,96,1,61,23,33,0,10,224,98,18,202,13,61,23,
29,0,34,79,113,0,34,143,45,0,41,135,45,0,241,129,169,61,245,53,
98,18,243,53,61,79,29,0,9,80,41,23,113,0,34,119,45,0,41,127,
45,0,239,113,169,5,2,72,34,23,113,0,234,17,234,245,61,111,29,0,
237,73,178,37,41,95,117,0,41,103,113,0,108,95,117,0,41,143,113,0,
41,87,117,0,106,143,113,0,61,135,29,0,105,135,113,0,61,119,29,0,
46,119,117,0,105,119,117,0,61,103,29,0,44,103,117,0,108,79,113,0,
61,95,29,0,107,79,117,0,125,79,29,0,252,47,32,0,0,82,64,6,
223,0,49,6,40,66,153,0,102,143,1,0,127,0,189,7,186,188,31,58,
189,7,172,188,128,7,33,0,191,255,208,251,38,6,40,66,153,0,39,6,
156,225,133,0,1,66,191,255,190,228,64,6,63,0,38,6,40,66,153,0,
189,7,140,188,38,6,40,66,153,0,31,58,189,7,120,188,42,6,72,65,
153,0,127,0,128,7,225,0,6,232,61,231,109,0,229,87,64,0,224,7,
96,1,61,143,105,0,10,248,224,137,178,77,224,225,146,77,60,127,1,0,
48,6,67,79,76,66,240,121,170,69,61,23,113,0,125,7,105,0,226,233,
202,5,124,7,33,0,245,13,124,23,33,0,61,111,117,0,61,119,113,0,
110,111,117,0,61,95,113,0,61,103,117,0,108,95,113,0,60,87,37,0,
61,143,49,0,95,82,124,87,37,0,104,138,202,21,32,127,69,184,32,134,
16,0,125,135,133,0,65,122,96,127,69,184,255,47,32,0,29,48,191,255,
210,232,224,81,226,5,191,255,210,232,181,5,255,47,32,0,61,23,101,0,
224,17,226,5,61,54,76,0,191,255,66,244,229,5,125,23,77,0,181,5,
255,47,32,0,64,6,255,0,128,7,225,0,6,232,61,231,109,0,229,87,
64,0,224,7,96,1,61,143,105,0,10,248,224,137,146,77,224,225,242,69,
60,127,1,0,48,6,78,68,86,68,240,121,138,69,61,23,113,0,125,7,
105,0,226,233,202,5,124,7,17,0,245,13,124,23,17,0,61,111,117,0,
61,119,113,0,110,111,117,0,61,95,113,0,61,103,117,0,108,95,113,0,
60,87,21,0,61,23,49,0,95,82,124,87,21,0,103,18,170,21,32,143,
69,184,125,23,133,0,65,138,96,143,69,184,255,47,32,0,29,48,191,255,
30,232,224,81,226,5,191,255,30,232,181,5,255,47,32,0,61,23,101,0,
224,17,226,5,61,54,76,0,191,255,142,243,229,5,125,23,77,0,181,5,
255,47,32,0,64,6,255,0,128,7,225,0,6,232,61,231,109,0,229,87,
64,0,224,7,96,1,61,143,105,0,10,248,224,137,162,77,224,225,130,77,
60,127,1,0,48,6,65,77,69,83,240,121,154,69,61,23,113,0,125,7,
105,0,226,233,202,5,124,7,13,0,245,13,124,23,13,0,61,111,117,0,
61,119,113,0,110,111,117,0,61,95,113,0,61,103,117,0,108,95,113,0,
60,87,17,0,61,143,49,0,95,82,124,87,17,0,102,138,186,21,32,127,
69,184,13,130,125,135,133,0,65,122,96,127,69,184,255,47,32,0,29,48,
191,255,104,231,224,81,226,5,191,255,104,231,181,5,255,47,32,0,61,23,
101,0,224,17,226,5,61,54,76,0,191,255,216,242,229,5,125,23,77,0,
181,5,255,47,32,0,64,6,255,0,128,7,225,0,6,232,229,87,64,0,
224,7,96,1,61,143,49,0,10,248,100,138,202,13,32,135,69,184,65,130,
96,135,69,184,255,47,32,0,29,48,191,255,14,231,197,13,61,231,105,0,
255,47,32,0,224,225,226,5,29,48,63,6,166,149,130,0,124,0,64,6,
255,0,132,7,225,240,49,6,77,73,84,65,241,49,178,5,128,7,72,1,
99,7,5,0,1,202,3,194,229,87,64,0,224,7,96,1,10,224,36,87,
41,144,42,23,1,0,224,17,99,23,1,0,178,5,98,31,25,0,36,127,
41,144,36,119,37,144,106,7,1,0,68,122,100,127,41,144,238,121,218,5,
36,111,33,144,100,111,41,144,100,7,61,144,252,47,32,0,229,87,64,0,
224,7,96,1,133,93,34,87,17,0,2,232,234,233,186,5,0,18,245,13,
34,103,21,0,106,103,21,0,34,87,17,0,34,95,21,0,107,87,17,0,
34,23,17,0,98,31,25,0,61,127,1,0,99,23,1,0,15,6,223,255,
185,13,15,118,224,255,125,119,1,0,0,218,35,110,4,0,125,239,17,0,
149,21,61,23,5,0,61,215,13,0,61,223,9,0,224,17,125,23,1,0,
226,5,35,110,4,0,125,239,17,0,165,5,2,104,125,111,25,0,252,47,
32,0,224,217,226,5,26,48,63,6,148,150,130,0,123,0,229,87,64,0,
224,7,96,1,61,143,25,0,10,224,35,86,4,0,234,137,234,5,125,7,
25,0,29,48,191,255,202,244,252,47,32,0,229,87,64,0,224,7,96,1,
35,23,1,0,10,224,224,17,218,165,36,135,61,144,224,129,202,21,32,23,
169,182,32,127,69,184,98,207,57,0,98,199,49,0,65,122,96,127,69,184,
252,47,32,0,32,55,169,182,191,255,160,229,191,7,208,254,252,47,32,0,
191,7,200,254,68,6,255,240,3,30,236,255,99,255,17,0,99,231,13,0,
3,230,12,0,99,215,9,0,99,223,5,0,99,239,1,0,6,208,7,216,
0,50,128,255,100,41,68,238,19,0,61,238,124,221,26,48,29,56,128,255,
14,40,27,48,224,217,218,5,68,54,0,0,38,54,0,252,29,56,128,255,
250,39,29,56,68,54,0,0,38,54,8,252,128,255,236,39,128,255,52,54,
35,215,9,0,35,223,5,0,35,239,1,0,35,255,17,0,35,231,13,0,
3,30,20,0,127,0,84,26,99,255,9,0,99,231,5,0,3,230,4,0,
99,239,1,0,128,239,4,0,6,64,40,63,5,0,93,254,0,0,39,95,
16,0,39,87,21,0,7,62,16,0,63,254,32,0,11,48,200,49,106,0,
10,56,68,54,0,0,38,54,12,252,191,255,74,255,35,239,1,0,35,255,
9,0,35,231,5,0,76,26,127,0,88,26,99,255,5,0,99,231,1,0,
3,224,191,255,160,255,35,255,5,0,35,231,1,0,72,26,127,0,88,26,
99,255,5,0,99,231,1,0,38,103,25,0,3,224,12,6,240,255,201,5,
38,87,5,0,181,5,38,86,4,0,35,255,5,0,35,231,1,0,72,26,
127,0,3,30,236,255,99,255,17,0,99,231,13,0,3,230,12,0,99,215,
9,0,99,223,5,0,99,239,1,0,6,232,135,0,8,216,224,57,178,21,
61,95,25,0,11,6,240,255,233,13,61,215,5,0,224,217,242,5,61,54,
4,0,26,56,27,64,189,255,50,104,26,48,128,255,188,14,15,50,125,55,
25,0,29,48,191,255,130,255,125,223,21,0,202,217,91,7,0,0,35,215,
9,0,35,223,5,0,35,239,1,0,35,255,17,0,35,231,13,0,3,30,
20,0,127,0,80,26,99,255,13,0,99,231,9,0,3,230,8,0,99,223,
5,0,99,239,1,0,6,232,7,216,224,233,194,13,61,54,8,0,1,58,
0,66,191,255,96,255,129,218,201,5,29,48,128,255,88,14,35,223,5,0,
35,239,1,0,35,255,13,0,35,231,9,0,3,30,16,0,127,0,88,26,
99,255,5,0,99,231,1,0,3,224,191,255,148,254,35,255,5,0,35,231,
1,0,72,26,127,0,80,26,99,255,13,0,99,231,9,0,3,230,8,0,
99,223,5,0,99,239,1,0,6,232,7,216,224,233,194,13,61,54,8,0,
1,58,0,66,191,255,250,254,129,218,201,5,29,48,128,255,242,13,35,223,
5,0,35,239,1,0,35,255,13,0,35,231,9,0,3,30,16,0,127,0,
88,26,99,255,5,0,99,231,1,0,3,224,191,255,46,254,35,255,5,0,
35,231,1,0,72,26,127,0,88,26,99,255,5,0,99,231,1,0,38,103,
25,0,3,224,12,6,240,255,201,5,38,87,5,0,181,5,38,86,4,0,
35,255,5,0,35,231,1,0,72,26,127,0,88,26,99,255,5,0,99,231,
1,0,3,224,72,50,191,255,198,255,35,255,5,0,35,231,1,0,72,26,
127,0,80,26,99,255,13,0,99,231,9,0,3,230,8,0,99,223,5,0,
99,239,1,0,6,232,7,216,224,233,194,13,61,54,8,0,1,58,0,66,
191,255,74,254,129,218,201,5,29,48,128,255,66,13,35,223,5,0,35,239,
1,0,35,255,13,0,35,231,9,0,3,30,16,0,127,0,3,30,236,255,
99,255,17,0,99,231,13,0,3,230,12,0,99,215,9,0,99,223,5,0,
99,239,1,0,7,208,0,234,6,216,191,255,216,253,234,209,161,13,27,48,
191,255,206,253,59,55,21,0,202,49,250,49,235,239,0,0,29,80,35,215,
9,0,35,223,5,0,35,239,1,0,35,255,17,0,35,231,13,0,3,30,
20,0,127,0,88,26,99,255,5,0,99,231,1,0,38,87,21,0,72,26,
127,0,80,26,99,255,13,0,99,231,9,0,3,230,8,0,99,239,1,0,
7,232,99,223,5,0,6,216,191,255,118,253,123,239,21,0,202,233,93,7,
0,0,35,223,5,0,35,239,1,0,35,255,13,0,35,231,9,0,3,30,
16,0,127,0,3,30,228,255,99,255,25,0,99,231,21,0,99,207,17,0,
99,215,13,0,99,223,9,0,99,239,5,0,6,232,61,103,21,0,8,208,
3,230,20,0,7,216,251,97,185,5,128,255,34,1,61,207,21,0,187,201,
250,201,169,5,25,208,224,209,162,29,29,48,191,255,14,253,27,112,202,113,
99,119,1,0,29,48,191,255,0,253,202,217,26,56,35,55,1,0,219,57,
25,64,186,65,128,255,112,33,61,63,21,0,29,48,186,57,191,255,82,255,
29,80,35,207,17,0,35,215,13,0,35,223,9,0,35,239,5,0,35,255,
25,0,35,231,21,0,3,30,28,0,127,0,3,30,228,255,99,255,25,0,
99,231,21,0,3,230,20,0,99,207,17,0,99,215,13,0,99,223,9,0,
99,239,5,0,6,216,7,200,8,208,99,79,1,0,25,48,191,255,240,254,
250,81,201,5,27,48,128,255,134,0,25,48,191,255,224,254,35,119,1,0,
10,232,186,233,253,113,169,5,14,232,27,48,29,56,249,217,186,13,218,57,
31,66,191,255,18,255,27,48,26,64,0,58,191,255,8,255,149,29,0,66,
128,255,6,3,224,81,194,21,27,48,191,255,72,252,99,87,1,0,25,48,
191,255,176,253,35,55,1,0,26,56,202,57,29,64,189,255,206,100,27,48,
29,56,191,255,152,254,27,80,35,207,17,0,35,215,13,0,35,223,9,0,
35,239,5,0,35,255,25,0,35,231,21,0,3,30,28,0,127,0,64,0,
3,30,172,255,99,255,81,0,99,231,77,0,3,230,76,0,99,215,73,0,
99,223,69,0,99,239,65,0,128,239,4,0,68,222,0,0,59,222,160,252,
3,48,0,58,0,66,191,255,0,252,27,56,3,48,128,255,88,1,68,94,
0,0,43,94,56,252,99,95,33,0,68,54,0,0,38,54,152,252,99,55,
29,0,35,54,36,0,0,58,0,66,191,255,212,251,35,54,36,0,3,56,
0,66,31,74,191,255,220,254,68,86,0,0,42,86,120,252,99,87,33,0,
68,214,0,0,58,215,213,252,35,222,28,0,224,209,242,5,27,48,93,254,
0,0,63,254,116,0,122,0,35,87,33,0,93,254,0,0,42,71,24,0,
42,63,29,0,63,254,144,0,8,72,219,73,9,48,103,0,27,48,191,255,
224,250,35,54,36,0,1,58,0,66,191,255,112,251,3,48,1,58,0,66,
191,255,102,251,35,215,73,0,35,223,69,0,35,239,65,0,35,255,81,0,
35,231,77,0,3,30,84,0,127,0,3,30,236,255,99,255,17,0,99,231,
13,0,3,230,12,0,99,215,9,0,99,223,5,0,99,239,1,0,8,208,
6,232,7,216,191,255,0,253,29,48,224,81,242,29,191,255,240,250,170,217,
29,48,191,255,70,253,251,81,201,5,29,48,191,255,220,254,29,48,191,255,
54,253,10,56,187,57,231,209,169,5,26,56,29,48,219,57,31,66,191,255,
114,253,29,48,27,64,0,58,191,255,104,253,181,21,26,56,0,66,128,255,
100,1,224,81,210,13,29,48,191,255,166,250,10,48,27,56,26,64,189,255,
58,99,29,48,26,56,191,255,4,253,29,80,35,215,9,0,35,223,5,0,
35,239,1,0,35,255,17,0,35,231,13,0,3,30,20,0,127,0,80,26,
99,255,13,0,99,231,9,0,3,230,8,0,99,223,5,0,6,216,99,239,
1,0,7,232,29,48,128,255,108,30,27,48,29,56,10,64,191,255,50,255,
35,223,5,0,35,239,1,0,35,255,13,0,35,231,9,0,3,30,16,0,
127,0,64,0,3,30,172,255,99,255,81,0,99,231,77,0,3,230,76,0,
99,215,73,0,99,223,69,0,99,239,65,0,128,239,4,0,68,222,0,0,
59,222,192,252,3,48,0,58,0,66,191,255,48,250,27,56,3,48,191,255,
136,255,68,94,0,0,43,94,56,252,99,95,33,0,68,54,0,0,38,54,
184,252,99,55,29,0,35,54,36,0,0,58,0,66,191,255,4,250,35,54,
36,0,3,56,0,66,31,74,191,255,12,253,68,86,0,0,42,86,88,252,
99,87,33,0,68,214,0,0,58,215,213,252,35,222,28,0,224,209,242,5,
27,48,93,254,0,0,63,254,116,0,122,0,35,87,33,0,93,254,0,0,
42,71,24,0,42,63,29,0,63,254,144,0,8,72,219,73,9,48,103,0,
27,48,191,255,16,249,35,54,36,0,1,58,0,66,191,255,160,249,3,48,
1,58,0,66,191,255,150,249,35,215,73,0,35,223,69,0,35,239,65,0,
35,255,81,0,35,231,77,0,3,30,84,0,127,0,3,30,228,255,99,255,
25,0,99,231,21,0,3,230,20,0,99,207,17,0,99,215,13,0,99,223,
9,0,99,239,5,0,6,232,7,216,8,208,154,0,126,218,179,5,191,255,
238,254,61,63,25,0,251,57,137,61,61,207,21,0,155,214,15,0,126,210,
179,5,27,208,245,13,26,96,3,90,235,103,194,2,7,48,129,50,230,97,
249,5,30,82,166,81,234,57,187,5,6,208,199,209,26,54,1,0,128,255,
144,6,99,87,1,0,224,201,162,13,29,48,191,255,214,248,35,55,1,0,
25,64,10,56,189,255,104,97,29,48,1,58,0,66,191,255,236,248,35,119,
1,0,125,215,25,0,29,48,25,56,125,119,5,0,191,255,28,251,149,29,
224,209,226,13,27,6,240,255,177,13,61,103,21,0,29,48,1,58,251,97,
251,103,50,67,191,255,186,248,165,13,224,217,138,13,125,223,21,0,29,48,
191,255,126,248,74,7,0,0,224,217,35,223,9,0,35,231,21,0,35,255,
25,0,35,239,5,0,35,215,13,0,35,207,17,0,234,87,0,0,3,30,
28,0,127,0,88,26,99,255,5,0,99,231,1,0,38,87,1,0,72,26,
127,0,88,26,99,255,5,0,99,231,1,0,3,224,224,49,210,5,129,58,
185,5,128,255,90,7,35,255,5,0,35,231,1,0,72,26,127,0,127,0,
84,26,99,255,9,0,99,231,5,0,99,239,1,0,68,102,19,0,44,103,
1,217,3,230,4,0,6,232,224,97,210,13,68,54,19,0,38,54,124,221,
68,62,0,0,39,62,32,253,128,255,112,16,128,255,140,45,61,95,1,0,
224,89,218,13,68,54,19,0,38,55,5,217,230,233,242,5,125,55,1,0,
68,14,19,0,97,239,5,217,35,239,1,0,35,255,9,0,35,231,5,0,
76,26,127,0,12,0,3,30,220,255,99,255,33,0,99,231,29,0,3,230,
28,0,99,207,25,0,99,215,21,0,99,223,17,0,99,239,13,0,128,239,
4,0,99,55,9,0,68,214,19,0,58,214,0,217,58,223,1,0,0,202,
133,69,35,119,9,0,224,113,178,13,59,55,5,0,224,49,210,53,35,119,
9,0,38,103,1,0,236,113,250,45,59,55,1,0,224,201,202,5,122,55,
1,0,181,5,121,55,1,0,58,119,1,0,59,55,9,0,99,119,5,0,
224,49,210,13,59,119,13,0,2,58,93,254,0,0,63,254,104,0,99,119,
1,0,14,104,109,0,181,13,59,119,13,0,93,254,0,0,63,254,126,0,
99,119,1,0,14,104,109,0,35,119,5,0,58,95,1,0,235,113,170,197,
165,5,27,200,59,223,1,0,224,217,138,197,35,207,25,0,35,215,21,0,
35,223,17,0,35,239,13,0,35,255,33,0,35,231,29,0,3,30,36,0,
127,0,3,30,236,255,99,255,17,0,99,231,13,0,3,230,12,0,99,215,
9,0,99,223,5,0,99,239,1,0,128,239,4,0,6,208,181,29,39,103,
1,0,7,48,122,103,1,0,38,63,5,0,224,57,178,13,38,223,9,0,
7,48,2,58,93,254,0,0,63,254,40,0,123,0,133,13,38,223,9,0,
93,254,0,0,63,254,56,0,123,0,58,63,1,0,224,57,186,229,35,215,
9,0,35,223,5,0,35,239,1,0,35,255,17,0,35,231,13,0,3,30,
20,0,127,0,88,26,99,255,5,0,99,231,1,0,68,102,19,0,44,103,
1,217,3,224,224,97,210,5,0,50,191,255,148,254,245,5,68,54,19,0,
38,54,4,217,191,255,94,255,35,255,5,0,35,231,1,0,72,26,127,0,
3,30,236,255,99,255,17,0,99,231,13,0,3,230,12,0,99,215,9,0,
99,223,5,0,99,239,1,0,128,239,4,0,68,118,0,0,46,119,105,253,
0,218,224,113,250,29,1,114,68,14,0,0,97,119,105,253,93,54,0,0,
38,54,168,255,128,255,46,43,133,13,65,218,9,208,93,254,0,0,63,254,
52,0,122,0,27,48,194,50,68,86,255,255,202,49,38,79,181,124,38,54,
180,124,224,73,250,237,35,215,9,0,35,223,5,0,35,239,1,0,35,255,
17,0,35,231,13,0,3,30,20,0,127,0,88,26,99,255,5,0,99,231,
1,0,3,224,9,50,128,255,106,4,35,255,5,0,35,231,1,0,72,26,
127,0,16,0,3,30,216,255,99,255,37,0,99,231,33,0,3,230,32,0,
99,207,29,0,99,215,25,0,99,223,21,0,99,239,17,0,128,239,4,0,
6,200,7,208,99,71,9,0,99,79,13,0,99,7,5,0,224,201,194,101,
127,210,234,29,35,119,13,0,224,113,162,29,68,54,0,0,38,55,109,253,
35,111,9,0,153,49,38,87,5,0,38,223,1,0,42,48,237,55,34,2,
230,217,178,5,191,255,124,255,35,111,9,0,27,208,99,223,5,0,237,215,
194,2,35,119,41,0,224,113,130,37,35,111,9,0,26,222,255,255,237,223,
34,2,99,7,1,0,217,217,165,21,27,48,35,111,41,0,2,58,93,254,
0,0,63,254,128,0,109,0,35,119,1,0,35,111,9,0,65,114,99,119,
1,0,173,217,35,119,1,0,250,113,198,237,35,119,45,0,224,113,226,29,
35,111,13,0,35,63,5,0,35,71,53,0,35,223,49,0,25,48,205,57,
173,49,224,217,202,5,128,255,14,4,229,13,224,65,242,5,93,254,0,0,
63,254,206,0,123,0,229,5,93,254,0,0,63,254,218,0,123,0,35,207,
29,0,35,215,25,0,35,223,21,0,35,239,17,0,35,255,37,0,35,231,
33,0,3,30,40,0,127,0,3,30,228,255,99,255,25,0,35,95,29,0,
9,80,0,74,99,231,21,0,3,230,20,0,127,58,218,5,68,78,0,0,
41,79,109,253,99,87,1,0,99,95,5,0,99,7,9,0,99,7,13,0,
99,7,17,0,191,255,172,254,35,255,25,0,35,231,21,0,3,30,28,0,
127,0,12,0,32,0,3,30,200,255,99,255,53,0,99,231,49,0,3,230,
48,0,99,207,45,0,99,215,41,0,99,223,37,0,99,239,33,0,128,239,
4,0,6,208,7,200,99,71,25,0,99,79,29,0,224,209,178,5,224,73,
226,45,35,223,25,0,224,209,249,223,34,2,154,29,35,55,29,0,35,119,
69,0,219,49,224,113,202,5,128,255,20,3,245,5,93,254,0,0,63,254,
64,0,14,104,109,0,10,208,224,209,194,5,35,111,29,0,205,209,224,209,
178,101,35,119,29,0,224,113,210,21,68,54,0,0,38,55,109,253,154,49,
102,223,1,0,57,72,102,79,5,0,165,13,35,119,81,0,224,113,226,13,
35,223,25,0,249,223,34,2,213,5,35,119,81,0,224,113,210,5,26,48,
27,56,128,255,146,1,35,119,61,0,224,113,242,61,0,218,99,215,29,0,
149,61,35,119,57,0,35,55,29,0,35,63,61,0,224,113,138,29,99,63,
21,0,0,58,99,7,1,0,99,7,5,0,99,7,9,0,99,7,13,0,
99,7,17,0,0,66,35,111,21,0,0,74,93,254,0,0,63,254,220,0,
109,0,165,21,99,63,21,0,35,111,21,0,14,56,93,254,0,0,63,254,
242,0,109,0,35,119,57,0,35,111,25,0,205,113,99,119,57,0,35,111,
25,0,35,119,29,0,65,218,205,113,99,119,29,0,249,217,246,197,26,80,
35,207,45,0,35,215,41,0,35,239,33,0,35,255,53,0,35,231,49,0,
35,223,37,0,3,30,56,0,127,0,3,30,220,255,99,255,33,0,99,231,
29,0,3,230,28,0,9,80,0,74,224,49,218,5,68,78,0,0,41,79,
109,253,99,7,1,0,99,87,5,0,99,7,9,0,99,7,13,0,99,7,
17,0,99,7,21,0,99,7,25,0,191,255,108,254,35,255,33,0,35,231,
29,0,3,30,36,0,127,0,88,26,99,255,5,0,99,231,1,0,3,224,
6,50,128,255,58,1,35,255,5,0,35,231,1,0,72,26,127,0,3,30,
236,255,99,255,17,0,99,231,13,0,3,230,12,0,99,215,9,0,99,223,
5,0,99,239,1,0,128,239,4,0,6,208,224,209,186,29,1,210,149,29,
68,54,0,0,38,55,237,254,93,222,0,0,59,222,186,1,224,49,162,5,
6,216,93,254,0,0,63,254,42,0,123,0,93,102,0,0,44,102,186,1,
236,217,186,5,0,82,229,5,26,48,128,255,178,38,224,81,194,229,35,215,
9,0,35,223,5,0,35,239,1,0,35,255,17,0,35,231,13,0,3,30,
20,0,127,0,88,26,99,255,5,0,99,231,1,0,3,224,7,64,0,58,
189,255,194,91,35,255,5,0,35,231,1,0,72,26,127,0,88,26,99,255,
5,0,99,231,1,0,3,224,0,82,95,50,104,50,251,53,70,0,9,0,
14,0,19,0,24,0,29,0,34,0,39,0,44,0,49,0,68,86,0,0,
42,86,112,253,133,45,68,86,0,0,42,86,188,253,181,37,68,86,0,0,
42,86,244,253,229,29,68,86,0,0,42,86,160,254,149,29,68,86,0,0,
42,86,40,254,197,21,68,86,0,0,42,86,72,254,245,13,68,86,0,0,
42,86,108,254,165,13,68,86,0,0,42,86,132,254,213,5,68,86,0,0,
42,86,132,253,35,255,5,0,35,231,1,0,72,26,127,0,80,26,99,255,
13,0,99,231,9,0,3,230,8,0,99,223,5,0,99,239,1,0,6,232,
1,50,191,255,90,255,10,216,29,48,191,255,82,255,68,54,19,0,38,54,
124,221,27,64,10,72,68,62,0,0,39,62,228,254,128,255,118,9,128,255,
146,38,35,223,5,0,35,239,1,0,35,255,13,0,35,231,9,0,3,30,
16,0,127,0,88,26,99,255,5,0,99,231,1,0,3,224,224,49,178,5,
128,255,12,35,35,255,5,0,35,231,1,0,72,26,127,0,88,26,99,255,
5,0,99,231,1,0,3,224,191,255,82,254,35,255,5,0,35,231,1,0,
72,26,127,0,88,26,99,255,5,0,99,231,1,0,3,224,191,255,184,255,
35,255,5,0,35,231,1,0,72,26,127,0,127,0,84,26,99,255,9,0,
99,231,5,0,3,230,4,0,99,239,1,0,128,239,4,0,6,56,39,103,
5,0,39,95,9,0,39,55,1,0,93,254,0,0,65,98,103,103,5,0,
63,254,30,0,107,0,35,239,1,0,35,255,9,0,35,231,5,0,76,26,
127,0,88,26,99,255,5,0,99,231,1,0,3,224,6,6,208,255,238,103,
0,0,6,6,199,255,231,95,0,0,44,89,202,5,32,62,48,0,149,21,
134,54,32,0,32,86,255,0,6,6,159,255,238,79,0,0,6,6,154,255,
231,71,0,0,41,65,218,5,32,62,87,0,6,80,167,81,35,255,5,0,
35,231,1,0,72,26,127,0,84,26,99,255,9,0,99,231,5,0,3,230,
4,0,99,239,1,0,128,239,4,0,7,64,127,50,242,13,40,103,5,0,
40,95,13,0,40,63,1,0,93,254,0,0,95,98,104,103,5,0,63,254,
34,0,107,0,35,239,1,0,35,255,9,0,35,231,5,0,76,26,127,0,
3,30,156,254,99,79,97,1,99,71,93,1,99,255,81,1,99,231,77,1,
3,230,76,1,99,207,73,1,99,215,69,1,99,223,65,1,99,239,61,1,
99,63,5,0,99,7,25,0,99,7,29,0,102,7,5,0,6,200,128,7,
218,1,35,87,5,0,10,87,0,0,10,48,6,6,224,255,162,13,87,50,
100,50,243,5,165,37,35,79,5,0,65,74,99,79,5,0,35,55,5,0,
6,55,0,0,6,6,224,255,210,245,87,50,100,50,163,245,213,5,25,48,
191,255,166,254,10,216,127,218,186,5,128,7,90,6,27,6,224,255,226,245,
27,54,247,255,100,50,163,245,128,7,56,6,10,6,219,255,194,13,251,81,
178,5,128,7,58,6,35,79,5,0,65,74,99,79,5,0,128,7,98,1,
35,71,5,0,1,106,65,66,99,71,5,0,8,239,0,0,99,111,21,0,
0,210,99,7,17,0,29,6,219,255,218,5,65,66,99,71,5,0,181,101,
35,95,5,0,11,239,0,0,65,90,99,95,5,0,29,78,208,255,105,74,
251,5,234,215,64,2,218,233,29,214,208,255,133,245,29,6,180,255,218,5,
2,106,99,111,17,0,149,237,29,6,148,255,218,5,35,111,17,0,65,106,
245,245,29,6,152,255,218,5,35,111,17,0,95,106,133,245,29,6,150,255,
130,221,29,6,134,255,210,213,29,6,140,255,162,213,29,6,162,255,202,13,
35,95,93,1,28,66,67,90,72,89,68,90,99,95,93,1,43,215,253,255,
197,197,29,6,214,255,202,5,99,7,21,0,229,189,29,6,219,255,202,5,
31,82,128,7,142,5,29,6,157,255,210,21,29,6,165,255,162,21,29,6,
146,255,242,13,213,5,25,48,191,255,154,253,10,216,127,218,130,13,27,6,
224,255,130,253,27,94,247,255,100,90,195,245,224,209,207,5,58,6,64,66,
15,0,0,58,29,6,219,255,226,45,29,6,176,255,226,101,29,6,168,255,
210,101,29,6,165,255,186,5,128,7,242,2,29,6,157,255,178,45,29,6,
156,255,178,93,29,6,151,255,162,93,29,6,146,255,177,5,128,7,198,4,
186,5,128,7,46,4,29,6,144,255,233,77,146,77,29,6,141,255,186,5,
128,7,190,2,29,6,139,255,194,69,29,6,136,255,130,69,128,7,158,4,
27,6,219,255,178,5,128,7,206,4,25,48,191,255,10,253,10,216,128,7,
174,4,42,6,64,66,15,0,234,209,170,5,1,210,35,111,21,0,224,105,
242,29,35,79,93,1,28,50,67,74,70,73,68,74,41,111,253,255,99,79,
93,1,99,111,37,0,165,21,35,111,21,0,224,105,162,13,35,103,37,0,
76,223,0,0,35,111,37,0,65,106,99,111,37,0,25,48,191,255,182,252,
10,216,95,210,188,5,128,7,132,3,127,218,170,237,128,7,124,3,32,62,
224,255,70,58,66,58,72,58,35,111,21,0,99,7,33,0,224,105,210,13,
35,79,93,1,28,50,67,74,70,73,68,74,41,111,253,255,99,79,93,1,
99,111,33,0,27,232,99,63,9,0,99,215,13,0,99,7,45,0,99,7,
49,0,99,7,41,0,3,50,224,57,142,13,1,106,99,111,49,0,32,110,
16,0,99,111,9,0,29,6,211,255,194,5,29,6,213,255,186,21,35,79,
13,0,9,110,255,255,99,111,13,0,97,74,183,13,29,6,211,255,226,111,
0,0,99,111,45,0,25,48,191,255,30,252,10,232,29,6,208,255,218,53,
35,111,9,0,224,105,194,5,13,6,240,255,218,53,35,71,13,0,8,110,
255,255,99,111,13,0,224,65,231,37,25,48,191,255,242,251,10,232,29,6,
136,255,194,5,29,6,168,255,170,21,35,63,13,0,7,110,255,255,99,111,
13,0,224,57,167,13,99,239,41,0,25,48,191,255,202,251,10,232,32,110,
16,0,133,21,32,110,48,0,99,111,41,0,35,111,9,0,224,105,170,13,
8,106,229,5,35,111,9,0,224,105,202,5,10,106,99,111,9,0,0,210,
0,218,29,48,191,255,218,251,35,111,13,0,10,248,224,105,210,5,35,103,
9,0,236,249,166,21,35,111,41,0,13,6,208,255,242,77,224,105,130,13,
29,48,25,56,191,255,8,252,35,239,41,0,229,69,29,218,189,217,197,117,
27,88,195,218,193,90,26,72,159,74,11,73,99,79,57,0,26,72,26,104,
193,106,99,111,53,0,35,111,9,0,157,74,9,217,195,210,106,106,186,13,
35,87,53,0,35,63,57,0,202,209,225,95,0,0,199,89,203,217,149,13,
13,6,240,255,234,5,218,209,225,63,0,0,219,57,199,217,31,64,191,66,
31,72,218,73,9,208,225,63,0,0,199,65,219,65,8,216,25,48,191,255,
252,250,10,232,29,48,191,255,56,251,35,111,13,0,10,248,95,106,99,111,
13,0,210,5,35,103,9,0,236,249,246,189,35,111,45,0,224,105,226,5,
128,209,225,87,0,0,128,81,138,217,35,111,33,0,224,105,194,37,35,111,
49,0,224,105,202,29,35,111,17,0,126,106,234,5,35,103,33,0,76,215,
0,0,245,21,224,105,238,5,35,103,33,0,108,215,0,0,133,21,35,111,
17,0,97,106,135,13,35,103,33,0,108,223,5,0,108,215,1,0,213,5,
35,103,33,0,108,215,1,0,29,216,127,218,190,5,128,7,24,2,128,7,
250,1,68,78,0,0,41,78,240,254,99,79,1,0,99,31,41,0,29,6,
141,255,210,5,35,110,4,0,99,111,41,0,35,111,21,0,89,7,16,0,
99,7,45,0,224,105,210,13,35,71,93,1,28,90,67,66,75,65,68,66,
40,111,253,255,99,71,93,1,99,111,45,0,35,239,41,0,99,215,49,0,
99,223,33,0,61,239,1,0,29,71,0,0,31,218,8,6,162,255,234,215,
0,0,170,5,65,234,35,54,60,0,224,209,226,63,0,0,32,70,0,1,
189,255,106,84,29,87,0,0,10,6,163,255,202,5,67,215,153,0,149,37,
29,55,0,0,6,6,211,255,250,21,127,218,210,21,29,63,1,0,224,57,
146,21,7,6,163,255,226,13,65,234,229,5,27,48,195,49,70,215,60,0,
65,218,29,87,0,0,234,217,135,253,31,218,229,5,6,216,27,72,195,73,
73,215,60,0,29,63,1,0,65,234,7,6,163,255,186,221,35,103,41,0,
65,234,108,239,1,0,35,239,45,0,213,13,224,233,226,5,35,111,33,0,
93,111,0,0,65,234,25,48,191,255,118,249,99,87,33,0,35,111,33,0,
127,106,226,13,195,105,13,79,60,0,224,73,146,13,35,71,49,0,8,110,
255,255,99,111,49,0,224,65,207,229,35,103,45,0,236,233,218,5,1,50,
89,55,16,0,213,5,224,233,178,5,93,7,0,0,25,63,16,0,35,223,
33,0,224,57,202,117,35,111,25,0,35,103,21,0,65,106,99,111,25,0,
35,111,29,0,204,105,99,111,29,0,213,93,35,111,21,0,224,105,146,93,
35,111,17,0,28,58,35,87,93,1,127,106,254,13,10,54,3,0,71,49,
57,87,5,0,68,50,99,55,93,1,38,55,253,255,95,82,70,87,0,0,
197,69,224,105,254,13,10,78,3,0,71,73,57,63,5,0,68,74,99,79,
93,1,41,79,253,255,95,58,105,63,0,0,197,53,57,55,5,0,35,111,
17,0,95,50,97,106,135,21,10,94,3,0,71,89,68,90,99,95,93,1,
43,95,253,255,6,56,191,58,107,55,1,0,107,63,5,0,229,29,67,82,
71,81,68,82,99,87,93,1,42,87,253,255,106,55,1,0,197,21,35,87,
25,0,149,45,35,111,29,0,35,103,21,0,204,105,99,111,29,0,35,111,
25,0,65,106,99,111,25,0,197,5,29,50,134,217,181,13,127,218,146,13,
35,63,5,0,7,63,0,0,224,57,178,5,191,7,102,249,27,48,25,56,
191,255,216,248,127,218,250,5,35,111,25,0,224,105,186,5,31,82,181,5,
35,87,29,0,35,207,73,1,35,215,69,1,35,223,65,1,35,239,61,1,
35,255,81,1,35,231,77,1,3,30,100,1,127,0,88,26,99,255,5,0,
99,231,1,0,38,87,1,0,10,87,0,0,3,224,224,81,242,5,38,95,
1,0,65,90,102,95,1,0,165,5,31,82,35,255,5,0,35,231,1,0,
72,26,127,0,88,26,99,255,5,0,99,231,1,0,3,224,224,49,130,13,
127,50,226,5,39,103,1,0,95,98,103,103,1,0,35,255,5,0,35,231,
1,0,72,26,127,0,24,0,3,30,204,255,99,79,49,0,99,71,45,0,
99,255,33,0,99,231,29,0,3,230,28,0,99,239,25,0,128,239,4,0,
99,31,5,0,93,94,0,0,43,94,130,255,99,95,13,0,93,86,0,0,
42,86,180,255,35,71,45,0,35,79,49,0,99,87,17,0,99,55,1,0,
35,54,4,0,191,255,64,248,35,239,25,0,35,255,33,0,35,231,29,0,
3,30,52,0,127,0,3,30,224,255,99,79,29,0,99,255,13,0,35,94,
16,0,203,94,7,0,99,95,5,0,99,71,25,0,35,102,24,0,99,103,
1,0,35,71,1,0,35,79,5,0,99,231,9,0,3,230,8,0,191,255,
106,255,35,255,13,0,35,231,9,0,3,30,32,0,127,0,3,30,224,255,
99,79,29,0,99,255,13,0,35,94,16,0,203,94,7,0,99,95,5,0,
99,71,25,0,35,102,24,0,99,103,1,0,35,71,1,0,35,79,5,0,
99,231,9,0,3,230,8,0,128,255,130,9,35,255,13,0,35,231,9,0,
3,30,32,0,127,0,88,26,99,255,5,0,99,231,1,0,6,80,39,55,
1,0,70,87,0,0,65,50,103,55,1,0,35,231,1,0,35,255,5,0,
138,0,72,26,127,0,8,0,3,30,220,255,99,79,33,0,99,71,29,0,
99,255,17,0,99,231,13,0,3,230,12,0,99,239,9,0,128,239,4,0,
99,55,5,0,35,54,4,0,7,64,35,103,33,0,35,79,29,0,93,62,
0,0,39,62,182,255,99,103,1,0,128,255,36,3,35,95,5,0,75,7,
0,0,35,239,9,0,35,255,17,0,35,231,13,0,3,30,36,0,127,0,
3,30,224,255,99,79,29,0,99,255,13,0,35,94,16,0,203,94,7,0,
99,95,5,0,99,71,25,0,35,102,24,0,99,103,1,0,35,71,1,0,
35,79,5,0,99,231,9,0,3,230,8,0,191,255,112,255,35,255,13,0,
35,231,9,0,3,30,32,0,127,0,88,26,99,255,5,0,99,231,1,0,
3,224,197,13,6,88,10,82,234,95,194,98,12,102,48,0,71,103,255,255,
95,58,234,55,194,2,224,49,202,245,224,65,146,13,229,5,32,54,48,0,
71,55,255,255,95,58,231,65,161,253,35,231,1,0,35,255,5,0,7,80,
72,26,127,0,24,0,3,30,208,255,99,255,45,0,99,231,41,0,3,230,
40,0,99,207,37,0,99,215,33,0,99,223,29,0,99,239,25,0,128,239,
4,0,99,55,13,0,38,119,9,0,7,216,224,217,99,119,17,0,38,207,
13,0,99,223,1,0,250,5,68,222,0,0,59,222,249,254,99,223,1,0,
27,48,128,255,228,9,35,111,13,0,13,103,21,0,45,55,5,0,224,97,
194,5,234,49,169,5,6,80,10,112,219,113,99,119,9,0,35,119,13,0,
46,119,1,0,234,113,99,119,5,0,190,5,99,87,5,0,35,79,13,0,
35,215,5,0,9,79,16,0,170,209,224,73,210,29,27,55,0,0,6,6,
211,255,242,5,6,6,213,255,194,5,6,6,224,255,170,5,65,218,27,103,
0,0,12,6,208,255,154,13,27,95,1,0,139,86,32,0,10,6,136,255,
170,5,66,218,32,118,48,0,181,5,32,118,32,0,99,119,21,0,229,13,
14,79,0,0,65,114,99,119,1,0,35,63,17,0,9,48,93,254,0,0,
63,254,204,0,121,0,35,119,1,0,251,113,129,245,35,71,13,0,8,71,
17,0,224,65,194,13,149,29,35,55,21,0,35,63,17,0,93,254,0,0,
63,254,244,0,121,0,95,210,224,209,223,245,197,13,27,103,0,0,65,218,
35,63,17,0,93,254,0,0,12,48,63,254,18,1,121,0,35,111,9,0,
237,217,161,245,181,13,35,63,17,0,32,54,32,0,93,254,0,0,63,254,
46,1,121,0,95,210,224,209,223,245,35,207,37,0,35,215,33,0,35,223,
29,0,35,239,25,0,35,255,45,0,35,231,41,0,35,87,5,0,3,30,
48,0,127,0,3,30,140,255,99,255,113,0,99,231,109,0,99,223,105,0,
99,239,101,0,6,232,61,79,5,0,3,230,108,0,8,216,3,70,99,0,
224,73,174,5,1,74,72,7,0,0,7,48,8,56,169,65,191,255,6,254,
10,64,224,217,194,5,72,223,255,255,95,66,29,48,8,56,191,255,62,254,
35,223,105,0,35,239,101,0,35,255,113,0,35,231,109,0,3,30,116,0,
127,0,88,26,99,255,5,0,99,231,1,0,6,103,27,0,8,80,3,224,
204,54,32,0,213,13,199,94,15,0,68,78,0,0,201,89,11,71,1,255,
132,58,6,65,74,71,255,255,95,82,224,57,186,245,35,255,5,0,35,231,
1,0,72,26,127,0,88,26,99,255,5,0,99,231,1,0,6,80,42,55,
5,0,3,224,224,49,174,5,1,50,166,73,224,57,238,5,32,54,48,0,
72,55,255,255,95,66,233,65,171,253,224,57,167,13,10,95,27,0,32,54,
48,0,72,55,254,255,72,95,255,255,94,66,10,48,8,56,191,255,158,253,
35,255,5,0,35,231,1,0,72,26,127,0,156,0,3,30,60,255,99,79,
193,0,99,255,177,0,99,231,173,0,3,230,172,0,99,207,169,0,99,215,
165,0,99,223,161,0,99,239,157,0,128,239,4,0,99,55,21,0,99,63,
13,0,8,216,0,210,224,217,218,5,68,222,0,0,59,222,249,254,35,111,
21,0,99,111,137,0,35,111,13,0,99,111,141,0,128,7,102,5,6,80,
10,6,219,255,226,13,35,103,13,0,35,63,21,0,10,48,93,254,0,0,
63,254,72,0,108,0,65,218,128,7,50,5,65,218,67,7,3,0,31,50,
99,55,129,0,99,55,133,0,35,54,144,0,197,5,70,7,0,0,65,50,
35,78,155,0,233,49,163,253,27,255,0,0,31,6,211,255,218,5,1,50,
67,55,145,0,197,29,31,48,31,6,213,255,202,5,67,55,146,0,213,21,
6,6,208,255,218,5,1,50,67,55,144,0,229,13,31,80,31,6,224,255,
202,5,67,87,147,0,245,5,10,6,221,255,234,5,1,50,67,55,148,0,
65,218,181,221,31,78,208,255,106,74,169,21,0,50,245,5,234,55,64,2,
65,218,198,89,11,54,208,255,99,55,129,0,27,95,0,0,11,78,208,255,
106,74,177,245,149,29,31,6,214,255,234,21,35,55,193,0,28,74,67,50,
73,49,68,50,99,55,193,0,38,55,253,255,99,55,129,0,224,49,254,5,
128,49,99,55,129,0,1,50,67,55,145,0,65,218,27,87,0,0,10,6,
210,255,250,53,1,106,27,71,1,0,67,111,3,0,65,218,8,70,208,255,
106,66,169,21,0,50,245,5,234,55,64,2,65,218,198,81,10,54,208,255,
99,55,133,0,27,87,0,0,10,70,208,255,106,66,177,245,197,29,27,55,
0,0,6,6,214,255,186,21,35,95,193,0,28,66,67,90,72,89,68,90,
99,95,193,0,43,95,253,255,99,95,133,0,224,89,142,13,31,50,99,55,
133,0,197,5,99,7,133,0,165,5,65,218,27,63,0,0,7,6,224,255,
178,253,7,6,148,255,138,13,27,63,1,0,65,218,7,6,148,255,218,37,
197,5,7,6,180,255,234,5,65,218,1,50,67,55,151,0,197,29,7,6,
152,255,250,13,27,87,1,0,1,50,65,218,10,6,152,255,218,5,65,218,
67,55,154,0,229,13,67,55,153,0,181,13,7,6,150,255,242,5,7,6,
134,255,194,5,7,6,140,255,170,5,65,218,27,63,0,0,65,218,67,63,
155,0,7,6,191,255,186,5,128,7,112,2,7,54,187,255,98,50,187,5,
128,7,100,2,107,50,186,5,128,7,22,1,6,6,237,255,186,5,128,7,
48,1,6,6,228,255,186,5,128,7,72,2,6,6,226,255,177,5,128,7,
38,3,186,5,128,7,12,3,6,6,225,255,162,37,6,6,221,255,177,5,
128,7,40,2,6,6,220,255,162,29,6,6,215,255,177,5,128,7,0,3,
186,5,128,7,62,2,6,6,213,255,201,117,146,101,6,6,210,255,186,5,
128,7,174,2,6,6,208,255,178,109,6,6,205,255,130,109,128,7,216,2,
3,95,3,0,224,89,178,5,67,7,144,0,3,87,151,0,35,79,193,0,
224,81,226,37,35,55,197,0,9,80,10,70,255,255,200,62,4,0,231,49,
226,79,0,0,194,74,202,73,9,54,3,0,28,58,71,49,72,50,99,55,
193,0,38,79,253,255,38,71,249,255,93,86,0,0,42,86,180,9,224,81,
242,5,35,54,128,0,128,255,216,6,128,7,172,2,8,200,149,13,67,74,
28,50,70,73,68,74,99,79,193,0,41,207,253,255,3,79,153,0,224,73,
178,5,249,0,229,5,3,63,154,0,224,57,162,5,185,0,3,71,146,0,
25,56,224,65,186,5,3,71,147,0,224,57,206,5,32,70,45,0,128,57,
35,54,128,0,149,109,3,87,155,0,35,79,193,0,28,50,72,82,67,87,
155,0,67,74,70,73,68,74,41,111,253,255,99,79,193,0,99,111,9,0,
181,93,3,79,3,0,224,73,178,5,67,7,144,0,3,71,151,0,35,63,
193,0,224,65,130,45,35,87,197,0,7,64,8,54,255,255,198,94,4,0,
235,81,226,63,0,0,194,58,200,57,7,54,3,0,28,90,75,49,72,50,
99,55,193,0,38,95,253,255,38,87,249,255,93,70,0,0,40,70,254,8,
224,65,146,13,10,64,11,72,35,54,128,0,128,255,84,5,128,7,222,1,
10,200,181,13,67,58,28,82,74,57,68,58,39,111,253,255,99,63,193,0,
99,111,9,0,3,63,153,0,224,57,242,5,35,111,9,0,205,0,99,111,
9,0,229,5,3,95,154,0,224,89,162,5,153,0,3,79,155,0,9,6,
139,255,170,13,35,63,9,0,35,54,128,0,0,66,191,255,226,250,128,7,
140,1,3,111,148,0,35,79,9,0,67,7,127,0,3,86,127,0,99,111,
17,0,224,73,186,5,99,79,17,0,3,63,155,0,99,87,25,0,7,6,
145,255,170,21,35,111,17,0,128,105,99,111,17,0,149,13,201,54,7,0,
6,54,48,0,74,55,255,255,95,82,131,74,224,73,250,245,245,5,9,56,
10,64,35,54,128,0,191,255,232,250,35,63,17,0,35,79,25,0,35,54,
128,0,10,64,191,255,22,251,128,7,30,1,68,110,0,0,45,62,17,255,
99,63,25,0,35,54,128,0,191,255,226,248,35,103,25,0,32,54,41,0,
76,55,15,0,35,103,25,0,202,209,76,7,16,0,149,125,3,87,154,0,
224,81,226,13,35,79,193,0,28,50,67,74,70,73,68,74,99,79,193,0,
41,79,253,255,73,215,0,0,133,109,3,71,153,0,35,87,193,0,224,65,
210,13,10,62,3,0,28,82,74,57,68,58,99,63,193,0,39,63,253,255,
103,215,0,0,229,85,3,55,151,0,28,58,224,49,130,21,10,94,3,0,
71,89,68,90,99,95,193,0,43,95,253,255,26,56,191,58,107,215,1,0,
107,63,5,0,165,69,67,82,71,81,68,82,99,87,193,0,42,87,253,255,
106,215,1,0,133,61,35,79,193,0,67,7,144,0,28,82,1,50,67,74,
74,73,68,74,99,79,193,0,9,64,40,63,253,255,67,55,149,0,35,54,
128,0,165,37,35,63,193,0,28,82,67,58,74,57,68,58,99,63,193,0,
7,63,252,255,67,63,4,0,67,7,5,0,167,0,224,57,218,13,35,63,
21,0,35,103,13,0,0,50,93,254,0,0,63,254,124,5,108,0,65,210,
133,13,35,54,128,0,35,62,4,0,191,255,220,247,202,209,27,55,0,0,
224,49,178,5,191,7,150,250,26,80,35,207,169,0,35,215,165,0,35,239,
157,0,35,255,177,0,35,231,173,0,35,223,161,0,3,30,196,0,127,0,
4,2,3,30,212,253,99,79,41,2,99,71,37,2,99,255,25,2,99,231,
21,2,3,230,20,2,99,207,17,2,99,215,13,2,99,223,9,2,99,239,
5,2,128,239,4,0,7,200,6,216,128,255,198,4,27,103,15,0,12,208,
220,210,159,210,135,98,209,5,9,50,128,255,254,30,133,61,59,95,5,0,
224,89,154,21,219,175,15,0,35,86,4,0,123,87,5,0,35,78,4,0,
32,54,0,2,123,79,1,0,123,55,9,0,219,151,15,0,27,48,93,62,
0,0,35,103,41,2,35,79,37,2,39,62,254,3,25,64,99,103,1,0,
191,255,146,249,10,200,59,87,5,0,35,94,4,0,235,81,170,13,27,48,
128,255,198,5,123,7,5,0,123,7,1,0,123,7,9,0,224,209,218,5,
219,223,15,0,162,5,31,202,27,48,128,255,18,4,25,80,35,207,17,2,
35,215,13,2,35,239,5,2,35,255,25,2,35,231,21,2,35,223,9,2,
3,30,44,2,127,0,3,30,224,255,99,79,29,0,99,71,25,0,99,255,
13,0,99,231,9,0,35,94,16,0,203,94,7,0,99,95,5,0,35,102,
20,0,99,103,1,0,6,64,99,63,21,0,8,56,35,71,1,0,35,79,
5,0,3,230,8,0,68,54,19,0,38,54,108,221,191,255,220,254,35,255,
13,0,35,231,9,0,3,30,32,0,127,0,8,2,6,232,7,224,8,216,
224,233,218,5,59,239,1,0,224,233,194,13,29,48,28,56,128,255,96,0,
10,48,6,96,221,97,12,95,0,0,224,89,186,5,0,82,149,29,198,233,
29,48,28,56,128,255,130,0,10,48,221,81,10,79,0,0,6,64,224,73,
202,5,8,56,221,57,197,5,221,65,8,62,1,0,123,63,1,0,221,49,
70,7,0,0,29,80,30,2,9,2,6,232,7,224,191,255,118,215,29,48,
28,56,42,70,180,0,191,255,142,255,31,2,10,2,7,232,6,248,181,13,
29,56,165,5,65,58,7,95,0,0,224,89,130,13,232,89,170,253,65,50,
6,71,0,0,224,65,186,245,6,80,191,81,32,2,6,56,6,103,0,0,
65,50,224,97,202,253,167,49,6,86,255,255,127,0,10,2,7,232,6,248,
181,13,29,56,165,5,65,58,7,87,0,0,232,81,130,13,224,81,170,253,
65,50,6,71,0,0,224,65,186,245,6,80,191,81,32,2,6,80,7,103,
0,0,65,58,70,103,0,0,65,50,224,97,154,253,127,0,7,64,6,56,
135,87,1,0,136,55,1,0,65,58,65,66,138,49,186,5,224,81,250,245,
6,80,127,0,6,88,7,72,8,80,224,81,178,29,11,64,8,96,169,97,
234,97,235,13,202,65,95,66,202,73,95,74,9,63,0,0,95,74,72,63,
0,0,95,66,95,82,154,253,149,13,9,55,0,0,65,74,72,55,0,0,
65,66,95,82,154,253,11,80,127,0,104,0,17,2,99,79,1,0,6,208,
58,55,5,0,57,6,0,202,154,59,7,232,35,62,103,0,224,49,174,5,
1,50,7,216,166,217,71,7,0,0,32,78,34,0,25,48,194,50,229,45,
0,82,0,98,0,226,9,6,225,255,222,5,25,80,233,87,192,0,165,5,
28,96,193,226,253,49,219,13,232,81,219,5,65,226,166,233,170,65,245,5,
253,49,217,5,65,226,166,233,170,65,95,234,129,50,95,74,252,229,12,232,
28,88,12,89,194,5,7,78,247,255,165,5,7,72,8,48,9,64,191,255,
84,244,10,56,28,64,3,50,4,74,224,233,170,213,8,48,27,64,191,255,
64,244,35,119,1,0,10,216,224,113,194,5,91,119,255,255,95,218,90,7,
20,0,26,48,27,56,191,255,112,244,39,2,104,0,108,0,17,2,6,200,
8,208,9,216,3,254,107,0,67,7,107,0,26,80,27,81,186,5,89,215,
20,0,25,111,20,0,25,87,27,0,99,255,1,0,99,111,5,0,10,6,
145,255,218,21,128,105,99,111,5,0,213,13,218,230,7,0,28,54,48,0,
95,55,255,255,95,250,131,210,27,64,221,66,8,209,131,218,26,72,27,73,
170,245,229,37,26,72,27,232,25,48,10,6,139,255,250,5,29,56,9,64,
0,74,191,255,222,254,165,37,35,71,1,0,9,56,191,255,204,245,10,248,
224,233,194,13,35,55,1,0,88,50,229,5,32,62,48,0,95,63,255,255,
95,250,255,49,161,253,25,48,29,56,31,64,191,255,166,245,10,248,35,63,
5,0,35,79,1,0,31,64,25,48,191,255,212,245,39,2,108,0,10,2,
6,232,29,255,18,0,224,249,186,5,29,255,19,0,224,73,174,13,32,254,
45,0,8,48,128,49,225,71,0,0,128,65,136,73,6,64,9,56,29,48,
31,72,191,255,102,254,32,2,0,2,39,103,9,0,6,64,95,98,103,103,
9,0,204,5,128,255,132,1,165,13,39,55,1,0,8,80,138,0,70,71,
0,0,65,50,103,55,1,0,22,2,68,94,19,0,43,94,92,221,6,72,
171,73,164,74,9,6,236,255,177,13,194,74,68,62,19,0,39,62,156,222,
9,64,199,65,8,48,191,7,80,212,127,0,9,2,68,54,19,0,38,54,
92,221,198,55,47,0,198,47,15,0,198,55,31,0,6,230,32,0,38,103,
28,0,38,87,44,0,6,238,16,0,32,110,0,192,77,97,77,81,138,86,
2,0,140,102,1,0,102,103,28,0,102,87,44,0,191,255,152,255,29,48,
191,255,146,255,28,48,191,255,140,255,31,2,68,94,19,0,43,94,92,221,
171,49,164,50,6,6,236,255,177,13,194,50,68,62,19,0,199,49,38,55,
157,222,224,49,178,5,191,7,228,211,127,0,68,94,19,0,43,94,92,221,
171,49,164,50,6,6,236,255,177,13,194,50,68,62,19,0,199,49,38,55,
157,222,224,49,178,5,191,7,192,211,127,0,8,2,6,224,7,232,29,48,
191,255,208,255,61,103,5,0,224,97,202,61,28,48,191,255,164,252,10,216,
224,217,130,13,28,55,0,0,29,56,128,255,122,0,127,82,130,21,95,218,
224,217,135,53,61,87,12,0,28,78,1,0,9,56,27,64,202,54,255,63,
191,255,136,114,251,81,206,37,221,31,15,0,31,226,149,37,61,71,9,0,
95,66,125,71,9,0,28,95,0,0,236,5,11,48,29,56,128,255,56,0,
165,13,61,55,1,0,11,80,138,0,70,95,0,0,65,50,125,55,1,0,
65,226,127,82,186,5,10,224,229,5,28,79,0,0,224,73,170,229,0,226,
29,48,191,255,26,255,28,80,30,2,4,0,19,2,6,216,7,232,68,54,
19,0,38,54,92,221,230,233,193,61,68,86,0,0,234,87,77,255,196,82,
198,81,234,233,201,53,221,247,15,0,146,53,29,55,15,0,61,231,5,0,
218,50,156,50,198,94,9,0,105,90,186,5,125,231,1,0,221,151,15,0,
221,175,15,0,224,225,170,29,61,231,12,0,67,223,3,0,220,230,255,63,
221,255,13,0,226,5,28,48,0,58,2,66,128,255,112,25,28,48,35,62,
3,0,1,66,191,255,188,113,97,82,206,21,221,31,15,0,229,5,29,48,
128,255,38,0,224,81,178,5,31,82,197,13,32,54,255,1,125,55,9,0,
92,223,0,0,65,226,125,231,1,0,27,80,138,0,41,2,4,0,9,2,
0,226,6,232,191,255,140,254,224,233,178,69,61,55,5,0,224,49,242,61,
221,247,15,0,234,5,9,50,128,255,192,24,31,226,245,53,221,239,15,0,
202,53,61,87,1,0,230,81,163,37,221,255,13,0,146,13,61,103,12,0,
0,58,2,66,204,54,255,63,128,255,232,24,61,95,12,0,61,79,1,0,
61,63,5,0,203,54,255,63,9,64,167,65,191,255,40,113,61,55,1,0,
61,63,5,0,167,49,230,81,206,5,221,31,15,0,31,226,61,55,5,0,
221,183,13,0,224,49,32,62,0,2,125,55,1,0,125,63,9,0,186,5,
125,55,9,0,29,48,191,255,214,253,28,80,31,2,227,63,64,2,200,57,
7,87,0,0,70,87,0,0,7,79,1,0,70,79,1,0,7,71,2,0,
6,86,3,0,70,71,2,0,127,0,6,72,7,96,10,50,1,58,197,5,
234,55,64,2,65,58,232,57,198,253,213,13,230,103,192,98,10,90,75,48,
12,80,230,87,192,2,10,86,48,0,73,87,0,0,65,74,95,66,188,245,
9,80,127,0,7,2,6,232,7,216,61,63,25,0,27,48,68,70,0,0,
40,70,86,255,191,255,146,255,32,230,32,0,74,231,0,0,61,63,17,0,
10,54,1,0,68,70,0,0,40,70,110,255,191,255,118,255,74,231,0,0,
61,63,13,0,2,66,10,54,1,0,191,255,136,255,74,231,0,0,61,63,
9,0,2,66,10,54,1,0,191,255,118,255,32,214,58,0,74,215,0,0,
61,63,5,0,2,66,10,54,1,0,191,255,96,255,74,215,0,0,61,63,
1,0,10,54,1,0,2,66,191,255,78,255,74,231,0,0,61,103,21,0,
10,54,1,0,4,66,12,62,108,7,191,255,56,255,74,7,0,0,27,80,
29,2,8,2,6,232,7,224,61,63,9,0,2,66,28,48,191,255,30,255,
32,222,58,0,74,223,0,0,61,63,5,0,2,66,10,54,1,0,191,255,
8,255,74,223,0,0,61,63,1,0,2,66,10,54,1,0,191,255,246,254,
74,7,0,0,28,80,30,2,8,2,6,232,7,216,61,63,25,0,27,48,
68,70,0,0,40,70,86,255,191,255,178,254,32,230,32,0,74,231,0,0,
61,63,17,0,10,54,1,0,68,70,0,0,40,70,110,255,191,255,150,254,
74,231,0,0,61,63,13,0,2,66,10,54,1,0,191,255,168,254,32,54,
44,0,74,55,0,0,74,231,1,0,61,103,21,0,4,66,10,54,2,0,
12,62,108,7,191,255,138,254,74,7,0,0,27,80,30,2,7,72,213,5,
70,63,0,0,65,50,65,66,233,49,217,5,8,63,0,0,224,57,250,245,
6,80,127,0,0,82,9,96,198,97,231,97,219,5,8,56,9,64,191,7,
84,254,127,0,52,0,17,2,99,55,17,0,99,71,13,0,9,200,99,7,
9,0,68,214,19,0,58,214,8,217,58,95,13,1,6,224,220,57,7,222,
255,255,224,89,178,5,128,7,164,4,68,254,0,0,63,254,210,255,68,118,
19,0,46,118,52,218,99,119,5,0,99,7,1,0,35,55,1,0,35,119,
5,0,194,50,6,72,218,73,105,255,1,0,218,49,102,119,49,0,31,55,
0,0,78,55,0,0,31,103,1,0,35,111,5,0,77,103,1,0,31,95,
2,0,35,111,5,0,77,95,2,0,35,111,5,0,77,7,3,0,35,119,
5,0,68,114,99,119,5,0,31,87,0,0,65,250,224,81,202,253,35,119,
1,0,65,114,99,119,1,0,108,114,134,213,68,254,0,0,63,254,150,255,
68,118,19,0,46,118,24,218,99,119,5,0,99,7,1,0,35,55,1,0,
35,119,5,0,194,50,6,64,218,65,104,255,97,0,218,49,102,119,125,0,
31,95,0,0,78,95,0,0,31,87,1,0,35,111,5,0,77,87,1,0,
31,79,2,0,35,111,5,0,77,79,2,0,35,111,5,0,77,7,3,0,
35,119,5,0,68,114,99,119,5,0,31,71,0,0,65,250,224,65,202,253,
35,119,1,0,65,114,99,119,1,0,103,114,134,213,68,62,0,0,39,62,
78,255,122,63,153,0,68,54,0,0,38,54,81,255,122,55,157,0,68,254,
0,0,63,254,42,0,99,7,1,0,35,103,1,0,12,112,65,114,99,119,
1,0,194,98,218,97,108,255,161,0,68,250,14,6,232,255,182,245,93,70,
0,0,40,70,96,255,122,71,1,1,93,62,0,0,39,62,30,255,122,63,
5,1,93,54,0,0,38,54,128,254,122,55,9,1,1,50,122,55,13,1,
128,7,66,3,35,55,13,0,6,55,0,0,6,6,219,255,226,5,92,55,
0,0,65,226,128,7,28,3,35,111,13,0,13,63,1,0,13,118,1,0,
99,119,13,0,7,48,6,6,191,255,129,13,6,6,219,255,186,5,128,7,
234,2,128,7,240,2,6,54,191,255,6,6,199,255,185,5,128,7,226,2,
70,0,75,0,105,0,110,1,10,1,110,1,110,1,110,1,148,0,153,0,
110,1,110,1,110,1,180,0,110,1,110,1,110,1,110,1,110,1,204,0,
27,1,228,0,228,0,228,0,27,1,58,1,67,1,110,1,110,1,110,1,
110,1,110,1,110,1,57,0,91,0,119,0,138,0,110,1,110,1,110,1,
153,0,110,1,167,0,110,1,110,1,174,0,110,1,110,1,185,0,110,1,
110,1,110,1,27,1,209,0,110,1,220,0,10,1,44,1,35,87,9,0,
57,95,25,0,28,48,234,78,16,1,194,90,27,56,218,73,203,73,41,71,
125,0,9,78,124,0,191,255,98,253,245,69,35,79,9,0,57,87,25,0,
28,48,233,102,16,1,194,82,27,56,218,97,44,78,96,0,204,81,42,71,
97,0,229,237,35,103,9,0,57,79,17,0,28,48,236,94,16,1,194,74,
27,56,218,89,201,89,43,71,49,0,133,229,35,95,9,0,57,103,17,0,
28,48,235,78,16,1,194,98,27,56,218,73,201,97,44,71,1,0,165,213,
35,55,9,0,230,70,16,1,93,254,0,0,218,65,40,79,9,1,25,48,
63,254,230,2,35,62,20,0,105,0,28,48,27,56,10,64,245,189,28,48,
27,56,57,71,13,0,2,74,191,255,240,252,10,224,128,7,190,1,28,48,
27,56,57,71,9,0,229,245,57,95,9,0,108,90,199,5,84,90,128,7,
46,1,224,89,178,5,128,7,38,1,12,90,128,7,32,1,57,71,29,0,
28,48,27,56,3,74,65,66,165,229,57,71,17,0,27,56,28,48,65,66,
181,221,28,48,27,56,57,71,5,0,229,213,35,87,9,0,234,102,16,1,
57,87,9,0,28,48,218,97,27,56,108,82,238,95,0,0,194,90,11,72,
204,89,43,71,153,0,191,7,252,254,28,48,27,56,57,71,1,0,229,189,
57,95,25,0,224,89,170,5,7,90,11,78,48,0,92,79,0,0,128,7,
44,1,57,71,25,0,8,70,48,0,92,71,0,0,128,7,28,1,35,103,
13,0,57,71,25,0,0,90,12,103,0,0,0,250,224,65,239,79,0,0,
12,6,171,255,186,5,1,74,197,13,12,6,170,255,218,5,4,90,32,254,
52,0,213,5,12,6,169,255,170,5,1,90,57,87,29,0,168,81,202,89,
212,5,7,66,72,88,201,89,234,45,31,88,197,45,35,55,9,0,230,70,
16,1,93,254,0,0,218,65,40,103,1,1,25,48,63,254,12,4,35,62,
20,0,108,0,191,7,218,254,35,55,9,0,230,70,16,1,93,254,0,0,
218,65,40,95,5,1,25,48,63,254,46,4,35,62,20,0,107,0,191,7,
184,254,57,95,21,0,11,6,156,255,214,5,32,86,100,0,234,95,128,90,
28,48,27,56,11,64,191,7,172,254,57,95,21,0,28,48,27,56,4,74,
11,70,108,7,191,7,156,254,128,255,10,12,10,88,127,90,162,45,224,89,
190,5,11,94,160,5,32,70,60,0,11,56,232,63,128,74,224,73,250,29,
224,89,214,29,32,54,60,0,11,72,70,72,9,6,232,255,238,21,35,103,
9,0,28,48,236,94,16,1,27,56,194,74,218,89,201,89,43,71,161,0,
191,7,194,253,32,54,37,0,92,55,0,0,181,5,92,63,0,0,65,226,
35,119,13,0,65,114,99,119,13,0,224,225,178,21,251,225,153,13,35,95,
13,0,11,95,0,0,224,89,178,5,191,7,178,252,27,86,1,0,234,225,
185,5,92,7,0,0,251,225,186,5,0,82,197,5,35,87,17,0,156,81,
39,2,52,0,48,0,17,2,6,208,58,239,17,0,12,90,58,87,21,0,
29,216,75,216,235,239,128,234,202,217,224,233,190,5,76,234,95,218,27,62,
254,255,7,6,119,255,185,5,128,7,38,1,58,103,13,0,29,88,193,90,
68,70,0,0,200,89,43,231,146,0,0,202,95,98,27,254,44,1,204,225,
223,54,3,0,138,21,32,94,100,0,31,80,235,87,128,98,224,97,138,13,
32,70,144,1,31,56,232,63,128,74,224,73,170,5,1,202,31,72,32,62,
144,1,31,88,71,248,32,86,100,0,74,88,4,98,76,72,171,73,201,249,
31,54,167,255,224,201,194,5,97,234,175,5,95,226,58,103,9,0,58,87,
5,0,252,103,68,2,58,239,1,0,204,81,252,87,68,2,213,5,42,6,
128,81,1,0,31,50,198,225,202,233,164,253,29,56,45,6,128,81,1,0,
237,239,192,234,32,54,109,1,251,55,32,2,237,63,192,2,199,225,6,86,
50,156,202,225,128,255,146,10,252,87,68,2,58,79,33,0,202,233,224,73,
174,29,28,64,248,71,64,2,8,88,252,95,68,2,29,72,252,95,68,2,
35,54,4,0,35,62,12,0,203,73,99,79,5,0,128,255,138,10,10,48,
224,49,226,29,38,71,33,0,122,71,33,0,58,63,33,0,224,57,178,5,
29,238,240,241,28,64,248,71,64,2,252,71,68,2,252,71,68,2,3,48,
35,62,12,0,8,72,201,233,99,239,1,0,128,255,80,10,10,48,224,49,
186,5,31,82,133,13,26,56,32,70,36,0,128,255,224,18,35,87,1,0,
39,2,48,0,88,26,99,255,5,0,99,231,1,0,68,62,19,0,39,62,
100,218,39,103,29,0,6,248,3,224,236,249,193,85,39,95,33,0,235,249,
137,85,223,86,7,0,218,77,39,55,9,0,63,95,253,255,230,249,169,13,
6,80,10,48,38,87,5,0,234,249,185,13,230,81,161,253,133,13,6,80,
42,55,1,0,230,81,185,5,255,49,163,253,103,87,9,0,42,63,253,255,
255,81,219,5,7,72,202,73,233,249,209,45,0,74,0,98,7,64,202,65,
255,65,234,5,10,248,63,87,5,0,199,89,1,74,11,56,223,57,230,57,
138,21,38,63,1,0,38,55,253,255,106,255,1,0,127,87,5,0,1,98,
198,89,7,48,127,55,1,0,102,255,5,0,127,95,253,255,224,73,186,13,
224,97,154,13,106,255,1,0,127,87,5,0,127,55,1,0,102,255,5,0,
35,255,5,0,35,231,1,0,72,26,127,0,84,26,99,255,9,0,99,231,
5,0,3,230,4,0,99,239,1,0,6,232,191,255,228,200,224,233,194,5,
29,48,191,255,18,255,191,255,204,200,35,239,1,0,35,255,9,0,35,231,
5,0,76,26,127,0,3,30,232,255,99,255,21,0,99,231,17,0,99,207,
13,0,99,215,9,0,99,239,1,0,99,223,5,0,68,222,19,0,59,222,
100,218,59,103,37,0,6,232,7,200,3,230,16,0,224,97,218,5,32,54,
0,8,123,55,37,0,59,55,37,0,29,208,6,88,221,89,71,90,95,50,
38,232,75,233,212,21,250,233,177,21,29,48,128,255,68,11,10,56,127,58,
250,13,224,201,178,13,26,238,8,0,24,98,76,233,29,48,128,255,44,11,
10,56,127,58,186,5,0,82,197,53,199,78,7,0,178,5,8,50,134,73,
59,87,33,0,231,81,138,13,29,48,199,49,123,55,33,0,9,216,199,217,
181,29,59,55,29,0,224,49,178,5,230,57,185,5,123,63,29,0,59,55,
33,0,224,49,210,5,29,64,199,65,232,49,217,5,29,48,199,49,123,55,
33,0,9,48,199,49,6,222,8,0,72,74,169,233,71,234,24,82,74,233,
123,239,253,255,27,48,191,255,30,254,27,80,35,207,13,0,35,215,9,0,
35,223,5,0,35,239,1,0,35,255,21,0,35,231,17,0,3,30,24,0,
127,0,3,30,228,255,99,255,25,0,99,231,21,0,3,230,20,0,99,207,
17,0,99,215,13,0,99,223,9,0,99,239,5,0,6,222,11,0,24,90,
75,217,230,217,185,5,0,82,245,117,27,6,240,255,177,5,32,222,16,0,
68,214,19,0,58,214,100,218,58,239,9,0,224,233,154,21,224,233,218,13,
122,239,1,0,26,54,20,0,122,55,9,0,122,55,21,0,122,55,25,0,
122,7,17,0,58,239,9,0,29,56,61,239,1,0,61,79,253,255,251,73,
193,45,61,87,1,0,122,63,9,0,9,48,187,49,6,6,240,255,241,5,
103,87,1,0,106,63,5,0,29,72,181,69,58,71,33,0,221,73,232,73,
218,5,29,64,219,233,1,90,197,5,6,64,221,65,0,90,8,72,104,223,
253,255,125,55,253,255,224,89,130,53,103,239,1,0,125,63,5,0,125,87,
1,0,106,239,5,0,245,37,58,55,9,0,230,233,186,205,99,55,1,0,
27,200,25,48,0,58,191,255,32,254,224,81,218,21,61,63,1,0,7,64,
40,63,1,0,231,65,217,5,58,54,20,0,230,57,138,253,40,55,253,255,
1,58,153,49,191,255,250,253,10,72,224,73,226,5,35,119,1,0,122,119,
9,0,149,173,9,80,35,207,17,0,35,215,13,0,35,223,9,0,35,239,
5,0,35,255,25,0,35,231,21,0,3,30,28,0,127,0,84,26,99,255,
9,0,99,231,5,0,3,230,4,0,99,239,1,0,6,232,191,255,116,198,
29,48,191,255,172,254,10,232,191,255,94,198,29,80,35,239,1,0,35,255,
9,0,35,231,5,0,76,26,127,0,8,2,191,255,80,198,32,230,35,0,
28,48,194,50,68,86,19,0,202,49,38,223,141,218,38,54,140,218,224,217,
146,13,0,58,102,7,1,0,93,254,0,0,63,254,46,0,123,0,95,226,
204,237,68,230,19,0,60,231,237,222,224,225,162,13,93,254,0,0,63,254,
72,0,124,0,68,14,19,0,97,7,237,222,191,255,246,197,30,2,8,2,
6,216,68,230,19,0,191,255,242,197,60,103,29,219,60,230,28,219,224,97,
170,13,93,94,0,0,43,94,166,255,124,95,1,0,28,48,128,255,140,11,
0,74,9,48,194,50,68,70,19,0,200,49,38,63,141,218,38,54,140,218,
224,57,250,5,102,223,1,0,191,255,170,197,0,82,133,13,65,74,9,6,
220,255,198,237,191,255,154,197,31,82,30,2,88,26,99,255,5,0,99,231,
1,0,3,224,6,50,128,255,122,7,35,255,5,0,35,231,1,0,72,26,
127,0,4,0,17,2,6,248,7,216,8,232,0,226,0,210,0,202,99,255,
1,0,165,5,65,250,31,71,0,0,8,6,224,255,178,253,8,94,248,255,
102,90,241,245,8,6,211,255,186,5,1,202,197,5,8,6,213,255,170,5,
65,250,224,233,154,29,31,95,0,0,11,6,208,255,170,21,31,103,1,0,
12,6,136,255,194,5,12,6,168,255,218,5,66,250,32,238,16,0,197,37,
11,6,208,255,186,5,8,234,245,29,10,234,213,29,29,86,254,255,10,6,
221,255,249,5,224,217,178,5,123,255,1,0,0,82,149,85,31,79,0,0,
9,6,208,255,218,13,31,63,1,0,7,6,136,255,194,5,7,6,168,255,
218,5,29,6,240,255,170,5,66,250,31,56,31,55,0,0,65,250,6,70,
208,255,106,66,185,5,8,48,181,21,6,102,159,255,12,6,230,255,193,5,
6,54,169,255,181,13,6,94,191,255,11,6,230,255,193,5,6,54,201,255,
181,5,32,54,37,0,253,49,206,13,31,74,166,73,253,79,194,2,233,225,
163,5,1,210,253,231,34,2,198,225,149,221,65,58,231,249,202,5,35,255,
1,0,65,250,224,217,194,5,95,250,123,255,1,0,224,201,162,5,128,225,
224,209,226,5,31,226,32,54,34,0,128,255,154,10,28,80,39,2,4,0,
0,2,38,79,5,0,38,103,1,0,32,94,168,58,32,70,168,58,32,62,
240,120,236,95,32,2,44,6,39,70,15,0,233,71,32,2,204,89,11,80,
176,90,203,65,8,88,71,88,235,63,32,2,128,254,0,128,167,65,128,62,
121,224,235,63,32,2,102,71,5,0,202,0,167,81,102,87,1,0,38,71,
1,0,224,65,158,21,8,72,128,65,176,66,8,94,1,0,11,80,38,71,
5,0,208,82,202,73,102,79,1,0,171,65,102,71,5,0,133,21,64,62,
1,0,231,65,198,13,38,103,1,0,38,95,5,0,176,66,204,0,102,103,
1,0,200,89,102,95,5,0,38,63,5,0,224,57,190,13,7,86,240,120,
102,87,5,0,38,87,1,0,128,78,121,224,201,81,229,205,38,87,1,0,
7,6,16,135,215,13,38,103,5,0,128,62,121,224,167,81,102,87,1,0,
12,102,16,135,102,103,5,0,245,189,208,58,199,81,164,82,255,87,192,82,
22,2,10,2,68,102,19,0,44,103,37,219,224,97,170,13,1,50,68,14,
19,0,97,55,37,219,68,14,19,0,97,55,41,219,191,255,86,195,68,54,
19,0,38,54,40,219,191,255,246,254,10,232,191,255,58,195,29,80,32,2,
88,26,99,231,5,0,99,239,1,0,6,88,7,48,0,58,0,82,8,6,
192,255,177,21,8,78,224,255,6,56,233,63,128,0,224,73,206,13,6,80,
232,87,128,0,232,95,128,0,41,72,6,56,233,63,192,0,193,58,11,57,
35,239,1,0,35,231,5,0,10,88,7,80,72,26,127,0,88,26,99,231,
5,0,99,239,1,0,7,88,6,56,0,74,0,50,8,6,192,255,177,21,
8,86,224,255,7,48,234,55,192,0,224,81,206,13,11,48,232,55,192,0,
7,72,232,79,192,0,42,80,234,63,128,0,129,58,7,49,35,239,1,0,
35,231,5,0,9,80,6,88,72,26,127,0,3,30,228,255,99,255,25,0,
99,215,21,0,99,223,17,0,99,231,13,0,99,239,9,0,99,55,1,0,
99,63,5,0,8,208,9,216,224,57,170,13,224,217,138,13,35,103,1,0,
250,103,194,90,11,80,0,90,245,29,35,63,5,0,35,55,1,0,27,72,
26,64,128,255,74,0,26,48,250,95,32,2,10,64,232,55,34,82,8,232,
251,239,32,2,202,89,35,87,1,0,250,71,32,2,203,233,35,63,5,0,
168,81,225,95,0,0,135,89,189,89,35,215,21,0,35,223,17,0,35,231,
13,0,35,239,9,0,35,255,25,0,3,30,28,0,127,0,3,30,208,255,
99,255,45,0,99,207,41,0,99,215,37,0,99,223,33,0,99,231,29,0,
99,239,25,0,99,55,9,0,99,63,13,0,99,71,17,0,99,79,21,0,
7,216,191,218,99,63,1,0,99,223,5,0,7,48,224,49,186,13,224,73,
154,13,35,87,9,0,35,103,17,0,0,88,236,87,194,2,181,109,64,70,
0,128,224,49,178,13,32,238,63,0,6,88,72,89,138,21,129,66,95,234,
224,65,170,253,181,13,32,238,31,0,35,103,9,0,72,97,218,5,129,66,
95,234,224,65,154,253,35,55,21,0,64,70,0,128,224,49,178,13,32,78,
63,0,6,56,72,57,138,21,129,66,95,74,224,65,170,253,181,13,32,78,
31,0,35,103,17,0,72,97,218,5,129,66,95,74,224,65,154,253,0,218,
0,226,233,233,182,53,35,215,1,0,35,207,9,0,169,233,178,13,35,63,
21,0,35,55,17,0,29,64,191,255,80,254,10,64,11,72,213,5,35,79,
21,0,35,71,17,0,9,56,8,48,165,29,28,64,159,66,193,226,193,218,
8,217,231,209,219,5,231,209,186,13,230,201,145,13,230,201,225,71,0,0,
199,65,168,209,166,201,156,230,1,0,7,64,223,66,129,58,129,50,8,49,
95,234,224,233,238,229,28,80,27,88,35,207,41,0,35,215,37,0,35,223,
33,0,35,231,29,0,35,239,25,0,35,255,45,0,3,30,48,0,127,0,
3,30,228,255,99,255,25,0,99,231,13,0,99,239,9,0,99,215,21,0,
99,63,5,0,99,55,1,0,35,55,5,0,8,208,99,223,17,0,9,216,
35,103,1,0,6,72,64,62,0,128,71,73,71,97,236,73,202,29,224,49,
178,5,127,50,138,29,27,64,8,80,71,81,26,72,71,73,233,81,154,21,
224,65,178,5,127,66,218,13,35,55,1,0,0,74,250,55,192,2,6,64,
71,65,162,5,31,74,9,88,6,80,165,69,224,49,198,13,224,217,166,13,
35,63,5,0,35,55,1,0,27,72,26,64,191,255,56,254,213,53,224,49,
198,21,27,72,26,64,128,65,35,55,1,0,35,63,5,0,225,95,0,0,
128,89,139,73,191,255,24,254,128,81,225,55,0,0,128,49,134,89,133,37,
35,231,1,0,35,63,5,0,128,225,225,55,0,0,128,49,134,57,28,48,
224,217,182,13,26,64,27,72,191,255,236,253,128,81,225,63,0,0,128,57,
135,89,165,13,128,209,225,71,0,0,128,65,136,217,26,64,27,72,191,255,
206,253,35,215,21,0,35,223,17,0,35,231,13,0,35,239,9,0,35,255,
25,0,3,30,28,0,127,0,127,0,88,26,99,255,5,0,99,231,1,0,
3,224,191,255,242,255,68,86,19,0,42,87,241,222,32,102,60,0,35,231,
1,0,35,255,5,0,76,80,72,26,127,0,3,30,232,255,99,255,21,0,
99,231,17,0,3,230,16,0,99,223,9,0,6,216,99,215,13,0,7,208,
99,239,5,0,0,234,191,255,180,255,59,63,1,0,252,87,68,2,7,48,
170,49,99,55,1,0,127,58,130,13,26,56,3,48,128,255,190,2,10,56,
224,57,186,5,0,82,245,117,39,55,17,0,6,94,253,255,103,90,177,5,
0,234,197,61,105,50,194,5,99,50,242,21,229,53,39,55,25,0,39,71,
13,0,136,49,165,5,9,48,6,78,7,0,9,6,225,255,183,253,230,65,
134,45,230,65,250,37,39,79,9,0,98,74,190,37,149,37,39,71,21,0,
39,55,13,0,39,79,25,0,8,6,169,255,142,21,6,64,9,48,136,49,
165,5,9,48,6,78,7,0,9,6,225,255,183,253,230,65,207,13,230,65,
186,13,213,5,233,49,135,13,224,73,218,5,39,103,9,0,98,98,166,5,
1,234,103,239,33,0,224,233,242,45,39,95,9,0,65,90,103,95,9,0,
11,6,232,255,250,37,39,87,29,0,39,79,25,0,103,7,9,0,65,82,
103,87,29,0,65,74,103,79,25,0,103,74,186,5,103,7,25,0,39,55,
17,0,68,102,0,0,39,71,13,0,204,49,6,95,178,0,65,66,103,71,
13,0,235,65,151,13,39,87,17,0,1,50,103,55,13,0,65,82,103,87,
17,0,7,80,35,215,13,0,35,223,9,0,35,239,5,0,35,255,21,0,
35,231,17,0,3,30,24,0,127,0,84,26,99,255,9,0,99,231,5,0,
3,230,4,0,99,239,1,0,6,232,191,255,62,190,42,62,184,0,29,48,
191,255,144,254,35,239,1,0,35,255,9,0,35,231,5,0,76,26,127,0,
3,30,236,255,99,255,17,0,99,231,13,0,3,230,12,0,99,215,9,0,
99,223,5,0,99,239,1,0,128,239,4,0,6,216,27,102,255,255,12,6,
224,255,185,5,31,82,229,29,191,255,240,189,27,96,194,98,12,64,202,65,
40,215,1,0,105,218,178,5,224,209,218,5,27,48,128,255,100,3,213,13,
97,210,178,13,10,56,202,97,108,7,1,0,27,48,93,254,0,0,63,254,
72,0,122,0,0,82,35,215,9,0,35,223,5,0,35,239,1,0,35,255,
17,0,35,231,13,0,3,30,20,0,127,0,88,26,99,255,5,0,99,231,
1,0,3,224,6,248,224,249,202,5,191,255,138,189,10,248,1,74,9,80,
194,82,223,81,106,7,1,0,65,74,9,6,224,255,135,253,32,78,18,0,
9,96,194,98,223,97,1,50,108,55,1,0,65,74,9,6,232,255,247,245,
32,78,29,0,9,56,194,58,223,57,1,50,103,55,1,0,65,74,9,6,
224,255,247,245,35,255,5,0,35,231,1,0,72,26,127,0,80,26,99,255,
13,0,99,231,9,0,3,230,8,0,99,239,1,0,99,223,5,0,6,216,
191,255,16,189,68,118,19,0,46,119,49,219,224,113,154,13,68,118,22,0,
46,118,24,71,68,14,19,0,97,119,49,219,68,54,19,0,38,55,49,219,
68,102,22,0,44,102,24,71,219,49,230,97,235,13,68,94,122,0,43,94,
8,155,235,49,139,13,68,14,19,0,97,55,49,219,6,232,187,233,213,5,
31,234,12,50,128,255,248,2,191,255,174,188,29,80,35,223,5,0,35,239,
1,0,35,231,9,0,35,255,13,0,3,30,16,0,127,0,3,30,228,255,
99,255,25,0,99,231,21,0,99,207,17,0,99,215,13,0,99,223,9,0,
99,239,5,0,38,239,1,0,7,208,57,6,128,81,1,0,3,230,20,0,
127,234,202,5,0,82,128,7,66,1,122,7,33,0,29,248,213,5,44,6,
0,132,12,36,204,249,224,249,182,253,249,255,192,2,7,74,233,255,128,82,
10,254,253,255,165,5,71,250,224,249,230,253,122,255,25,0,29,56,249,63,
192,250,224,249,222,5,45,6,128,81,1,0,205,249,31,48,32,102,16,14,
76,48,32,86,24,0,234,55,128,90,32,62,60,0,31,64,71,64,231,71,
128,50,231,255,128,82,122,55,5,0,29,56,38,6,224,135,225,1,230,63,
192,2,122,95,9,0,122,87,1,0,7,222,114,1,4,90,27,80,235,87,
128,98,224,97,0,250,138,21,32,70,100,0,27,56,232,63,128,74,224,73,
138,13,32,102,144,1,27,88,236,95,128,50,224,49,170,5,1,250,27,96,
32,94,144,1,75,96,27,64,32,62,100,0,71,64,4,74,27,48,73,48,
27,78,142,254,39,6,128,51,225,1,168,49,233,63,32,2,198,97,12,54,
167,255,249,55,32,2,99,255,1,0,199,49,253,49,183,5,95,218,197,205,
166,233,249,239,192,2,29,6,147,254,186,5,0,234,65,218,35,119,1,0,
224,113,162,5,65,234,122,239,29,0,65,234,0,250,68,86,0,0,223,81,
10,55,190,0,97,250,234,5,35,119,1,0,224,113,162,5,65,50,230,233,
215,5,166,233,65,250,107,250,246,237,27,70,212,254,122,71,21,0,122,255,
17,0,122,239,13,0,26,80,35,207,17,0,35,215,13,0,35,223,9,0,
35,239,5,0,35,255,25,0,35,231,21,0,3,30,28,0,127,0,4,0,
3,30,228,255,99,255,25,0,99,231,21,0,3,230,20,0,99,207,17,0,
99,215,13,0,99,223,9,0,99,239,5,0,128,239,4,0,99,55,1,0,
0,202,191,255,222,186,68,222,19,0,59,223,53,219,165,13,59,215,1,0,
93,254,0,0,63,254,34,0,122,0,59,223,5,0,224,217,234,245,68,118,
0,0,46,119,205,0,224,113,242,5,191,255,186,186,42,54,220,0,128,255,
4,0,35,63,1,0,2,50,128,255,8,1,25,96,172,0,2,90,76,88,
203,78,1,0,98,74,145,253,191,255,126,186,35,207,17,0,35,215,13,0,
35,223,9,0,35,239,5,0,35,255,25,0,35,231,21,0,3,30,28,0,
127,0,88,26,99,255,5,0,99,231,1,0,3,224,1,50,191,255,80,255,
35,255,5,0,35,231,1,0,72,26,127,0,84,26,99,255,9,0,99,231,
5,0,3,230,4,0,99,239,1,0,6,232,191,255,52,186,68,14,19,0,
33,103,53,219,125,103,5,0,97,239,53,219,191,255,22,186,35,239,1,0,
35,255,9,0,35,231,5,0,76,26,127,0,84,26,99,255,9,0,99,231,
5,0,3,230,4,0,99,239,1,0,128,239,4,0,93,102,0,0,44,102,
2,186,224,97,234,5,68,86,19,0,42,86,4,223,245,5,191,255,236,185,
10,48,224,81,162,5,6,80,35,239,1,0,35,255,9,0,35,231,5,0,
76,26,127,0,84,26,99,255,9,0,99,231,5,0,3,230,4,0,99,239,
1,0,6,232,191,255,164,255,224,81,178,5,106,239,1,0,35,239,1,0,
35,255,9,0,35,231,5,0,76,26,127,0,92,26,99,255,1,0,97,2,
0,82,131,255,74,8,217,5,10,48,191,255,190,255,31,82,35,255,1,0,
68,26,127,0,88,26,99,255,5,0,99,231,1,0,3,224,8,80,7,72,
9,64,10,72,6,56,38,6,7,0,4,0,191,255,196,255,35,255,5,0,
35,231,1,0,72,26,127,0,88,26,99,255,5,0,99,231,1,0,3,224,
8,80,7,72,9,64,10,72,6,56,38,6,1,0,4,0,191,255,152,255,
35,255,5,0,35,231,1,0,72,26,127,0,88,0,96,0,106,0,116,0,
132,0,142,0,152,0,162,0,172,0,182,0,192,0,240,0,208,0,218,0,
228,0,0,1,246,0,10,1,20,1,30,1,40,1,50,1,84,1,98,1,
114,1,130,1,148,1,164,1,180,1,196,1,212,1,228,1,244,1,74,1,
88,1,104,1,120,1,138,1,154,1,170,1,186,1,202,1,218,1,234,1,
128,7,33,0,224,7,68,1,128,7,33,0,128,7,193,255,165,13,128,7,
33,0,128,7,193,247,213,5,128,7,33,0,128,7,193,243,240,239,64,0,
224,7,68,1,128,7,33,0,128,7,193,241,229,29,128,7,33,0,128,7,
193,240,149,29,128,7,33,0,128,7,193,112,197,21,128,7,33,0,128,7,
193,48,245,13,128,7,33,0,128,7,193,16,165,13,128,7,33,0,128,7,
193,0,213,5,128,7,33,0,128,7,65,0,240,239,64,0,224,7,68,1,
128,7,33,0,128,7,193,255,165,13,128,7,33,0,128,7,193,247,213,5,
128,7,33,0,128,7,193,243,128,7,78,0,128,7,33,0,213,37,128,7,
33,0,128,7,193,240,229,29,128,7,33,0,128,7,193,241,149,29,128,7,
33,0,128,7,193,112,197,21,128,7,33,0,128,7,193,48,245,13,128,7,
33,0,128,7,193,16,165,13,128,7,33,0,128,7,193,0,213,5,128,7,
33,0,128,7,65,0,240,239,64,0,240,87,64,0,234,95,253,255,171,25,
106,0,240,255,64,0,255,103,1,0,204,25,64,6,63,0,240,255,64,0,
255,103,1,0,204,25,64,6,192,255,133,21,240,255,64,0,255,103,1,0,
204,25,64,6,192,247,133,13,240,255,64,0,255,103,1,0,204,25,64,6,
192,243,64,6,63,0,240,255,64,0,255,103,1,0,204,25,64,6,192,241,
133,53,240,255,64,0,255,103,1,0,204,25,64,6,192,240,133,45,240,255,
64,0,255,103,1,0,204,25,64,6,192,112,133,37,240,255,64,0,255,103,
1,0,204,25,64,6,192,48,133,29,240,255,64,0,255,103,1,0,204,25,
64,6,192,16,133,21,240,255,64,0,255,103,1,0,204,25,64,6,192,0,
133,13,240,255,64,0,255,103,1,0,204,25,64,6,64,0,64,6,63,0,
229,15,64,0,129,14,15,2,161,14,15,2,96,50,202,5,129,14,1,0,
165,13,97,50,202,5,129,14,10,0,213,5,98,50,186,5,129,14,0,2,
6,80,127,0,80,26,99,55,1,0,99,63,5,0,99,71,9,0,99,79,
13,0,245,5,6,79,0,0,65,50,71,79,0,0,65,58,95,66,224,65,
142,253,35,79,13,0,35,71,9,0,35,63,5,0,35,55,1,0,3,30,
16,0,127,0,224,29,133,0,179,251,0,0,2,0,0,0,84,230,133,0,
244,29,133,0,179,251,0,0,2,0,0,0,86,230,133,0,48,120,48,48,
48,48,48,48,48,48,0,0,0,0,0,0,220,230,133,0,1,0,0,0,
20,38,133,0,2,0,0,0,32,38,133,0,3,0,0,0,196,230,133,0,
4,0,0,0,44,38,133,0,5,0,0,0,204,230,133,0,6,0,0,0,
212,230,133,0,7,0,0,0,56,38,133,0,8,0,0,0,72,38,133,0,
9,0,0,0,88,38,133,0,115,116,114,105,110,103,32,110,111,116,32,102,
111,117,110,100,0,0,0,0,0,0,0,0,12,31,139,0,30,69,128,0,
0,0,0,0,64,28,141,0,90,85,128,0,0,0,0,0,0,0,0,0,
0,0,0,0,180,105,128,0,0,0,0,0,174,105,128,0,0,0,0,0,
172,105,128,0,0,0,0,0,0,0,0,0,0,0,0,0,110,105,128,0,
0,0,0,0,88,105,128,0,0,0,0,0,84,105,128,0,0,0,0,0,
0,0,0,0,0,0,0,0,22,105,128,0,0,0,0,0,88,105,128,0,
0,0,0,0,18,105,128,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,105,128,0,0,0,0,0,174,105,128,0,0,0,0,0,14,105,128,0,
0,0,0,0,220,244,133,0,0,105,128,0,0,0,0,0,0,0,0,0,
0,0,0,0,1,0,0,0,64,2,0,0,2,0,0,0,66,2,0,0,
3,0,0,0,198,1,0,0,4,0,0,0,67,2,0,0,5,0,0,0,
19,48,0,0,6,0,0,0,192,1,0,0,7,0,0,0,0,0,0,0,
10,0,0,0,0,0,0,0,20,0,0,0,0,0,0,0,30,0,0,0,
0,0,0,0,40,0,0,0,0,0,0,0,50,0,0,0,0,0,0,0,
60,0,0,0,0,0,0,0,70,0,0,0,0,0,0,0,80,0,0,0,
0,0,0,0,90,0,0,0,0,0,0,0,112,28,141,0,194,105,128,0,
0,0,0,0,192,28,141,0,208,105,128,0,0,0,0,0,8,215,255,255,
176,106,128,0,0,0,0,0,56,215,255,255,162,106,128,0,0,0,0,0,
0,0,0,0,0,0,0,0,120,165,130,0,0,0,0,0,120,165,130,0,
0,0,0,0,120,165,130,0,0,0,0,0,8,139,0,0,0,0,0,0,
120,165,130,0,0,0,0,0,120,165,130,0,0,0,0,0,110,137,0,0,
0,0,0,0,228,138,0,0,0,0,0,0,194,138,0,0,0,0,0,0,
158,138,0,0,0,0,0,0,122,138,0,0,0,0,0,0,118,138,0,0,
0,0,0,0,26,137,0,0,0,0,0,0,198,136,0,0,0,0,0,0,
110,136,0,0,0,0,0,0,24,136,0,0,0,0,0,0,140,117,0,0,
0,0,0,0,246,134,0,0,0,0,0,0,138,134,0,0,0,0,0,0,
52,134,0,0,0,0,0,0,218,133,0,0,0,0,0,0,128,133,0,0,
0,0,0,0,50,110,0,0,0,0,0,0,204,132,0,0,0,0,0,0,
208,113,0,0,0,0,0,0,158,131,0,0,0,0,0,0,234,130,0,0,
0,0,0,0,150,130,0,0,0,0,0,0,144,129,0,0,0,0,0,0,
158,127,0,0,0,0,0,0,66,127,0,0,0,0,0,0,30,126,0,0,
0,0,0,0,26,138,0,0,0,0,0,0,56,125,0,0,0,0,0,0,
0,124,0,0,0,0,0,0,110,123,0,0,0,0,0,0,112,138,0,0,
0,0,0,0,102,138,0,0,0,0,0,0,98,138,0,0,0,0,0,0,
92,138,0,0,0,0,0,0,90,138,0,0,0,0,0,0,250,112,0,0,
0,0,0,0,194,122,0,0,0,0,0,0,26,122,0,0,0,0,0,0,
86,138,0,0,0,0,0,0,80,138,0,0,0,0,0,0,76,138,0,0,
0,0,0,0,34,121,0,0,0,0,0,0,48,120,0,0,0,0,0,0,
208,119,0,0,0,0,0,0,94,119,0,0,0,0,0,0,238,118,0,0,
0,0,0,0,62,138,0,0,0,0,0,0,120,165,130,0,0,0,0,0,
120,165,130,0,0,0,0,0,244,114,0,0,0,0,0,0,154,114,0,0,
0,0,0,0,64,114,0,0,0,0,0,0,96,113,0,0,0,0,0,0,
104,112,0,0,0,0,0,0,222,111,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,142,150,0,0,0,0,0,0,166,140,0,0,0,0,0,0,
126,150,0,0,0,0,0,0,8,152,0,0,0,0,0,0,16,150,0,0,
0,0,0,0,250,149,0,0,0,0,0,0,120,149,0,0,0,0,0,0,
228,151,0,0,0,0,0,0,194,151,0,0,0,0,0,0,158,151,0,0,
0,0,0,0,54,149,0,0,0,0,0,0,154,151,0,0,0,0,0,0,
108,151,0,0,0,0,0,0,104,151,0,0,0,0,0,0,212,149,0,0,
0,0,0,0,80,151,0,0,0,0,0,0,172,145,0,0,0,0,0,0,
96,151,0,0,0,0,0,0,82,151,0,0,0,0,0,0,78,151,0,0,
0,0,0,0,74,151,0,0,0,0,0,0,70,151,0,0,0,0,0,0,
254,140,0,0,0,0,0,0,250,148,0,0,0,0,0,0,40,145,0,0,
0,0,0,0,24,151,0,0,0,0,0,0,220,148,0,0,0,0,0,0,
66,151,0,0,0,0,0,0,78,148,0,0,0,0,0,0,238,147,0,0,
0,0,0,0,202,147,0,0,0,0,0,0,38,151,0,0,0,0,0,0,
10,144,0,0,0,0,0,0,32,151,0,0,0,0,0,0,0,124,0,0,
0,0,0,0,30,151,0,0,0,0,0,0,148,151,0,0,0,0,0,0,
138,151,0,0,0,0,0,0,134,151,0,0,0,0,0,0,128,151,0,0,
0,0,0,0,126,151,0,0,0,0,0,0,230,144,0,0,0,0,0,0,
60,151,0,0,0,0,0,0,54,151,0,0,0,0,0,0,122,151,0,0,
0,0,0,0,116,151,0,0,0,0,0,0,112,151,0,0,0,0,0,0,
50,151,0,0,0,0,0,0,44,151,0,0,0,0,0,0,186,146,0,0,
0,0,0,0,194,146,0,0,0,0,0,0,178,146,0,0,0,0,0,0,
62,139,0,0,0,0,0,0,26,151,0,0,0,0,0,0,58,141,0,0,
0,0,0,0,230,150,0,0,0,0,0,0,238,150,0,0,0,0,0,0,
232,150,0,0,0,0,0,0,18,145,0,0,0,0,0,0,244,150,0,0,
0,0,0,0,228,150,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
142,150,0,0,0,0,0,0,166,140,0,0,0,0,0,0,126,150,0,0,
0,0,0,0,8,152,0,0,0,0,0,0,16,150,0,0,0,0,0,0,
250,149,0,0,0,0,0,0,120,149,0,0,0,0,0,0,228,151,0,0,
0,0,0,0,194,151,0,0,0,0,0,0,158,151,0,0,0,0,0,0,
54,149,0,0,0,0,0,0,34,109,128,0,0,0,0,0,108,151,0,0,
0,0,0,0,104,151,0,0,0,0,0,0,212,149,0,0,0,0,0,0,
80,151,0,0,0,0,0,0,172,145,0,0,0,0,0,0,96,151,0,0,
0,0,0,0,82,151,0,0,0,0,0,0,78,151,0,0,0,0,0,0,
74,151,0,0,0,0,0,0,70,151,0,0,0,0,0,0,220,107,128,0,
0,0,0,0,250,148,0,0,0,0,0,0,40,145,0,0,0,0,0,0,
24,151,0,0,0,0,0,0,220,148,0,0,0,0,0,0,66,151,0,0,
0,0,0,0,78,148,0,0,0,0,0,0,8,108,128,0,0,0,0,0,
202,147,0,0,0,0,0,0,38,151,0,0,0,0,0,0,10,144,0,0,
0,0,0,0,32,151,0,0,0,0,0,0,0,124,0,0,0,0,0,0,
30,151,0,0,0,0,0,0,148,151,0,0,0,0,0,0,138,151,0,0,
0,0,0,0,134,151,0,0,0,0,0,0,128,151,0,0,0,0,0,0,
126,151,0,0,0,0,0,0,230,144,0,0,0,0,0,0,60,151,0,0,
0,0,0,0,54,151,0,0,0,0,0,0,122,151,0,0,0,0,0,0,
116,151,0,0,0,0,0,0,112,151,0,0,0,0,0,0,50,151,0,0,
0,0,0,0,44,151,0,0,0,0,0,0,186,146,0,0,0,0,0,0,
194,146,0,0,0,0,0,0,178,146,0,0,0,0,0,0,2,109,128,0,
0,0,0,0,26,151,0,0,0,0,0,0,72,108,128,0,0,0,0,0,
230,150,0,0,0,0,0,0,238,150,0,0,0,0,0,0,232,150,0,0,
0,0,0,0,18,145,0,0,0,0,0,0,244,150,0,0,0,0,0,0,
228,150,0,0,0,0,0,0,0,0,0,0,0,0,0,0,142,150,0,0,
0,0,0,0,218,106,128,0,0,0,0,0,126,150,0,0,0,0,0,0,
8,152,0,0,0,0,0,0,16,150,0,0,0,0,0,0,250,149,0,0,
0,0,0,0,120,149,0,0,0,0,0,0,228,151,0,0,0,0,0,0,
194,151,0,0,0,0,0,0,158,151,0,0,0,0,0,0,54,149,0,0,
0,0,0,0,222,108,128,0,0,0,0,0,108,151,0,0,0,0,0,0,
104,151,0,0,0,0,0,0,212,149,0,0,0,0,0,0,80,151,0,0,
0,0,0,0,172,145,0,0,0,0,0,0,206,106,128,0,0,0,0,0,
190,106,128,0,0,0,0,0,78,151,0,0,0,0,0,0,74,151,0,0,
0,0,0,0,70,151,0,0,0,0,0,0,220,107,128,0,0,0,0,0,
250,148,0,0,0,0,0,0,40,145,0,0,0,0,0,0,24,151,0,0,
0,0,0,0,220,148,0,0,0,0,0,0,66,151,0,0,0,0,0,0,
78,148,0,0,0,0,0,0,10,107,128,0,0,0,0,0,202,147,0,0,
0,0,0,0,38,151,0,0,0,0,0,0,10,144,0,0,0,0,0,0,
32,151,0,0,0,0,0,0,0,124,0,0,0,0,0,0,216,108,128,0,
0,0,0,0,148,151,0,0,0,0,0,0,138,151,0,0,0,0,0,0,
134,151,0,0,0,0,0,0,128,151,0,0,0,0,0,0,126,151,0,0,
0,0,0,0,230,144,0,0,0,0,0,0,60,151,0,0,0,0,0,0,
54,151,0,0,0,0,0,0,122,151,0,0,0,0,0,0,116,151,0,0,
0,0,0,0,112,151,0,0,0,0,0,0,50,151,0,0,0,0,0,0,
44,151,0,0,0,0,0,0,186,146,0,0,0,0,0,0,194,146,0,0,
0,0,0,0,178,146,0,0,0,0,0,0,184,108,128,0,0,0,0,0,
26,151,0,0,0,0,0,0,72,108,128,0,0,0,0,0,230,150,0,0,
0,0,0,0,238,150,0,0,0,0,0,0,232,150,0,0,0,0,0,0,
18,145,0,0,0,0,0,0,244,150,0,0,0,0,0,0,228,150,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,142,150,0,0,0,0,0,0,
166,140,0,0,0,0,0,0,126,150,0,0,0,0,0,0,8,152,0,0,
0,0,0,0,16,150,0,0,0,0,0,0,250,149,0,0,0,0,0,0,
120,149,0,0,0,0,0,0,228,151,0,0,0,0,0,0,194,151,0,0,
0,0,0,0,158,151,0,0,0,0,0,0,54,149,0,0,0,0,0,0,
34,109,128,0,0,0,0,0,108,151,0,0,0,0,0,0,104,151,0,0,
0,0,0,0,212,149,0,0,0,0,0,0,80,151,0,0,0,0,0,0,
172,145,0,0,0,0,0,0,96,151,0,0,0,0,0,0,82,151,0,0,
0,0,0,0,78,151,0,0,0,0,0,0,74,151,0,0,0,0,0,0,
70,151,0,0,0,0,0,0,220,107,128,0,0,0,0,0,250,148,0,0,
0,0,0,0,40,145,0,0,0,0,0,0,24,151,0,0,0,0,0,0,
220,148,0,0,0,0,0,0,66,151,0,0,0,0,0,0,78,148,0,0,
0,0,0,0,124,107,128,0,0,0,0,0,202,147,0,0,0,0,0,0,
38,151,0,0,0,0,0,0,10,144,0,0,0,0,0,0,32,151,0,0,
0,0,0,0,0,124,0,0,0,0,0,0,30,151,0,0,0,0,0,0,
148,151,0,0,0,0,0,0,138,151,0,0,0,0,0,0,134,151,0,0,
0,0,0,0,128,151,0,0,0,0,0,0,126,151,0,0,0,0,0,0,
230,144,0,0,0,0,0,0,60,151,0,0,0,0,0,0,54,151,0,0,
0,0,0,0,122,151,0,0,0,0,0,0,116,151,0,0,0,0,0,0,
112,151,0,0,0,0,0,0,50,151,0,0,0,0,0,0,44,151,0,0,
0,0,0,0,186,146,0,0,0,0,0,0,194,146,0,0,0,0,0,0,
178,146,0,0,0,0,0,0,226,108,128,0,0,0,0,0,26,151,0,0,
0,0,0,0,72,108,128,0,0,0,0,0,230,150,0,0,0,0,0,0,
238,150,0,0,0,0,0,0,232,150,0,0,0,0,0,0,18,145,0,0,
0,0,0,0,244,150,0,0,0,0,0,0,228,150,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,40,166,0,0,0,0,0,0,34,166,0,0,
0,0,0,0,60,164,0,0,0,0,0,0,8,167,0,0,0,0,0,0,
108,166,0,0,0,0,0,0,104,166,0,0,0,0,0,0,110,137,0,0,
0,0,0,0,12,165,0,0,0,0,0,0,230,166,0,0,0,0,0,0,
194,166,0,0,0,0,0,0,158,166,0,0,0,0,0,0,154,166,0,0,
0,0,0,0,26,137,0,0,0,0,0,0,198,136,0,0,0,0,0,0,
110,136,0,0,0,0,0,0,24,136,0,0,0,0,0,0,214,159,0,0,
0,0,0,0,76,162,0,0,0,0,0,0,56,162,0,0,0,0,0,0,
52,134,0,0,0,0,0,0,218,133,0,0,0,0,0,0,128,133,0,0,
0,0,0,0,50,110,0,0,0,0,0,0,204,132,0,0,0,0,0,0,
38,159,0,0,0,0,0,0,158,131,0,0,0,0,0,0,234,130,0,0,
0,0,0,0,150,130,0,0,0,0,0,0,254,163,0,0,0,0,0,0,
22,164,0,0,0,0,0,0,66,127,0,0,0,0,0,0,100,162,0,0,
0,0,0,0,64,166,0,0,0,0,0,0,56,125,0,0,0,0,0,0,
0,124,0,0,0,0,0,0,110,123,0,0,0,0,0,0,148,166,0,0,
0,0,0,0,138,166,0,0,0,0,0,0,134,166,0,0,0,0,0,0,
128,166,0,0,0,0,0,0,126,166,0,0,0,0,0,0,16,158,0,0,
0,0,0,0,194,122,0,0,0,0,0,0,26,122,0,0,0,0,0,0,
122,166,0,0,0,0,0,0,116,166,0,0,0,0,0,0,112,166,0,0,
0,0,0,0,34,121,0,0,0,0,0,0,48,120,0,0,0,0,0,0,
208,119,0,0,0,0,0,0,234,162,0,0,0,0,0,0,238,118,0,0,
0,0,0,0,208,161,0,0,0,0,0,0,100,166,0,0,0,0,0,0,
66,161,0,0,0,0,0,0,244,114,0,0,0,0,0,0,14,159,0,0,
0,0,0,0,222,158,0,0,0,0,0,0,96,113,0,0,0,0,0,0,
104,112,0,0,0,0,0,0,46,166,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,254,191,0,0,0,0,0,0,156,189,0,0,0,0,0,0,
28,189,0,0,0,0,0,0,34,193,0,0,0,0,0,0,118,187,0,0,
0,0,0,0,250,185,0,0,0,0,0,0,110,137,0,0,0,0,0,0,
254,192,0,0,0,0,0,0,220,192,0,0,0,0,0,0,184,192,0,0,
0,0,0,0,148,192,0,0,0,0,0,0,144,192,0,0,0,0,0,0,
72,192,0,0,0,0,0,0,198,136,0,0,0,0,0,0,54,185,0,0,
0,0,0,0,24,136,0,0,0,0,0,0,202,170,0,0,0,0,0,0,
254,184,0,0,0,0,0,0,234,184,0,0,0,0,0,0,52,134,0,0,
0,0,0,0,218,133,0,0,0,0,0,0,128,133,0,0,0,0,0,0,
50,110,0,0,0,0,0,0,204,132,0,0,0,0,0,0,48,169,0,0,
0,0,0,0,158,131,0,0,0,0,0,0,234,130,0,0,0,0,0,0,
150,130,0,0,0,0,0,0,144,129,0,0,0,0,0,0,158,127,0,0,
0,0,0,0,66,127,0,0,0,0,0,0,30,126,0,0,0,0,0,0,
86,192,0,0,0,0,0,0,56,125,0,0,0,0,0,0,0,124,0,0,
0,0,0,0,14,175,0,0,0,0,0,0,138,192,0,0,0,0,0,0,
128,192,0,0,0,0,0,0,124,192,0,0,0,0,0,0,148,175,0,0,
0,0,0,0,122,192,0,0,0,0,0,0,250,112,0,0,0,0,0,0,
174,183,0,0,0,0,0,0,122,182,0,0,0,0,0,0,150,181,0,0,
0,0,0,0,196,180,0,0,0,0,0,0,162,179,0,0,0,0,0,0,
178,178,0,0,0,0,0,0,174,177,0,0,0,0,0,0,208,119,0,0,
0,0,0,0,66,176,0,0,0,0,0,0,26,176,0,0,0,0,0,0,
152,174,0,0,0,0,0,0,60,192,0,0,0,0,0,0,244,171,0,0,
0,0,0,0,244,114,0,0,0,0,0,0,154,114,0,0,0,0,0,0,
64,114,0,0,0,0,0,0,164,168,0,0,0,0,0,0,104,112,0,0,
0,0,0,0,222,111,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,18,0,0,0,7,0,0,0,
6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,0,0,0,
15,0,0,0,14,0,0,0,0,0,0,0,15,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,138,9,1,0,
0,0,0,0,76,9,1,0,0,0,0,0,92,6,1,0,0,0,0,0,
152,10,1,0,0,0,0,0,230,9,1,0,0,0,0,0,226,9,1,0,
0,0,0,0,110,137,0,0,0,0,0,0,28,7,1,0,0,0,0,0,
118,10,1,0,0,0,0,0,82,10,1,0,0,0,0,0,46,10,1,0,
0,0,0,0,42,10,1,0,0,0,0,0,222,9,1,0,0,0,0,0,
218,9,1,0,0,0,0,0,152,5,1,0,0,0,0,0,56,250,0,0,
0,0,0,0,66,244,0,0,0,0,0,0,96,5,1,0,0,0,0,0,
76,5,1,0,0,0,0,0,20,5,1,0,0,0,0,0,244,4,1,0,
0,0,0,0,212,4,1,0,0,0,0,0,50,110,0,0,0,0,0,0,
204,132,0,0,0,0,0,0,178,242,0,0,0,0,0,0,32,242,0,0,
0,0,0,0,234,130,0,0,0,0,0,0,150,130,0,0,0,0,0,0,
144,129,0,0,0,0,0,0,174,4,1,0,0,0,0,0,66,127,0,0,
0,0,0,0,30,126,0,0,0,0,0,0,234,9,1,0,0,0,0,0,
56,125,0,0,0,0,0,0,0,124,0,0,0,0,0,0,170,249,0,0,
0,0,0,0,36,10,1,0,0,0,0,0,26,10,1,0,0,0,0,0,
22,10,1,0,0,0,0,0,16,10,1,0,0,0,0,0,14,10,1,0,
0,0,0,0,40,241,0,0,0,0,0,0,60,2,1,0,0,0,0,0,
12,1,1,0,0,0,0,0,204,255,0,0,0,0,0,0,238,254,0,0,
0,0,0,0,230,253,0,0,0,0,0,0,240,252,0,0,0,0,0,0,
238,251,0,0,0,0,0,0,208,119,0,0,0,0,0,0,106,250,0,0,
0,0,0,0,66,250,0,0,0,0,0,0,52,249,0,0,0,0,0,0,
212,9,1,0,0,0,0,0,182,245,0,0,0,0,0,0,244,114,0,0,
0,0,0,0,206,9,1,0,0,0,0,0,200,9,1,0,0,0,0,0,
44,242,0,0,0,0,0,0,104,112,0,0,0,0,0,0,222,111,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,44,18,1,0,0,0,0,0,
70,17,1,0,0,0,0,0,126,150,0,0,0,0,0,0,26,19,1,0,
0,0,0,0,28,15,1,0,0,0,0,0,62,13,1,0,0,0,0,0,
120,149,0,0,0,0,0,0,246,18,1,0,0,0,0,0,38,18,1,0,
0,0,0,0,210,18,1,0,0,0,0,0,54,149,0,0,0,0,0,0,
124,109,128,0,0,0,0,0,164,18,1,0,0,0,0,0,160,18,1,0,
0,0,0,0,212,149,0,0,0,0,0,0,158,18,1,0,0,0,0,0,
192,11,1,0,0,0,0,0,206,106,128,0,0,0,0,0,190,106,128,0,
0,0,0,0,156,18,1,0,0,0,0,0,152,18,1,0,0,0,0,0,
148,18,1,0,0,0,0,0,228,12,1,0,0,0,0,0,250,148,0,0,
0,0,0,0,252,10,1,0,0,0,0,0,104,18,1,0,0,0,0,0,
220,148,0,0,0,0,0,0,144,18,1,0,0,0,0,0,78,148,0,0,
0,0,0,0,20,13,1,0,0,0,0,0,202,147,0,0,0,0,0,0,
116,18,1,0,0,0,0,0,10,144,0,0,0,0,0,0,110,18,1,0,
0,0,0,0,0,124,0,0,0,0,0,0,118,109,128,0,0,0,0,0,
204,18,1,0,0,0,0,0,194,18,1,0,0,0,0,0,190,18,1,0,
0,0,0,0,184,18,1,0,0,0,0,0,182,18,1,0,0,0,0,0,
198,10,1,0,0,0,0,0,138,18,1,0,0,0,0,0,132,18,1,0,
0,0,0,0,178,18,1,0,0,0,0,0,172,18,1,0,0,0,0,0,
168,18,1,0,0,0,0,0,128,18,1,0,0,0,0,0,122,18,1,0,
0,0,0,0,186,146,0,0,0,0,0,0,194,146,0,0,0,0,0,0,
178,146,0,0,0,0,0,0,86,109,128,0,0,0,0,0,106,18,1,0,
0,0,0,0,82,11,1,0,0,0,0,0,54,18,1,0,0,0,0,0,
62,18,1,0,0,0,0,0,56,18,1,0,0,0,0,0,18,145,0,0,
0,0,0,0,68,18,1,0,0,0,0,0,52,18,1,0,0,0,0,0,
0,0,0,0,0,0,0,0,138,20,1,0,0,0,0,0,156,189,0,0,
0,0,0,0,28,189,0,0,0,0,0,0,48,23,1,0,0,0,0,0,
118,187,0,0,0,0,0,0,250,185,0,0,0,0,0,0,110,137,0,0,
0,0,0,0,12,23,1,0,0,0,0,0,234,22,1,0,0,0,0,0,
198,22,1,0,0,0,0,0,162,22,1,0,0,0,0,0,158,22,1,0,
0,0,0,0,86,22,1,0,0,0,0,0,198,136,0,0,0,0,0,0,
54,185,0,0,0,0,0,0,24,136,0,0,0,0,0,0,154,19,1,0,
0,0,0,0,254,184,0,0,0,0,0,0,234,184,0,0,0,0,0,0,
52,134,0,0,0,0,0,0,218,133,0,0,0,0,0,0,128,133,0,0,
0,0,0,0,50,110,0,0,0,0,0,0,204,132,0,0,0,0,0,0,
48,169,0,0,0,0,0,0,158,131,0,0,0,0,0,0,234,130,0,0,
0,0,0,0,150,130,0,0,0,0,0,0,144,129,0,0,0,0,0,0,
158,127,0,0,0,0,0,0,66,127,0,0,0,0,0,0,30,126,0,0,
0,0,0,0,100,22,1,0,0,0,0,0,56,125,0,0,0,0,0,0,
0,124,0,0,0,0,0,0,14,175,0,0,0,0,0,0,152,22,1,0,
0,0,0,0,142,22,1,0,0,0,0,0,138,22,1,0,0,0,0,0,
148,175,0,0,0,0,0,0,136,22,1,0,0,0,0,0,250,112,0,0,
0,0,0,0,174,183,0,0,0,0,0,0,122,182,0,0,0,0,0,0,
150,181,0,0,0,0,0,0,196,180,0,0,0,0,0,0,162,179,0,0,
0,0,0,0,178,178,0,0,0,0,0,0,174,177,0,0,0,0,0,0,
208,119,0,0,0,0,0,0,66,176,0,0,0,0,0,0,26,176,0,0,
0,0,0,0,128,109,128,0,0,0,0,0,74,22,1,0,0,0,0,0,
118,19,1,0,0,0,0,0,244,114,0,0,0,0,0,0,154,114,0,0,
0,0,0,0,64,114,0,0,0,0,0,0,32,19,1,0,0,0,0,0,
104,112,0,0,0,0,0,0,222,111,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,74,128,128,0,0,0,0,0,68,128,128,0,0,0,0,0,
52,129,128,0,0,0,0,0,14,129,128,0,0,0,0,0,10,129,128,0,
0,0,0,0,6,129,128,0,0,0,0,0,110,137,0,0,0,0,0,0,
220,23,1,0,0,0,0,0,186,23,1,0,0,0,0,0,150,23,1,0,
0,0,0,0,114,23,1,0,0,0,0,0,110,23,1,0,0,0,0,0,
250,127,128,0,0,0,0,0,176,127,128,0,0,0,0,0,110,136,0,0,
0,0,0,0,24,136,0,0,0,0,0,0,202,113,128,0,0,0,0,0,
224,128,128,0,0,0,0,0,138,134,0,0,0,0,0,0,52,134,0,0,
0,0,0,0,218,133,0,0,0,0,0,0,128,133,0,0,0,0,0,0,
50,110,0,0,0,0,0,0,186,128,128,0,0,0,0,0,36,113,128,0,
0,0,0,0,158,131,0,0,0,0,0,0,234,130,0,0,0,0,0,0,
124,127,128,0,0,0,0,0,72,127,128,0,0,0,0,0,168,120,128,0,
0,0,0,0,66,127,0,0,0,0,0,0,30,126,0,0,0,0,0,0,
54,23,1,0,0,0,0,0,56,125,0,0,0,0,0,0,0,124,0,0,
0,0,0,0,110,123,0,0,0,0,0,0,12,118,128,0,0,0,0,0,
100,23,1,0,0,0,0,0,10,119,128,0,0,0,0,0,94,23,1,0,
0,0,0,0,164,128,128,0,0,0,0,0,80,128,128,0,0,0,0,0,
126,126,128,0,0,0,0,0,184,125,128,0,0,0,0,0,142,124,128,0,
0,0,0,0,228,123,128,0,0,0,0,0,90,23,1,0,0,0,0,0,
74,122,128,0,0,0,0,0,214,120,128,0,0,0,0,0,208,119,0,0,
0,0,0,0,208,119,128,0,0,0,0,0,106,119,128,0,0,0,0,0,
150,117,128,0,0,0,0,0,160,128,128,0,0,0,0,0,160,116,128,0,
0,0,0,0,244,114,0,0,0,0,0,0,122,128,128,0,0,0,0,0,
84,128,128,0,0,0,0,0,96,113,0,0,0,0,0,0,104,112,0,0,
0,0,0,0,222,111,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
28,132,128,0,0,0,0,0,24,132,128,0,0,0,0,0,28,131,128,0,
0,0,0,0,178,24,1,0,0,0,0,0,20,132,128,0,0,0,0,0,
16,132,128,0,0,0,0,0,110,137,0,0,0,0,0,0,142,24,1,0,
0,0,0,0,108,24,1,0,0,0,0,0,72,24,1,0,0,0,0,0,
36,24,1,0,0,0,0,0,12,132,128,0,0,0,0,0,8,132,128,0,
0,0,0,0,4,132,128,0,0,0,0,0,110,136,0,0,0,0,0,0,
24,136,0,0,0,0,0,0,178,131,128,0,0,0,0,0,0,132,128,0,
0,0,0,0,248,131,128,0,0,0,0,0,52,134,0,0,0,0,0,0,
218,133,0,0,0,0,0,0,128,133,0,0,0,0,0,0,204,130,128,0,
0,0,0,0,244,131,128,0,0,0,0,0,166,131,128,0,0,0,0,0,
242,131,128,0,0,0,0,0,238,131,128,0,0,0,0,0,156,130,128,0,
0,0,0,0,106,130,128,0,0,0,0,0,56,130,128,0,0,0,0,0,
232,131,128,0,0,0,0,0,226,131,128,0,0,0,0,0,152,131,128,0,
0,0,0,0,220,131,128,0,0,0,0,0,218,131,128,0,0,0,0,0,
110,123,0,0,0,0,0,0,6,130,128,0,0,0,0,0,26,24,1,0,
0,0,0,0,22,24,1,0,0,0,0,0,16,24,1,0,0,0,0,0,
14,24,1,0,0,0,0,0,158,131,128,0,0,0,0,0,212,131,128,0,
0,0,0,0,206,131,128,0,0,0,0,0,10,24,1,0,0,0,0,0,
4,24,1,0,0,0,0,0,0,24,1,0,0,0,0,0,202,131,128,0,
0,0,0,0,196,131,128,0,0,0,0,0,208,119,0,0,0,0,0,0,
194,131,128,0,0,0,0,0,190,131,128,0,0,0,0,0,190,129,128,0,
0,0,0,0,186,131,128,0,0,0,0,0,182,131,128,0,0,0,0,0,
244,114,0,0,0,0,0,0,174,131,128,0,0,0,0,0,170,131,128,0,
0,0,0,0,162,131,128,0,0,0,0,0,148,131,128,0,0,0,0,0,
222,111,0,0,0,0,0,0,0,0,0,0,40,132,128,0,0,0,0,0,
120,183,141,0,82,176,128,0,0,0,0,0,8,0,0,0,0,0,1,0,
0,0,1,0,3,0,0,0,4,0,1,0,0,0,5,0,3,0,0,0,
252,223,4,32,0,0,16,0,236,3,0,0,252,223,0,36,0,0,0,0,
8,0,0,0,0,0,1,0,0,0,1,0,3,0,0,0,4,0,1,0,
0,0,5,0,3,0,0,0,252,255,4,0,0,0,16,0,236,3,0,0,
252,255,0,4,196,70,133,0,220,70,133,0,244,70,133,0,12,71,133,0,
36,71,133,0,60,71,133,0,84,71,133,0,108,71,133,0,132,71,133,0,
156,71,133,0,180,71,133,0,204,71,133,0,228,71,133,0,252,71,133,0,
0,0,0,0,0,0,0,0,0,0,0,0,74,188,128,0,0,0,0,0,
122,241,128,0,0,0,0,0,0,0,0,0,0,0,0,0,176,241,128,0,
0,0,0,0,16,198,128,0,0,0,0,0,0,0,0,0,0,0,0,0,
144,241,128,0,0,0,0,0,236,197,128,0,0,0,0,0,0,0,0,0,
0,0,0,0,248,240,128,0,0,0,0,0,92,240,128,0,0,0,0,0,
0,0,0,0,0,0,0,0,64,239,128,0,0,0,0,0,176,238,128,0,
0,0,0,0,0,0,0,0,0,0,0,0,168,237,128,0,0,0,0,0,
24,237,128,0,0,0,0,0,0,0,0,0,0,0,0,0,26,236,128,0,
0,0,0,0,138,235,128,0,0,0,0,0,0,0,0,0,0,0,0,0,
198,234,128,0,0,0,0,0,70,234,128,0,0,0,0,0,0,0,0,0,
0,0,0,0,198,233,128,0,0,0,0,0,46,233,128,0,0,0,0,0,
0,0,0,0,0,0,0,0,136,231,128,0,0,0,0,0,0,231,128,0,
0,0,0,0,0,0,0,0,0,0,0,0,182,229,128,0,0,0,0,0,
22,229,128,0,0,0,0,0,0,0,0,0,0,0,0,0,6,227,128,0,
0,0,0,0,118,226,128,0,0,0,0,0,0,0,0,0,0,0,0,0,
20,225,128,0,0,0,0,0,126,224,128,0,0,0,0,0,0,0,0,0,
0,0,0,0,178,218,128,0,0,0,0,0,50,218,128,0,0,0,0,0,
0,0,0,0,0,0,0,0,178,217,128,0,0,0,0,0,34,217,128,0,
0,0,0,0,0,0,0,0,0,0,0,0,132,215,128,0,0,0,0,0,
244,214,128,0,0,0,0,0,0,0,0,0,0,0,0,0,76,213,128,0,
0,0,0,0,200,212,128,0,0,0,0,0,0,0,0,0,0,0,0,0,
136,197,128,0,0,0,0,0,8,197,128,0,0,0,0,0,0,0,0,0,
0,0,0,0,126,196,128,0,0,0,0,0,250,195,128,0,0,0,0,0,
0,0,0,0,0,0,0,0,120,195,128,0,0,0,0,0,248,194,128,0,
0,0,0,0,0,0,0,0,0,0,0,0,124,194,128,0,0,0,0,0,
252,193,128,0,0,0,0,0,0,0,0,0,0,0,0,0,10,193,128,0,
0,0,0,0,130,192,128,0,0,0,0,0,0,0,0,0,0,0,0,0,
118,189,128,0,0,0,0,0,194,187,128,0,0,0,0,0,0,0,0,0,
0,0,0,0,164,211,128,0,0,0,0,0,20,211,128,0,0,0,0,0,
0,0,0,0,0,0,0,0,224,209,128,0,0,0,0,0,92,209,128,0,
0,0,0,0,0,0,0,0,0,0,0,0,30,206,128,0,0,0,0,0,
150,205,128,0,0,0,0,0,0,0,0,0,0,0,0,0,122,204,128,0,
0,0,0,0,242,203,128,0,0,0,0,0,0,0,0,0,0,0,0,0,
240,202,128,0,0,0,0,0,104,202,128,0,0,0,0,0,0,0,0,0,
0,0,0,0,56,201,128,0,0,0,0,0,176,200,128,0,0,0,0,0,
0,0,0,0,0,0,0,0,150,199,128,0,0,0,0,0,6,199,128,0,
200,101,133,0,200,101,133,0,192,233,133,0,192,233,133,0,200,233,133,0,
144,102,133,0,156,102,133,0,0,0,0,2,0,4,2,4,2,5,4,6,
4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,120,165,130,0,
0,0,0,0,120,165,130,0,126,76,11,125,14,0,20,0,9,0,3,125,
0,125,127,127,126,77,11,125,14,4,20,4,9,4,3,17,17,4,2,0,
4,0,1,0,0,125,127,127,126,64,11,125,12,125,3,125,3,125,5,4,
3,125,3,125,5,4,3,125,3,125,4,0,1,0,0,125,127,127,0,0,
126,65,8,4,3,125,8,4,3,125,8,4,4,0,1,0,0,125,127,127,
126,66,19,125,11,125,10,0,2,125,0,125,127,127,0,0,126,67,19,125,
11,125,10,4,2,0,10,4,2,0,4,0,1,0,0,125,127,127,0,0,
126,68,11,125,3,125,3,125,3,125,3,125,3,125,3,125,4,0,1,0,
0,125,127,127,126,69,11,125,7,0,19,125,12,125,8,0,9,0,3,125,
0,125,127,127,126,70,11,125,7,4,19,125,21,4,12,125,8,4,9,4,
3,17,17,4,2,0,4,0,1,0,0,125,127,127,0,0,126,71,8,4,
3,125,8,4,3,125,4,0,1,0,0,125,127,127,0,0,132,237,133,0,
140,237,133,0,148,237,133,0,156,237,133,0,144,53,134,0,160,53,134,0,
184,53,134,0,216,53,134,0,236,53,134,0,252,53,134,0,20,54,134,0,
44,54,134,0,64,54,134,0,96,54,134,0,126,64,11,125,12,125,3,125,
5,4,3,125,2,0,4,0,1,0,0,125,127,127,0,0,126,65,8,4,
2,0,4,0,1,0,0,125,127,127,0,0,126,66,19,125,11,125,10,0,
2,125,0,125,127,127,0,0,126,67,19,125,11,125,10,4,2,0,4,0,
1,0,0,125,127,127,0,0,126,68,11,125,3,125,3,125,3,125,3,125,
3,125,3,125,4,0,1,0,0,125,127,127,126,69,11,125,7,0,19,125,
8,0,9,0,3,125,0,125,127,127,0,0,126,70,11,125,7,4,19,125,
21,4,8,4,9,4,3,17,17,4,2,0,4,0,1,0,0,125,127,127,
126,71,8,4,2,0,4,0,1,0,0,125,127,127,0,0,132,237,133,0,
140,237,133,0,148,237,133,0,156,237,133,0,144,53,134,0,160,53,134,0,
172,54,134,0,196,54,134,0,212,54,134,0,228,54,134,0,248,54,134,0,
16,55,134,0,36,55,134,0,64,55,134,0,255,255,255,255,0,2,64,0,
255,255,255,255,220,111,133,0,255,255,255,255,1,2,65,0,255,255,255,255,
12,112,133,0,255,255,255,255,2,2,66,0,1,0,0,0,212,112,133,0,
255,255,255,255,2,2,66,0,6,0,0,0,56,112,133,0,255,255,255,255,
2,2,67,0,24,0,0,0,236,112,133,0,255,255,255,255,3,2,68,0,
255,255,255,255,4,113,133,0,255,255,255,255,4,2,69,0,1,0,0,0,
24,113,133,0,255,255,255,255,4,2,70,0,30,0,0,0,44,113,133,0,
255,255,255,255,8,2,71,0,255,255,255,255,236,111,133,0,255,255,255,255,
10,2,76,0,1,0,0,0,80,112,133,0,255,255,255,255,10,2,77,0,
30,0,0,0,104,112,133,0,255,255,255,255,9,2,71,0,255,255,255,255,
64,113,133,0,255,255,255,255,16,2,65,0,255,255,255,255,84,113,133,0,
255,255,255,255,17,2,71,0,255,255,255,255,252,111,133,0,255,255,255,255,
18,2,71,0,255,255,255,255,104,113,133,0,255,255,255,255,19,2,71,0,
255,255,255,255,128,112,133,0,255,255,255,255,20,2,71,0,255,255,255,255,
32,112,133,0,255,255,255,255,22,2,75,0,255,255,255,255,124,113,133,0,
255,255,255,255,23,2,75,0,255,255,255,255,144,113,133,0,255,255,255,255,
19,16,72,0,255,255,255,255,144,112,133,0,255,255,255,255,17,16,73,0,
255,255,255,255,36,234,133,0,0,1,5,38,0,1,112,0,40,140,133,0,
1,1,5,32,0,1,112,0,72,140,133,0,2,1,5,38,0,1,112,0,
136,124,133,0,3,1,5,38,0,1,112,0,168,124,133,0,4,1,5,38,
0,1,112,0,96,140,133,0,5,1,5,36,0,1,112,0,64,132,133,0,
6,1,5,36,0,1,112,0,128,140,133,0,7,1,5,36,0,1,112,0,
148,140,133,0,8,1,5,36,0,1,112,0,96,132,133,0,9,1,5,33,
0,1,112,0,172,140,133,0,10,1,5,37,0,1,112,0,192,140,133,0,
11,1,5,38,0,1,112,0,220,140,133,0,12,1,5,38,0,1,112,0,
252,140,133,0,13,1,5,36,0,1,112,0,28,141,133,0,14,1,5,36,
0,1,112,0,52,141,133,0,15,1,5,38,0,1,112,0,92,141,133,0,
16,1,11,85,1,1,112,0,124,141,133,0,17,1,11,85,3,1,112,0,
152,141,133,0,18,1,11,85,3,1,112,0,180,141,133,0,19,1,11,85,
1,1,112,0,112,132,133,0,20,1,11,85,1,1,112,0,144,132,133,0,
21,1,11,85,1,1,112,0,48,128,133,0,32,1,11,105,1,1,112,0,
204,141,133,0,33,1,11,103,5,1,112,0,220,141,133,0,34,1,11,109,
0,1,112,0,160,132,133,0,35,1,11,108,0,1,112,0,240,141,133,0,
36,1,11,108,0,1,112,0,8,142,133,0,37,1,5,255,255,1,112,0,
36,142,133,0,38,1,11,255,255,1,112,0,64,142,133,0,39,1,11,109,
0,1,112,0,160,132,133,0,40,1,5,4,0,1,112,0,80,142,133,0,
41,1,11,255,0,1,112,0,60,128,133,0,42,1,11,255,0,1,112,0,
180,132,133,0,43,1,11,255,0,1,112,0,96,142,133,0,44,1,11,255,
0,1,112,0,204,132,133,0,48,1,11,255,255,1,112,0,228,132,133,0,
49,1,11,255,255,1,112,0,120,142,133,0,50,1,11,255,255,1,112,0,
252,132,133,0,51,1,11,255,255,1,112,0,148,142,133,0,64,1,11,255,
255,1,112,0,176,142,133,0,80,1,5,33,1,1,112,0,192,142,133,0,
81,1,5,33,1,1,112,0,224,142,133,0,82,1,5,33,1,1,112,0,
0,143,133,0,83,1,5,33,1,1,112,0,32,143,133,0,96,1,5,38,
0,1,112,0,64,143,133,0,97,1,5,38,0,1,112,0,92,143,133,0,
98,1,5,38,0,1,112,0,120,143,133,0,112,1,11,255,255,1,112,0,
148,143,133,0,113,1,11,255,255,1,112,0,24,133,133,0,128,1,11,255,
255,1,112,0,188,143,133,0,129,1,11,255,255,1,112,0,88,128,133,0,
130,1,11,255,255,1,112,0,236,143,133,0,131,1,11,255,255,2,112,0,
12,144,133,0,132,1,11,255,255,1,112,0,200,124,133,0,133,1,11,255,
255,1,112,0,56,133,133,0,160,1,11,255,255,1,112,0,52,144,133,0,
192,1,4,0,0,1,112,0,76,144,133,0,193,1,4,0,0,1,112,0,
124,128,133,0,194,1,4,0,0,1,112,0,112,133,133,0,195,1,4,0,
0,1,112,0,144,128,133,0,196,1,4,0,0,1,112,0,104,144,133,0,
197,1,4,0,0,1,112,0,132,144,133,0,198,1,4,0,0,1,112,0,
156,144,133,0,199,1,4,0,0,1,112,0,180,144,133,0,200,1,4,0,
0,1,112,0,140,133,133,0,201,1,4,0,0,1,112,0,208,144,133,0,
202,1,4,0,0,1,112,0,240,144,133,0,203,1,4,0,0,1,112,0,
20,145,133,0,204,1,4,0,0,1,112,0,64,145,133,0,205,1,4,0,
0,1,112,0,96,145,133,0,206,1,4,0,0,1,112,0,124,145,133,0,
208,1,5,38,0,1,112,0,248,124,133,0,209,1,5,26,0,1,112,0,
172,128,133,0,210,1,5,38,0,1,112,0,152,145,133,0,211,1,5,38,
0,1,112,0,180,145,133,0,0,2,4,8,3,1,112,0,24,125,133,0,
1,2,4,71,1,1,112,0,204,145,133,0,2,2,3,17,0,1,112,0,
40,125,133,0,3,2,4,74,0,1,112,0,228,145,133,0,4,2,4,8,
1,1,112,0,168,133,133,0,5,2,4,41,0,1,112,0,0,146,133,0,
6,2,4,71,1,1,112,0,184,133,133,0,7,2,4,70,0,1,112,0,
56,125,133,0,8,2,4,8,0,1,112,0,80,125,133,0,9,2,4,8,
0,1,112,0,24,146,133,0,10,2,4,32,0,1,112,0,204,133,133,0,
16,2,4,71,1,1,112,0,204,145,133,0,17,2,4,75,0,1,112,0,
200,128,133,0,18,2,4,75,0,1,112,0,52,146,133,0,19,2,4,255,
255,1,112,0,76,146,133,0,20,2,4,255,255,1,112,0,220,128,133,0,
21,2,4,255,255,1,112,0,96,125,133,0,22,2,4,255,255,2,112,0,
96,146,133,0,23,2,4,255,255,1,112,0,124,146,133,0,48,2,5,32,
0,1,112,0,228,133,133,0,49,2,0,0,0,3,112,0,156,146,133,0,
50,2,5,38,0,1,112,0,16,134,133,0,51,2,5,38,0,1,112,0,
184,146,133,0,52,2,5,38,0,1,112,0,220,146,133,0,53,2,5,38,
0,1,112,0,60,134,133,0,64,2,4,0,0,3,112,0,112,125,133,0,
65,2,4,0,0,3,112,0,136,125,133,0,66,2,1,64,0,3,112,0,
100,134,133,0,67,2,4,64,0,3,112,0,248,128,133,0,68,2,4,0,
0,3,112,0,160,125,133,0,69,2,4,0,0,3,112,0,4,147,133,0,
70,2,4,0,0,3,112,0,44,147,133,0,71,2,4,0,0,3,112,0,
152,134,133,0,72,2,4,0,0,3,112,0,80,147,133,0,73,2,4,0,
0,3,112,0,100,147,133,0,80,2,5,38,0,1,112,0,128,147,133,0,
81,2,5,38,0,1,112,0,160,147,133,0,82,2,5,38,0,1,112,0,
204,147,133,0,83,2,5,38,0,1,112,0,12,129,133,0,84,2,5,38,
0,1,112,0,240,147,133,0,85,2,5,38,0,1,112,0,40,148,133,0,
86,2,5,38,0,1,112,0,92,148,133,0,87,2,5,38,0,1,112,0,
180,134,133,0,88,2,5,38,0,1,112,0,200,125,133,0,89,2,5,38,
0,1,112,0,220,134,133,0,90,2,5,38,0,1,112,0,136,148,133,0,
91,2,5,38,0,1,112,0,248,134,133,0,92,2,5,38,0,1,112,0,
32,135,133,0,93,2,5,38,0,1,112,0,180,148,133,0,96,2,4,93,
0,2,112,0,208,148,133,0,112,2,5,38,0,1,112,0,236,148,133,0,
113,2,5,38,0,1,112,0,76,135,133,0,114,2,5,38,0,1,112,0,
8,149,133,0,0,3,4,71,1,1,112,0,40,149,133,0,1,3,4,71,
1,1,112,0,92,149,133,0,2,3,11,255,0,1,112,0,128,149,133,0,
3,3,11,255,0,1,112,0,100,135,133,0,16,3,4,71,1,1,112,0,
192,149,133,0,17,3,4,71,1,1,112,0,56,129,133,0,18,3,4,71,
1,1,112,0,220,149,133,0,19,3,4,71,1,1,112,0,84,129,133,0,
20,3,4,71,1,1,112,0,252,149,133,0,21,3,4,71,1,1,112,0,
20,150,133,0,22,3,4,71,1,1,112,0,112,129,133,0,32,3,4,71,
1,1,112,0,160,135,133,0,33,3,4,71,1,1,112,0,132,129,133,0,
34,3,4,71,1,1,112,0,48,150,133,0,35,3,4,71,1,1,112,0,
188,135,133,0,128,3,4,71,1,1,112,0,236,135,133,0,129,3,4,71,
1,1,112,0,20,136,133,0,130,3,4,71,1,1,112,0,232,125,133,0,
131,3,4,71,1,1,112,0,56,136,133,0,132,3,4,71,1,1,112,0,
88,150,133,0,133,3,4,71,1,1,112,0,120,150,133,0,134,3,4,71,
1,1,112,0,160,129,133,0,135,3,4,71,1,1,112,0,72,136,133,0,
136,3,4,71,1,1,112,0,88,136,133,0,137,3,4,71,1,1,112,0,
188,129,133,0,138,3,4,71,1,1,112,0,224,129,133,0,139,3,4,71,
1,1,112,0,152,150,133,0,140,3,4,71,1,1,112,0,252,129,133,0,
141,3,4,71,1,1,112,0,104,136,133,0,144,3,5,38,0,1,112,0,
248,125,133,0,145,3,5,38,0,1,112,0,184,150,133,0,146,3,5,38,
0,1,112,0,204,150,133,0,0,16,0,0,0,3,127,0,112,234,133,0,
1,16,0,0,0,3,127,0,112,234,133,0,2,16,0,0,0,3,127,0,
112,234,133,0,3,16,0,0,0,3,127,0,16,130,133,0,4,16,0,0,
0,3,127,0,16,126,133,0,5,16,0,0,0,3,127,0,16,126,133,0,
6,16,0,0,0,3,127,0,112,234,133,0,7,16,0,0,0,3,127,0,
112,234,133,0,8,16,0,0,0,3,127,0,220,150,133,0,9,16,0,0,
0,3,127,0,244,150,133,0,16,16,0,0,0,3,127,0,12,151,133,0,
17,16,0,0,0,3,127,0,40,126,133,0,18,16,0,0,0,3,127,0,
64,126,133,0,19,16,0,0,0,3,127,0,36,130,133,0,20,16,0,0,
0,3,127,0,88,126,133,0,21,16,0,0,0,3,127,0,40,151,133,0,
22,16,0,0,0,3,127,0,104,126,133,0,32,16,0,0,0,3,127,0,
56,130,133,0,0,32,0,0,0,3,127,0,56,151,133,0,1,32,0,0,
0,3,127,0,76,130,133,0,19,48,0,0,0,1,127,0,136,126,133,0,
20,48,0,0,0,1,127,0,112,130,133,0,30,48,0,0,0,1,127,0,
92,151,133,0,33,48,0,0,0,1,127,0,148,130,133,0,36,48,0,0,
0,1,127,0,128,151,133,0,37,48,0,0,0,1,127,0,184,130,133,0,
38,48,0,0,0,1,127,0,124,136,133,0,39,48,0,0,0,1,127,0,
212,130,133,0,71,48,0,0,0,1,127,0,160,151,133,0,98,48,0,0,
0,1,127,0,156,136,133,0,99,48,0,0,0,1,127,0,188,151,133,0,
100,48,0,0,0,1,127,0,228,151,133,0,101,48,0,0,0,1,127,0,
188,136,133,0,102,48,0,0,0,1,127,0,216,136,133,0,103,48,0,0,
0,1,127,0,244,136,133,0,104,48,0,0,0,1,127,0,12,137,133,0,
105,48,0,0,0,1,127,0,248,151,133,0,106,48,0,0,0,1,127,0,
28,152,133,0,107,48,0,0,0,1,127,0,52,152,133,0,108,48,0,0,
0,1,127,0,24,137,133,0,0,0,0,0,0,4,113,0,176,126,133,0,
1,0,6,41,0,3,113,0,60,137,133,0,2,0,4,107,2,1,113,0,
88,137,133,0,3,0,4,0,0,1,113,0,104,137,133,0,4,0,4,107,
2,1,113,0,84,152,133,0,5,0,0,107,1,3,113,0,132,137,133,0,
6,0,0,107,2,2,113,0,100,152,133,0,7,0,0,0,0,3,113,0,
128,152,133,0,8,0,0,0,0,2,113,0,152,137,133,0,9,0,4,0,
0,1,113,0,152,152,133,0,10,0,4,0,0,1,113,0,176,152,133,0,
11,0,0,0,0,3,113,0,192,126,133,0,12,0,0,0,0,3,113,0,
200,152,133,0,13,0,0,0,0,3,113,0,220,152,133,0,14,0,4,107,
2,1,113,0,180,137,133,0,15,0,0,93,0,2,113,0,208,148,133,0,
16,0,0,0,0,1,113,0,236,152,133,0,17,0,0,0,0,1,113,0,
200,137,133,0,18,0,0,0,0,1,113,0,232,130,133,0,19,0,0,0,
0,1,113,0,20,153,133,0,20,0,0,0,0,1,113,0,240,137,133,0,
21,0,0,0,0,1,113,0,56,153,133,0,22,0,0,0,0,1,113,0,
20,138,133,0,23,0,0,0,0,1,113,0,88,153,133,0,24,0,0,0,
0,1,113,0,60,138,133,0,25,0,0,0,0,1,113,0,116,153,133,0,
26,0,0,0,0,1,113,0,88,138,133,0,27,0,0,0,0,1,113,0,
208,126,133,0,28,0,0,0,0,1,113,0,240,126,133,0,29,0,0,0,
0,1,113,0,16,127,133,0,32,0,0,0,0,1,113,0,148,153,133,0,
33,0,0,0,0,2,113,0,12,131,133,0,34,0,0,0,0,2,113,0,
120,138,133,0,35,0,1,17,0,2,113,0,40,127,133,0,36,0,4,64,
0,1,113,0,184,153,133,0,37,0,4,0,0,1,113,0,216,153,133,0,
38,0,3,17,0,1,113,0,252,153,133,0,39,0,4,0,0,1,113,0,
32,131,133,0,40,0,4,0,0,1,113,0,64,127,133,0,41,0,0,0,
0,3,113,0,24,154,133,0,42,0,4,107,2,1,113,0,140,138,133,0,
43,0,0,0,0,3,113,0,40,154,133,0,44,0,1,17,0,1,113,0,
60,154,133,0,45,0,4,107,2,1,113,0,60,131,133,0,46,0,0,0,
0,2,113,0,96,154,133,0,47,0,0,0,0,2,113,0,136,154,133,0,
48,0,4,0,0,1,113,0,88,131,133,0,49,0,0,0,0,4,113,0,
180,154,133,0,50,0,0,0,0,2,113,0,88,127,133,0,51,0,0,0,
0,3,113,0,156,138,133,0,52,0,4,107,2,1,113,0,216,154,133,0,
53,0,0,0,0,3,113,0,108,131,133,0,54,0,0,0,0,2,113,0,
176,138,133,0,55,0,4,64,0,1,113,0,236,154,133,0,56,0,4,64,
0,1,113,0,4,155,133,0,57,0,1,64,0,2,113,0,96,146,133,0,
58,0,4,41,0,1,113,0,212,138,133,0,59,0,0,0,0,3,113,0,
28,155,133,0,60,0,0,0,0,3,113,0,244,138,133,0,61,0,0,0,
0,3,113,0,8,139,133,0,62,0,0,0,0,3,113,0,44,155,133,0,
63,0,4,64,0,2,113,0,240,144,133,0,64,0,0,0,0,3,113,0,
64,155,133,0,65,0,4,64,0,2,113,0,92,155,133,0,66,0,4,64,
0,2,113,0,128,127,133,0,67,0,4,64,0,2,113,0,124,155,133,0,
68,0,0,0,0,3,113,0,24,139,133,0,69,0,4,0,0,2,113,0,
156,155,133,0,70,0,4,0,0,2,113,0,160,127,133,0,71,0,4,0,
0,1,113,0,180,155,133,0,72,0,4,0,0,1,113,0,128,131,133,0,
73,0,0,0,0,3,113,0,52,139,133,0,74,0,4,0,0,2,113,0,
208,155,133,0,75,0,4,0,0,2,113,0,156,131,133,0,76,0,4,0,
0,1,113,0,236,155,133,0,77,0,4,0,0,1,113,0,184,127,133,0,
78,0,0,0,0,3,113,0,84,139,133,0,79,0,0,0,0,2,113,0,
116,139,133,0,80,0,0,0,0,3,113,0,216,127,133,0,81,0,0,0,
0,3,113,0,12,156,133,0,82,0,0,0,0,3,113,0,44,156,133,0,
83,0,0,0,0,3,113,0,76,156,133,0,84,0,0,0,0,4,113,0,
184,131,133,0,85,0,0,0,0,3,113,0,112,156,133,0,86,0,0,0,
0,3,113,0,140,156,133,0,87,0,4,0,0,1,113,0,168,156,133,0,
88,0,0,0,0,3,113,0,248,127,133,0,89,0,4,0,0,1,113,0,
148,139,133,0,90,0,0,0,0,3,113,0,192,156,133,0,91,0,4,0,
0,1,113,0,212,156,133,0,92,0,4,0,0,2,113,0,32,128,133,0,
93,0,4,0,0,1,113,0,228,131,133,0,94,0,0,0,0,3,113,0,
0,132,133,0,95,0,4,0,0,1,113,0,236,156,133,0,96,0,0,0,
0,4,113,0,36,132,133,0,97,0,0,0,0,4,113,0,28,157,133,0,
98,0,0,0,0,4,113,0,188,139,133,0,99,0,0,0,0,4,113,0,
60,157,133,0,100,0,0,0,0,4,113,0,220,139,133,0,252,0,0,0,
0,4,113,0,92,157,133,0,253,0,0,0,0,4,113,0,136,157,133,0,
254,0,0,0,0,4,113,0,252,139,133,0,255,0,0,0,0,4,113,0,
20,140,133,0,0,0,0,0,0,0,0,0,0,0,0,0,120,165,130,0,
0,0,0,0,120,165,130,0,0,0,0,0,120,165,130,0,0,0,0,0,
120,165,130,0,0,0,0,0,120,165,130,0,0,0,0,0,120,165,130,0,
0,0,0,0,120,165,130,0,0,0,0,0,0,0,0,0,0,0,0,0,
146,58,129,0,0,0,0,0,244,57,129,0,0,0,0,0,210,57,129,0,
0,0,0,0,218,57,129,0,0,0,0,0,226,57,129,0,0,0,0,0,
120,165,130,0,0,0,0,0,234,57,129,0,0,0,0,0,0,0,0,0,
0,0,0,0,120,165,130,0,0,0,0,0,120,165,130,0,0,0,0,0,
120,165,130,0,0,0,0,0,120,165,130,0,0,0,0,0,120,165,130,0,
0,0,0,0,120,165,130,0,0,0,0,0,120,165,130,0,0,0,0,0,
0,0,0,0,0,0,0,0,6,61,129,0,0,0,0,0,104,60,129,0,
0,0,0,0,70,60,129,0,0,0,0,0,78,60,129,0,0,0,0,0,
86,60,129,0,0,0,0,0,120,165,130,0,0,0,0,0,94,60,129,0,
0,0,0,0,0,0,0,0,0,0,0,0,120,165,130,0,0,0,0,0,
120,165,130,0,0,0,0,0,120,165,130,0,0,0,0,0,120,165,130,0,
0,0,0,0,120,165,130,0,0,0,0,0,120,165,130,0,0,0,0,0,
120,165,130,0,0,0,0,0,0,0,0,0,0,0,0,0,100,67,129,0,
0,0,0,0,254,66,129,0,0,0,0,0,248,66,129,0,0,0,0,0,
242,66,129,0,0,0,0,0,236,66,129,0,0,0,0,0,216,66,129,0,
0,0,0,0,210,66,129,0,0,0,0,0,144,209,141,0,24,94,129,0,
128,234,133,0,136,234,133,0,144,234,133,0,152,234,133,0,160,234,133,0,
168,234,133,0,176,234,133,0,184,234,133,0,192,234,133,0,2,0,0,0,
14,20,2,0,0,0,0,0,82,101,97,100,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,3,0,0,0,5,20,2,0,0,0,0,0,
87,114,105,116,101,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
4,0,0,0,2,20,2,0,0,0,0,0,82,101,97,100,86,101,114,105,
102,121,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
18,121,129,0,78,111,112,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,1,0,0,0,0,0,0,0,38,121,129,0,73,110,105,116,
67,111,110,110,101,99,116,0,0,0,0,0,0,0,0,0,5,0,0,0,
0,4,0,0,22,113,129,0,86,101,114,105,102,121,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,6,0,0,0,0,0,0,0,164,104,129,0,
80,111,114,116,83,99,97,110,0,0,0,0,0,0,0,0,0,0,0,0,
7,0,0,0,0,0,0,0,60,104,129,0,73,109,112,111,114,116,85,110,
105,116,0,0,0,0,0,0,0,0,0,0,8,0,0,0,0,4,0,0,
154,112,129,0,90,101,114,111,85,110,105,116,0,0,0,0,0,0,0,0,
0,0,0,0,9,0,0,0,0,4,0,0,102,112,129,0,82,101,112,108,
97,99,101,68,114,105,118,101,0,0,0,0,0,0,0,0,10,0,0,0,
0,0,0,0,200,109,129,0,72,111,116,83,119,97,112,0,0,0,0,0,
0,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,64,109,129,0,
83,101,108,102,84,101,115,116,115,0,0,0,0,0,0,0,0,0,0,0,
12,0,0,0,32,0,0,0,48,189,129,0,83,121,110,99,80,97,114,97,
109,0,0,0,0,0,0,0,0,0,0,0,13,0,0,0,32,0,0,0,
42,105,129,0,82,101,111,114,100,101,114,85,110,105,116,115,0,0,0,0,
0,0,0,0,14,0,0,0,0,4,0,0,244,120,129,0,70,108,117,115,
104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,0,0,0,
32,6,0,0,210,101,129,0,77,105,103,114,97,116,101,85,110,105,116,0,
0,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,38,124,129,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
17,0,0,0,0,8,0,0,144,113,129,0,65,84,65,80,97,115,115,84,
104,114,117,0,0,0,0,0,0,0,0,0,18,0,0,0,96,0,0,0,
10,193,129,0,71,101,116,80,97,114,97,109,0,0,0,0,0,0,0,0,
0,0,0,0,19,0,0,0,32,0,0,0,10,191,129,0,83,101,116,80,
97,114,97,109,0,0,0,0,0,0,0,0,0,0,0,0,20,0,0,0,
32,2,0,0,224,116,129,0,67,114,101,97,116,101,85,110,105,116,0,0,
0,0,0,0,0,0,0,0,21,0,0,0,0,4,0,0,26,116,129,0,
68,101,108,101,116,101,85,110,105,116,0,0,0,0,0,0,0,0,0,0,
22,0,0,0,32,0,0,0,194,114,129,0,68,111,119,110,108,111,97,100,
70,87,0,0,0,0,0,0,0,0,0,0,23,0,0,0,0,4,0,0,
14,112,129,0,82,101,98,117,105,108,100,85,110,105,116,0,0,0,0,0,
0,0,0,0,24,0,0,0,0,0,0,0,120,103,129,0,80,119,114,77,
97,110,97,103,101,109,101,110,116,0,0,0,0,0,0,0,25,0,0,0,
64,2,0,0,116,111,129,0,82,101,97,100,80,114,111,109,70,105,108,101,
0,0,0,0,0,0,0,0,26,0,0,0,0,0,0,0,38,124,129,0,
87,114,105,116,101,67,102,103,0,0,0,0,0,0,0,0,0,0,0,0,
27,0,0,0,32,0,0,0,38,104,129,0,82,101,109,111,116,101,80,114,
105,110,116,0,0,0,0,0,0,0,0,0,28,0,0,0,0,0,0,0,
46,111,129,0,82,101,115,101,116,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,29,0,0,0,0,0,0,0,38,124,129,0,82,101,115,101,
114,118,101,100,55,0,0,0,0,0,0,0,0,0,0,0,30,0,0,0,
0,0,0,0,30,55,128,0,66,66,85,67,111,110,116,114,111,108,0,0,
0,0,0,0,0,0,0,0,31,0,0,0,0,0,0,0,30,106,129,0,
68,105,97,103,110,111,115,116,105,99,0,0,0,0,0,0,0,0,0,0,
40,0,0,0,14,53,2,0,0,0,0,0,82,101,97,100,49,48,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,42,0,0,0,5,53,2,0,
0,0,0,0,87,114,105,116,101,49,48,0,0,0,0,0,0,0,0,0,
0,0,0,0,136,0,0,0,14,53,2,0,0,0,0,0,82,101,97,100,
49,54,0,0,0,0,0,0,0,0,0,0,0,0,0,0,138,0,0,0,
5,53,2,0,0,0,0,0,87,114,105,116,101,49,54,0,0,0,0,0,
0,0,0,0,0,0,0,0,168,0,0,0,14,53,2,0,0,0,0,0,
82,101,97,100,49,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
170,0,0,0,5,53,2,0,0,0,0,0,87,114,105,116,101,49,50,0,
0,0,0,0,0,0,0,0,0,0,0,0,8,0,0,0,14,53,2,0,
0,0,0,0,82,101,97,100,54,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,10,0,0,0,5,53,2,0,0,0,0,0,87,114,105,116,
101,54,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,0,0,0,
2,53,2,0,0,0,0,0,86,101,114,105,102,121,49,48,0,0,0,0,
0,0,0,0,0,0,0,0,143,0,0,0,2,53,2,0,0,0,0,0,
86,101,114,105,102,121,49,54,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,53,0,0,42,135,129,0,84,101,115,116,85,110,105,116,
82,101,97,100,121,0,0,0,0,0,0,0,3,0,0,0,64,1,0,0,
192,134,129,0,82,101,113,117,101,115,116,83,101,110,115,101,0,0,0,0,
0,0,0,0,18,0,0,0,64,53,0,0,198,133,129,0,73,110,113,117,
105,114,121,0,0,0,0,0,0,0,0,0,0,0,0,0,26,0,0,0,
64,1,0,0,66,132,129,0,77,111,100,101,83,101,110,115,101,54,0,0,
0,0,0,0,0,0,0,0,27,0,0,0,0,21,0,0,42,130,129,0,
83,116,97,114,116,83,116,111,112,0,0,0,0,0,0,0,0,0,0,0,
37,0,0,0,64,53,0,0,188,132,129,0,82,101,97,100,67,97,112,97,
99,105,116,121,0,0,0,0,0,0,0,0,21,0,0,0,32,21,0,0,
66,131,129,0,77,111,100,101,83,101,108,101,99,116,54,0,0,0,0,0,
0,0,0,0,59,0,0,0,0,1,0,0,8,135,129,0,87,114,105,116,
101,66,117,102,102,101,114,0,0,0,0,0,0,0,0,0,60,0,0,0,
0,1,0,0,8,135,129,0,82,101,97,100,66,117,102,102,101,114,0,0,
0,0,0,0,0,0,0,0,85,0,0,0,32,21,0,0,8,131,129,0,
77,111,100,101,83,101,108,101,99,116,49,48,0,0,0,0,0,0,0,0,
90,0,0,0,64,21,0,0,176,131,129,0,77,111,100,101,83,101,110,115,
101,49,48,0,0,0,0,0,0,0,0,0,53,0,0,0,0,21,0,0,
0,130,129,0,83,121,110,99,67,97,99,104,101,49,48,0,0,0,0,0,
0,0,0,0,145,0,0,0,0,21,0,0,0,130,129,0,83,121,110,99,
67,97,99,104,101,49,48,0,0,0,0,0,0,0,0,0,158,0,0,0,
64,21,0,0,128,129,129,0,83,101,114,118,105,99,101,65,99,116,105,111,
110,73,110,0,0,0,0,0,160,0,0,0,64,21,0,0,134,128,129,0,
82,101,112,111,114,116,76,85,78,83,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,120,165,130,0,0,0,0,0,
120,165,130,0,0,0,0,0,0,0,0,0,0,0,0,0,50,135,129,0,
0,0,0,0,46,135,129,0,232,203,142,0,220,203,142,0,208,203,142,0,
0,0,0,0,0,0,0,0,0,0,0,0,120,165,130,0,0,0,0,0,
120,165,130,0,0,0,0,0,120,165,130,0,0,0,0,0,120,165,130,0,
0,0,0,0,120,165,130,0,0,0,0,0,120,165,130,0,0,0,0,0,
120,165,130,0,0,0,0,0,0,0,0,0,0,0,0,0,22,142,129,0,
0,0,0,0,44,143,129,0,0,0,0,0,52,144,129,0,0,0,0,0,
146,144,129,0,0,0,0,0,200,138,129,0,0,0,0,0,184,139,129,0,
0,0,0,0,62,141,129,0,0,0,0,0,0,0,0,0,0,0,0,0,
166,145,129,0,0,0,0,0,16,146,129,0,0,0,0,0,124,146,129,0,
0,0,0,0,202,146,129,0,0,0,0,0,120,165,130,0,0,0,0,0,
120,165,130,0,0,0,0,0,120,165,130,0,0,0,0,0,0,0,0,0,
0,0,0,0,226,155,129,0,0,0,0,0,188,154,129,0,0,0,0,0,
0,0,0,0,0,0,0,0,128,154,129,0,0,0,0,0,122,154,129,0,
0,0,0,0,0,0,0,0,0,0,0,0,28,194,129,0,0,0,0,0,
22,194,129,0,0,0,0,0,20,194,129,0,0,0,0,0,0,0,0,0,
0,0,0,0,214,193,129,0,0,0,0,0,192,193,129,0,0,0,0,0,
188,193,129,0,0,0,0,0,0,0,0,0,0,0,0,0,126,193,129,0,
0,0,0,0,192,193,129,0,0,0,0,0,122,193,129,0,0,0,0,0,
0,0,0,0,0,0,0,0,104,193,129,0,0,0,0,0,22,194,129,0,
0,0,0,0,118,193,129,0,0,0,0,0,232,244,133,0,104,193,129,0,
2,0,0,0,160,179,133,0,0,0,0,0,3,0,0,0,232,179,133,0,
0,0,0,0,4,0,0,0,248,179,133,0,0,0,0,0,5,0,0,0,
8,180,133,0,0,0,0,0,0,2,15,16,176,179,133,0,0,0,0,0,
0,3,15,16,52,182,133,0,0,0,0,0,1,4,0,0,104,235,133,0,
0,0,0,0,2,4,0,0,180,181,133,0,0,0,0,0,3,4,0,0,
20,181,133,0,0,0,0,0,10,4,0,0,56,180,133,0,0,0,0,0,
12,4,0,0,80,180,133,0,0,0,0,0,16,4,7,6,144,180,133,0,
0,0,0,0,6,0,0,0,164,182,133,0,0,0,0,0,0,127,255,255,
112,235,133,0,0,0,0,0,0,0,0,0,76,164,145,0,198,207,129,0,
0,0,0,0,4,165,145,0,198,207,129,0,51,119,97,114,101,32,73,110,
116,101,114,110,97,108,32,85,115,101,32,32,0,0,0,0,78,111,32,70,
97,99,116,111,114,121,32,68,97,116,97,32,104,97,115,32,98,101,101,110,
32,119,114,105,116,116,101,110,46,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,54,211,129,0,0,0,0,0,
36,186,129,0,0,0,0,0,204,202,129,0,0,0,0,0,0,0,0,0,
0,0,0,0,54,211,129,0,0,0,0,0,208,185,129,0,0,0,0,0,
204,202,129,0,0,0,0,0,0,0,0,0,0,0,0,0,54,211,129,0,
0,0,0,0,66,185,129,0,0,0,0,0,204,202,129,0,0,0,0,0,
0,0,0,0,0,0,0,0,54,211,129,0,0,0,0,0,238,184,129,0,
0,0,0,0,204,202,129,0,0,0,0,0,0,0,0,0,0,0,0,0,
54,211,129,0,0,0,0,0,154,184,129,0,0,0,0,0,204,202,129,0,
0,0,0,0,0,0,0,0,0,0,0,0,250,172,129,0,0,0,0,0,
110,174,129,0,0,0,0,0,158,172,129,0,0,0,0,0,120,165,130,0,
0,0,0,0,0,0,0,0,0,0,0,0,30,178,129,0,0,0,0,0,
110,174,129,0,0,0,0,0,62,178,129,0,0,0,0,0,106,178,129,0,
0,0,0,0,0,0,0,0,0,0,0,0,46,173,129,0,0,0,0,0,
220,174,129,0,0,0,0,0,98,173,129,0,0,0,0,0,76,170,129,0,
0,0,0,0,0,0,0,0,0,0,0,0,54,211,129,0,0,0,0,0,
72,214,129,0,0,0,0,0,66,214,129,0,0,0,0,0,0,0,0,0,
0,0,0,0,210,209,129,0,0,0,0,0,58,214,129,0,0,0,0,0,
66,214,129,0,0,0,0,0,0,0,0,0,0,0,0,0,76,209,129,0,
0,0,0,0,58,214,129,0,0,0,0,0,66,214,129,0,0,0,0,0,
0,0,0,0,0,0,0,0,210,209,129,0,0,0,0,0,22,209,129,0,
0,0,0,0,66,214,129,0,0,0,0,0,0,0,0,0,0,0,0,0,
76,209,129,0,0,0,0,0,222,208,129,0,0,0,0,0,66,214,129,0,
0,0,0,0,0,0,0,0,0,0,0,0,120,206,129,0,0,0,0,0,
58,214,129,0,0,0,0,0,66,214,129,0,0,0,0,0,0,0,0,0,
0,0,0,0,6,206,129,0,0,0,0,0,58,214,129,0,0,0,0,0,
66,214,129,0,0,0,0,0,0,0,0,0,0,0,0,0,128,205,129,0,
0,0,0,0,58,214,129,0,0,0,0,0,66,214,129,0,0,0,0,0,
0,0,0,0,0,0,0,0,54,211,129,0,0,0,0,0,62,214,129,0,
0,0,0,0,66,214,129,0,0,0,0,0,0,0,0,0,0,0,0,0,
54,211,129,0,0,0,0,0,54,214,129,0,0,0,0,0,226,204,129,0,
0,0,0,0,0,0,0,0,0,0,0,0,54,211,129,0,0,0,0,0,
50,214,129,0,0,0,0,0,148,204,129,0,0,0,0,0,0,0,0,0,
0,0,0,0,54,211,129,0,0,0,0,0,46,214,129,0,0,0,0,0,
80,204,129,0,0,0,0,0,0,0,0,0,0,0,0,0,54,211,129,0,
0,0,0,0,42,214,129,0,0,0,0,0,56,204,129,0,0,0,0,0,
0,0,0,0,0,0,0,0,54,211,129,0,0,0,0,0,38,214,129,0,
0,0,0,0,142,203,129,0,0,0,0,0,0,0,0,0,0,0,0,0,
54,211,129,0,0,0,0,0,34,214,129,0,0,0,0,0,128,203,129,0,
0,0,0,0,0,0,0,0,0,0,0,0,54,211,129,0,0,0,0,0,
30,214,129,0,0,0,0,0,24,203,129,0,0,0,0,0,0,0,0,0,
0,0,0,0,54,211,129,0,0,0,0,0,26,214,129,0,0,0,0,0,
0,203,129,0,0,0,0,0,0,0,0,0,0,0,0,0,54,211,129,0,
0,0,0,0,22,214,129,0,0,0,0,0,210,202,129,0,0,0,0,0,
0,0,0,0,0,0,0,0,54,211,129,0,0,0,0,0,16,210,129,0,
0,0,0,0,66,214,129,0,0,0,0,0,0,0,0,0,0,0,0,0,
54,211,129,0,0,0,0,0,124,213,129,0,0,0,0,0,66,214,129,0,
0,0,0,0,0,0,0,0,0,0,0,0,132,211,129,0,0,0,0,0,
172,210,129,0,0,0,0,0,66,214,129,0,0,0,0,0,0,0,0,0,
0,0,0,0,54,211,129,0,0,0,0,0,82,213,129,0,0,0,0,0,
66,214,129,0,0,0,0,0,0,0,0,0,0,0,0,0,210,209,129,0,
0,0,0,0,232,206,129,0,0,0,0,0,66,214,129,0,0,0,0,0,
52,177,255,255,62,220,129,0,0,0,0,0,0,0,0,0,0,0,0,0,
164,244,129,0,0,0,0,0,38,238,129,0,0,0,0,0,170,22,130,0,
0,0,0,0,130,22,130,0,0,0,0,0,194,230,129,0,0,0,0,0,
130,16,130,0,0,0,0,0,156,15,130,0,0,0,0,0,184,14,130,0,
0,0,0,0,118,227,129,0,0,0,0,0,162,14,130,0,0,0,0,0,
216,248,129,0,0,0,0,0,18,9,130,0,0,0,0,0,0,0,0,0,
0,0,0,0,98,22,130,0,0,0,0,0,38,238,129,0,0,0,0,0,
170,22,130,0,0,0,0,0,130,22,130,0,0,0,0,0,194,230,129,0,
0,0,0,0,34,1,130,0,0,0,0,0,156,15,130,0,0,0,0,0,
184,14,130,0,0,0,0,0,118,227,129,0,0,0,0,0,162,14,130,0,
0,0,0,0,216,248,129,0,0,0,0,0,18,9,130,0,0,0,0,0,
0,0,0,0,0,0,0,0,66,22,130,0,0,0,0,0,38,238,129,0,
0,0,0,0,170,22,130,0,0,0,0,0,130,22,130,0,0,0,0,0,
168,0,130,0,0,0,0,0,130,16,130,0,0,0,0,0,156,15,130,0,
0,0,0,0,184,14,130,0,0,0,0,0,118,227,129,0,0,0,0,0,
162,14,130,0,0,0,0,0,216,248,129,0,0,0,0,0,18,9,130,0,
0,0,0,0,0,0,0,0,0,0,0,0,34,22,130,0,0,0,0,0,
38,238,129,0,0,0,0,0,170,22,130,0,0,0,0,0,130,22,130,0,
0,0,0,0,194,230,129,0,0,0,0,0,130,16,130,0,0,0,0,0,
66,0,130,0,0,0,0,0,124,254,129,0,0,0,0,0,118,227,129,0,
0,0,0,0,162,14,130,0,0,0,0,0,216,248,129,0,0,0,0,0,
18,9,130,0,0,0,0,0,0,0,0,0,0,0,0,0,2,22,130,0,
0,0,0,0,38,238,129,0,0,0,0,0,170,22,130,0,0,0,0,0,
130,22,130,0,0,0,0,0,242,253,129,0,0,0,0,0,130,16,130,0,
0,0,0,0,6,253,129,0,0,0,0,0,56,252,129,0,0,0,0,0,
118,227,129,0,0,0,0,0,162,14,130,0,0,0,0,0,212,251,129,0,
0,0,0,0,18,9,130,0,0,0,0,0,0,0,0,0,0,0,0,0,
226,21,130,0,0,0,0,0,38,238,129,0,0,0,0,0,170,22,130,0,
0,0,0,0,130,22,130,0,0,0,0,0,74,251,129,0,0,0,0,0,
48,251,129,0,0,0,0,0,24,251,129,0,0,0,0,0,42,250,129,0,
0,0,0,0,118,227,129,0,0,0,0,0,162,14,130,0,0,0,0,0,
76,249,129,0,0,0,0,0,18,9,130,0,0,0,0,0,0,0,0,0,
0,0,0,0,70,245,129,0,0,0,0,0,96,242,129,0,0,0,0,0,
72,225,129,0,0,0,0,0,30,225,129,0,0,0,0,0,126,232,129,0,
0,0,0,0,100,230,129,0,0,0,0,0,190,229,129,0,0,0,0,0,
10,228,129,0,0,0,0,0,212,227,129,0,0,0,0,0,162,14,130,0,
0,0,0,0,168,226,129,0,0,0,0,0,18,9,130,0,40,236,133,0,
8,198,133,0,60,198,133,0,24,198,133,0,36,198,133,0,48,198,133,0,
252,197,133,0,76,198,133,0,0,0,0,0,0,0,0,0,0,0,0,0,
86,37,130,0,0,0,0,0,162,37,130,0,0,0,0,0,0,0,0,0,
0,0,0,0,180,36,130,0,0,0,0,0,156,37,130,0,0,0,0,0,
0,221,152,0,92,51,130,0,0,0,0,0,36,221,152,0,176,64,130,0,
0,0,0,0,216,228,152,0,36,70,130,0,180,179,255,255,108,211,133,0,
130,116,1,0,0,0,0,0,8,227,255,255,0,0,0,0,11,0,0,0,
11,0,0,0,0,0,0,0,0,0,0,0,104,116,1,0,10,0,0,0,
176,224,152,0,128,210,133,0,236,112,1,0,0,0,0,0,8,164,153,0,
0,0,0,0,10,0,0,0,10,0,0,0,0,0,0,0,1,0,0,0,
232,112,1,0,0,0,0,0,184,221,152,0,144,210,133,0,120,117,1,0,
0,0,0,0,8,84,153,0,0,0,0,0,10,0,0,0,10,0,0,0,
0,0,0,0,1,0,0,0,116,117,1,0,0,0,0,0,232,222,152,0,
124,211,133,0,154,115,1,0,0,0,0,0,8,116,153,0,0,0,0,0,
11,0,0,0,11,0,0,0,0,0,0,0,1,0,0,0,122,115,1,0,
0,0,0,0,72,225,152,0,160,210,133,0,154,110,1,0,0,0,0,0,
8,180,153,0,0,0,0,0,10,0,0,0,10,0,0,0,0,0,0,0,
0,0,0,0,116,110,1,0,2,0,0,0,224,225,152,0,144,211,133,0,
168,114,1,0,0,0,0,0,8,196,153,0,0,0,0,0,8,0,0,0,
8,0,0,0,0,0,0,0,1,0,0,0,138,114,1,0,3,0,0,0,
24,224,152,0,164,211,133,0,52,115,1,0,0,0,0,0,8,148,153,0,
0,0,0,0,6,0,0,0,6,0,0,0,0,0,0,0,1,0,0,0,
48,115,1,0,3,0,0,0,128,223,152,0,176,210,133,0,226,114,1,0,
0,0,0,0,8,132,153,0,0,0,0,0,5,0,0,0,5,0,0,0,
0,0,0,0,1,0,0,0,222,114,1,0,3,0,0,0,120,226,152,0,
192,211,133,0,82,108,1,0,0,0,0,0,8,244,153,0,0,0,0,0,
4,0,0,0,4,0,0,0,0,0,0,0,1,0,0,0,78,108,1,0,
0,0,0,0,80,222,152,0,212,211,133,0,46,117,1,0,0,0,0,0,
8,100,153,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,
1,0,0,0,42,117,1,0,3,0,0,0,16,227,152,0,200,210,133,0,
118,109,1,0,0,0,0,0,8,4,154,0,0,0,0,0,3,0,0,0,
3,0,0,0,0,0,0,0,1,0,0,0,42,117,1,0,3,0,0,0,
168,227,152,0,216,210,133,0,248,108,1,0,0,0,0,0,8,8,154,0,
0,0,0,0,2,0,0,0,2,0,0,0,0,0,0,0,1,0,0,0,
42,117,1,0,3,0,0,0,64,228,152,0,248,210,133,0,150,108,1,0,
0,0,0,0,8,12,154,0,0,0,0,0,7,0,0,0,7,0,0,0,
0,0,0,0,1,0,0,0,42,117,1,0,3,0,0,0,0,0,0,0,
0,0,0,0,216,71,130,0,232,3,0,0,67,111,112,121,114,105,103,104,
116,32,40,99,41,32,49,57,57,54,45,50,48,48,50,32,69,120,112,114,
101,115,115,32,76,111,103,105,99,32,73,110,99,46,32,42,32,84,104,114,
101,97,100,88,32,78,69,67,32,86,56,53,48,69,47,71,114,101,101,110,
32,72,105,108,108,115,32,86,101,114,115,105,111,110,32,71,52,46,48,97,
46,52,46,48,97,32,42,0,71,45,71,66,45,71,76,45,77,45,68,45,
68,76,45,75,77,76,45,67,77,82,45,72,77,82,45,77,76,50,45,71,
90,45,75,72,50,45,67,77,45,82,80,45,84,67,45,78,72,45,84,68,
45,65,80,45,72,65,45,71,70,45,68,68,45,65,84,45,77,70,45,77,
83,45,68,87,45,85,83,65,45,67,65,45,83,68,45,83,68,83,85,0,
117,110,107,110,111,119,110,0,10,0,0,0,101,120,99,101,112,116,105,111,
110,58,32,0,0,0,0,0,0,0,0,0,0,0,0,0,170,159,130,0,
0,0,0,0,152,159,130,0,0,0,0,0,206,159,130,0,0,0,0,0,
0,0,0,0,0,0,0,0,166,153,130,0,0,0,0,0,136,153,130,0,
0,0,0,0,64,153,130,0,0,0,0,0,0,0,0,0,0,0,0,0,
246,152,130,0,0,0,0,0,136,153,130,0,0,0,0,0,218,152,130,0,
0,0,0,0,0,0,0,0,0,0,0,0,144,152,130,0,0,0,0,0,
136,153,130,0,0,0,0,0,206,151,130,0,117,110,107,110,111,119,110,0,
105,110,118,97,108,105,100,32,115,116,114,105,110,103,32,112,111,115,105,116,
105,111,110,0,117,110,107,110,111,119,110,0,115,116,114,105,110,103,32,116,
111,111,32,108,111,110,103,0,255,255,255,255,0,0,0,0,69,114,114,111,
114,58,32,100,101,116,101,99,116,101,100,32,109,105,115,109,97,116,99,104,
32,105,110,32,116,104,101,32,115,116,97,116,105,99,32,100,101,115,116,114,
117,99,116,111,114,32,111,114,100,101,114,105,110,103,32,115,116,114,97,116,
101,103,121,10,0,0,0,0,69,114,114,111,114,58,32,100,101,116,101,99,
116,101,100,32,109,105,115,109,97,116,99,104,32,105,110,32,116,104,101,32,
115,116,97,116,105,99,32,100,101,115,116,114,117,99,116,111,114,32,111,114,
100,101,114,105,110,103,32,115,116,114,97,116,101,103,121,10,0,0,0,0,
0,0,0,0,8,0,0,0,67,43,43,32,114,117,110,116,105,109,101,32,
97,98,111,114,116,0,0,0,102,114,101,101,105,110,103,32,97,114,114,97,
121,32,110,111,116,32,97,108,108,111,99,97,116,101,100,32,98,121,32,97,
110,32,97,114,114,97,121,32,110,101,119,32,111,112,101,114,97,116,105,111,
110,0,0,0,116,101,114,109,105,110,97,116,101,40,41,32,99,97,108,108,
101,100,32,98,121,32,116,104,101,32,101,120,99,101,112,116,105,111,110,32,
104,97,110,100,108,105,110,103,32,109,101,99,104,97,110,105,115,109,0,0,
114,101,116,117,114,110,101,100,32,102,114,111,109,32,97,32,117,115,101,114,
45,100,101,102,105,110,101,100,32,116,101,114,109,105,110,97,116,101,40,41,
32,114,111,117,116,105,110,101,0,0,0,0,109,97,105,110,40,41,32,99,
97,108,108,101,100,32,109,111,114,101,32,116,104,97,110,32,111,110,99,101,
0,0,0,0,97,32,112,117,114,101,32,118,105,114,116,117,97,108,32,102,
117,110,99,116,105,111,110,32,119,97,115,32,99,97,108,108,101,100,0,0,
105,110,118,97,108,105,100,32,100,121,110,97,109,105,99,32,99,97,115,116,
0,0,0,0,105,110,118,97,108,105,100,32,116,121,112,101,105,100,32,111,
112,101,114,97,116,105,111,110,0,0,0,0,105,110,116,101,114,110,97,108,
32,101,114,114,111,114,58,32,115,116,97,116,105,99,32,111,98,106,101,99,
116,32,109,97,114,107,101,100,32,102,111,114,32,100,101,115,116,114,117,99,
116,105,111,110,32,109,111,114,101,32,116,104,97,110,32,111,110,99,101,0,
37,115,58,32,37,115,10,0,0,0,0,0,94,32,9,10,13,11,12,93,
0,40,110,117,108,108,41,0,0,48,49,50,51,52,53,54,55,56,57,65,
66,67,68,69,70,40,70,108,111,97,116,105,110,103,32,112,111,105,110,116,
32,111,117,116,112,117,116,32,117,110,115,117,112,112,111,114,116,101,100,32,
119,47,45,110,111,102,108,111,97,116,105,111,32,111,114,32,45,102,110,111,
110,101,41,0,20,0,65,77,0,80,77,0,0,0,83,117,110,77,111,110,
84,117,101,87,101,100,84,104,117,70,114,105,83,97,116,0,0,0,74,97,
110,70,101,98,77,97,114,65,112,114,77,97,121,74,117,110,74,117,108,65,
117,103,83,101,112,79,99,116,78,111,118,68,101,99,0,0,0,0,83,117,
110,100,97,121,0,77,111,110,100,97,121,0,84,117,101,115,100,97,121,0,
87,101,100,110,101,115,100,97,121,0,84,104,117,114,115,100,97,121,0,70,
114,105,100,97,121,0,83,97,116,117,114,100,97,121,0,0,0,0,74,97,
110,117,97,114,121,0,70,101,98,114,117,97,114,121,0,77,97,114,99,104,
0,65,112,114,105,108,0,77,97,121,0,74,117,110,101,0,74,117,108,121,
0,65,117,103,117,115,116,0,83,101,112,116,101,109,98,101,114,0,79,99,
116,111,98,101,114,0,78,111,118,101,109,98,101,114,0,68,101,99,101,109,
98,101,114,0,0,0,87,69,84,0,32,32,32,0,32,32,32,0,32,32,
32,0,65,83,84,0,69,83,84,0,67,83,84,0,77,83,84,0,80,83,
84,0,32,32,32,0,32,32,32,0,32,32,32,0,32,32,32,0,32,32,
32,0,32,32,32,0,32,32,32,0,32,32,32,0,32,32,32,0,32,32,
32,0,32,32,32,0,32,32,32,0,32,32,32,0,32,32,32,0,77,69,
84,0,69,69,84,0,32,32,32,0,0,0,31,0,59,0,90,0,120,0,
151,0,181,0,212,0,243,0,17,1,48,1,78,1,71,77,84,0,32,32,
32,0,31,28,31,30,31,30,31,31,30,31,30,31,31,28,31,30,31,30,
31,31,30,31,30,0,0,0,0,0,0,0,0,255,0,0,128,0,0,4,
0,1,0,4,0,2,0,4,179,82,179,82,179,82,179,82,179,34,179,18,
179,18,0,0,224,18,133,0,0,1,0,0,0,0,0,0,0,0,0,0,
32,45,133,0,0,0,0,0,19,0,0,0,115,116,114,105,110,103,32,110,
111,116,32,102,111,117,110,100,0,0,0,0,82,101,118,32,48,48,48,32,
0,0,0,0,71,101,114,111,110,105,109,111,47,65,112,97,99,104,101,32,
0,0,0,0,123,231,133,0,126,231,133,0,0,0,0,0,16,0,0,0,
0,0,5,0,9,0,0,0,0,0,0,0,0,0,8,0,0,0,0,0,
0,0,0,0,1,2,0,0,1,0,0,0,0,0,0,0,126,74,13,125,
127,127,0,0,126,73,0,125,127,127,0,0,126,72,1,125,0,125,127,127,
126,75,13,125,15,125,127,127,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,242,5,42,1,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176,179,133,0,
180,181,133,0,52,182,133,0,112,235,133,0,164,182,133,0,232,179,133,0,
248,179,133,0,8,180,133,0,56,180,133,0,80,180,133,0,144,180,133,0,
168,180,133,0,180,183,133,0,120,235,133,0,60,82,134,0,1,0,0,0,
1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,2,0,0,78,77,73,0,56,236,133,0,60,236,133,0,64,236,133,0,
0,0,0,0,0,0,0,0,100,245,133,0,0,0,0,0,1,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,240,240,240,240,16,0,0,0,16,0,0,0,0,1,0,0,
0,2,0,0,7,0,0,0,128,0,0,0,156,213,130,0,0,0,0,0,
164,190,130,0,4,147,130,0,10,0,0,0,10,0,0,0,37,48,50,88,
32,0,0,0,10,0,0,0,37,48,50,88,32,0,0,0,10,0,0,0,
37,48,50,88,32,0,0,0,48,120,37,48,56,88,0,0,10,0,0,0,
48,120,37,48,56,88,0,0,37,48,50,46,50,88,32,0,112,102,99,104,
101,99,107,0,111,112,115,116,97,116,101,0,112,98,98,117,102,108,103,0,
32,32,100,111,110,101,10,0,112,100,104,0,119,114,105,116,101,0,0,0,
37,48,50,88,32,0,0,0,10,0,0,0,112,102,112,100,108,0,0,0,
114,101,115,101,116,0,0,0,115,99,111,109,112,0,0,0,115,115,121,110,
99,0,0,0,101,105,110,116,114,0,0,0,100,105,110,116,114,0,0,0,
99,105,110,116,114,0,0,0,114,101,97,100,0,0,0,0,114,98,117,102,
0,0,0,0,114,120,0,0,37,99,32,32,0,0,0,0,99,98,117,102,
0,0,0,0,116,101,115,116,0,0,0,0,101,117,0,100,117,0,115,112,
0,0,0,0,115,100,102,116,0,0,0,0,115,108,115,121,110,99,0,0,
115,117,110,105,116,110,0,0,109,114,0,119,102,0,117,102,0,0,0,0,
117,102,110,114,0,0,0,0,104,101,108,112,0,0,0,0,48,120,37,48,
56,88,0,0,46,10,0,0,83,101,109,66,98,117,0,0,1,13,5,17,
222,173,10,0,117,102,0,0,111,116,104,101,114,0,0,0,109,97,105,110,
0,0,0,0,111,116,104,101,114,0,0,0,109,97,105,110,0,0,0,0,
46,10,0,0,85,80,83,32,105,115,32,0,102,111,114,99,101,100,32,0,
114,101,97,100,121,46,10,0,0,0,0,0,110,111,116,32,0,0,0,0,
0,0,0,0,48,120,37,88,0,0,0,0,0,0,0,0,0,0,0,0,
117,110,105,116,61,37,100,0,84,101,115,116,105,110,103,0,70,97,117,108,
116,0,0,0,69,114,114,111,114,0,0,0,79,75,0,0,85,110,107,110,
111,119,110,0,13,0,0,0,36,86,69,82,86,69,82,36,37,100,37,115,
10,0,0,0,75,66,0,77,66,0,0,0,80,97,114,105,116,121,0,0,
68,97,116,97,0,0,0,0,82,67,68,61,37,117,10,0,0,0,0,0,
117,110,107,110,111,119,110,0,117,110,107,110,111,119,110,0,36,86,69,82,
86,69,82,36,10,0,0,0,112,111,114,116,61,37,100,0,10,0,0,0,
37,48,51,100,32,0,0,0,32,77,73,82,82,79,82,0,32,68,69,65,
68,0,0,0,32,40,37,120,41,0,0,0,32,82,65,73,68,48,0,0,
32,82,65,73,68,53,0,0,37,115,0,43,62,0,32,32,0,0,0,0,
0,0,255,255,72,168,0,0,0,0,255,255,128,168,0,0,0,0,255,255,
14,167,0,0,0,0,255,255,160,167,0,0,0,0,255,255,12,168,0,0,
0,0,255,255,90,167,0,0,0,0,255,255,138,226,0,0,0,0,255,255,
24,240,0,0,0,0,255,255,0,241,0,0,0,0,255,255,176,240,0,0,
0,0,255,255,216,240,0,0,0,0,255,255,176,240,0,0,0,0,255,255,
150,239,0,0,0,0,255,255,240,239,0,0,0,0,255,255,110,239,0,0,
0,0,255,255,70,239,0,0,0,0,255,255,254,238,0,0,0,0,255,255,
64,240,0,0,0,0,255,255,82,229,0,0,0,0,255,255,116,228,0,0,
0,0,255,255,34,228,0,0,0,0,255,255,196,231,0,0,0,0,255,255,
54,233,0,0,0,0,255,255,12,226,0,0,0,0,255,255,162,228,0,0,
0,0,255,255,128,233,0,0,0,0,255,255,218,235,0,0,0,0,255,255,
18,236,0,0,0,0,255,255,70,227,0,0,0,0,255,255,138,226,0,0,
0,0,255,255,70,226,0,0,0,0,255,255,248,226,0,0,0,0,255,255,
166,193,0,0,0,0,255,255,8,194,0,0,0,0,255,255,24,194,0,0,
73,110,105,116,105,97,108,0,73,100,108,101,0,0,0,0,32,32,32,0,
32,37,48,50,88,0,0,0,10,0,37,99,0,0,0,0,112,111,114,116,
115,0,0,0,112,111,114,116,0,0,0,0,37,99,37,105,0,0,0,0,
37,115,37,115,37,99,0,0,84,87,77,72,0,0,0,0,8,0,0,0,
8,0,0,0,99,104,101,99,107,102,119,0,99,109,100,104,105,115,116,0,
109,101,109,114,101,97,100,0,116,104,114,101,97,100,115,0,100,105,115,101,
99,104,111,0,98,98,117,0,109,111,110,0,116,97,115,0,118,97,114,0,
118,101,114,0,35,0,104,0,112,97,114,97,109,0,0,0,116,97,115,107,
115,0,0,0,117,110,105,116,115,0,0,0,47,47,0,0,99,109,100,108,
111,103,0,0,100,101,108,101,116,101,0,0,99,114,101,97,116,101,0,0,
100,114,105,118,101,115,0,0,103,111,0,0,115,105,109,101,114,114,0,0,
115,116,97,116,117,115,0,0,116,97,115,107,0,0,0,0,116,104,0,0,
117,110,108,111,99,107,0,0,37,105,0,0,108,111,99,97,108,0,0,0,
52,46,48,0,37,105,0,0,28,0,0,0,7,0,0,0,67,111,100,101,
115,58,10,0,109,97,105,110,0,0,0,0,85,68,77,65,45,51,51,0,
85,68,77,65,45,54,54,0,69,78,65,66,76,69,68,0,10,0,0,0,
32,37,115,44,32,0,0,0,41,0,0,0,76,79,67,75,69,68,0,0,
73,110,105,116,105,97,108,0,78,111,68,114,105,118,101,0,78,111,80,111,
114,116,0,0,10,0,0,0,116,105,109,101,111,117,116,0,104,97,110,100,
108,101,114,0,116,111,107,101,110,0,0,0,0,37,84,0,80,61,37,88,
32,58,32,0,79,75,10,0,112,111,114,116,61,37,100,0,117,110,105,116,
61,37,100,0,112,111,114,116,61,37,100,0,112,111,114,116,61,37,100,0,
117,110,105,116,61,37,100,0,97,99,116,105,118,101,10,0,10,0,0,0,
111,102,102,0,111,110,0,0,0,0,0,0,37,115,10,0,238,238,34,34,
187,187,85,85,73,78,86,65,76,73,68,0,68,73,82,72,69,65,68,0,
68,73,82,84,65,73,76,0,67,79,77,80,95,48,51,0,67,79,77,80,
95,48,52,0,67,79,77,80,95,48,53,0,67,79,77,80,95,48,54,0,
67,79,77,80,95,48,55,0,67,79,77,80,95,48,56,0,0,0,10,0,
0,0,0,0,36,86,69,82,86,69,82,36,10,0,0,0,111,102,102,0,
114,101,108,0,99,108,101,97,114,0,0,0,110,111,114,101,108,0,0,0,
111,110,0,0,115,104,111,119,0,0,0,0,37,48,52,120,32,32,0,0,
117,110,105,116,61,37,105,0,76,85,78,61,37,100,0,0,117,112,10,0,
100,111,119,110,10,0,0,0,32,37,105,60,45,37,105,0,10,0,0,0,
68,111,110,101,46,10,10,0,121,101,115,0,110,111,0,0,117,110,105,116,
61,37,100,0,0,128,131,10,0,0,0,0,108,117,110,46,99,112,112,0,
108,117,110,46,99,112,112,0,108,117,110,46,99,112,112,0,2,0,0,0,
60,151,145,0,0,0,0,0,184,149,145,0,117,110,107,110,111,119,110,0,
117,110,107,110,111,119,110,0,1,0,0,0,5,0,0,0,28,0,0,0,
24,0,0,0,0,0,0,0,20,0,0,0,9,0,4,0,3,0,7,0,
69,65,82,76,89,0,0,0,85,83,69,82,0,0,0,0,69,65,82,76,
89,0,0,0,85,83,69,82,0,0,0,0,48,120,37,48,50,88,10,0,
83,101,109,80,98,117,102,0,46,0,0,0,91,37,99,58,37,120,93,0,
10,0,0,0,117,110,105,116,61,37,100,0,37,84,0,0,117,110,105,116,
61,37,100,0,37,84,0,0,117,110,105,116,61,37,100,0,90,101,114,111,
101,114,0,0,117,110,105,116,61,37,100,0,112,111,114,116,61,37,100,0,
117,110,105,116,61,37,100,0,0,0,0,0,117,110,105,116,61,37,100,0,
10,0,0,0,27,91,67,0,27,91,68,0,27,91,50,75,13,0,0,0,
0,0,0,0,32,44,9,10,0,0,0,0,0,13,10,0,83,101,109,68,
77,65,0,0,68,69,66,85,71,0,0,0,0,0,0,32,115,112,105,46,
99,112,112,0,181,53,125,145,79,75,10,0,79,75,10,0,0,0,0,0,
13,0,0,0,0,0,0,0,37,52,100,0,10,0,0,0,37,52,104,88,
0,0,0,0,0,10,0,37,99,0,0,0,79,70,70,0,79,78,0,0,
117,110,105,116,61,37,100,0,91,37,50,100,93,0,0,0,10,0,0,0,
37,52,104,88,0,0,0,0,10,0,0,0,68,73,83,75,32,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,36,0,129,0,40,0,
1,2,4,2,136,0,4,18,68,0,130,0,130,2,72,0,2,2,2,18,
8,2,8,18,8,0,0,2,68,18,4,19,4,3,72,18,99,255,233,255,
31,48,63,6,54,51,130,0,127,0,0,0,99,255,233,255,63,6,116,81,
130,0,127,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,99,255,233,255,31,48,63,6,16,51,130,0,
127,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
99,255,233,255,31,48,63,6,16,51,130,0,127,0,0,0,99,255,233,255,
63,6,36,212,1,0,127,0,0,0,0,0,99,255,233,255,63,6,160,211,
1,0,127,0,0,0,0,0,99,255,233,255,63,6,182,211,1,0,127,0,
0,0,0,0,99,255,233,255,63,6,204,211,1,0,127,0,0,0,0,0,
99,255,233,255,63,6,204,211,1,0,127,0,0,0,0,0,99,255,233,255,
63,6,204,211,1,0,127,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,99,255,233,255,31,48,63,6,16,51,130,0,
127,0,0,0,99,255,233,255,63,6,92,212,1,0,127,0,0,0,0,0,
99,255,233,255,63,6,14,212,1,0,127,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,99,255,233,255,31,48,63,6,16,51,130,0,
127,0,0,0,99,255,233,255,63,6,226,211,1,0,127,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,99,255,233,255,31,48,63,6,
16,51,130,0,127,0,0,0,99,255,233,255,63,6,248,211,1,0,127,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,99,255,233,255,31,48,63,6,16,51,130,0,127,0,0,0,
130,7,225,243,6,224,60,223,18,0,60,23,25,0,7,200,201,218,60,239,
5,0,224,17,146,93,193,18,60,215,16,0,32,102,0,176,204,17,34,183,
0,0,201,210,0,194,57,191,9,0,60,151,1,0,99,151,1,0,128,255,
94,16,35,151,1,0,10,16,2,82,66,87,34,0,98,151,1,0,119,23,
5,0,61,87,1,0,65,194,61,111,5,0,218,81,98,87,9,0,225,103,
0,0,205,97,98,103,13,0,61,135,9,0,218,129,98,135,17,0,61,119,
13,0,98,183,26,0,218,113,98,119,21,0,61,87,17,0,2,184,186,81,
251,81,163,5,27,80,10,88,137,90,98,95,24,0,170,217,210,5,29,238,
20,0,0,210,245,197,220,215,22,0,146,13,60,87,20,0,60,135,1,0,
98,87,28,0,208,7,2,0,57,119,20,0,121,191,9,0,216,113,121,119,
20,0,66,6,255,243,152,7,225,112,7,200,8,216,187,0,6,224,60,215,
1,0,128,255,186,15,10,232,1,130,93,135,34,0,60,127,20,0,124,239,
5,0,125,215,1,0,29,208,65,122,124,127,20,0,124,215,9,0,125,7,
8,0,125,135,10,0,99,207,37,0,125,7,13,0,93,7,15,0,93,7,
16,0,99,7,29,0,99,7,33,0,60,103,1,0,99,207,41,0,32,110,
0,2,99,111,45,0,99,103,1,0,35,94,28,0,99,95,5,0,99,7,
9,0,99,7,13,0,99,135,18,0,99,7,16,0,99,7,20,0,99,7,
22,0,97,218,234,5,32,126,228,255,13,114,12,18,245,13,224,217,146,13,
38,6,208,15,133,0,32,62,129,10,0,66,128,255,28,15,32,126,232,255,
15,114,11,18,93,127,17,0,125,119,18,0,99,23,25,0,28,56,3,48,
191,255,112,254,60,23,9,0,34,87,26,0,138,86,0,128,98,87,26,0,
220,15,32,0,220,7,32,0,26,80,88,6,255,112,152,7,225,240,6,224,
7,200,25,48,39,6,208,13,133,0,8,216,32,70,0,2,129,255,144,61,
60,215,1,0,128,255,200,14,10,232,1,130,93,135,34,0,60,127,20,0,
124,239,5,0,29,192,124,199,9,0,65,122,124,127,20,0,125,7,8,0,
125,135,10,0,125,7,13,0,93,7,15,0,93,7,16,0,125,215,1,0,
27,208,154,0,27,6,15,255,130,13,27,6,14,255,130,21,27,6,10,255,
210,13,197,5,220,31,33,0,149,13,27,64,38,6,224,15,133,0,32,62,
18,10,128,255,94,14,99,207,37,0,93,215,17,0,15,106,125,111,18,0,
99,7,29,0,99,7,33,0,60,95,1,0,99,207,41,0,32,102,0,2,
99,103,45,0,99,95,1,0,35,86,28,0,99,87,5,0,99,7,9,0,
99,7,13,0,1,130,99,135,18,0,11,122,99,127,25,0,99,7,16,0,
99,7,20,0,99,7,22,0,28,56,3,48,191,255,116,253,61,118,18,0,
206,47,0,0,220,15,32,0,220,7,32,0,24,80,88,6,255,240,152,7,
225,48,7,216,6,224,60,215,1,0,128,255,230,13,10,232,1,130,93,135,
34,0,60,127,20,0,125,215,1,0,124,239,5,0,124,239,9,0,65,122,
124,127,20,0,93,7,12,0,125,135,10,0,32,118,208,0,125,119,8,0,
99,223,37,0,32,102,79,0,93,103,13,0,32,94,194,255,93,95,14,0,
32,86,160,255,93,87,16,0,32,134,176,255,93,135,17,0,13,122,125,127,
18,0,99,7,29,0,99,7,33,0,60,111,1,0,99,223,41,0,32,118,
0,2,99,119,45,0,99,111,1,0,35,102,28,0,99,103,5,0,99,7,
9,0,99,7,13,0,1,90,99,95,18,0,12,82,99,87,25,0,99,7,
16,0,99,7,20,0,99,7,22,0,28,56,3,48,191,255,170,252,60,23,
9,0,34,135,26,0,29,80,144,134,0,128,98,135,26,0,220,15,32,0,
220,7,32,0,88,6,255,48,152,7,225,16,7,216,6,232,61,231,1,0,
128,255,20,13,1,130,74,135,34,0,61,127,20,0,125,87,5,0,106,231,
1,0,10,224,65,122,125,127,20,0,125,231,9,0,106,7,8,0,106,135,
10,0,99,223,37,0,106,7,13,0,74,7,15,0,74,7,16,0,32,110,
236,255,74,111,17,0,13,98,106,103,18,0,99,7,29,0,99,7,33,0,
61,87,1,0,99,223,41,0,32,94,0,2,99,95,45,0,99,87,1,0,
35,134,28,0,99,135,5,0,99,7,9,0,99,7,13,0,1,122,99,127,
18,0,12,114,99,119,25,0,99,7,16,0,99,7,20,0,99,7,22,0,
29,56,3,48,191,255,236,251,61,23,9,0,34,111,26,0,28,80,141,110,
0,128,98,111,26,0,221,15,32,0,221,7,32,0,88,6,255,16,128,7,
225,48,7,224,6,232,61,223,1,0,61,215,9,0,128,255,82,12,1,138,
10,16,66,143,34,0,122,23,5,0,61,135,20,0,125,23,9,0,65,130,
125,135,20,0,252,127,1,0,98,127,8,0,252,119,3,0,98,119,10,0,
60,111,5,0,98,111,13,0,188,103,9,0,66,103,17,0,156,95,9,0,
66,95,16,0,252,87,11,0,98,223,1,0,98,87,18,0,221,15,32,0,
221,7,32,0,2,80,64,6,255,48,128,7,225,16,6,232,61,231,1,0,
61,223,9,0,128,255,228,11,1,138,74,143,34,0,123,87,5,0,61,135,
20,0,125,87,9,0,2,122,106,231,1,0,65,130,125,135,20,0,106,7,
8,0,106,7,10,0,106,7,13,0,74,7,15,0,74,7,16,0,74,7,
17,0,106,127,18,0,221,15,32,0,221,7,32,0,64,6,255,16,128,7,
225,48,6,232,7,216,8,208,9,224,188,0,128,255,140,11,106,7,32,0,
3,138,74,143,34,0,106,223,1,0,106,239,22,0,106,87,9,0,1,130,
106,135,20,0,106,7,13,0,106,7,17,0,10,232,29,48,26,56,191,255,
252,254,97,226,202,5,29,48,191,255,98,255,42,118,18,0,206,47,0,0,
29,48,129,255,66,90,64,6,255,48,128,7,225,48,6,232,7,216,8,208,
9,224,188,0,128,255,48,11,106,7,32,0,3,138,74,143,34,0,106,223,
1,0,106,239,22,0,106,87,9,0,1,130,106,135,20,0,106,7,13,0,
106,7,17,0,10,232,29,48,26,56,191,255,160,254,97,226,202,5,29,48,
191,255,6,255,42,118,18,0,206,47,0,0,29,48,129,255,80,86,64,6,
255,48,128,7,225,112,6,232,7,216,59,215,1,0,8,224,60,207,9,0,
128,255,208,10,1,130,74,135,34,0,121,87,5,0,60,127,20,0,106,215,
1,0,124,87,9,0,65,122,124,127,20,0,106,7,5,0,59,103,9,0,
106,103,13,0,59,119,18,0,106,7,8,0,106,119,10,0,60,23,22,0,
36,126,148,137,196,18,194,233,194,234,207,233,61,119,2,0,106,119,16,0,
61,111,0,0,106,111,18,0,64,6,255,112,142,7,97,0,7,232,98,50,
227,5,104,50,211,13,107,50,163,21,149,45,61,23,9,0,34,135,26,0,
144,134,0,128,98,135,26,0,197,53,61,23,5,0,34,118,18,0,206,47,
0,0,213,45,99,7,9,0,99,7,13,0,61,111,1,0,99,7,18,0,
99,7,22,0,29,64,99,111,1,0,5,50,3,56,191,255,64,255,61,23,
9,0,34,102,18,0,204,47,0,0,213,21,108,50,170,13,61,23,9,0,
34,95,26,0,139,94,0,128,98,95,26,0,165,13,6,64,38,6,240,15,
133,0,32,62,232,2,128,255,230,9,224,81,78,6,127,0,140,7,225,243,
9,176,54,191,18,0,67,55,3,0,54,223,16,0,7,200,201,186,54,199,
5,0,201,218,181,5,57,207,9,0,185,23,5,0,162,65,188,253,8,232,
8,224,194,225,57,23,1,0,128,233,201,234,201,226,194,225,99,7,5,0,
54,215,1,0,128,255,160,9,106,7,32,0,3,106,74,111,34,0,12,98,
106,103,22,0,106,87,9,0,1,90,106,95,20,0,106,7,13,0,106,7,
17,0,106,215,1,0,10,208,253,185,174,5,23,232,189,185,99,7,9,0,
54,151,1,0,99,151,17,0,58,151,9,0,99,151,21,0,128,255,88,9,
10,16,35,151,17,0,35,143,21,0,2,82,66,87,34,0,98,151,1,0,
113,23,5,0,122,23,9,0,56,87,1,0,27,112,191,114,219,81,56,111,
5,0,98,87,9,0,225,103,0,0,206,97,205,97,98,103,13,0,54,119,
25,0,32,102,0,176,3,87,3,0,193,114,204,113,46,95,0,0,224,81,
98,95,26,0,250,5,98,231,17,0,56,87,9,0,219,81,245,5,56,111,
9,0,28,80,219,105,98,111,17,0,98,87,21,0,56,87,17,0,187,81,
253,81,199,5,221,217,29,80,197,5,24,198,20,0,0,218,35,151,9,0,
10,128,169,130,98,135,24,0,65,146,99,151,9,0,202,225,170,233,224,233,
239,165,35,151,5,0,224,145,202,5,99,215,5,0,213,5,35,143,13,0,
113,215,13,0,58,23,9,0,34,119,26,0,35,143,9,0,142,118,0,128,
98,119,26,0,58,103,20,0,122,7,13,0,209,97,122,103,20,0,57,207,
9,0,99,215,13,0,224,201,226,5,185,239,5,0,57,231,1,0,201,234,
224,185,183,5,191,7,188,254,35,87,5,0,76,6,255,243,128,7,225,112,
6,200,7,208,8,216,59,231,1,0,128,255,70,8,3,138,10,232,125,7,
32,0,125,207,22,0,125,239,9,0,1,130,125,135,20,0,125,7,13,0,
125,7,17,0,59,127,22,0,93,143,34,0,125,231,1,0,29,224,207,110,
3,0,125,111,32,0,108,210,242,13,26,48,27,56,28,64,191,255,34,253,
27,48,28,56,191,255,100,247,26,48,28,56,191,255,128,253,213,13,27,48,
28,56,191,255,82,247,61,23,9,0,34,103,26,0,140,102,0,128,98,103,
26,0,28,80,64,6,255,112,134,7,225,243,6,184,55,207,18,0,7,176,
55,215,16,0,8,216,201,202,55,199,5,0,201,210,181,5,59,223,9,0,
187,23,5,0,162,73,188,253,9,232,9,224,194,225,59,23,1,0,128,233,
201,234,54,151,9,0,201,226,194,225,99,7,5,0,99,151,1,0,253,201,
174,5,25,232,189,201,55,151,1,0,99,151,9,0,128,255,122,7,2,106,
35,151,9,0,35,143,1,0,10,16,66,111,34,0,98,151,1,0,113,23,
5,0,99,23,1,0,118,23,9,0,56,87,1,0,26,112,191,114,218,81,
56,111,5,0,98,87,9,0,225,103,0,0,206,97,205,97,98,103,13,0,
55,87,25,0,32,126,0,176,193,82,207,81,42,119,0,0,98,119,26,0,
56,103,9,0,98,231,21,0,218,97,98,103,17,0,56,87,17,0,186,81,
253,81,199,5,221,209,29,80,197,5,24,198,20,0,0,210,35,151,5,0,
10,120,169,122,98,127,24,0,65,146,99,151,5,0,202,225,170,233,224,233,
191,181,59,223,9,0,224,217,226,5,187,239,5,0,59,231,1,0,201,234,
224,201,207,165,35,151,1,0,54,111,20,0,35,143,5,0,118,151,9,0,
209,105,118,111,20,0,70,6,255,243,128,7,225,240,6,208,7,216,9,200,
35,199,29,0,8,224,60,239,1,0,128,255,162,6,106,7,32,0,106,215,
22,0,106,87,9,0,1,130,106,135,20,0,106,7,13,0,106,7,17,0,
60,127,22,0,3,138,74,143,34,0,27,48,207,110,3,0,106,111,32,0,
28,56,106,239,1,0,10,232,29,64,191,255,132,251,28,48,29,56,25,64,
24,72,191,255,138,254,27,48,29,56,191,255,222,251,29,48,129,255,178,81,
64,6,255,240,128,7,225,48,6,232,7,224,8,216,9,208,128,255,56,6,
106,7,32,0,3,138,74,143,34,0,106,231,1,0,106,239,22,0,106,87,
9,0,1,130,106,135,20,0,106,7,13,0,106,7,17,0,10,232,29,48,
27,56,26,64,191,255,34,247,29,48,129,255,254,84,64,6,255,48,128,7,
225,16,6,232,7,224,8,216,128,255,240,5,106,7,32,0,3,138,74,143,
34,0,106,231,1,0,106,239,22,0,106,87,9,0,1,130,106,135,20,0,
106,7,13,0,106,7,17,0,10,232,29,48,27,56,191,255,208,247,29,48,
129,255,184,84,64,6,255,16,128,7,225,16,6,232,7,224,8,216,128,255,
170,5,106,7,32,0,3,138,74,143,34,0,106,231,1,0,106,239,22,0,
106,87,9,0,1,130,106,135,20,0,106,7,13,0,106,7,17,0,10,232,
29,48,27,56,191,255,92,248,29,48,129,255,114,84,64,6,255,16,128,7,
225,0,6,232,7,224,128,255,102,5,106,7,32,0,3,138,74,143,34,0,
106,231,1,0,106,87,9,0,1,130,106,135,20,0,106,7,13,0,106,7,
17,0,106,239,22,0,10,232,29,48,191,255,72,249,42,126,18,0,207,47,
0,0,29,48,129,255,40,84,64,6,255,0,134,7,33,0,136,0,137,0,
99,71,0,0,99,79,2,0,99,7,5,0,67,7,8,0,32,142,239,0,
67,143,9,0,8,130,99,135,10,0,3,64,0,74,191,255,96,249,70,6,
63,0,134,7,33,0,3,138,99,143,0,0,8,134,64,0,99,135,2,0,
99,7,5,0,67,7,8,0,32,126,239,0,67,127,9,0,8,114,99,119,
10,0,3,64,0,74,191,255,44,249,70,6,63,0,128,7,225,16,6,232,
7,224,8,216,128,255,180,4,106,7,32,0,3,138,74,143,34,0,106,231,
1,0,106,239,22,0,106,87,9,0,1,66,106,71,20,0,106,7,13,0,
106,7,17,0,10,232,29,48,27,56,191,255,188,244,29,48,129,255,230,79,
64,6,255,16,128,7,225,16,6,232,7,224,8,216,128,255,110,4,106,7,
32,0,3,138,74,143,34,0,106,231,1,0,106,239,22,0,106,87,9,0,
1,130,106,135,20,0,106,7,13,0,106,7,17,0,10,232,29,48,27,56,
0,66,191,255,116,244,29,48,129,255,158,79,64,6,255,16,128,7,225,48,
6,232,7,224,8,216,9,208,128,255,36,4,106,7,32,0,3,138,74,143,
34,0,106,231,1,0,106,239,22,0,106,87,9,0,1,130,106,135,20,0,
106,7,13,0,106,7,17,0,10,232,29,48,27,56,26,64,191,255,14,245,
29,48,129,255,84,79,64,6,255,48,128,7,225,48,6,208,9,216,35,239,
21,0,168,0,111,66,155,85,72,0,16,0,25,0,63,0,35,0,71,0,
20,0,67,0,30,0,40,0,49,0,79,0,58,0,75,0,44,0,79,0,
53,0,125,7,25,0,0,18,229,69,9,130,125,135,25,0,5,18,149,69,
9,122,125,127,25,0,1,18,197,61,8,114,125,119,25,0,7,18,245,53,
8,106,125,111,25,0,3,18,165,53,125,7,25,0,8,18,229,45,9,98,
125,103,25,0,13,18,149,45,9,18,125,23,25,0,213,37,8,82,125,87,
25,0,15,18,133,37,8,138,125,143,25,0,11,18,181,29,125,7,25,0,
2,18,245,21,125,7,25,0,6,18,181,21,125,7,25,0,4,18,245,13,
125,7,25,0,12,18,181,13,61,55,1,0,32,134,13,1,31,58,102,135,
12,0,129,255,4,33,229,53,123,23,10,0,97,58,218,5,59,126,10,0,
207,7,1,0,61,231,1,0,128,255,12,3,106,7,32,0,3,114,74,119,
34,0,106,215,22,0,106,87,9,0,1,106,106,111,20,0,106,7,13,0,
106,7,17,0,106,231,1,0,10,224,28,48,27,56,191,255,124,246,61,103,
25,0,224,97,210,5,29,48,28,56,191,255,54,242,28,48,191,255,214,246,
42,94,18,0,203,47,0,0,28,48,129,255,32,78,64,6,255,48,134,7,
33,0,99,7,0,0,99,7,2,0,99,7,5,0,32,142,64,0,67,143,
8,0,32,134,224,0,67,135,9,0,8,122,99,127,10,0,3,64,0,74,
191,255,74,247,70,6,63,0,142,7,225,16,6,216,99,7,9,0,99,7,
13,0,99,7,18,0,7,224,99,231,1,0,128,255,104,2,10,232,125,7,
32,0,221,15,32,0,29,64,5,50,3,56,125,7,17,0,125,7,13,0,
1,122,125,239,9,0,125,223,22,0,125,231,1,0,3,130,93,135,34,0,
125,127,20,0,191,255,82,247,61,23,9,0,29,48,34,118,18,0,206,47,
0,0,129,255,136,77,78,6,255,16,134,7,33,0,99,7,0,0,99,7,
2,0,99,71,5,0,32,142,64,0,67,143,8,0,32,134,112,0,67,135,
9,0,8,122,99,127,10,0,3,64,0,74,191,255,178,246,70,6,63,0,
134,7,33,0,99,7,0,0,99,7,2,0,99,7,5,0,67,7,8,0,
32,142,229,0,67,143,9,0,8,130,99,135,10,0,3,64,1,74,191,255,
132,246,70,6,63,0,134,7,33,0,32,142,216,0,99,143,0,0,99,7,
2,0,99,7,5,0,32,134,79,0,67,135,5,0,32,126,194,0,67,127,
6,0,32,118,160,0,67,119,8,0,32,110,176,0,67,111,9,0,8,98,
99,103,10,0,3,64,0,74,191,255,62,246,70,6,63,0,134,7,33,0,
32,142,218,0,99,143,0,0,99,7,2,0,99,7,5,0,32,134,79,0,
67,135,5,0,32,126,194,0,67,127,6,0,32,118,160,0,67,119,8,0,
32,110,176,0,67,111,9,0,8,98,99,103,10,0,3,64,1,74,191,255,
248,245,70,6,63,0,134,7,33,0,136,0,32,142,255,0,99,143,0,0,
99,71,2,0,40,16,67,23,4,0,67,23,5,0,67,71,6,0,67,7,
7,0,67,7,9,0,67,7,8,0,12,122,99,127,10,0,3,64,0,74,
191,255,186,245,70,6,63,0,128,7,225,0,6,232,7,224,128,255,232,0,
106,7,32,0,3,138,74,143,34,0,106,231,1,0,106,87,9,0,1,130,
106,135,20,0,106,7,13,0,106,7,17,0,106,239,22,0,10,232,29,48,
191,255,202,244,42,126,18,0,207,47,0,0,29,48,129,255,20,76,64,6,
255,0,128,7,225,16,6,232,7,224,8,216,128,255,156,0,106,7,32,0,
3,138,74,143,34,0,106,231,1,0,106,239,22,0,106,87,9,0,1,130,
106,135,20,0,106,7,13,0,106,7,17,0,10,232,29,48,27,56,191,255,
124,242,29,48,129,255,206,75,64,6,255,16,128,7,225,16,6,232,7,224,
8,216,128,255,86,0,106,7,32,0,3,138,74,143,34,0,106,231,1,0,
106,239,22,0,106,87,9,0,1,130,106,135,20,0,106,7,13,0,106,7,
17,0,10,232,29,48,27,56,191,255,8,243,29,48,129,255,136,75,64,6,
255,16,128,7,33,0,191,255,194,247,10,48,129,255,118,75,64,6,63,0,
33,6,200,5,128,0,97,0,128,7,193,0,229,87,64,0,224,7,96,1,
32,143,53,176,32,135,57,176,10,232,17,22,1,0,240,137,238,13,96,23,
53,176,32,231,49,176,60,127,5,0,96,127,49,176,253,47,32,0,28,80,
64,6,223,0,229,87,64,0,224,135,96,1,32,119,57,176,32,111,53,176,
238,105,190,253,253,47,32,0,165,221,128,7,193,0,6,224,229,87,64,0,
224,7,96,1,32,23,57,176,10,232,188,17,2,134,255,255,16,6,0,239,
177,5,96,23,57,176,253,47,32,0,64,6,223,0,128,7,225,0,0,226,
38,239,13,0,129,255,64,180,65,226,29,48,224,233,154,253,28,80,64,6,
255,0,96,7,53,176,42,6,200,121,134,0,96,87,49,176,32,142,0,17,
96,143,57,176,0,18,10,134,36,0,106,135,5,0,16,80,65,18,2,6,
1,239,134,253,127,0,4,143,232,135,224,137,194,21,6,128,193,50,36,142,
20,142,209,49,194,130,36,110,212,141,205,129,48,23,1,0,32,134,0,2,
102,135,0,0,98,135,0,0,226,23,1,0,127,0,4,143,232,135,224,137,
162,21,6,128,194,130,36,110,212,141,205,129,48,23,1,0,193,50,36,142,
20,142,209,49,102,7,0,0,98,7,0,0,226,23,1,0,127,0,38,143,
0,0,32,86,9,2,209,134,192,0,194,5,32,86,1,2,181,85,38,111,
0,0,134,106,249,77,134,23,25,0,194,134,1,0,178,45,131,18,233,69,
166,23,25,0,2,6,240,255,161,13,97,18,242,29,100,18,162,29,101,18,
146,21,108,18,186,61,229,13,2,6,240,255,210,21,2,6,236,255,130,13,
2,6,192,255,242,13,2,6,124,255,226,5,213,45,4,143,232,135,224,137,
146,45,32,86,0,2,229,37,32,86,10,2,181,37,32,86,2,2,133,37,
194,126,112,0,178,21,194,94,112,0,11,6,192,255,130,13,11,6,176,255,
178,21,11,6,144,255,210,5,149,21,32,86,3,2,229,13,32,86,6,2,
181,13,194,134,128,0,194,5,32,86,4,2,213,5,132,18,185,5,32,86,
8,2,127,0,128,7,225,48,6,232,128,255,20,2,194,234,0,218,32,214,
36,17,29,48,191,255,6,255,29,128,194,130,36,110,212,141,205,129,48,231,
1,0,29,96,193,98,36,142,20,142,209,97,236,135,1,0,10,50,144,134,
224,128,124,135,0,0,124,215,2,0,128,255,224,1,29,112,193,114,36,94,
20,142,203,113,238,87,1,0,65,234,65,218,100,218,124,87,0,0,166,221,
64,6,255,48,128,7,225,112,0,234,36,222,212,141,32,230,108,177,36,214,
20,142,165,61,59,87,1,0,10,200,249,23,1,0,194,142,224,0,242,29,
29,48,129,255,170,65,224,81,226,5,29,48,1,58,129,255,214,65,181,37,
25,48,191,255,168,254,29,48,10,64,32,62,66,0,128,255,128,1,10,200,
29,48,1,58,129,255,184,65,224,201,178,21,25,48,128,255,116,1,245,13,
194,126,1,64,15,6,255,191,170,13,250,119,1,0,28,48,142,118,0,128,
106,119,0,0,129,255,178,182,68,218,28,230,32,0,66,210,65,234,36,103,
234,135,236,233,198,197,32,254,36,241,223,191,0,0,64,86,0,0,0,90,
74,95,144,244,32,254,38,241,223,191,0,0,64,86,0,0,0,90,74,95,
144,244,32,254,40,241,223,191,0,0,64,86,0,0,0,90,74,95,144,244,
64,6,255,112,194,50,36,134,212,141,198,129,48,23,1,0,226,87,1,0,
36,110,148,141,103,87,0,0,226,23,7,0,205,49,103,23,2,0,38,23,
1,0,226,87,9,0,103,87,4,0,226,23,11,0,103,23,6,0,127,0,
194,50,36,118,212,141,206,49,38,23,1,0,167,0,224,57,202,29,162,103,
25,0,104,103,0,0,130,95,25,0,104,95,10,0,34,135,26,0,16,80,
138,0,104,87,2,0,168,130,72,135,4,0,34,135,28,0,72,135,5,0,
168,130,72,135,6,0,34,135,30,0,181,29,162,111,17,0,104,111,0,0,
130,103,17,0,104,103,10,0,34,135,18,0,16,88,139,0,104,95,2,0,
168,130,72,135,4,0,34,135,20,0,72,135,5,0,168,130,72,135,6,0,
34,135,22,0,16,112,206,102,15,0,72,103,7,0,208,134,240,0,72,135,
8,0,168,114,72,119,9,0,127,0,199,0,194,50,36,118,212,141,206,49,
193,58,36,86,248,135,202,57,39,143,0,0,38,23,1,0,98,143,4,0,
127,0,33,6,112,12,128,0,97,0,33,6,100,71,130,0,97,0,33,6,
72,56,129,0,97,0,33,6,228,48,129,0,97,0,128,7,33,0,36,158,
84,144,211,207,0,0,162,21,36,158,84,144,211,223,0,0,218,13,128,255,
82,0,224,81,0,82,154,13,36,158,84,144,211,223,0,0,234,87,0,0,
165,5,1,82,64,6,63,0,64,134,137,0,16,135,228,221,1,82,101,130,
194,5,102,130,162,5,0,82,138,0,224,81,210,13,36,158,84,144,211,207,
0,0,1,82,234,5,4,111,124,142,99,106,162,5,0,82,138,0,127,0,
33,6,130,54,128,0,97,0,64,142,16,0,241,49,158,13,6,120,191,122,
150,122,207,49,170,50,37,70,4,130,133,13,6,96,191,98,140,98,204,49,
180,50,37,70,7,130,6,56,37,54,252,129,128,7,158,10,128,7,225,48,
6,216,7,224,188,0,27,232,29,23,6,0,220,86,1,0,193,82,61,215,
9,0,194,22,253,0,10,17,93,23,6,0,221,151,6,0,125,7,9,0,
221,223,6,0,154,13,27,64,38,6,164,39,133,0,32,62,223,5,191,255,
2,251,221,159,6,0,29,48,129,255,200,165,224,81,146,13,29,64,38,6,
164,39,133,0,32,62,228,5,191,255,228,250,26,232,224,233,202,213,64,6,
255,48,128,7,225,16,7,216,6,238,4,0,0,226,181,13,29,48,198,215,
6,0,194,5,1,58,191,255,126,255,29,238,16,0,65,226,251,225,214,245,
64,6,255,16,132,7,225,243,6,176,54,215,5,0,7,216,27,142,255,255,
8,232,250,143,192,2,99,79,5,0,55,6,180,39,133,0,0,226,27,200,
17,22,1,0,97,18,186,37,54,55,1,0,35,71,45,0,3,56,129,255,
254,165,224,81,202,101,35,127,1,0,35,151,5,0,26,224,114,127,1,0,
125,127,1,0,207,223,6,0,79,223,5,0,242,5,23,48,15,64,32,62,
3,5,191,255,74,250,61,23,1,0,194,31,6,0,213,61,125,7,1,0,
0,194,54,55,1,0,35,71,45,0,3,56,129,255,180,165,61,103,1,0,
224,81,178,13,12,48,224,49,194,5,1,58,191,255,216,254,125,7,1,0,
0,226,181,53,35,223,1,0,218,225,224,97,186,5,125,223,1,0,35,151,
5,0,249,209,249,215,60,19,114,223,1,0,219,223,6,0,91,23,5,0,
130,13,61,71,1,0,32,62,59,5,23,48,191,255,220,249,219,31,6,0,
224,193,178,5,120,223,9,0,27,192,186,201,224,201,143,205,224,225,210,13,
61,23,1,0,162,23,5,0,224,17,250,5,23,48,28,64,32,62,79,5,
191,255,172,249,28,80,68,6,255,243,7,6,224,255,135,13,6,54,28,0,
7,6,128,255,183,5,6,54,28,0,97,66,202,5,38,103,5,0,181,5,
38,103,1,0,0,18,2,136,194,138,38,118,8,0,206,137,49,95,1,0,
43,111,5,0,7,86,255,255,237,87,192,2,10,110,1,0,43,87,1,0,
42,87,9,0,234,105,195,5,65,18,236,17,150,237,11,80,127,0,35,103,
1,0,6,86,4,0,0,90,229,21,10,16,98,63,1,0,66,79,4,0,
66,7,5,0,98,7,9,0,97,98,186,5,194,7,6,0,194,15,6,0,
65,90,9,136,10,86,16,0,201,138,209,57,232,89,166,237,127,0,130,7,
97,0,61,6,16,222,136,0,61,63,13,0,61,71,29,0,32,78,16,0,
99,7,1,0,38,6,12,223,136,0,191,255,164,255,61,63,17,0,61,71,
33,0,32,78,128,0,99,7,1,0,38,6,12,223,137,0,191,255,138,255,
38,6,12,223,138,0,61,63,21,0,61,71,37,0,1,114,99,119,1,0,
32,78,16,0,191,255,110,255,38,6,12,255,138,0,61,63,25,0,61,71,
41,0,1,98,99,103,1,0,32,78,128,0,191,255,82,255,66,6,127,0,
128,7,97,0,61,6,16,222,136,0,61,119,5,0,61,23,9,0,61,103,
49,0,32,94,0,2,130,113,137,114,172,113,125,119,45,0,12,80,191,82,
155,82,12,128,202,129,165,130,16,6,0,254,254,5,12,112,191,114,155,114,
12,88,206,89,165,90,61,111,49,0,125,95,37,0,11,96,196,90,171,105,
125,111,49,0,205,98,172,17,125,23,21,0,32,94,0,2,13,112,191,114,
153,114,13,96,206,97,167,98,12,6,0,254,254,5,13,80,191,82,153,82,
13,88,202,89,167,90,125,95,41,0,208,90,61,103,45,0,171,17,125,23,
25,0,32,86,0,16,12,104,191,106,155,106,12,88,205,89,165,90,11,6,
0,240,254,5,12,136,191,138,155,138,12,80,209,81,165,82,61,95,45,0,
125,87,29,0,10,120,196,82,170,89,125,95,45,0,205,122,175,17,125,23,
13,0,32,86,0,16,11,136,191,138,153,138,11,120,209,121,167,122,15,6,
0,240,254,5,11,104,191,106,153,106,11,80,205,81,167,82,125,87,33,0,
208,82,170,17,125,23,17,0,125,23,5,0,38,6,212,39,133,0,128,255,
236,6,61,143,41,0,61,55,37,0,199,138,196,50,209,49,201,50,191,255,
14,252,38,6,196,39,133,0,128,255,206,6,61,87,33,0,61,55,29,0,
199,82,196,50,202,49,201,50,191,255,240,251,221,7,248,0,64,6,127,0,
130,7,225,0,60,6,16,222,136,0,60,143,29,0,61,6,232,39,133,0,
41,6,12,223,136,0,38,6,72,184,255,255,196,138,99,143,1,0,39,6,
248,39,133,0,12,66,128,255,136,6,224,81,242,5,29,48,32,62,182,1,
0,66,191,255,22,247,60,127,37,0,41,6,12,223,138,0,38,6,168,184,
255,255,39,6,12,40,133,0,196,122,99,127,1,0,12,66,128,255,86,6,
224,81,242,5,29,48,32,62,194,1,0,66,191,255,228,246,60,111,33,0,
41,6,12,223,137,0,38,6,120,184,255,255,39,6,36,40,133,0,196,106,
99,111,1,0,12,66,128,255,36,6,224,81,242,5,29,48,32,62,206,1,
0,66,191,255,178,246,60,95,41,0,41,6,12,255,138,0,38,6,216,184,
255,255,39,6,56,40,133,0,196,90,99,95,1,0,12,66,128,255,242,5,
224,81,130,13,29,48,32,62,218,1,0,66,191,255,128,246,224,81,66,6,
255,0,128,7,33,0,128,255,220,5,4,127,96,144,100,87,77,142,224,81,
226,135,0,0,207,126,247,0,208,118,1,0,195,114,10,104,231,111,66,2,
14,121,68,127,96,144,131,106,64,14,137,0,97,111,17,222,64,6,63,0,
128,7,225,112,6,232,29,56,60,6,16,222,136,0,38,6,72,184,255,255,
32,70,48,0,128,255,150,5,29,238,48,0,38,6,120,184,255,255,29,56,
32,70,48,0,128,255,130,5,29,238,48,0,38,6,168,184,255,255,29,56,
32,70,48,0,128,255,110,5,38,6,216,184,255,255,29,238,48,0,29,56,
32,70,48,0,128,255,90,5,59,6,12,223,136,0,27,48,29,238,48,0,
29,56,64,70,1,0,128,255,68,5,58,6,12,223,137,0,26,48,93,238,
1,0,29,56,64,70,1,0,128,255,46,5,57,6,12,223,138,0,25,48,
93,238,1,0,29,56,32,70,0,32,128,255,24,5,29,62,0,32,61,6,
12,255,138,0,29,48,32,70,0,32,128,255,4,5,60,63,29,0,27,48,
191,255,178,250,60,63,37,0,25,48,191,255,168,250,60,63,33,0,26,48,
191,255,158,250,60,63,41,0,29,48,191,255,148,250,42,6,192,64,2,0,
64,6,255,112,128,7,97,0,6,232,39,6,72,184,255,255,32,70,48,0,
128,255,190,4,29,238,48,0,29,48,39,6,120,184,255,255,32,70,48,0,
128,255,170,4,29,238,48,0,29,48,39,6,168,184,255,255,32,70,48,0,
128,255,150,4,29,238,48,0,29,48,39,6,216,184,255,255,32,70,48,0,
128,255,130,4,29,238,48,0,29,48,39,6,12,223,136,0,64,70,1,0,
128,255,110,4,93,238,1,0,29,48,39,6,12,223,137,0,64,70,1,0,
128,255,90,4,93,238,1,0,29,48,39,6,12,223,138,0,32,70,0,32,
128,255,70,4,29,54,0,32,39,6,12,255,138,0,32,70,0,32,128,255,
52,4,42,6,192,64,2,0,64,6,127,0,0,82,224,73,183,45,181,5,
38,55,9,0,134,95,5,0,171,57,188,253,7,16,203,57,38,95,1,0,
201,58,128,17,203,57,162,73,172,5,201,17,104,63,9,0,104,63,13,0,
2,128,201,130,104,7,1,0,104,7,5,0,38,55,9,0,104,135,17,0,
8,70,20,0,65,82,224,49,210,5,38,63,1,0,134,23,5,0,224,73,
223,229,127,0,132,7,225,16,6,232,7,224,8,216,29,56,38,6,32,41,
133,0,1,66,191,255,162,250,10,48,29,56,28,64,99,223,1,0,35,78,
4,0,191,255,134,249,68,6,255,16,130,7,225,48,9,232,61,143,1,0,
6,224,7,216,8,208,17,6,127,255,217,5,209,134,127,0,125,135,1,0,
61,63,1,0,38,6,32,41,133,0,0,66,220,57,191,255,92,250,42,23,
5,0,10,48,61,63,1,0,27,64,95,18,26,72,66,57,125,63,1,0,
220,57,99,7,1,0,191,255,50,249,66,6,255,48,130,7,225,16,6,232,
7,224,8,216,29,56,38,6,116,41,133,0,0,66,191,255,32,250,10,48,
29,56,28,64,27,72,31,122,99,127,1,0,191,255,4,249,66,6,255,16,
130,7,225,16,196,223,96,144,6,224,178,5,31,82,197,109,61,6,16,222,
136,0,61,223,245,0,65,218,27,6,240,255,198,5,32,86,18,1,133,101,
221,199,248,0,178,37,28,6,128,255,199,5,32,86,17,1,245,85,3,56,
31,66,28,6,240,255,191,13,38,6,72,184,255,255,129,255,230,158,224,81,
186,13,32,86,16,0,229,45,38,6,120,184,255,255,129,255,210,158,224,81,
194,5,32,86,16,1,229,61,32,86,128,0,149,37,61,127,45,0,61,135,
49,0,207,129,16,118,0,252,238,225,195,5,32,86,20,1,245,45,61,111,
5,0,28,96,201,98,61,135,9,0,99,111,1,0,204,105,61,103,49,0,
125,111,5,0,173,129,137,130,172,129,125,135,45,0,28,80,138,0,27,16,
236,23,64,2,61,102,52,0,2,88,204,89,75,87,5,0,35,95,1,0,
2,80,204,81,1,130,106,95,1,0,2,80,204,17,98,135,8,0,125,223,
245,0,204,81,74,231,4,0,11,80,66,6,255,16,128,7,33,0,191,255,
38,250,191,255,168,249,191,255,94,251,64,6,63,0,128,7,97,0,6,232,
29,56,38,6,96,40,133,0,128,255,246,1,61,63,1,0,38,6,112,40,
133,0,128,255,232,1,157,63,5,0,38,6,132,40,133,0,128,255,218,1,
189,63,5,0,38,6,152,40,133,0,128,255,204,1,221,199,6,0,37,62,
20,130,178,5,37,62,12,130,38,6,80,40,133,0,128,255,180,1,64,6,
127,0,128,7,225,243,7,200,35,23,37,0,8,176,9,192,6,230,4,0,
97,18,226,191,0,0,0,210,133,61,28,232,61,23,1,0,0,218,249,17,
242,5,1,218,38,6,172,40,133,0,128,255,124,1,157,23,5,0,248,17,
242,5,1,218,38,6,192,40,133,0,128,255,104,1,29,23,6,0,194,22,
1,0,247,17,242,5,1,218,38,6,212,40,133,0,128,255,80,1,189,23,
5,0,248,17,247,5,38,6,232,40,133,0,128,255,62,1,181,5,224,217,
194,5,29,48,191,255,46,255,28,230,16,0,24,128,201,130,208,201,65,210,
246,209,134,205,64,6,255,243,130,7,97,0,61,6,16,222,136,0,61,63,
13,0,61,71,29,0,32,78,16,0,99,7,1,0,38,6,12,223,136,0,
191,255,78,255,61,63,17,0,61,71,33,0,32,78,128,0,99,7,1,0,
38,6,12,223,137,0,191,255,52,255,38,6,12,223,138,0,61,63,21,0,
61,71,37,0,1,114,99,119,1,0,32,78,16,0,191,255,24,255,38,6,
12,255,138,0,61,63,25,0,61,71,41,0,1,98,99,103,1,0,32,78,
128,0,191,255,252,254,66,6,127,0,128,7,33,0,38,6,0,41,133,0,
128,255,150,0,64,54,137,0,38,55,17,222,191,255,192,245,64,86,137,0,
42,87,17,222,64,6,63,0,128,7,97,0,61,6,16,222,136,0,191,255,
160,250,191,255,204,255,125,7,5,0,61,143,1,0,125,7,13,0,125,7,
17,0,125,7,21,0,125,143,9,0,125,7,25,0,125,7,29,0,125,7,
33,0,125,7,37,0,125,7,41,0,61,23,1,0,224,17,146,29,32,118,
0,2,139,18,47,6,0,32,1,0,239,17,239,23,50,19,2,6,255,253,
238,23,50,19,125,23,49,0,137,138,162,137,125,143,45,0,31,122,125,127,
245,0,221,135,248,0,64,6,127,0,33,6,6,187,130,0,97,0,33,6,
168,124,130,0,97,0,33,6,44,68,130,0,97,0,33,6,136,0,128,0,
97,0,128,7,97,0,6,232,29,56,38,6,48,31,139,0,32,70,128,4,
191,255,230,255,29,62,128,4,36,54,80,142,4,66,191,255,216,255,32,86,
132,4,64,6,127,0,128,7,97,0,6,232,39,6,48,31,139,0,32,70,
128,4,191,255,188,255,29,54,128,4,36,62,80,142,4,66,191,255,174,255,
32,86,132,4,64,6,127,0,128,7,97,0,6,232,197,5,1,50,128,255,
72,22,29,135,22,0,101,130,178,5,224,129,138,253,64,6,127,0,130,7,
33,0,99,55,1,0,3,56,32,54,108,180,0,66,128,255,44,22,224,81,
162,13,38,6,76,42,133,0,32,62,14,13,0,66,191,255,238,239,224,81,
66,6,63,0,128,7,97,0,6,248,127,63,5,0,229,87,64,0,224,7,
96,1,63,135,20,0,10,232,3,138,95,143,22,0,224,129,202,5,31,48,
191,255,174,255,253,47,32,0,64,6,127,0,128,7,225,243,7,208,218,247,
54,0,6,200,154,13,38,6,92,42,133,0,32,62,5,6,0,66,191,255,
154,239,229,87,64,0,224,7,96,1,58,239,29,0,253,255,13,0,10,192,
128,249,229,87,64,0,224,7,96,1,32,127,65,176,10,224,223,121,96,127,
65,176,252,47,32,0,189,119,15,0,29,48,1,58,206,118,244,0,93,119,
15,0,128,255,78,41,29,48,128,255,206,40,58,183,1,0,249,239,125,0,
58,63,5,0,22,48,29,64,128,255,114,21,249,103,127,0,10,224,250,87,
9,0,28,112,86,97,32,110,1,1,10,222,255,255,204,217,253,223,128,0,
220,217,237,119,194,234,245,13,29,48,194,50,57,134,132,0,208,49,26,56,
128,255,110,25,65,226,65,234,29,6,255,254,170,5,0,234,251,225,147,245,
26,48,129,255,100,63,24,248,255,47,32,0,64,6,255,243,128,7,225,0,
6,232,229,87,64,0,224,7,96,1,29,71,22,0,10,224,97,66,162,13,
101,66,130,13,38,6,108,42,133,0,32,62,248,10,191,255,194,238,36,119,
81,142,93,7,22,0,100,239,81,142,125,119,1,0,252,47,32,0,64,6,
255,0,142,7,225,16,6,232,61,135,20,0,224,129,146,13,38,6,124,42,
133,0,32,62,84,13,0,66,191,255,140,238,29,127,22,0,99,122,250,69,
196,207,84,144,194,69,1,106,125,111,20,0,4,98,93,103,22,0,99,7,
9,0,99,7,13,0,99,7,18,0,129,255,116,9,10,112,110,7,9,0,
32,94,232,3,110,95,21,0,32,86,16,0,110,87,2,0,48,6,8,44,
1,0,110,135,5,0,47,6,176,35,139,0,110,127,29,0,110,239,33,0,
61,87,5,0,206,55,3,0,32,110,136,0,42,23,105,0,63,6,192,40,
0,0,99,111,22,0,2,22,192,0,34,55,0,0,34,103,5,0,3,56,
99,119,1,0,202,49,108,0,35,55,1,0,10,56,129,255,224,11,165,61,
229,87,64,0,224,7,96,1,10,216,61,87,5,0,224,81,242,13,42,23,
105,0,2,22,128,0,34,55,0,0,34,95,5,0,0,58,63,6,250,40,
0,0,202,49,107,0,61,87,1,0,224,81,226,21,149,21,224,225,130,13,
61,231,9,0,61,54,8,0,28,56,129,255,114,62,61,55,1,0,220,55,
54,0,28,56,191,255,236,253,61,231,16,0,224,225,223,237,5,114,93,119,
22,0,29,48,191,255,164,254,27,248,255,47,32,0,78,6,255,16,128,7,
225,0,6,232,7,248,229,87,64,0,224,7,96,1,10,224,2,138,93,143,
22,0,61,54,8,0,31,56,129,255,136,62,61,135,20,0,65,130,125,135,
20,0,252,47,32,0,64,6,255,0,128,7,97,0,6,248,229,87,64,0,
224,7,96,1,63,143,20,0,10,232,95,138,127,143,20,0,241,0,224,137,
170,13,31,119,22,0,99,114,178,5,100,114,202,5,31,48,191,255,10,253,
253,47,32,0,64,6,127,0,128,7,225,16,6,216,229,87,64,0,224,7,
96,1,36,239,81,142,10,224,224,233,226,13,61,143,1,0,61,54,8,0,
100,143,81,142,129,255,118,62,125,223,1,0,1,130,93,135,22,0,252,47,
32,0,29,80,64,6,255,16,128,7,97,0,6,232,38,6,180,42,133,0,
191,255,34,252,29,63,2,0,38,6,140,42,133,0,221,58,159,58,191,255,
16,252,221,215,2,0,138,13,160,63,171,176,38,6,152,42,133,0,191,255,
252,251,29,127,2,0,37,54,28,130,207,62,1,0,191,255,236,251,64,6,
127,0,128,7,225,16,7,16,34,63,5,0,6,216,34,55,1,0,251,87,
121,0,224,57,130,13,10,64,0,74,128,255,168,18,10,48,11,56,197,5,
234,55,194,2,0,58,251,103,121,0,6,70,1,0,225,95,0,0,8,80,
12,16,234,23,34,10,199,89,236,95,32,2,1,80,202,89,8,80,236,87,
32,2,64,6,255,16,128,7,225,48,32,231,121,176,32,134,1,1,6,216,
7,208,28,136,240,143,194,234,64,7,136,176,96,7,133,176,197,29,96,239,
129,176,29,48,194,50,59,102,132,0,204,49,26,56,128,255,148,18,10,136,
0,87,136,176,234,137,183,5,64,143,136,176,100,138,186,5,1,82,197,13,
65,226,65,234,29,6,255,254,170,5,0,234,32,135,125,176,240,225,163,229,
0,82,64,6,255,48,128,7,225,16,7,216,251,239,9,0,59,231,29,0,
213,5,191,255,22,240,224,81,250,5,252,143,11,0,29,128,240,0,240,137,
250,245,123,239,32,0,64,6,255,16,144,7,225,243,6,200,67,63,7,0,
217,215,2,0,210,13,167,0,99,58,218,13,32,127,165,176,57,119,25,0,
36,111,245,178,206,121,239,105,203,5,0,82,128,7,78,5,1,98,99,103,
9,0,31,50,128,255,228,55,57,55,105,0,224,49,186,13,25,48,191,255,
82,254,99,87,25,0,224,81,162,253,121,87,105,0,181,5,99,55,25,0,
36,151,245,178,0,186,99,151,21,0,185,151,3,0,0,178,185,87,21,0,
3,135,7,0,218,146,159,146,67,151,3,0,224,81,234,151,0,0,67,151,
4,0,98,130,226,151,0,0,67,151,5,0,229,87,64,0,224,7,96,1,
163,127,3,0,10,216,224,121,210,13,224,185,210,5,23,192,121,7,117,0,
165,21,57,54,40,0,128,255,206,237,10,192,197,13,57,199,100,0,224,193,
130,13,57,199,93,0,57,54,92,0,24,56,129,255,160,59,121,199,113,0,
27,248,255,47,32,0,224,193,186,5,128,7,200,3,216,247,54,0,162,13,
25,48,24,56,191,255,234,254,25,48,24,56,191,255,0,251,197,205,163,111,
3,0,224,105,186,5,128,7,220,2,25,48,24,56,191,255,20,254,10,224,
11,232,229,87,64,0,224,7,96,1,10,216,57,54,40,0,128,255,96,237,
10,184,121,191,117,0,224,185,218,37,163,103,5,0,224,97,210,29,56,135,
13,0,36,87,245,178,176,81,10,6,206,255,209,21,224,177,186,13,216,255,
54,0,138,13,56,87,1,0,249,119,121,0,156,81,238,81,154,13,57,54,
92,0,24,56,129,255,108,59,0,194,121,7,113,0,251,47,32,0,128,7,
100,2,251,47,32,0,215,247,54,0,162,13,25,48,24,56,191,255,82,254,
25,48,23,56,191,255,104,250,149,197,248,23,9,0,56,55,1,0,56,63,
5,0,55,215,1,0,2,64,55,223,5,0,198,65,225,127,0,0,199,121,
239,217,178,5,128,7,188,1,232,209,178,5,128,7,180,1,247,119,9,0,
249,103,129,0,194,113,55,87,29,0,236,113,183,5,128,7,4,2,138,95,
15,0,224,89,178,5,128,7,248,1,28,216,186,217,249,23,121,0,229,5,
194,225,225,79,0,0,201,233,194,217,224,217,166,253,224,217,186,5,128,7,
216,1,25,48,24,56,191,255,208,253,25,48,23,56,191,255,200,253,229,87,
64,0,224,7,96,1,247,23,9,0,99,87,17,0,248,119,9,0,56,255,
29,0,251,17,226,151,0,0,67,151,6,0,194,113,120,119,8,0,55,223,
29,0,229,87,64,0,224,7,96,1,255,95,9,0,251,111,9,0,10,208,
205,89,127,95,8,0,251,87,11,0,255,127,11,0,63,95,21,0,202,121,
59,87,17,0,127,127,10,0,251,119,13,0,255,103,13,0,107,87,9,0,
59,135,21,0,206,97,127,103,12,0,127,135,21,0,250,47,32,0,55,223,
29,0,247,87,33,0,248,23,33,0,187,127,15,0,0,58,202,17,120,23,
32,0,27,48,207,126,244,0,91,127,15,0,128,255,240,34,27,48,128,255,
112,34,249,71,125,0,55,215,1,0,55,223,5,0,1,98,99,71,29,0,
26,48,172,49,225,63,0,0,155,57,128,255,8,15,35,71,29,0,99,87,
13,0,26,48,27,56,128,255,248,14,249,111,127,0,35,143,29,0,247,95,
9,0,10,176,90,105,22,120,11,214,255,255,205,209,241,215,128,0,214,209,
32,118,1,1,238,127,194,218,165,29,35,143,13,0,23,56,27,48,194,50,
241,177,131,13,57,86,132,0,202,49,24,64,128,255,54,18,229,5,57,110,
132,0,205,49,128,255,218,18,65,178,65,218,27,6,255,254,170,5,0,218,
250,177,227,229,23,48,129,255,208,56,131,103,7,0,1,178,0,186,121,7,
117,0,224,97,226,5,35,255,17,0,255,47,32,0,165,61,35,255,17,0,
255,47,32,0,191,7,166,253,163,95,5,0,224,89,130,53,56,127,13,0,
36,135,245,178,175,129,16,6,206,255,129,45,224,177,170,13,216,255,54,0,
250,5,249,111,121,0,28,64,166,65,237,65,218,29,229,87,64,0,224,7,
96,1,10,216,57,54,92,0,24,56,129,255,34,57,23,192,121,199,113,0,
121,7,117,0,25,48,24,56,0,186,191,255,92,251,10,224,11,232,0,178,
27,248,255,47,32,0,191,7,64,253,224,193,186,5,191,7,182,252,25,48,
24,56,191,255,244,251,1,146,67,151,4,0,229,87,64,0,224,7,96,1,
35,55,25,0,24,56,10,216,191,255,46,250,121,7,113,0,27,248,255,47,
32,0,129,255,176,2,10,16,98,7,9,0,32,102,232,3,98,103,21,0,
32,94,16,0,98,95,2,0,35,151,25,0,42,6,8,44,1,0,98,87,
5,0,98,199,29,0,98,151,33,0,120,23,45,0,0,130,224,185,146,21,
55,95,5,0,55,87,1,0,253,89,225,23,0,0,253,89,226,135,0,0,
252,81,225,87,0,0,74,129,2,129,144,0,0,66,224,129,178,5,32,70,
32,0,248,127,9,0,249,119,129,0,8,216,238,121,147,13,38,6,216,42,
133,0,32,62,57,9,0,66,191,255,32,231,56,63,45,0,27,64,24,48,
128,255,160,43,56,55,45,0,1,58,129,255,240,4,191,7,238,251,163,111,
3,0,224,105,226,29,229,87,64,0,224,7,96,1,10,224,245,5,199,63,
54,0,57,54,40,0,128,255,86,234,57,239,100,0,224,233,130,13,57,239,
93,0,57,54,92,0,29,56,129,255,148,55,29,56,224,57,218,237,28,248,
255,47,32,0,131,95,5,0,224,89,194,53,35,151,21,0,185,87,21,0,
153,127,23,0,121,151,25,0,10,128,65,82,89,87,21,0,144,0,239,129,
210,5,3,119,7,0,98,114,242,37,35,71,25,0,40,71,1,0,249,65,
130,13,38,6,216,42,133,0,32,62,108,9,191,255,124,230,57,63,109,0,
35,55,25,0,191,255,140,246,3,103,7,0,98,98,210,5,35,55,25,0,
191,255,48,246,121,7,105,0,89,7,21,0,245,5,57,55,105,0,191,255,
102,247,121,7,105,0,35,95,9,0,131,239,5,0,224,89,210,5,99,7,
9,0,128,255,166,50,29,80,138,0,80,6,255,243,128,7,225,0,6,232,
7,224,245,5,128,255,252,41,29,48,4,58,191,255,114,250,29,48,28,56,
191,255,218,249,224,81,218,245,64,6,255,0,134,7,225,16,6,224,7,232,
61,223,45,0,129,255,10,1,32,134,16,0,47,6,110,43,1,0,106,223,
9,0,106,135,2,0,106,127,5,0,1,114,106,119,0,0,106,239,29,0,
221,7,55,0,96,87,185,176,99,7,9,0,32,150,160,176,210,207,0,0,
194,13,35,54,8,0,128,255,152,28,35,63,9,0,60,54,28,0,128,255,
240,11,149,21,32,111,141,176,128,103,159,176,99,111,9,0,224,97,154,13,
45,54,12,0,32,62,72,176,128,255,234,18,96,87,153,176,35,87,9,0,
224,81,154,13,38,6,232,42,133,0,32,62,25,4,0,66,191,255,116,229,
253,135,9,0,32,71,73,176,32,79,77,176,35,63,9,0,99,135,1,0,
32,127,153,176,60,54,28,0,99,127,5,0,128,255,178,19,202,7,15,0,
125,87,29,0,0,82,70,6,255,16,136,7,225,48,32,231,145,176,6,208,
224,135,157,176,0,18,60,231,9,0,7,232,98,130,154,13,32,23,149,176,
34,23,9,0,2,23,15,0,194,22,1,0,2,216,229,87,64,0,224,7,
96,1,220,199,15,0,10,248,178,5,128,7,76,1,224,217,178,5,128,7,
68,1,255,47,32,0,253,63,9,0,28,48,35,70,8,0,35,78,12,0,
128,255,142,29,35,23,9,0,192,7,160,176,224,17,182,21,35,111,13,0,
224,105,255,13,221,31,54,0,253,87,9,0,125,231,21,0,125,23,26,0,
125,7,32,0,125,87,24,0,128,7,18,1,221,23,54,0,224,17,182,21,
253,87,9,0,35,95,13,0,125,231,21,0,125,23,26,0,171,81,125,87,
24,0,224,17,230,5,224,103,157,176,98,98,250,37,245,5,32,142,156,176,
241,95,1,0,98,90,234,13,32,231,149,176,253,63,9,0,60,231,9,0,
35,70,8,0,35,78,12,0,28,48,128,255,12,29,35,23,13,0,253,87,
9,0,138,17,125,23,40,0,85,17,138,17,253,87,25,0,125,7,42,0,
125,231,37,0,170,17,99,23,13,0,35,23,13,0,224,17,202,5,125,23,
32,0,229,69,61,231,45,0,128,255,58,255,32,134,16,0,47,6,110,43,
1,0,106,231,9,0,106,135,2,0,106,127,5,0,1,114,106,119,0,0,
106,239,29,0,221,7,55,0,96,87,185,176,253,71,25,0,61,87,1,0,
35,111,13,0,61,95,5,0,32,63,141,176,202,65,99,111,1,0,32,103,
153,176,225,79,0,0,203,73,58,54,28,0,99,103,5,0,128,255,50,18,
35,23,13,0,202,7,15,0,125,87,29,0,125,7,34,0,125,23,32,0,
181,13,255,47,32,0,38,6,248,42,133,0,32,62,222,3,1,66,191,255,
166,227,72,6,255,48,128,7,225,0,6,232,7,224,61,54,28,0,128,255,
136,18,224,81,178,5,1,82,245,29,61,54,28,0,28,56,128,255,200,24,
224,81,178,21,32,63,141,176,0,66,61,54,28,0,128,255,248,19,224,143,
157,176,224,137,130,13,29,48,28,56,191,255,32,254,220,7,55,0,213,5,
29,48,28,56,191,255,76,253,0,82,64,6,255,0,128,7,97,0,6,232,
221,199,2,0,234,13,61,54,28,0,128,255,126,24,224,81,130,13,32,63,
141,176,1,66,61,54,28,0,128,255,174,19,64,6,127,0,138,7,225,243,
6,176,99,63,17,0,67,71,3,0,55,6,60,42,133,0,181,13,128,255,
226,38,35,55,17,0,38,55,49,0,134,55,27,0,129,255,210,119,32,223,
77,176,32,215,73,176,224,207,81,176,163,231,3,0,128,255,234,28,10,232,
224,233,210,117,246,119,127,0,26,104,0,18,78,105,99,111,13,0,224,225,
130,13,246,95,123,0,14,80,89,81,14,16,170,89,75,17,2,192,224,225,
194,13,35,71,13,0,224,65,226,5,23,48,32,62,255,4,191,255,164,226,
99,199,13,0,25,48,35,62,4,0,35,70,8,0,35,78,12,0,191,255,
100,238,10,192,224,193,247,69,229,87,64,0,224,7,96,1,32,111,65,176,
10,248,216,105,96,111,65,176,255,47,32,0,224,225,162,37,246,95,123,0,
35,71,13,0,235,65,225,5,23,48,32,62,19,5,191,255,86,226,35,87,
9,0,35,95,13,0,170,23,5,0,171,17,74,23,5,0,138,87,5,0,
130,0,234,17,243,5,23,48,32,62,22,5,0,66,191,255,46,226,99,7,
13,0,125,215,1,0,125,223,5,0,35,135,5,0,125,207,8,0,35,127,
9,0,125,7,10,0,35,119,13,0,125,199,12,0,125,127,21,0,125,135,
17,0,93,119,14,0,213,5,29,48,128,255,112,27,0,234,224,233,186,5,
191,7,230,254,35,143,17,0,113,239,29,0,35,143,17,0,224,23,81,176,
113,23,32,0,74,6,255,243,128,7,33,0,6,80,42,22,20,0,170,17,
2,48,202,49,194,57,32,70,136,4,162,65,191,255,42,241,32,86,136,4,
64,6,63,0,128,7,97,0,6,232,61,55,105,0,224,49,226,13,61,63,
109,0,191,255,182,241,61,55,105,0,191,255,98,241,125,7,105,0,93,7,
21,0,1,138,17,80,138,0,64,6,127,0,134,7,225,112,7,224,60,23,
21,0,130,87,5,0,162,95,5,0,8,208,6,232,171,81,250,81,153,77,
99,7,9,0,26,216,170,217,130,207,5,0,197,21,128,255,46,37,61,55,
105,0,6,80,224,81,194,69,61,63,109,0,191,255,92,241,61,55,105,0,
191,255,8,241,125,7,105,0,93,7,21,0,27,48,3,56,35,70,4,0,
35,78,8,0,191,255,246,236,10,248,224,249,178,229,229,87,64,0,224,7,
96,1,32,143,65,176,10,232,223,137,96,143,65,176,253,47,32,0,252,135,
9,0,252,119,13,0,60,23,21,0,35,103,1,0,218,129,124,135,8,0,
223,113,35,95,5,0,124,119,12,0,66,207,5,0,98,103,9,0,124,95,
21,0,149,13,252,87,9,0,218,89,66,95,5,0,218,81,124,87,8,0,
26,80,70,6,255,112,128,7,225,240,36,150,84,144,210,207,0,0,7,216,
6,208,162,13,32,254,30,241,223,55,0,0,64,86,0,0,0,90,74,95,
144,244,0,23,136,176,57,6,8,43,133,0,97,18,178,5,128,7,2,1,
250,239,127,0,32,23,73,176,66,233,250,5,25,48,32,62,111,6,0,66,
191,255,112,224,250,127,123,0,224,119,81,176,32,111,133,176,189,121,238,121,
238,127,50,235,224,105,250,5,25,48,32,62,117,6,0,66,191,255,76,224,
32,231,133,176,60,231,29,0,220,199,15,0,130,13,188,71,15,0,32,62,
121,6,25,48,191,255,48,224,252,199,9,0,250,135,131,0,24,80,221,81,
240,81,177,5,128,7,54,1,26,48,28,56,29,64,191,255,150,254,224,81,
187,5,128,7,36,1,123,231,21,0,123,239,24,0,123,199,26,0,32,127,
133,176,239,119,9,0,221,113,111,119,8,0,224,111,81,176,253,105,186,21,
36,150,84,144,210,207,0,0,186,5,128,7,252,1,32,254,30,241,223,183,
0,0,64,86,0,0,0,90,74,95,144,244,128,7,230,1,32,87,73,176,
32,103,77,176,221,81,225,23,0,0,204,17,96,87,73,176,96,23,77,176,
224,103,81,176,189,97,96,103,80,176,123,87,1,0,123,23,5,0,123,103,
8,0,32,87,121,176,65,82,96,87,121,176,149,85,99,18,250,77,32,127,
133,176,224,121,250,5,25,48,32,62,173,6,0,66,191,255,114,223,32,239,
133,176,61,239,29,0,221,199,15,0,130,13,189,71,15,0,32,62,176,6,
25,48,191,255,86,223,32,103,73,176,61,231,1,0,253,111,9,0,140,225,
237,225,243,5,25,48,32,62,181,6,0,66,191,255,56,223,251,23,9,0,
123,239,21,0,123,231,26,0,123,23,24,0,229,87,64,0,224,7,96,1,
224,103,81,176,10,224,253,87,11,0,36,150,84,144,172,81,125,87,10,0,
210,207,0,0,162,13,32,254,30,241,223,183,0,0,64,86,0,0,0,90,
74,95,144,244,28,248,255,47,32,0,128,7,12,1,26,48,27,56,0,66,
191,255,196,251,59,23,21,0,59,71,29,0,232,17,234,5,25,48,32,62,
215,6,191,255,202,222,27,232,149,13,128,255,158,34,61,55,49,0,134,55,
27,0,129,255,146,115,29,48,0,58,128,255,20,10,10,56,224,57,162,245,
7,248,229,87,64,0,224,7,96,1,32,55,129,176,10,200,58,86,132,0,
31,56,194,50,202,49,128,255,114,9,25,248,255,47,32,0,32,231,121,176,
229,45,28,120,32,118,1,1,238,127,194,130,27,232,96,135,129,176,149,13,
128,255,68,34,61,55,49,0,134,55,27,0,129,255,56,115,29,48,0,58,
128,255,186,9,10,56,224,57,162,245,7,248,229,87,64,0,224,7,96,1,
32,55,129,176,10,232,58,126,132,0,31,56,194,50,207,49,128,255,24,9,
29,248,255,47,32,0,65,226,253,47,32,0,32,119,125,176,238,225,129,213,
218,239,3,0,27,56,226,5,58,54,40,0,128,255,124,225,213,5,58,54,
92,0,129,255,42,47,36,150,84,144,210,207,0,0,162,13,32,254,30,241,
223,183,0,0,64,86,0,0,0,90,74,95,144,244,249,47,32,0,64,6,
255,240,128,7,97,0,6,232,221,239,3,0,226,5,61,54,40,0,128,255,
194,223,181,5,61,87,100,0,189,143,23,0,241,81,215,5,29,48,2,58,
191,255,14,242,64,6,127,0,128,7,225,0,7,224,60,87,1,0,60,95,
5,0,96,87,73,176,96,95,77,176,252,135,9,0,6,232,96,135,80,176,
220,207,52,0,146,61,32,87,73,176,32,95,77,176,224,103,81,176,1,130,
10,112,11,120,202,97,225,111,0,0,203,105,176,97,225,23,0,0,143,114,
209,122,14,121,32,142,108,176,113,103,1,0,141,17,113,23,5,0,72,138,
113,127,1,0,11,104,61,95,9,0,10,96,61,87,5,0,235,105,218,5,
234,97,186,5,192,39,160,176,32,142,108,176,49,103,1,0,49,111,5,0,
12,86,1,0,125,87,5,0,225,23,0,0,205,17,125,23,9,0,32,63,
77,176,32,55,73,176,253,71,125,0,128,255,60,3,96,87,121,176,32,95,
73,176,253,23,127,0,224,127,81,176,253,103,125,0,75,17,15,118,255,255,
206,17,236,23,128,0,202,17,96,23,125,176,221,215,2,0,210,5,29,48,
28,56,191,255,172,246,221,199,2,0,178,5,128,7,110,1,220,223,11,0,
178,5,128,7,100,1,29,23,16,0,224,17,138,61,60,95,5,0,61,111,
9,0,61,103,5,0,60,23,1,0,237,89,218,21,236,17,186,21,189,111,
19,0,65,106,93,111,19,0,205,102,255,0,106,98,187,5,128,7,38,1,
3,90,93,95,16,0,93,7,19,0,128,7,24,1,32,135,117,176,61,87,
13,0,234,129,178,5,128,7,8,1,157,127,19,0,65,122,93,127,18,0,
207,118,255,0,99,114,163,125,1,106,93,111,16,0,93,7,18,0,93,7,
17,0,165,117,97,18,234,45,61,95,13,0,32,23,117,176,235,17,234,5,
29,48,28,56,191,255,150,248,149,109,125,23,13,0,32,63,117,176,61,54,
28,0,128,255,86,18,224,81,130,13,29,48,28,56,191,255,120,248,93,7,
17,0,133,93,189,135,17,0,2,82,93,87,16,0,65,130,93,135,17,0,
208,126,255,0,106,122,195,77,93,7,16,0,93,7,18,0,245,69,98,18,
218,69,61,111,13,0,32,63,117,176,237,57,170,29,157,103,19,0,65,98,
93,103,18,0,204,94,255,0,99,90,227,53,1,82,93,87,16,0,93,7,
18,0,93,7,17,0,61,54,28,0,128,255,194,17,29,48,28,56,191,255,
16,248,229,37,61,54,28,0,128,255,216,17,224,81,178,13,29,48,28,56,
191,255,250,247,93,7,17,0,1,130,93,135,16,0,229,21,189,127,17,0,
65,122,93,127,17,0,207,118,255,0,106,114,147,13,93,7,16,0,93,7,
18,0,61,54,28,0,128,255,118,17,32,111,117,176,125,111,13,0,1,82,
64,6,255,0,128,7,225,0,7,232,61,87,1,0,61,95,5,0,96,87,
73,176,96,95,77,176,253,135,9,0,6,224,96,135,80,176,221,207,52,0,
146,61,32,87,73,176,32,95,77,176,224,103,81,176,1,130,10,112,11,120,
202,97,225,111,0,0,203,105,176,97,225,23,0,0,143,114,209,122,14,121,
32,142,108,176,113,103,1,0,141,17,113,23,5,0,72,138,113,127,1,0,
11,104,60,95,9,0,10,96,60,87,5,0,235,105,218,5,234,97,186,5,
192,39,160,176,32,142,108,176,49,103,1,0,49,111,5,0,12,86,1,0,
124,87,5,0,225,23,0,0,205,17,124,23,9,0,32,63,77,176,32,55,
73,176,252,71,125,0,128,255,232,0,96,87,121,176,252,23,127,0,32,95,
73,176,252,103,125,0,224,127,81,176,28,48,75,17,29,56,15,118,255,255,
206,17,236,23,128,0,202,17,96,23,125,176,191,255,66,247,221,7,55,0,
221,135,54,0,220,215,2,0,210,5,191,255,148,222,224,81,138,29,28,48,
29,56,0,66,191,255,76,247,221,7,54,0,220,215,2,0,170,13,160,119,
171,176,224,113,226,5,221,223,11,0,186,5,221,135,54,0,221,31,11,0,
0,82,133,53,28,48,29,56,191,255,18,244,128,111,171,176,224,105,194,5,
221,159,11,0,149,29,221,223,11,0,226,21,0,95,136,176,99,90,178,5,
98,90,250,5,128,255,244,29,28,48,4,58,191,255,106,238,221,7,54,0,
0,66,29,56,28,48,191,255,230,246,0,82,213,13,28,48,29,56,191,255,
60,249,61,23,45,0,42,6,198,48,1,0,98,87,5,0,1,82,64,6,
255,0,33,6,252,138,130,0,97,0,33,6,164,129,130,0,97,0,33,6,
240,207,130,0,97,0,33,6,24,209,130,0,97,0,33,6,218,81,128,0,
97,0,38,119,1,0,224,113,14,16,194,29,39,111,5,0,39,103,1,0,
34,135,9,0,48,95,5,0,48,87,1,0,237,89,161,13,187,5,236,81,
243,5,0,82,238,17,178,13,34,87,1,0,133,13,34,23,5,0,238,17,
202,237,34,23,1,0,2,80,127,0,138,7,225,243,6,248,99,63,17,0,
0,178,99,7,9,0,0,234,67,7,2,0,67,7,3,0,229,87,64,0,
224,7,96,1,63,231,1,0,99,87,13,0,224,225,186,5,128,7,88,2,
35,63,17,0,31,48,191,255,132,255,35,151,17,0,10,248,210,199,52,0,
186,5,99,255,9,0,224,249,234,5,28,16,1,146,67,151,2,0,133,13,
63,23,5,0,252,17,226,151,0,0,67,151,3,0,35,143,17,0,241,215,
9,0,49,87,1,0,49,95,5,0,99,231,5,0,202,209,225,223,0,0,
203,217,131,127,3,0,224,121,138,125,35,87,5,0,213,5,234,249,130,117,
63,255,1,0,63,191,9,0,215,247,54,0,138,253,131,119,3,0,224,113,
138,109,35,143,17,0,55,207,5,0,55,199,1,0,247,71,9,0,49,63,
5,0,49,55,1,0,216,65,225,79,0,0,217,73,233,57,203,69,177,5,
232,49,153,69,24,224,166,225,225,239,0,0,153,233,167,233,26,48,168,49,
35,151,17,0,225,63,0,0,155,57,169,57,210,199,52,0,146,45,224,233,
191,21,182,5,224,225,139,21,224,57,239,13,182,5,224,49,187,13,215,223,
55,0,138,13,96,191,133,176,3,234,1,146,67,151,2,0,229,45,224,233,
150,21,224,57,246,13,215,223,55,0,202,13,35,143,5,0,215,55,54,0,
2,234,241,249,226,151,0,0,67,151,2,0,197,29,4,234,165,29,65,178,
214,0,1,146,67,151,2,0,4,234,181,21,35,151,17,0,210,199,52,0,
178,13,215,223,55,0,138,13,233,57,234,5,232,49,202,5,96,191,133,176,
1,234,1,146,67,151,2,0,163,119,3,0,224,113,186,93,34,111,9,0,
205,247,54,0,162,21,35,95,5,0,197,5,202,247,54,0,130,13,34,23,
5,0,235,17,34,87,9,0,138,253,229,69,163,95,3,0,224,89,218,69,
34,231,9,0,60,55,1,0,60,63,5,0,6,64,7,72,233,217,129,61,
187,5,232,209,211,53,35,111,17,0,141,111,53,0,205,238,1,0,146,45,
35,143,17,0,49,95,5,0,49,87,1,0,233,89,251,29,177,5,232,81,
203,29,252,71,9,0,198,65,225,111,0,0,199,105,237,217,193,21,187,5,
232,209,145,21,220,223,55,0,234,13,35,143,5,0,34,103,5,0,220,55,
54,0,2,234,241,97,226,151,0,0,67,151,3,0,181,13,224,233,202,5,
224,177,65,178,214,0,4,234,197,5,1,146,67,151,3,0,35,151,17,0,
210,199,52,0,226,13,100,234,162,37,131,119,3,0,224,113,186,5,191,7,
64,254,163,111,3,0,224,105,226,149,245,21,131,103,3,0,34,23,5,0,
224,97,210,5,163,95,3,0,224,89,250,5,35,143,5,0,241,17,178,5,
191,7,14,254,35,87,9,0,42,87,9,0,96,87,133,176,35,55,13,0,
230,47,32,0,29,80,74,6,255,243,128,7,97,0,6,232,29,56,38,6,
240,147,139,0,32,70,0,96,191,255,62,230,29,62,0,96,36,54,108,142,
4,66,191,255,48,230,36,23,109,142,32,86,0,8,100,87,105,142,197,5,
34,23,5,0,95,82,224,17,202,253,100,87,105,142,32,86,4,96,64,6,
127,0,128,7,97,0,6,232,39,6,240,147,139,0,32,70,0,96,191,255,
248,229,29,54,0,96,36,62,108,142,4,66,191,255,234,229,32,86,4,96,
64,6,127,0,38,23,1,0,224,17,2,80,162,13,42,143,9,0,231,137,
226,5,42,87,5,0,226,81,154,253,0,82,127,0,128,7,225,0,8,224,
191,255,220,255,10,232,224,233,154,13,38,6,56,43,133,0,32,62,241,1,
0,66,191,255,50,214,125,231,9,0,64,6,255,0,128,7,97,0,6,232,
224,233,154,13,38,6,72,43,133,0,32,62,19,1,0,66,191,255,16,214,
229,87,64,0,224,7,96,1,36,23,109,142,36,143,105,142,10,248,125,23,
5,0,100,239,109,142,95,138,100,143,105,142,255,47,32,0,64,6,127,0,
128,7,97,0,38,143,1,0,1,234,241,57,186,13,39,23,5,0,226,57,
218,5,102,7,1,0,0,234,181,5,102,23,1,0,39,23,5,0,39,87,
1,0,98,87,1,0,39,23,1,0,39,87,5,0,7,48,98,87,5,0,
191,255,130,255,29,80,64,6,127,0,128,7,225,0,6,224,191,255,44,255,
10,232,224,233,154,13,38,6,88,43,133,0,32,62,207,1,0,66,191,255,
130,213,28,48,29,56,191,255,150,255,64,6,255,0,128,7,225,16,6,216,
7,232,8,224,224,233,154,13,38,6,104,43,133,0,32,62,64,1,0,66,
191,255,88,213,59,23,1,0,224,17,178,21,224,225,194,5,60,23,5,0,
213,5,34,231,1,0,123,239,1,0,125,231,1,0,124,239,5,0,125,23,
5,0,98,239,1,0,245,5,125,239,1,0,125,239,5,0,123,239,1,0,
64,6,255,16,128,7,225,0,7,224,60,63,9,0,6,232,191,255,86,251,
29,48,28,56,10,64,191,255,144,255,64,6,255,0,128,7,193,0,6,224,
156,0,229,87,64,0,224,7,96,1,10,232,224,225,226,231,0,0,133,21,
224,225,170,13,229,87,64,0,224,135,96,1,229,87,64,0,224,7,96,1,
213,5,253,47,32,0,0,82,181,21,36,135,109,142,224,129,226,237,36,231,
109,142,36,119,105,142,60,127,5,0,65,114,100,119,105,142,100,127,109,142,
253,47,32,0,28,80,64,6,223,0,128,7,97,0,6,232,135,0,7,48,
191,255,150,255,224,81,178,5,106,239,9,0,64,6,127,0,128,7,97,0,
6,232,224,233,154,13,38,6,136,43,133,0,32,62,19,1,0,66,191,255,
106,212,229,87,64,0,224,7,96,1,36,23,89,142,36,143,85,142,10,248,
125,23,5,0,100,239,89,142,95,138,100,143,85,142,255,47,32,0,64,6,
127,0,128,7,97,0,38,143,1,0,1,234,241,57,186,13,39,23,5,0,
226,57,218,5,102,7,1,0,0,234,181,5,102,23,1,0,39,23,5,0,
39,87,1,0,98,87,1,0,39,23,1,0,39,87,5,0,7,48,98,87,
5,0,191,255,130,255,29,80,64,6,127,0,128,7,225,0,6,232,7,224,
224,225,178,5,224,233,154,13,38,6,152,43,133,0,32,62,125,3,0,66,
191,255,220,211,61,54,12,0,28,56,191,255,148,255,253,135,25,0,97,130,
202,5,0,82,0,90,149,29,61,87,13,0,0,18,224,81,178,5,42,23,
1,0,34,23,9,0,34,103,1,0,226,87,9,0,34,111,5,0,1,130,
204,81,225,95,0,0,203,105,176,81,225,95,0,0,141,89,253,127,25,0,
125,95,9,0,125,87,5,0,95,122,125,127,24,0,64,6,255,0,128,7,
225,16,6,216,7,232,8,224,224,233,154,13,38,6,168,43,133,0,32,62,
64,1,0,66,191,255,96,211,59,23,1,0,224,17,178,21,224,225,194,5,
60,23,5,0,213,5,34,231,1,0,123,239,1,0,125,231,1,0,124,239,
5,0,125,23,5,0,98,239,1,0,245,5,125,239,1,0,125,239,5,0,
123,239,1,0,64,6,255,16,128,7,193,0,6,224,156,0,229,87,64,0,
224,7,96,1,10,232,224,225,226,231,0,0,133,21,224,225,170,13,229,87,
64,0,224,135,96,1,229,87,64,0,224,7,96,1,213,5,253,47,32,0,
0,82,181,21,36,135,89,142,224,129,226,237,36,231,89,142,36,119,85,142,
60,127,5,0,65,114,100,119,85,142,100,127,89,142,253,47,32,0,28,80,
64,6,223,0,128,7,97,0,6,232,135,0,7,48,191,255,150,255,224,81,
178,5,106,239,9,0,64,6,127,0,38,119,1,0,224,113,14,16,194,29,
39,111,5,0,39,103,1,0,34,135,9,0,48,95,5,0,48,87,1,0,
237,89,161,13,187,5,236,81,243,5,0,82,238,17,178,13,34,87,1,0,
133,13,34,23,5,0,238,17,202,237,34,23,1,0,2,80,127,0,128,7,
225,0,7,224,60,63,9,0,6,232,191,255,176,255,29,48,28,56,10,64,
191,255,210,254,64,6,255,0,128,7,225,112,8,48,38,87,1,0,230,71,
9,0,38,103,5,0,9,200,7,216,202,65,225,79,0,0,204,73,1,58,
8,224,167,225,225,239,0,0,137,233,191,255,90,255,10,208,224,201,186,29,
59,127,13,0,224,121,250,21,251,119,25,0,224,113,146,13,38,6,184,43,
133,0,32,62,246,2,0,66,191,255,244,209,123,231,5,0,123,239,9,0,
59,54,12,0,26,56,191,255,128,255,197,21,59,95,9,0,59,87,5,0,
235,233,129,13,187,5,234,225,211,5,123,231,5,0,123,239,9,0,59,54,
12,0,26,56,25,64,191,255,64,254,251,111,25,0,251,103,27,0,65,106,
123,111,24,0,65,98,123,103,26,0,64,6,255,112,128,7,225,48,35,215,
25,0,7,224,35,23,21,0,9,56,6,216,8,48,2,64,128,255,8,12,
10,232,224,233,146,13,125,231,25,0,27,48,28,56,29,64,26,72,191,255,
46,255,29,80,64,6,255,48,32,134,128,0,100,135,93,142,100,7,97,142,
43,6,240,131,139,0,11,16,100,23,101,142,0,82,31,98,98,103,1,0,
98,7,5,0,98,7,9,0,98,7,13,0,98,7,24,0,98,7,26,0,
66,87,28,0,10,6,129,255,130,13,2,22,32,0,107,23,17,0,107,7,
21,0,2,88,65,82,10,6,128,255,214,229,107,7,17,0,107,7,21,0,
127,0,32,142,108,176,49,87,1,0,49,95,5,0,72,138,49,119,1,0,
143,82,11,96,209,98,10,97,143,90,224,89,234,87,0,0,238,97,234,23,
0,0,2,81,127,0,128,7,225,48,6,216,251,143,25,0,7,208,224,137,
154,13,38,6,200,43,133,0,32,62,177,4,0,66,191,255,194,208,58,239,
9,0,253,255,11,0,128,249,229,87,64,0,224,7,96,1,32,127,61,176,
10,224,223,121,96,127,61,176,252,47,32,0,29,48,1,58,128,255,140,10,
221,143,15,0,26,56,27,48,191,255,148,252,64,6,255,48,128,7,225,0,
6,232,253,143,27,0,60,6,232,43,133,0,224,137,242,5,28,48,32,62,
120,4,0,66,191,255,104,208,253,135,25,0,97,130,233,13,28,48,32,62,
123,4,0,66,191,255,84,208,224,81,229,5,61,63,13,0,29,48,191,255,
104,255,253,119,25,0,224,113,138,253,224,113,242,5,28,48,32,62,136,4,
0,66,191,255,46,208,229,87,64,0,224,7,96,1,36,111,101,142,36,103,
97,142,10,248,125,111,17,0,100,239,101,142,95,98,100,103,97,142,255,47,
32,0,36,95,97,142,224,89,142,13,28,48,32,62,151,4,0,66,191,255,
246,207,224,81,64,6,255,0,128,7,225,16,7,232,253,143,25,0,8,216,
6,224,224,137,154,13,38,6,248,43,133,0,32,62,81,3,0,66,191,255,
206,207,253,135,25,0,97,130,227,5,29,48,27,56,191,255,224,254,133,13,
28,48,29,56,128,255,106,7,29,48,191,255,42,255,64,6,255,16,128,7,
225,48,6,216,7,208,9,232,213,13,40,231,5,0,27,48,26,56,191,255,
166,255,253,143,1,0,28,64,95,138,125,143,0,0,253,135,1,0,224,129,
154,245,64,6,255,48,132,7,225,243,6,176,99,63,5,0,136,0,224,65,
186,53,32,23,145,176,34,119,9,0,32,95,77,176,46,111,5,0,46,103,
1,0,32,87,73,176,237,89,139,53,177,5,236,81,217,45,32,87,149,176,
224,81,162,5,10,16,34,23,9,0,32,142,108,176,49,71,1,0,34,103,
1,0,226,87,9,0,49,79,5,0,34,111,5,0,1,130,204,81,225,95,
0,0,203,105,176,81,225,95,0,0,141,89,235,73,241,13,187,5,234,65,
195,13,35,63,5,0,32,71,145,176,32,78,156,176,22,48,191,255,78,255,
128,7,248,2,224,127,157,176,97,122,186,5,128,7,236,2,57,6,24,43,
133,0,0,186,67,7,3,0,32,239,145,176,224,233,154,13,38,6,40,43,
133,0,32,62,136,2,0,66,191,255,192,206,61,223,5,0,0,74,0,210,
253,217,130,101,61,23,9,0,27,208,194,199,15,0,170,93,59,135,9,0,
208,199,15,0,218,85,34,103,1,0,226,87,9,0,34,111,5,0,204,81,
225,23,0,0,205,17,48,111,5,0,48,103,1,0,237,17,218,69,236,81,
186,69,224,233,250,5,25,48,32,62,190,3,0,66,191,255,106,206,61,239,
9,0,59,231,9,0,224,233,61,199,25,0,250,5,25,48,32,62,196,3,
0,66,191,255,78,206,224,193,250,5,25,48,32,62,197,3,0,66,191,255,
62,206,252,119,9,0,253,103,9,0,61,127,21,0,206,97,60,119,17,0,
125,103,8,0,252,95,11,0,253,135,11,0,111,119,9,0,60,111,21,0,
29,48,203,129,125,135,10,0,125,111,21,0,128,255,254,6,220,143,15,0,
124,7,25,0,24,48,27,56,191,255,0,250,1,74,224,73,226,13,224,95,
157,176,32,87,149,176,95,90,96,95,156,176,234,209,186,13,1,186,96,7,
149,176,213,13,32,135,149,176,240,209,154,13,1,186,245,5,163,127,3,0,
224,121,186,5,191,7,236,254,32,239,149,176,224,185,154,125,61,239,1,0,
224,233,154,13,38,6,40,43,133,0,32,62,136,2,0,66,191,255,160,205,
61,215,5,0,0,74,253,209,242,93,61,23,9,0,194,199,15,0,170,93,
58,135,9,0,208,199,15,0,218,85,34,103,1,0,226,87,9,0,34,111,
5,0,204,81,225,23,0,0,205,17,48,111,5,0,48,103,1,0,237,17,
218,69,236,81,186,69,224,233,250,5,25,48,32,62,190,3,0,66,191,255,
78,205,61,231,9,0,58,223,9,0,224,225,60,199,25,0,250,5,25,48,
32,62,196,3,0,66,191,255,50,205,224,193,250,5,25,48,32,62,197,3,
0,66,191,255,34,205,251,119,9,0,252,103,9,0,60,127,21,0,206,97,
59,119,17,0,124,103,8,0,251,95,11,0,252,135,11,0,111,119,9,0,
59,111,21,0,28,48,203,129,124,135,10,0,124,111,21,0,128,255,226,5,
219,143,15,0,123,7,25,0,24,48,26,56,191,255,228,248,1,74,224,73,
130,13,224,95,157,176,96,239,149,176,95,90,96,95,156,176,224,231,157,176,
32,239,145,176,181,69,61,23,9,0,32,95,77,176,34,111,5,0,34,103,
1,0,32,87,73,176,61,223,5,0,237,89,187,53,177,5,236,81,137,53,
226,87,9,0,32,142,108,176,49,71,1,0,49,79,5,0,204,81,225,95,
0,0,203,105,1,130,176,81,225,95,0,0,141,89,235,73,209,29,187,5,
234,65,163,29,35,63,5,0,29,64,22,48,191,255,120,252,224,135,157,176,
32,127,145,176,95,130,96,135,156,176,239,233,218,5,32,119,149,176,96,119,
145,176,32,239,149,176,224,233,178,5,96,7,149,176,95,226,27,232,224,225,
218,189,32,111,145,176,224,105,218,13,32,103,149,176,224,97,154,13,38,6,
8,44,133,0,32,62,29,2,0,66,191,255,22,204,224,95,157,176,224,89,
170,13,38,6,8,44,133,0,32,62,34,2,0,66,191,255,254,203,224,81,
68,6,255,243,132,7,225,243,6,248,7,176,0,202,99,7,1,0,0,194,
0,234,0,186,0,226,0,218,229,87,64,0,224,7,96,1,63,215,1,0,
99,87,5,0,224,209,186,5,128,7,2,1,31,48,22,56,191,255,26,249,
10,248,99,255,1,0,224,249,202,5,26,16,1,226,229,5,63,23,5,0,
250,17,226,223,0,0,54,55,1,0,246,71,9,0,54,63,5,0,198,65,
225,79,0,0,199,73,224,225,218,37,26,80,213,5,234,249,130,37,63,255,
1,0,63,103,9,0,204,207,15,0,130,253,224,225,138,29,44,87,1,0,
236,119,9,0,44,95,5,0,202,113,225,87,0,0,203,81,234,57,187,13,
177,5,238,49,137,13,65,234,221,0,31,200,31,192,1,226,4,186,165,5,
1,226,224,217,138,45,34,119,9,0,206,207,15,0,250,13,26,88,197,5,
202,207,15,0,138,13,34,23,5,0,235,17,34,87,9,0,138,253,229,21,
224,217,218,21,34,103,9,0,44,95,5,0,44,87,1,0,235,73,193,13,
187,5,234,65,147,13,224,233,170,5,2,200,2,192,65,234,221,0,4,186,
165,5,1,218,34,23,5,0,224,225,178,5,224,217,186,5,250,17,170,173,
96,239,156,176,35,151,1,0,96,207,145,176,96,199,149,176,1,130,96,151,
153,176,64,135,158,176,35,55,5,0,230,47,32,0,23,80,68,6,255,243,
128,7,97,0,192,15,160,176,96,7,149,176,96,7,145,176,96,7,153,176,
96,7,156,176,96,7,141,176,38,135,8,0,64,7,158,176,224,129,194,77,
199,231,54,0,154,77,38,239,1,0,32,119,117,176,61,127,1,0,239,113,
186,61,253,111,25,0,224,105,154,13,38,6,24,44,133,0,32,62,33,1,
0,66,191,255,102,202,192,143,160,176,96,239,141,176,61,23,13,0,32,142,
108,176,34,23,9,0,49,95,5,0,34,111,5,0,34,103,1,0,49,87,
1,0,237,89,145,37,187,5,236,81,225,29,32,95,77,176,61,111,9,0,
61,103,5,0,32,23,73,176,237,89,203,21,177,5,236,17,155,21,61,54,
12,0,32,62,72,176,191,255,30,254,97,82,151,13,1,82,133,13,38,103,
1,0,61,239,17,0,236,233,186,189,0,82,64,6,127,0,130,7,97,0,
6,232,99,7,1,0,149,13,29,48,3,56,128,255,162,1,35,55,1,0,
191,255,88,249,61,143,8,0,224,137,218,245,66,6,127,0,128,7,225,16,
6,224,60,143,8,0,7,216,224,137,146,29,60,239,1,0,61,135,1,0,
240,217,186,5,1,82,165,21,61,239,17,0,224,233,154,13,38,6,56,44,
133,0,32,62,195,0,0,66,191,255,152,201,60,127,5,0,239,233,186,237,
0,82,64,6,255,16,38,23,1,0,224,17,2,80,162,13,42,143,9,0,
231,137,226,5,42,87,5,0,226,81,154,253,0,82,127,0,128,7,225,0,
6,224,60,239,25,0,253,143,25,0,224,137,154,13,38,6,72,44,133,0,
32,62,42,3,0,66,191,255,74,201,61,54,12,0,28,56,191,255,186,255,
253,135,25,0,29,48,10,56,97,130,195,5,191,255,82,248,181,5,191,255,
166,248,64,6,255,0,128,7,97,0,6,232,229,87,64,0,224,7,96,1,
10,248,149,13,229,87,64,0,224,135,96,1,229,87,64,0,224,7,96,1,
36,127,97,142,36,135,93,142,240,121,178,245,36,23,101,142,15,110,1,0,
125,23,1,0,34,119,17,0,100,111,97,142,100,119,101,142,255,47,32,0,
36,63,97,142,97,58,231,13,38,6,104,44,133,0,191,255,36,216,38,6,
88,44,133,0,32,62,78,4,1,66,191,255,186,200,61,95,1,0,235,95,
25,0,224,89,146,13,38,6,88,44,133,0,32,62,82,4,0,66,191,255,
158,200,61,23,1,0,32,87,117,176,98,7,26,0,98,7,24,0,98,87,
1,0,34,86,12,0,106,7,1,0,98,7,5,0,98,7,9,0,36,87,
97,142,64,6,127,0,128,7,33,0,191,255,2,247,128,255,44,0,64,6,
63,0,102,7,1,0,102,7,5,0,8,138,102,143,10,0,102,7,8,0,
127,0,33,6,66,80,128,0,97,0,33,6,2,81,128,0,97,0,33,6,
148,81,128,0,97,0,128,7,225,0,60,6,240,243,139,0,60,143,9,0,
6,232,241,233,194,53,221,223,15,0,146,13,38,6,224,44,133,0,32,62,
11,2,0,66,191,255,12,200,60,135,13,0,240,233,218,5,61,127,29,0,
124,127,13,0,61,111,29,0,61,119,33,0,110,111,29,0,61,95,33,0,
61,103,29,0,60,23,9,0,108,95,33,0,34,23,29,0,226,233,34,87,
33,0,178,13,234,233,146,13,125,23,29,0,98,239,33,0,125,87,33,0,
106,239,29,0,124,239,9,0,64,6,255,0,128,7,97,0,6,232,29,56,
38,6,240,243,139,0,32,70,24,0,191,255,20,215,29,62,24,0,38,6,
8,244,139,0,128,70,0,252,191,255,2,215,128,86,24,252,64,6,127,0,
128,7,97,0,6,232,39,6,240,243,139,0,32,70,24,0,191,255,230,214,
29,54,24,0,39,6,8,244,139,0,128,70,0,252,191,255,212,214,128,86,
24,252,64,6,127,0,128,7,225,0,32,87,73,176,38,119,1,0,8,232,
174,81,230,119,11,0,202,57,125,87,1,0,9,224,174,57,124,63,1,0,
61,103,1,0,224,97,142,21,224,57,151,13,38,6,240,44,133,0,32,62,
135,0,0,66,191,255,28,199,61,135,1,0,128,129,124,135,1,0,64,6,
255,0,34,6,240,243,139,0,34,143,13,0,241,49,178,61,34,135,1,0,
240,49,234,5,38,127,33,0,98,127,1,0,133,53,34,119,9,0,238,49,
234,5,38,111,33,0,98,111,9,0,149,13,34,103,5,0,236,49,218,5,
38,95,29,0,98,95,5,0,38,143,29,0,38,87,33,0,106,143,29,0,
38,135,29,0,38,127,33,0,34,87,1,0,112,127,33,0,42,87,29,0,
234,49,42,95,33,0,178,13,235,49,146,13,102,87,29,0,106,55,33,0,
102,95,33,0,107,55,29,0,98,55,13,0,127,0,128,7,225,0,6,232,
229,87,64,0,224,7,96,1,221,199,15,0,29,48,10,224,194,21,191,255,
100,255,189,143,15,0,209,142,246,0,93,143,15,0,221,215,15,0,186,13,
61,135,25,0,240,127,27,0,95,122,112,127,26,0,181,5,191,255,22,254,
34,6,240,243,139,0,34,119,17,0,50,6,0,244,139,0,95,114,98,119,
17,0,50,239,1,0,252,47,32,0,224,233,158,13,38,6,0,45,133,0,
32,62,27,1,0,66,191,255,22,198,29,80,64,6,255,0,102,7,25,0,
224,57,226,5,38,55,17,0,1,58,191,7,190,202,127,0,128,7,225,16,
60,6,240,243,139,0,229,87,64,0,224,7,96,1,60,143,21,0,60,135,
17,0,10,216,241,129,218,5,251,47,32,0,0,82,245,37,60,239,9,0,
29,127,15,0,207,118,9,0,146,13,38,6,16,45,133,0,32,62,81,1,
0,66,191,255,182,197,61,95,25,0,221,15,15,0,224,89,194,5,29,48,
191,255,60,252,61,87,33,0,60,143,17,0,124,239,5,0,124,87,9,0,
65,138,124,143,17,0,251,47,32,0,29,80,64,6,255,16,134,7,225,48,
6,208,7,216,8,224,191,255,126,255,10,232,224,233,130,45,99,7,9,0,
28,48,3,56,35,70,4,0,35,78,8,0,191,255,50,209,224,81,135,29,
125,215,1,0,125,223,5,0,35,135,1,0,125,231,8,0,35,127,5,0,
125,7,10,0,35,119,9,0,125,87,12,0,125,127,21,0,125,135,17,0,
93,119,14,0,213,5,29,48,191,255,158,254,0,234,29,80,70,6,255,48,
0,90,32,142,0,7,44,6,240,243,139,0,108,143,21,0,108,7,17,0,
34,6,8,244,139,0,2,80,108,87,13,0,108,87,9,0,108,87,5,0,
108,87,1,0,44,111,21,0,149,13,98,87,29,0,2,80,2,22,36,0,
106,23,33,0,65,90,237,89,246,245,44,23,1,0,106,23,33,0,98,87,
29,0,127,0,128,7,225,0,128,143,175,176,6,232,7,224,252,0,224,137,
178,29,32,135,61,177,224,129,146,13,38,6,8,46,133,0,32,62,97,1,
0,66,191,255,158,196,32,54,52,177,129,255,66,116,224,81,146,13,38,6,
20,46,133,0,32,62,178,1,0,66,191,255,130,196,29,48,28,56,128,255,
156,212,29,48,129,255,226,20,61,55,45,0,224,49,178,5,128,255,112,220,
224,231,241,176,245,13,229,87,64,0,10,232,32,254,159,255,93,249,255,47,
32,0,253,47,32,0,4,119,124,142,224,113,154,37,51,6,5,0,32,0,
211,255,0,0,218,237,229,87,64,0,224,7,96,1,32,111,217,176,10,232,
95,106,96,111,217,176,138,13,32,103,45,177,224,97,202,5,3,50,128,255,
24,16,29,248,255,47,32,0,50,6,54,0,32,0,114,231,0,0,64,6,
255,0,134,7,225,243,132,135,105,144,7,200,6,184,224,129,162,13,57,223,
5,0,57,215,1,0,57,126,8,0,47,239,1,0,133,13,57,215,1,0,
0,218,57,22,4,0,34,239,1,0,247,199,33,0,247,119,9,0,9,224,
99,71,9,0,238,193,183,37,215,207,52,0,224,55,241,176,146,13,215,215,
52,0,32,110,86,0,178,13,32,110,82,0,133,13,215,199,52,0,32,110,
88,0,178,5,32,110,87,0,26,64,27,72,99,239,1,0,99,111,5,0,
39,6,192,45,133,0,128,255,140,15,32,86,3,1,197,125,224,193,202,5,
56,6,255,255,255,127,96,231,193,176,213,109,32,103,213,176,0,178,236,225,
195,5,32,182,97,1,213,21,26,80,27,81,178,5,224,233,202,5,32,182,
0,1,213,13,218,126,3,0,0,121,194,5,32,182,2,1,229,5,221,110,
255,1,162,37,32,182,4,1,215,207,52,0,224,55,241,176,146,13,215,215,
52,0,32,102,82,0,186,13,32,102,86,0,133,13,215,199,52,0,32,102,
87,0,186,5,32,102,88,0,26,64,27,72,99,239,1,0,99,103,5,0,
39,6,192,45,133,0,128,255,0,15,22,80,224,81,234,53,29,80,137,82,
170,193,204,5,24,232,201,234,128,233,35,151,9,0,124,7,9,0,124,215,
1,0,124,223,5,0,95,146,99,151,9,0,132,119,105,144,124,7,13,0,
124,239,17,0,28,230,20,0,224,113,178,13,76,202,57,223,5,0,57,215,
1,0,57,110,8,0,45,239,1,0,149,13,72,202,57,215,1,0,0,218,
57,22,4,0,34,239,1,0,35,151,9,0,224,145,183,5,224,193,255,141,
0,82,70,6,255,243,144,7,225,243,132,135,105,144,7,184,6,216,224,129,
162,13,55,207,5,0,55,199,1,0,55,126,8,0,47,215,1,0,133,13,
55,199,1,0,0,202,55,22,4,0,34,215,1,0,32,95,237,176,32,87,
233,176,235,201,129,13,187,5,234,193,211,5,96,199,233,176,96,207,237,176,
219,199,55,0,186,5,128,7,8,2,24,224,25,232,57,6,8,185,255,255,
59,150,20,0,99,151,17,0,99,7,25,0,35,95,17,0,43,95,1,0,
224,89,186,5,128,7,192,1,35,87,25,0,32,118,188,176,194,82,206,81,
106,207,1,0,35,87,17,0,139,23,15,0,234,87,7,0,43,183,17,0,
202,17,2,80,229,5,171,81,196,5,54,183,9,0,10,16,182,95,5,0,
224,81,143,253,35,151,17,0,242,151,5,0,99,151,9,0,2,144,201,146,
99,151,13,0,35,151,9,0,162,89,54,87,1,0,235,145,235,151,60,195,
201,194,128,7,72,1,32,111,213,176,99,7,22,0,237,201,227,5,32,150,
97,1,99,151,22,0,181,29,28,88,29,89,178,5,224,209,234,5,32,150,
0,1,99,151,22,0,149,21,220,86,3,0,0,81,226,5,32,150,2,1,
99,151,22,0,133,13,218,118,255,1,194,37,32,150,4,1,99,151,22,0,
219,207,52,0,224,55,241,176,146,13,219,215,52,0,32,110,82,0,186,13,
32,110,86,0,133,13,219,199,52,0,32,110,87,0,186,5,32,110,88,0,
39,6,192,45,133,0,28,64,29,72,99,215,1,0,99,111,5,0,128,255,
40,13,35,87,22,0,224,81,178,5,128,7,62,2,250,193,35,151,9,0,
250,199,50,19,2,88,137,90,171,145,99,151,9,0,35,151,13,0,121,231,
1,0,121,239,5,0,121,23,17,0,121,151,13,0,121,151,9,0,25,206,
20,0,250,17,138,29,132,87,105,144,224,81,178,13,76,186,55,239,5,0,
55,231,1,0,55,134,8,0,48,215,1,0,245,13,72,186,55,231,1,0,
0,234,55,86,4,0,42,215,1,0,229,5,194,225,225,79,0,0,201,233,
162,209,248,17,250,29,35,151,9,0,224,145,135,45,54,183,9,0,224,177,
154,13,38,6,156,45,133,0,32,62,232,6,0,66,191,255,130,192,54,151,
1,0,182,23,5,0,99,151,13,0,35,151,9,0,226,145,226,151,60,195,
201,194,191,7,196,254,2,80,162,193,35,151,13,0,202,145,99,151,13,0,
35,151,9,0,224,145,183,5,191,7,170,254,35,151,17,0,72,146,99,151,
17,0,35,151,25,0,65,146,99,151,25,0,99,146,190,5,191,7,28,254,
0,82,128,7,86,1,26,232,251,215,33,0,251,127,9,0,60,6,8,185,
255,255,99,71,25,0,239,209,183,37,219,207,52,0,224,55,241,176,146,13,
219,215,52,0,32,118,86,0,178,13,32,118,82,0,133,13,219,199,52,0,
32,118,88,0,178,5,32,118,87,0,39,6,192,45,133,0,24,64,25,72,
99,239,1,0,99,119,5,0,128,255,222,11,32,86,3,1,197,125,224,209,
202,5,58,6,255,255,255,127,96,231,193,176,213,109,32,111,213,176,0,178,
237,225,195,5,32,182,97,1,213,21,24,88,25,89,178,5,224,233,202,5,
32,182,0,1,213,13,216,86,3,0,0,81,194,5,32,182,2,1,229,5,
221,118,255,1,162,37,32,182,4,1,219,207,52,0,224,55,241,176,146,13,
219,215,52,0,32,110,82,0,186,13,32,110,86,0,133,13,219,199,52,0,
32,110,87,0,186,5,32,110,88,0,39,6,192,45,133,0,24,64,25,72,
99,239,1,0,99,111,5,0,128,255,82,11,22,80,224,81,234,53,29,88,
137,90,171,209,204,5,26,232,201,234,128,233,35,151,25,0,124,7,9,0,
124,199,1,0,124,207,5,0,95,146,99,151,25,0,132,127,105,144,124,7,
13,0,124,239,17,0,28,230,20,0,224,121,178,13,76,186,55,207,5,0,
55,199,1,0,55,118,8,0,46,239,1,0,149,13,72,186,55,199,1,0,
0,202,55,22,4,0,34,239,1,0,35,151,25,0,224,145,183,5,224,209,
255,141,0,82,80,6,255,243,130,7,225,112,8,232,9,200,7,224,0,218,
133,29,61,215,17,0,61,63,5,0,61,55,1,0,28,64,26,72,224,201,
194,5,32,22,36,0,181,5,32,22,129,0,99,23,1,0,128,255,200,235,
218,225,29,238,20,0,65,218,32,127,177,176,239,217,230,229,66,6,255,112,
142,7,97,0,6,232,221,223,11,0,61,118,28,0,130,13,221,199,54,0,
32,70,64,0,178,5,32,70,72,0,221,199,55,0,242,85,46,95,1,0,
238,23,7,0,139,111,15,0,43,95,17,0,42,6,8,185,255,255,238,103,
5,0,194,105,13,16,133,13,171,127,5,0,175,17,196,5,43,95,9,0,
2,104,224,17,143,253,133,37,43,23,1,0,13,120,201,122,194,121,171,23,
5,0,173,17,226,97,195,5,162,97,201,18,197,5,12,16,201,18,162,97,
106,127,9,0,106,127,13,0,106,23,17,0,106,7,1,0,106,7,5,0,
10,86,20,0,43,95,9,0,0,106,224,97,143,229,46,23,1,0,42,6,
8,185,255,255,11,130,194,7,15,0,221,31,55,0,61,103,1,0,61,111,
5,0,46,23,4,0,99,87,5,0,99,103,9,0,99,111,13,0,99,23,
18,0,99,135,25,0,213,21,32,23,193,176,232,0,61,95,5,0,61,87,
1,0,99,23,5,0,46,103,4,0,99,95,13,0,99,87,9,0,8,122,
99,103,18,0,99,127,25,0,61,87,49,0,42,87,5,0,232,0,42,23,
105,0,99,7,16,0,99,71,22,0,99,63,1,0,2,22,16,0,34,55,
0,0,34,119,5,0,3,56,63,6,98,89,0,0,202,49,110,0,195,247,
22,0,194,5,221,63,53,0,181,5,221,191,53,0,0,82,78,6,127,0,
128,7,225,48,6,232,58,6,8,240,140,0,128,255,94,9,61,55,45,0,
128,255,6,219,221,239,52,0,0,218,250,5,221,247,52,0,202,5,221,223,
53,0,194,13,32,71,177,176,32,63,181,176,125,7,32,0,29,48,26,72,
191,255,14,249,10,216,128,143,175,176,224,137,178,29,32,135,61,177,224,129,
146,13,38,6,32,46,133,0,32,62,97,1,0,66,191,255,234,188,32,54,
52,177,129,255,142,108,224,81,146,13,38,6,44,46,133,0,32,62,178,1,
0,66,191,255,206,188,224,217,202,77,221,239,52,0,125,7,8,0,27,224,
202,5,221,247,52,0,210,29,0,50,26,16,0,82,245,5,34,119,17,0,
2,22,20,0,65,82,206,49,32,111,177,176,237,81,246,245,224,49,178,53,
6,96,169,98,125,103,8,0,128,255,158,8,10,224,224,225,202,5,32,222,
21,1,245,37,221,239,52,0,242,5,29,48,28,56,26,64,1,74,191,255,
158,253,221,223,53,0,26,56,170,5,28,56,29,48,128,255,124,197,221,247,
52,0,10,216,242,5,29,48,28,56,26,64,0,74,191,255,122,253,221,207,
53,0,194,5,29,48,128,255,210,196,224,225,194,5,28,48,128,255,78,8,
31,50,128,255,132,8,27,80,64,6,255,48,128,7,97,0,128,143,175,176,
224,137,146,85,64,7,174,176,61,6,8,4,141,0,29,48,32,62,0,1,
128,255,36,233,32,135,61,177,224,129,146,13,38,6,56,46,133,0,32,62,
97,1,0,66,191,255,240,187,32,54,52,177,129,255,148,107,224,81,146,13,
38,6,68,46,133,0,32,62,178,1,0,66,191,255,212,187,29,127,0,0,
207,126,31,0,15,6,240,255,186,13,189,87,5,0,61,103,6,0,61,110,
8,0,205,81,204,102,255,15,133,29,157,111,1,0,8,90,132,135,105,144,
216,106,157,106,13,80,194,82,221,81,224,129,162,5,12,90,0,18,224,105,
242,5,189,23,1,0,130,90,173,17,235,23,194,2,2,96,96,103,177,176,
96,87,181,176,64,6,127,0,130,7,225,16,6,232,7,224,8,216,1,138,
67,143,3,0,38,6,8,215,255,255,31,58,129,255,254,100,224,81,154,253,
29,48,28,56,27,64,191,255,198,252,163,135,3,0,10,232,224,129,162,21,
67,7,3,0,38,6,8,215,255,255,129,255,16,99,224,81,146,13,38,6,
252,45,133,0,32,62,255,0,0,66,191,255,34,187,29,80,66,6,255,16,
158,7,225,243,6,232,7,192,8,200,9,176,55,6,8,215,255,255,1,130,
67,135,3,0,23,48,31,58,129,255,158,100,10,216,224,217,170,253,61,231,
53,0,251,0,28,208,221,210,159,210,242,5,29,48,25,56,22,64,191,255,
96,248,10,216,28,120,206,122,159,122,178,37,128,119,175,176,224,113,210,29,
64,7,174,176,32,111,61,177,224,105,146,13,38,6,80,46,133,0,32,62,
97,1,0,66,191,255,176,186,32,54,52,177,129,255,84,106,224,81,146,13,
38,6,92,46,133,0,32,62,178,1,0,66,191,255,148,186,221,143,54,0,
44,6,5,0,0,1,92,97,42,6,5,0,0,1,234,97,234,117,224,217,
234,117,27,200,0,218,27,16,195,18,61,86,20,0,194,81,42,87,1,0,
224,81,178,101,224,201,154,101,128,111,105,177,61,86,20,0,202,17,226,183,
5,0,224,105,202,5,221,223,11,0,194,53,27,96,194,98,32,134,188,176,
208,97,44,207,1,0,32,54,52,177,31,58,129,255,120,106,224,81,170,253,
25,48,22,56,32,70,4,2,128,255,36,230,32,127,61,177,10,200,224,121,
146,13,38,6,168,45,133,0,32,62,97,1,0,66,191,255,6,186,32,54,
52,177,129,255,170,105,224,81,146,13,38,6,228,45,133,0,32,62,178,1,
0,66,191,255,234,185,224,201,206,37,0,202,165,37,61,23,45,0,99,7,
48,0,27,104,194,106,32,86,188,176,202,105,45,87,1,0,99,23,33,0,
99,7,41,0,99,7,45,0,99,87,37,0,99,183,50,0,5,130,99,135,
57,0,99,7,54,0,32,54,16,0,12,58,35,70,32,0,191,255,142,185,
65,218,99,218,182,149,25,216,221,151,52,0,224,217,242,21,163,119,3,0,
224,113,130,21,67,7,3,0,23,48,129,255,88,97,224,81,146,13,38,6,
252,45,133,0,32,62,255,0,0,66,191,255,106,185,27,80,128,7,212,1,
224,193,210,101,28,104,222,106,159,106,178,93,61,55,49,0,61,111,5,0,
61,103,1,0,61,22,28,0,38,55,5,0,34,23,4,0,224,209,130,61,
28,80,199,82,159,82,32,71,193,176,12,112,13,120,2,72,250,5,99,119,
13,0,99,127,17,0,9,18,213,13,253,87,25,0,0,106,206,81,99,87,
13,0,225,23,0,0,207,17,99,23,17,0,10,18,99,23,29,0,38,23,
105,0,99,7,20,0,99,79,22,0,99,7,26,0,72,18,34,87,0,0,
99,199,5,0,99,71,9,0,34,127,5,0,198,81,10,48,35,62,4,0,
63,6,244,93,0,0,111,0,197,29,99,7,20,0,99,199,5,0,99,7,
9,0,99,103,13,0,99,111,17,0,99,23,22,0,99,7,29,0,99,7,
26,0,35,62,4,0,128,255,82,38,245,5,29,48,24,56,0,66,191,255,
18,250,10,216,220,118,6,0,102,114,186,109,28,104,205,106,159,106,202,5,
204,226,159,226,194,101,61,231,24,0,224,225,247,45,32,215,189,176,32,54,
52,177,31,58,129,255,180,104,224,81,170,253,26,48,28,56,32,70,136,0,
128,255,96,228,32,135,61,177,10,224,224,129,146,13,38,6,180,45,133,0,
32,62,97,1,0,66,191,255,66,184,32,54,52,177,129,255,230,103,224,81,
146,13,38,6,240,45,133,0,32,62,178,1,0,66,191,255,38,184,28,104,
224,105,174,5,0,106,61,239,40,0,224,233,231,45,224,105,202,45,32,231,
197,176,32,54,52,177,31,58,129,255,76,104,224,81,170,253,28,48,29,56,
32,70,136,0,128,255,248,227,32,95,61,177,10,232,224,89,146,13,38,6,
180,45,133,0,32,62,97,1,0,66,191,255,218,183,32,54,52,177,129,255,
126,103,224,81,146,13,38,6,240,45,133,0,32,62,178,1,0,66,191,255,
190,183,224,233,163,135,3,0,224,129,130,21,67,7,3,0,23,48,129,255,
132,95,224,81,146,13,38,6,252,45,133,0,32,62,255,0,0,66,191,255,
150,183,27,80,94,6,255,243,130,7,225,16,6,224,60,239,45,0,7,216,
29,48,128,255,208,213,224,81,242,69,48,6,36,16,141,0,99,135,1,0,
61,79,37,0,61,71,33,0,3,48,128,255,206,200,10,232,224,233,146,13,
29,64,38,6,104,46,133,0,32,62,138,1,191,255,76,183,35,23,1,0,
2,111,0,0,205,110,31,0,13,6,240,255,218,13,162,103,5,0,34,86,
6,0,42,79,0,0,34,70,8,0,204,65,201,78,255,15,149,29,130,87,
1,0,8,90,132,111,105,144,216,82,157,82,10,64,194,66,194,65,224,105,
162,5,12,90,11,104,0,74,224,81,130,13,162,95,1,0,130,106,11,72,
170,73,237,79,194,2,224,233,202,21,28,48,27,56,191,255,206,251,10,232,
224,233,146,13,29,64,38,6,104,46,133,0,32,62,151,1,191,255,208,182,
27,48,1,58,128,255,174,212,29,80,66,6,255,16,130,7,225,16,48,6,
8,4,141,0,99,135,1,0,3,48,0,66,0,74,128,255,22,200,10,56,
224,57,186,5,135,0,245,5,7,6,250,239,178,5,128,7,78,2,1,58,
64,63,174,176,229,87,64,0,224,7,96,1,32,103,217,176,10,232,12,110,
1,0,96,111,217,176,224,97,138,13,32,95,45,177,224,89,202,5,1,50,
128,255,106,2,29,248,255,47,32,0,181,45,128,87,175,176,224,81,242,37,
64,7,174,176,61,6,8,4,141,0,29,48,32,62,0,1,128,255,96,227,
32,135,61,177,224,129,146,13,38,6,116,46,133,0,32,62,97,1,0,66,
191,255,44,182,32,54,52,177,129,255,208,101,224,81,146,13,38,6,128,46,
133,0,32,62,178,1,0,66,191,255,16,182,99,239,1,0,229,87,64,0,
224,7,96,1,32,23,177,179,224,17,234,5,10,248,255,47,32,0,0,234,
149,13,34,127,61,0,2,232,10,248,96,127,177,179,255,47,32,0,224,233,
130,197,35,63,1,0,29,48,32,70,184,176,128,255,28,191,32,119,249,176,
32,111,245,176,10,56,7,6,0,240,96,119,181,176,96,111,177,176,178,5,
128,7,70,1,96,7,172,176,221,207,52,0,29,56,210,45,125,7,21,0,
253,87,9,0,61,22,24,0,98,7,1,0,61,22,32,0,61,55,49,0,
98,87,1,0,61,22,40,0,98,7,1,0,38,55,1,0,125,7,29,0,
125,7,37,0,0,218,191,255,198,215,224,81,162,13,221,223,54,0,210,5,
96,7,185,176,0,226,213,5,1,226,181,5,32,222,0,16,27,56,224,57,
186,77,213,53,61,22,24,0,98,7,1,0,61,22,32,0,61,55,49,0,
98,7,1,0,61,22,40,0,98,7,1,0,38,55,1,0,125,7,21,0,
125,7,29,0,125,7,37,0,191,255,200,217,224,81,226,21,128,87,105,177,
96,7,185,176,0,226,224,81,138,21,10,16,195,18,61,94,20,0,203,17,
34,23,1,0,224,17,162,5,65,226,65,82,99,82,198,245,165,5,1,226,
61,23,49,0,98,7,24,0,61,23,49,0,253,87,9,0,32,79,177,176,
32,71,181,176,34,111,21,0,32,63,185,176,29,48,202,105,98,111,21,0,
191,255,172,249,10,56,224,57,130,13,61,95,45,0,221,55,54,0,0,226,
107,63,12,0,61,255,45,0,28,216,229,87,64,0,224,7,96,1,63,231,
0,0,219,225,127,231,0,0,10,216,251,47,32,0,224,225,138,13,31,48,
63,87,5,0,63,6,68,98,0,0,106,0,61,55,49,0,38,55,1,0,
191,255,154,214,197,21,29,48,224,57,250,13,61,239,45,0,1,106,125,111,
0,0,191,255,22,247,125,87,12,0,29,48,31,58,128,255,56,210,181,5,
191,255,136,239,0,82,66,6,255,16,34,6,8,185,255,255,0,82,98,7,
1,0,98,7,5,0,98,7,17,0,98,7,9,0,98,7,13,0,2,22,
20,0,65,82,10,6,128,254,150,245,34,6,8,185,255,255,96,23,189,176,
2,134,236,29,96,135,213,176,64,7,174,176,96,7,217,176,127,0,33,6,
86,148,129,0,97,0,33,6,224,52,129,0,97,0,33,6,56,167,130,0,
97,0,33,6,84,167,130,0,97,0,128,7,97,0,38,6,64,28,141,0,
129,255,174,91,224,81,186,5,1,234,213,13,0,234,10,6,226,255,146,13,
38,6,140,46,133,0,32,62,32,1,0,66,191,255,180,179,29,80,64,6,
127,0,128,7,33,0,6,56,38,6,64,28,141,0,129,255,64,93,224,81,
226,87,0,0,64,6,63,0,191,7,178,255,132,7,225,48,32,239,169,182,
32,142,180,179,6,208,241,233,194,53,60,6,152,46,133,0,29,48,0,58,
3,64,128,255,178,0,224,81,242,5,28,48,32,62,187,0,0,66,191,255,
94,179,32,54,76,180,2,58,0,66,129,255,188,95,10,216,224,217,242,5,
28,48,32,62,194,0,0,66,191,255,64,179,26,48,191,255,144,255,35,63,
1,0,10,208,29,48,35,70,4,0,128,255,110,0,224,217,178,13,28,48,
32,62,203,0,0,66,191,255,26,179,197,5,191,255,106,255,10,208,26,80,
68,6,255,48,128,7,33,0,32,135,169,182,32,142,180,179,241,129,202,21,
32,127,61,177,97,122,146,13,38,6,164,46,133,0,32,62,98,0,0,66,
191,255,228,178,191,255,2,255,224,81,194,5,31,50,191,255,44,255,64,6,
63,0,38,6,64,28,141,0,39,6,176,46,133,0,0,66,128,7,12,0,
33,6,0,137,130,0,97,0,33,6,28,148,129,0,97,0,128,7,65,0,
4,23,124,142,4,135,125,142,99,18,178,5,224,129,210,13,2,232,224,7,
96,1,29,48,0,58,0,66,64,254,128,0,63,254,0,0,127,0,197,13,
2,232,224,7,96,1,29,56,0,66,0,74,64,254,16,0,63,254,2,0,
127,0,64,6,95,0,128,7,65,0,6,232,64,86,0,0,106,239,98,245,
64,6,95,0,64,86,0,0,42,87,2,253,202,0,202,0,127,0,64,86,
0,0,1,90,74,95,2,244,64,86,0,0,0,90,74,95,144,244,127,0,
64,86,0,0,0,90,74,95,2,244,64,86,0,0,0,90,74,95,144,244,
127,0,128,7,65,0,134,0,6,232,64,86,0,0,74,239,6,253,64,86,
0,0,0,90,74,95,144,244,64,6,95,0,134,0,224,49,154,13,64,86,
0,0,43,6,176,0,0,0,74,95,0,253,133,13,64,86,0,0,43,6,
208,0,0,0,74,95,0,253,64,86,0,0,0,90,74,95,144,244,127,0,
128,7,65,0,134,0,6,232,64,86,0,0,74,239,12,253,64,86,0,0,
0,90,74,95,144,244,64,6,95,0,64,86,0,0,43,6,128,0,0,0,
74,95,8,253,64,86,0,0,0,90,74,95,144,244,127,0,64,86,0,0,
10,87,8,253,138,0,138,0,127,0,128,7,193,16,6,216,64,86,0,0,
10,87,76,244,138,0,10,232,29,16,32,86,31,255,194,230,31,0,64,86,
0,0,74,231,76,244,64,86,0,0,10,87,12,244,138,0,91,87,0,0,
64,86,0,0,74,239,76,244,64,6,223,16,128,7,193,16,6,216,64,86,
0,0,10,87,74,244,138,0,10,232,29,16,32,86,159,255,194,230,159,0,
64,86,0,0,74,231,74,244,64,86,0,0,10,87,10,244,138,0,91,87,
0,0,64,86,0,0,74,239,74,244,64,6,223,16,64,86,0,0,43,6,
32,0,0,0,74,95,10,244,64,86,0,0,43,6,40,0,0,0,74,95,
10,244,127,0,64,86,0,4,5,90,74,95,142,3,127,0,128,7,33,0,
64,86,0,0,0,90,74,95,14,244,5,50,191,255,214,180,64,86,0,0,
43,6,28,0,0,0,74,95,14,244,64,6,63,0,128,7,65,0,64,86,
0,0,10,87,32,250,138,0,32,22,111,255,202,238,111,0,64,86,0,0,
74,239,32,250,0,18,65,18,2,6,156,255,214,253,64,86,0,0,43,6,
144,0,0,0,74,95,32,250,228,23,133,142,32,238,162,0,226,239,192,2,
64,86,0,0,106,239,34,250,64,86,0,0,43,6,242,0,0,0,74,95,
32,250,64,6,95,0,128,7,97,0,128,255,196,7,68,7,88,137,229,87,
64,0,224,7,96,1,10,232,64,86,0,0,42,87,128,244,202,0,32,22,
127,255,202,254,127,255,64,86,0,0,106,255,128,244,64,86,0,0,42,87,
166,244,202,0,34,6,255,127,255,255,202,254,255,127,64,86,0,0,106,255,
166,244,64,86,0,0,42,87,128,244,202,0,138,254,128,0,64,86,0,0,
106,255,128,244,64,86,0,0,43,6,5,128,0,0,106,95,166,244,64,86,
0,0,43,6,160,32,0,0,106,95,164,244,64,86,0,0,42,87,164,244,
202,0,137,82,169,253,8,138,100,143,132,142,64,86,0,0,0,90,74,95,
252,241,64,86,0,0,0,90,74,95,44,248,0,0,0,0,0,0,0,0,
0,0,228,23,133,142,128,254,27,183,226,255,192,2,64,86,0,0,106,255,
82,245,191,255,224,254,29,248,255,47,32,0,64,6,127,0,128,7,33,0,
64,86,0,0,202,63,14,244,64,86,0,0,0,90,74,95,144,244,38,6,
160,134,1,0,191,255,118,179,64,86,0,0,202,191,14,244,64,86,0,0,
0,90,74,95,144,244,64,6,63,0,64,86,0,0,10,87,224,240,138,0,
202,86,128,0,127,0,128,7,193,48,6,208,154,0,26,232,64,86,0,0,
74,239,2,242,0,226,0,218,64,86,0,0,10,87,0,242,138,0,138,238,
128,0,64,86,0,0,74,239,0,242,61,6,64,13,3,0,64,86,0,0,
10,87,0,242,138,0,135,82,177,5,95,234,138,253,61,6,64,13,3,0,
64,86,0,0,10,87,0,242,138,0,135,82,185,5,95,234,138,253,64,86,
0,0,10,87,0,242,138,0,32,22,127,255,202,238,127,0,64,86,0,0,
74,239,0,242,26,16,193,18,2,238,16,242,61,87,1,0,202,225,65,218,
100,218,246,197,28,128,191,130,158,130,208,225,130,226,220,0,28,80,202,0,
64,6,223,48,128,7,193,48,6,224,7,232,221,0,224,233,194,61,28,215,
0,0,65,226,95,234,221,0,224,233,178,5,95,234,221,0,64,86,0,0,
10,87,16,248,138,0,32,22,127,255,202,222,127,0,64,86,0,0,74,223,
16,248,28,16,144,18,194,222,255,15,64,86,0,0,106,223,130,240,64,86,
0,0,106,231,128,240,64,86,0,0,106,239,192,240,64,86,0,0,10,87,
224,240,138,0,64,86,0,0,10,87,224,240,138,0,138,238,1,0,64,86,
0,0,74,239,224,240,26,232,64,86,0,0,74,239,40,250,64,6,223,48,
128,7,65,0,4,143,88,137,6,232,189,0,99,138,194,13,64,86,0,0,
10,87,36,250,138,0,136,82,161,253,64,86,0,0,74,239,40,250,64,6,
95,0,128,7,65,0,229,87,64,0,224,7,96,1,10,232,64,86,0,0,
42,87,112,240,202,0,224,81,170,253,64,86,0,0,3,90,106,95,112,240,
64,86,0,0,42,87,112,240,202,0,224,81,170,253,253,47,32,0,64,6,
95,0,191,7,196,255,128,7,33,0,128,255,28,5,32,254,116,241,223,55,
0,0,64,86,0,0,0,90,74,95,144,244,32,254,116,241,223,191,0,0,
64,86,0,0,0,90,74,95,144,244,32,254,118,241,223,55,0,0,64,86,
0,0,0,90,74,95,144,244,32,254,118,241,223,191,0,0,64,86,0,0,
0,90,74,95,144,244,32,254,146,241,223,55,0,0,64,86,0,0,0,90,
74,95,144,244,32,254,146,241,223,191,0,0,64,86,0,0,0,90,74,95,
144,244,32,254,32,241,223,55,0,0,64,86,0,0,0,90,74,95,144,244,
32,254,32,241,223,191,0,0,64,86,0,0,0,90,74,95,144,244,32,254,
34,241,223,55,0,0,64,86,0,0,0,90,74,95,144,244,32,254,34,241,
223,191,0,0,64,86,0,0,0,90,74,95,144,244,32,254,36,241,223,55,
0,0,64,86,0,0,0,90,74,95,144,244,32,254,36,241,223,191,0,0,
64,86,0,0,0,90,74,95,144,244,32,254,38,241,223,55,0,0,64,86,
0,0,0,90,74,95,144,244,32,254,38,241,223,191,0,0,64,86,0,0,
0,90,74,95,144,244,32,254,40,241,223,55,0,0,64,86,0,0,0,90,
74,95,144,244,32,254,40,241,223,191,0,0,64,86,0,0,0,90,74,95,
144,244,32,254,174,241,223,55,0,0,64,86,0,0,0,90,74,95,144,244,
32,254,174,241,223,191,0,0,64,86,0,0,0,90,74,95,144,244,32,254,
30,241,223,55,0,0,64,86,0,0,0,90,74,95,144,244,32,254,30,241,
223,191,0,0,64,86,0,0,0,90,74,95,144,244,191,255,154,249,64,6,
63,0,128,7,193,48,32,238,119,34,32,230,119,119,128,222,163,255,128,214,
175,255,64,86,0,0,106,239,132,244,28,232,64,86,0,0,106,239,134,244,
27,232,64,86,0,0,106,239,136,244,26,232,64,86,0,0,106,239,138,244,
64,6,223,48,128,7,33,0,64,86,0,0,0,90,74,95,252,241,64,86,
0,0,1,90,74,95,44,248,0,0,0,0,0,0,0,0,0,0,64,86,
0,0,42,87,128,244,202,0,32,22,127,255,202,254,127,255,64,86,0,0,
106,255,128,244,64,86,0,0,42,87,166,244,202,0,34,6,255,127,255,255,
202,254,255,127,64,86,0,0,106,255,166,244,64,86,0,0,42,87,128,244,
202,0,138,254,128,0,64,86,0,0,106,255,128,244,64,86,0,0,43,6,
9,129,0,0,106,95,166,244,64,86,0,0,43,6,160,32,0,0,106,95,
164,244,64,86,0,0,42,87,164,244,202,0,137,82,169,253,64,86,0,0,
4,90,74,95,106,240,64,86,0,0,0,90,106,95,144,244,64,86,0,0,
0,90,106,95,146,244,0,50,191,255,10,255,64,86,0,0,43,6,224,0,
0,0,74,95,76,244,64,86,0,0,0,90,74,95,108,244,64,86,0,0,
0,90,74,95,44,252,64,86,0,0,43,6,224,0,0,0,74,95,12,252,
64,86,0,0,43,6,28,0,0,0,74,95,14,244,64,86,0,0,0,90,
74,95,78,244,64,86,0,0,43,6,99,0,0,0,74,95,46,244,64,86,
0,0,43,6,23,0,0,0,74,95,74,244,64,86,0,0,43,6,215,0,
0,0,74,95,42,244,64,86,0,0,0,90,74,95,106,244,64,86,0,0,
0,90,74,95,42,252,64,86,0,0,7,90,74,95,10,252,64,86,0,0,
43,6,40,0,0,0,74,95,10,244,64,86,0,0,43,6,16,0,0,0,
74,95,0,242,64,86,0,0,2,90,74,95,1,242,64,86,0,0,43,6,
199,0,0,0,74,95,68,244,64,86,0,0,43,6,199,0,0,0,74,95,
100,244,64,86,0,0,43,6,249,0,0,0,74,95,36,244,64,86,0,0,
43,6,144,0,0,0,74,95,32,250,64,86,0,0,43,6,162,0,0,0,
106,95,34,250,64,86,0,0,43,6,242,0,0,0,74,95,32,250,64,86,
0,0,43,6,62,0,0,0,74,95,16,248,64,86,0,0,43,6,32,0,
0,0,106,95,208,240,64,86,0,0,43,6,255,15,0,0,106,95,134,240,
64,86,0,0,43,6,40,250,0,0,106,95,132,240,32,254,146,241,223,191,
0,0,64,86,0,0,0,90,74,95,144,244,32,254,146,241,223,183,0,0,
64,86,0,0,0,90,74,95,144,244,32,254,174,241,223,191,0,0,64,86,
0,0,0,90,74,95,144,244,32,254,174,241,223,183,0,0,64,86,0,0,
0,90,74,95,144,244,64,86,0,0,1,90,74,95,84,245,128,254,27,183,
1,138,209,22,255,255,226,255,192,2,100,143,132,142,64,86,0,0,106,255,
82,245,32,254,116,241,223,191,0,0,64,86,0,0,0,90,74,95,144,244,
32,254,116,241,223,183,0,0,64,86,0,0,0,90,74,95,144,244,64,86,
0,0,43,6,35,0,0,0,74,95,84,245,64,86,0,0,1,90,74,95,
100,245,32,254,118,241,223,191,0,0,64,86,0,0,0,90,74,95,144,244,
32,254,118,241,223,183,0,0,64,86,0,0,0,90,74,95,144,244,64,86,
0,0,43,6,113,0,0,0,74,95,100,245,64,86,0,0,0,90,74,95,
40,240,64,86,0,0,43,6,143,0,0,0,74,95,72,240,64,86,0,0,
43,6,32,0,0,0,74,95,8,240,64,86,0,0,10,87,8,240,138,0,
138,254,16,0,64,86,0,0,74,255,8,240,64,86,0,0,1,90,74,95,
2,244,64,86,0,0,43,6,240,0,0,0,74,95,34,244,64,86,0,0,
2,90,74,95,98,244,64,86,0,0,43,6,56,0,0,0,74,95,1,253,
64,86,0,0,43,6,144,0,0,0,74,95,0,253,64,86,0,0,8,90,
74,95,9,253,64,86,0,0,14,90,74,95,66,244,64,6,63,0,33,6,
134,42,130,0,97,0,130,7,225,240,6,192,7,224,8,200,64,150,255,255,
82,233,0,218,0,210,197,117,60,126,16,0,218,121,47,111,1,0,224,105,
178,109,60,102,16,0,218,97,44,87,1,0,42,23,105,0,2,22,184,0,
34,63,0,0,202,57,34,87,5,0,63,6,126,110,0,0,3,48,25,64,
106,0,35,95,1,0,11,120,239,0,224,121,146,85,64,150,255,255,29,112,
82,233,238,0,15,113,206,102,255,255,12,233,29,104,221,86,255,255,176,90,
11,136,28,23,7,0,208,138,17,81,10,232,2,6,17,0,129,13,2,6,
33,0,226,29,2,6,81,0,178,53,197,53,123,18,210,45,119,18,130,45,
2,6,17,0,218,45,60,23,105,0,2,22,176,1,34,55,0,0,34,135,
5,0,63,6,236,110,0,0,220,49,112,0,251,81,234,29,157,238,2,0,
181,29,60,23,105,0,2,22,176,1,34,55,0,0,34,111,5,0,63,6,
16,111,0,0,220,49,109,0,251,81,202,13,157,238,4,0,149,13,157,238,
8,0,229,5,157,238,16,0,181,5,157,238,32,0,68,210,65,218,60,103,
4,0,236,217,166,141,120,239,1,0,24,80,66,6,255,240,132,7,225,240,
7,200,0,234,6,216,129,255,232,63,10,192,127,194,178,69,0,226,1,210,
27,56,29,64,3,48,191,255,212,254,195,207,0,0,3,143,0,0,226,135,
0,0,81,129,129,130,217,5,26,96,253,103,192,0,12,225,65,234,29,6,
240,255,182,237,28,48,198,0,35,62,4,0,129,255,140,45,10,232,35,87,
5,0,42,88,75,225,242,5,24,48,28,56,128,255,118,27,0,234,149,29,
224,201,242,21,229,87,64,0,224,7,96,1,32,142,41,1,121,143,12,0,
249,135,19,0,35,127,5,0,10,248,15,129,121,135,18,0,255,47,32,0,
25,48,31,58,128,255,210,196,29,80,68,6,255,240,130,7,225,16,6,232,
29,135,7,0,221,63,2,0,119,130,154,29,61,87,97,0,61,95,101,0,
61,23,105,0,31,58,125,87,89,0,125,95,93,0,2,22,200,0,34,55,
0,0,34,127,5,0,31,66,3,72,221,49,63,6,32,112,0,0,111,0,
0,218,0,226,197,29,61,118,16,0,220,113,46,103,1,0,224,97,178,21,
61,94,16,0,220,89,43,87,1,0,42,23,105,0,2,22,232,1,34,55,
0,0,34,135,5,0,63,6,88,112,0,0,202,49,112,0,68,226,65,218,
61,127,4,0,239,217,166,229,66,6,255,16,130,7,225,112,6,224,7,208,
0,202,0,218,0,234,181,61,60,142,16,0,221,137,49,127,1,0,224,121,
162,53,60,118,16,0,221,113,46,87,1,0,42,23,105,0,26,64,2,22,
184,0,34,63,0,0,34,103,5,0,3,48,63,6,174,112,0,0,202,57,
108,0,35,23,1,0,129,18,169,29,60,142,16,0,29,80,209,81,42,23,
1,0,209,233,34,23,105,0,61,87,1,0,2,22,224,1,34,55,0,0,
34,127,5,0,26,56,63,6,228,112,0,0,202,49,111,0,10,200,245,5,
68,234,65,218,60,119,4,0,238,217,182,197,25,80,66,6,255,112,128,7,
225,240,6,216,7,200,8,192,9,208,0,234,0,226,197,37,59,142,16,0,
220,137,49,127,1,0,224,121,178,29,59,118,16,0,220,113,46,87,1,0,
42,23,105,0,25,56,24,64,2,22,80,1,34,55,0,0,34,103,5,0,
26,72,63,6,68,113,0,0,202,49,108,0,122,239,1,0,10,16,224,17,
250,5,68,226,65,234,59,87,4,0,234,233,166,221,2,80,64,6,255,240,
128,7,225,240,6,216,7,200,185,0,8,192,9,208,0,18,0,234,0,226,
245,37,59,142,16,0,220,137,49,127,1,0,224,121,226,29,59,118,16,0,
220,113,46,87,1,0,25,96,42,23,105,0,12,56,24,64,2,22,216,1,
34,55,0,0,34,95,5,0,26,72,63,6,176,113,0,0,202,49,107,0,
10,16,10,6,224,254,202,5,122,239,1,0,245,5,68,226,65,234,59,143,
4,0,241,233,246,213,2,80,64,6,255,240,128,7,225,240,6,216,7,200,
185,0,8,192,9,208,0,18,0,234,0,226,245,37,59,142,16,0,220,137,
49,127,1,0,224,121,226,29,59,118,16,0,220,113,46,87,1,0,25,96,
42,23,105,0,12,56,24,64,2,22,200,0,34,55,0,0,34,95,5,0,
26,72,63,6,32,114,0,0,202,49,107,0,10,16,10,6,224,254,202,5,
122,239,1,0,245,5,68,226,65,234,59,143,4,0,241,233,246,213,2,80,
64,6,255,240,128,7,225,48,6,216,32,214,255,127,0,226,0,234,245,29,
59,142,16,0,221,137,49,127,1,0,224,121,226,21,59,118,16,0,221,113,
46,87,1,0,42,23,105,0,2,22,208,1,34,55,0,0,34,103,5,0,
63,6,130,114,0,0,202,49,108,0,234,209,167,5,10,208,68,234,65,226,
59,95,4,0,235,225,246,221,26,80,64,6,255,48,128,7,225,48,6,216,
32,214,255,127,0,226,0,234,245,29,59,142,16,0,221,137,49,127,1,0,
224,121,226,21,59,118,16,0,221,113,46,87,1,0,42,23,105,0,2,22,
200,1,34,55,0,0,34,103,5,0,63,6,220,114,0,0,202,49,108,0,
234,209,167,5,10,208,68,234,65,226,59,95,4,0,235,225,246,221,26,80,
64,6,255,48,128,7,225,16,6,224,0,218,0,234,181,61,60,142,16,0,
221,137,49,127,1,0,224,121,162,53,60,118,16,0,221,113,46,87,1,0,
42,23,105,0,2,22,192,1,34,55,0,0,34,103,5,0,63,6,50,115,
0,0,202,49,108,0,60,94,16,0,221,89,43,143,1,0,224,137,194,21,
60,134,16,0,221,129,48,87,1,0,42,23,105,0,2,22,168,1,34,55,
0,0,34,119,5,0,3,58,63,6,102,115,0,0,202,49,110,0,60,110,
16,0,221,105,109,7,1,0,68,234,65,218,60,95,4,0,235,217,182,197,
64,6,255,16,128,7,33,0,224,49,138,13,32,54,108,0,128,255,146,23,
10,48,224,49,178,45,48,6,220,25,134,0,102,135,105,0,102,7,85,0,
102,7,81,0,70,7,3,0,102,7,4,0,70,7,1,0,70,7,0,0,
70,7,7,0,102,7,89,0,102,7,93,0,1,82,0,18,102,87,97,0,
102,7,101,0,102,87,8,0,102,87,14,0,38,86,16,0,106,7,1,0,
68,82,65,18,2,6,240,255,166,253,6,80,64,6,63,0,128,7,225,16,
134,0,60,6,204,27,134,0,59,6,188,29,134,0,6,16,106,18,169,13,
97,18,177,29,194,45,98,18,194,61,101,18,226,61,128,7,100,1,109,18,
249,5,107,18,185,5,128,7,16,1,194,85,229,101,109,18,162,117,111,18,
146,69,2,6,224,255,186,5,128,7,32,1,128,7,62,1,32,54,116,0,
128,255,218,22,10,232,224,233,146,13,29,48,191,255,48,255,49,6,140,35,
134,0,125,143,105,0,29,80,128,7,40,1,32,54,140,0,128,255,182,22,
10,232,224,233,146,13,29,48,191,255,12,255,48,6,124,37,134,0,125,135,
105,0,29,80,128,7,4,1,0,50,128,255,96,161,213,125,32,54,208,0,
128,255,138,22,10,232,224,233,146,13,29,48,191,255,224,254,47,6,28,40,
134,0,125,127,105,0,29,80,197,109,32,54,124,0,128,255,104,22,10,232,
224,233,226,5,29,48,191,255,190,254,125,231,105,0,29,80,229,93,32,54,
128,0,128,255,76,22,10,232,224,233,178,13,29,48,191,255,162,254,46,6,
172,31,134,0,125,119,105,0,125,7,125,0,29,80,181,77,32,54,124,0,
128,255,38,22,10,232,224,233,226,5,29,48,191,255,124,254,125,223,105,0,
29,80,213,61,32,54,124,0,128,255,10,22,10,232,224,233,146,13,29,48,
191,255,96,254,45,6,156,33,134,0,125,111,105,0,29,80,197,45,32,54,
132,0,128,255,232,21,10,232,224,233,178,13,29,48,191,255,62,254,125,7,
125,0,43,6,12,42,134,0,125,95,105,0,29,80,149,29,32,54,120,0,
128,255,194,21,10,232,224,233,146,13,29,48,191,255,24,254,42,6,236,45,
134,0,125,87,105,0,29,80,133,13,6,56,38,6,72,49,133,0,191,255,
152,176,0,82,64,6,255,16,132,7,225,243,99,63,5,0,7,143,1,0,
6,232,93,71,0,0,93,143,6,0,7,135,5,0,93,135,7,0,7,127,
0,0,93,79,1,0,125,127,4,0,7,119,19,0,15,56,7,6,240,255,
93,119,2,0,167,13,38,6,116,49,133,0,191,255,78,176,125,7,4,0,
0,82,133,93,1,194,1,226,0,186,0,218,9,176,197,61,35,151,5,0,
61,206,16,0,252,214,20,0,210,209,186,55,1,0,219,201,191,255,248,253,
121,87,1,0,61,134,16,0,219,129,48,23,1,0,224,17,178,61,61,118,
16,0,219,113,46,87,1,0,42,23,105,0,29,103,0,0,35,159,45,0,
2,22,136,0,34,55,0,0,99,159,1,0,65,98,26,56,202,49,34,87,
5,0,12,64,22,72,63,6,70,118,0,0,106,0,234,0,202,225,252,0,
224,81,186,5,10,192,184,0,68,218,65,178,65,186,61,127,4,0,239,185,
166,197,224,193,242,13,61,23,105,0,2,22,184,1,34,55,0,0,34,111,
5,0,63,6,128,118,0,0,221,49,109,0,165,5,0,226,28,80,68,6,
255,243,130,7,225,112,6,216,7,200,31,210,0,234,0,226,197,37,59,142,
16,0,220,137,49,127,1,0,224,121,178,29,59,118,16,0,220,113,46,87,
1,0,42,23,105,0,25,64,2,22,184,0,34,63,0,0,34,103,5,0,
3,48,63,6,208,118,0,0,202,57,108,0,35,23,1,0,129,18,185,5,
29,208,245,5,68,226,65,234,59,87,4,0,234,233,166,221,26,80,66,6,
255,112,130,7,225,240,6,216,7,192,1,210,1,202,0,226,0,234,245,37,
59,142,16,0,221,137,49,127,1,0,224,121,226,29,59,118,16,0,221,113,
46,87,1,0,42,23,105,0,2,22,160,1,34,55,0,0,34,103,5,0,
3,56,63,6,52,119,0,0,202,49,108,0,224,81,170,5,10,208,35,23,
1,0,224,17,202,5,2,200,0,210,245,5,68,234,65,226,59,95,4,0,
235,225,246,213,120,207,1,0,26,80,66,6,255,240,128,7,225,112,6,216,
7,200,185,0,8,208,186,0,123,210,146,13,119,210,242,5,26,6,33,0,
194,5,26,6,81,0,250,37,0,226,0,234,133,37,59,110,16,0,221,105,
45,95,1,0,224,89,242,21,59,86,16,0,221,81,42,87,1,0,25,128,
42,23,105,0,16,56,26,120,2,22,152,1,34,55,0,0,34,119,5,0,
15,64,63,6,192,119,0,0,202,49,110,0,68,234,65,226,59,111,4,0,
237,225,230,221,64,6,255,112,128,7,225,48,6,224,7,208,252,209,186,5,
1,82,245,37,0,218,0,234,245,29,60,142,16,0,221,137,49,127,1,0,
224,121,226,21,60,118,16,0,221,113,46,87,1,0,42,23,105,0,2,22,
144,1,34,55,0,0,34,103,5,0,26,56,63,6,26,120,0,0,202,49,
108,0,97,82,130,229,68,234,65,218,60,95,4,0,235,217,246,221,0,82,
64,6,255,48,132,7,225,243,7,200,99,71,5,0,6,192,8,56,191,255,
76,254,10,184,224,185,230,21,57,135,18,0,56,95,101,0,57,223,13,0,
56,87,97,0,16,176,57,215,9,0,235,217,193,5,139,13,234,209,233,5,
56,23,8,0,2,120,239,129,198,5,32,86,34,1,197,85,191,122,26,80,
2,96,234,23,34,10,27,16,250,127,32,2,236,23,32,2,1,80,22,232,
202,17,194,121,26,80,236,87,32,2,191,234,22,224,202,225,225,95,0,0,
194,186,56,110,16,0,215,105,45,71,1,0,203,233,207,233,40,71,14,0,
28,48,29,56,0,74,99,71,1,0,191,255,56,196,121,87,9,0,121,95,
13,0,35,71,1,0,0,74,28,48,29,56,128,255,78,18,121,87,18,0,
56,86,16,0,23,88,202,89,43,23,1,0,202,185,34,23,105,0,55,87,
1,0,35,71,5,0,2,22,136,1,34,55,0,0,34,127,5,0,25,56,
63,6,18,121,0,0,202,49,111,0,121,215,9,0,121,223,13,0,121,183,
18,0,68,6,255,243,134,7,225,243,7,200,99,71,5,0,99,79,9,0,
6,192,8,56,191,255,86,253,10,184,224,185,230,21,57,135,18,0,56,95,
101,0,57,223,13,0,56,87,97,0,16,176,57,215,9,0,235,217,193,5,
139,13,234,209,233,5,56,23,8,0,2,120,239,129,182,5,0,82,229,85,
191,122,26,80,2,96,234,23,34,10,27,16,250,127,32,2,236,23,32,2,
1,80,22,232,202,17,194,121,26,80,236,87,32,2,191,234,22,224,202,225,
225,95,0,0,194,186,56,110,16,0,215,105,45,71,1,0,203,233,207,233,
40,71,14,0,28,48,29,56,0,74,99,71,1,0,191,255,68,195,121,87,
9,0,121,95,13,0,35,71,1,0,0,74,28,48,29,56,128,255,90,17,
121,87,18,0,56,86,16,0,23,88,202,89,43,23,1,0,202,185,34,23,
105,0,55,87,1,0,35,71,5,0,35,79,9,0,2,22,128,1,34,55,
0,0,34,127,5,0,25,56,63,6,10,122,0,0,202,49,111,0,121,183,
18,0,121,215,9,0,121,223,13,0,70,6,255,243,130,7,225,240,7,192,
56,143,18,0,6,224,8,200,32,214,34,1,97,138,194,5,32,86,34,1,
213,69,0,218,0,234,213,61,60,134,16,0,221,129,48,119,1,0,224,113,
194,53,60,110,16,0,221,105,45,87,1,0,42,23,105,0,25,64,2,22,
184,0,34,63,0,0,34,95,5,0,3,48,63,6,114,122,0,0,202,57,
107,0,35,23,1,0,129,18,201,29,60,134,16,0,29,136,208,137,49,23,
1,0,221,129,34,23,105,0,48,87,1,0,24,56,2,22,96,1,34,55,
0,0,34,119,5,0,25,64,63,6,170,122,0,0,202,49,110,0,10,208,
224,209,242,5,68,234,65,218,60,103,4,0,236,217,150,197,26,80,66,6,
255,240,130,7,225,241,7,192,56,143,18,0,6,224,8,200,9,184,97,138,
194,5,32,86,37,1,133,77,32,214,34,1,0,218,0,234,229,61,60,134,
16,0,221,129,48,119,1,0,224,113,210,53,60,110,16,0,221,105,45,87,
1,0,42,23,105,0,25,64,2,22,184,0,34,63,0,0,34,95,5,0,
3,48,63,6,28,123,0,0,202,57,107,0,35,23,1,0,129,18,217,29,
60,134,16,0,29,136,208,137,49,23,1,0,221,129,34,23,105,0,48,87,
1,0,24,56,25,64,2,22,88,1,34,55,0,0,34,119,5,0,23,72,
63,6,86,123,0,0,202,49,110,0,10,208,224,209,250,5,68,234,65,218,
60,103,4,0,236,217,134,197,26,80,66,6,255,241,128,7,225,16,6,224,
220,143,2,0,0,234,0,218,197,29,60,142,16,0,221,137,49,127,1,0,
224,121,178,21,60,118,16,0,221,113,46,87,1,0,42,23,105,0,2,22,
32,1,34,55,0,0,34,103,5,0,63,6,176,123,0,0,202,49,108,0,
68,234,65,218,60,95,4,0,235,217,166,229,64,6,255,16,128,7,33,0,
38,79,101,0,38,71,97,0,9,88,8,80,10,120,11,121,194,21,38,95,
93,0,38,55,89,0,202,90,6,56,150,58,11,57,202,50,224,73,250,5,
224,57,218,5,6,80,232,87,194,2,181,5,191,255,2,193,64,6,63,0,
128,7,193,48,6,232,8,208,9,216,229,87,64,0,224,7,96,1,29,111,
7,0,10,224,123,106,146,13,119,106,242,5,13,6,33,0,194,5,13,6,
81,0,250,29,61,111,93,0,61,103,89,0,61,95,101,0,204,209,225,23,
0,0,219,17,205,17,125,215,89,0,125,23,93,0,61,111,93,0,61,23,
89,0,61,87,97,0,235,105,129,13,187,5,234,17,209,5,125,87,89,0,
125,95,93,0,252,47,32,0,64,6,223,48,128,7,193,112,6,232,7,200,
229,87,64,0,224,7,96,1,10,224,61,223,93,0,61,215,89,0,252,47,
32,0,29,111,7,0,27,72,26,64,123,106,194,13,119,106,162,13,13,6,
33,0,242,5,13,6,81,0,194,5,0,82,0,90,165,13,61,87,97,0,
61,111,101,0,168,81,225,95,0,0,141,89,169,89,121,87,1,0,121,95,
5,0,8,80,9,88,64,6,223,112,128,7,225,16,6,232,61,23,105,0,
7,224,2,22,200,1,34,55,0,0,34,143,5,0,8,216,63,6,246,124,
0,0,221,49,113,0,124,87,1,0,10,6,1,128,218,5,32,126,0,2,
124,127,1,0,61,23,105,0,2,22,208,1,34,55,0,0,34,119,5,0,
63,6,34,125,0,0,221,49,110,0,123,87,1,0,10,6,1,128,218,5,
32,102,0,2,123,103,1,0,64,6,255,16,134,7,225,48,6,224,60,23,
105,0,7,216,2,22,160,1,34,55,0,0,34,135,5,0,3,56,63,6,
92,125,0,0,220,49,112,0,35,127,1,0,224,121,202,5,32,86,35,1,
149,93,31,82,31,90,123,87,1,0,123,95,5,0,0,210,0,234,181,77,
60,118,16,0,221,113,46,103,1,0,224,97,162,69,60,94,16,0,221,89,
43,87,1,0,42,23,105,0,2,22,16,1,34,55,0,0,34,135,5,0,
35,62,4,0,63,6,178,125,0,0,202,49,112,0,224,81,178,29,60,118,
16,0,29,120,206,121,47,23,1,0,221,113,34,23,105,0,46,87,1,0,
2,22,24,0,34,55,0,0,34,103,5,0,63,6,226,125,0,0,202,49,
108,0,99,87,5,0,99,95,9,0,35,111,9,0,59,127,5,0,59,119,
1,0,35,103,5,0,239,105,139,13,177,5,238,97,217,5,123,103,1,0,
123,111,5,0,68,234,65,210,60,119,4,0,238,209,182,181,0,82,70,6,
255,48,132,7,225,243,6,232,7,184,8,176,31,210,31,218,0,202,0,226,
213,37,61,134,16,0,220,129,48,119,1,0,224,113,194,29,61,110,16,0,
220,105,45,87,1,0,42,23,105,0,2,22,24,0,34,55,0,0,34,95,
5,0,63,6,100,126,0,0,202,49,107,0,10,96,11,104,251,105,235,5,
177,5,250,97,185,5,12,208,13,216,68,226,65,202,61,111,4,0,237,201,
150,221,32,198,35,1,0,202,0,226,213,85,61,102,16,0,220,97,44,87,
1,0,224,81,194,77,29,135,7,0,16,6,17,0,250,69,61,23,105,0,
2,22,176,1,34,55,0,0,34,127,5,0,63,6,190,126,0,0,221,49,
111,0,234,201,138,61,61,110,16,0,28,112,205,113,46,23,1,0,28,80,
205,81,34,23,105,0,42,87,1,0,23,56,2,22,8,1,34,55,0,0,
99,215,1,0,99,223,5,0,34,95,5,0,202,49,22,64,63,6,252,126,
0,0,107,0,10,16,224,81,202,21,61,23,105,0,32,134,223,255,2,22,
184,1,34,55,0,0,34,127,5,0,93,135,7,0,63,6,36,127,0,0,
221,49,111,0,0,194,181,13,2,6,221,254,162,5,2,192,68,226,65,202,
61,111,4,0,237,201,150,173,24,80,68,6,255,243,130,7,225,0,6,232,
61,23,105,0,7,224,28,64,2,22,184,0,34,63,0,0,34,143,5,0,
3,48,63,6,104,127,0,0,221,57,113,0,35,23,1,0,194,134,1,0,
194,5,222,18,159,18,202,5,32,86,33,1,245,13,61,23,105,0,2,22,
224,1,34,55,0,0,34,119,5,0,28,56,63,6,154,127,0,0,221,49,
110,0,66,6,255,0,128,7,225,112,6,232,29,23,7,0,2,6,17,0,
209,13,224,17,146,53,2,6,81,0,162,45,2,6,65,0,178,37,2,6,
33,0,194,29,181,45,127,18,146,13,123,18,178,13,119,18,210,13,2,6,
17,0,226,13,149,37,38,6,192,49,133,0,133,37,38,6,204,49,133,0,
197,29,38,6,216,49,133,0,133,29,38,6,228,49,133,0,197,21,38,6,
240,49,133,0,133,21,38,6,168,49,133,0,197,13,38,6,252,49,133,0,
133,13,38,6,8,50,133,0,197,5,38,6,20,50,133,0,191,255,250,165,
157,23,7,0,101,18,249,5,97,18,225,13,178,21,98,18,194,21,229,29,
101,18,178,13,2,6,224,255,162,21,2,6,192,255,178,21,213,21,37,54,
112,130,213,21,37,54,120,130,165,21,37,54,88,130,245,13,38,6,32,50,
133,0,181,13,38,6,60,50,133,0,245,5,37,54,96,130,197,5,38,6,
180,49,133,0,191,255,162,165,29,63,1,0,37,54,104,130,135,0,191,255,
148,165,61,23,105,0,2,22,24,0,34,55,0,0,34,119,5,0,63,6,
164,128,0,0,221,49,110,0,10,64,11,72,38,6,72,50,133,0,32,62,
32,0,191,255,104,165,29,48,191,255,8,251,228,87,76,2,38,6,44,50,
133,0,10,56,10,96,191,98,150,98,204,57,170,58,191,255,72,165,29,63,
2,0,38,6,84,50,133,0,222,58,159,58,191,255,54,165,0,202,0,210,
197,77,61,134,16,0,218,129,48,119,1,0,224,113,178,69,0,226,245,5,
27,56,37,54,128,130,191,255,20,165,65,226,29,111,0,0,36,223,93,136,
237,225,215,245,61,23,105,0,2,22,176,1,34,55,0,0,34,103,5,0,
63,6,50,129,0,0,221,49,108,0,234,201,186,13,29,23,7,0,2,6,
17,0,194,5,2,6,33,0,186,5,36,223,89,136,27,56,37,54,128,130,
191,255,202,164,61,86,16,0,26,88,202,89,43,23,1,0,218,81,34,23,
105,0,42,87,1,0,2,22,240,0,34,55,0,0,34,127,5,0,63,6,
128,129,0,0,202,49,111,0,68,210,65,202,61,119,4,0,238,201,166,181,
64,6,255,112,128,7,225,112,6,232,157,135,7,0,7,208,61,119,4,0,
61,23,105,0,90,135,1,0,29,127,7,0,90,119,0,0,2,22,176,1,
34,103,5,0,90,127,5,0,29,111,1,0,34,55,0,0,63,6,210,129,
0,0,90,111,4,0,221,49,108,0,61,95,10,0,90,87,3,0,90,95,
2,0,61,95,93,0,61,87,89,0,122,87,9,0,61,95,93,0,61,87,
89,0,29,48,122,95,13,0,191,255,200,249,58,23,6,0,202,86,255,127,
32,142,0,128,81,17,10,17,61,87,85,0,122,23,6,0,26,135,7,0,
224,81,234,23,0,0,208,134,127,0,194,126,1,0,199,122,15,129,90,135,
7,0,29,119,2,0,122,7,16,0,90,7,18,0,1,226,90,119,19,0,
0,202,0,218,165,37,61,110,16,0,219,105,45,95,1,0,224,89,146,29,
61,86,16,0,219,81,42,87,1,0,252,126,20,0,42,23,105,0,15,56,
2,22,232,0,34,55,0,0,34,111,5,0,218,57,63,6,128,130,0,0,
202,49,109,0,202,225,252,0,68,218,65,202,61,103,4,0,236,201,198,221,
28,80,64,6,255,112,128,7,225,48,6,216,1,210,0,226,0,234,213,29,
59,142,16,0,221,137,49,127,1,0,224,121,194,21,59,118,16,0,221,113,
46,87,1,0,42,23,105,0,2,22,224,0,34,55,0,0,34,103,5,0,
63,6,214,130,0,0,202,49,108,0,202,209,68,234,65,226,59,95,4,0,
235,225,150,229,26,80,64,6,255,48,128,7,225,240,6,232,7,200,57,199,
1,0,128,255,220,174,49,6,68,205,1,0,106,143,5,0,106,199,9,0,
121,87,1,0,0,210,0,218,0,226,133,61,61,134,16,0,220,129,48,119,
1,0,224,113,242,45,29,111,7,0,13,6,17,0,138,21,61,23,105,0,
2,22,176,1,34,55,0,0,34,103,5,0,63,6,70,131,0,0,221,49,
108,0,251,81,178,29,61,86,16,0,28,88,202,89,43,23,1,0,220,81,
34,23,105,0,42,87,1,0,2,22,216,0,34,55,0,0,34,135,5,0,
25,56,63,6,120,131,0,0,202,49,112,0,224,81,162,5,65,210,68,226,
65,218,61,127,4,0,239,217,230,197,57,55,1,0,26,56,128,255,22,177,
121,199,1,0,1,82,64,6,255,240,128,7,225,48,6,216,7,208,0,226,
0,234,213,29,59,142,16,0,221,137,49,127,1,0,224,121,194,21,59,118,
16,0,221,113,46,87,1,0,42,23,105,0,2,22,208,0,34,55,0,0,
34,103,5,0,26,56,63,6,224,131,0,0,202,49,108,0,68,234,65,226,
59,95,4,0,235,225,150,229,64,6,255,48,130,7,33,0,6,80,42,23,
105,0,7,64,1,58,2,22,216,1,34,55,0,0,34,143,5,0,3,72,
63,6,22,132,0,0,202,49,113,0,66,6,63,0,130,7,33,0,6,80,
42,23,105,0,7,64,0,58,2,22,216,1,34,55,0,0,34,143,5,0,
3,72,63,6,64,132,0,0,202,49,113,0,66,6,63,0,130,7,33,0,
6,80,42,23,105,0,167,0,2,22,200,0,34,55,0,0,34,135,5,0,
3,72,63,6,104,132,0,0,202,49,112,0,66,6,63,0,138,7,225,16,
99,7,1,0,99,7,5,0,39,127,16,0,39,111,18,0,99,7,9,0,
99,7,13,0,15,128,208,105,201,106,99,111,17,0,6,80,42,23,105,0,
39,231,5,0,3,96,103,103,5,0,72,18,34,55,0,0,39,223,25,0,
103,7,25,0,34,95,5,0,202,49,7,232,63,6,192,132,0,0,107,0,
125,223,25,0,125,231,5,0,74,6,255,16,128,7,225,240,6,232,7,200,
57,199,1,0,128,255,250,172,49,6,68,205,1,0,106,143,5,0,106,199,
9,0,121,87,1,0,0,210,0,218,0,226,133,61,61,134,16,0,220,129,
48,119,1,0,224,113,242,45,29,111,7,0,13,6,17,0,138,21,61,23,
105,0,2,22,176,1,34,55,0,0,34,103,5,0,63,6,40,133,0,0,
221,49,108,0,251,81,178,29,61,86,16,0,28,88,202,89,43,23,1,0,
220,81,34,23,105,0,42,87,1,0,2,22,192,0,34,55,0,0,34,135,
5,0,25,56,63,6,90,133,0,0,202,49,112,0,224,81,162,5,65,210,
68,226,65,218,61,127,4,0,239,217,230,197,57,55,1,0,26,56,128,255,
52,175,121,199,1,0,1,82,64,6,255,240,128,7,225,112,6,216,7,208,
0,202,0,226,0,234,245,29,59,142,16,0,221,137,49,127,1,0,224,121,
226,21,59,118,16,0,221,113,46,87,1,0,42,23,105,0,2,22,176,0,
34,55,0,0,34,103,5,0,26,56,63,6,196,133,0,0,202,49,108,0,
202,209,202,201,68,234,65,226,59,95,4,0,235,225,246,221,25,80,64,6,
255,112,128,7,225,112,6,216,7,208,0,202,0,226,0,234,245,29,59,142,
16,0,221,137,49,127,1,0,224,121,226,21,59,118,16,0,221,113,46,87,
1,0,42,23,105,0,2,22,168,0,34,55,0,0,34,103,5,0,26,56,
63,6,30,134,0,0,202,49,108,0,202,209,202,201,68,234,65,226,59,95,
4,0,235,225,246,221,25,80,64,6,255,112,128,7,225,48,6,216,7,208,
154,0,0,226,0,234,229,29,59,142,16,0,221,137,49,127,1,0,224,121,
210,21,59,118,16,0,221,113,46,87,1,0,42,23,105,0,26,96,2,22,
160,0,34,55,0,0,34,95,5,0,12,56,63,6,122,134,0,0,202,49,
107,0,68,234,65,226,59,87,4,0,234,225,134,229,64,6,255,48,128,7,
225,112,6,224,7,200,121,7,1,0,220,207,2,0,1,210,178,5,0,82,
149,45,0,218,0,234,149,37,60,142,16,0,221,137,49,127,1,0,224,121,
130,29,60,118,16,0,221,113,46,87,1,0,42,23,105,0,2,22,152,0,
34,55,0,0,34,103,5,0,25,56,63,6,220,134,0,0,202,49,108,0,
224,81,186,5,10,208,245,5,68,234,65,218,60,95,4,0,235,217,214,221,
26,80,64,6,255,112,128,7,225,48,6,216,1,210,0,226,0,234,245,29,
59,142,16,0,221,137,49,127,1,0,224,121,226,21,59,118,16,0,221,113,
46,87,1,0,42,23,105,0,2,22,144,0,34,55,0,0,34,103,5,0,
63,6,54,135,0,0,202,49,108,0,224,81,170,5,10,208,68,234,65,226,
59,95,4,0,235,225,246,221,26,80,64,6,255,48,132,7,225,0,6,224,
188,55,1,0,191,255,152,236,10,232,224,233,146,93,61,23,105,0,99,7,
5,0,28,56,35,126,4,0,2,22,136,0,34,55,0,0,99,127,1,0,
34,119,5,0,0,66,221,49,32,78,128,0,63,6,144,135,0,0,110,0,
10,224,224,225,167,29,61,23,105,0,2,22,184,1,34,55,0,0,34,111,
5,0,63,6,176,135,0,0,221,49,109,0,224,81,186,13,29,56,0,50,
128,255,118,3,10,232,38,6,100,50,133,0,191,255,86,158,224,225,202,37,
38,6,120,50,133,0,191,255,72,158,61,23,105,0,2,22,240,0,34,55,
0,0,34,103,5,0,63,6,240,135,0,0,221,49,108,0,224,233,242,13,
61,23,105,0,2,22,168,1,34,55,0,0,34,95,5,0,3,58,63,6,
16,136,0,0,221,49,107,0,0,234,29,80,68,6,255,0,128,7,225,48,
6,216,7,208,154,0,0,226,0,234,229,29,59,142,16,0,221,137,49,127,
1,0,224,121,210,21,59,118,16,0,221,113,46,87,1,0,42,23,105,0,
26,96,2,22,128,0,34,55,0,0,34,95,5,0,12,56,63,6,94,136,
0,0,202,49,107,0,68,234,65,226,59,87,4,0,234,225,134,229,64,6,
255,48,128,7,225,48,6,216,7,208,0,226,0,234,245,29,59,142,16,0,
221,137,49,127,1,0,224,121,226,21,59,118,16,0,221,113,46,87,1,0,
42,23,105,0,2,22,120,0,34,55,0,0,34,103,5,0,26,56,63,6,
176,136,0,0,202,49,108,0,224,81,130,13,68,234,65,226,59,95,4,0,
235,225,246,221,1,82,64,6,255,48,128,7,225,16,6,216,0,226,0,234,
229,29,59,142,16,0,221,137,49,127,1,0,224,121,210,21,59,118,16,0,
221,113,46,87,1,0,42,23,105,0,2,22,112,0,34,55,0,0,34,103,
5,0,63,6,4,137,0,0,202,49,108,0,97,82,130,13,68,234,65,226,
59,95,4,0,235,225,134,229,0,82,64,6,255,16,128,7,225,16,6,216,
0,226,0,234,229,29,59,142,16,0,221,137,49,127,1,0,224,121,210,21,
59,118,16,0,221,113,46,87,1,0,42,23,105,0,2,22,104,0,34,55,
0,0,34,103,5,0,63,6,88,137,0,0,202,49,108,0,97,82,130,13,
68,234,65,226,59,95,4,0,235,225,134,229,0,82,64,6,255,16,128,7,
225,240,6,216,8,200,9,192,7,232,61,231,1,0,128,255,84,168,49,6,
68,205,1,0,106,143,5,0,106,231,9,0,125,87,1,0,61,215,25,0,
15,130,125,135,25,0,25,56,24,64,29,72,1,50,191,255,62,131,61,63,
1,0,10,48,128,255,216,217,61,119,1,0,10,110,1,0,59,23,105,0,
11,122,110,111,0,0,125,127,25,0,2,22,16,0,34,55,0,0,34,103,
5,0,29,56,63,6,226,137,0,0,219,49,108,0,125,215,25,0,125,231,
1,0,64,6,255,240,128,7,33,0,38,6,8,215,255,255,39,6,144,50,
133,0,0,66,191,255,12,218,38,6,56,215,255,255,39,6,160,50,133,0,
1,66,128,255,36,1,64,6,63,0,128,7,33,0,6,80,42,23,105,0,
2,22,0,1,34,55,0,0,34,135,5,0,63,6,58,138,0,0,202,49,
112,0,64,6,63,0,224,49,210,5,129,58,185,5,128,7,200,0,127,0,
0,82,127,0,32,86,34,1,127,0,0,82,127,0,127,0,32,86,42,1,
127,0,31,82,127,0,38,95,101,0,38,87,97,0,127,0,32,86,44,1,
127,0,1,82,127,0,128,7,33,0,6,80,42,23,105,0,2,22,16,0,
34,55,0,0,34,135,5,0,63,6,154,138,0,0,202,49,112,0,64,6,
63,0,128,7,33,0,6,80,42,23,105,0,2,22,16,0,34,55,0,0,
34,135,5,0,63,6,190,138,0,0,202,49,112,0,64,6,63,0,128,7,
33,0,6,80,42,23,105,0,72,18,34,55,0,0,34,135,5,0,63,6,
224,138,0,0,202,49,112,0,64,6,63,0,128,7,33,0,6,80,42,23,
105,0,2,22,16,0,34,55,0,0,34,135,5,0,63,6,4,139,0,0,
202,49,112,0,64,6,63,0,0,82,0,90,127,0,33,6,24,167,130,0,
97,0,33,6,14,164,128,0,97,0,33,6,150,165,130,0,97,0,33,6,
136,208,130,0,97,0,33,6,78,131,128,0,97,0,33,6,228,147,129,0,
97,0,128,7,225,0,6,232,7,224,224,233,226,29,61,135,85,0,49,6,
204,27,134,0,125,143,105,0,224,129,146,13,38,6,180,50,133,0,32,62,
240,6,0,66,191,255,88,139,61,63,108,0,38,6,200,50,133,0,191,255,
164,154,129,226,201,5,29,48,191,255,142,255,64,6,255,0,142,7,225,240,
6,192,56,23,113,0,41,87,9,0,41,135,5,0,41,127,16,0,99,7,
13,0,202,17,99,23,9,0,41,119,25,0,99,135,5,0,99,127,16,0,
99,119,25,0,233,111,23,0,7,208,8,200,0,218,99,111,22,0,195,151,
22,0,41,231,18,0,41,239,1,0,128,255,0,166,44,6,68,205,1,0,
106,103,5,0,106,239,9,0,99,87,1,0,56,239,110,0,253,225,174,5,
28,232,99,239,18,0,189,225,252,0,65,218,251,0,224,225,234,21,229,87,
64,0,224,7,96,1,35,111,1,0,45,103,0,0,10,248,219,97,109,103,
0,0,255,47,32,0,26,48,25,56,3,64,191,255,138,138,78,6,255,240,
26,48,25,56,3,64,191,255,124,138,35,23,5,0,34,87,17,0,35,135,
16,0,137,82,138,129,240,0,253,129,138,13,99,7,16,0,2,22,20,0,
99,23,5,0,245,21,253,129,142,21,29,80,176,81,2,22,20,0,34,95,
17,0,137,90,171,81,172,253,203,81,99,87,16,0,99,23,5,0,229,5,
35,103,16,0,221,97,99,103,16,0,35,103,9,0,29,120,191,122,35,111,
13,0,204,233,99,239,9,0,225,23,0,0,207,17,205,17,99,23,13,0,
165,165,128,7,225,0,7,232,221,151,22,0,221,223,22,0,9,66,6,16,
170,5,6,66,61,135,18,0,34,127,110,0,34,63,108,0,239,129,207,21,
61,231,9,0,34,23,113,0,125,7,13,0,7,48,8,56,220,17,125,23,
9,0,29,64,191,255,202,137,125,231,9,0,125,7,13,0,213,5,2,48,
29,72,191,255,146,254,64,6,255,0,39,127,108,0,64,150,255,255,82,17,
232,121,202,21,7,103,1,0,194,22,254,255,130,22,1,0,7,87,7,0,
208,98,12,17,123,82,226,5,119,82,234,5,130,22,8,0,181,5,130,22,
16,0,102,23,1,0,6,80,127,0,128,7,97,0,6,232,29,135,7,0,
0,18,16,6,225,255,170,13,93,7,2,0,125,7,89,0,125,7,93,0,
31,122,93,127,7,0,29,119,7,0,224,113,202,5,31,106,93,111,7,0,
61,55,108,0,6,6,240,255,145,13,61,95,117,0,224,89,210,5,128,255,
144,10,1,18,213,5,32,86,0,1,93,7,7,0,125,87,110,0,2,80,
64,6,127,0,142,7,225,240,8,232,61,231,18,0,6,208,58,127,110,0,
7,192,239,225,207,21,61,231,9,0,58,23,113,0,125,7,13,0,220,17,
125,23,9,0,58,55,108,0,191,255,176,128,10,200,125,231,9,0,125,7,
13,0,133,117,58,23,113,0,61,87,9,0,61,111,5,0,61,103,16,0,
99,7,13,0,202,17,99,23,9,0,61,95,25,0,61,87,1,0,99,111,
5,0,99,103,16,0,99,95,25,0,99,87,1,0,253,135,23,0,0,218,
99,135,22,0,195,151,22,0,58,127,110,0,58,55,108,0,24,56,3,64,
239,225,239,231,60,235,253,0,99,239,18,0,191,255,72,128,224,217,194,5,
123,87,13,0,165,5,10,200,10,216,189,225,146,61,35,23,5,0,34,95,
17,0,35,87,16,0,137,90,139,81,234,0,253,81,138,13,99,7,16,0,
2,22,20,0,99,23,5,0,245,21,253,81,142,21,29,88,170,89,2,22,
20,0,34,87,17,0,137,82,170,89,172,253,202,89,99,95,16,0,99,23,
5,0,229,5,35,111,16,0,221,105,99,111,16,0,35,103,9,0,29,120,
191,122,35,111,13,0,204,233,99,239,9,0,225,23,0,0,207,17,205,17,
99,23,13,0,165,181,25,80,78,6,255,240,144,7,225,241,6,192,56,23,
113,0,40,87,9,0,40,135,5,0,40,127,16,0,99,7,17,0,202,17,
99,23,13,0,40,119,25,0,99,135,9,0,99,127,20,0,7,184,99,119,
29,0,232,111,23,0,9,200,35,223,65,0,0,210,99,111,26,0,195,151,
26,0,40,231,18,0,40,239,1,0,128,255,204,162,44,6,68,205,1,0,
106,103,5,0,106,239,9,0,99,87,5,0,56,239,110,0,253,225,174,5,
28,232,99,239,22,0,189,225,252,0,65,210,250,0,224,225,186,29,229,87,
64,0,224,7,96,1,35,111,5,0,45,103,0,0,10,248,218,97,109,103,
0,0,255,47,32,0,23,56,56,55,108,0,35,70,4,0,99,223,1,0,
25,72,191,255,176,128,80,6,255,241,23,56,56,55,108,0,35,70,4,0,
99,223,1,0,25,72,191,255,152,128,35,23,9,0,34,127,17,0,35,119,
20,0,137,122,143,113,238,0,253,113,138,13,99,7,20,0,2,22,20,0,
99,23,9,0,245,21,253,113,142,21,29,80,174,81,2,22,20,0,34,95,
17,0,137,90,171,81,172,253,203,81,99,87,20,0,99,23,9,0,229,5,
35,87,20,0,221,81,99,87,20,0,25,72,29,16,219,17,245,5,169,87,
5,0,170,17,196,5,41,79,9,0,2,216,224,17,143,253,35,103,13,0,
9,200,29,120,191,122,204,233,35,111,17,0,99,239,13,0,225,23,0,0,
207,17,205,17,99,23,17,0,165,141,128,7,225,48,8,16,6,232,61,135,
108,0,35,223,25,0,35,215,21,0,32,230,35,1,231,129,194,5,32,86,
35,1,197,93,2,127,0,0,2,87,1,0,224,121,218,85,2,119,3,0,
14,6,240,255,129,85,108,82,178,5,109,82,202,77,221,199,2,0,32,230,
36,1,242,5,26,70,0,8,225,79,0,0,219,73,181,5,26,64,27,72,
194,199,19,0,34,87,13,0,178,5,10,86,0,8,224,73,235,53,177,5,
234,65,187,53,2,135,3,0,34,127,9,0,61,23,14,0,26,112,125,119,
117,0,125,127,113,0,226,119,194,2,8,104,31,98,125,135,108,0,125,119,
97,0,61,23,105,0,125,7,101,0,125,7,89,0,125,111,121,0,125,7,
93,0,2,22,184,1,34,55,0,0,93,103,7,0,34,95,5,0,0,226,
221,49,63,6,210,144,0,0,107,0,97,82,226,5,32,230,35,1,31,82,
125,87,108,0,28,80,64,6,255,48,38,135,108,0,0,82,240,57,154,21,
40,119,1,0,38,111,113,0,104,7,5,0,173,113,104,119,1,0,38,103,
121,0,0,18,236,113,169,5,2,18,2,80,127,0,167,0,0,82,224,57,
250,5,38,135,108,0,232,129,186,5,32,86,32,1,127,0,167,0,0,74,
127,58,242,5,123,58,226,37,7,6,17,0,162,53,245,53,6,135,7,0,
123,130,186,53,38,111,101,0,38,95,93,0,38,103,97,0,38,23,89,0,
237,89,145,45,187,5,236,17,225,37,38,23,85,0,70,63,7,0,224,17,
226,5,1,122,66,127,5,1,102,7,85,0,102,7,89,0,102,7,93,0,
229,21,6,119,7,0,127,114,170,21,6,111,0,0,224,105,234,13,70,63,
7,0,102,7,89,0,102,7,93,0,245,5,38,103,108,0,232,97,186,5,
32,78,32,1,9,80,127,0,128,7,97,0,6,232,35,87,9,0,93,71,
0,0,7,135,1,0,42,23,1,0,93,135,6,0,93,23,1,0,7,111,
5,0,2,118,1,0,1,122,93,111,7,0,7,103,2,0,106,119,1,0,
125,239,17,0,125,127,4,0,98,98,125,103,10,0,198,5,13,6,225,255,
202,5,7,130,125,135,10,0,61,127,10,0,1,114,39,135,9,0,7,111,
19,0,239,119,192,0,125,119,8,0,125,135,113,0,39,127,13,0,125,119,
14,0,14,102,255,255,238,0,125,127,121,0,125,127,117,0,238,127,194,2,
93,111,2,0,32,70,0,4,125,103,12,0,7,103,3,0,39,55,6,0,
0,74,15,16,125,103,108,0,209,50,177,50,6,80,234,23,34,10,6,56,
191,58,239,63,32,2,239,55,32,2,1,80,202,57,191,255,148,170,61,23,
105,0,125,87,89,0,125,95,93,0,2,22,184,1,34,55,0,0,34,127,
5,0,63,6,140,146,0,0,221,49,111,0,61,23,117,0,61,87,14,0,
125,7,101,0,234,23,194,2,125,23,97,0,234,5,1,82,125,87,97,0,
125,7,101,0,1,82,64,6,127,0,103,7,1,0,0,82,127,0,230,57,
226,87,0,0,127,0,134,7,225,48,8,216,187,0,6,232,61,215,85,0,
7,224,188,0,99,226,202,53,29,111,7,0,237,217,138,53,123,106,234,45,
224,209,226,5,125,7,85,0,1,98,90,103,5,1,29,48,35,62,4,0,
191,255,120,233,61,23,105,0,35,71,5,0,35,79,9,0,2,22,24,1,
34,55,0,0,34,95,5,0,63,6,30,147,0,0,221,49,107,0,61,23,
105,0,31,58,31,66,2,22,200,0,34,55,0,0,34,87,5,0,3,72,
63,6,62,147,0,0,221,49,106,0,224,225,234,13,29,119,7,0,238,217,
170,13,61,111,85,0,224,105,226,5,125,7,85,0,1,98,90,103,5,1,
97,226,202,53,29,111,7,0,237,217,138,53,61,127,85,0,224,121,202,45,
189,119,3,0,224,113,138,45,123,106,234,5,0,50,128,255,152,4,125,87,
85,0,61,55,85,0,224,49,210,29,29,56,128,255,142,4,224,81,210,21,
61,87,85,0,224,81,226,13,42,23,241,13,72,18,34,55,0,0,34,103,
5,0,3,58,63,6,186,147,0,0,202,49,108,0,125,7,85,0,197,5,
1,90,93,95,3,0,70,6,255,48,38,143,108,0,231,137,218,13,38,23,
85,0,224,17,226,5,1,130,66,135,5,1,102,7,85,0,31,122,102,127,
108,0,0,82,127,0,128,7,97,0,6,232,29,143,7,0,123,138,234,5,
38,6,172,51,133,0,191,255,24,146,29,63,1,0,61,71,108,0,38,6,
184,51,133,0,191,255,6,146,61,63,117,0,61,71,113,0,38,6,200,51,
133,0,191,255,244,145,29,48,191,255,148,231,228,87,76,2,38,6,224,51,
133,0,10,56,10,104,191,106,150,106,205,57,170,58,191,255,212,145,64,6,
127,0,128,7,225,0,134,143,7,0,7,232,93,143,1,0,6,135,7,0,
93,7,0,0,93,135,5,0,6,127,1,0,6,224,93,127,4,0,191,255,
78,231,61,23,6,0,32,150,0,128,202,86,255,127,60,119,85,0,82,17,
10,17,125,23,6,0,29,111,7,0,224,113,234,23,0,0,194,102,1,0,
205,110,127,0,199,98,12,105,93,111,7,0,60,143,113,0,60,87,108,0,
7,90,93,95,2,0,125,143,9,0,60,135,117,0,93,87,3,0,28,127,
2,0,125,7,16,0,125,135,13,0,93,7,18,0,93,127,19,0,1,82,
64,6,255,0,128,7,33,0,38,55,108,0,0,82,6,6,240,255,225,5,
39,63,1,0,191,255,38,127,1,82,64,6,63,0,128,7,225,0,6,224,
60,55,108,0,0,82,7,232,6,6,240,255,177,21,221,255,22,0,186,5,
128,255,62,203,221,223,22,0,61,63,1,0,60,55,108,0,194,5,191,255,
34,127,181,5,191,255,172,128,1,82,64,6,255,0,128,7,225,0,7,232,
221,151,22,0,221,223,22,0,9,58,170,5,6,58,61,231,9,0,38,23,
113,0,125,7,13,0,220,17,125,23,9,0,38,55,108,0,29,64,191,255,
18,121,125,231,9,0,125,7,13,0,10,48,128,255,84,208,64,6,255,0,
130,7,225,0,7,232,221,151,22,0,221,223,22,0,9,58,9,80,8,16,
170,5,6,58,61,135,18,0,38,127,110,0,2,72,29,64,239,129,223,21,
61,231,9,0,38,23,113,0,125,7,13,0,220,17,125,23,9,0,38,55,
108,0,99,87,1,0,191,255,88,122,125,231,9,0,125,7,13,0,213,5,
99,87,1,0,191,255,236,248,66,6,255,0,0,18,1,82,10,128,226,135,
192,0,71,129,242,5,38,127,108,0,239,17,186,5,0,82,229,5,65,18,
2,6,224,255,166,245,1,82,127,0,7,16,104,7,1,0,194,223,22,0,
9,58,170,5,6,58,2,64,191,7,140,247,128,7,225,240,6,224,7,232,
61,199,1,0,61,223,25,0,13,138,125,143,25,0,61,215,5,0,125,71,
5,0,61,207,16,0,125,7,16,0,224,73,178,5,125,79,1,0,60,23,
105,0,72,18,34,55,0,0,34,135,5,0,29,56,63,6,88,150,0,0,
220,49,112,0,125,223,25,0,221,223,22,0,125,215,5,0,125,207,16,0,
9,58,125,199,1,0,170,5,6,58,28,48,29,64,191,255,34,247,64,6,
255,240,38,23,117,0,0,90,1,82,224,17,162,5,2,80,127,0,128,7,
225,0,7,232,61,135,25,0,0,66,6,16,224,129,170,5,3,66,61,127,
18,0,34,119,110,0,34,63,108,0,238,121,207,21,61,231,9,0,34,23,
113,0,125,7,13,0,7,48,8,56,220,17,125,23,9,0,29,64,191,255,
228,127,125,231,9,0,125,7,13,0,213,5,2,48,29,72,191,255,172,244,
64,6,255,0,127,0,127,0,32,86,255,127,127,0,32,86,255,127,127,0,
128,7,33,0,6,80,42,23,105,0,2,22,248,0,34,55,0,0,34,135,
5,0,63,6,20,151,0,0,202,49,112,0,64,6,63,0,127,0,31,82,
127,0,127,0,32,86,35,1,127,0,32,86,35,1,127,0,32,86,34,1,
127,0,0,82,127,0,32,86,34,1,127,0,32,86,34,1,127,0,1,82,
127,0,0,82,127,0,0,82,127,0,127,0,127,0,103,7,1,0,198,207,
2,0,226,87,0,0,127,0,198,143,2,0,0,82,127,0,0,82,127,0,
0,82,127,0,0,82,127,0,32,86,34,1,127,0,0,82,127,0,127,0,
32,86,42,1,127,0,31,82,127,0,38,95,101,0,38,87,97,0,127,0,
32,86,44,1,127,0,1,82,127,0,128,7,33,0,6,80,42,23,105,0,
2,22,16,0,34,55,0,0,34,135,5,0,63,6,190,151,0,0,202,49,
112,0,64,6,63,0,128,7,33,0,6,80,42,23,105,0,72,18,34,55,
0,0,34,135,5,0,63,6,224,151,0,0,202,49,112,0,64,6,63,0,
128,7,33,0,6,80,42,23,105,0,2,22,16,0,34,55,0,0,34,135,
5,0,63,6,4,152,0,0,202,49,112,0,64,6,63,0,0,82,0,90,
127,0,33,6,156,11,128,0,97,0,33,6,132,251,129,0,97,0,33,6,
230,20,130,0,97,0,128,7,225,16,6,232,7,216,8,224,224,73,154,29,
61,126,16,0,194,58,7,128,207,129,48,23,1,0,207,57,34,23,105,0,
39,87,1,0,72,18,34,55,0,0,34,111,5,0,28,56,63,6,98,152,
0,0,202,49,109,0,181,69,61,103,113,0,97,98,234,37,60,63,1,0,
221,15,2,0,29,48,191,255,202,214,224,81,234,53,61,134,16,0,27,56,
194,58,7,136,208,137,49,23,1,0,125,87,113,0,208,57,34,23,105,0,
39,87,1,0,2,22,16,0,34,55,0,0,34,119,5,0,28,56,63,6,
180,152,0,0,202,49,110,0,165,29,61,94,16,0,27,56,194,58,7,96,
203,97,44,23,1,0,203,57,34,23,105,0,39,87,1,0,2,22,16,0,
34,55,0,0,34,143,5,0,28,56,63,6,232,152,0,0,202,49,113,0,
64,6,255,16,150,7,225,243,6,208,7,216,8,192,99,79,13,0,38,6,
56,215,255,255,0,58,129,255,6,46,224,81,218,5,58,135,4,0,98,130,
206,5,0,82,128,7,102,2,59,119,25,0,47,6,88,29,141,0,99,127,
21,0,99,7,32,0,99,119,41,0,251,111,23,0,99,111,38,0,195,151,
38,0,59,239,1,0,128,255,148,152,44,6,68,205,1,0,106,103,5,0,
106,239,9,0,99,87,17,0,10,88,58,87,4,0,56,135,13,0,107,87,
0,0,56,87,1,0,56,103,5,0,99,7,9,0,208,81,99,87,25,0,
225,23,0,0,204,17,99,23,29,0,58,239,8,0,59,231,5,0,59,151,
18,0,59,207,16,0,176,233,56,183,9,0,99,151,1,0,128,7,178,1,
99,7,34,0,25,184,35,55,1,0,99,231,5,0,41,6,88,29,141,0,
0,218,6,144,189,145,99,151,1,0,224,145,151,21,60,135,17,0,29,16,
137,130,185,129,245,5,28,230,20,0,60,135,17,0,0,202,137,130,176,17,
156,253,208,201,194,201,58,87,4,0,35,23,5,0,58,127,10,0,35,111,
34,0,10,62,255,255,23,64,239,63,192,0,221,57,167,49,221,105,99,111,
34,0,229,69,34,135,17,0,137,130,224,65,151,37,168,129,34,87,1,0,
201,66,8,112,191,114,200,81,34,111,5,0,105,87,1,0,225,103,0,0,
206,97,205,97,105,103,5,0,34,127,9,0,200,121,105,127,9,0,34,103,
13,0,200,97,105,103,13,0,34,127,17,0,168,121,0,66,181,21,34,87,
1,0,105,87,1,0,34,87,5,0,105,87,5,0,34,111,9,0,105,111,
9,0,34,103,13,0,105,103,13,0,34,127,17,0,105,127,17,0,176,233,
236,5,29,80,201,82,202,121,105,127,17,0,2,22,20,0,9,78,20,0,
65,218,224,233,175,189,224,49,215,29,35,23,5,0,58,127,8,0,34,135,
17,0,23,64,239,49,239,55,60,235,137,130,168,129,245,5,2,22,20,0,
34,135,17,0,0,66,137,130,176,57,156,253,200,129,7,184,208,185,99,23,
5,0,224,49,159,141,35,79,13,0,26,48,22,56,35,70,16,0,191,255,
76,253,35,87,25,0,58,119,12,0,58,239,8,0,35,111,29,0,74,113,
174,81,99,87,25,0,225,23,0,0,141,17,99,23,29,0,58,135,4,0,
65,178,240,177,134,21,58,119,8,0,0,178,2,96,14,120,191,122,202,113,
99,119,25,0,225,23,0,0,207,17,204,17,99,23,29,0,27,6,0,255,
166,13,38,6,240,51,133,0,32,62,138,4,0,66,191,255,134,123,224,81,
35,151,9,0,65,146,99,151,9,0,35,151,9,0,58,127,4,0,239,145,
190,5,191,7,70,254,38,6,56,215,255,255,129,255,12,43,224,81,146,13,
38,6,4,52,133,0,32,62,178,1,0,66,191,255,76,123,1,82,86,6,
255,243,154,7,225,243,6,200,57,151,8,0,99,71,5,0,7,192,56,223,
13,0,57,87,14,0,99,151,1,0,56,215,9,0,224,217,146,53,10,64,
10,72,191,74,26,48,27,56,191,255,78,161,35,143,1,0,10,224,28,184,
241,231,32,2,17,120,17,16,241,95,32,2,234,23,34,10,191,122,99,231,
37,0,239,191,32,2,1,80,202,89,203,185,99,191,41,0,57,103,4,0,
28,80,28,232,236,191,32,2,12,16,12,104,236,231,32,2,234,23,34,10,
191,106,237,239,32,2,1,80,202,185,215,233,245,13,26,224,234,231,194,2,
242,231,34,2,99,7,41,0,99,231,37,0,57,23,4,0,0,234,226,231,
34,2,57,135,12,0,188,209,26,64,224,129,178,13,57,127,10,0,8,112,
16,16,239,119,128,0,99,119,45,0,72,17,197,13,35,143,1,0,8,88,
241,95,194,2,99,95,45,0,241,95,34,2,8,16,171,17,56,231,18,0,
35,143,1,0,2,112,28,96,206,97,99,23,49,0,241,97,187,5,128,7,
106,1,57,87,14,0,234,225,151,21,57,135,12,0,224,129,210,13,35,79,
5,0,25,48,24,56,35,70,36,0,191,255,98,252,97,82,186,5,128,7,
122,1,56,119,16,0,56,239,5,0,56,111,25,0,35,103,37,0,99,119,
24,0,35,119,49,0,99,239,13,0,99,111,33,0,35,111,41,0,204,113,
99,119,17,0,225,23,0,0,205,17,99,23,21,0,248,103,23,0,99,103,
30,0,195,151,30,0,56,223,1,0,128,255,248,148,35,127,49,0,43,6,
68,205,1,0,106,95,5,0,106,223,9,0,99,87,9,0,57,87,8,0,
25,48,35,63,45,0,35,79,5,0,175,81,99,87,26,0,35,70,8,0,
191,255,26,251,35,87,37,0,35,95,41,0,1,218,99,87,17,0,99,95,
21,0,181,85,61,23,17,0,35,95,24,0,137,18,171,17,245,5,29,238,
20,0,61,23,17,0,0,90,137,18,162,81,156,253,203,17,194,81,99,87,
24,0,57,23,8,0,65,218,99,239,13,0,226,225,175,21,99,231,26,0,
229,87,64,0,224,7,96,1,35,111,9,0,45,103,0,0,10,248,219,97,
109,103,0,0,255,47,32,0,181,5,99,23,26,0,35,95,45,0,57,87,
4,0,65,90,99,95,45,0,234,89,202,21,57,119,8,0,99,7,45,0,
35,103,17,0,35,111,21,0,14,120,191,122,204,113,99,119,17,0,225,23,
0,0,207,17,205,17,99,23,21,0,35,63,45,0,35,79,5,0,35,70,
8,0,25,48,191,255,98,250,35,87,26,0,170,225,224,225,175,173,213,29,
35,103,37,0,56,231,9,0,35,111,41,0,56,239,13,0,204,113,120,119,
9,0,225,23,0,0,205,17,120,23,13,0,35,63,45,0,35,79,5,0,
25,48,24,64,191,255,38,250,120,231,9,0,120,239,13,0,90,6,255,243,
130,7,225,243,99,79,1,0,6,200,8,192,191,255,222,210,10,184,224,185,
162,93,56,231,1,0,56,239,5,0,57,183,8,0,28,48,29,56,22,208,
26,64,22,216,191,218,27,72,191,255,186,158,57,103,101,0,10,64,57,87,
97,0,11,72,236,73,209,5,187,5,234,65,161,5,0,186,57,119,14,0,
8,80,8,96,14,16,234,23,34,10,14,16,14,120,233,23,32,2,1,80,
191,122,202,17,35,87,1,0,239,103,32,2,42,87,1,0,194,97,8,16,
246,87,32,2,238,23,32,2,250,79,32,2,10,120,191,122,194,81,225,111,
0,0,207,105,204,105,10,96,8,80,26,16,234,23,34,10,8,56,251,63,
32,2,1,80,250,71,32,2,202,73,201,57,168,225,225,127,0,0,157,121,
167,121,204,225,120,231,1,0,225,23,0,0,207,17,205,17,120,23,5,0,
23,80,66,6,255,243,128,7,97,0,6,232,191,255,92,211,10,6,1,128,
162,13,61,143,8,0,241,81,178,13,61,135,4,0,240,87,32,2,229,5,
61,103,4,0,61,87,8,0,236,80,64,6,127,0,128,7,97,0,6,232,
191,255,134,211,10,6,1,128,186,5,61,87,8,0,64,6,127,0,130,7,
225,112,7,224,188,0,8,208,9,200,0,218,6,232,3,56,191,255,182,215,
35,23,1,0,224,17,218,45,127,226,194,5,123,226,242,29,133,45,29,135,
7,0,123,130,202,37,61,111,101,0,61,95,93,0,61,103,97,0,61,87,
89,0,237,89,161,29,187,5,236,81,241,21,61,87,85,0,93,231,7,0,
224,81,146,21,1,122,74,127,5,1,125,7,85,0,181,13,29,119,7,0,
127,114,250,5,93,231,7,0,125,7,89,0,125,7,93,0,97,18,210,5,
224,17,170,13,123,226,130,13,29,48,28,56,26,64,25,72,191,255,32,210,
10,216,61,23,105,0,2,22,184,1,34,55,0,0,34,95,5,0,63,6,
208,159,0,0,221,49,107,0,27,80,66,6,255,112,130,7,225,0,6,232,
7,95,0,0,7,127,1,0,35,255,17,0,125,7,113,0,125,95,4,0,
93,127,6,0,11,6,240,255,191,5,224,89,170,13,11,56,38,6,16,52,
133,0,191,255,20,134,0,82,128,7,50,1,39,103,9,0,39,111,13,0,
0,80,204,81,225,23,0,0,205,17,125,87,89,0,125,23,93,0,7,95,
2,0,61,135,4,0,1,122,125,95,10,0,125,95,108,0,235,127,192,0,
239,128,125,127,8,0,15,110,255,255,125,111,12,0,125,135,14,0,100,90,
190,5,224,89,186,5,105,90,151,13,11,56,38,6,76,52,133,0,191,255,
180,133,0,82,149,109,29,48,99,255,1,0,191,255,24,213,10,224,224,225,
242,77,0,98,0,114,245,45,61,86,16,0,206,81,42,95,1,0,1,106,
0,18,43,95,14,0,1,122,226,127,192,0,235,121,242,5,65,18,2,6,
224,255,137,253,97,106,226,5,61,111,10,0,224,105,218,21,213,5,125,7,
10,0,0,18,229,5,125,23,10,0,11,22,255,255,226,0,61,87,4,0,
235,80,125,95,8,0,125,23,12,0,125,87,14,0,245,5,68,114,65,98,
61,127,4,0,239,97,246,205,61,23,105,0,2,22,24,0,34,55,0,0,
34,119,5,0,63,6,2,161,0,0,221,49,110,0,61,71,14,0,10,48,
11,56,8,72,191,74,191,255,236,155,125,87,97,0,125,95,101,0,61,87,
97,0,61,95,101,0,11,81,202,13,38,6,140,52,133,0,191,255,238,132,
1,82,125,87,97,0,125,7,101,0,0,226,28,80,66,6,255,0,128,7,
225,48,6,232,29,135,7,0,1,210,16,6,225,255,170,13,93,7,2,0,
125,7,89,0,125,7,93,0,31,122,93,127,7,0,0,218,0,226,149,37,
61,118,16,0,220,113,46,103,1,0,224,97,242,29,61,94,16,0,220,89,
43,87,1,0,42,23,105,0,2,22,184,1,34,55,0,0,34,135,5,0,
63,6,158,161,0,0,202,49,112,0,224,81,202,5,93,87,7,0,133,13,
68,226,65,218,61,119,4,0,238,217,214,221,165,5,0,210,29,103,7,0,
127,98,226,5,123,98,194,5,93,7,7,0,0,210,26,80,64,6,255,48,
128,7,225,0,6,232,7,224,224,233,210,45,61,135,85,0,49,6,140,35,
134,0,125,143,105,0,224,129,146,13,38,6,240,52,133,0,32,62,52,6,
0,66,191,255,198,116,61,23,105,0,2,22,192,1,34,55,0,0,34,127,
5,0,63,6,24,162,0,0,221,49,111,0,29,63,0,0,29,71,1,0,
38,6,200,52,133,0,191,255,244,131,129,226,201,5,29,48,191,255,222,232,
64,6,255,0,128,7,97,0,7,232,191,255,76,228,1,138,125,143,1,0,
64,6,127,0,128,7,97,0,6,232,191,255,164,228,221,143,2,0,1,82,
125,87,113,0,64,6,127,0,128,7,225,240,6,232,7,200,8,192,0,218,
0,226,213,53,61,142,16,0,220,137,49,127,1,0,32,214,35,1,224,121,
162,45,61,118,16,0,220,113,46,87,1,0,42,23,105,0,25,56,2,22,
0,1,34,55,0,0,34,103,5,0,24,64,63,6,174,162,0,0,202,49,
108,0,10,136,17,208,224,137,250,13,61,23,105,0,2,22,184,1,34,55,
0,0,34,87,5,0,63,6,208,162,0,0,221,49,106,0,165,13,17,6,
220,254,242,5,68,226,65,218,61,135,4,0,240,217,150,205,26,80,64,6,
255,240,134,7,225,48,8,216,187,0,6,232,61,215,85,0,7,224,188,0,
99,226,202,53,29,111,7,0,237,217,138,53,123,106,234,45,224,209,226,5,
125,7,85,0,1,98,90,103,5,1,29,48,35,62,4,0,191,255,80,217,
61,23,105,0,35,71,5,0,35,79,9,0,2,22,24,1,34,55,0,0,
34,95,5,0,63,6,70,163,0,0,221,49,107,0,61,23,105,0,31,58,
31,66,2,22,200,0,34,55,0,0,34,87,5,0,3,72,63,6,102,163,
0,0,221,49,106,0,224,225,234,13,29,119,7,0,238,217,170,13,61,111,
85,0,224,105,226,5,125,7,85,0,1,98,90,103,5,1,97,226,218,53,
29,111,7,0,237,217,154,53,61,127,85,0,224,121,170,53,189,119,3,0,
224,113,234,45,123,106,234,5,0,50,191,255,112,244,125,87,85,0,61,55,
85,0,224,49,178,37,29,56,191,255,102,244,224,81,210,21,61,87,85,0,
224,81,226,13,42,23,241,13,72,18,34,55,0,0,34,103,5,0,3,58,
63,6,226,163,0,0,202,49,108,0,125,7,85,0,165,13,1,90,93,95,
3,0,229,5,29,48,28,56,27,64,191,255,104,211,70,6,255,48,128,7,
225,0,6,232,7,224,191,255,138,221,61,143,108,0,92,143,2,0,64,6,
255,0,128,7,97,0,6,232,61,63,8,0,38,6,4,53,133,0,7,128,
159,130,208,57,161,58,191,255,236,129,29,48,191,255,106,219,64,6,127,0,
128,7,225,112,6,208,31,226,31,234,0,202,0,218,213,37,58,134,16,0,
219,129,48,119,1,0,224,113,194,29,58,110,16,0,219,105,45,87,1,0,
42,23,105,0,2,22,24,0,34,55,0,0,34,95,5,0,63,6,126,164,
0,0,202,49,107,0,10,96,11,104,253,105,235,5,177,5,252,97,185,5,
12,224,13,232,68,218,65,202,58,23,4,0,226,201,150,221,31,98,253,97,
250,5,31,82,252,81,202,5,0,82,0,90,229,45,2,104,191,106,28,56,
28,80,2,96,234,23,34,10,29,16,237,63,32,2,236,23,32,2,1,80,
28,48,202,17,194,57,58,23,14,0,236,55,32,2,224,17,231,21,2,64,
8,208,2,72,191,74,9,232,191,255,22,152,10,48,230,239,32,2,26,16,
234,23,34,10,250,95,32,2,250,55,32,2,1,80,202,89,203,233,29,56,
6,80,7,88,64,6,255,112,132,7,225,243,6,176,54,151,8,0,7,184,
99,71,5,0,55,223,13,0,99,151,1,0,55,215,9,0,54,87,14,0,
224,217,242,45,10,64,10,72,191,74,26,48,27,56,191,255,192,151,54,103,
4,0,35,143,1,0,10,192,24,200,12,104,17,120,191,122,239,207,32,2,
17,16,234,23,34,10,241,199,32,2,191,106,241,95,32,2,24,232,1,80,
202,89,203,201,24,80,12,16,234,23,34,10,12,16,237,239,32,2,249,23,
32,2,1,80,24,224,202,17,194,233,236,231,32,2,213,13,26,192,234,199,
194,2,242,199,34,2,54,135,4,0,0,202,0,234,24,224,240,231,34,2,
35,143,1,0,188,209,26,16,241,23,194,2,226,143,34,2,177,209,250,45,
35,143,1,0,55,103,18,0,241,97,154,45,55,231,9,0,119,199,9,0,
55,239,13,0,119,207,13,0,54,134,16,0,2,88,194,90,11,80,208,81,
42,23,1,0,208,89,34,23,105,0,43,87,1,0,35,71,5,0,2,22,
64,0,34,55,0,0,34,119,5,0,23,56,63,6,10,166,0,0,202,49,
110,0,119,231,9,0,119,239,13,0,229,5,22,48,23,56,1,66,191,255,
100,245,68,6,255,243,1,66,191,7,90,245,0,66,191,7,84,245,128,7,
97,0,6,232,191,255,170,201,221,191,2,0,64,6,127,0,128,7,33,0,
6,80,42,23,105,0,2,22,0,1,34,55,0,0,34,135,5,0,63,6,
96,166,0,0,202,49,112,0,64,6,63,0,31,82,127,0,0,82,127,0,
0,82,127,0,0,82,127,0,32,86,34,1,127,0,0,82,127,0,127,0,
32,86,42,1,127,0,31,82,127,0,38,95,101,0,38,87,97,0,127,0,
32,86,44,1,127,0,1,82,127,0,128,7,33,0,6,80,42,23,105,0,
2,22,16,0,34,55,0,0,34,135,5,0,63,6,190,166,0,0,202,49,
112,0,64,6,63,0,128,7,33,0,6,80,42,23,105,0,2,22,16,0,
34,55,0,0,34,135,5,0,63,6,226,166,0,0,202,49,112,0,64,6,
63,0,128,7,33,0,6,80,42,23,105,0,72,18,34,55,0,0,34,135,
5,0,63,6,4,167,0,0,202,49,112,0,64,6,63,0,0,82,0,90,
127,0,128,7,225,0,6,232,61,143,17,0,49,23,105,0,2,22,16,0,
34,55,0,0,34,135,5,0,7,224,63,6,52,167,0,0,209,49,112,0,
61,127,21,0,47,23,105,0,2,22,16,0,34,55,0,0,34,119,5,0,
28,56,63,6,84,167,0,0,207,49,110,0,2,82,64,6,255,0,128,7,
225,0,7,224,60,63,1,0,198,15,2,0,6,232,191,255,214,199,224,81,
218,21,61,23,105,0,2,22,184,1,34,55,0,0,34,135,5,0,93,87,
110,0,63,6,144,167,0,0,221,49,112,0,29,48,28,56,191,255,122,255,
165,5,1,82,64,6,255,0,128,7,225,0,7,224,60,63,1,0,6,232,
191,255,148,199,224,81,170,45,61,23,105,0,2,22,184,1,34,55,0,0,
34,135,5,0,93,87,109,0,63,6,210,167,0,0,221,49,112,0,29,119,
108,0,61,102,16,0,194,114,14,104,204,105,45,23,1,0,204,113,34,23,
105,0,46,87,1,0,2,22,16,0,34,55,0,0,202,49,34,87,5,0,
28,56,63,6,6,168,0,0,106,0,1,82,64,6,255,0,128,7,33,0,
6,135,108,0,38,118,16,0,194,130,16,120,206,121,47,23,1,0,206,129,
34,23,105,0,48,87,1,0,2,22,16,0,34,55,0,0,34,103,5,0,
63,6,66,168,0,0,202,49,108,0,1,82,64,6,63,0,128,7,33,0,
6,135,108,0,38,118,16,0,194,130,16,120,206,121,47,23,1,0,206,129,
34,23,105,0,48,87,1,0,72,18,34,55,0,0,34,103,5,0,63,6,
124,168,0,0,202,49,108,0,64,6,63,0,128,7,33,0,38,143,17,0,
49,23,105,0,72,18,34,55,0,0,34,135,5,0,63,6,160,168,0,0,
209,49,112,0,64,6