/***********************************************************************
**
**   projectionbase.h
**
**   This file is part of KFLog2.
**
************************************************************************
**
**   Copyright (c):  2002 by Heiner Lamprecht
**
**   This file is distributed under the terms of the General Public
**   Licence. See the file COPYING for more information.
**
**   $Id: projectionbase.h,v 1.2 2003/05/20 20:22:44 eggert Exp $
**
***********************************************************************/

#ifndef PROJECTIONBASE_H
#define PROJECTIONBASE_H

/**
 * This class is used as a base-class for the map-projection. It will
 * be inherited by all classes, which implement one type of map-projection.
 *
 * @author Heiner Lamprecht
 * @version $Id: projectionbase.h,v 1.2 2003/05/20 20:22:44 eggert Exp $
 */
class ProjectionBase
{
  public:
    /** */
    ProjectionBase(int projectionType = Unknown);
    /** */
    virtual ~ProjectionBase();
    /** */
    const int projectionType() const {  return projType;  };
    /** */
    virtual double projectX(double latitude, double longitude) const = 0;
    /** */
    virtual double projectY(double latitude, double longitude) const = 0;
    /** */
    virtual double invertLat(double x, double y) const = 0;
    /** */
    virtual double invertLon(double x, double y) const = 0;
    /** */
    virtual double getRotationArc(int x, int y) const = 0;
    /** */
    virtual int getTranslationX(int width, int x) const = 0;
    /** */
    virtual int getTranslationY(int height, int y) const = 0;
    /**
     * List of possible projection-types.
     */
    enum ProjectionType {Unknown = 0, Lambert, Cylindric};

  protected:
    /** */
    ProjectionType projType;
};

#endif
