/* ============================================================
 * Author: M. Asselstine <asselsm@gmail.com>
 * Date  : 05-08-2005
 * Description : Dialog to allow photo properties to be edited
 * 
 * Copyright 2005 by M. Asselstine

 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * ============================================================ */
#ifndef PHOTOPROPSDLG_H
#define PHOTOPROPSDLG_H

#include "photoeditdlg.h"

#include <qstring.h>
#include <qpixmap.h>
#include <qstringlist.h>

class QRegExpValidator;
class PhotoListViewItem;


/**
 * Provides helper functions and specialization to the PhotoEditDlg class.
 * @short Photo properties edit dialog.
 * @author M. Asselstine <asselsm@gmail.com>
 */
class PhotoPropsDlg: public PhotoEditDlg
{
Q_OBJECT

public:
    PhotoPropsDlg(QWidget *parent = 0, const char *name = 0);
    ~PhotoPropsDlg();
    
    void setPixmap(const QPixmap &pm);
    void setFriends(bool friends = true);
    void setFamily(bool family = true);
    void setPublic(bool pub = true);
    void setNeitherPublicOrPrivate();
    void setDescription(const QString &str);
    void setTitle(const QString &str);
    void setTags(const QStringList &lst);
    void setAvailableTags(const QStringList &);
    void setPhotoSize(const QString &size); 
    
    bool isFamily() const;
    bool isFriends() const;
    bool isPublic() const;
    bool isPrivate() const;
    QString description() const;
    QString title() const;
    QStringList tags() const;
    QStringList availableTags() const;
    QString photoSize() const;
    
    void editPhotoBatch();
    void updateActivePhotoInfo();
    void editSinglePhoto(PhotoListViewItem *);    
    
private slots:
    void rotatePhoto();
    void addSelectedTag();
    void updatePublic(bool);
    void updateRemoveBtn();
    void updatePrivate(bool);
    void updateChecks(bool);
    void removeSelectedTags();
    void showLargerPreview();
    void insertNewTag(const QString&);
    void updateAddBtn(const QString &str);
    
    virtual void editPhotoBelow();
    virtual void editPhotoAbove();
    
private:
   PhotoListViewItem *m_activePhoto;
};

#endif
