/***************************************************************************
                          keybled.h  -  description
                             -------------------
    begin                : Fri Jul 13 2001
    copyright            : (C) 2001 by Aurelien Jarno
    email                : aurelien.jarno@insa-lyon.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KEYBLED_H
#define KEYBLED_H

#ifdef HAVE_CONFIG_H
  #include <config.h>
#endif

// includes files for Qt
#include <qstring.h>
#include <qlabel.h>
#include <qtimer.h>

// includes files for KDE
#include <kpanelapplet.h>
#include <kconfig.h>
#include <kled.h>

// forward declaration of the classes
class KLedToggle;
class PopUp;
class ConfDialog;

class KeybLED : public KPanelApplet
{
Q_OBJECT
public:
/**
* Construct a @ref KPanelApplet just like any other widget.
*
* @param configFile The configFile handed over in the factory function.
* @param Type The applet @ref type().
* @param actions Standard RMB menu actions supported by the applet (see @ref action() ).
* @param parent The pointer to the parent widget handed over in the factory function.
* @param name A Qt object name for your applet.
**/
	KeybLED(const QString& configFile, Type t = Normal, int actions = 0,
        QWidget *parent = 0, const char *name = 0);

/**
* destructor
*/
	~KeybLED();

  int widthForHeight(int height) const;
	int heightForWidth(int width) const;
	
	void about();
	void help();
	void preferences();
  void updateGeometry();
	
protected slots:
	void dlgOkClicked();
	void dlgApplyClicked();
	void dlgCancelClicked();
	void dlgHelpClicked();
	void dlgDeleted();
	void timerEvent();
	
	void slotToggleNumLED();
	void slotToggleCapsLED();
	void slotToggleScrollLED();

protected:
  void xtest_init();
  void SetLEDStartup();
  	
  void applySettings();
  void openContextMenu();
  void readSettings();
  void writeSettings();

  void resizeEvent(QResizeEvent *event);
  bool eventFilter(QObject *object, QEvent *event);
  void mousePressEvent(QMouseEvent *event);

	void toggleNumLED();
	void toggleCapsLED();
	void toggleScrollLED();


private:
  enum {Vertical = 0, Horizontal = 1};
  enum {Left = 0, Right = 1};
  enum {Top = 0, Bottom = 1};
  enum {unchanged = 0, on = 1, off = 2};
	
	ConfDialog *confDialog;
	KConfig *ksConfig;

	Display *display;
  unsigned int numlock_mask, capslock_mask, scrolllock_mask;

	KLedToggle *numLed, *capsLed, *scrollLed;
	QLabel *numLabel, *capsLabel, *scrollLabel;

	int refreshTime;
	bool tooltipsEnabled, popupEnabled, mouseToggle;
	
	KLed::Look ledLook;
	KLed::Shape ledShape;
	QColor ledColor;
	int ledSize;
	bool numLEDEnabled, capsLEDEnabled, scrollLEDEnabled;
  int ledOrientation;

	int labelPositionVertical;
	int labelPositionHorizontal;
	bool labelEnabled;
	int labelSize;

  int numLEDStartup, capsLEDStartup, scrollLEDStartup;

	bool popupOn;
	PopUp *popup;
	int popupX, popupY;

  QTimer *timer;

private slots:
	void showPopUp(QPoint point);
	void hidePopUp();
	void savePopUpPos();
};

#endif
