/*
 *
 *  General SAR library for ATM devices.
 *
 *  Copyright (c) 2000, Johan Verrept
 *
 *  This code falls under the GNU General Public License, see COPYING for details.
 *
 */

#ifndef _SARLIB_H_
#define _SARLIB_H_

#include <linux/kernel.h>
#include <linux/proc_fs.h>
#include <linux/malloc.h>
#include <linux/atmdev.h>
#include <linux/skbuff.h>
#include <linux/types.h>
#include <linux/atm.h>

#define SARLIB_USE_53BYTE_CELL  0x1L
#define SARLIB_SET_PTI          0x2L


/* types */
#define SARLIB_TYPE_AAL0        ATM_AAL0
#define SARLIB_TYPE_AAL1        ATM_AAL1
#define SARLIB_TYPE_AAL2        ATM_AAL2
#define SARLIB_TYPE_AAL34       ATM_AAL34
#define SARLIB_TYPE_AAL5        ATM_AAL5


/* default MTU's */
#define SARLIB_DEF_MTU_AAL0         48
#define SARLIB_DEF_MTU_AAL1         47
#define SARLIB_DEF_MTU_AAL2          0 /* not supported */
#define SARLIB_DEF_MTU_AAL34         0 /* not supported */
#define SARLIB_DEF_MTU_AAL5      65535 /* max mtu ..    */

typedef struct sarlib_vcc_data {
  struct sarlib_vcc_data   *next;

  /* general sarlib flags, per connection */
  int                flags;
  int                type;

  /* connection specific non-sarlib data */
  struct sk_buff    *(*alloc_tx)(struct atm_vcc *vcc, unsigned int size);
  struct atm_vcc    *vcc;
  struct k_atm_aal_stats *stats;
  unsigned short     mtu; /* max is actually  65k for AAL5... */

  /* cell data */
  unsigned int       vp;
  unsigned int       vc;
  unsigned char      gfc;
  unsigned char      pti;
  unsigned int       headerFlags;
  unsigned long      atmHeader;
   
  /* raw cell reassembly */
  struct sk_buff    *reasBuffer;
  } sarlib_vcc_data_t;


extern struct sarlib_vcc_data *sarlib_open (struct sarlib_vcc_data **list, struct atm_vcc *vcc, uint type, ushort vpi, ushort vci, unchar pti, unchar gfc, uint flags);
extern void                    sarlib_close(struct sarlib_vcc_data **list, struct sarlib_vcc_data *vcc);

extern struct sk_buff *sarlib_encode_rawcell (struct sarlib_vcc_data *ctx, struct sk_buff *skb);
extern struct sk_buff *sarlib_encode_aal5    (struct sarlib_vcc_data *ctx, struct sk_buff *skb);

struct sk_buff *sarlib_decode_rawcell (struct sarlib_vcc_data *list, struct sk_buff *skb, struct sarlib_vcc_data **ctx);
struct sk_buff *sarlib_decode_aal5    (struct sarlib_vcc_data *ctx,  struct sk_buff *skb);

struct sk_buff *sarlib_alloc_tx(struct sarlib_vcc_data *vcc, unsigned int size);

#endif /* _SARLIB_H_ */
