/* This file is part of the Keep project
   Copyright (C) 2005 Jean-Rémy Falleri <jr.falleri@laposte.net>

   Keep is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   Keep is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Keep; if not, write to the
   Free Software Foundation, Inc.,
   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           */

#include <klocale.h>
#include <kdebug.h>

#include "backup.h"

Backup::Backup()
{
}

Backup::Backup( QString source, QString dest, int interval, int deleteAfter, bool neverDelete,bool useCompression, bool excludeSpecialFiles,bool useAdvancedConfig,QStringList optionList,bool useIncludeExclude,QStringList includeExcludeList)
{
	m_source = source;
	m_dest = dest;
	m_interval = interval;
	m_deleteAfter = deleteAfter;
	m_neverDelete = neverDelete;
	m_useCompression = useCompression;
	m_excludeSpecialFiles = excludeSpecialFiles;
	m_useAdvancedConfig = useAdvancedConfig;
	m_optionList = optionList;
	m_useIncludeExclude = useIncludeExclude;
	m_includeExcludeList = includeExcludeList;
}
Backup::~Backup()
{
}

QString Backup::source()
{
	return m_source;
}

void Backup::setSource(QString source)
{
	m_source = source;
}

QString Backup::dest()
{
	return m_dest;
}

void Backup::setDest(QString dest)
{
	m_dest = dest;
}

int Backup::interval()
{
	return m_interval;
}

void Backup::setInterval(int interval)
{
	m_interval = interval;
}

int Backup::deleteAfter()
{
	return m_deleteAfter;
}

void Backup::setDeleteAfter(int deleteAfter)
{
	m_deleteAfter = deleteAfter;
}

bool Backup::neverDelete()
{
	return m_neverDelete;
}

void Backup::setNeverDelete(bool neverDelete)
{
	m_neverDelete = neverDelete;
}

bool Backup::useCompression()
{
	return m_useCompression;
}

void Backup::setUseCompression(bool useCompression)
{
	m_useCompression = useCompression;
}

bool Backup::excludeSpecialFiles()
{
	return m_excludeSpecialFiles;
}

void Backup::setExcludeSpecialFiles(bool excludeSpecialFiles)
{
	m_excludeSpecialFiles = excludeSpecialFiles;
}

bool Backup::useAdvancedConfig()
{
	return m_useAdvancedConfig;
}

void Backup::setUseAdvancedConfig(bool useAdvancedConfig)
{
	m_useAdvancedConfig = useAdvancedConfig;
}

QStringList Backup::optionList()
{
	return m_optionList;
}

void Backup::setOptionList(QStringList optionList)
{
	m_optionList = optionList;
}

bool Backup::useIncludeExclude()
{
	return m_useIncludeExclude;
}

void Backup::setUseIncludeExclude(bool useIncludeExclude)
{
	m_useIncludeExclude = useIncludeExclude;
}

QStringList Backup::includeExcludeList()
{
	return m_includeExcludeList;
}

void Backup::setIncludeExcludeList(QStringList includeExcludeList)
{
	m_includeExcludeList = includeExcludeList;
}

QString Backup::htmlDesc()
{
	QString del;
	QString compression;
	if ( m_neverDelete )
		del = i18n("Never delete");
	else
		del = i18n("%1 days").arg(m_deleteAfter);
	if ( m_useCompression )
		compression = i18n("Yes");
	else
		compression = i18n("No");
	QString html = "<p><b>" + i18n("Source directory:") + "</b><br>"
		+ m_source + "<br><b>" + i18n("Destination directory:") + "</b><br>"
		+ m_dest + "</p><p><b>" + i18n("Interval:") + "</b> " + i18n("%1 days").arg(m_interval)
		+ "<br><b>" + i18n("Delete after:") + "</b> " + del
		+ "<br><b>" + i18n("Use compression:") + "</b> " + compression
		+ "</p>";
	return html;
}


