/***************************************************************************
 *   Copyright (C) 2004, 2005 Thomas Nagy                                  *
 *   tnagy2^8@yahoo.fr                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation (see COPYING)            *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 ***************************************************************************/

#ifndef _KDISSHTMLDOC_H
#define _KDISSHTMLDOC_H

#include <qstringlist.h>
#include <qobject.h>
#include <klibloader.h>
#include "DGenerator.h"

class kdisshtmldocFactory : KLibFactory { Q_OBJECT public: QObject *createObject(QObject *, const char *, const char *, const QStringList & = QStringList()); };

class DDataItem;
/**
 * HTML document generator
 *
 * @short HTML document generator
 * @author Thomas Nagy <tnagy2^8@yahoo.fr>
 */
class kdisshtmldoc : public DGenerator
{
    public:
	kdisshtmldoc();
	~kdisshtmldoc();

	const QString identifikation();
	const QString fullName();
	const QString group();
	const QString description();
	const QString quickstart();

    private:
	bool writeMaindoc(DDataItem*, const QString &);
	void writeItem(DDataItem* item, QTextStream & s, int level);

	int m_cnt_lev1;
	int m_cnt_lev2;
	int m_cnt_lev3;
};

#endif // _KDISSHTMLDOC_H
