#!/usr/bin/env python

#****************************************************************************
#** $Id: smalltable.py 322023 2004-06-19 20:33:37Z sedwards $
#**
#** Copyright (C) 1992-1998 Troll Tech AS.  All rights reserved.
#**
#** This file is part of an example program for PyQt.  This example
#** program may be used, distributed and modified without limitation.
#**
#*****************************************************************************/

import sys
import os
from qt import *
from qttable import *

TRUE  = 1
FALSE = 0

numRows = 30
numCols = 10

if __name__ == '__main__':
    app = QApplication(sys.argv)

    table = QTable(numRows, numCols)

    header = table.horizontalHeader()

    header.setLabel(0, "Tiny", 40)
    header.setLabel(1, "Checkboxes")
    header.setLabel(5, "Combos")
    header.setMovingEnabled(TRUE)

    img = QImage("trolltech.bmp")
    pix = QPixmap(img.scaleHeight(table.rowHeight(3)))
    table.setPixmap(3, 2, pix)
    table.setText(3, 2, "A Pixmap")

    comboEntries = QStringList("one")
    comboEntries.append("two")
    comboEntries.append("three")
    comboEntries.append("four")

    for i in range(numRows):
        item = QComboTableItem(table, comboEntries, FALSE)
        item.setCurrentItem(i % 4)
        table.setItem(i, 5, item)

    for i in range(numRows):
        table.setItem(i, 1, QCheckTableItem(table, "Check me"))
    
    table.setCaption("Small table example")
    table.show()
    app.setMainWidget(table)
    app.exec_loop()
