/***************************************************************************
                            KLocale.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**


 KLocale provides support for country specific stuff like
 the national language.

 KLocale supports translating, as well as specifying the format
 for numbers, currency, time, and date.

 @author Stephan Kulow <coolo@kde.org>, Preston Brown <pbrown@kde.org>, Hans Petter Bieker <bieker@kde.org>

 @short class for supporting locale settings and national language.
*/
public class  KLocale implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KLocale(Class dummy){}


/** 
 Create a KLocale with the given catalogue name.
 If no catalogue is given, the application name is used.
 The constructor looks for an entry Locale/Language in the
 configuration file.
 If nothing is set there, it looks for the environment variable
 $LANG. The format for LANG is de, if de (german) is your
 prefered language. If none of them can be find, the default (C)
 will be used.

*/
	private native void newKLocale( String catalogue);
	public KLocale( String catalogue) {
		newKLocale( catalogue);
	}
	private native void newKLocale();
	public KLocale() {
		newKLocale();
	}

/** 
 Destructor.
      
*/
	protected native void finalize() throws InternalError;

/** 
 Translate the string into the corresponding string in
 the national language, if available. If not, returns
 the string itself.
 There is a KDE wide message file that contains the most
 often used phrases, so we can avoid duplicating the
 translation of these phrases. If a phrase is not found
 in the catalogue given to the constructor, it will search
 in the system catalog. This makes it possible to override
 some phrases for your needs.

*/
	public native String translate( String index);

/** 
 Translate the string into the corresponding string in the
 national language, if available.

 The real contents of the string is in the argument fallback,
 but the meaning of it is coded into the argument index.
 In some cases you'll need this function, when english is
 too ambigious to express it.

 Most of the times the translators will tell you if it can't
 be translated as it, but think of cases as "New", where the
 translations differs depending on what is New.
 Or simple cases as "Open", that can be used to express something
 is open or it can be used to express that you want something to
 open... There are tons of such examples.

 If translate("Open") is not enough to translate it well, use
 translate("To Open", "Open") or translate("Is Open", "Open").
 The english user will see "Open" in both cases, but the translated
 version may vary. Of course you can also use i18n()

*/
	public native String translate( String index, String fallback);
	public native String translate( String singular, String plural, long n);

/** 
 Allows programs such as kcmlocale to choose which translation to use.

*/
	public native void setLanguage( String _lang);

/** 
 Retrieve what a decimal point should look like ("." or "," etc.)
 according to the current locale or user settings.

*/
	public native String decimalSymbol();

/** 
 Retrieve what the thousands separator should look
 like ("," or "." etc.)
 according to the current locale or user settings.

*/
	public native String thousandsSeparator();

/** 
 Retrieve what the symbol denoting currency in the current locale
 as as defined by user settings should look like.

*/
	public native String currencySymbol();

/** 
 Retrieve what a decimal point should look like ("." or "," etc.)
 for monetary values, according to the current locale or user
 settings.

*/
	public native String monetaryDecimalSymbol();

/** 
 Retrieve what a thousands separator for monetary values should
 look like ("," or " " etc.) according to the current locale or
 user settings.

*/
	public native String monetaryThousandsSeparator();

/** 
 Retrieve what a positive sign should look like ("+", " ", etc.)
 according to the current locale or user settings.

*/
	public native String positiveSign();

/** 
 Retrieve what a negative sign should look like ("-", etc.)
 according to the current locale or user settings.

*/
	public native String negativeSign();

/** 
 The number of fractional digits to include in numeric/monetary
 values (usually 2).

*/
	public native int fracDigits();

/** 
 If and only if the currency symbol precedes a positive value,
 this will be true.

*/
	public native boolean positivePrefixCurrencySymbol();

/** 
 If and only if the currency symbol precedes a negative value,
 this will be true.

*/
	public native boolean negativePrefixCurrencySymbol();

/** 
 Retrieve the position of a positive sign in relation to a
 monetary value.

*/
	public native int positiveMonetarySignPosition();

/** 
 Denotes where to place a negative sign in relation to a
 monetary value.

*/
	public native int negativeMonetarySignPosition();

/** 
 Given a double, convert that to a numeric string containing
 the localized monetary equivalent.

 e.g. given 123456, return "$ 123,456.00".

*/
	public native String formatMoney( double num, String currency, int digits);

/** 
 This function differs from the above only in that it can take
 a String as the argument for convenience.

*/
	public native String formatMoney( String numStr);

/** 
 Given a double, convert that to a numeric string containing
 the localized numeric equivalent.

 e.g. given 123456.78, return "123,456.78" (for some European country).
 If precision isn't specified, 2 is used.

*/
	public native String formatNumber( double num, int precision);

/** 
 This function differs from the above only in that it can take
 a String as the argument for convenience.

*/
	public native String formatNumber( String numStr);

/** 
 Return a string formatted to the current locale's conventions
 regarding dates.

*/
	public native String formatDate( Calendar pDate, boolean shortfmt);

/** 
 Return a string formatted to the current locale's conventions
 regarding times.

*/
	public native String formatTime( Date pTime, boolean includeSecs);

/** 
 Use this to determine if the user wants a 12 hour clock.

*/
	public native boolean use12Clock();

/** 
 Use this to determine if the user wants the week to start on monday.

*/
	public native boolean weekStartsMonday();

/** 
 Return a string containing the name of the month name.

*/
	public native String monthName( int i, boolean _short);

/** 
 Return a string containing the name of the week day.

*/
	public native String weekDayName( int i, boolean _short);

/** 
 Return a string formated to the current locale's conventions
 regarding both date and time. Defaults to short date format.

*/
	public native String formatDateTime( Calendar pDateTime);

/** 
 Return a string formated to the current locale's conventions
 regarding both date and time.

*/
	public native String formatDateTime( Calendar pDateTime, boolean shortfmt, boolean includeSecs);

/** 
 Converts a localized monetary string to a double.

*/
	public native double readMoney( String numStr, int[] ok);
	public native double readMoney( String numStr);

/** 
 Converts a localized numeric string to a double.

*/
	public native double readNumber( String numStr, int[] ok);
	public native double readNumber( String numStr);

/** 
 Converts a localized date string to a QDate.
 isValid() on the returning object will be false
 if the date entered was not valid.

 Note: This only works on short dates for the time beeing.

*/
	public native Calendar readDate( String str);

/** 
 Converts a localized time string to a QTime.
 isValid() on the returning object will be false
 if the time entered was not valid.

*/
	public native Date readTime( String str);

/** 
 Returns the language used by this object. The domain AND the
 library translation must be available in this language.
 'C' is default, if no other available.

*/
	public native String language();

/** 
 Returns the country code of the country where the user lives.
 'C' is default, if no other available

*/
	public native String country();

/** 
 Returns the languages selected by user.

*/
	public native String languages();

/** 
 Returns the languages selected by user.

*/
	public native ArrayList languageList();

/** 
 Returns the charset name by selected locale.
 This will be the charset defined in the config file.
 NOTE: This is no longer the same as encoding.
 "iso-8859-1" is default

*/
	public native String charset();

/** 
 adds another catalogue to search for translation lookup.
 This function is useful for extern libraries and/or code,
 that provides its own messages.

 If the catalogue does not exist for the chosen language,
 it will be ignored and C will be used.

*/
	public native void insertCatalogue( String catalogue);

/** 
 translates a message as a QTranslator is supposed to.
 The parameters are similiar to i18n(), but the result
 value has other semantics (it can be String.null)

*/
	public native String translateQt( String context, String sourceText);

/** 
 Init the localization part of the instance with the config object.

*/
	public native void initFormat( KConfig config);

/** 
 Init the language part of the instance with the given config object. It
 should be valid and contain the global entries.

*/
	public native void initLanguage( KConfig config, String catalogue);

/** 

*/
	public native boolean inited();

/** 
 returns the parts of the parameter str understood as language setting
 the format is language_country.charset

*/
	public static native void splitLocale( String str, String language, String country, String charset);

/** 
 Use this to as main catalogue for all KLocales, if not the appname
 will be used.

*/
	public static native void setMainCatalogue( String catalogue);

/** 
 Find localized resource in resourceDir( rtype ) + <lang> + fname.

*/
	public static native String langLookup( String fname, String rtype);

/** 

     
*/
	protected native Date readTime( String str, boolean seconds);

/** 

     
*/
	protected native Calendar readDate( String str, boolean shortfmt);

/** 

     
*/
	protected native void setEncodingLang( String _lang);
	private native void newKLocale( KLocale arg1);
	public KLocale( KLocale arg1) {
		newKLocale( arg1);
	}
	public static final int ParensAround = 0;
	public static final int BeforeQuantityMoney = 1;
	public static final int AfterQuantityMoney = 2;
	public static final int BeforeMoney = 3;
	public static final int AfterMoney = 4;
}
