#ifndef RATIOS_H
#define RATIOS_H

#include "ftpaccess.h"
#include <qwidget.h>
#include <qcheckbox.h>
#include <qspinbox.h>
#include <qlistbox.h>
#include <kapp.h>
#include "InputFileCtl.h"

class Ratios : public QWidget {
	Q_OBJECT
public:
	Ratios(QWidget *parent=0, const char *name=0);
	~Ratios();
public slots:
	void	ftpaccessLoaded(ftpaccess *xs);
	void	update();
	void	dlFreeAddPressed();
	void	dlFreeRmPressed();
	void	dlFreeDirAddPressed();
	void	dlFreeDirRmPressed();
	void	dlFreeAdded(bool isDir, QString name);
private:
	void	redraw();
	ftpaccess *	ftpxs;
	QStringList *	dlFreeL;
	QStringList *	dlFreeDirL;
	QSpinBox *	UlDlRatio;
	QCheckBox *	UlDlRatioAnon;
	QCheckBox *	UlDlRatioGuest;
	QSpinBox *	limitTime;
	QCheckBox *	limitTimeAnon;
	QCheckBox *	limitTimeGuest;
	QSpinBox *	limitUpload;
	QCheckBox *	limitUploadAnon;
	QCheckBox *	limitUploadGuest;
	QSpinBox *	limitDownload;
	QCheckBox *	limitDownloadAnon;
	QCheckBox *	limitDownloadGuest;
	QListBox *	dlFree;
	QPushButton *	dlFreeAdd;
	QPushButton *	dlFreeRm;
	QListBox *	dlFreeDir;
	QPushButton *	dlFreeDirAdd;
	QPushButton *	dlFreeDirRm;
};

#endif
