/*
    Copyright (c) 2001 Dawit Alemayehu <adawit@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License (LGPL) as published by the Free Software Foundation;
    either version 2 of the License, or (at your option) any later
    version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/

#ifndef __UACHANGER_PLUGIN_H
#define __UACHANGER_PLUGIN_H

#include <qmap.h>
#include <qarray.h>

#include <klibloader.h>
#include <kparts/plugin.h>

class QStringList;
class KActionMenu;
class KSimpleConfig;

namespace KIO
{
  class Job;
};

class UAChangerPlugin : public KParts::Plugin
{
  Q_OBJECT

public:
  UAChangerPlugin( QObject* parent, const char* name );
  ~UAChangerPlugin();

protected slots:
  void slotStarted( KIO::Job* );
  void slotItemSelected( int );
  void slotAboutToShow();
  void slotReset();
  void slotSave();
  void parseDescFiles();

private:
  void updateIOSlaves();
  QString uaForHost( const QString& );

  int m_iSelectedItem;
  bool m_bReloadConfig;
  KSimpleConfig* m_config;
  KActionMenu* m_pUAMenu;

  QString m_prevHost;
  QStringList m_lstAlias, m_lstIdentity;

  typedef QValueList<int> BrowserGroup;
  typedef QMap<QString,BrowserGroup> AliasMap;
  typedef AliasMap::Iterator AliasIterator;
  typedef AliasMap::ConstIterator AliasConstIterator;

  AliasMap m_mapAlias;
};

class UAChangerPluginFactory : public KLibFactory
{
  Q_OBJECT
public:
  UAChangerPluginFactory( QObject* parent = 0, const char* name = 0 );
  ~UAChangerPluginFactory();
  virtual QObject* createObject( QObject* parent = 0, const char* pname = 0,
                                 const char* name = "QObject",
                                 const QStringList &args = QStringList() );
private:
    static KInstance* s_instance;
};
#endif
