/*
	Serenity Style for KDE 3+
	
		Copyright (C) 2006 Remi Villatel <maxilys@tele2.fr>
	
	Based on Lipstik engine:
	
		Copyright (C) 2004 Patrice Tremblay <tremblaypatrice@yahoo.fr>
	
	Also based on numerous open source styles that helped me to not 
	re-invent the wheel for every line of code. Thanks to everyone.  ;-)
	
	This library is free software; you can redistribute it and/or 
	modify it under the terms of the GNU Library General Public 
	License version 2 as published by the Free Software Foundation.
	
	This library is distributed in the hope that it will be useful, 
	but WITHOUT ANY WARRANTY; without even the implied warranty of 
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
	Library General Public License for more details.
	
	You should have received a copy of the GNU Library General Public 
	License along with this library. (See the file COPYING.) If not, 
	write to:
	The Free Software Foundation, Inc., 59 Temple Place - Suite 330, 
	Boston, MA 02111-1307, USA.
*/

#include <qapplication.h>
#include <qcheckbox.h>
#include <qcolor.h>
#include <qcombobox.h>
#include <qframe.h>
#include <qhbox.h>
#include <qvbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qsettings.h>
#include <qslider.h>
#include <qtabwidget.h>
#include <qvgroupbox.h>

#include <kglobal.h>
#include <klocale.h>
#include <kcolorbutton.h>
#include <kseparator.h>

#include "serenityconf.h"

extern "C"
{
	QWidget* allocate_kstyle_config(QWidget* parent)
	{
		KGlobal::locale()->insertCatalogue("kstyle_serenity_config");
		return new SerenityStyleConfig(parent);
	}
}

SerenityStyleConfig::SerenityStyleConfig(QWidget* parent): QWidget(parent)
{
	KGlobal::locale()->insertCatalogue("kstyle_serenity_config");
	
	///Init tabs
	QVBoxLayout* layout = new QVBoxLayout(this, 0, 0);
	QGridLayout* tabLayout = new QGridLayout(this, 2, 1, 10);
	
	QTabWidget *tabWidget = new QTabWidget(this);
	layout->addWidget(tabWidget);

	///Init tab 1 
	QWidget *page1 = new QWidget(tabWidget);
	layout = new QVBoxLayout(page1);
	
	tabWidget->insertTab(page1, i18n("Configuration"));
	
	layout->addLayout(tabLayout);	
	
	// Serenity group
	QVBox *firstGrp = new QVBox(page1, "FirstGroup");
	firstGrp->setSpacing(6);
	firstGrp->setSizePolicy(QSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed));

	QHBox* hbGrSt = new QHBox(firstGrp);
	QLabel* gradientStyleLabel;
	gradientStyleLabel = new QLabel(i18n("Gradient style: "), hbGrSt);
	gradientStyle = new QComboBox(i18n("Gradient style"), hbGrSt);
	gradientStyle->setEditable(false);
	gradientStyle->insertItem("Serene");
	gradientStyle->insertItem("Zen");
	gradientStyle->insertItem("Flat");
	gradientStyleLabel->setBuddy(gradientStyle);
	//
	alternateSinking = new QCheckBox(i18n("Use alternate sunken effect"), firstGrp);
	KSeparator* hline = new KSeparator(firstGrp);
	customOverHighlightColor = new QCheckBox(i18n("Custom mouseover tint:"), firstGrp);
	QHBox *hbox3 = new QHBox(firstGrp);
	hbox3->layout()->addItem(new QSpacerItem(20, 0, QSizePolicy::Fixed, QSizePolicy::Minimum) );
	overHighlightColor = new KColorButton(hbox3);
	//mouseOver = new QCheckBox(i18n("Mouseover checkmark/radiobutton label"), firstGrp);
	hline = new KSeparator(firstGrp);
	//
	QHBox* hbScSt = new QHBox(firstGrp);
	QLabel* scrollBarStyleLabel;
	scrollBarStyleLabel = new QLabel(i18n("Scrollbar style: "), hbScSt);
	scrollBarStyle = new QComboBox(i18n("Scrollbar style"), hbScSt);
	scrollBarStyle->setEditable(false);
	scrollBarStyle->insertItem("KDE");
	scrollBarStyle->insertItem("Arrowless");
	scrollBarStyle->insertItem("NeXT");
	scrollBarStyle->insertItem("Platinum");
	scrollBarStyle->insertItem("Windows");
	scrollBarStyleLabel->setBuddy(scrollBarStyle);
	hline = new KSeparator(firstGrp);
	//
	centerTabs = new QCheckBox(i18n("Center tabs"), firstGrp);
	//
	QHBox* hbTaSt = new QHBox(firstGrp);
	QLabel* tabStyleLabel;
	tabStyleLabel = new QLabel(i18n("Active tab style: "), hbTaSt);
	tabStyle = new QComboBox(i18n("Tab style"), hbTaSt);
	tabStyle->setEditable(false);
	tabStyle->insertItem("Serene button");
	tabStyle->insertItem("Highlighted button");
	tabStyle->insertItem("Serene gradient");
	tabStyle->insertItem("Highlighted gradient");
	tabStyle->insertItem("Flat");
	tabStyleLabel->setBuddy(tabStyle);
	//
	QHBox* hbTaWa = new QHBox(firstGrp);
	QLabel* tabWarnStyleLabel;
	tabWarnStyleLabel = new QLabel(i18n("Tab warnings: "), hbTaWa);
	tabWarnStyle = new QComboBox(i18n("Tab warnings"), hbTaWa);
	tabWarnStyle->setEditable(false);
	tabWarnStyle->insertItem("App. default");
	tabWarnStyle->insertItem("Bold text");
	tabWarnStyle->insertItem("Italic text");
	tabWarnStyle->insertItem("Deactivated");
	tabWarnStyleLabel->setBuddy(tabWarnStyle);
	hline = new KSeparator(firstGrp);
	//
	QHBox* hbMeGr = new QHBox(firstGrp);
	QLabel* menuGrooveStyleLabel;
	menuGrooveStyleLabel = new QLabel(i18n("Menu groove style: "), hbMeGr);
	menuGrooveStyle = new QComboBox(i18n("Menu groove style"), hbMeGr);
	menuGrooveStyle->setEditable(false);
	menuGrooveStyle->insertItem("Solid frame");
	menuGrooveStyle->insertItem("Two lines");
	menuGrooveStyle->insertItem("Empty");
	menuGrooveStyleLabel->setBuddy(menuGrooveStyle);
	//
	menubarHack = new QCheckBox(i18n("Draw wider menubar entries"), firstGrp);

	tabLayout->addWidget(firstGrp, 0, 0, 0);

	KSeparator* middleSep = new KSeparator(QFrame::VLine, page1);
	tabLayout->addWidget(middleSep, 0, 1, 0);
	
	// General group
	QVBox* secondGrp = new QVBox(page1, "SecondGroup");
	secondGrp->setSpacing(6);
	secondGrp->setSizePolicy(QSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed));
	//
	QHBox* hbTiTi = new QHBox(secondGrp);
	QLabel* tipTintLabel;
	tipTintLabel = new QLabel(i18n("Tool tip tint: "), hbTiTi);
	tipTint = new QComboBox(i18n("Tool tip tint"), hbTiTi);
	tipTint->setEditable(false);
	tipTint->insertItem("Yellow");
	tipTint->insertItem("Blue");
	tipTint->insertItem("Green");
	tipTint->insertItem("Red");
	tipTint->insertItem("Orange");
	tipTint->insertItem("Violet");
	tipTint->insertItem("Grey");
	tipTint->insertItem("White");
	tipTintLabel->setBuddy(tipTint);
	//
	hline = new KSeparator(secondGrp);
	drawTriangularExpander = new QCheckBox(i18n("Use arrow symbols in tree views"), secondGrp);
	hline = new KSeparator(secondGrp);
	drawFocusRect = new QCheckBox(i18n("Draw focus rectangles"), secondGrp);
	hline = new KSeparator(secondGrp);
	drawToolBarHandle = new QCheckBox(i18n("Draw toolbar handles"), secondGrp);
	drawToolBarSeparator = new QCheckBox(i18n("Draw toolbar item separators"), secondGrp);
	hline = new KSeparator(secondGrp);
	//
	QHBox* hbPrPa = new QHBox(secondGrp);
	QLabel* progressBarPatternLabel;
	progressBarPatternLabel = new QLabel(i18n("Progress bar pattern: "), hbPrPa);
	progressBarPattern = new QComboBox(i18n("Gradient style"), hbPrPa);
	progressBarPattern->setEditable(false);
	progressBarPattern->insertItem("Arrows");
	progressBarPattern->insertItem("Candy Bar");
	progressBarPattern->insertItem("Checker");
	progressBarPattern->insertItem("Waves");
	progressBarPatternLabel->setBuddy(progressBarPattern);
	//
	flatProgressBar = new QCheckBox(i18n("Flat progress bars"), secondGrp);
	animateProgressBar = new QCheckBox(i18n("Animate progress bars"), secondGrp);
	hline = new KSeparator(secondGrp);
	//
	QLabel* submenuSpeedLabel;
	submenuSpeedLabel = new QLabel(i18n("Popup sub-menus delay: "), secondGrp);
	submenuSpeed = new QSlider(-8, 8, 1, 0, Qt::Horizontal, secondGrp);
	submenuSpeed->setTickmarks(QSlider::Below);
	submenuSpeed->setTickInterval(4);
	submenuSpeedLabel->setBuddy(submenuSpeed);
	QHBox* tickBox = new QHBox(secondGrp);
	QLabel* fastLabel;
	QLabel* regularLabel;
	QLabel* slowLabel;
	fastLabel = new QLabel(i18n("fast"), tickBox);
	regularLabel = new QLabel(i18n("standard"), tickBox);
	slowLabel = new QLabel(i18n("slow"), tickBox);
	if ( QApplication::reverseLayout() )
	{
		fastLabel->setAlignment(AlignRight);
		slowLabel->setAlignment(AlignLeft);
	}
	else
	{
		fastLabel->setAlignment(AlignLeft);
		slowLabel->setAlignment(AlignRight);
	}
	regularLabel->setAlignment(AlignHCenter);

	tabLayout->addWidget(secondGrp, 0, 2, 0);

	/// Init tab 2
	QWidget *page2 = new QWidget(tabWidget);
	QLabel* serenityLabel;
	QLabel* aLabel1;
	QLabel* lipstikLabel;
	QLabel* aLabel2;
	QLabel* aLabel3;
	QLabel* aLabel4;
	QLabel* aLabel5;
	
        layout = new QVBoxLayout(page2, 8, -1);
	
	tabWidget->insertTab(page2, i18n("About"));
	
	serenityLabel = new QLabel("<b>Serenity 1.4</b> -- (C) Remi Villatel &lt;maxilys@tele2.fr&gt; -- 2006", 
					page2);
	serenityLabel->setMargin(5);
	serenityLabel->setAlignment(AlignHCenter);
	serenityLabel->setFrameStyle(QFrame::Box | QFrame::Sunken);
	aLabel1 = new QLabel(i18n("The sources of several styles helped me."), 
				page2);
	lipstikLabel = new QLabel(i18n("        Especially Lipstik by Patrice Tremblay,"), page2);
	aLabel2 = new QLabel(i18n("        Plastik, DotNet, QtCurve, HighContrast, Keramik, etc."), 
				page2);
	aLabel3 = new QLabel(i18n("        Thanks to their respective authors and the others I forgot."), 
				page2);
	aLabel4 = new QLabel(i18n("And so did the sources of KDE 3.5 and Qt 3."), page2);
	aLabel5 = new QLabel(i18n("        Thanks to the KDE developers and Trolltech."), page2);

	layout->add(serenityLabel);
	layout->addSpacing(10);
	layout->add(aLabel1);
	layout->addSpacing(5);
	layout->add(lipstikLabel);
	layout->add(aLabel2);
	layout->add(aLabel3);
	layout->addSpacing(5);
	layout->add(aLabel4);
	layout->add(aLabel5);
	layout->addStretch(10);

	// Read config and populate!
	QSettings s;

	origGradientStyle = s.readNumEntry("/serenitystyle/Settings/gradientStyle", 0);
	gradientStyle->setCurrentItem(origGradientStyle);
	origAlternateSinking = s.readBoolEntry("/serenitystyle/Settings/alternateSunkenEffect", false);
	alternateSinking->setChecked(origAlternateSinking);
	origCustomOverHighlightColor = s.readBoolEntry("/serenitystyle/Settings/customOverHighlightColor", true);
	customOverHighlightColor->setChecked(origCustomOverHighlightColor);
	origOverHighlightColor = s.readEntry("/serenitystyle/Settings/overHighlightColor", "#00d000");
	overHighlightColor->setColor(origOverHighlightColor);
	//origMouseOverLabel = s.readBoolEntry("/serenitystyle/Settings/mouseOverLabel", true);
	//mouseOverLabel->setChecked(origMouseOverLabel);
	origScrollBarStyle = s.readNumEntry("/serenitystyle/Settings/scrollBarStyle", 0);
	scrollBarStyle->setCurrentItem(origScrollBarStyle);
	origCenterTabs = s.readBoolEntry("/serenitystyle/Settings/centerTabs", false);
	centerTabs->setChecked(origCenterTabs);
	origTabStyle = s.readNumEntry("/serenitystyle/Settings/tabStyle", 0);
	tabStyle->setCurrentItem(origTabStyle);
	origTabWarnStyle = s.readNumEntry("/serenitystyle/Settings/tabWarningStyle", 0);
	tabWarnStyle->setCurrentItem(origTabWarnStyle);
	origMenuGrooveStyle = s.readNumEntry("/serenitystyle/Settings/menuGrooveStyle", 0);
	menuGrooveStyle->setCurrentItem(origMenuGrooveStyle);
	origMenubarHack = s.readBoolEntry("/serenitystyle/Settings/menubarHack", false);
	menubarHack->setChecked(origMenubarHack);
	//
	origTipTint = s.readNumEntry("/serenitystyle/Settings/tipTint", 0);
	tipTint->setCurrentItem(origTipTint);
	origDrawTriangularExpander = s.readBoolEntry("/serenitystyle/Settings/drawTriangularExpander", true);
	drawTriangularExpander->setChecked(origDrawTriangularExpander);
	origDrawFocusRect = s.readBoolEntry("/serenitystyle/Settings/drawFocusRect", true);
	drawFocusRect->setChecked(origDrawFocusRect);
	origDrawToolBarHandle = s.readBoolEntry("/serenitystyle/Settings/drawToolBarHandle", true);
	drawToolBarHandle->setChecked(origDrawToolBarHandle);
	origDrawToolBarSeparator = s.readBoolEntry("/serenitystyle/Settings/drawToolBarSeparator", false);
	drawToolBarSeparator->setChecked(origDrawToolBarSeparator);
	origProgressBarPattern = s.readNumEntry("/serenitystyle/Settings/progressBarPattern", 0);
	progressBarPattern->setCurrentItem(origProgressBarPattern);
	origFlatProgressBar = s.readBoolEntry("/serenitystyle/Settings/flatProgressBar", false);
	flatProgressBar->setChecked(origFlatProgressBar);
	origAnimProgressBar = s.readBoolEntry("/serenitystyle/Settings/animateProgressBar", true);
	animateProgressBar->setChecked(origAnimProgressBar);
	origSubmenuSpeed = s.readNumEntry("/serenitystyle/Settings/submenuSpeed", 0);
	submenuSpeed->setValue(origSubmenuSpeed);
	
	connect(gradientStyle, SIGNAL( activated(int) ), SLOT( updateChanged() ) );
	connect(alternateSinking, SIGNAL( toggled(bool) ), SLOT( updateChanged() ) );
	connect(customOverHighlightColor, SIGNAL( toggled(bool) ), SLOT( updateChanged() ) );
	connect(overHighlightColor, SIGNAL( pressed() ), SLOT( updateChanged() ) );
	//connect(mouseOverLabel, SIGNAL( toggled(bool) ), SLOT( updateChanged() ) );
	connect(scrollBarStyle, SIGNAL( activated(int) ), SLOT( updateChanged() ) );
	connect(centerTabs, SIGNAL( toggled(bool) ), SLOT( updateChanged() ) );
	connect(tabStyle, SIGNAL( activated(int) ), SLOT( updateChanged() ) );
	connect(tabWarnStyle, SIGNAL( activated(int) ), SLOT( updateChanged() ) );
	connect(menuGrooveStyle, SIGNAL( activated(int) ), SLOT( updateChanged() ) );
	connect(menubarHack, SIGNAL( toggled(bool) ), SLOT( updateChanged() ) );
	//
	connect(tipTint, SIGNAL( activated(int) ), SLOT( updateChanged() ) );
	connect(drawTriangularExpander, SIGNAL( toggled(bool) ), SLOT( updateChanged() ) );
 	connect(drawFocusRect, SIGNAL( toggled(bool) ), SLOT( updateChanged() ) );
	connect(drawToolBarHandle, SIGNAL( toggled(bool) ), SLOT( updateChanged() ) );
	connect(drawToolBarSeparator, SIGNAL( toggled(bool) ), SLOT( updateChanged() ) );
	connect(progressBarPattern, SIGNAL( activated(int) ), SLOT( updateChanged() ) );
	connect(flatProgressBar, SIGNAL( toggled(bool) ), SLOT( updateChanged() ) );
	connect(animateProgressBar, SIGNAL( toggled(bool) ), SLOT( updateChanged() ) );
	connect(submenuSpeed, SIGNAL( valueChanged(int) ), SLOT( updateChanged() ) );

	if (gradientStyle->currentItem() >= 2)
		alternateSinking->setEnabled(false);
	else
		alternateSinking->setEnabled(true);
	//
	if ( customOverHighlightColor->isChecked() )
		overHighlightColor->setEnabled(true);
	else
		overHighlightColor->setEnabled(false);
}

SerenityStyleConfig::~SerenityStyleConfig()
{
}


void SerenityStyleConfig::save()
{
	QSettings s;

	s.writeEntry("/serenitystyle/Settings/gradientStyle", gradientStyle->currentItem());
	s.writeEntry("/serenitystyle/Settings/alternateSunkenEffect", alternateSinking->isChecked());
	s.writeEntry("/serenitystyle/Settings/customOverHighlightColor", customOverHighlightColor->isChecked());
	s.writeEntry("/serenitystyle/Settings/overHighlightColor", QColor(overHighlightColor->color()).name());
	//s.writeEntry("/serenitystyle/Settings/mouseOverLabel", mouseOverLabel->isChecked());
	s.writeEntry("/serenitystyle/Settings/scrollBarStyle", scrollBarStyle->currentItem());
	s.writeEntry("/serenitystyle/Settings/centerTabs", centerTabs->isChecked());
	s.writeEntry("/serenitystyle/Settings/tabStyle", tabStyle->currentItem());
	s.writeEntry("/serenitystyle/Settings/tabWarningStyle", tabWarnStyle->currentItem());
	s.writeEntry("/serenitystyle/Settings/menuGrooveStyle", menuGrooveStyle->currentItem());
	s.writeEntry("/serenitystyle/Settings/menubarHack", menubarHack->isChecked());
	//
	s.writeEntry("/serenitystyle/Settings/tipTint", tipTint->currentItem());
	s.writeEntry("/serenitystyle/Settings/drawTriangularExpander", drawTriangularExpander->isChecked());
	s.writeEntry("/serenitystyle/Settings/drawFocusRect", drawFocusRect->isChecked());
	s.writeEntry("/serenitystyle/Settings/drawToolBarHandle", drawToolBarHandle->isChecked());
	s.writeEntry("/serenitystyle/Settings/drawToolBarSeparator", drawToolBarSeparator->isChecked());
	s.writeEntry("/serenitystyle/Settings/progressBarPattern", progressBarPattern->currentItem());
	s.writeEntry("/serenitystyle/Settings/flatProgressBar", flatProgressBar->isChecked());
	s.writeEntry("/serenitystyle/Settings/animateProgressBar", animateProgressBar->isChecked());
	s.writeEntry("/serenitystyle/Settings/submenuSpeed", submenuSpeed->value());
}

void SerenityStyleConfig::defaults()
{
	gradientStyle->setCurrentItem(0);
	alternateSinking->setChecked(false);
	customOverHighlightColor->setChecked(true);
	overHighlightColor->setColor("#00d000");
	//mouseOverLabel->setChecked(true);
	scrollBarStyle->setCurrentItem(0);
	centerTabs->setChecked(false);
	tabStyle->setCurrentItem(0);
	tabWarnStyle->setCurrentItem(0);
	menuGrooveStyle->setCurrentItem(0);
	menubarHack->setChecked(false);
	//
	tipTint->setCurrentItem(0);
	drawTriangularExpander->setChecked(true);
	drawFocusRect->setChecked(true);
	drawToolBarHandle->setChecked(true);
	drawToolBarSeparator->setChecked(false);
	progressBarPattern->setCurrentItem(0);
	flatProgressBar->setChecked(false);
	animateProgressBar->setChecked(true);
	submenuSpeed->setValue(0);
}

void SerenityStyleConfig::updateChanged()
{
	if (gradientStyle->currentItem() >= 2)
		alternateSinking->setEnabled(false);
	else
		alternateSinking->setEnabled(true);
	//
	if ( customOverHighlightColor->isChecked() )
		overHighlightColor->setEnabled(true);
	else
		overHighlightColor->setEnabled(false);
	//
	if ( (gradientStyle->currentItem() != origGradientStyle) 
	|| (alternateSinking->isChecked() != origAlternateSinking) 
	|| (customOverHighlightColor->isChecked() != origCustomOverHighlightColor) 
	|| (overHighlightColor->color() != origOverHighlightColor) 
	//|| (mouseOverLabel->isChecked() != origMouseOverLabel) 
	|| (scrollBarStyle->currentItem() != origScrollBarStyle) 
	|| (centerTabs->isChecked() != origCenterTabs) 
	|| (tabStyle->currentItem() != origTabStyle) 
	|| (tabWarnStyle->currentItem() != origTabWarnStyle) 
	|| (menuGrooveStyle->currentItem() != origMenuGrooveStyle) 
	|| (menubarHack->isChecked() != origMenubarHack) 
	//
	|| (tipTint->currentItem() != origTipTint) 
	|| (drawTriangularExpander->isChecked() != origDrawTriangularExpander) 
	|| (drawFocusRect->isChecked() != origDrawFocusRect) 
	|| (drawToolBarHandle->isChecked() != origDrawToolBarHandle) 
	|| (drawToolBarSeparator->isChecked() != origDrawToolBarSeparator) 
	|| (progressBarPattern->currentItem() != origProgressBarPattern) 
	|| (flatProgressBar->isChecked() != origFlatProgressBar) 
	|| (animateProgressBar->isChecked() != origAnimProgressBar) 
	|| (submenuSpeed->value() != origSubmenuSpeed) )
		emit changed(true);
	else
		emit changed(false);
}

#include "serenityconf.moc"
