/***************************************************************************
                                 proc.cpp
                             -------------------
    begin                : Thu Aug 5 1999
    copyright            : (C) 1999 by Markus Gustavsson
    email                : mighty@fragzone.se
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "proc.h"

Proc::Proc()
{

	tag = (char *) calloc(32, sizeof(char));
	cpuStr = (char *) calloc(32, sizeof(char));

	strcpy(cpuStr, "cpu0");

	split = 0;

	UT = 0;
	ST = 0;
	NT = 0;
	IT = 0;

	UT0 = 0;
	ST0 = 0;
	NT0 = 0;
	IT0 = 0;

	UT1 = 0;
	ST1 = 0;
	NT1 = 0;
	IT1 = 0;

	if((fd = fopen("/proc/stat", "r")) == NULL) {
		smp = false;
		ret = (int *) calloc(6, sizeof(int));
		return;
	}

	fscanf(fd, "%32s %d %d %d %d", tag, &cUT, &cNT, &cST, &cIT);
	fscanf(fd, "%32s %d %d %d %d", tag, &cUT, &cNT, &cST, &cIT);

	if(!strcmp(cpuStr, tag)) smp = true;
	else smp = false;

	if(smp) ret = (int *) calloc(6, sizeof(int));
	else ret = (int *) calloc(2, sizeof(int));

}

Proc::~Proc()
{
	free(ret);
	free(tag);
	free(cpuStr);
}

int *Proc::readLoad()
{

	if(smp) for(i = 0; i < 6; i++) ret[i] = 0;
	else for(i = 0; i < 2; i++) ret[i] = 0;

	if((fd = fopen("/proc/stat", "r")) == NULL) return ret;

	if(smp) {

		fscanf(fd, "%32s %d %d %d %d", tag, &cUT, &cNT, &cST, &cIT);
		fscanf(fd, "%32s %d %d %d %d", tag, &cUT0, &cNT0, &cST0, &cIT0);
		fscanf(fd, "%32s %d %d %d %d", tag, &cUT1, &cNT1, &cST1, &cIT1);

		Tot = (cUT - UT) + (cST - ST) + (cNT - NT) + (cIT - IT);

		if(split) {
			if(Tot > 0) {
				ret[0] = ((100 * (cUT - UT)) / Tot);
				ret[1] = ((100 * (cST - ST)) / Tot) + ((100 * (cNT - NT)) / Tot);
			} else {
				ret[0] = 0;
				ret[1] = 0;
			}
		} else {
			if(Tot > 0) ret[0] = ((100 * (cUT - UT)) / Tot) + ((100 * (cST - ST)) / Tot) + ((100 * (cNT - NT)) / Tot);
			else ret[0] = 0;
		}

		UT = cUT;
		ST = cST;
		NT = cNT;
		IT = cIT;

		Tot0 = (cUT0 - UT0) + (cST0 - ST0) + (cNT0 - NT0) + (cIT0 - IT0);

		if(split) {
			if(Tot0 > 0) {
				ret[2] = ((100 * (cUT0 - UT0)) / Tot0);
				ret[3] = ((100 * (cST0 - ST0)) / Tot0) + ((100 * (cNT0 - NT0)) / Tot0);
			} else {
				ret[2] = 0;
				ret[3] = 0;
			}
		} else {
			if(Tot0 > 0) ret[2] = ((100 * (cUT0 - UT0)) / Tot0) + ((100 * (cST0 - ST0)) / Tot0) + ((100 * (cNT0 - NT0)) / Tot0);
			else ret[2] = 0;
		}

		UT0 = cUT0;
		ST0 = cST0;
		NT0 = cNT0;
		IT0 = cIT0;

		Tot1 = (cUT1 - UT1) + (cST1 - ST1) + (cNT1 - NT1) + (cIT1 - IT1);

		if(split) {
			if(Tot1 > 0) {
				ret[4] = ((100 * (cUT1 - UT1)) / Tot1);
				ret[5] = ((100 * (cST1 - ST1)) / Tot1) + ((100 * (cNT1 - NT1)) / Tot1);
			} else {
				ret[4] = 0;
				ret[5] = 0;
			}
		} else {
			if(Tot1 > 0) ret[4] = ((100 * (cUT1 - UT1)) / Tot1) + ((100 * (cST1 - ST1)) / Tot1) + ((100 * (cNT1 - NT1)) / Tot1);
			else ret[4] = 0;
		}

		UT1 = cUT1;
		ST1 = cST1;
		NT1 = cNT1;
		IT1 = cIT1;

		fclose(fd);

		return ret;

	} else {

		fscanf(fd, "%32s %d %d %d %d", tag, &cUT, &cNT, &cST, &cIT);

		Tot = (cUT - UT) + (cST - ST) + (cNT - NT) + (cIT - IT);

		if(split) {
			if(Tot > 0) {
				ret[0] = ((100 * (cUT - UT)) / Tot);
				ret[1] = ((100 * (cST - ST)) / Tot) + ((100 * (cNT - NT)) / Tot);
			} else {
				ret[0] = 0;
				ret[1] = 0;
			}
		} else {
			if(Tot > 0) ret[0] = ((100 * (cUT - UT)) / Tot) + ((100 * (cST - ST)) / Tot) + ((100 * (cNT - NT)) / Tot);
			else ret[0] = 0;
		}

		UT = cUT;
		ST = cST;
		NT = cNT;
		IT = cIT;

		fclose(fd);

		return ret;

	}

}

bool Proc::smpChk()
{
	return smp;
}

void Proc::setSplit(bool set)
{
	split = set;
}






