/*
 * Copyright 2010 Jörg Ehrichs <joerg.ehichs@gmx.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "selectkeystroke.h"
#include "ui_selectkeystroke.h"

#include <QtCore/QString>

using namespace Wacom;

SelectKeyStroke::SelectKeyStroke(QWidget *parent) :
        KDialog(parent),
        ui(new Ui::SelectKeyStroke)
{
    QWidget *widget = new QWidget(this);
    ui->setupUi(widget);
    setMainWidget(widget);

    setButtons(KDialog::Ok | KDialog::Cancel);
    setCaption(i18n("Select Key Function"));

    ui->kkeysequencewidget->setCheckForConflictsAgainst(KKeySequenceWidget::None);
    ui->kkeysequencewidget->setModifierlessAllowed(true);

    //fill the combobox with all values
    ui->comboBox->blockSignals(true);
    ui->comboBox->addItem(i18nc("none means no special modifier is used. instead use the values from the Key Sequence Widget", "none"), QString("none"));
    ui->comboBox->addItem(i18nc("ALT key", "ALT"), QString("ALT"));
    ui->comboBox->addItem(i18nc("CTRL key", "CTRL"), QString("CTRL"));
    ui->comboBox->addItem(i18nc("SHIFT key", "SHIFT"), QString("SHIFT"));
    ui->comboBox->addItem(i18nc("META key", "META"), QString("META"));
    ui->comboBox->addItem(i18nc("ALT+CTRL key combination", "ALT+CTRL"), QString("ALT+CTRL"));
    ui->comboBox->addItem(i18nc("ALT+SHIFT key combination", "ALT+SHIFT"), QString("ALT+SHIFT"));
    ui->comboBox->addItem(i18nc("ALT+META key combination", "ALT+META"), QString("ALT+META"));
    ui->comboBox->addItem(i18nc("CTRL+SHIFT key combination", "CTRL+SHIFT"), QString("CTRL+SHIFT"));
    ui->comboBox->addItem(i18nc("CTRL+META key combination", "CTRL+META"), QString("CTRL+META"));
    ui->comboBox->addItem(i18nc("SHIFT+META key combination", "SHIFT+META"), QString("SHIFT+META"));
    ui->comboBox->addItem(i18nc("ALT+CTRL+META key combination", "ALT+CTRL+META"), QString("ALT+CTRL+META"));
    ui->comboBox->addItem(i18nc("ALT+CTRL+SHIFT key combination", "ALT+CTRL+SHIFT"), QString("ALT+CTRL+SHIFT"));
    ui->comboBox->addItem(i18nc("CTRL+META+SHIFT key combination", "CTRL+META+SHIFT"), QString("CTRL+META+SHIFT"));
    ui->comboBox->blockSignals(false);

    connect(this, SIGNAL(okClicked()), this, SLOT(slotOkClicked()));
}

SelectKeyStroke::~SelectKeyStroke()
{
    delete ui;
}

QString SelectKeyStroke::keyStroke()
{
    return m_keyStroke;
}

void SelectKeyStroke::slotOkClicked()
{

    if (ui->comboBox->currentIndex() != 0) {
        int index = ui->comboBox->currentIndex();
        m_keyStroke = ui->comboBox->itemData(index).toString();
    } else {
        m_keyStroke = ui->kkeysequencewidget->keySequence().toString();
    }

    m_keyStroke.replace(QRegExp("([^\\s])\\+"), "\\1 ");
    m_keyStroke = m_keyStroke.toLower();
}
