/***************************************************************************
 *   Copyright (C) 2004 by Roberto Virga                                   *
 *   rvirga@users.sourceforge.net                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Library General Public     *
 *   License along with this program; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef KBSSETILOGX_H
#define KBSSETILOGX_H

#include <kbslogmonitor.h>

class KBSSETILogX : public KBSLogMonitor
{
  Q_OBJECT
  public:
    KBSSETILogX(const KURL &url, QObject *parent=0, const char *name=0);
    
    virtual QStringList keys() const;
    virtual bool hasResults() const;
  
  protected:
    virtual bool parseFile(KBSFileInfo *file, const QString &fileName);
  
    virtual KBSLogDatum formatWorkunitDatum(KBSSETIProjectMonitor *monitor, const QString &workunit) const;
    virtual KBSLogData formatSpikeData(KBSSETIProjectMonitor *monitor, const QString &workunit) const;
    virtual KBSLogData formatGaussianData(KBSSETIProjectMonitor *monitor, const QString &workunit) const;
    virtual KBSLogData formatPulseData(KBSSETIProjectMonitor *monitor, const QString &workunit) const;
    virtual KBSLogData formatTripletData(KBSSETIProjectMonitor *monitor, const QString &workunit) const;
    virtual QMap<QString,KBSLogData> formatWorkunit(KBSProjectMonitor *monitor, const QString &workunit) const;
    
    virtual void appendHeader(const KBSFileInfo *info, QIODevice *io);
    virtual void appendWorkunit(const KBSFileInfo *info, QIODevice *io, const KBSLogDatum &datum);
    
  private:
    void initKeys();
    
    static QString workunitName(const QString &result);
    
    bool parseSETILogDocument(const QStringList &lines);
    bool parseResultsLogDocument(unsigned type, const QStringList &lines);
    
  private slots:
    void updateFile(const QString &fileName);
    
  protected:
    enum FileType {SETIFile, SpikeFile, GaussianFile, PulseFile, TripletFile};
    static const QString s_version;
    static const QString s_filename[TripletFile+1];
    QStringList m_keys[TripletFile+1];
    
  private:
    enum ResultType {Spike, Gaussian, Pulse, Triplet};
    QMap<QString,QString> m_workunit;
    unsigned m_count[Triplet+1];
};

#endif
