/***************************************************************************
 *   Copyright (C) 2004 by Roberto Virga                                   *
 *   rvirga@users.sf.net                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef KBSSETIRESULTSPLOT_H
#define KBSSETIRESULTSPLOT_H

#include <qwidget.h>

#include <setidata.h>

class KBSBOINCMonitor;
class KBSSETIProjectMonitor;

class KBSSETIResultsPlot : public QWidget
{
  Q_OBJECT
  public:
    KBSSETIResultsPlot(QWidget *parent=0, const char *name=0);
    
    virtual QString workunit() const;
    virtual void setWorkunit(const QString &workunit);
    
    virtual QString project() const;
    virtual KBSBOINCMonitor *monitor() const;
    
    virtual KBSSETIProjectMonitor *projectMonitor() const;
    virtual void setProjectMonitor(KBSSETIProjectMonitor *projectMonitor);
    
  public slots:
    virtual void update();
  
  protected:
    virtual void paintEvent(QPaintEvent *event);
    
    virtual void paintResult(double chirp_rate, double power, const QPixmap& target, QPixmap *plot);
    
    static double power(const SETIAnalysisCfg *analysis_cfg, const SETISpike &spike);
    static double power(const SETIAnalysisCfg *analysis_cfg, const SETIGaussian &gaussian);
    static double power(const SETIAnalysisCfg *analysis_cfg, const SETIPulse &pulse);
    static double power(const SETIAnalysisCfg *analysis_cfg, const SETITriplet &triplet);
     
  private:
    QString m_workunit;
    KBSSETIProjectMonitor *m_projectMonitor;
};

#endif
