/***************************************************************************
                          kbearsitemanager.cpp  -  description
                             -------------------
    begin                : fre mar 15 2002
    copyright            : (C) 2002 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qtimer.h>
#include <qdom.h>
#include <qtimer.h>
#include <qfile.h>
#include <qtextedit.h>
#include <qcheckbox.h>
#include <qpopupmenu.h>
#include <qradiobutton.h>
///////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kprotocolinfo.h>
#include <kparts/plugin.h>
#include <kpassdlg.h>
#include <kmessagebox.h>
#include <klineeditdlg.h>
#include <kmdcodec.h>
#include <kcharsets.h>
#include <kstandarddirs.h>
#include <klocale.h>
#include <kglobal.h>
#include <kdebug.h>
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "kbearsitemanager.h"
#include "kbearsitemanagertreeview.h"
#include "../../base/site.h"
#include "../../base/group.h"
#include "../../base/siteimportfilterpluginiface.h"
#include <netdb.h>
#include <sys/param.h>
#include <netinet/in.h>
#include <string.h>

//-----------------------------------------------
KBearSiteManager::KBearSiteManager(QWidget *parent, const char *name )
	:	KBearSiteManagerBase(parent,name),
		m_importDialog( new SiteImportDialog( this, "SiteImportDialog" )),
		m_advancedDialog( new KBearSiteManagerAdvancedDialog( this, "KBearSiteManagerAdvancedDialog" )),
		m_hasKBearFTP(false), m_pendingConnect( false ),
		m_isModified( false )
{
	connect( p_showSystemTrayCheckBox, SIGNAL( toggled( bool ) ), SIGNAL( showSystemTray( bool ) ) );
	connect( p_plugInKonqCheckBox, SIGNAL( toggled( bool ) ), SIGNAL( plugInKonq( bool ) ) );
	connect( p_reloadButton, SIGNAL( clicked() ), SIGNAL( update() ) );
	connect( m_importDialog, SIGNAL( importSites( const QString& ) ), SIGNAL(importSites( const QString&)));
	connect( m_advancedDialog, SIGNAL( edited() ), this, SLOT(slotSetEdited() ) );
	setupProtocolCombo();
	p_encodingComboBox->insertStringList( KGlobal::charsets()->descriptiveEncodingNames() );
}
//-----------------------------------------------
KBearSiteManager::~KBearSiteManager(){
}
//-----------------------------------------------
/*
void KBearSiteManager::firstTimeImport( const QString& siteManagerFile) {
	QValueList<KService::Ptr> pluginList = m_importDialog->pluginList();
	KTrader::OfferList::Iterator it( pluginList.begin() );
	for( ; it != pluginList.end(); ++it ) {
		KService::Ptr ptr = (*it);
		if( ptr->property( "OldSiteManager" ).toBool() ) {
			SiteImportFilterPluginIface* plugin = static_cast<SiteImportFilterPluginIface*>( KParts::Plugin::loadPlugin( this, ptr->library() ) );
			m_importDialog->startImport( plugin, siteManagerFile );
		}
	}
}
*/
//-----------------------------------------------
void KBearSiteManager::slotSetEdited() {
	saveButton->setEnabled(true);
	p_advancedSettingsButton->setEnabled( true );
	m_isModified = true;
}
//-----------------------------------------------
void KBearSiteManager::slotSetHostEdited() {
	slotSetEdited();
	connectButton->setEnabled(true);
}
//-----------------------------------------------
void KBearSiteManager::slotAdvancedSettings() {
#warning FIXME disable selections depending on protocol
	bool enabled = (p_protocolComboBox->currentText() == "ftp");
	m_advancedDialog->p_disablePassiveMode->setEnabled( enabled );
	m_advancedDialog->p_binaryModeRadioButton->setEnabled( enabled );
	m_advancedDialog->p_asciiModeRadioButton->setEnabled( enabled );
	m_advancedDialog->p_disableListA->setEnabled( enabled );
	if( m_advancedDialog->p_disablePassiveMode->isChecked() )
		m_advancedDialog->p_disableExtendedPassiveMode->setEnabled( false );
	else
		m_advancedDialog->p_disableExtendedPassiveMode->setEnabled( true );
	m_advancedDialog->exec();


}
//-----------------------------------------------
Site KBearSiteManager::getCurrentSite() {
kdDebug()<<"KBearSiteManager::getCurrentSite()="<<siteEdit->text()<<endl;
	Site s;
	QListViewItem* item = siteTreeView->selectedItem();
	QString parentStr = QString::null;
	if( item ) {
		if( item->isExpandable() )
			parentStr = siteTreeView->getFullPath( item );
		else
			parentStr = siteTreeView->getParentString( item );
	}				
	s.setParent( parentStr );
	s.setDescription( descriptionEdit->text() );
	s.setLabel( siteEdit->text() );
	s.setHost( hostNameEdit->text() );
	if( p_protocolComboBox->currentText() == "ftp" && m_hasKBearFTP )
		s.setProtocol( "kbearftp" );
	else
		s.setProtocol( p_protocolComboBox->currentText() );

	s.setAnonym( anonymousCheck->isChecked() );
	s.setUser( userNameEdit->currentText() );
	s.setPass( encodePassword( passwordEdit->text() ) );

	if( defaultLocalDirEdit->text() == "" )
		s.setLocalPath( "/" );
	else
		s.setLocalPath( defaultLocalDirEdit->text() );
	if( defaultRemoteDirEdit->text() == "" )
		s.setRemotePath( "/" );
	else
		s.setRemotePath( defaultRemoteDirEdit->text() );

	s.setPort( p_portSpinBox->value() );
	// Advanced settings
	s.setAutoReconnect( m_advancedDialog->p_autoReconnectCheckBox->isChecked() );
	s.setReconnectTime( m_advancedDialog->p_reconnectTime->value() );
	s.setNumOfRetries( m_advancedDialog->p_numOfRetries->value() );
	s.setBinaryMode( m_advancedDialog->p_binaryModeRadioButton->isChecked() );
	s.setEnableLog( ! m_advancedDialog->p_disableLogging->isChecked() );
	s.setMarkPartial( m_advancedDialog->p_partExtensionCheckBox->isChecked() );
	s.setPassiveMode( ! m_advancedDialog->p_disablePassiveMode->isChecked() );
	s.setListA( ! m_advancedDialog->p_disableListA->isChecked() );
	s.setQueue( m_advancedDialog->p_queueTransfers->isChecked() );
	s.setSingleConnection( m_advancedDialog->p_singleConnection->isChecked() );
	if( m_advancedDialog->p_disableExtendedPassiveMode->isEnabled() )
		s.setExtendedPassiveMode( ! m_advancedDialog->p_disableExtendedPassiveMode->isChecked() );
	else
		s.setExtendedPassiveMode( false );

	QString tmp = KGlobal::charsets()->encodingForName( m_advancedDialog->m_encodingComboBox->currentText() );
	s.setFileSysEncoding( tmp );

	return s;
}
//-----------------------------------------------
void KBearSiteManager::slotConnect() {
	accept();
	Site site = getCurrentSite();
	site.setPass( decodePassword( site.pass() ) );
	emit openConnection( site );
}
//-----------------------------------------------
void KBearSiteManager::slotDoubleClicked(QListViewItem* item) {
	if( ! item || item->isExpandable() ) // no item or a group was selected so ignore it
		return;
kdDebug()<<"KBearSiteManager::slotDoubleClicked"<<endl;
	m_pendingConnect = true;
	slotSelectedSite( item );
}
//-----------------------------------------------
void KBearSiteManager::slotMoved(const QString& oldParent, const QString& name, QListViewItem* newParent, bool isGroup) {
	m_movedItem.setLabel( name );
	m_movedItem.setParent( oldParent );

	QString newParentPath = siteTreeView->getFullPath(newParent);		

	if( isGroup )
		emit moveGroup( m_movedItem, newParentPath );
	else {
		Site site;
		site.setLabel( name );
		site.setParent( oldParent );
		emit moveSite( site, newParentPath );
	}
}
//-----------------------------------------------
void KBearSiteManager::slotNewGroup() {
	QString name = promptForGroupName();
	if( name.isNull() )
		return;
	QListViewItem* selectedItem =  siteTreeView->selectedItem();
	QString parentName = QString::null;
	if( selectedItem ) {
		if( selectedItem->isExpandable() ) {
			parentName = siteTreeView->getFullPath( selectedItem );
		}
		else {
			parentName = siteTreeView->getFullPath( selectedItem->parent() );
		}
	}
	Group group;
	group.setLabel( name );	
	group.setParent( parentName );
	emit newGroup( group );
}
//-----------------------------------------------
void KBearSiteManager::slotRemove() {
	if( ! siteTreeView->selectedItem() )
		return;
	QString tmp1, tmp2;
	if( siteTreeView->selectedItem()->isExpandable() ) {
		tmp1 = i18n("group");
		tmp2 = i18n("\nIf you do all sub groups/sites will be removed as well.");
	}
	else {
		tmp1 = i18n("site");
		tmp2 = i18n("\nIf you do the site will be removed permanently.");
	}
	int answer = KMessageBox::questionYesNo( this, i18n( "Do you really want to remove the %1:\n%2"
							"%3" ).arg(tmp1).arg(siteTreeView->selectedItem()->text(0)).arg(tmp2),
							i18n("Remove...") );
	if( answer == KMessageBox::No )
		return;
	if( siteTreeView->selectedItem()->isExpandable() ) {
		Group group;
		QString path = siteTreeView->getFullPath( siteTreeView->selectedItem()->parent() );
		group.setParent( path );
		group.setLabel( siteTreeView->selectedItem()->text( 0 ) );
		emit removeGroup( group );
	}
	else {
		Site site = getCurrentSite();
		emit removeSite( site );
	}	
	clear();
}
//-----------------------------------------------
void KBearSiteManager::slotSave() {
	Site site = getCurrentSite();
	m_isModified = false;
	saveButton->setEnabled( false );
	if( site.label() == m_selectedItem.label() ) {
		emit changeSite( site, m_selectedItem.label() );
	}
	else {
		emit saveSite( site );
	}

	m_selectedItem = site;
}
//-----------------------------------------------
void KBearSiteManager::slotContextMenu( KListView*, QListViewItem* item, const QPoint& pos) {
	if( ! item )
		return;
	QPopupMenu menu( this );
	menu.insertItem( i18n("&Remove"), this, SLOT( slotRemove() ) );
	menu.insertSeparator();
	const int RENAME = menu.insertItem( i18n("Rename") );
	menu.setMouseTracking( true );
	if( RENAME == menu.exec( pos ) ) {
		siteTreeView->rename( item, 0 );
//		setItemsRenameable( false );
	}
}
//-----------------------------------------------
void KBearSiteManager::slotItemRenamed(QListViewItem* item, const QString& newName, int) {
kdDebug()<<"KBearSiteManager::slotItemRenamed"<<endl;
//	setItemsRenameable( false );
	if( ! item || m_selectedItem.label() == newName )
		return;
kdDebug()<<"KBearSiteManager::slotItemRenamed selected="<<m_selectedItem.label()<<" new name="<<newName<<endl;
	if( item->isExpandable() ) {// group renamed
		Group group;
		group.setParent( m_selectedItem.parent() );
		group.setLabel( newName );
		emit changeGroup( group, m_selectedItem.label() );
	}
	else {
		siteEdit->blockSignals( true ); // we need to block signals so we don't think it's user changed
		siteEdit->setText( newName );
		QString oldName = m_selectedItem.label();
		m_selectedItem.setLabel( newName );
		emit changeSite( m_selectedItem, oldName );
		siteEdit->blockSignals( false );
	}
}
//-----------------------------------------------
void KBearSiteManager::slotPressed(QListViewItem* item) {
	if( ! item )
		slotSelectedSite( 0L );
}
//-----------------------------------------------
void KBearSiteManager::slotSelectedSite( QListViewItem* item ) {
kdDebug()<<"KBearSiteManager::slotSelectedSite item="<<(item?item->text(0):QString::null)<<endl;

	if( item && item->isSelected() ) {
		checkModified();
		QString parent = siteTreeView->getParentString( item );
		QString label = item->text( 0 );
		removeButton->setEnabled( true );
		if( item->isExpandable() ) {// a group was selected
			clear();
			m_selectedItem.setParent( parent );
			m_selectedItem.setLabel( label );
			emit selectionCleared();
			return;
		}
		m_selectedItem.setParent( parent );
		m_selectedItem.setLabel( label );
	}
	else {
		m_selectedItem.setParent( QString::null );
		m_selectedItem.setLabel( QString::null );
		removeButton->setEnabled( false );
		clear();
		emit selectionCleared();
		return;
	}
	emit siteSelected( m_selectedItem );
}
//-----------------------------------------------
void KBearSiteManager::setSite( const Site& site ) {
	siteEdit->setText( site.label() );
	hostNameEdit->setText( site.host() );
	kdDebug()<<"KBearSiteManager::setSite protocol="<<site.protocol()<<endl;
	QString prot = (site.protocol()=="kbearftp"?QString::fromLatin1("ftp"):site.protocol());
	p_protocolComboBox->setCurrentItem( prot );
	anonymousCheck->setChecked( site.anonym() );
	userNameEdit->setCurrentText( site.user() );
	passwordEdit->setText( decodePassword( site.pass() ) );
	defaultLocalDirEdit->setText( site.localPath() );
	defaultRemoteDirEdit->setText( site.remotePath() );
	p_portSpinBox->setValue( site.port() );
	descriptionEdit->setText( site.description() );
	// Advanced settings
	m_advancedDialog->p_autoReconnectCheckBox->setChecked( site.autoReconnect() );
	m_advancedDialog->p_reconnectTime->setValue( site.reconnectTime() );
	m_advancedDialog->p_numOfRetries->setValue( site.numOfRetries() );
	if( site.binaryMode() )
		m_advancedDialog->p_binaryModeRadioButton->setChecked( true );
	else
		m_advancedDialog->p_asciiModeRadioButton->setChecked( true );

	m_advancedDialog->p_disableLogging->setChecked( ! site.enableLog() );
	m_advancedDialog->p_partExtensionCheckBox->setChecked( site.markPartial() );
	m_advancedDialog->p_disablePassiveMode->setChecked( ! site.passiveMode() );
	m_advancedDialog->p_disableExtendedPassiveMode->setChecked( ! site.extendedPassiveMode() );
	m_advancedDialog->p_disableListA->setChecked( ! site.listA() );
	m_advancedDialog->p_queueTransfers->setChecked( site.queue() );
	m_advancedDialog->p_singleConnection->setChecked( site.singleConnection() );
	QString fileSysEncoding = site.fileSysEncoding();
	 for( int i = 0; i < m_advancedDialog->m_encodingComboBox->count(); i++ ) {
		QString tmp = KGlobal::charsets()->encodingForName( m_advancedDialog->m_encodingComboBox->text( i ) );
		if( tmp == fileSysEncoding ) {
			m_advancedDialog->m_encodingComboBox->setCurrentItem( i );
			break;
		}
	}


	m_isModified = false;
	m_selectedItem = site;
	p_advancedSettingsButton->setEnabled( true );
	connectButton->setEnabled( true );
	saveButton->setEnabled( false );
	QListViewItem* parentItem = siteTreeView->findParentByFullName( site.parent() );
	if( parentItem ) {
		QListViewItem* item = siteTreeView->findItemByName( parentItem, site.label() );
		if( item ) {
			siteTreeView->ensureItemVisible( item );		
			siteTreeView->blockSignals( true );
			siteTreeView->setSelected( item, true );		
			siteTreeView->blockSignals( false );
		}
	}
	if( m_pendingConnect ) {
		slotConnect();
		m_pendingConnect = false;
	}
	kdDebug()<<"KBearSiteManager::setSite="<<passwordEdit->text()<<endl;		
}
//-----------------------------------------------
QString KBearSiteManager::decodePassword( const QString& pass ) {
	QString p = pass;
	QCString dataIn;
	QTextStream sStream( &p, IO_ReadOnly );
	sStream >> dataIn;
	QCString result = KCodecs::base64Decode( dataIn );
	return result.data();
}
//-----------------------------------------------
QString KBearSiteManager::encodePassword( const QString& password ) {
	QString pass = password;
	QTextStream sStream( &pass, IO_ReadOnly );
	QCString bArray;
	sStream >> bArray;
	QCString result = KCodecs::base64Encode( bArray, true );	
	return result.data();
}
//-----------------------------------------------
void KBearSiteManager::slotSetEncoding(const QString& encoding) {
	emit newEncoding( KGlobal::charsets()->encodingForName( encoding ) );
}
//-----------------------------------------------
void KBearSiteManager::slotOpenImportDialog() {
	m_importDialog->exec();
}
//-----------------------------------------------
void KBearSiteManager::slotSelectedProtocol( const QString& protocol ) {
	char p[25];
	strcpy( p, "ssh" );
	if( protocol != "sftp" && protocol != "fish" ) // ssh protocols
		strcpy( p, protocol.latin1() );
	setservent( true );  // open /etc/services
	struct servent* serv = getservbyname( p, NULL );   // find default port for specified protocol
	if( serv ) {
		int port = (int)ntohs( (unsigned short int)serv->s_port);
		p_portSpinBox->setValue( port );
	}
	endservent();  // close /etc/services
}
//-----------------------------------------------
void KBearSiteManager::setupProtocolCombo() {
	bool hasFTP = false;
	QStringList protList = KProtocolInfo::protocols();
	for( QStringList::Iterator it = protList.begin(); it != protList.end(); ++it ) {
		if( ( KProtocolInfo::outputType( *it ) == KProtocolInfo::T_FILESYSTEM )
			&& KProtocolInfo::supportsListing( *it )
			&& KProtocolInfo::supportsReading( *it )
			&& KProtocolInfo::supportsWriting( *it )
			&& KProtocolInfo::supportsMakeDir( *it )
			&& KProtocolInfo::supportsDeleting( *it ) ) {
							
			if( *it == "ftp" )
				hasFTP = true;
			else if( *it == "kbearftp" )
				m_hasKBearFTP = true;
			if( (*it != "floppy") && (*it != "file") && ( (*it).left(6) != "webdav") )
				p_protocolComboBox->insertItem( *it );
			
		}
	}		
	if( hasFTP ) {
		if( m_hasKBearFTP ) {
			p_protocolComboBox->setCurrentText( "kbearftp" );
			p_protocolComboBox->removeItem( p_protocolComboBox->currentItem() );
		}
		p_protocolComboBox->setCurrentText( "ftp" );
	}
	slotSelectedProtocol( p_protocolComboBox->currentText() );
}
//-----------------------------------------------
void KBearSiteManager::clear(){
	Site site;  // We use a site here in order to get the correct default values

	setSite( site );	

	connectButton->setEnabled( false );
	p_advancedSettingsButton->setEnabled( false );
}
//-----------------------------------------------
QString KBearSiteManager::promptForGroupName() {
	bool ok;
	QString name = KLineEditDlg::getText ( i18n("Enter name for the group:"),  i18n("New Group"), &ok, this );
	if( ok )
		return name;
	
	return QString::null;
}
//-----------------------------------------------
void KBearSiteManager::closeEvent( QCloseEvent* e ) {
	if( ! checkModified() ) {
		e->ignore();
		return;
	}
	
	QWidget::closeEvent( e );
}
//-----------------------------------------------
void KBearSiteManager::accept() {
	if( ! checkModified() ) {
		return;
	}
	QDialog::accept();
}
//-----------------------------------------------
void KBearSiteManager::reject() {
	if( ! checkModified() ) {
		return;
	}
	QDialog::reject();
}
//-----------------------------------------------
bool KBearSiteManager::checkModified() {
	if( m_isModified ) {
		int answer = KMessageBox::warningYesNoCancel( this, i18n( "You have unsaved changes.\n"
							"Do you want to save these changes ?" ), i18n("Unsaved changes...") );

		switch( answer ) {
			case KMessageBox::Yes:
				slotSave();
				break;
			case KMessageBox::Cancel:
				saveButton->setEnabled(false);
				m_isModified = false;
				return false;
			default:
				saveButton->setEnabled(false);
				m_isModified = false;
				break;
		}
	}
	return true;
}
//-----------------------------------------------

#ifndef NO_INCLUDE_MOCFILES
#include "kbearsitemanager.moc"
#endif
