/***************************************************************************
                          kbearsystemtraydock.cpp  -  description
                             -------------------
    begin                : mn maj 27 2002
    copyright            : (C) 2002 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//////////////////////////////////////////////////////
// Qt specific includes
#include <qtooltip.h>
//////////////////////////////////////////////////////
// KDE specific includes
#include <klocale.h>
#include <kaction.h>
#include <kiconloader.h>
#include <kapplication.h>
#include <klocale.h>
#include <kconfig.h>
#include <kdebug.h>
//////////////////////////////////////////////////////
// Application specific includes
#include "kbearsystemtraydock.h"

//-----------------------------------------------
KBearSystemTrayDock::KBearSystemTrayDock(QWidget *parent, const char *name, KToggleAction* disconnect, KToggleAction* shutdown )
	:	KSystemTray(parent,name),
		m_disconnectAction( disconnect ), m_shutdownAction( shutdown )
{
	setPixmap( kapp->miniIcon() );
	contextMenu()->insertSeparator();
	contextMenu()->insertItem( i18n("Hide system tray icon"), this, SLOT( hide() ) );
	contextMenu()->insertSeparator();
	m_disconnectAction->plug( contextMenu() );
	contextMenu()->insertSeparator();
	m_shutdownAction->plug( contextMenu() );
	setToolTip( 0, 0 );
}
//-----------------------------------------------
KBearSystemTrayDock::~KBearSystemTrayDock(){
}
//-----------------------------------------------
void KBearSystemTrayDock::show(){
	QString oldGroup = kapp->config()->group();
	kapp->config()->setGroup( "General" );
	kapp->config()->writeEntry( "Show System Tray Icon", true );
	kapp->config()->setGroup( oldGroup );
	kapp->config()->sync();
	KSystemTray::show();
}
//-----------------------------------------------
void KBearSystemTrayDock::setToolTip( int active, int queued ) {
	QString tooltip( i18n("Transfer status:\n%1 Active transfers\n%2 Queued transfers").arg(active,5).arg(queued,5) );
	QToolTip::remove( this );
	QToolTip::add( this, tooltip );
}
//-----------------------------------------------
void KBearSystemTrayDock::hide(){
	QString oldGroup = kapp->config()->group();
	kapp->config()->setGroup( "General" );
	kapp->config()->writeEntry( "Show System Tray Icon", false );
	kapp->config()->setGroup( oldGroup );
	kapp->config()->sync();
	KSystemTray::hide();	
}
//-----------------------------------------------
void KBearSystemTrayDock::enterEvent( QEvent* e ) {
	KSystemTray::enterEvent( e );	
}
//-----------------------------------------------
#ifndef NO_INCLUDE_MOCFILES
#include "kbearsystemtraydock.moc"
#endif
