/***************************************************************************
                          kbearsitemanagertreeview.h  -  description
                             -------------------
    begin                : Sat Sep 16 2000
    copyright            : (C) 2000 by Bjrn Sahlstrm
    email                : bjorn.sahlstrom@mail.bip.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KBEARSITEMANAGERTREEVIEW_H
#define KBEARSITEMANAGERTREEVIEW_H

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qwidget.h>
#include <qtimer.h>
#include <qdragobject.h>
//////////////////////////////////////////////////////////////////////
// application specific include files
#include "kbeartreeview.h"

/**	
	*This class represents the site tree view in the @ref KBearSiteManager. It inherites @ref KBearTreeView
	* in order to add 'drag and drop'  to the view
	*@short This class represents the site tree view
	*@author Bjrn Sahlstrm
*/

class KBearSiteManagerTreeView : public KBearTreeView  {
   Q_OBJECT
public: 
	/** */
	KBearSiteManagerTreeView(QWidget *parent=0, const char *name=0);
	/** */
	~KBearSiteManagerTreeView();
protected slots: // Protected slots
	/**
	*Called automatically when @ref myAutoOpenTimer goes off in order to open the group
	*/
	void slotOpenGroup();
protected: // Protected methods
	/**	*/
	virtual void contentsDragEnterEvent( QDragEnterEvent *e );
	/**	*/
	virtual void contentsDragMoveEvent( QDragMoveEvent *e );
	/**	*/
	virtual void contentsDragLeaveEvent( QDragLeaveEvent *e );
	/**	*/
	virtual void contentsDropEvent( QDropEvent* e );
private:
	QListViewItem* dropItem;
	/** */
	QTimer myAutoOpenTimer;
};

#endif
