/* -*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 *  Copyright (C) 2008  Kouhei Sutou <kou@cozmixng.org>
 *
 *  This library is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef __KZ_TEST_UTILS_H__
#define __KZ_TEST_UTILS_H__

#include <gcutter.h>
#include "src/bookmarks/kz-bookmark.h"

G_BEGIN_DECLS

const gchar   *kz_test_get_base_dir    (void);

#define kz_assert_equal_bookmark(expected, actual, ...) do              \
{                                                                       \
    cut_trace_with_info_expression(                                     \
        kz_assert_equal_bookmark_helper((expected), (actual),           \
                                        #expected, #actual),            \
        kz_assert_equal_bookmark(expected, actual, __VA_ARGS__));       \
} while (0)

void kz_assert_equal_bookmark_helper (KzBookmark *expected,
                                      KzBookmark *actual,
                                      const gchar *expression_expected,
                                      const gchar *expression_actual);

gboolean kz_test_equal_bookmark (KzBookmark *b1, KzBookmark *b2);

G_END_DECLS

#endif /* __KZ_TEST_UTILS_H__ */

/*
vi:ts=4:nowrap:ai:expandtab:sw=4
*/
