/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2007 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copyED of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>
#include "kazehakase.h"
#include "kz-profile.h"
#include "kz-proxy-item.h"

#ifndef __KZ_EMBED_PREFS_H__
#define __KZ_EMBED_PREFS_H__

G_BEGIN_DECLS

#define KZ_TYPE_EMBED_PREFS		(kz_embed_prefs_get_type())
#define KZ_EMBED_PREFS(o)		(G_TYPE_CHECK_INSTANCE_CAST((o), KZ_TYPE_EMBED_PREFS, KzEmbedPrefs))
#define KZ_IS_EMBED_PREFS(o)		(G_TYPE_CHECK_INSTANCE_TYPE((o), KZ_TYPE_EMBED_PREFS))
#define KZ_EMBED_PREFS_GET_IFACE(o)	(G_TYPE_INSTANCE_GET_INTERFACE((o), KZ_TYPE_EMBED_PREFS, KzEmbedPrefsIFace))

typedef struct _KzEmbedPrefs      KzEmbedPrefs;
typedef struct _KzEmbedPrefsIFace KzEmbedPrefsIFace;

struct _KzEmbedPrefsIFace {
	GTypeInterface g_iface;

	gboolean 	(*init)            (KzEmbedPrefs *embed_prefs);

	gboolean  	(*get_passwords)       (KzEmbedPrefs *embed_prefs, GList **passwords);
	gboolean  	(*remove_passwords)    (KzEmbedPrefs *embed_prefs, GList *passwords);
};

GType		kz_embed_prefs_get_type		(void) G_GNUC_CONST;

gboolean 	kz_embed_prefs_init		(KzEmbedPrefs *embed_prefs);
gboolean 	kz_embed_prefs_get_font_list	(KzEmbedPrefs *embed_prefs, const gchar  *lang_group,
						 const gchar  *font_type,
						 GList      **font_list,
						 GList      **all_font_list,
						 gchar       **default_font);

gboolean  	kz_embed_prefs_get_passwords       (KzEmbedPrefs *embed_prefs, GList **passwords);
gboolean  	kz_embed_prefs_remove_passwords    (KzEmbedPrefs *embed_prefs, GList *passwords);

G_END_DECLS

#endif /* __KZ_EMBED_PREFS_H__ */
