/* -*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 *  Copyright (C) 2009 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __KZ_DBUS_EMBED_DELEGATE_H__
#define __KZ_DBUS_EMBED_DELEGATE_H__

#include <gtk/gtk.h>
#include <dbus/dbus-glib.h>

G_BEGIN_DECLS

#define KZ_DBUS_EMBED_DELEGATE_NAME "org.kazehakase.Embed.Delegate"
#define KZ_DBUS_EMBED_DELEGATE_PATH "/org/kazehakase/Embed/Delegate"
#define KZ_DBUS_EMBED_DELEGATE_INTERFACE "org.kazehakase.Embed.Delegate"

#define KZ_EMBED_PROCESS_NAME "org.kazehakase.embed"
#define KZ_EMBED_PROCESS_PATH "/org/kazehakase/Embed"
#define KZ_EMBED_PROCESS_INTERFACE "org.kazehakase.Embed"

#define KZ_TYPE_DBUS_EMBED_DELEGATE		        (kz_dbus_embed_delegate_get_type ())
#define KZ_DBUS_EMBED_DELEGATE(obj)		        (G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_DBUS_EMBED_DELEGATE, KzDBusEmbedDelegate))
#define KZ_DBUS_EMBED_DELEGATE_CLASS(klass)	    (G_TYPE_CHECK_CLASS_CAST ((klass), KZ_TYPE_DBUS_EMBED_DELEGATE, KzDBusEmbedDelegateClass))
#define KZ_IS_EMBED_DBUS(obj)	                (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_DBUS_EMBED_DELEGATE))
#define KZ_IS_EMBED_DBUS_CLASS(klass)           (G_TYPE_CHECK_CLASS_TYPE ((klass), KZ_TYPE_DBUS_EMBED_DELEGATE))
#define KZ_DBUS_EMBED_DELEGATE_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), KZ_TYPE_DBUS_EMBED_DELEGATE, KzDBusEmbedDelegateClass))

typedef struct _KzDBusEmbedDelegate KzDBusEmbedDelegate;
typedef struct _KzDBusEmbedDelegateClass KzDBusEmbedDelegateClass;

struct _KzDBusEmbedDelegate
{
    GtkSocket parent;
};

struct _KzDBusEmbedDelegateClass
{
    GtkSocketClass parent;
};

GType        kz_dbus_embed_delegate_get_type (void) G_GNUC_CONST;
void         kz_dbus_embed_delegate_register_type
                                             (GTypeModule *module);
GtkWidget   *kz_dbus_embed_delegate_new      (const gchar *socket_address);
void         kz_dbus_embed_delegate_set_connection
                                             (KzDBusEmbedDelegate *delegate,
                                              DBusGConnection  *connection);

G_END_DECLS

#endif /* __KZ_DBUS_EMBED_DELEGATE_H__ */
/* 
vi:ts=4:nowrap:ai:expandtab:sw=4
*/
