/* Egg Libraries: egg-pixbuf-thumbnail.h
 * 
 * Copyright (c) 2004 James M. Cape <jcape@ignore-your.tv>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __EGG_PIXBUF_THUMBNAIL_H__
#define __EGG_PIXBUF_THUMBNAIL_H__ 1

#include <time.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

G_BEGIN_DECLS


typedef enum /* <prefix=EGG_PIXBUF_THUMB> */
{
  EGG_PIXBUF_THUMB_UNKNOWN = -1,
  EGG_PIXBUF_THUMB_NORMAL  = 128,
  EGG_PIXBUF_THUMB_LARGE   = 256
}
EggPixbufThumbSize;


GdkPixbuf             *egg_pixbuf_get_thumbnail_for_file         (const gchar         *filename,
								  EggPixbufThumbSize   size,
								  GError             **error);
GdkPixbuf             *egg_pixbuf_get_thumbnail_for_file_at_size (const gchar         *filename,
								  gint                 pixel_size,
								  GError             **error);

GdkPixbuf             *egg_pixbuf_load_thumbnail                 (const gchar         *uri,
								  time_t               mtime,
								  EggPixbufThumbSize   size);
GdkPixbuf             *egg_pixbuf_load_thumbnail_at_size         (const gchar         *uri,
								  time_t               mtime,
								  gint                 pixel_size);

gboolean               egg_pixbuf_save_thumbnail                 (GdkPixbuf           *thumbnail,
								  GError             **error,
								  ...);
gboolean               egg_pixbuf_save_thumbnailv                (GdkPixbuf           *thumbnail,
								  gchar              **keys,
								  gchar              **values,
								  GError             **error);

gboolean               egg_pixbuf_has_failed_thumbnail           (const gchar         *uri,
								  time_t               mtime,
								  GError             **error);
void                   egg_pixbuf_save_failed_thumbnail          (const gchar         *uri,
								  time_t               mtime,
								  const GError        *error);

GdkPixbuf            *egg_pixbuf_create_thumbnail               (GdkPixbuf           *pixbuf,
								 const gchar         *uri,
								 time_t               mtime,
								 EggPixbufThumbSize   size);

gboolean              egg_pixbuf_add_thumbnail_data             (GdkPixbuf           *pixbuf,
								 const gchar         *uri,
								 time_t               mtime,
								 EggPixbufThumbSize   size);
gboolean              egg_pixbuf_has_thumbnail_data             (GdkPixbuf           *pixbuf);

EggPixbufThumbSize    egg_pixbuf_get_thumb_size                 (GdkPixbuf           *thumbnail);
gboolean	      egg_pixbuf_set_thumb_size                 (GdkPixbuf           *thumbnail,
								 EggPixbufThumbSize   size);

G_CONST_RETURN gchar *egg_pixbuf_get_thumb_uri                  (GdkPixbuf           *thumbnail);
gboolean	      egg_pixbuf_set_thumb_uri                  (GdkPixbuf           *thumbnail,
								 const gchar         *uri);
G_CONST_RETURN gchar *egg_pixbuf_get_thumb_mime_type            (GdkPixbuf           *thumbnail);
gboolean	      egg_pixbuf_set_thumb_mime_type            (GdkPixbuf           *thumbnail,
								 const gchar         *mime_type);
G_CONST_RETURN gchar *egg_pixbuf_get_thumb_description          (GdkPixbuf           *thumbnail);
gboolean	      egg_pixbuf_set_thumb_description          (GdkPixbuf           *thumbnail,
								 const gchar         *description);
time_t		      egg_pixbuf_get_thumb_mtime                (GdkPixbuf           *thumbnail);
gboolean	      egg_pixbuf_set_thumb_mtime                (GdkPixbuf           *thumbnail,
								 time_t               mtime);
gssize		      egg_pixbuf_get_thumb_filesize             (GdkPixbuf           *thumbnail);
gboolean	      egg_pixbuf_set_thumb_filesize             (GdkPixbuf           *thumbnail,
								 gssize               filesize);
gint		      egg_pixbuf_get_thumb_image_width          (GdkPixbuf           *thumbnail);
gboolean	      egg_pixbuf_set_thumb_image_width          (GdkPixbuf           *thumbnail,
								 gint                 image_width);
gint		      egg_pixbuf_get_thumb_image_height         (GdkPixbuf           *thumbnail);
gboolean	      egg_pixbuf_set_thumb_image_height         (GdkPixbuf           *thumbnail,
								 gint                 image_height);
gint		      egg_pixbuf_get_thumb_document_pages       (GdkPixbuf           *thumbnail);
gboolean	      egg_pixbuf_set_thumb_document_pages       (GdkPixbuf           *thumbnail,
								 gint                 document_pages);
time_t		      egg_pixbuf_get_thumb_movie_length         (GdkPixbuf           *thumbnail);
gboolean	      egg_pixbuf_set_thumb_movie_length         (GdkPixbuf           *thumbnail,
								 time_t               movie_length);

G_CONST_RETURN gchar *egg_pixbuf_get_thumb_software             (GdkPixbuf           *thumbnail);


gchar                *egg_pixbuf_get_thumb_filename             (const gchar         *uri,
								 EggPixbufThumbSize   size);

G_END_DECLS

#endif /* !__EGG_PIXBUF_THUMBNAIL_H__ */
