/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __KZ_DOWNLOADER_H__
#define __KZ_DOWNLOADER_H__

#include <glib-object.h>
#include "kz-io.h"

G_BEGIN_DECLS

#define KZ_TYPE_DOWNLOADER		(kz_downloader_get_type ())
#define KZ_DOWNLOADER(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_DOWNLOADER, KzDownloader))
#define KZ_DOWNLOADER_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass), KZ_TYPE_DOWNLOADER, KzDownloaderClass))
#define KZ_IS_DOWNLOADER(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_DOWNLOADER))
#define KZ_IS_DOWNLOADER_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), KZ_TYPE_DOWNLOADER))
#define KZ_DOWNLOADER_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), KZ_TYPE_DOWNLOADER, KzDownloaderClass))

typedef struct _KzDownloader   		KzDownloader;
typedef struct _KzDownloaderClass	KzDownloaderClass;

struct _KzDownloader
{
	GObject parent;
	KzIO *io;

	gchar  *uri;
	gchar  *dir;
	gchar  *filename;
};

struct _KzDownloaderClass
{
	GObjectClass parent_class;

	/* -- signals -- */
	void (*start)     (KzDownloader *downloader);
	void (*completed) (KzDownloader *downloader);
	void (*error)     (KzDownloader *downloader);
	void (*io_in)     (KzDownloader *downloader);
	/* for virtual function */
	void  (*kz_downloader_cancel)      (KzDownloader *downloader);
	gint  (*kz_downloader_get_percent) (KzDownloader *downloader);
};

GType         kz_downloader_get_type          (void) G_GNUC_CONST;
KzDownloader *kz_downloader_new               (const gchar *uri);
KzDownloader *kz_downloader_new_with_filename (const gchar *uri, const gchar *filename);

void          kz_downloader_cancel               (KzDownloader *downloader);
gboolean      kz_downloader_to_file              (KzDownloader *downloader);
gboolean      kz_downloader_to_buffer            (KzDownloader *downloader);
const gchar  *kz_downloader_get_string           (KzDownloader *downloader);
gsize         kz_downloader_get_size             (KzDownloader *downloader);
gint          kz_downloader_get_percent          (KzDownloader *downloader);
gsize         kz_downloader_get_current_progress (KzDownloader *downloader);
gsize         kz_downloader_get_total_progress   (KzDownloader *downloader);

G_END_DECLS

#endif /* __KZ_DOWNLOADER_H__ */
