/*
 *  Copyright (C) 2004 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *  $Id: MozillaPrivate.h,v 1.3 2005/03/16 01:05:49 ikezoe Exp $
 */

/*
 * Based on MozillaPrivate.cpp in Epiphany-1.5.1.
 *  Copyright (C) 2003, 2004 Marco Pesenti Gritti
 */

#include <glib.h>
#include <nsIPrintSettings.h>
#include <nsIDOMDocument.h>
#include <nsIDOMRange.h>
#include <nsISelection.h>
#include <nsIDocShell.h>

namespace MozillaPrivate
{
	GList    *GetPrinterList      ();
	gboolean  CreatePrintSettings (nsIPrintSettings **options);
	gboolean  GetRootRange        (nsIDOMDocument *domDoc, nsIDOMRange *range);
	gboolean  GetSelectedRange    (nsIDOMDocument *domDoc, nsIDOMRange *range,
				       nsISelection *selection, gboolean backward);
	gboolean  SetZoomOnDocShell   (float aZoom, nsIDocShell *DocShell);
}
