#include <KayaAPI.h>
#include "binary_glue.h"
#include "stdfuns.h"

void* newBlock(int size)
{
    return (void*)GC_MALLOC_ATOMIC(size);
}

void poke(void* block,int offset,int val)
{
    BYTE* data = (BYTE*)block;
    *(data+offset)=val;
}

int peek(void* block,int offset)
{
    BYTE* data = (BYTE*)block;
    return (int)(*(data+offset));
}

void pokestring(void* block, int offset, wchar_t* str)
{
    BYTE* point = ((BYTE*)block)+offset;
    memcpy(point,wctostr(str),strlen(wctostr(str))+1);
}

wchar_t* peekstring(void* block, int offset)
{
    char* str = (char*)(((BYTE*)block)+offset);
    char* buf = (char*)(KayaAlloc(strlen(str)));
    strcpy(buf,str);
    return strtowc(str);
}

void* copyBlock(void* block, int size)
{
    void* newblock = (void*)KayaAlloc(size);
    memcpy(newblock,block,size);
    return newblock;
}

void* copyChunk(void* block,int offset,int size)
{
    void* newblock = (void*)GC_MALLOC_ATOMIC(size);
    void* blockstart = (void*)((BYTE*)block+offset);
    memcpy(newblock,blockstart,size);
    return newblock;
}

KayaArray getBlockData(void* block, int offset,int size)
{
    BYTE* blockloc = (BYTE*)block+offset;
    KayaArray data = newKayaArray(size);
    for(int i=0;i<size;i++) {
	KayaValue v = KayaInt((int)(*blockloc));
	KayaArrayPush(data,v);
	blockloc++;
    }
    return data;
}

void setBlockData(void* block, int offset, int size, KayaArray data)
{
    int v;
    BYTE* blockloc = (BYTE*)block+offset;
    for(int i=0;i<size;i++) {
	v = KayaGetInt(KayaArrayLookup(data,i));
	*blockloc = (BYTE)v;
	blockloc++;
    }
}

int writeBlock(FILE* f,void* block, int size)
{
    return fwrite(block,1,size,f);
}

void* readBlock(FILE* f, KayaValue size)
{
    int isize = KayaGetInt(size);
    void* newblock = (void*)GC_MALLOC_ATOMIC(isize);
    isize = fread(newblock,1,isize,f);
    KayaSetInt(size,isize);
    return newblock;
}

wchar_t* b64binary(void* block, int len)
{
    return strtowc(b64enc((char*)block, len));
}

void* b64binarydec(wchar_t* block, KayaValue len)
{
  // use wctostr to get binary decoding
    return (void*)(b64dec(wctostr(block), len));
}
