#ifndef _ARRAY_H
#define _ARRAY_H

/**
    Kaya run-time system
    Copyright (C) 2004, 2005 Edwin Brady

    This file is distributed under the terms of the GNU Lesser General
    Public Licence. See COPYING for licence.
*/

using namespace std;

#ifndef WIN32
#include <pthread.h>
#define GC_PTHREADS
#else
#define GC_WIN32_THREADS
#endif
#include <gc/gc_cpp.h>
#include <map>

class Value;

/** Chunks of data inside arrays. 
    We can't move arrays around if they grow, as there might be references 
    into them, so we store them as a linked list of chunks. */
struct chunk : public gc {
    Value** data;
    int size;
    chunk* next;
};

class Array : public gc_cleanup
{
public:
    Array(int size=0);
    ~Array();
    void push_back(Value* v);
    Value* lookup(int i);
    inline int size() { return m_size; }
    inline int reserved_size() { return m_alloc; }
    Array* copy(map<Value*,Value*>& done);
    void resize(int i);
    Value* shift();

    /// Make sure there's enough space for at least i things.
    void expectedSize(int i);

    int memusage();
//    void append(Array* xs);

    bool eq(Array* x);
    int cmp(Array* x);

private:
    int m_alloc;
    int m_size;
    chunk* m_first;
};

#endif
