
/*
 * Kanatest
 *
 * Copyright (C) 2001 Tomasz Mka
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <config.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/stat.h>

#include <gtk/gtk.h>

#include "main.h"
#include "prefs.h"

struct jpprefs config;

FILE *prefs_filehandle;


/*---------------------------------------------------------------------------*/

gchar* s_getdir_config (void)
{
static gchar cfgdir[MAX_PATH];
struct stat cfg;

	s_strcpy (cfgdir, getenv ("HOME"), MAX_PATH);
	s_strcat (cfgdir, "/.clay", MAX_PATH);

	if(stat (cfgdir, &cfg) < 0)
		mkdir (cfgdir, S_IRUSR | S_IWUSR | S_IXUSR);

	return cfgdir;
}

/*---------------------------------------------------------------------------*/

gchar* s_getfilename_config (void)
{
static gchar filename[MAX_PATH];

	s_strcpy (filename, s_getdir_config(), MAX_PATH);
	s_strcat (filename, slash, MAX_PATH);
	s_strcat (filename, config_filename, MAX_PATH);

	return filename;
}

/*---------------------------------------------------------------------------*/

void* s_prefs_openfile (gchar *filename, gint openmode)
{
	prefs_filehandle = NULL;

	if (openmode == P_READ)
		prefs_filehandle = fopen (filename, "rb");
	else if (openmode == P_WRITE)
		prefs_filehandle = fopen (filename, "wb");
    
	return prefs_filehandle;
}


void s_prefs_closefile (void)
{
	fclose (prefs_filehandle);
}

/*---------------------------------------------------------------------------*/

void s_prefs_put_int (gchar *tagname, gint value)
{
	fprintf (prefs_filehandle, "%s = %d\n", tagname, value);
}


void s_prefs_put_float (gchar *tagname, gfloat value)
{
	fprintf (prefs_filehandle, "%s = %f\n", tagname, value);
}


void s_prefs_put_string (gchar *tagname, gchar *value)
{
	fprintf (prefs_filehandle, "%s = %s\n", tagname, value);
}


void s_prefs_put_lf (void)
{
	fprintf (prefs_filehandle, "\n");
}


void s_prefs_put_comment (gchar *comment)
{
gchar text[MAX_LINE_LEN];

		s_strcpy (text, "# ", MAX_LINE_LEN);
		s_strcat (text, comment, MAX_LINE_LEN);
		fprintf (prefs_filehandle, text);
}

/*---------------------------------------------------------------------------*/

gchar* s_prefs_get_line_with_tag (gchar *tagname)
{
static gchar prfline[MAX_LINE_LEN];
gint i;
gchar c;

	fseek (prefs_filehandle, 0, SEEK_SET);	
    
	while (!feof (prefs_filehandle)) {
		i = 0;

		while (((c = fgetc (prefs_filehandle)) != crlf_char) && c!= EOF && i < MAX_LINE_LEN)
			prfline[i++] = c;
            
		prfline[i] = null_char;
        
		if (prfline[0] != '#')
			if (!strncmp (tagname, prfline, strlen (tagname))) break;
	}
        
	return prfline;
}


gchar* s_prefs_get_value_field (gchar *tagname)
{
static gchar valuestr[MAX_VALUE_LEN];
gchar *valpos, c;
gint i;

	i = 0;

	if ((valpos = strchr (s_prefs_get_line_with_tag (tagname), '='))) {
		while((c = valpos[i+2]) != null_char && i < MAX_VALUE_LEN) valuestr[i++] = c;
	}
    
	valuestr[i] = null_char;
	return valuestr;
}


gint s_prefs_get_int (gchar *tagname)
{
	return (atoi (s_prefs_get_value_field (tagname)));
}


gfloat s_prefs_get_float (gchar *tagname)
{
	return (atof (s_prefs_get_value_field (tagname)));
}


gchar* s_prefs_get_string (gchar *tagname)
{
	return (s_prefs_get_value_field (tagname));
}

/*---------------------------------------------------------------------------*/
/* following functions based on samba sources.                               */
/* safe_strcpy and safe_strcat routines written by Andrew Tridgell           */
/*---------------------------------------------------------------------------*/

gchar* s_strcpy (gchar *dest, const gchar *src, guint maxlength)
{
guint len;

	if (!dest) {
		printf ("ERROR: NULL dest in safe_strcpy\n");
		return NULL;
	}

	if (!src) {
		*dest = 0;
		return dest;
	}

	len = strlen(src);

	if (len > maxlength) {
		printf ("ERROR: string overflow by %d in safe_strcpy [%.50s]\n",
				(int)(len-maxlength), src);
		len = maxlength;
	}
      
	memcpy(dest, src, len);
	dest[len] = 0;
	return dest;
}

/*---------------------------------------------------------------------------*/

gchar* s_strcat (gchar *dest, const gchar *src, guint maxlength)
{
guint src_len, dest_len;

	if (!dest) {
		printf ("ERROR: NULL dest in safe_strcat\n");
		return NULL;
	}

	if (!src) {
		return dest;
	}

	src_len = strlen(src);
	dest_len = strlen(dest);

	if (src_len + dest_len > maxlength) {
		printf ("ERROR: string overflow by %d in safe_strcat [%.50s]\n",
				(int)(src_len + dest_len - maxlength), src);
		src_len = maxlength - dest_len;
	}
      
	memcpy(&dest[dest_len], src, src_len);
	dest[dest_len + src_len] = 0;
	return dest;
}

/*---------------------------------------------------------------------------*/

void read_config (void)
{

	if (s_prefs_openfile (s_getfilename_config (), P_READ)) {
    
		config.window_x = s_prefs_get_int ("window_pos_x");
		config.window_y = s_prefs_get_int ("window_pos_y");
		config.window_size_x = s_prefs_get_int ("window_size_x");
		config.window_size_y = s_prefs_get_int ("window_size_y");
		config.stat_window_x = s_prefs_get_int ("stat_window_pos_x");
		config.stat_window_y = s_prefs_get_int ("stat_window_pos_y");
		config.about_window_x = s_prefs_get_int ("about_window_pos_x");
		config.about_window_y = s_prefs_get_int ("about_window_pos_y");
		s_strcpy (config.data_path, s_prefs_get_string ("data_path"), MAX_PATH);

		config.last_mode = s_prefs_get_int ("last_mode");
		config.repeat_wrong = s_prefs_get_int ("repeat_wrong");
		config.t_time = s_prefs_get_float ("t_time");

		config.run_counter = s_prefs_get_int ("run_counter");

		config.hiragana_counter = s_prefs_get_int ("hiragana_counter");
		config.katakana_counter = s_prefs_get_int ("katakana_counter");
		config.mixed_counter = s_prefs_get_int ("mixed_counter");

		config.hiragana_max_result = s_prefs_get_int ("hiragana_max_result");
		config.katakana_max_result = s_prefs_get_int ("katakana_max_result");
		config.mixed_max_result = s_prefs_get_int ("mixed_max_result");

		config.hiragana_time = s_prefs_get_float ("hiragana_time");
		config.katakana_time = s_prefs_get_float ("katakana_time");
		config.mixed_time = s_prefs_get_float ("mixed_time");
        
		s_prefs_closefile ();
        
	} else {

		config.window_x = 50;
		config.window_y = 100;
		config.window_size_x = 255;
		config.window_size_y = 370;
		config.stat_window_x = 100;
		config.stat_window_y = 100;
		config.about_window_x = 150;
		config.about_window_y = 100;

		config.run_counter = 0;

		config.hiragana_counter = 0;
		config.katakana_counter = 0;
		config.mixed_counter = 0;

		config.hiragana_max_result = 0;
		config.katakana_max_result = 0;
		config.mixed_max_result = 0;

		config.hiragana_time = 0.0;
		config.katakana_time = 0.0;
		config.mixed_time = 0.0;

		config.last_mode = HIRAGANA;
		config.repeat_wrong = FALSE;

		config.t_time = 0.0;

		s_strcpy (config.data_path, PACKAGE_DATA_DIR, MAX_PATH);

		write_config ();
	}
    
}

/*------------------------------------------------------------------------*/

void write_config(void)
{
	if (s_prefs_openfile (s_getfilename_config (), P_WRITE)) {
    
		s_prefs_put_string ("data_path", config.data_path);
		s_prefs_put_int ("window_pos_x", config.window_x);
		s_prefs_put_int ("window_pos_y", config.window_y);
		s_prefs_put_int ("window_size_x", config.window_size_x);
		s_prefs_put_int ("window_size_y", config.window_size_y);
		s_prefs_put_int ("stat_window_pos_x", config.stat_window_x);
		s_prefs_put_int ("stat_window_pos_y", config.stat_window_y);
		s_prefs_put_int ("about_window_pos_x", config.about_window_x);
		s_prefs_put_int ("about_window_pos_y", config.about_window_y);
		s_prefs_put_int ("last_mode", config.last_mode);
		s_prefs_put_int ("repeat_wrong", config.repeat_wrong);
		s_prefs_put_float ("t_time", config.t_time);
		s_prefs_put_int ("run_counter", config.run_counter);

		s_prefs_put_int ("hiragana_counter", config.hiragana_counter);
		s_prefs_put_int ("katakana_counter", config.katakana_counter);
		s_prefs_put_int ("mixed_counter", config.mixed_counter);

		s_prefs_put_int ("hiragana_max_result", config.hiragana_max_result);
		s_prefs_put_int ("katakana_max_result", config.katakana_max_result);
		s_prefs_put_int ("mixed_max_result", config.mixed_max_result);

		s_prefs_put_float ("hiragana_time", config.hiragana_time);
		s_prefs_put_float ("katakana_time", config.katakana_time);
		s_prefs_put_float ("mixed_time", config.mixed_time);
	}
        
	s_prefs_closefile ();
}
    
/*------------------------------------------------------------------------*/

