/***************************************************************************
    copyright            : (C) 2006 by Mantia Andras
    email                : amantia@kdewebdev.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 
//own includes
#include "firstpage.h"
#include "kalleryfunctions.h"
#include "kalleryglobals.h"

//KDE includes
#include <kapplication.h>
#include <kfiledialog.h>
#include <klocale.h>
#include <kwizard.h>

//Qt includes
#include <qlabel.h>
#include <qradiobutton.h>

FirstPage::FirstPage(QWidget *parent, const char *name)
    :KFirstPage(parent, name)
{
  LogoPixmap->setPixmap(QPixmap(KalleryGlobals::ref()->baseDir() + "images/kallery.png", 0, QPixmap::Auto));

  connect(OpenProjectBtn, SIGNAL(clicked()), this, SLOT(slotOpenProject()));

}

void FirstPage::slotOpenProject()
{
  QString projectFileName;

  projectFileName = KFileDialog::getOpenFileName("","*.kallery\n*|All files",this,i18n("Open project"));
  if (!projectFileName.isEmpty())
  {
    if (KalleryFunctions::ref()->openProject(projectFileName) )
    {
      QString baseDir = QFileInfo(KalleryGlobals::ref()->options.galleryFile).dirPath()+"/";
      KalleryGlobals::ref()->setProjectBaseDir(baseDir);
      KalleryGlobals::ref()->setProjectFile(projectFileName);
      emit projectLoaded();
    }
    else
    {
      KalleryGlobals::ref()->setDefaultOptions();
    }
  } else
    StartNewBtn->setChecked(true);
}


void FirstPage::invokeHelp()
{
  kapp->invokeHelp("first-page", "kallery");
}

bool FirstPage::processPage()
{
   if (StartNewBtn->isChecked())
    KalleryGlobals::ref()->setDefaultOptions();
  return true;
}

void FirstPage::setupPage()
{
  //no need to set up the first page
}

#include "firstpage.moc"
