#ifndef KADU_CUSTOM_INPUT_H
#define KADU_CUSTOM_INPUT_H

#include <qmultilineedit.h>

class QKeyEvent;
class QWidget;

/**
	\class CustomInput
	\brief Klasa umoliwiajca wpisywanie wiadomoci
**/
class CustomInput : public QMultiLineEdit
{
	Q_OBJECT

	protected:

		bool autosend_enabled;/*!< zmienna informujca czy wczone jest
					automatyczne wysyanie */
		/**
			\fn virtual void keyPressEvent(QKeyEvent *e)
			Funkcja obsugujca nacinicie przycisku
			\param e wskanik do obiektu obsugujcego klawisze
		**/
		virtual void keyPressEvent(QKeyEvent *e);

		/**
			\fn virtual void keyReleaseEvent(QKeyEvent *e)
			Funkcja obsugujca zwolnienie przycisku
			\param e wskanik do obiektu obsugujcego klawisze
		**/
		virtual void keyReleaseEvent(QKeyEvent* e);

	public:

		/*! Typ wyliczeniowy mowicy o rodzaju pisanych znakw */
		enum
		{
			KEY_BOLD,/*!< pogrubienie */
			KEY_ITALIC,/*!< kursywa */
			KEY_UNDERLINE/*!< podkrelenie */
		};

		/**
			\fn CustomInput(QWidget* parent = 0, const char* name = 0)
			Konstruktor tworzcy obiekt
			i ustawiajcy odpowiedni styl
			\param parent rodzic okna
			\param name nazwa obiektu
		**/
		CustomInput(QWidget* parent = 0, const char* name = 0);

	public slots:

		/**
			\fn void paste()
			Slot wkleja czysty tekst
		**/
		void paste();

		/**
			\fn void setAutosend(bool on)
			Ustawia/wycza automatyczne wysyanie wiadomoci
			\param on zmienna ustawiajca autosend
		**/
		void setAutosend(bool on);

	signals:

		/**
			\fn void sendMessage()
			Sygna zostaje wysany kiedy nacinito
			klawisz wysania wiadomoci
		**/
		void sendMessage();

		/**
			\fn void specialKeyPressed(int key)
			Sygna zostaje wysany gdy nacinito specjalny
			klawisz (skrt) odpowiadajcy np KEY_BOLD
			\param key warto z typu wyliczeniowego KEY_*
		**/
		void specialKeyPressed(int key);

		/**
			\fn void keyPressed(QKeyEvent* e, CustomInput* sender, bool &handled)
			Dowolny przycisk klawiatury zosta nacinity.
			Przekazany zostaje take obiekt, ktry wywoa akcj -
			 czyli this
			\param e wskanik do obiektu obsugujcego klawisze
			\param sender wskanik do obiektu, ktry
			wywoa ten sygna
			\param handled Slot osbugujcy ten sygna powinien ten parametr ustawi na true,
			jeli zdarzenie zostao ju obsuone i adne czynnoci zwizane
			ze standardow obsug kontrolek Qt nie powinny by podjte.
		**/
		void keyPressed(QKeyEvent* e, CustomInput* sender, bool &handled);

		/**
			\fn void keyReleased(QKeyEvent* e, CustomInput* sender, bool &handled)
			Dowolny przycisk klawiatury zosta zwolniony.
			Przekazany zostaje take obiekt, ktry wywoa akcj -
			 czyli this.
			\param e wskanik do obiektu obsugujcego klawisze
			\param sender wskanik do obiektu, ktry
			wywoa ten sygna
			\param handled Slot osbugujcy ten sygna powinien ten parametr ustawi na true,
			jeli zdarzenie zostao ju obsuone i adne czynnoci zwizane
			ze standardow obsug kontrolek Qt nie powinny by podjte.
		**/
		void keyReleased(QKeyEvent* e, CustomInput* sender, bool &handled);
};

#endif
