/***************************************************************************
*                                                                          *
*   This program is free software; you can redistribute it and/or modify   *
*   it under the terms of the GNU General Public License as published by   *
*   the Free Software Foundation; either version 3 of the License, or      *
*   (at your option) any later version.                                    *
*                                                                          *
***************************************************************************/


#ifndef GLOBALHOTKEYS_H
	#define GLOBALHOTKEYS_H


#include <qguardedptr.h>
#include <qmap.h>
#include <qptrlist.h>
#include <qstring.h>
#include <qtimer.h>

#include "configuration_aware_object.h"
#include "configuration_window_widgets.h"
#include "main_configuration_window.h"

#include "globalhotkeys.h"

#include <X11/Xlib.h>
#include <X11/keysym.h>


#define  GLOBALHOTKEYS_CONFIGURATIONCLEARKEY                           XK_BackSpace
#define  GLOBALHOTKEYS_HOTKEYSTIMERINTERVAL                                      50   /* ms */
#define  GLOBALHOTKEYS_X11SHIFTMASK                                       ShiftMask
#define  GLOBALHOTKEYS_X11CONTROLMASK                                   ControlMask
#define  GLOBALHOTKEYS_X11ALTMASK                                          Mod1Mask
#define  GLOBALHOTKEYS_X11ALTGRMASK                                        Mod5Mask
#define  GLOBALHOTKEYS_X11SUPERMASK                                        Mod4Mask
#define  GLOBALHOTKEYS_X11CAPSLOCKMASK                                     LockMask
#define  GLOBALHOTKEYS_X11NUMLOCKMASK                                      Mod2Mask
#define  GLOBALHOTKEYS_X11LSHIFT                                         XK_Shift_L
#define  GLOBALHOTKEYS_X11RSHIFT                                         XK_Shift_R
#define  GLOBALHOTKEYS_X11LCONTROL                                     XK_Control_L
#define  GLOBALHOTKEYS_X11RCONTROL                                     XK_Control_R
#define  GLOBALHOTKEYS_X11LALT                                             XK_Alt_L
#define  GLOBALHOTKEYS_X11RALT                                             XK_Alt_R
#define  GLOBALHOTKEYS_X11ALTGR                                 XK_ISO_Level3_Shift
#define  GLOBALHOTKEYS_X11LSUPER                                         XK_Super_L
#define  GLOBALHOTKEYS_X11RSUPER                                         XK_Super_R
#define  GLOBALHOTKEYS_SHOWANDACTIVATETIMERINTERVAL                              50   /* ms */
#define  GLOBALHOTKEYS_RECENTCHATSMENUINACTIVITYTIMERINTERVAL                    50   /* ms */


static int messageshandled;
void EmptyMsgHandler( QtMsgType type, const char *msg );


class Hotkey
{
	public:
		Hotkey( bool _shift, bool _control, bool _alt, bool _altgr, bool _super, int _keycode, QString _comment = "" );
		Hotkey( QString hotkeystring );
		bool equals( Hotkey *h );
		bool shift;
		bool control;
		bool alt;
		bool altgr;
		bool super;
		int keycode;
		QString comment;
};


class HotkeyEdit : public ConfigLineEdit
{
	public:
		HotkeyEdit( const QString &section, const QString &item, const QString &widgetCaption, const QString &toolTip, ConfigGroupBox *parentConfigGroupBox, char *name=0 )
			: ConfigLineEdit( section, item, widgetCaption, toolTip, parentConfigGroupBox, name ) {}
		HotkeyEdit( ConfigGroupBox *parentConfigGroupBox, char *name=0 )
			: ConfigLineEdit( parentConfigGroupBox, name ) {}
	protected:
		virtual bool x11Event( XEvent *event );
		virtual void focusInEvent( QFocusEvent *event );
		virtual void focusOutEvent( QFocusEvent *event );
	private:
		QString lastvalidvalue;
};


class GlobalHotkeys : public ConfigurationUiHandler, ConfigurationAwareObject
{
	Q_OBJECT
	public:
		GlobalHotkeys();
		~GlobalHotkeys();
		void mainConfigurationWindowCreated( MainConfigurationWindow *mainConfigurationWindow );
	protected:
		void configurationUpdated();
	private slots:
		void checkPendingHotkeys();
		void showAndActivateToplevel();
		void openRecentChat( int n );
		void recentchatsmenuinactivitytimerTimeout();
	private:
		void createDefaultConfiguration();
		void grabHotkeys( QMap<QString,Hotkey*> hotkeys );
		QTimer *hotkeysTimer;
		Display *display;
		QMap<QString,Hotkey*> hotkeys;
		QGuardedPtr<OpenChatWith> openchatwithwindow;
		QPopupMenu *recentchatsmenu;
		QMap<int,UserListElements> recentchatsusers;
		QMap<int,QWidget*> recentchatswindows;
		QTimer *recentchatsmenuinactivitytimer;
		QString showKadusMainWindow;           // configuration value
		QString hideKadusMainWindow;           // configuration value
		QString showHideKadusMainWindow;       // configuration value
		QString openIncomingChatWindow;        // configuration value
		QString openAllIncomingChatWindows;    // configuration value
		QString minimizeOpenedChatWindows;     // configuration value
		QString restoreMinimizedChatWindows;   // configuration value
		QString minimizeRestoreChatWindows;    // configuration value
		QString closeAllChatWindows;           // configuration value
		QString openChatWith;                  // configuration value
		QString openRecentChats;               // configuration value
};


extern GlobalHotkeys *globalHotkeys;


#endif
