#ifndef MAIL_H
#define MAIL_H

/*
 * autor 
 * Micha Podsiadlik
 * michal at gov.one.pl
 *
 * obsluga maildir:
 * Konrad Klimaszewski
 * klimasz at if.pw.edu.pl>
 */

#include <qsocket.h>
#include <qtimer.h>
#include <qstring.h>

#include "main_configuration_window.h"

#include "pop3.h"

class QLineEdit;
class QListBox;

class Mail : public ConfigurationUiHandler
{
	Q_OBJECT

	public:	
		Mail();
		virtual ~Mail();
		virtual void mainConfigurationWindowCreated(MainConfigurationWindow *mainConfigurationWindow);
			
	private:
		QTimer *timer;
		QString formatmessage(int last, int total, int size, QString name);
		QPtrList<Pop3Proto> accounts;
		void updateList();

		QListBox *accountsListBox;
		QLineEdit *maildirLineEdit;

		/**
			\fn void import_0_5_0_Configuration()
			Import danych konfiguracyjnych ze starszej wersji Kadu.
		**/
		void import_0_5_0_Configuration();
		void createDefaultConfiguration();
				
	public slots:
		void checkmail();
		void onSelectMaildir();
		void maildir();
		void printstat(int last, int total, int size, QString name);
		void onAddButton();
		void onEditButton();
		void onRemoveButton();
		void configurationWindowApplied();

};

extern Mail* mail;

#endif
