#ifndef K3DDIALOG_H
#define K3DDIALOG_H

// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\brief Declares the k3dObjectDialog class, which provides a standard dialog implementation for K-3D objects
		\author Tim Shead (tshead@k-3d.com)
*/

#include "k3duserinterfaceelement.h"
#include "window_geometry.h"

#include <boost/filesystem/path.hpp>
#include <memory>

/////////////////////////////////////////////////////////////////////////////
// k3dDialog

class k3dDialog :
	public k3dUserInterfaceElement
{
	typedef k3dUserInterfaceElement base;

public:
	k3dDialog(k3d::iunknown* ParentCommandNode, const std::string& CommandNodeName, k3d::window_geometry_store* const GeometryStore);
	virtual ~k3dDialog();

	/// Standard UI destruction (deletes this object)
	virtual void CloseDialog();

protected:
	/// Called to load a GTKML template from a stream (connects to some standard events)
	virtual bool LoadGTKMLTemplate(std::istream& Stream, const std::string& StreamName);
	/// Called to load a GTKML template file (connects to some standard events)
	virtual bool LoadGTKMLTemplate(const boost::filesystem::path& Template);

	/// Called to make this dialog visible (also handles restoring saved window positions)
	virtual void Show();

	/// Called to cleanly refresh dialog controls (temporarily suspends event-handling)
	virtual void CallUpdateControls();

	/// Does the work of updating controls when their underlying data changes
	virtual void UpdateControls();

	// Event-handling ...
	void OnEvent(sdpGtkEvent* Event);

	// Built-in events ...
	virtual void OnOK();
	virtual void OnClose();
	/// Called when the user hits the window manager "close" button
	virtual void OnDelete(sdpGtkEvent* Event);
	
	/// Updates current window geometry (size & position) from the stored window_geometry_store object (if any)
	void restore_geometry();

private:
	/// Called when the window is resized
	void on_resize();

	/// Stores an object that can serialize our window configuration
	const std::auto_ptr<k3d::window_geometry_store> m_geometry_store;
};

#endif // K3DDIALOG_H

