
/*
 * typedefs.h -- written for Juice
 *	Copyright (C) 1999, 2000, 2001 Abraham vd Merwe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef CONFIG_TYPEDEFS_H
#define CONFIG_TYPEDEFS_H

/*
 * Boolean definitions
 */

//#ifndef bool
#undef bool
#define bool int
//#endif

//#ifndef TRUE
#undef TRUE
#define TRUE 1
//#endif

//#ifndef FALSE
#undef FALSE
#define FALSE 0
//#endif

/*
 * Entry types
 */

#define CFG_TYPE_INTEGER	0
#define CFG_TYPE_BOOLEAN	1
#define CFG_TYPE_STRING		2

/*
 * Errors
 */

#define CFG_ERROR_NONE		0		/* No error occurred */
#define CFG_ERROR_ACCESS	1		/* Error opening configuration file */
#define CFG_ERROR_CORRUPT	2		/* Configuration file is corrupt */
#define CFG_ERROR_LINES		3		/* Lines is too long (increase CFG_LINE_LENGTH) */

/*
 * Configuration file line length
 */

#define CFG_LINE_LENGTH		255

#endif
