
/*
 * describe.h -- written for Juice
 *  Copyright (C) 1999, 2000, 2001 Abraham vd Merwe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef MPG123_DESCRIBE_H
#define MPG123_DESCRIBE_H

#include "typedefs.h"							 /* bool */

/* Change if you want to allow for longer fields in the song structure */
#define FIELDLEN 50
#define FIELDLENSTR "50"

/* Song structure */
typedef struct
{
   char title[FIELDLEN + 1];
   char artist[FIELDLEN + 1];
   char album[FIELDLEN + 1];
} song_t;

/*
 * Extract information from a 4dos-like descript.ion file
 * in the directory in which filename resides, if possible.
 * A normal 4dos description file will pass, but it is
 * recommended that you put a header at the top of the
 * form <artist> <delim> <album> where <delim> can be either
 * a ':' or a '-'. If there is no artist (or multiple ones),
 * just put the album name in the header. In the case of
 * multiple artists, it can be included with each song.
 * If describe() returns TRUE, the song info was extracted
 * succesfully and put in song, FALSE if not successful.
 *
 * UPDATE:
 *   All TAB's found in the descript.ion file will be converted
 *   to spaces when read. Therefore, don't use TABs in
 *   descript.ion's
 */
bool describe (song_t *song,const char *filename);

#endif
