import gtk
import sys
sys.path.append('../')

import GooCalendar
import datetime

def on_event_clicked(calendar, event, event_store):
    print "Event %s was clicked" % event.caption
    event_store.remove(event)


def on_day_selected(calendar, day):
    print "Day %s was clicked" % day
    calendar.set_zoom(calendar.ZOOM_WEEK)

window      = gtk.Window()
event_store = GooCalendar.EventStore()
calendar    = GooCalendar.Calendar(event_store)

event_store.add(GooCalendar.Event("Bake",
                                  datetime.datetime(2007,10,16,17,0,0),
                                  datetime.datetime(2007,10,16,18,0,0)))

event_store.add(GooCalendar.Event("Ethiopian Feast Night",
                                  datetime.datetime(2007,10,16,19,30,0),
                                  datetime.datetime(2007,10,16,22,30,0)))

#calendar.select_from_tuple((2007, 10, 8))
#calendar.select_next_page()
#calendar.select_previous_page()
window.add(calendar)
window.set_size_request(400, 400)
window.show_all()

window.connect('delete-event', gtk.main_quit)
calendar.connect('event-clicked', on_event_clicked, event_store)
calendar.connect('day-selected',  on_day_selected)
gtk.main()
