/* sync-Contacts.c
 *
 * This is a J-Pilot Plugin which supports the Pocket Journal palm application
 *
 * Copyright (C) 2006 by Nick Piper. Based on code by Judd Montgomery.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>

#include "libplugin.h"

#include <pi-dlp.h>

#define PLUGIN_NAME "sync-LCMGDB"
#define DBNAME      "LCMGDB"

/*
 * This is a mandatory plugin function.
 */
void plugin_version(int *major_version, int *minor_version) {
  /* Not -our- version */
   *major_version=0;
   *minor_version=99;
}

/*
 * This is a mandatory plugin function.
 */
int plugin_get_name(char *name, int len) {
  snprintf(name, len, "%s %d.%d%s", PLUGIN_NAME, 
	   JPPY_MAJOR_VERSION,
	   JPPY_MINOR_VERSION,
	   JPPY_EXTRA_VERSION);
  return 0;
}

/*
 * This is an optional plugin function.
 * This is the name that will show up in the plugins help menu in J-Pilot.
 * If this function is used then plugin_help must be also.
 */
int plugin_get_help_name(char *name, int len) {
  snprintf(name, len, "About %s", PLUGIN_NAME);
  return 0;
}

/*
 * This is an optional plugin function.
 * This is the palm database that will automatically be synced.
 */
int plugin_get_db_name(char *name, int len) {
  strncpy(name, DBNAME, len);
  return 0;
}

int plugin_help(char **text, int *width, int *height) {
   *text = strdup(
		 PLUGIN_NAME 
		 " plugin for J-Pilot was written by\n"
		 "Nick Piper (c) 2006 (based on code by Judd Montgomery)\n"
		 "nick@nickpiper.co.uk\n"
		 "\n"
		 "This plugin syncs the database: "
		 DBNAME
		 );
   *height = 200;
   *width = 300;
   
   return 0;
}
	 
