/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.Attribute;
import au.id.jericho.lib.html.CharacterReference;
import au.id.jericho.lib.html.Element;
import au.id.jericho.lib.html.FormControlOutputStyle;
import au.id.jericho.lib.html.FormControlType;
import au.id.jericho.lib.html.FormFields;
import au.id.jericho.lib.html.OutputDocument;
import au.id.jericho.lib.html.Segment;
import au.id.jericho.lib.html.Source;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public abstract class FormControl
extends Segment {
    FormControlType formControlType;
    String name;
    ElementContainer elementContainer;
    FormControlOutputStyle outputStyle = FormControlOutputStyle.NORMAL;
    private static final String CHECKBOX_NULL_DEFAULT_VALUE = "on";
    private static Comparator COMPARATOR = new PositionComparator();

    static FormControl construct(Element element) {
        String string = element.getStartTag().getName();
        if (string == "input") {
            String string2 = element.getAttributes().getRawValue("type");
            if (string2 == null) {
                return new InputFormControl(element, FormControlType.TEXT);
            }
            FormControlType formControlType = FormControlType.getFromInputElementType(string2.toLowerCase());
            if (formControlType == null) {
                if (element.source.logger.isInfoEnabled()) {
                    element.source.logger.info(element.source.getRowColumnVector(element.begin).appendTo(new StringBuffer(200)).append(": INPUT control with unrecognised type \"").append(string2).append("\" assumed to be type \"text\"").toString());
                }
                formControlType = FormControlType.TEXT;
            }
            if (formControlType == FormControlType.TEXT) {
                return new InputFormControl(element, formControlType);
            }
            if (formControlType == FormControlType.CHECKBOX || formControlType == FormControlType.RADIO) {
                return new RadioCheckboxFormControl(element, formControlType);
            }
            if (formControlType == FormControlType.SUBMIT) {
                return new SubmitFormControl(element, formControlType);
            }
            if (formControlType == FormControlType.IMAGE) {
                return new ImageSubmitFormControl(element);
            }
            if (formControlType == FormControlType.NON_FORM_CONTROL) {
                return null;
            }
            return new InputFormControl(element, formControlType);
        }
        if (string == "select") {
            return new SelectFormControl(element);
        }
        if (string == "textarea") {
            return new TextAreaFormControl(element);
        }
        if (string == "button") {
            return "submit".equalsIgnoreCase(element.getAttributes().getRawValue("type")) ? new SubmitFormControl(element, FormControlType.BUTTON) : null;
        }
        return null;
    }

    private FormControl(Element element, FormControlType formControlType, boolean bl) {
        super(element.source, element.begin, element.end);
        this.elementContainer = new ElementContainer(element, bl);
        this.formControlType = formControlType;
        this.name = element.getAttributes().getValue("name");
        this.verifyName();
    }

    public final FormControlType getFormControlType() {
        return this.formControlType;
    }

    public final String getName() {
        return this.name;
    }

    public final Element getElement() {
        return this.elementContainer.element;
    }

    public Iterator getOptionElementIterator() {
        throw new UnsupportedOperationException("Only SELECT controls contain OPTION elements");
    }

    public FormControlOutputStyle getOutputStyle() {
        return this.outputStyle;
    }

    public void setOutputStyle(FormControlOutputStyle formControlOutputStyle) {
        this.outputStyle = formControlOutputStyle;
    }

    public final Map getAttributesMap() {
        return this.elementContainer.getAttributesMap();
    }

    public final boolean isDisabled() {
        return this.elementContainer.getBooleanAttribute("disabled");
    }

    public final void setDisabled(boolean bl) {
        this.elementContainer.setBooleanAttribute("disabled", bl);
    }

    public boolean isChecked() {
        throw new UnsupportedOperationException("This property is only relevant for CHECKBOX and RADIO controls");
    }

    public String getPredefinedValue() {
        return this.elementContainer.predefinedValue;
    }

    public Collection getPredefinedValues() {
        return this.getPredefinedValue() != null ? Collections.singleton(this.getPredefinedValue()) : Collections.EMPTY_SET;
    }

    public List getValues() {
        ArrayList arrayList = new ArrayList();
        this.addValuesTo(arrayList);
        return arrayList;
    }

    public final void clearValues() {
        this.setValue(null);
    }

    public abstract boolean setValue(CharSequence var1);

    public boolean addValue(CharSequence charSequence) {
        return this.setValue(charSequence);
    }

    abstract void addValuesTo(Collection var1);

    abstract void addToFormFields(FormFields var1);

    abstract void replaceInOutputDocument(OutputDocument var1);

    public String getDebugInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.formControlType).append(" name=\"").append(this.name).append('\"');
        if (this.elementContainer.predefinedValue != null) {
            stringBuffer.append(" PredefinedValue=\"").append(this.elementContainer.predefinedValue).append('\"');
        }
        stringBuffer.append(" - ").append(this.getElement().getDebugInfo());
        return stringBuffer.toString();
    }

    final String getDisplayValueHTML(CharSequence charSequence, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer((charSequence == null ? 0 : charSequence.length() * 2) + 50);
        stringBuffer.append('<').append(FormControlOutputStyle.ConfigDisplayValue.ElementName);
        Iterator iterator = FormControlOutputStyle.ConfigDisplayValue.AttributeNames.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            CharSequence charSequence2 = this.elementContainer.getAttributeValue(string);
            if (charSequence2 == null) continue;
            Attribute.appendHTML(stringBuffer, (CharSequence)string, charSequence2);
        }
        stringBuffer.append('>');
        if (charSequence == null || charSequence.length() == 0) {
            stringBuffer.append(FormControlOutputStyle.ConfigDisplayValue.EmptyHTML);
        } else {
            CharacterReference.appendEncode(stringBuffer, charSequence, bl);
        }
        stringBuffer.append("</").append(FormControlOutputStyle.ConfigDisplayValue.ElementName).append('>');
        return stringBuffer.toString();
    }

    final void replaceAttributesInOutputDocumentIfModified(OutputDocument outputDocument) {
        this.elementContainer.replaceAttributesInOutputDocumentIfModified(outputDocument);
    }

    static List findAll(Segment segment) {
        ArrayList arrayList = new ArrayList();
        FormControl.findAll(segment, arrayList, "input");
        FormControl.findAll(segment, arrayList, "textarea");
        FormControl.findAll(segment, arrayList, "select");
        FormControl.findAll(segment, arrayList, "button");
        Collections.sort(arrayList, COMPARATOR);
        return arrayList;
    }

    private static void findAll(Segment segment, ArrayList arrayList, String string) {
        Iterator iterator = segment.findAllElements(string).iterator();
        while (iterator.hasNext()) {
            FormControl formControl = ((Element)iterator.next()).getFormControl();
            if (formControl == null) continue;
            arrayList.add(formControl);
        }
    }

    private static CharSequence getString(char c, int n) {
        if (n == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private void verifyName() {
        String string;
        if (this.formControlType.isSubmit()) {
            return;
        }
        if (this.name == null) {
            string = "missing";
        } else {
            if (this.name.length() != 0) {
                return;
            }
            string = "blank";
        }
        Source source = this.getElement().source;
        if (source.logger.isInfoEnabled()) {
            source.logger.info(this.getElement().source.getRowColumnVector(this.getElement().begin).appendTo(new StringBuffer(200)).append(": compulsory \"name\" attribute of ").append(this.formControlType).append(" control is ").append(string).toString());
        }
    }

    private static final void addValueTo(Collection collection, CharSequence charSequence) {
        collection.add(charSequence != null ? charSequence : "");
    }

    static final class ElementContainer {
        public final Element element;
        public Map attributesMap = null;
        public String predefinedValue;

        public ElementContainer(Element element, boolean bl) {
            this.element = element;
            this.predefinedValue = bl ? element.getAttributes().getValue("value") : null;
        }

        public Map getAttributesMap() {
            if (this.attributesMap == null) {
                this.attributesMap = this.element.getAttributes().getMap(true);
            }
            return this.attributesMap;
        }

        public boolean setSelected(CharSequence charSequence, String string, boolean bl) {
            if (charSequence != null && this.predefinedValue.equals(((Object)charSequence).toString())) {
                this.setBooleanAttribute(string, true);
                return true;
            }
            if (!bl) {
                this.setBooleanAttribute(string, false);
            }
            return false;
        }

        public CharSequence getAttributeValue(String string) {
            if (this.attributesMap != null) {
                return (CharSequence)this.attributesMap.get(string);
            }
            return this.element.getAttributes().getValue(string);
        }

        public void setAttributeValue(String string, CharSequence charSequence) {
            if (charSequence == null) {
                this.setBooleanAttribute(string, false);
                return;
            }
            if (this.attributesMap != null) {
                this.attributesMap.put(string, charSequence);
                return;
            }
            String string2 = ((Object)charSequence).toString();
            CharSequence charSequence2 = this.getAttributeValue(string);
            if (charSequence2 != null && ((Object)charSequence2).toString().equals(string2)) {
                return;
            }
            this.getAttributesMap().put(string, string2);
        }

        public boolean getBooleanAttribute(String string) {
            if (this.attributesMap != null) {
                return this.attributesMap.containsKey(string);
            }
            return this.element.getAttributes().get(string) != null;
        }

        public void setBooleanAttribute(String string, boolean bl) {
            boolean bl2 = this.getBooleanAttribute(string);
            if (bl == bl2) {
                return;
            }
            if (bl) {
                this.getAttributesMap().put(string, string);
            } else {
                this.getAttributesMap().remove(string);
            }
        }

        public void replaceAttributesInOutputDocumentIfModified(OutputDocument outputDocument) {
            if (this.attributesMap != null) {
                outputDocument.replace(this.element.getAttributes(), this.attributesMap);
            }
        }
    }

    private static final class PositionComparator
    implements Comparator {
        private PositionComparator() {
        }

        public int compare(Object object, Object object2) {
            int n;
            int n2 = ((FormControl)object).getElement().getBegin();
            if (n2 < (n = ((FormControl)object2).getElement().getBegin())) {
                return -1;
            }
            if (n2 > n) {
                return 1;
            }
            return 0;
        }
    }

    static final class SelectFormControl
    extends FormControl {
        public ElementContainer[] optionElementContainers;

        public SelectFormControl(Element element) {
            super(element, element.getAttributes().get("multiple") != null ? FormControlType.SELECT_MULTIPLE : FormControlType.SELECT_SINGLE, false);
            List list = element.findAllElements("option");
            this.optionElementContainers = new ElementContainer[list.size()];
            int n = 0;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ElementContainer elementContainer = new ElementContainer((Element)iterator.next(), true);
                if (elementContainer.predefinedValue == null) {
                    elementContainer.predefinedValue = CharacterReference.decodeCollapseWhiteSpace(elementContainer.element.getContent());
                }
                this.optionElementContainers[n++] = elementContainer;
            }
        }

        public String getPredefinedValue() {
            throw new UnsupportedOperationException("Use getPredefinedValues() method instead on SELECT controls");
        }

        public Collection getPredefinedValues() {
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(this.optionElementContainers.length * 2, 1.0f);
            for (int i = 0; i < this.optionElementContainers.length; ++i) {
                linkedHashSet.add(this.optionElementContainers[i].predefinedValue);
            }
            return linkedHashSet;
        }

        public Iterator getOptionElementIterator() {
            return new OptionElementIterator();
        }

        public boolean setValue(CharSequence charSequence) {
            return this.addValue(charSequence, false);
        }

        public boolean addValue(CharSequence charSequence) {
            return this.addValue(charSequence, this.formControlType == FormControlType.SELECT_MULTIPLE);
        }

        private boolean addValue(CharSequence charSequence, boolean bl) {
            boolean bl2 = false;
            for (int i = 0; i < this.optionElementContainers.length; ++i) {
                if (!this.optionElementContainers[i].setSelected(charSequence, "selected", bl)) continue;
                bl2 = true;
            }
            return bl2;
        }

        void addValuesTo(Collection collection) {
            for (int i = 0; i < this.optionElementContainers.length; ++i) {
                if (!this.optionElementContainers[i].getBooleanAttribute("selected")) continue;
                FormControl.addValueTo(collection, this.optionElementContainers[i].predefinedValue);
            }
        }

        void addToFormFields(FormFields formFields) {
            for (int i = 0; i < this.optionElementContainers.length; ++i) {
                formFields.add(this, this.optionElementContainers[i].predefinedValue);
            }
        }

        void replaceInOutputDocument(OutputDocument outputDocument) {
            if (this.outputStyle == FormControlOutputStyle.REMOVE) {
                outputDocument.remove(this.getElement());
            } else if (this.outputStyle == FormControlOutputStyle.DISPLAY_VALUE) {
                StringBuffer stringBuffer = new StringBuffer(100);
                for (int i = 0; i < this.optionElementContainers.length; ++i) {
                    if (!this.optionElementContainers[i].getBooleanAttribute("selected")) continue;
                    stringBuffer.append(SelectFormControl.getOptionLabel(this.optionElementContainers[i].element));
                    stringBuffer.append(FormControlOutputStyle.ConfigDisplayValue.MultipleValueSeparator);
                }
                if (stringBuffer.length() > 0) {
                    stringBuffer.setLength(stringBuffer.length() - FormControlOutputStyle.ConfigDisplayValue.MultipleValueSeparator.length());
                }
                outputDocument.replace(this.getElement(), this.getDisplayValueHTML(stringBuffer, false));
            } else {
                this.replaceAttributesInOutputDocumentIfModified(outputDocument);
                for (int i = 0; i < this.optionElementContainers.length; ++i) {
                    this.optionElementContainers[i].replaceAttributesInOutputDocumentIfModified(outputDocument);
                }
            }
        }

        private static String getOptionLabel(Element element) {
            String string = element.getAttributeValue("label");
            if (string != null) {
                return string;
            }
            return CharacterReference.decodeCollapseWhiteSpace(element.getContent());
        }

        private final class OptionElementIterator
        implements Iterator {
            private int i = 0;

            private OptionElementIterator() {
            }

            public boolean hasNext() {
                return this.i < SelectFormControl.this.optionElementContainers.length;
            }

            public Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return SelectFormControl.this.optionElementContainers[this.i++].element;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    static final class ImageSubmitFormControl
    extends SubmitFormControl {
        public ImageSubmitFormControl(Element element) {
            super(element, FormControlType.IMAGE);
        }

        void addToFormFields(FormFields formFields) {
            super.addToFormFields(formFields);
            formFields.addName(this, this.name + ".x");
            formFields.addName(this, this.name + ".y");
        }
    }

    static class SubmitFormControl
    extends FormControl {
        public SubmitFormControl(Element element, FormControlType formControlType) {
            super(element, formControlType, true);
        }

        public boolean setValue(CharSequence charSequence) {
            return false;
        }

        void addValuesTo(Collection collection) {
        }

        void addToFormFields(FormFields formFields) {
            if (this.getPredefinedValue() != null) {
                formFields.add(this);
            }
        }

        void replaceInOutputDocument(OutputDocument outputDocument) {
            if (this.outputStyle == FormControlOutputStyle.REMOVE) {
                outputDocument.remove(this.getElement());
            } else {
                if (this.outputStyle == FormControlOutputStyle.DISPLAY_VALUE) {
                    this.setDisabled(true);
                }
                this.replaceAttributesInOutputDocumentIfModified(outputDocument);
            }
        }
    }

    static final class RadioCheckboxFormControl
    extends FormControl {
        public RadioCheckboxFormControl(Element element, FormControlType formControlType) {
            super(element, formControlType, true);
            if (this.elementContainer.predefinedValue == null) {
                this.elementContainer.predefinedValue = FormControl.CHECKBOX_NULL_DEFAULT_VALUE;
                if (element.source.logger.isInfoEnabled()) {
                    element.source.logger.info(element.source.getRowColumnVector(element.begin).appendTo(new StringBuffer(200)).append(": compulsory \"value\" attribute of ").append(formControlType).append(" control \"").append(this.name).append("\" is missing, assuming the value \"").append(FormControl.CHECKBOX_NULL_DEFAULT_VALUE).append('\"').toString());
                }
            }
        }

        public boolean setValue(CharSequence charSequence) {
            return this.elementContainer.setSelected(charSequence, "checked", false);
        }

        public boolean addValue(CharSequence charSequence) {
            return this.elementContainer.setSelected(charSequence, "checked", this.formControlType == FormControlType.CHECKBOX);
        }

        void addValuesTo(Collection collection) {
            if (this.isChecked()) {
                FormControl.addValueTo(collection, this.getPredefinedValue());
            }
        }

        public boolean isChecked() {
            return this.elementContainer.getBooleanAttribute("checked");
        }

        void addToFormFields(FormFields formFields) {
            formFields.add(this);
        }

        void replaceInOutputDocument(OutputDocument outputDocument) {
            if (this.outputStyle == FormControlOutputStyle.REMOVE) {
                outputDocument.remove(this.getElement());
            } else {
                if (this.outputStyle == FormControlOutputStyle.DISPLAY_VALUE) {
                    String string;
                    String string2 = string = this.isChecked() ? FormControlOutputStyle.ConfigDisplayValue.CheckedHTML : FormControlOutputStyle.ConfigDisplayValue.UncheckedHTML;
                    if (string != null) {
                        outputDocument.replace(this.getElement(), string);
                        return;
                    }
                    this.setDisabled(true);
                }
                this.replaceAttributesInOutputDocumentIfModified(outputDocument);
            }
        }
    }

    static final class TextAreaFormControl
    extends FormControl {
        public CharSequence value = UNCHANGED;
        private static final String UNCHANGED = new String();

        public TextAreaFormControl(Element element) {
            super(element, FormControlType.TEXTAREA, false);
        }

        public boolean setValue(CharSequence charSequence) {
            this.value = charSequence;
            return true;
        }

        void addValuesTo(Collection collection) {
            FormControl.addValueTo(collection, this.getValue());
        }

        void addToFormFields(FormFields formFields) {
            formFields.add(this);
        }

        void replaceInOutputDocument(OutputDocument outputDocument) {
            if (this.outputStyle == FormControlOutputStyle.REMOVE) {
                outputDocument.remove(this.getElement());
            } else if (this.outputStyle == FormControlOutputStyle.DISPLAY_VALUE) {
                outputDocument.replace(this.getElement(), this.getDisplayValueHTML(this.getValue(), true));
            } else {
                this.replaceAttributesInOutputDocumentIfModified(outputDocument);
                if (this.value != UNCHANGED) {
                    outputDocument.replace(this.getElement().getContent(), CharacterReference.encode(this.value));
                }
            }
        }

        private CharSequence getValue() {
            return this.value == UNCHANGED ? CharacterReference.decode(this.getElement().getContent()) : this.value;
        }
    }

    static final class InputFormControl
    extends FormControl {
        public InputFormControl(Element element, FormControlType formControlType) {
            super(element, formControlType, false);
        }

        public boolean setValue(CharSequence charSequence) {
            this.elementContainer.setAttributeValue("value", charSequence);
            return true;
        }

        void addValuesTo(Collection collection) {
            FormControl.addValueTo(collection, this.elementContainer.getAttributeValue("value"));
        }

        void addToFormFields(FormFields formFields) {
            formFields.add(this);
        }

        void replaceInOutputDocument(OutputDocument outputDocument) {
            if (this.outputStyle == FormControlOutputStyle.REMOVE) {
                outputDocument.remove(this.getElement());
            } else if (this.outputStyle == FormControlOutputStyle.DISPLAY_VALUE) {
                String string = null;
                if (this.formControlType != FormControlType.HIDDEN) {
                    CharSequence charSequence = this.elementContainer.getAttributeValue("value");
                    if (this.formControlType == FormControlType.PASSWORD && charSequence != null) {
                        charSequence = FormControl.getString(FormControlOutputStyle.ConfigDisplayValue.PasswordChar, charSequence.length());
                    }
                    string = this.getDisplayValueHTML(charSequence, false);
                }
                outputDocument.replace(this.getElement(), string);
            } else {
                this.replaceAttributesInOutputDocumentIfModified(outputDocument);
            }
        }
    }
}

