%  backups.sl			-*- SLang -*-
%
%  This file provides numbered backups whenever a file is saved,
%  in a fashion similar to Emacs. For Jed 0.99.* upwards.
%  Written by Guido Gonzato  <guido@ibogeo.df.unibo.it>
%  Last updated: 18 May 1999
%
%  Usage:
%  Let's suppose that you edit a new file, foo.bar. If you save it, the
%  numbered backup copy foo.bar.~1~ will be created; saving again will
%  create foo.bar.~2~, and so on. The standard backup copy is unaffected.
%  Win32 users need to set the variable LFN=y to use backups.
%
%  To enable numbered backups, put this line in your .jedrc:
%  backups_on ();

static variable DO_BACKUPS = 1;

static define numbered_backups (buf, mode)
{
   variable status, version;
   variable file;

   if (0 == DO_BACKUPS)
     return;

   % check whether an old copy or backup files exist

   version = 0;
   do {
      version++;
      file = sprintf ("%s.~%d~", buf, version);
   }
   while (1 == file_status (file));

   % mark the whole buffer and write it to file - don't use write_buffer ()

   push_spot ();
   mark_buffer ();
   () = write_region_to_file (sprintf ("%s.~%d~", buf, version));
   pop_spot();
}
%
define backups_off ()
{
  DO_BACKUPS = 0;
  flush ("Numbered backups disabled.");
}
%

define backups_on ()
{
  DO_BACKUPS = 1;
  flush ("Numbered backups enabled.");
}
%

hook_add_hook ("save_buffer_hook", &numbered_backups);

%
% --- End of file backups.sl ---
