/*
 *   Jackbeat - JACK sequencer
 *    
 *   Copyright (c) 2004-2008 Olivier Guilyardi <olivier {at} samalyse {dot} com>
 *    
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   SVN:$Id: msg.c 121 2008-01-10 00:17:40Z olivier $
 */

#include <stdlib.h>
#include <unistd.h>
#include <jack/ringbuffer.h>

#include "msg.h"

struct msg_t 
{
  jack_ringbuffer_t  *rb_msg, *rb_ack;
  int synced;
  int item_size;
};

msg_t *
msg_new (int buffer_size, int item_size)
{
  msg_t *msg = malloc(sizeof(msg_t));
  msg->rb_msg = jack_ringbuffer_create(buffer_size);
  msg->rb_ack = jack_ringbuffer_create(buffer_size);
  msg->synced = 1;
  msg->item_size = item_size;
  return msg;
}

void
msg_destroy (msg_t *msg)
{
  jack_ringbuffer_free (msg->rb_msg);
  jack_ringbuffer_free (msg->rb_ack);
}

void
msg_send (msg_t *msg, void *data, int flags)
{
  while (jack_ringbuffer_write_space(msg->rb_msg) < msg->item_size + sizeof(int))
    usleep(2000);

  jack_ringbuffer_write (msg->rb_msg, (char *) &flags, sizeof(int));
  jack_ringbuffer_write (msg->rb_msg, (char *) data, msg->item_size);

  if (flags & MSG_ACK) 
  {
    char ack;
    while (!jack_ringbuffer_read (msg->rb_ack, &ack, 1)) 
      usleep (2000);
  }
}

void
msg_sync(msg_t *msg)
{
  if (!msg->synced) 
  {
    char ack = 1;
    msg->synced = jack_ringbuffer_write (msg->rb_ack, &ack, 1) ? 1 : 0;
  }
}

int
msg_receive (msg_t *msg, void *data)
{
  if (msg->synced) 
  {
    int flags;
    if (jack_ringbuffer_read_space(msg->rb_msg) >= msg->item_size + sizeof(int)) 
    {
      jack_ringbuffer_read (msg->rb_msg, (char *) &flags, sizeof(int));
      jack_ringbuffer_read (msg->rb_msg, (char *) data, msg->item_size);

      if (flags & MSG_ACK) 
      {
        msg->synced = 0;
        //msg_sync(msg);
      }
      return 1;
    }
  }
  return 0;
}
