#ifndef _SEND_OSC_C
#define _SEND_OSC_C

#define COMMON_SETUP(n)				\
  char packet[256] ;				\
  osc_data_t o[n] ;				\
  o[0].t = ntp ;				\
  o[1].d = utc ;				\
  o[2].h = frm ;

#define COMMON_SEND(addr,dsc,incl)						\
  int packet_sz = osc_construct_message ( addr , dsc , o , packet , 256 ) ;	\
  sendto_client_register ( d->fd , d->cr , packet , packet_sz , incl ) ; 

void
send_jck_dc ( jackclock_t *d , uint64_t ntp , double utc , int64_t frm , int64_t ntp_dif , double utc_dif )
{
  COMMON_SETUP ( 5 ) ;
  o[3].h = ntp_dif ;
  o[4].d = utc_dif ;
  COMMON_SEND ( "/jck_dc" , ",tdhhd" , REQUEST_JCK_DC ) ;
}

void
send_jck_mc ( jackclock_t *d , uint64_t ntp , double utc , int64_t frm , double ppc , double pt )
{
  COMMON_SETUP ( 5 ) ;
  o[3].d = ppc ;
  o[4].d = pt ;
  COMMON_SEND ( "/jck_mc" , ",tdhdd" , REQUEST_JCK_MC ) ;
}

void
send_jck_tc ( jackclock_t *d , uint64_t ntp , double utc , int64_t frm , double ppm )
{
  COMMON_SETUP ( 4 ) ;
  o[3].d = ppm ;
  COMMON_SEND ( "/jck_tc" , ",tdhd" , REQUEST_JCK_TC ) ;
}

void
send_jck_rc ( jackclock_t *d , uint64_t ntp , double utc , int64_t frm , int32_t rolling )
{
  COMMON_SETUP ( 4 ) ;
  o[3].i = rolling ;
  COMMON_SEND ( "/jck_rc" , ",tdhi" , REQUEST_JCK_RC ) ;
}

void
send_jck_fc ( jackclock_t *d , uint64_t ntp , double utc , int64_t frm , double fps )
{
  COMMON_SETUP ( 4 ) ;
  o[3].d = fps ;
  COMMON_SEND ( "/jck_fc" , ",tdhd" , REQUEST_JCK_FC ) ;
}

void
send_jck_tk ( jackclock_t *d , uint64_t ntp , double utc , int64_t frm , int64_t frame , double pulse )
{
  COMMON_SETUP ( 5 ) ;
  o[3].h = frame ;
  o[4].d = pulse ;
  COMMON_SEND ( "/jck_st" , ",tdhhd" , REQUEST_JCK_TK ) ;
}

void
send_jck_tk_to ( int fd , struct sockaddr_in address , uint64_t ntp , double utc , int64_t frm , int64_t frame , double pulse )
{
  COMMON_SETUP ( 5 ) ;
  o[3].h = frame ;
  o[4].d = pulse ;
  int packet_sz = osc_construct_message ( "/jck_tk" , ",tdhhd" , o , packet , 256 ) ;
  if ( packet_sz ) {
    sendto_exactly ( fd , packet , packet_sz , address ) ;
  }
}

void
send_jck_pl ( jackclock_t *d , uint64_t ntp , double utc , int64_t frm , 
	      uint64_t p_ntp , double p_utc , int64_t p_frm , int32_t pulse )
{
  COMMON_SETUP ( 7 ) ;
  o[3].t = p_ntp ;
  o[4].d = p_utc ;
  o[5].h = p_frm ;
  o[6].i = pulse ;
  COMMON_SEND ( "/jck_pl" , ",tdhtdhi" , REQUEST_JCK_PL ) ;
}

void
send_jck_st ( int fd , struct sockaddr_in address , double fps , double ppm , double ppc , double pt , int32_t rolling )
{
  char packet[256] ;
  osc_data_t o[5] ;
  o[0].d = fps ;
  o[1].d = ppm ;
  o[2].d = ppc ;
  o[3].d = pt ;
  o[4].i = rolling ;
  int packet_sz = osc_construct_message ( "/jck_st" , ",ddddi" , o , packet , 256 ) ;
  if ( packet_sz ) {
    sendto_exactly ( fd , packet , packet_sz , address ) ;
  }
}

#endif
