/*
 * text_input_dialog.cpp - implementation of dialog for editing strings
 *
 * iTALC
 * Copyright (c) 2004-2005 Tobias Doerffel <tobias@doerffel.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program (see COPYING); if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */


#include <qlabel.h>
#include <qlineedit.h>

#include "text_input_dialog.h"

#include "text_input_dialog.moc"


textInputDialog::textInputDialog( const QString & _txt, QString & _r_string, QWidget * _parent ):
	QDialog( _parent ),
	m_stringToEdit( _r_string )
{
	setCaption( tr( "Input..." ) );

	m_txtLbl = new QLabel( _txt, this );
	m_txtLbl->setAlignment( m_txtLbl->alignment()|WordBreak );
	m_txtLbl->move( 5, 5 );
	m_txtLbl->setFixedSize( 500, 110 );
	m_txtLbl->adjustSize();

	m_stringLineEdit = new QLineEdit( this );
	m_stringLineEdit->setText( _r_string );
	m_stringLineEdit->setGeometry( 5, m_txtLbl->y()+m_txtLbl->height()+5, 500, 24 );
	connect( m_stringLineEdit, SIGNAL( textChanged( const QString & ) ), this, SLOT( textChanged( const QString & ) ) );
	connect( m_stringLineEdit, SIGNAL( returnPressed( void )), this, SLOT( accept( void ) ) );

	resize( 510, m_stringLineEdit->y()+m_stringLineEdit->height()+5 );
}




textInputDialog::~textInputDialog()
{
}




void textInputDialog::resizeEvent( QResizeEvent * )
{
	m_txtLbl->setFixedWidth( width()-10 );
	m_txtLbl->adjustSize();
	m_stringLineEdit->setGeometry( 5, m_txtLbl->y()+m_txtLbl->height()+5, width()-10, 24 );
}




void textInputDialog::textChanged( const QString & _new_string )
{
	m_stringToEdit = _new_string;
}




void textInputDialog::keyPressEvent( QKeyEvent * _ke )
{
	if( _ke->key() == Qt::Key_Escape )
	{
		m_stringToEdit = "";
		accept();
	}
}

