#ifndef __MODES_H
#define __MODES_H

/*

Defines signals:

invitelist_add():
 "invitelist added", channel_rec, mask

invitelist_remove():
 "invitelist removed", channel_rec, mask

parse_user_mode():
 "nick mode change", channel_rec, oldnick_rec, newnick_rec
 "channel mode change", channel_rec

parse_user_mode():
 "user mode change", server_rec, mode

*/

void modes_init(void);
void modes_deinit(void);

gboolean modes_set(gchar *data, gchar *mode, SERVER_REC *server, CHANNEL_REC *curchan);
void modes_parse_channel(CHANNEL_REC *channel, gchar *setby, gchar *modestr);

void invitelist_add(CHANNEL_REC *channel, gchar *mask);
void invitelist_remove(CHANNEL_REC *channel, gchar *mask);

#endif
