/*
 setup-misc.c : irssi

    Copyright (C) 1999 Timo Sirainen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "irssi.h"
#include "setup-int.h"
#include "dialog-irssibot.h"

static gboolean sig_setup_apply(void)
{
    setup_write("misc", misc_options);
    return TRUE;
}

static GtkWidget *create_spin(GtkWidget *box, GtkAdjustment *adj, gchar *prefix, gchar *suffix, SETUP_REC *option)
{
    GtkWidget *hbox, *label, *spin;

    hbox = gtk_hbox_new(FALSE, 5);
    gtk_box_pack_start(GTK_BOX(box), hbox, FALSE, FALSE, 0);

    label = gtk_label_new(prefix);
    gtk_misc_set_alignment(GTK_MISC(label), 0, .5);
    gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);

    spin = gtk_spin_button_new(adj, 0, 0);
    option->widget = spin;
    gtk_widget_set_usize(spin, 60, -1);
    gtk_box_pack_start(GTK_BOX(hbox), spin, FALSE, FALSE, 0);

    label = gtk_label_new(suffix);
    gtk_misc_set_alignment(GTK_MISC(label), 0, .5);
    gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);

    return spin;
}

static gboolean setup_misc(GtkWidget *dialog)
{
    GtkWidget *mainvbox, *vbox, *frame, *table;
    GtkWidget *label, *spin, *entry, *button;
    GtkAdjustment *adj;

    g_return_val_if_fail(dialog != NULL, FALSE);

    mainvbox = gtk_vbox_new(FALSE, 7);
    gtk_container_border_width(GTK_CONTAINER(mainvbox), 7);

    /* --- */
    frame = gtk_frame_new(_("Programs"));
    gtk_box_pack_start(GTK_BOX(mainvbox), frame, FALSE, FALSE, 0);

    table = gtk_table_new(3, 2, FALSE);
    gtk_table_set_col_spacing(GTK_TABLE(table), 0, 5);
    gtk_container_border_width(GTK_CONTAINER(table), 5);
    gtk_container_add(GTK_CONTAINER(frame), table);

    entry = gui_create_tablelabelentry(table, 0, 0, _("Web browser"),
                                       *((gchar **) misc_options[OPTION_WWW_CLIENT].data));
    misc_options[OPTION_WWW_CLIENT].widget = entry;
    entry = gui_create_tablelabelentry(table, 0, 1, _("FTP client"),
                                       *((gchar **) misc_options[OPTION_FTP_CLIENT].data));
    misc_options[OPTION_FTP_CLIENT].widget = entry;
    entry = gui_create_tablelabelentry(table, 0, 2, _("E-Mail client"),
                                       *((gchar **) misc_options[OPTION_MAIL_CLIENT].data));
    misc_options[OPTION_MAIL_CLIENT].widget = entry;

    /* --- */
    frame = gtk_frame_new(_("Lag checking"));
    gtk_box_pack_start(GTK_BOX(mainvbox), frame, FALSE, FALSE, 0);

    table = gtk_table_new(3, 2, FALSE);
    gtk_container_border_width(GTK_CONTAINER(table), 5);
    gtk_container_add(GTK_CONTAINER(frame), table);

    label = gtk_label_new(_("How often to check for lag (secs)"));
    gtk_misc_set_alignment(GTK_MISC(label), 1, .5);
    gtk_table_attach(GTK_TABLE(table), label, 0, 1, 0, 1, GTK_FILL, 0, 5, 0);

    adj = (GtkAdjustment *) gtk_adjustment_new (*((gint *) misc_options[OPTION_MIN_LAG_CHECK_TIME].data),
                                                0, G_MAXINT, 1, 10, 0);
    spin = gtk_spin_button_new(adj, 0, 0);
    misc_options[OPTION_MIN_LAG_CHECK_TIME].widget = spin;
    gtk_widget_set_usize(spin, 60, -1);
    gtk_table_attach(GTK_TABLE(table), spin, 1, 2, 0, 1, GTK_FILL, 0, 5, 0);

    label = gtk_label_new(_("Maximum lag before force disconnect (secs)"));
    gtk_misc_set_alignment(GTK_MISC(label), 1, .5);
    gtk_table_attach(GTK_TABLE(table), label, 0, 1, 1, 2, GTK_FILL, 0, 5, 0);

    adj = (GtkAdjustment *) gtk_adjustment_new (*((gint *) misc_options[OPTION_MAX_LAG_BEFORE_DISCONNECT].data),
                                                0, G_MAXINT, 1, 10, 0);
    spin = gtk_spin_button_new(adj, 0, 0);
    misc_options[OPTION_MAX_LAG_BEFORE_DISCONNECT].widget = spin;
    gtk_widget_set_usize(spin, 60, -1);
    gtk_table_attach(GTK_TABLE(table), spin, 1, 2, 1, 2, GTK_FILL, 0, 5, 0);

    /* --- */
    frame = gtk_frame_new(_("Misc"));
    gtk_box_pack_start(GTK_BOX(mainvbox), frame, FALSE, FALSE, 0);

    table = gtk_table_new(3, 2, FALSE);
    gtk_table_set_col_spacing(GTK_TABLE(table), 0, 5);
    gtk_container_border_width(GTK_CONTAINER(table), 5);
    gtk_container_add(GTK_CONTAINER(frame), table);

    entry = gui_create_tablelabelentry(table, 0, 0, _("Default quit message"),
                                       *((gchar **) misc_options[OPTION_DEFAULT_QUIT_MESSAGE].data));
    gtk_signal_connect(GTK_OBJECT(entry), "key_press_event",
		       GTK_SIGNAL_FUNC(setup_sig_keypress), NULL);
    misc_options[OPTION_DEFAULT_QUIT_MESSAGE].widget = entry;
    entry = gui_create_tablelabelentry(table, 0, 1, _("Default user mode"),
                                       *((gchar **) misc_options[OPTION_DEFAULT_USER_MODE].data));
    misc_options[OPTION_DEFAULT_USER_MODE].widget = entry;
    entry = gui_create_tablelabelentry(table, 0, 2, _("CTCP VERSION reply"),
				       *((gchar **) misc_options[OPTION_CTCP_VERSION_REPLY].data));
    misc_options[OPTION_CTCP_VERSION_REPLY].widget = entry;
    entry = gui_create_tablelabelentry(table, 0, 3, _("Translation table file (ircII style)"),
				       *((gchar **) misc_options[OPTION_TRANSLATION].data));
    misc_options[OPTION_TRANSLATION].widget = entry;
    entry = gui_create_tablelabelentry(table, 0, 4, _("Awaylog file name"),
				       *((gchar **) misc_options[OPTION_AWAYLOG_FILE].data));
    misc_options[OPTION_AWAYLOG_FILE].widget = entry;
    entry = gui_create_tablelabelentry(table, 0, 5, _("Awaylog logging level"),
				       *((gchar **) misc_options[OPTION_AWAYLOG_LEVEL].data));
    misc_options[OPTION_AWAYLOG_LEVEL].widget = entry;

    vbox = gtk_vbox_new(FALSE, 2);
    gtk_table_attach_defaults(GTK_TABLE(table), vbox, 0, 2, 6, 7);

    gtk_box_pack_start(GTK_BOX(vbox), gtk_hseparator_new(), FALSE, FALSE, 5);

    adj = (GtkAdjustment *) gtk_adjustment_new (*((gint *) misc_options[OPTION_KNOCKOUT_TIME].data),
                                                0, G_MAXINT, 1, 60, 0);
    spin = create_spin(vbox, adj, _("Knockout bans for"), _("seconds (requires ops)"), &misc_options[OPTION_KNOCKOUT_TIME]);
    
    adj = (GtkAdjustment *) gtk_adjustment_new (*((gint *) misc_options[OPTION_TIMESTAMP_TIMEOUT].data),
						0, G_MAXINT, 1, 60, 0);
    spin = create_spin(vbox, adj, _("Show timestamps after"), _("seconds idle time"), &misc_options[OPTION_TIMESTAMP_TIMEOUT]);

    button = gtk_button_new_with_label(_("Automatically checking new Irssi versions..."));
    gtk_signal_connect(GTK_OBJECT(button), "clicked",
                       GTK_SIGNAL_FUNC(dialog_irssibot_config), NULL);
    gtk_box_pack_start(GTK_BOX(vbox), button, FALSE, FALSE, 0);

    setup_finish_init(dialog, misc_options);

    gnome_property_box_append_page(GNOME_PROPERTY_BOX(dialog),
                                   mainvbox, gtk_label_new(_("Misc")));
    return TRUE;
}

void init_misc(void)
{
    signal_add("setup preferences apply", (SIGNAL_FUNC) sig_setup_apply);
    signal_add("setup preferences", (SIGNAL_FUNC) setup_misc);
}

void deinit_misc(void)
{
    signal_remove("setup preferences apply", (SIGNAL_FUNC) sig_setup_apply);
    signal_remove("setup preferences", (SIGNAL_FUNC) setup_misc);
}

